/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ToolListener;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class UndoableTool
implements Tool,
ToolListener {
    private Tool myWrappedTool;
    private AbstractTool.EventDispatcher myEventDispatcher;

    public UndoableTool(Tool tool) {
        this.setEventDispatcher(this.createEventDispatcher());
        this.setWrappedTool(tool);
        this.getWrappedTool().addToolListener(this);
    }

    public void activate() {
        this.getWrappedTool().activate();
    }

    public void deactivate() {
        this.getWrappedTool().deactivate();
        Undoable undoable = this.getWrappedTool().getUndoActivity();
        if (undoable != null && undoable.isUndoable()) {
            this.editor().getUndoManager().pushUndo(undoable);
            this.editor().getUndoManager().clearRedos();
            this.editor().figureSelectionChanged(this.getActiveView());
        }
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.getWrappedTool().mouseDown(mouseEvent, n, n2);
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        this.getWrappedTool().mouseDrag(mouseEvent, n, n2);
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        this.getWrappedTool().mouseUp(mouseEvent, n, n2);
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
        this.getWrappedTool().mouseMove(mouseEvent, n, n2);
    }

    public void keyDown(KeyEvent keyEvent, int n) {
        this.getWrappedTool().keyDown(keyEvent, n);
    }

    public boolean isUsable() {
        return this.getWrappedTool().isUsable();
    }

    public boolean isActive() {
        return this.editor().tool() == this;
    }

    public boolean isEnabled() {
        return this.getWrappedTool().isEnabled();
    }

    public void setUsable(boolean bl) {
        this.getWrappedTool().setUsable(bl);
    }

    public void setEnabled(boolean bl) {
        this.getWrappedTool().setEnabled(bl);
    }

    protected void setWrappedTool(Tool tool) {
        this.myWrappedTool = tool;
    }

    protected Tool getWrappedTool() {
        return this.myWrappedTool;
    }

    public DrawingEditor editor() {
        return this.getWrappedTool().editor();
    }

    public DrawingView view() {
        return this.editor().view();
    }

    public Undoable getUndoActivity() {
        return new UndoableAdapter(this.view());
    }

    public void setUndoActivity(Undoable undoable) {
    }

    public void toolUsable(EventObject eventObject) {
        this.getEventDispatcher().fireToolUsableEvent();
    }

    public void toolUnusable(EventObject eventObject) {
        this.getEventDispatcher().fireToolUnusableEvent();
    }

    public void toolActivated(EventObject eventObject) {
        this.getEventDispatcher().fireToolActivatedEvent();
    }

    public void toolDeactivated(EventObject eventObject) {
        this.getEventDispatcher().fireToolDeactivatedEvent();
    }

    public void toolEnabled(EventObject eventObject) {
        this.getEventDispatcher().fireToolEnabledEvent();
    }

    public void toolDisabled(EventObject eventObject) {
        this.getEventDispatcher().fireToolDisabledEvent();
    }

    public void addToolListener(ToolListener toolListener) {
        this.getEventDispatcher().addToolListener(toolListener);
    }

    public void removeToolListener(ToolListener toolListener) {
        this.getEventDispatcher().removeToolListener(toolListener);
    }

    private void setEventDispatcher(AbstractTool.EventDispatcher eventDispatcher) {
        this.myEventDispatcher = eventDispatcher;
    }

    protected AbstractTool.EventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    public AbstractTool.EventDispatcher createEventDispatcher() {
        return new AbstractTool.EventDispatcher(this);
    }

    public DrawingView getActiveView() {
        return this.editor().view();
    }
}

