/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef EBOOKBITSTREAM_H_INCLUDED
#define EBOOKBITSTREAM_H_INCLUDED

#include "libebook_utils.h"

class WPXInputStream;

namespace libebook
{

class EBOOKBitStream
{
public:
  explicit EBOOKBitStream(WPXInputStream *stream);

  uint32_t read(uint8_t numberOfBits, bool bigEndian = false);

  bool atEOS() const;
  bool atLastByte() const;

private:
  void fill();

  /** Reads a byte from the stream.
    *
    * @return a byte
    */
  uint8_t readByte();

  /** Reads a given amount of bits from the stream.
    *
    * @arg[in] numberOfBits the number of bits to read. Has to be less
    * than or equal to 8.
    *
    * @return a byte containing the bits
    */
  uint8_t readBits(uint8_t numberOfBits);

  uint8_t readAvailableBits(uint8_t numberOfBits);

private:
  static const uint8_t s_masks[8];

private:
  WPXInputStream *const m_stream;
  uint8_t m_current;
  uint8_t m_available;
};

}

#endif // EBOOKBITSTREAM_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
