# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -iterations=3 -timeline -register-file-stats < %s | FileCheck %s

xor %eax, %eax
mov %eax, %ebx
mov %ebx, %ecx
mov %ecx, %edx
mov %edx, %eax

# CHECK:      Iterations:        3
# CHECK-NEXT: Instructions:      15
# CHECK-NEXT: Total Cycles:      15
# CHECK-NEXT: Total uOps:        15

# CHECK:      Dispatch Width:    4
# CHECK-NEXT: uOps Per Cycle:    1.00
# CHECK-NEXT: IPC:               1.00
# CHECK-NEXT: Block RThroughput: 1.3

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      0     0.25                        xorl	%eax, %eax
# CHECK-NEXT:  1      1     0.33                        movl	%eax, %ebx
# CHECK-NEXT:  1      1     0.33                        movl	%ebx, %ecx
# CHECK-NEXT:  1      1     0.33                        movl	%ecx, %edx
# CHECK-NEXT:  1      1     0.33                        movl	%edx, %eax

# CHECK:      Register File statistics:
# CHECK-NEXT: Total number of mappings created:    18
# CHECK-NEXT: Max number of mappings used:         15

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SBDivider
# CHECK-NEXT: [1]   - SBFPDivider
# CHECK-NEXT: [2]   - SBPort0
# CHECK-NEXT: [3]   - SBPort1
# CHECK-NEXT: [4]   - SBPort4
# CHECK-NEXT: [5]   - SBPort5
# CHECK-NEXT: [6.0] - SBPort23
# CHECK-NEXT: [6.1] - SBPort23

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6.0]  [6.1]
# CHECK-NEXT:  -      -     1.33   1.33    -     1.33    -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6.0]  [6.1]  Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -     xorl	%eax, %eax
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     movl	%eax, %ebx
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     movl	%ebx, %ecx
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     movl	%ecx, %edx
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     movl	%edx, %eax

# CHECK:      Timeline view:
# CHECK-NEXT:                     01234
# CHECK-NEXT: Index     0123456789

# CHECK:      [0,0]     DR   .    .   .   xorl	%eax, %eax
# CHECK-NEXT: [0,1]     DeER .    .   .   movl	%eax, %ebx
# CHECK-NEXT: [0,2]     D=eER.    .   .   movl	%ebx, %ecx
# CHECK-NEXT: [0,3]     D==eER    .   .   movl	%ecx, %edx
# CHECK-NEXT: [0,4]     .D==eER   .   .   movl	%edx, %eax
# CHECK-NEXT: [1,0]     .D===ER   .   .   xorl	%eax, %eax
# CHECK-NEXT: [1,1]     .D===eER  .   .   movl	%eax, %ebx
# CHECK-NEXT: [1,2]     .D====eER .   .   movl	%ebx, %ecx
# CHECK-NEXT: [1,3]     . D====eER.   .   movl	%ecx, %edx
# CHECK-NEXT: [1,4]     . D=====eER   .   movl	%edx, %eax
# CHECK-NEXT: [2,0]     . D======ER   .   xorl	%eax, %eax
# CHECK-NEXT: [2,1]     . D======eER  .   movl	%eax, %ebx
# CHECK-NEXT: [2,2]     .  D======eER .   movl	%ebx, %ecx
# CHECK-NEXT: [2,3]     .  D=======eER.   movl	%ecx, %edx
# CHECK-NEXT: [2,4]     .  D========eER   movl	%edx, %eax

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     3     3.7    0.0    0.0       xorl	%eax, %eax
# CHECK-NEXT: 1.     3     4.0    0.3    0.0       movl	%eax, %ebx
# CHECK-NEXT: 2.     3     4.7    0.0    0.0       movl	%ebx, %ecx
# CHECK-NEXT: 3.     3     5.3    0.0    0.0       movl	%ecx, %edx
# CHECK-NEXT: 4.     3     6.0    0.0    0.0       movl	%edx, %eax
