; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -loop-sink -break-crit-edges -branch-prob -S -enable-new-pm=0 | FileCheck %s
; RUN: opt < %s -loop-sink -break-crit-edges -lazy-block-freq -S -enable-new-pm=0 | FileCheck %s
; RUN: opt < %s -loop-sink -break-crit-edges -lazy-branch-prob -S -enable-new-pm=0 | FileCheck %s

; BreakCriticalEdges tries to update LI and DT if they are present. However,
; updating LI actually needs a DT, so we now require DT in
; BranchProbabilityInfo/LazyBlockFrequencyInfo/LazyBranchProbabilityInfo so it
; is indeed available when LI is.

target triple = "x86_64-unknown-linux-gnu"

define void @f1() {
; CHECK-LABEL: @f1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    br i1 false, label [[FOR_BODY:%.*]], label [[FOR_COND_FOR_END_CRIT_EDGE:%.*]]
; CHECK:       for.cond.for.end_crit_edge:
; CHECK-NEXT:    br label [[FOR_END:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    br i1 true, label [[FOR_ENDSPLIT:%.*]], label [[FOR_INC:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       for.endsplit:
; CHECK-NEXT:    br label [[FOR_END]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.cond

for.cond:                                         ; preds = %for.inc, %entry
  br i1 undef, label %for.body, label %for.end

for.body:                                         ; preds = %for.cond
  br i1 undef, label %for.end, label %for.inc

for.inc:                                          ; preds = %for.body
  br label %for.cond

for.end:                                          ; preds = %for.body, %for.cond
  ret void
}
