// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
//

// <Area> Nullable - Lifting - Operators </Area>
// <Title> general lifting of builtin operators on bool </Title>
// <Description>  
// Logical AND	&
// Logical XOR	^
// Logical OR	|
// Equality	==  !=
// Conditional AND	&& 
// Conditional OR	||
// Conditional	?:
// Assignment	=  &=  ^=  |=
// </Description> 
// <RelatedBugs> </RelatedBugs>  

//<Expects Status=success></Expects>

// <Code> 

#pragma warning disable 458, 169
using System;

public class NullableTest
{
    static int counter = 0;

    static bool? qNULL = null;
    static bool? qTRUE = true;
    static bool? qFALSE = false;
    static bool TRUE = true;
    static bool FALSE = false;

    static bool? qMTRUE()
    {
        ++counter;
        return true;
    }
    static bool? qMFALSE()
    {
        ++counter;
        return false;
    }
    static bool? qMNULL()
    {
        ++counter;
        return null;
    }
    static bool? MTRUE()
    {
        ++counter;
        return true;
    }
    static bool? MFALSE()
    {
        ++counter;
        return false;
    }

    static bool? qPTRUE
    {
        get
        {
            ++counter;
            return true;
        }
    }
    static bool? qPFALSE
    {
        get
        {
            ++counter;
            return false;
        }
    }
    static bool? qPNULL
    {
        get
        {
            ++counter;
            return null;
        }
    }
    static bool? PTRUE
    {
        get
        {
            ++counter;
            return true;
        }
    }
    static bool? PFALSE
    {
        get
        {
            ++counter;
            return false;
        }
    }


    static bool? nub;



    // Logical 	& |

    public static void And()
    {
        counter = 0;
        nub = (true) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (true) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (TRUE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (TRUE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (true) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (true) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (TRUE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (TRUE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (true) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true) & (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (true) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (TRUE) & (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (TRUE) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (true) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (TRUE) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (PTRUE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (PTRUE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (PTRUE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (PTRUE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (PTRUE) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (PTRUE) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PTRUE) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = ((bool?)true) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qTRUE) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qTRUE) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qTRUE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qTRUE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qTRUE) & (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qTRUE) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qTRUE) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (false) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (FALSE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (FALSE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (false) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (false) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (FALSE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (FALSE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (false) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (false) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (FALSE) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (FALSE) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (false) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (PFALSE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (PFALSE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (PFALSE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (PFALSE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (PFALSE) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (PFALSE) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = ((bool?)false) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) & (true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) & (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) & ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) & (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) & (null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) & (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) & (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (null) & (true);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) & (TRUE);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) & (true);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) & (TRUE);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) & (true | MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (true | MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (true | PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (true | PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (true | MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (true | MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (true | PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (true | PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & ((bool?)true);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) & (qTRUE);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) & ((bool?)true);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) & (qTRUE);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) & (true | qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (true | qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (true | qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (true | qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (true | qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (true | qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (true | qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (true | qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (true | qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (true | qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (true | qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (true | qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (null) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qNULL) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qNULL) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (null) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (null) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qNULL) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qNULL) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (null) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (null) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (bool?)(null) & (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) & (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (TRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) & (TRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) & (true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) & (TRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) & (true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) & (TRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) & (true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) & (TRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) & (true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) & (TRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) & (true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) & (TRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) & (true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) & (TRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true | MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true | MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true | PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true | PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true | MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true | MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true | PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true | PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (true | MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (true | MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (true | PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (true | PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (true | MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (true | MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (true | PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (true | PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (true | MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (true | MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (true | PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (true | PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (true | MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (true | MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (true | PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (true | PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (true | MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (true | MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (true | PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (true | PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (true | MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (true | MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (true | PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (true | PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & ((bool?)true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (qTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) & ((bool?)true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) & (qTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) & ((bool?)true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) & (qTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) & ((bool?)true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) & (qTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) & ((bool?)true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) & (qTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) & ((bool?)true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) & (qTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) & ((bool?)true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) & (qTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) & ((bool?)true);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) & (qTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true | qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true | qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true | qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true | qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true | qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (true | qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true | qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true | qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true | qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true | qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true | qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (true | qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (true | qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (true | qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (true | qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (true | qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (true | qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (true | qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (true | qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (true | qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (true | qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (true | qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (true | qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (true | qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (true | qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (true | qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (true | qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (true | qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (true | qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (true | qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (true | qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (true | qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (true | qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (true | qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (true | qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (true | qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (true | qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (true | qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (true | qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (true | qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (true | qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (true | qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (true | qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (true | qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (true | qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (true | qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (true | qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (true | qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPNULL) & (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPNULL) & (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPNULL) & ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPNULL) & (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) & (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) & (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) & (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));

        counter = 0;
        nub = (true) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (true) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (TRUE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (TRUE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (true) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (true) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (TRUE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (TRUE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (true) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (true) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (TRUE) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (TRUE) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (true) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (TRUE) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (PTRUE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (PTRUE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (PTRUE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (PTRUE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MFALSE()) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PTRUE) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | PFALSE) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (MTRUE()) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (PTRUE) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (PTRUE) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | MTRUE()) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MTRUE()) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | MFALSE()) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PTRUE) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | PFALSE) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MTRUE()) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PTRUE) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = ((bool?)true) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qTRUE) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)true) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)true) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qTRUE) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMFALSE()) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMNULL()) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPTRUE) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPFALSE) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qPNULL) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMTRUE()) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) | (null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPTRUE) | (qNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMTRUE()) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMFALSE()) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qMNULL()) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPTRUE) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPFALSE) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (true | qPNULL) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMTRUE()) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qMTRUE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qMFALSE() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qMNULL() | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qPTRUE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qPFALSE | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (false & qPNULL | null);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPTRUE) | (qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (false) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (FALSE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (FALSE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (false) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (false) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (FALSE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (FALSE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (false) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false) | (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (false) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (FALSE) | (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (FALSE) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (false) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (FALSE) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (PFALSE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (PFALSE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (PFALSE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (PFALSE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & MFALSE()) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & PTRUE) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & PFALSE) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (MFALSE()) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (PFALSE) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (PFALSE) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & MTRUE()) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MTRUE()) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & MFALSE()) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PTRUE) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & PFALSE) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (MFALSE()) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (PFALSE) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = ((bool?)false) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qFALSE) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qFALSE) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qFALSE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qFALSE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = (qFALSE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qFALSE) | (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qFALSE) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = ((bool?)false) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = ((bool?)false) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qFALSE) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) | (false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) | (FALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) | ((bool?)false);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) | (qFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == false) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE()) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL()) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMFALSE()) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPFALSE) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE()) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE()) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL()) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMFALSE()) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPFALSE) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (null) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (null) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qNULL) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qNULL) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (null) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (null) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qNULL) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (qNULL) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 0));
        counter = 0;
        nub = (null) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (null) | (false);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) | (FALSE);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) | (false);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) | (FALSE);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) | (false & MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | ((bool?)false);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) | (qFALSE);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) | ((bool?)false);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) | (qFALSE);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) | (false & qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (bool?)(null) | (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) | (null);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (qNULL) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 0));
        counter = 0;
        nub = (null) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (null) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qNULL) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPNULL) | (true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPNULL) | (TRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (true | MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (true | MFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (true | PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (true | PFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (MTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (PTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPNULL) | ((bool?)true);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (qPNULL) | (qTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (true | qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (true | qMFALSE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (true | qMNULL());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (true | qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (true | qPFALSE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (true | qPNULL);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (qMTRUE());
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (qPTRUE);
        Test.Eval((nub.HasValue) && (nub.Value == true) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (FALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) | (FALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) | (false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) | (FALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) | (false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) | (FALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) | (false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) | (FALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) | (false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) | (FALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) | (false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) | (FALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) | (false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) | (FALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & MTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & PTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (MFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (PFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | ((bool?)false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (qFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) | ((bool?)false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) | (qFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) | ((bool?)false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) | (qFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) | ((bool?)false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) | (qFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) | ((bool?)false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) | (qFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) | ((bool?)false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) | (qFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) | ((bool?)false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) | (qFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) | ((bool?)false);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) | (qFALSE);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qMTRUE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qPTRUE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (qMFALSE());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (qPFALSE);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMFALSE() | null) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMNULL() | null) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPTRUE | null) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPFALSE | null) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qPNULL | null) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qMNULL()) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) | (null);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (qPNULL) | (qNULL);
        Test.Eval((!nub.HasValue) && (counter == 1));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMTRUE() | null) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMFALSE() | null) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qMNULL() | null) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPTRUE | null) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPFALSE | null) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (false & qPNULL | null) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qMNULL()) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qMTRUE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qMFALSE() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qMNULL() | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qPTRUE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qPFALSE | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (false & qPNULL | null);
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (qMNULL());
        Test.Eval((!nub.HasValue) && (counter == 2));
        counter = 0;
        nub = (qPNULL) | (qPNULL);
        Test.Eval((!nub.HasValue) && (counter == 2));
    }


    public static void Run()
    {
        And();
    }
}

public class Test
{
    public static int counter = 0;
    public static bool result = true;

    public static void Eval(bool expr)
    {
        counter++;
        if (!expr)
        {
            result = false;
            Console.WriteLine("Test Failed at location {0}", counter);
        }

    }

    public static void Eval(object obj1, object obj2)
    {
        counter++;

        if ((!(null == obj1 && null == obj2)) && (null == obj1 || null == obj2 || !obj1.Equals(obj2)))
        {
            result = false;
            Console.WriteLine("Test Failed at location: " + counter);
            Console.WriteLine("While Comparing {0} to {1}", obj1, obj2);
        }

    }

    public static int Main()
    {

        NullableTest.Run();

        if (result)
        {
            Console.WriteLine("Test SUCCESS");
            return 100;
        }
        else
        {
            Console.WriteLine("Test FAILED");
            return 101;
        }
    }

}

// </Code>
