// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;
using System.IO;

// DIRECTIONS:
//    This file isn't very robust and makes several assumptions
//    You can execute it by calling "csi .\GenerateTests.csx"
//
//    csi can be found under the <repo-root>\tools\net46\roslyn directory
//    It must be run such from the directory that contains the csx script
//
//    New tests can be generated from the template by adding an entry to the
//    appropriate Inputs array below.
//
//    You can support a new Isa by creating a new array and adding a new
//    "ProcessInputs" call at the bottom of the script.

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector64Inputs = new []
{
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create",             ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),

    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "Create", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector64_1Inputs = new []
{
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "Zero", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8" }),

    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8" }),

    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64_1", ["Method"] = "As", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),

    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "7", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "0", ["ConsumeValues"] = "values[0]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "3", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "1", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "7", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "1", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "3", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "0", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "1", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "0", ["ConsumeValues"] = "values[0]" }),

    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToScalar", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0]" }),

    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector64", ["Method"] = "ToVector128", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0]" }),

    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Single", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Double", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector64", ["Method"] = "ToString", ["VectorType"] = "Vector64", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "8", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0]" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector128Inputs = new []
{
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create",             ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),

    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "Create", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["OpVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector128_1Inputs = new []
{
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "Zero", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16" }),

    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16" }),

    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "(byte)TestLibrary.Generator.GetByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(double)TestLibrary.Generator.GetDouble()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "(short)TestLibrary.Generator.GetInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "(int)TestLibrary.Generator.GetInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "(long)TestLibrary.Generator.GetInt64()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "(sbyte)TestLibrary.Generator.GetSByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(float)TestLibrary.Generator.GetSingle()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(ushort)TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(uint)TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "As", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(ulong)TestLibrary.Generator.GetUInt64()" }),

    ("VectorAsNumericsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector2", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["NumericsType"] = "Vector2", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorAsNumericsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector3", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["NumericsType"] = "Vector3", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorAsNumericsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector4", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["NumericsType"] = "Vector4", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),

    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(byte)TestLibrary.Generator.GetByte()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(double)TestLibrary.Generator.GetDouble()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(short)TestLibrary.Generator.GetInt16()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(int)TestLibrary.Generator.GetInt32()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(long)TestLibrary.Generator.GetInt64()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(sbyte)TestLibrary.Generator.GetSByte()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(float)TestLibrary.Generator.GetSingle()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(ushort)TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(uint)TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128_1", ["Method"] = "AsVector", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "16", ["NextValueOp"] = "(ulong)TestLibrary.Generator.GetUInt64()" }),

    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToScalar", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorExtendTest.template", new Dictionary<string, string> { ["Isa"] = "Vector128", ["Method"] = "ToVector256", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector256", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),

    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector128", ["Method"] = "ToString", ["VectorType"] = "Vector128", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1]" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector256Inputs = new []
{
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create",             ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != expectedValue" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalar",       ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "resultElements[i] != 0" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),
    ("VectorCreateTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "CreateScalarUnsafe", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "resultElements[0] != expectedValue", ["ValidateRemainingResults"] = "false /* value is uninitialized */" }),

    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorCreateElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()" }),
    ("VectorCreateVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "Create", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["OpVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] Vector256_1Inputs = new []
{
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32" }),
    ("VectorZeroTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "Zero", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32" }),

    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32" }),
    ("VectorAllBitsSetTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AllBitsSet", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32" }),


    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "(byte)TestLibrary.Generator.GetByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(double)TestLibrary.Generator.GetDouble()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "(short)TestLibrary.Generator.GetInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "(int)TestLibrary.Generator.GetInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "(long)TestLibrary.Generator.GetInt64()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "(sbyte)TestLibrary.Generator.GetSByte()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(float)TestLibrary.Generator.GetSingle()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(ushort)TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(uint)TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "As", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(ulong)TestLibrary.Generator.GetUInt64()" }),

    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(byte)TestLibrary.Generator.GetByte()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(double)TestLibrary.Generator.GetDouble()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(short)TestLibrary.Generator.GetInt16()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(int)TestLibrary.Generator.GetInt32()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(long)TestLibrary.Generator.GetInt64()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(sbyte)TestLibrary.Generator.GetSByte()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(float)TestLibrary.Generator.GetSingle()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(ushort)TestLibrary.Generator.GetUInt16()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(uint)TestLibrary.Generator.GetUInt32()" }),
    ("VectorAsNumericsVectorTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256_1", ["Method"] = "AsVector", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["NumericsType"] = "Vector", ["LargestVectorSize"] = "32", ["NextValueOp"] = "(ulong)TestLibrary.Generator.GetUInt64()" }),

    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["Imm"] = "31", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["Imm"] = "31", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["Imm"] = "15", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["Imm"] = "7",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "0",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "1",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithElementTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithElement", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["Imm"] = "3",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorGetAndWithLowerAndUpperTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "GetAndWithLowerAndUpper", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["TgtVectorType"] = "Vector128", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToScalarTest.template", new Dictionary<string, string> { ["Isa"] = "Vector256", ["Method"] = "ToScalar", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),

    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Byte",   ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetByte()",   ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "SByte",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSByte()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15], values[16], values[17], values[18], values[19], values[20], values[21], values[22], values[23], values[24], values[25], values[26], values[27], values[28], values[29], values[30], values[31]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Int16",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt16()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "UInt16", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt16()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Int32",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt32()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "UInt32", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt32()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Single", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetSingle()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Double", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetDouble()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "Int64",  ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetInt64()",  ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
    ("VectorToStringTest.template", new Dictionary<string, string> {["Isa"] = "Vector256", ["Method"] = "ToString", ["VectorType"] = "Vector256", ["BaseType"] = "UInt64", ["LargestVectorSize"] = "32", ["NextValueOp"] = "TestLibrary.Generator.GetUInt64()", ["ConsumeValues"] = "values[0], values[1], values[2], values[3]" }),
};

private static readonly (string templateFileName, Dictionary<string, string> templateData)[] NotSupportedInputs = new []
{
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanZero",                    ["TargetType"] = "Vector64<bool>",    ["Source"] = "Vector64<bool>",             ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAllBitsSet",              ["TargetType"] = "Vector64<bool>",    ["Source"] = "Vector64<bool>",             ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Boolean",       ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64ByteAsGeneric_Boolean",          ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<byte>)",    ["Method"] = "As<byte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64DoubleAsGeneric_Boolean",        ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<double>)",  ["Method"] = "As<double, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int16AsGeneric_Boolean",         ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<short>)",   ["Method"] = "As<short, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int32AsGeneric_Boolean",         ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<int>)",     ["Method"] = "As<int, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int64AsGeneric_Boolean",         ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<long>)",    ["Method"] = "As<long, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64SByteAsGeneric_Boolean",         ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<sbyte>)",   ["Method"] = "As<sbyte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64SingleAsGeneric_Boolean",        ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<float>)",   ["Method"] = "As<float, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt16AsGeneric_Boolean",        ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<ushort>)",  ["Method"] = "As<ushort, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt32AsGeneric_Boolean",        ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<uint>)",    ["Method"] = "As<uint, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt64AsGeneric_Boolean",        ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<ulong>)",   ["Method"] = "As<ulong, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Byte",          ["TargetType"] = "Vector64<byte>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Double",        ["TargetType"] = "Vector64<double>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Int16",         ["TargetType"] = "Vector64<short>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Int32",         ["TargetType"] = "Vector64<int>",     ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Int64",         ["TargetType"] = "Vector64<long>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_SByte",         ["TargetType"] = "Vector64<sbyte>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_Single",        ["TargetType"] = "Vector64<float>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_UInt16",        ["TargetType"] = "Vector64<ushort>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_UInt32",        ["TargetType"] = "Vector64<uint>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsGeneric_UInt64",        ["TargetType"] = "Vector64<ulong>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "As<bool, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsByte",                  ["TargetType"] = "Vector64<byte>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsDouble",                ["TargetType"] = "Vector64<double>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsInt16",                 ["TargetType"] = "Vector64<short>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsInt32",                 ["TargetType"] = "Vector64<int>",     ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsInt64",                 ["TargetType"] = "Vector64<long>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsSByte",                 ["TargetType"] = "Vector64<sbyte>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsSingle",                ["TargetType"] = "Vector64<float>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsUInt16",                ["TargetType"] = "Vector64<ushort>",  ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsUInt32",                ["TargetType"] = "Vector64<uint>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanAsUInt64",                ["TargetType"] = "Vector64<ulong>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanGetElementNegativeOne",   ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanGetElement0",             ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanGetElementMaxValue",      ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanWithElementNegativeOne",  ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "WithElement(-1, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanWithElement0",            ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "WithElement(0, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanWithElementMaxValue",     ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector64<bool>)",    ["Method"] = "WithElement(int.MaxValue, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanToScalar",                ["TargetType"] = "bool",              ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanToVector128",             ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToVector128()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanToVector128Unsafe",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToVector128Unsafe()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64BooleanToString",                ["TargetType"] = "string",            ["Source"] = "default(Vector64<bool>)",    ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntZero",                       ["TargetType"] = "Vector64<nint>",    ["Source"] = "Vector64<nint>",             ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAllBitsSet",                 ["TargetType"] = "Vector64<nint>",    ["Source"] = "Vector64<nint>",             ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_NInt",             ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64ByteAsGeneric_NInt",             ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<byte>)",    ["Method"] = "As<byte, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64DoubleAsGeneric_NInt",           ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<double>)",  ["Method"] = "As<double, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int16AsGeneric_NInt",            ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<short>)",   ["Method"] = "As<short, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int32AsGeneric_NInt",            ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<int>)",     ["Method"] = "As<int, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int64AsGeneric_NInt",            ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<long>)",    ["Method"] = "As<long, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64SByteAsGeneric_NInt",            ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<sbyte>)",   ["Method"] = "As<sbyte, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64SingleAsGeneric_NInt",           ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<float>)",   ["Method"] = "As<float, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt16AsGeneric_NInt",           ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<ushort>)",  ["Method"] = "As<ushort, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt32AsGeneric_NInt",           ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<uint>)",    ["Method"] = "As<uint, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt64AsGeneric_NInt",           ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<ulong>)",   ["Method"] = "As<ulong, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_Byte",             ["TargetType"] = "Vector64<byte>",    ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_Double",           ["TargetType"] = "Vector64<double>",  ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_Int16",            ["TargetType"] = "Vector64<short>",   ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_Int32",            ["TargetType"] = "Vector64<int>",     ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_Int64",            ["TargetType"] = "Vector64<long>",    ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_SByte",            ["TargetType"] = "Vector64<sbyte>",   ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_Single",           ["TargetType"] = "Vector64<float>",   ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_UInt16",           ["TargetType"] = "Vector64<ushort>",  ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_UInt32",           ["TargetType"] = "Vector64<uint>",    ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsGeneric_UInt64",           ["TargetType"] = "Vector64<ulong>",   ["Source"] = "default(Vector64<nint>)",    ["Method"] = "As<nint, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsByte",                     ["TargetType"] = "Vector64<byte>",    ["Source"] = "default(Vector64<nint>)",    ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsDouble",                   ["TargetType"] = "Vector64<double>",  ["Source"] = "default(Vector64<nint>)",    ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsInt16",                    ["TargetType"] = "Vector64<short>",   ["Source"] = "default(Vector64<nint>)",    ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsInt32",                    ["TargetType"] = "Vector64<int>",     ["Source"] = "default(Vector64<nint>)",    ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsInt64",                    ["TargetType"] = "Vector64<long>",    ["Source"] = "default(Vector64<nint>)",    ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsSByte",                    ["TargetType"] = "Vector64<sbyte>",   ["Source"] = "default(Vector64<nint>)",    ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsSingle",                   ["TargetType"] = "Vector64<float>",   ["Source"] = "default(Vector64<nint>)",    ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsUInt16",                   ["TargetType"] = "Vector64<ushort>",  ["Source"] = "default(Vector64<nint>)",    ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsUInt32",                   ["TargetType"] = "Vector64<uint>",    ["Source"] = "default(Vector64<nint>)",    ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntAsUInt64",                   ["TargetType"] = "Vector64<ulong>",   ["Source"] = "default(Vector64<nint>)",    ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntGetElementNegativeOne",      ["TargetType"] = "nint",              ["Source"] = "default(Vector64<nint>)",    ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntGetElement0",                ["TargetType"] = "nint",              ["Source"] = "default(Vector64<nint>)",    ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntGetElementMaxValue",         ["TargetType"] = "nint",              ["Source"] = "default(Vector64<nint>)",    ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntWithElementNegativeOne",     ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<nint>)",    ["Method"] = "WithElement(-1, (nint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntWithElement0",               ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<nint>)",    ["Method"] = "WithElement(0, (nint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntWithElementMaxValue",        ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector64<nint>)",    ["Method"] = "WithElement(int.MaxValue, (nint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntToScalar",                   ["TargetType"] = "nint",              ["Source"] = "default(Vector64<nint>)",    ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntToVector128",                ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector64<nint>)",    ["Method"] = "ToVector128()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntToVector128Unsafe",          ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector64<nint>)",    ["Method"] = "ToVector128Unsafe()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NIntToString",                   ["TargetType"] = "string",            ["Source"] = "default(Vector64<nint>)",    ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntZero",                      ["TargetType"] = "Vector64<nuint>",   ["Source"] = "Vector64<nuint>",            ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAllBitsSet",                ["TargetType"] = "Vector64<nuint>",   ["Source"] = "Vector64<nuint>",            ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_NUInt",           ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64ByteAsGeneric_NUInt",            ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<byte>)",    ["Method"] = "As<byte, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64DoubleAsGeneric_NUInt",          ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<double>)",  ["Method"] = "As<double, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int16AsGeneric_NUInt",           ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<short>)",   ["Method"] = "As<short, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int32AsGeneric_NUInt",           ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<int>)",     ["Method"] = "As<int, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64Int64AsGeneric_NUInt",           ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<long>)",    ["Method"] = "As<long, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64SByteAsGeneric_NUInt",           ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<sbyte>)",   ["Method"] = "As<sbyte, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64SingleAsGeneric_NUInt",          ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<float>)",   ["Method"] = "As<float, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt16AsGeneric_NUInt",          ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<ushort>)",  ["Method"] = "As<ushort, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt32AsGeneric_NUInt",          ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<uint>)",    ["Method"] = "As<uint, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64UInt64AsGeneric_NUInt",          ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<ulong>)",   ["Method"] = "As<ulong, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_Byte",            ["TargetType"] = "Vector64<byte>",    ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_Double",          ["TargetType"] = "Vector64<double>",  ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_Int16",           ["TargetType"] = "Vector64<short>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_Int32",           ["TargetType"] = "Vector64<int>",     ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_Int64",           ["TargetType"] = "Vector64<long>",    ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_SByte",           ["TargetType"] = "Vector64<sbyte>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_Single",          ["TargetType"] = "Vector64<float>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_UInt16",          ["TargetType"] = "Vector64<ushort>",  ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_UInt32",          ["TargetType"] = "Vector64<uint>",    ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsGeneric_UInt64",          ["TargetType"] = "Vector64<ulong>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "As<nuint, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsByte",                    ["TargetType"] = "Vector64<byte>",    ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsDouble",                  ["TargetType"] = "Vector64<double>",  ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsInt16",                   ["TargetType"] = "Vector64<short>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsInt32",                   ["TargetType"] = "Vector64<int>",     ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsInt64",                   ["TargetType"] = "Vector64<long>",    ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsSByte",                   ["TargetType"] = "Vector64<sbyte>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsSingle",                  ["TargetType"] = "Vector64<float>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsUInt16",                  ["TargetType"] = "Vector64<ushort>",  ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsUInt32",                  ["TargetType"] = "Vector64<uint>",    ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntAsUInt64",                  ["TargetType"] = "Vector64<ulong>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntGetElementNegativeOne",     ["TargetType"] = "nuint",             ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntGetElement0",               ["TargetType"] = "nuint",             ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntGetElementMaxValue",        ["TargetType"] = "nuint",             ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntWithElementNegativeOne",    ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "WithElement(-1, (nuint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntWithElement0",              ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "WithElement(0, (nuint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntWithElementMaxValue",       ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "WithElement(int.MaxValue, (nuint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntToScalar",                  ["TargetType"] = "nuint",             ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntToVector128",               ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "ToVector128()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntToVector128Unsafe",         ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "ToVector128Unsafe()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector64NUIntToString",                  ["TargetType"] = "string",            ["Source"] = "default(Vector64<nuint>)",   ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanZero",                   ["TargetType"] = "Vector128<bool>",   ["Source"] = "Vector128<bool>",            ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAllBitsSet",             ["TargetType"] = "Vector128<bool>",   ["Source"] = "Vector128<bool>",            ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Boolean",      ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128ByteAsGeneric_Boolean",         ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<byte>)",   ["Method"] = "As<byte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128DoubleAsGeneric_Boolean",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<double>)", ["Method"] = "As<double, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int16AsGeneric_Boolean",        ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<short>)",  ["Method"] = "As<short, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int32AsGeneric_Boolean",        ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<int>)",    ["Method"] = "As<int, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int64AsGeneric_Boolean",        ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<long>)",   ["Method"] = "As<long, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128SByteAsGeneric_Boolean",        ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<sbyte>)",  ["Method"] = "As<sbyte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128SingleAsGeneric_Boolean",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<float>)",  ["Method"] = "As<float, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt16AsGeneric_Boolean",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<ushort>)", ["Method"] = "As<ushort, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt32AsGeneric_Boolean",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<uint>)",   ["Method"] = "As<uint, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt64AsGeneric_Boolean",       ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<ulong>)",  ["Method"] = "As<ulong, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Byte",         ["TargetType"] = "Vector128<byte>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Double",       ["TargetType"] = "Vector128<double>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Int16",        ["TargetType"] = "Vector128<short>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Int32",        ["TargetType"] = "Vector128<int>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Int64",        ["TargetType"] = "Vector128<long>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_SByte",        ["TargetType"] = "Vector128<sbyte>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_Single",       ["TargetType"] = "Vector128<float>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_UInt16",       ["TargetType"] = "Vector128<ushort>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_UInt32",       ["TargetType"] = "Vector128<uint>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsGeneric_UInt64",       ["TargetType"] = "Vector128<ulong>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "As<bool, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsByte",                 ["TargetType"] = "Vector128<byte>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsDouble",               ["TargetType"] = "Vector128<double>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsInt16",                ["TargetType"] = "Vector128<short>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsInt32",                ["TargetType"] = "Vector128<int>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsInt64",                ["TargetType"] = "Vector128<long>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsSByte",                ["TargetType"] = "Vector128<sbyte>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsSingle",               ["TargetType"] = "Vector128<float>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsUInt16",               ["TargetType"] = "Vector128<ushort>", ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsUInt32",               ["TargetType"] = "Vector128<uint>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanAsUInt64",               ["TargetType"] = "Vector128<ulong>",  ["Source"] = "default(Vector128<bool>)",   ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanGetElementNegativeOne",  ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanGetElement0",            ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanGetElementMaxValue",     ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanWithElementNegativeOne", ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithElement(-1, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanWithElement0",           ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithElement(0, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanWithElementMaxValue",    ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithElement(int.MaxValue, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanGetLower",               ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetLower()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanWithLower",              ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithLower(default(Vector64<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanGetUpper",               ["TargetType"] = "Vector64<bool>",    ["Source"] = "default(Vector128<bool>)",   ["Method"] = "GetUpper()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanWithUpper",              ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "WithUpper(default(Vector64<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanToScalar",               ["TargetType"] = "bool",              ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanToVector256",            ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToVector256()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanToVector256Unsafe",      ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToVector256Unsafe()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128BooleanToString",               ["TargetType"] = "string",            ["Source"] = "default(Vector128<bool>)",   ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntZero",                      ["TargetType"] = "Vector128<nint>",   ["Source"] = "Vector128<nint>",            ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAllBitsSet",                ["TargetType"] = "Vector128<nint>",   ["Source"] = "Vector128<nint>",            ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_NInt",            ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128ByteAsGeneric_NInt",            ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<byte>)",   ["Method"] = "As<byte, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128DoubleAsGeneric_NInt",          ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<double>)", ["Method"] = "As<double, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int16AsGeneric_NInt",           ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<short>)",  ["Method"] = "As<short, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int32AsGeneric_NInt",           ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<int>)",    ["Method"] = "As<int, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int64AsGeneric_NInt",           ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<long>)",   ["Method"] = "As<long, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128SByteAsGeneric_NInt",           ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<sbyte>)",  ["Method"] = "As<sbyte, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128SingleAsGeneric_NInt",          ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<float>)",  ["Method"] = "As<float, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt16AsGeneric_NInt",          ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<ushort>)", ["Method"] = "As<ushort, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt32AsGeneric_NInt",          ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<uint>)",   ["Method"] = "As<uint, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt64AsGeneric_NInt",          ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<ulong>)",  ["Method"] = "As<ulong, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_Byte",            ["TargetType"] = "Vector128<byte>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_Double",          ["TargetType"] = "Vector128<double>", ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_Int16",           ["TargetType"] = "Vector128<short>",  ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_Int32",           ["TargetType"] = "Vector128<int>",    ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_Int64",           ["TargetType"] = "Vector128<long>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_SByte",           ["TargetType"] = "Vector128<sbyte>",  ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_Single",          ["TargetType"] = "Vector128<float>",  ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_UInt16",          ["TargetType"] = "Vector128<ushort>", ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_UInt32",          ["TargetType"] = "Vector128<uint>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsGeneric_UInt64",          ["TargetType"] = "Vector128<ulong>",  ["Source"] = "default(Vector128<nint>)",   ["Method"] = "As<nint, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsByte",                    ["TargetType"] = "Vector128<byte>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsDouble",                  ["TargetType"] = "Vector128<double>", ["Source"] = "default(Vector128<nint>)",   ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsInt16",                   ["TargetType"] = "Vector128<short>",  ["Source"] = "default(Vector128<nint>)",   ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsInt32",                   ["TargetType"] = "Vector128<int>",    ["Source"] = "default(Vector128<nint>)",   ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsInt64",                   ["TargetType"] = "Vector128<long>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsSByte",                   ["TargetType"] = "Vector128<sbyte>",  ["Source"] = "default(Vector128<nint>)",   ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsSingle",                  ["TargetType"] = "Vector128<float>",  ["Source"] = "default(Vector128<nint>)",   ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsUInt16",                  ["TargetType"] = "Vector128<ushort>", ["Source"] = "default(Vector128<nint>)",   ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsUInt32",                  ["TargetType"] = "Vector128<uint>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntAsUInt64",                  ["TargetType"] = "Vector128<ulong>",  ["Source"] = "default(Vector128<nint>)",   ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntGetElementNegativeOne",     ["TargetType"] = "nint",              ["Source"] = "default(Vector128<nint>)",   ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntGetElement0",               ["TargetType"] = "nint",              ["Source"] = "default(Vector128<nint>)",   ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntGetElementMaxValue",        ["TargetType"] = "nint",              ["Source"] = "default(Vector128<nint>)",   ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntWithElementNegativeOne",    ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "WithElement(-1, (nint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntWithElement0",              ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "WithElement(0, (nint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntWithElementMaxValue",       ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "WithElement(int.MaxValue, (nint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntGetLower",                  ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector128<nint>)",   ["Method"] = "GetLower()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntWithLower",                 ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "WithLower(default(Vector64<nint>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntGetUpper",                  ["TargetType"] = "Vector64<nint>",    ["Source"] = "default(Vector128<nint>)",   ["Method"] = "GetUpper()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntWithUpper",                 ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "WithUpper(default(Vector64<nint>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntToScalar",                  ["TargetType"] = "nint",              ["Source"] = "default(Vector128<nint>)",   ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntToVector256",               ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "ToVector256()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntToVector256Unsafe",         ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector128<nint>)",   ["Method"] = "ToVector256Unsafe()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NIntToString",                  ["TargetType"] = "string",            ["Source"] = "default(Vector128<nint>)",   ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntZero",                     ["TargetType"] = "Vector128<nuint>",  ["Source"] = "Vector128<nuint>",           ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAllBitsSet",               ["TargetType"] = "Vector128<nuint>",  ["Source"] = "Vector128<nuint>",           ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_NUInt",          ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128ByteAsGeneric_NUInt",           ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<byte>)",   ["Method"] = "As<byte, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128DoubleAsGeneric_NUInt",         ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<double>)", ["Method"] = "As<double, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int16AsGeneric_NUInt",          ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<short>)",  ["Method"] = "As<short, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int32AsGeneric_NUInt",          ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<int>)",    ["Method"] = "As<int, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128Int64AsGeneric_NUInt",          ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<long>)",   ["Method"] = "As<long, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128SByteAsGeneric_NUInt",          ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<sbyte>)",  ["Method"] = "As<sbyte, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128SingleAsGeneric_NUInt",         ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<float>)",  ["Method"] = "As<float, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt16AsGeneric_NUInt",         ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<ushort>)", ["Method"] = "As<ushort, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt32AsGeneric_NUInt",         ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<uint>)",   ["Method"] = "As<uint, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128UInt64AsGeneric_NUInt",         ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<ulong>)",  ["Method"] = "As<ulong, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_Byte",           ["TargetType"] = "Vector128<byte>",   ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_Double",         ["TargetType"] = "Vector128<double>", ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_Int16",          ["TargetType"] = "Vector128<short>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_Int32",          ["TargetType"] = "Vector128<int>",    ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_Int64",          ["TargetType"] = "Vector128<long>",   ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_SByte",          ["TargetType"] = "Vector128<sbyte>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_Single",         ["TargetType"] = "Vector128<float>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_UInt16",         ["TargetType"] = "Vector128<ushort>", ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_UInt32",         ["TargetType"] = "Vector128<uint>",   ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsGeneric_UInt64",         ["TargetType"] = "Vector128<ulong>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "As<nuint, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsByte",                   ["TargetType"] = "Vector128<byte>",   ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsDouble",                 ["TargetType"] = "Vector128<double>", ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsInt16",                  ["TargetType"] = "Vector128<short>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsInt32",                  ["TargetType"] = "Vector128<int>",    ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsInt64",                  ["TargetType"] = "Vector128<long>",   ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsSByte",                  ["TargetType"] = "Vector128<sbyte>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsSingle",                 ["TargetType"] = "Vector128<float>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsUInt16",                 ["TargetType"] = "Vector128<ushort>", ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsUInt32",                 ["TargetType"] = "Vector128<uint>",   ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntAsUInt64",                 ["TargetType"] = "Vector128<ulong>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntGetElementNegativeOne",    ["TargetType"] = "nuint",             ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntGetElement0",              ["TargetType"] = "nuint",             ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntGetElementMaxValue",       ["TargetType"] = "nuint",             ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntWithElementNegativeOne",   ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "WithElement(-1, (nuint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntWithElement0",             ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "WithElement(0, (nuint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntWithElementMaxValue",      ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "WithElement(int.MaxValue, (nuint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntGetLower",                 ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "GetLower()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntWithLower",                ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "WithLower(default(Vector64<nuint>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntGetUpper",                 ["TargetType"] = "Vector64<nuint>",   ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "GetUpper()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntWithUpper",                ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "WithUpper(default(Vector64<nuint>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntToScalar",                 ["TargetType"] = "nuint",             ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntToVector256",              ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "ToVector256()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntToVector256Unsafe",        ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "ToVector256Unsafe()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector128NUIntToString",                 ["TargetType"] = "string",            ["Source"] = "default(Vector128<nuint>)",  ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanZero",                   ["TargetType"] = "Vector256<bool>",   ["Source"] = "Vector256<bool>",            ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAllBitsSet",             ["TargetType"] = "Vector256<bool>",   ["Source"] = "Vector256<bool>",            ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Boolean",      ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256ByteAsGeneric_Boolean",         ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<byte>)",   ["Method"] = "As<byte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256DoubleAsGeneric_Boolean",       ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<double>)", ["Method"] = "As<double, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int16AsGeneric_Boolean",        ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<short>)",  ["Method"] = "As<short, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int32AsGeneric_Boolean",        ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<int>)",    ["Method"] = "As<int, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int64AsGeneric_Boolean",        ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<long>)",   ["Method"] = "As<long, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256SByteAsGeneric_Boolean",        ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<sbyte>)",  ["Method"] = "As<sbyte, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256SingleAsGeneric_Boolean",       ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<float>)",  ["Method"] = "As<float, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt16AsGeneric_Boolean",       ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<ushort>)", ["Method"] = "As<ushort, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt32AsGeneric_Boolean",       ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<uint>)",   ["Method"] = "As<uint, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt64AsGeneric_Boolean",       ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<ulong>)",  ["Method"] = "As<ulong, bool>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Byte",         ["TargetType"] = "Vector256<byte>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Double",       ["TargetType"] = "Vector256<double>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Int16",        ["TargetType"] = "Vector256<short>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Int32",        ["TargetType"] = "Vector256<int>",    ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Int64",        ["TargetType"] = "Vector256<long>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_SByte",        ["TargetType"] = "Vector256<sbyte>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_Single",       ["TargetType"] = "Vector256<float>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_UInt16",       ["TargetType"] = "Vector256<ushort>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_UInt32",       ["TargetType"] = "Vector256<uint>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsGeneric_UInt64",       ["TargetType"] = "Vector256<ulong>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "As<bool, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsByte",                 ["TargetType"] = "Vector256<byte>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsDouble",               ["TargetType"] = "Vector256<double>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsInt16",                ["TargetType"] = "Vector256<short>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsInt32",                ["TargetType"] = "Vector256<int>",    ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsInt64",                ["TargetType"] = "Vector256<long>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsSByte",                ["TargetType"] = "Vector256<sbyte>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsSingle",               ["TargetType"] = "Vector256<float>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsUInt16",               ["TargetType"] = "Vector256<ushort>", ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsUInt32",               ["TargetType"] = "Vector256<uint>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanAsUInt64",               ["TargetType"] = "Vector256<ulong>",  ["Source"] = "default(Vector256<bool>)",   ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanGetElementNegativeOne",  ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanGetElement0",            ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanGetElementMaxValue",     ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanWithElementNegativeOne", ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithElement(-1, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanWithElement0",           ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithElement(0, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanWithElementMaxValue",    ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithElement(int.MaxValue, false)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanGetLower",               ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetLower()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanWithLower",              ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithLower(default(Vector128<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanGetUpper",               ["TargetType"] = "Vector128<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "GetUpper()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanWithUpper",              ["TargetType"] = "Vector256<bool>",   ["Source"] = "default(Vector256<bool>)",   ["Method"] = "WithUpper(default(Vector128<bool>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanToScalar",               ["TargetType"] = "bool",              ["Source"] = "default(Vector256<bool>)",   ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256BooleanToString",               ["TargetType"] = "string",            ["Source"] = "default(Vector256<bool>)",   ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntZero",                      ["TargetType"] = "Vector256<nint>",   ["Source"] = "Vector256<nint>",            ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAllBitsSet",                ["TargetType"] = "Vector256<nint>",   ["Source"] = "Vector256<nint>",            ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_NInt",            ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256ByteAsGeneric_NInt",            ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<byte>)",   ["Method"] = "As<byte, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256DoubleAsGeneric_NInt",          ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<double>)", ["Method"] = "As<double, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int16AsGeneric_NInt",           ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<short>)",  ["Method"] = "As<short, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int32AsGeneric_NInt",           ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<int>)",    ["Method"] = "As<int, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int64AsGeneric_NInt",           ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<long>)",   ["Method"] = "As<long, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256SByteAsGeneric_NInt",           ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<sbyte>)",  ["Method"] = "As<sbyte, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256SingleAsGeneric_NInt",          ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<float>)",  ["Method"] = "As<float, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt16AsGeneric_NInt",          ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<ushort>)", ["Method"] = "As<ushort, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt32AsGeneric_NInt",          ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<uint>)",   ["Method"] = "As<uint, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt64AsGeneric_NInt",          ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<ulong>)",  ["Method"] = "As<ulong, nint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_Byte",            ["TargetType"] = "Vector256<byte>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_Double",          ["TargetType"] = "Vector256<double>", ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_Int16",           ["TargetType"] = "Vector256<short>",  ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_Int32",           ["TargetType"] = "Vector256<int>",    ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_Int64",           ["TargetType"] = "Vector256<long>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_SByte",           ["TargetType"] = "Vector256<sbyte>",  ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_Single",          ["TargetType"] = "Vector256<float>",  ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_UInt16",          ["TargetType"] = "Vector256<ushort>", ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_UInt32",          ["TargetType"] = "Vector256<uint>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsGeneric_UInt64",          ["TargetType"] = "Vector256<ulong>",  ["Source"] = "default(Vector256<nint>)",   ["Method"] = "As<nint, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsByte",                    ["TargetType"] = "Vector256<byte>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsDouble",                  ["TargetType"] = "Vector256<double>", ["Source"] = "default(Vector256<nint>)",   ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsInt16",                   ["TargetType"] = "Vector256<short>",  ["Source"] = "default(Vector256<nint>)",   ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsInt32",                   ["TargetType"] = "Vector256<int>",    ["Source"] = "default(Vector256<nint>)",   ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsInt64",                   ["TargetType"] = "Vector256<long>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsSByte",                   ["TargetType"] = "Vector256<sbyte>",  ["Source"] = "default(Vector256<nint>)",   ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsSingle",                  ["TargetType"] = "Vector256<float>",  ["Source"] = "default(Vector256<nint>)",   ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsUInt16",                  ["TargetType"] = "Vector256<ushort>", ["Source"] = "default(Vector256<nint>)",   ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsUInt32",                  ["TargetType"] = "Vector256<uint>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntAsUInt64",                  ["TargetType"] = "Vector256<ulong>",  ["Source"] = "default(Vector256<nint>)",   ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntGetElementNegativeOne",     ["TargetType"] = "nint",              ["Source"] = "default(Vector256<nint>)",   ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntGetElement0",               ["TargetType"] = "nint",              ["Source"] = "default(Vector256<nint>)",   ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntGetElementMaxValue",        ["TargetType"] = "nint",              ["Source"] = "default(Vector256<nint>)",   ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntWithElementNegativeOne",    ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "WithElement(-1, (nint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntWithElement0",              ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "WithElement(0, (nint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntWithElementMaxValue",       ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "WithElement(int.MaxValue, (nint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntGetLower",                  ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "GetLower()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntWithLower",                 ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "WithLower(default(Vector128<nint>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntGetUpper",                  ["TargetType"] = "Vector128<nint>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "GetUpper()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntWithUpper",                 ["TargetType"] = "Vector256<nint>",   ["Source"] = "default(Vector256<nint>)",   ["Method"] = "WithUpper(default(Vector128<nint>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntToScalar",                  ["TargetType"] = "nint",              ["Source"] = "default(Vector256<nint>)",   ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NIntToString",                  ["TargetType"] = "string",            ["Source"] = "default(Vector256<nint>)",   ["Method"] = "ToString()" }),

    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntZero",                     ["TargetType"] = "Vector256<nuint>",  ["Source"] = "Vector256<nuint>",           ["Method"] = "Zero" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAllBitsSet",               ["TargetType"] = "Vector256<nuint>",  ["Source"] = "Vector256<nuint>",           ["Method"] = "AllBitsSet" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_NUInt",          ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256ByteAsGeneric_NUInt",           ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<byte>)",   ["Method"] = "As<byte, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256DoubleAsGeneric_NUInt",         ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<double>)", ["Method"] = "As<double, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int16AsGeneric_NUInt",          ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<short>)",  ["Method"] = "As<short, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int32AsGeneric_NUInt",          ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<int>)",    ["Method"] = "As<int, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256Int64AsGeneric_NUInt",          ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<long>)",   ["Method"] = "As<long, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256SByteAsGeneric_NUInt",          ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<sbyte>)",  ["Method"] = "As<sbyte, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256SingleAsGeneric_NUInt",         ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<float>)",  ["Method"] = "As<float, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt16AsGeneric_NUInt",         ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<ushort>)", ["Method"] = "As<ushort, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt32AsGeneric_NUInt",         ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<uint>)",   ["Method"] = "As<uint, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256UInt64AsGeneric_NUInt",         ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<ulong>)",  ["Method"] = "As<ulong, nuint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_Byte",           ["TargetType"] = "Vector256<byte>",   ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, byte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_Double",         ["TargetType"] = "Vector256<double>", ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, double>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_Int16",          ["TargetType"] = "Vector256<short>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, short>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_Int32",          ["TargetType"] = "Vector256<int>",    ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, int>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_Int64",          ["TargetType"] = "Vector256<long>",   ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, long>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_SByte",          ["TargetType"] = "Vector256<sbyte>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, sbyte>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_Single",         ["TargetType"] = "Vector256<float>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, float>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_UInt16",         ["TargetType"] = "Vector256<ushort>", ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, ushort>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_UInt32",         ["TargetType"] = "Vector256<uint>",   ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, uint>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsGeneric_UInt64",         ["TargetType"] = "Vector256<ulong>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "As<nuint, ulong>()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsByte",                   ["TargetType"] = "Vector256<byte>",   ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "AsByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsDouble",                 ["TargetType"] = "Vector256<double>", ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "AsDouble()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsInt16",                  ["TargetType"] = "Vector256<short>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "AsInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsInt32",                  ["TargetType"] = "Vector256<int>",    ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "AsInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsInt64",                  ["TargetType"] = "Vector256<long>",   ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "AsInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsSByte",                  ["TargetType"] = "Vector256<sbyte>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "AsSByte()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsSingle",                 ["TargetType"] = "Vector256<float>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "AsSingle()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsUInt16",                 ["TargetType"] = "Vector256<ushort>", ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "AsUInt16()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsUInt32",                 ["TargetType"] = "Vector256<uint>",   ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "AsUInt32()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntAsUInt64",                 ["TargetType"] = "Vector256<ulong>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "AsUInt64()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntGetElementNegativeOne",    ["TargetType"] = "nuint",             ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "GetElement(-1)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntGetElement0",              ["TargetType"] = "nuint",             ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "GetElement(0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntGetElementMaxValue",       ["TargetType"] = "nuint",             ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "GetElement(int.MaxValue)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntWithElementNegativeOne",   ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "WithElement(-1, (nuint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntWithElement0",             ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "WithElement(0, (nuint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntWithElementMaxValue",      ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "WithElement(int.MaxValue, (nuint)0)" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntGetLower",                 ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "GetLower()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntWithLower",                ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "WithLower(default(Vector128<nuint>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntGetUpper",                 ["TargetType"] = "Vector128<nuint>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "GetUpper()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntWithUpper",                ["TargetType"] = "Vector256<nuint>",  ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "WithUpper(default(Vector128<nuint>))" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntToScalar",                 ["TargetType"] = "nuint",             ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "ToScalar()" }),
    ("VectorNotSupportedTest.template", new Dictionary<string, string> { ["Isa"] = "NotSupported", ["Name"] = "Vector256NUIntToString",                 ["TargetType"] = "string",            ["Source"] = "default(Vector256<nuint>)",  ["Method"] = "ToString()" }),
};

private static void ProcessInputs(string groupName, (string templateFileName, Dictionary<string, string> templateData)[] inputs)
{
    var testListFileName = Path.Combine("..", groupName, $"Program.{groupName}.cs");

    using (var testListFile = new StreamWriter(testListFileName, append: false))
    {
        testListFile.WriteLine(@"// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.General
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {");

        foreach (var input in inputs)
        {
            ProcessInput(testListFile, groupName, input);
        }

        testListFile.WriteLine(@"            };
        }
    }
}");
    }
}

private static void ProcessInput(StreamWriter testListFile, string groupName, (string templateFileName, Dictionary<string, string> templateData) input)
{
    var testName = "";

    // Ex: ["Add.Single"] = AddSingle
    if (input.templateFileName == "VectorCreateElementTest.template")
    {
        testName = $"{input.templateData["Method"]}Element.{input.templateData["BaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}Element{input.templateData["BaseType"]},");
    }
    else if (input.templateFileName == "VectorCreateVectorTest.template")
    {
        testName = $"{input.templateData["Method"]}Vector.{input.templateData["BaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}Vector{input.templateData["BaseType"]},");
    }
    else if (input.templateFileName == "VectorGetAndWithElementTest.template")
    {
        testName = $"{input.templateData["Method"]}.{input.templateData["BaseType"]}.{input.templateData["Imm"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{input.templateData["BaseType"]}{input.templateData["Imm"]},");
    }
    else if (input.templateFileName == "VectorNotSupportedTest.template")
    {
        testName = input.templateData["Name"];
        testListFile.WriteLine($@"                [""{testName}""] = {testName},");
    }
    else
    {
        testName = $"{input.templateData["Method"]}.{input.templateData["BaseType"]}";
        testListFile.WriteLine($@"                [""{testName}""] = {input.templateData["Method"]}{input.templateData["BaseType"]},");
    }

    var testFileName = Path.Combine("..", groupName, $"{testName}.cs");
    var template = File.ReadAllText(input.templateFileName);

    foreach (var kvp in input.templateData)
    {
        template = template.Replace($"{{{kvp.Key}}}", kvp.Value);
    }

    File.WriteAllText(testFileName, template);
}

ProcessInputs("Vector64", Vector64Inputs);
ProcessInputs("Vector64_1", Vector64_1Inputs);
ProcessInputs("Vector128", Vector128Inputs);
ProcessInputs("Vector128_1", Vector128_1Inputs);
ProcessInputs("Vector256", Vector256Inputs);
ProcessInputs("Vector256_1", Vector256_1Inputs);
ProcessInputs("NotSupported", NotSupportedInputs);
