// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["ShiftLogicalSaturateScalar.Vector64.UInt16"] = ShiftLogicalSaturateScalar_Vector64_UInt16,
                ["ShiftLogicalSaturateScalar.Vector64.UInt32"] = ShiftLogicalSaturateScalar_Vector64_UInt32,
                ["ShiftRightArithmeticNarrowingSaturateScalar.Vector64.Int16.16"] = ShiftRightArithmeticNarrowingSaturateScalar_Vector64_Int16_16,
                ["ShiftRightArithmeticNarrowingSaturateScalar.Vector64.Int32.32"] = ShiftRightArithmeticNarrowingSaturateScalar_Vector64_Int32_32,
                ["ShiftRightArithmeticNarrowingSaturateScalar.Vector64.SByte.8"] = ShiftRightArithmeticNarrowingSaturateScalar_Vector64_SByte_8,
                ["ShiftRightArithmeticNarrowingSaturateUnsignedScalar.Vector64.Byte.3"] = ShiftRightArithmeticNarrowingSaturateUnsignedScalar_Vector64_Byte_3,
                ["ShiftRightArithmeticNarrowingSaturateUnsignedScalar.Vector64.UInt16.5"] = ShiftRightArithmeticNarrowingSaturateUnsignedScalar_Vector64_UInt16_5,
                ["ShiftRightArithmeticNarrowingSaturateUnsignedScalar.Vector64.UInt32.7"] = ShiftRightArithmeticNarrowingSaturateUnsignedScalar_Vector64_UInt32_7,
                ["ShiftRightArithmeticRoundedNarrowingSaturateScalar.Vector64.Int16.32"] = ShiftRightArithmeticRoundedNarrowingSaturateScalar_Vector64_Int16_32,
                ["ShiftRightArithmeticRoundedNarrowingSaturateScalar.Vector64.Int32.64"] = ShiftRightArithmeticRoundedNarrowingSaturateScalar_Vector64_Int32_64,
                ["ShiftRightArithmeticRoundedNarrowingSaturateScalar.Vector64.SByte.16"] = ShiftRightArithmeticRoundedNarrowingSaturateScalar_Vector64_SByte_16,
                ["ShiftRightArithmeticRoundedNarrowingSaturateUnsignedScalar.Vector64.Byte.1"] = ShiftRightArithmeticRoundedNarrowingSaturateUnsignedScalar_Vector64_Byte_1,
                ["ShiftRightArithmeticRoundedNarrowingSaturateUnsignedScalar.Vector64.UInt16.1"] = ShiftRightArithmeticRoundedNarrowingSaturateUnsignedScalar_Vector64_UInt16_1,
                ["ShiftRightArithmeticRoundedNarrowingSaturateUnsignedScalar.Vector64.UInt32.1"] = ShiftRightArithmeticRoundedNarrowingSaturateUnsignedScalar_Vector64_UInt32_1,
                ["ShiftRightLogicalNarrowingSaturateScalar.Vector64.Byte.5"] = ShiftRightLogicalNarrowingSaturateScalar_Vector64_Byte_5,
                ["ShiftRightLogicalNarrowingSaturateScalar.Vector64.Int16.7"] = ShiftRightLogicalNarrowingSaturateScalar_Vector64_Int16_7,
                ["ShiftRightLogicalNarrowingSaturateScalar.Vector64.Int32.11"] = ShiftRightLogicalNarrowingSaturateScalar_Vector64_Int32_11,
                ["ShiftRightLogicalNarrowingSaturateScalar.Vector64.SByte.3"] = ShiftRightLogicalNarrowingSaturateScalar_Vector64_SByte_3,
                ["ShiftRightLogicalNarrowingSaturateScalar.Vector64.UInt16.5"] = ShiftRightLogicalNarrowingSaturateScalar_Vector64_UInt16_5,
                ["ShiftRightLogicalNarrowingSaturateScalar.Vector64.UInt32.7"] = ShiftRightLogicalNarrowingSaturateScalar_Vector64_UInt32_7,
                ["ShiftRightLogicalRoundedNarrowingSaturateScalar.Vector64.Byte.1"] = ShiftRightLogicalRoundedNarrowingSaturateScalar_Vector64_Byte_1,
                ["ShiftRightLogicalRoundedNarrowingSaturateScalar.Vector64.Int16.1"] = ShiftRightLogicalRoundedNarrowingSaturateScalar_Vector64_Int16_1,
                ["ShiftRightLogicalRoundedNarrowingSaturateScalar.Vector64.Int32.1"] = ShiftRightLogicalRoundedNarrowingSaturateScalar_Vector64_Int32_1,
                ["ShiftRightLogicalRoundedNarrowingSaturateScalar.Vector64.SByte.1"] = ShiftRightLogicalRoundedNarrowingSaturateScalar_Vector64_SByte_1,
                ["ShiftRightLogicalRoundedNarrowingSaturateScalar.Vector64.UInt16.1"] = ShiftRightLogicalRoundedNarrowingSaturateScalar_Vector64_UInt16_1,
                ["ShiftRightLogicalRoundedNarrowingSaturateScalar.Vector64.UInt32.1"] = ShiftRightLogicalRoundedNarrowingSaturateScalar_Vector64_UInt32_1,
                ["Sqrt.Vector64.Single"] = Sqrt_Vector64_Single,
                ["Sqrt.Vector128.Double"] = Sqrt_Vector128_Double,
                ["Sqrt.Vector128.Single"] = Sqrt_Vector128_Single,
                ["StorePair.Vector64.Byte"] = StorePair_Vector64_Byte,
                ["StorePair.Vector64.Double"] = StorePair_Vector64_Double,
                ["StorePair.Vector64.Int16"] = StorePair_Vector64_Int16,
                ["StorePair.Vector64.Int32"] = StorePair_Vector64_Int32,
                ["StorePair.Vector64.Int64"] = StorePair_Vector64_Int64,
                ["StorePair.Vector64.SByte"] = StorePair_Vector64_SByte,
                ["StorePair.Vector64.Single"] = StorePair_Vector64_Single,
                ["StorePair.Vector64.UInt16"] = StorePair_Vector64_UInt16,
                ["StorePair.Vector64.UInt32"] = StorePair_Vector64_UInt32,
                ["StorePair.Vector64.UInt64"] = StorePair_Vector64_UInt64,
                ["StorePair.Vector128.Byte"] = StorePair_Vector128_Byte,
                ["StorePair.Vector128.Double"] = StorePair_Vector128_Double,
                ["StorePair.Vector128.Int16"] = StorePair_Vector128_Int16,
                ["StorePair.Vector128.Int32"] = StorePair_Vector128_Int32,
                ["StorePair.Vector128.Int64"] = StorePair_Vector128_Int64,
                ["StorePair.Vector128.SByte"] = StorePair_Vector128_SByte,
                ["StorePair.Vector128.Single"] = StorePair_Vector128_Single,
                ["StorePair.Vector128.UInt16"] = StorePair_Vector128_UInt16,
                ["StorePair.Vector128.UInt32"] = StorePair_Vector128_UInt32,
                ["StorePair.Vector128.UInt64"] = StorePair_Vector128_UInt64,
                ["StorePairScalar.Vector64.Int32"] = StorePairScalar_Vector64_Int32,
                ["StorePairScalar.Vector64.Single"] = StorePairScalar_Vector64_Single,
                ["StorePairScalar.Vector64.UInt32"] = StorePairScalar_Vector64_UInt32,
                ["StorePairScalarNonTemporal.Vector64.Int32"] = StorePairScalarNonTemporal_Vector64_Int32,
                ["StorePairScalarNonTemporal.Vector64.Single"] = StorePairScalarNonTemporal_Vector64_Single,
                ["StorePairScalarNonTemporal.Vector64.UInt32"] = StorePairScalarNonTemporal_Vector64_UInt32,
                ["StorePairNonTemporal.Vector64.Byte"] = StorePairNonTemporal_Vector64_Byte,
                ["StorePairNonTemporal.Vector64.Double"] = StorePairNonTemporal_Vector64_Double,
                ["StorePairNonTemporal.Vector64.Int16"] = StorePairNonTemporal_Vector64_Int16,
                ["StorePairNonTemporal.Vector64.Int32"] = StorePairNonTemporal_Vector64_Int32,
                ["StorePairNonTemporal.Vector64.Int64"] = StorePairNonTemporal_Vector64_Int64,
                ["StorePairNonTemporal.Vector64.SByte"] = StorePairNonTemporal_Vector64_SByte,
                ["StorePairNonTemporal.Vector64.Single"] = StorePairNonTemporal_Vector64_Single,
                ["StorePairNonTemporal.Vector64.UInt16"] = StorePairNonTemporal_Vector64_UInt16,
                ["StorePairNonTemporal.Vector64.UInt32"] = StorePairNonTemporal_Vector64_UInt32,
                ["StorePairNonTemporal.Vector64.UInt64"] = StorePairNonTemporal_Vector64_UInt64,
                ["StorePairNonTemporal.Vector128.Byte"] = StorePairNonTemporal_Vector128_Byte,
                ["StorePairNonTemporal.Vector128.Double"] = StorePairNonTemporal_Vector128_Double,
                ["StorePairNonTemporal.Vector128.Int16"] = StorePairNonTemporal_Vector128_Int16,
                ["StorePairNonTemporal.Vector128.Int32"] = StorePairNonTemporal_Vector128_Int32,
                ["StorePairNonTemporal.Vector128.Int64"] = StorePairNonTemporal_Vector128_Int64,
                ["StorePairNonTemporal.Vector128.SByte"] = StorePairNonTemporal_Vector128_SByte,
                ["StorePairNonTemporal.Vector128.Single"] = StorePairNonTemporal_Vector128_Single,
                ["StorePairNonTemporal.Vector128.UInt16"] = StorePairNonTemporal_Vector128_UInt16,
                ["StorePairNonTemporal.Vector128.UInt32"] = StorePairNonTemporal_Vector128_UInt32,
                ["StorePairNonTemporal.Vector128.UInt64"] = StorePairNonTemporal_Vector128_UInt64,
                ["Subtract.Vector128.Double"] = Subtract_Vector128_Double,
                ["SubtractSaturateScalar.Vector64.Byte"] = SubtractSaturateScalar_Vector64_Byte,
                ["SubtractSaturateScalar.Vector64.Int16"] = SubtractSaturateScalar_Vector64_Int16,
                ["SubtractSaturateScalar.Vector64.Int32"] = SubtractSaturateScalar_Vector64_Int32,
                ["SubtractSaturateScalar.Vector64.SByte"] = SubtractSaturateScalar_Vector64_SByte,
                ["SubtractSaturateScalar.Vector64.UInt16"] = SubtractSaturateScalar_Vector64_UInt16,
                ["SubtractSaturateScalar.Vector64.UInt32"] = SubtractSaturateScalar_Vector64_UInt32,
                ["TransposeEven.Vector64.Byte"] = TransposeEven_Vector64_Byte,
                ["TransposeEven.Vector64.Int16"] = TransposeEven_Vector64_Int16,
                ["TransposeEven.Vector64.Int32"] = TransposeEven_Vector64_Int32,
                ["TransposeEven.Vector64.SByte"] = TransposeEven_Vector64_SByte,
                ["TransposeEven.Vector64.Single"] = TransposeEven_Vector64_Single,
                ["TransposeEven.Vector64.UInt16"] = TransposeEven_Vector64_UInt16,
                ["TransposeEven.Vector64.UInt32"] = TransposeEven_Vector64_UInt32,
                ["TransposeEven.Vector128.Byte"] = TransposeEven_Vector128_Byte,
                ["TransposeEven.Vector128.Double"] = TransposeEven_Vector128_Double,
                ["TransposeEven.Vector128.Int16"] = TransposeEven_Vector128_Int16,
                ["TransposeEven.Vector128.Int32"] = TransposeEven_Vector128_Int32,
                ["TransposeEven.Vector128.Int64"] = TransposeEven_Vector128_Int64,
                ["TransposeEven.Vector128.SByte"] = TransposeEven_Vector128_SByte,
                ["TransposeEven.Vector128.Single"] = TransposeEven_Vector128_Single,
                ["TransposeEven.Vector128.UInt16"] = TransposeEven_Vector128_UInt16,
                ["TransposeEven.Vector128.UInt32"] = TransposeEven_Vector128_UInt32,
                ["TransposeEven.Vector128.UInt64"] = TransposeEven_Vector128_UInt64,
                ["TransposeOdd.Vector64.Byte"] = TransposeOdd_Vector64_Byte,
            };
        }
    }
}
