; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=memcpyopt -S %s | FileCheck %s

declare void @init(i64* nocapture sret(i64) align 8)

declare i1 @check(i64* readonly byval(i64) align 8) readonly argmemonly

declare void @clobber(i8*) argmemonly

declare void @llvm.lifetime.start.p0i8(i64 immarg, i8* nocapture)
declare void @llvm.lifetime.end.p0i8(i64 immarg, i8* nocapture)
declare void @llvm.memcpy.p0i8.p0i8.i64(i8* noalias nocapture writeonly, i8* noalias nocapture readonly, i64, i1 immarg)

; %a.2's lifetime ends before the call to @check. Cannot replace
; %a.1 with %a.2 in the call to @check.
define i1 @alloca_forwarding_lifetime_end_clobber() {
; CHECK-LABEL: @alloca_forwarding_lifetime_end_clobber(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_1:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[A_2:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[BC_A_1:%.*]] = bitcast i64* [[A_1]] to i8*
; CHECK-NEXT:    [[BC_A_2:%.*]] = bitcast i64* [[A_2]] to i8*
; CHECK-NEXT:    call void @llvm.lifetime.start.p0i8(i64 8, i8* [[BC_A_2]])
; CHECK-NEXT:    call void @init(i64* sret(i64) align 8 [[A_2]])
; CHECK-NEXT:    store i8 0, i8* [[BC_A_2]], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* [[BC_A_1]], i8* [[BC_A_2]], i64 8, i1 false)
; CHECK-NEXT:    call void @llvm.lifetime.end.p0i8(i64 8, i8* [[BC_A_2]])
; CHECK-NEXT:    [[CALL:%.*]] = call i1 @check(i64* byval(i64) align 8 [[A_1]])
; CHECK-NEXT:    ret i1 [[CALL]]
;
entry:
  %a.1 = alloca i64, align 8
  %a.2 = alloca i64, align 8
  %bc.a.1 = bitcast i64* %a.1 to i8*
  %bc.a.2 = bitcast i64* %a.2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %bc.a.2)
  call void @init(i64* sret(i64) align 8 %a.2)
  store i8 0, i8* %bc.a.2
  call void @llvm.memcpy.p0i8.p0i8.i64(i8* %bc.a.1, i8* %bc.a.2, i64 8, i1 false)
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %bc.a.2)
  ;call void @clobber(i8* %bc.a.2)
  %call = call i1 @check(i64* byval(i64) align 8 %a.1)
  ret i1 %call
}

; There is a call clobbering %a.2 before the call to @check. Cannot replace
; %a.1 with %a.2 in the call to @check.
define i1 @alloca_forwarding_call_clobber() {
; CHECK-LABEL: @alloca_forwarding_call_clobber(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_1:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[A_2:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[BC_A_1:%.*]] = bitcast i64* [[A_1]] to i8*
; CHECK-NEXT:    [[BC_A_2:%.*]] = bitcast i64* [[A_2]] to i8*
; CHECK-NEXT:    call void @llvm.lifetime.start.p0i8(i64 8, i8* [[BC_A_2]])
; CHECK-NEXT:    call void @init(i64* sret(i64) align 8 [[A_2]])
; CHECK-NEXT:    store i8 0, i8* [[BC_A_2]], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* [[BC_A_1]], i8* [[BC_A_2]], i64 8, i1 false)
; CHECK-NEXT:    call void @clobber(i8* [[BC_A_2]])
; CHECK-NEXT:    [[CALL:%.*]] = call i1 @check(i64* byval(i64) align 8 [[A_1]])
; CHECK-NEXT:    ret i1 [[CALL]]
;
entry:
  %a.1 = alloca i64, align 8
  %a.2 = alloca i64, align 8
  %bc.a.1 = bitcast i64* %a.1 to i8*
  %bc.a.2 = bitcast i64* %a.2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %bc.a.2)
  call void @init(i64* sret(i64) align 8 %a.2)
  store i8 0, i8* %bc.a.2
  call void @llvm.memcpy.p0i8.p0i8.i64(i8* %bc.a.1, i8* %bc.a.2, i64 8, i1 false)
  call void @clobber(i8* %bc.a.2)
  %call = call i1 @check(i64* byval(i64) align 8 %a.1)
  ret i1 %call
}

define i1 @alloca_forwarding_call_clobber_after() {
; CHECK-LABEL: @alloca_forwarding_call_clobber_after(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_1:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[A_2:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[BC_A_1:%.*]] = bitcast i64* [[A_1]] to i8*
; CHECK-NEXT:    [[BC_A_2:%.*]] = bitcast i64* [[A_2]] to i8*
; CHECK-NEXT:    call void @llvm.lifetime.start.p0i8(i64 8, i8* [[BC_A_2]])
; CHECK-NEXT:    call void @init(i64* sret(i64) align 8 [[A_2]])
; CHECK-NEXT:    store i8 0, i8* [[BC_A_2]], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* [[BC_A_1]], i8* [[BC_A_2]], i64 8, i1 false)
; CHECK-NEXT:    [[CALL:%.*]] = call i1 @check(i64* byval(i64) align 8 [[A_2]])
; CHECK-NEXT:    call void @clobber(i8* [[BC_A_2]])
; CHECK-NEXT:    ret i1 [[CALL]]
;
entry:
  %a.1 = alloca i64, align 8
  %a.2 = alloca i64, align 8
  %bc.a.1 = bitcast i64* %a.1 to i8*
  %bc.a.2 = bitcast i64* %a.2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %bc.a.2)
  call void @init(i64* sret(i64) align 8 %a.2)
  store i8 0, i8* %bc.a.2
  call void @llvm.memcpy.p0i8.p0i8.i64(i8* %bc.a.1, i8* %bc.a.2, i64 8, i1 false)
  %call = call i1 @check(i64* byval(i64) align 8 %a.1)
  call void @clobber(i8* %bc.a.2)
  ret i1 %call
}

define i1 @alloca_forwarding_unrelated_call_noclobber() {
; CHECK-LABEL: @alloca_forwarding_unrelated_call_noclobber(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_1:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[A_2:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[A_3:%.*]] = alloca i64, align 8
; CHECK-NEXT:    [[BC_A_1:%.*]] = bitcast i64* [[A_1]] to i8*
; CHECK-NEXT:    [[BC_A_2:%.*]] = bitcast i64* [[A_2]] to i8*
; CHECK-NEXT:    call void @llvm.lifetime.start.p0i8(i64 8, i8* [[BC_A_2]])
; CHECK-NEXT:    call void @init(i64* sret(i64) align 8 [[A_2]])
; CHECK-NEXT:    store i8 0, i8* [[BC_A_2]], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* [[BC_A_1]], i8* [[BC_A_2]], i64 8, i1 false)
; CHECK-NEXT:    [[BC_A_3:%.*]] = bitcast i64* [[A_3]] to i8*
; CHECK-NEXT:    call void @clobber(i8* [[BC_A_3]])
; CHECK-NEXT:    [[CALL:%.*]] = call i1 @check(i64* byval(i64) align 8 [[A_2]])
; CHECK-NEXT:    ret i1 [[CALL]]
;
entry:
  %a.1 = alloca i64, align 8
  %a.2 = alloca i64, align 8
  %a.3 = alloca i64, align 8
  %bc.a.1 = bitcast i64* %a.1 to i8*
  %bc.a.2 = bitcast i64* %a.2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %bc.a.2)
  call void @init(i64* sret(i64) align 8 %a.2)
  store i8 0, i8* %bc.a.2
  call void @llvm.memcpy.p0i8.p0i8.i64(i8* %bc.a.1, i8* %bc.a.2, i64 8, i1 false)
  %bc.a.3 = bitcast i64* %a.3 to i8*
  call void @clobber(i8* %bc.a.3)
  %call = call i1 @check(i64* byval(i64) align 8 %a.1)
  ret i1 %call
}

