BEGIN;
-- Chart of Accounts for France
-- according to Autorité des normes comptables de France, rule #2014-03
-- sample only, Plan de comptes général, système développé
--
-- Add wrapper for lisibility. It will vanish at the end of this transaction
CREATE OR REPLACE FUNCTION pg_temp._account_heading_save
(in_id int, in_accno text, in_description text, in_accno_parent text)
RETURNS int AS
$$
DECLARE parent_id int;
BEGIN
        SELECT id INTO parent_id
        FROM account_heading
        WHERE accno = in_accno_parent;
        RETURN account_heading_save(in_id, in_accno, in_description, parent_id);
END;
$$ LANGUAGE PLPGSQL;

SELECT account_heading_save(NULL, '000', '', NULL);
SELECT pg_temp._account_heading_save(NULL,'1', 'Classe 1: Comptes de capitaux', '000');
--
SELECT account__save(NULL,'101', 'Capital','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1011', 'Capital souscrit non appelé','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1012', 'Capital souscrit appelé non versé','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1013', 'Capital souscrit appelé versé','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'10131', 'Capital non amorti','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'10132', 'Capital amorti','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1018', 'Capital souscr. à règlem. part.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'104', 'Primes liées au capital social','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1041', 'Primes d''émission','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1042', 'Primes de fusion','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1043', 'Primes d''apport','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1044', 'Primes convers. obligat. actions','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1045', 'Bons de souscription d''action','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'105', 'Écarts de réévaluation','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1051', 'Réserve spéciale de réévaluation','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1052', 'Écart de réévaluation libre','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1053', 'Réserve de réévaluation','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1055', 'Écarts rééval. (aut. oper. leg.)','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1057', 'Aut. écarts rééval. en france','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1058', 'Aut. écarts rééval. à l''etranger','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'106', 'Réserves','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1061', 'Réserve legale','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'10611', 'Réserve legale proprement dite','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'10612', 'Plus-values nettes à long terme','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1062', 'Réserves indisponibles','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1063', 'Réserves statut. ou contractuelles','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1064', 'Réserves reglementées','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'10641', 'Plus-values nettes à long terme','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'10643', 'Réser. consec. octroi subv. invest','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'10648', 'Autres réserves réglementées','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1068', 'Autres réserves','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'10681', 'Réserve de propre assureur','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'10688', 'Réserves diverses','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'107', 'Écart d''équivalence','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
--TODO: I? E? ==> A/L ?
SELECT account__save(NULL,'108','Compte de l''exploitant','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1081','Compte de l''exploitant','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'109', 'Actionn. capital sousc. non appelé','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'11', 'Report à nouveau (solde créditeur)','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'119', 'Report à nouveau (solde débiteur)','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'12', 'Résultat de l''exercice (bénéfice)','Q',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'129', 'Résultat de l''exercice (perte)','Q',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'131', 'Subventions d''équipement','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1311', 'État','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1312', 'Régions','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1313', 'Départements','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1314', 'Communes','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1315', 'Collectivités publiques','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1316', 'Entreprises publiques','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1317', 'Entreprises et organismes privés','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1318', 'Autres','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'138', 'Autres subventions d''investis.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'139', 'Subv. inves. insc. au cpte résult.','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1391', 'Subventions d''équipement','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'13911', 'État','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'13912', 'Régions','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'13913', 'Départements','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'13914', 'Communes','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'13915', 'Collectivités publiques','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'13916', 'Entreprises publiques','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'13917', 'Entreprises et organismes privés','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'13918', 'Autres','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1398', 'Autres subventions d''investis.','L',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'142', 'Provis. réglem. relativ. aux immo.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1423', 'Provis. pour reconstitution gis.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1424', 'Provis. investis. (partic. salar.)','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'143', 'Provis. réglement. relativ. stocks','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1431', 'Hausse des prix','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1432', 'Fluctuation des cours','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'144', 'Provis. réglem. relat. élem. actif','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'145', 'Amortissements dérogatoires','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'146', 'Provision spéciale de réévaluation','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'147', 'Plus-values réinvesties','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'148', 'Autres provisions réglementées','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'151', 'Provisions pour risques','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1511', 'Provisions pour litiges','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1512', 'Prov. garant. données aux clients','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1513', 'Prov. pertes sur marches à terme.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1514', 'Provis. pour amendes et pénalités','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1515', 'Provis. pour pertes de change','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1518', 'Autres provisions pour risques','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'153', 'Provis. pensions et oblig. simil.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'155', 'Provisions pour impôts','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'156', 'Provis. renouv. immo (ets concess)','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'157', 'Prov. charg. à repart. sur exerc.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1572', 'Provis. pour grosses réparations','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'158', 'Autres provisions pour charges','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1582', 'Provis. charg. socia. fisc. sur cp','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'161', 'Emprunts obligatoires convertibles','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'163', 'Autres emprunts obligataires','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'164', 'Emprunts aupres établis. de crédit','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'165', 'Dépôts et cautionnements reçus','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1651', 'Dépôts','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1655', 'Cautionnements','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'166', 'Particip. salariés aux résultats','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1661', 'Comptes bloqués','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1662', 'Fonds de participation','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'167', 'Empr. dettes assort. condit. part.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1671', 'Émission de titres participatifs','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1674', 'Avances conditionnées de l''état','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1675', 'Emprunts participatifs','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'168', 'Autres empr. et dettes assimilées','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1681', 'Autres emprunts','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1685', 'Rentes viagères capitalisées','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1687', 'Autres dettes','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1688', 'Intérêts courus','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'16881', 'Sur empr. obligatair. convertibles','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'16883', 'Sur autres emprunts obligataires','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'16884', 'Sur emprunts auprès établi. crédit','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'16885', 'Sur dépôts et cautionnements reçus','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'16886', 'Sur particip. salar. résultats ets','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'16887', 'Sur empr. dettes assor. cond. part','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'16888', 'Sur autres empr. dettes assimilées','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'169', 'Primes remboursement obligations','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'171', 'Dettes rattach. à partic. (groupe)','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'174', 'Dettes ratt. à part. (hors groupe)','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'178', 'Dettes rattach. à stes en partic.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1781', 'Principal','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'1788', 'Intérêts courus','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'181', 'Compte de liaison établissements','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'186', 'Biens prest. serv. ech. (charges)','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'187', 'Biens prest. serv. ech. (produits)','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'188', 'Comptes de liaison stes en partic.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
--
SELECT account_heading_save(NULL,'2', 'Classe 2: Comptes d''immobilisations', null);
--
SELECT account__save(NULL,'201','Frais d''établissement','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2011', 'Frais de constitution','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2012', 'Frais de premier établissement','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'20121', 'Frais de prospection','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'20122', 'Frais de publicité','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2013', 'Frais augmen. capit. opér. divers.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'203', 'Frais recherche et développement','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'205', 'Concessions et droits similaires','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'206', 'Droit au bail','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'207', 'Fonds commercial','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'208', 'Autres immobilisations incorpor.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'209','Sortie d''immobilisation','A',NULL, NULL, true, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'211', 'Terrains','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2111', 'Terrains nus','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2112', 'Terrains aménagés','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2113', 'Sous-sols et sur-sols','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2114', 'Terrains de gisement','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21141', 'Carrières','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2115', 'Terrains bâtis','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21151', 'Ensembles  immobiliers industriels','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21155', 'Ensembles immob. adm. et commerc.','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21158', 'Autres ensembles immobiliers','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'211581', 'Affectes aux opérat. profession.','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'211588', 'Affectes aux opérat. non prof.','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2116', 'Compte d''ordre sur immobilisations','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'212', 'Agencements aménagements terrains','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'213', 'Constructions','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2131', 'Bâtiments','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21311', 'Ensembles immob. industriels','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21315', 'Ensembles immob. adm. et commerc.','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21318', 'Autres ensembles immobiliers','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'213181', 'Affectés aux opérat. profession.','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'213188', 'Affectés aux opérat. non prof.','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2135', 'Installations générales','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2138', 'Ouvrages d''infrastructure','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21381', 'Voies de terre','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21382', 'Voies de fer','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21383', 'Voies d''eau','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21384', 'Barrages','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21385', 'Pistes d''aérodromes','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'214', 'Constructions sur sol d''autrui','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'215', 'Install. tech. mat. outil. indus.','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2151', 'Install. complexes specialisées','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21511', 'Sur sol propre','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21514', 'Sur sol d''autrui','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2153', 'Install. à caractère spécifique','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21531', 'Sur sol propre','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'21534', 'Sur sol d''autrui','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2154', 'Matériel industriel','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2155', 'Outillage industriel','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2157', 'Agencem. aménag. mat. outil. indus','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'218', 'Autres immobilisations corporelles','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2181', 'Install. gene. agenc. aménag. div.','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2182', 'Matériel de transport','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2183', 'Matériel de bureau et informatique','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2184', 'Mobilier','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2185', 'Cheptel','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2186', 'Emballages récupérables','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'231', 'Immobilisat. corporelles en cours','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2312', 'Terrains','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2313', 'Constructions','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2315', 'Install. tech. mat. outil. indust.','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2318', 'Autres immobilisations corporelles','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'232', 'Immo. incorporelles en cours','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'237', 'Avanc. acompt. versés sur imm. inc','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'238', 'Avanc. acomp. versés cdes imm. cor','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2382', 'Terrains','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2383', 'Constructions','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2385', 'Install. tech. mat. outil. indust.','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'2388', 'Autres immobilisations corporelles','A',NULL, NULL, false, false, string_to_array('Fixed_Asset', ':'), false, false);
SELECT account__save(NULL,'261', 'Titres de participation','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2611', 'Actions','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2618', 'Autres titres','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'266', 'Autres formes de participation','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'267', 'Créances rattachées à participat.','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2671', 'Créances ratt. à part. (groupe)','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2674', 'Créanc. ratt. part. (hors groupe)','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2675', 'Versem. d''apports non capitalisés','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2676', 'Avances consolidables','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2677', 'Autres créances ratt. à part.','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2678', 'Intérêts courus','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'268', 'Créances ratt. à ste en part.','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2681', 'Principal','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2688', 'Intérêts courus','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'269', 'Vers. rest. à effect. sur t.p.n.l.','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'271', 'Titres immobilisés (droit prop.)','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2711', 'Actions','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2718', 'Autres titres','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'272', 'Titres immobilisés (droit créance)','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2721', 'Obligations','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2722', 'Bons','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'273', 'Titres immobilisés de l''act. de portef.','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'274', 'Prêts','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2741', 'Prêts participatifs','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2742', 'Prêts aux associes','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2743', 'Prêts au personnel','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2748', 'Autres prêts','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'275', 'Dépôts et cautionnements versés','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2751', 'Dépôts','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2755', 'Cautionnements','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'276', 'Autres créances immobilisées','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2761', 'Créances diverses','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2768', 'Intérêts courus','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'27682', 'Sur titres immob. (droit créance)','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'27684', 'Sur prêts','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'27685', 'Sur dépôts et cautionnements','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'27688', 'Sur créances diverses','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2771', 'Actions propres ou parts propres','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'2772', 'Act. pro. ou parts pro. voie d''annul.','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'279', 'Versem. à effect. sur t.i.n.l.','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
-- Amortissements
SELECT account__save(NULL,'28', 'Amortiss. immobilisations incorp.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2801', 'Frais d''établissement','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2803', 'Frais de recherche et développ.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2805', 'Concessions et droits similaires','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2807', 'Fonds commercial','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2808', 'Autres immobilisations incorpor.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'281', 'Amortiss. immobilisations corpor.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2811', 'Terrains de gisement','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2812', 'Agencements aménagements terrains','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2813', 'Constructions','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2814', 'Constructions sur sol d''autrui','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2815', 'Install tech. mat. outil. indust.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2818', 'Autres immobilisations corporelles','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'282', 'Amortiss. immobil. en concession','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
-- Dépréciations
SELECT account__save(NULL,'29', 'Provis. dépréciation immob. incorp','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2905', 'Marques procédés droits et valeurs','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2906', 'Droit au bail','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2907', 'Fonds commercial','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2908', 'Autres immob. incorporelles','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'291', 'Provis. dépréciation immob. corpor','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2911', 'Terrains (autres que gisement)','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'292', 'Provis. dépréciat. immob. concess.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'293', 'Provis. dépréciat. immob. en cours','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2931', 'Immobilisations corpor. en cours','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2932', 'Immo. incorporelles en cours','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'296', 'Prov. dépréc. part et créanc. part','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2961', 'Titres de participation','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2966', 'Autres formes de participation','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2967', 'Créances ratt. à participation','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2968', 'Créances ratt. à ste en particip.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'297', 'Provis. dépréciation autres immob.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2971', 'Titres immobilisés droit propriété','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2972', 'Titres immobilisés droit créance','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2973', 'Titres immo. de l''act. de portef.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2974', 'Prêts','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2975', 'Dépôts et cautionnements versés','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'2976', 'Autres créances immobilisées','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
--
SELECT account_heading_save(NULL,'3', 'Classe 3: Comptes de stocks et en-cours', null);
--
SELECT account__save(NULL,'311', 'Matière (ou groupe) a','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'312', 'Matière (ou groupe) b','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'317', 'Fournitures a, b, c...','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'321', 'Matières consommables','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3211', 'Matière (ou groupe) c','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3212', 'Matière (ou groupe) d','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'322', 'Fournitures consommables','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3221', 'Combustibles','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3222', 'Produits d''entretien','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3223', 'Fournitures d''atelier et d''usine','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3224', 'Fournitures de magasin','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3225', 'Fournitures de bureau','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'326', 'Emballages','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3261', 'Emballages perdus','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3265', 'Embal. récupér. non identifiables','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3267', 'Emballages à usage mixte','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'331', 'Produits en cours','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3311', 'Produits en cours p1','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3312', 'Produits en cours p2','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'335', 'Travaux en cours','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3351', 'Travaux en cours t1','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3352', 'Travaux en cours t2','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'341', 'Études en cours','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3411', 'Étude en cours e1','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3412', 'Étude en cours e2','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'345', 'Prestations de services en cours','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3451', 'Prestation de services s1','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3452', 'Prestation de services s2','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'351', 'Produits intermédiaires','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3511', 'Produit intermédiaire (ou grpe) a','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3512', 'Produit intermédiaire (ou grpe) b','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'355', 'Produits finis','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3551', 'Produit fini (ou groupe) a','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3552', 'Produit fini (ou groupe) b','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'358', 'Prod. résiduels (ou mat. récup.)','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3581', 'Déchets','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3585', 'Rebuts','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3586', 'Matières de récupération','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'371', 'Marchandise (ou groupe) a','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'372', 'Marchandise (ou groupe) b','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'391', 'Provis. pour dépréciat. mat. prem.','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3911', 'Matière (ou groupe) a','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3912', 'Matière (ou groupe) b','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3917', 'Fourniture a, b, c...','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'392', 'Provis. pour dépréciat. aut. appro','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3921', 'Matières consommables','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3922', 'Fournitures consommables','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3926', 'Emballages','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'393', 'Prov. dépréc. en-cours prod. biens','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3931', 'Produits en cours','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3935', 'Travaux en cours','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'394', 'Prov. dépréc. en-cours prod. serv.','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3941', 'Études en cours','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3945', 'Prestations de services en cours','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'395', 'Prov. pour dépréc. stocks de prod.','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3951', 'Produits intermédiaires','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3955', 'Produits finis','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'397', 'Prov. pour dépréc. stocks marchan.','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3971', 'Marchandise ou groupe a','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'3972', 'Marchandise ou groupe b','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
--
SELECT account_heading_save(NULL,'4', 'Classe 4: Comptes de tiers', null);
--
SELECT account__save(NULL,'40', 'Fournisseurs et comptes rattaches','L',NULL, NULL, false, false, string_to_array('AP', ':'), false, false);
SELECT account__save(NULL,'401', 'Fournisseurs divers','L',NULL, NULL, false, false, string_to_array('AP', ':'), false, false);
SELECT account__save(NULL,'403', 'Fournisseurs - effets à payer','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'404', 'Fournisseurs d''immobilisations','L',NULL, NULL, false, false, string_to_array('AP', ':'), false, false);
SELECT account__save(NULL,'4041', 'Fournisseurs achats d''immobilisat.','L',NULL, NULL, false, false, string_to_array('AP', ':'), false, false);
SELECT account__save(NULL,'4047', 'Fournis. d''immob. retenues de gar.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'405', 'Fournis. d''immob. effets à payer','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'408', 'Fournis. factures non parvenues','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4081', 'Fournisseurs','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4084', 'Fournisseurs d''immobilisations','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4088', 'Fournisseurs intérêts courus','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'409', 'Fournisseurs débiteurs','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4091', 'Fournis. avanc. & acompt. sur cdes','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4096', 'Fourn. créan. emb. & mat. à rendre','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4097', 'Fournisseurs autres avoirs','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'40971', 'Fournisseurs d''exploitation','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'40974', 'Fournisseurs d''immobilisations','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4098', 'Rabais remises ristour. à obtenir','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'41', 'Clients et comptes rattachés','A',NULL, NULL, false, false, string_to_array('AR', ':'), false, false);
SELECT account__save(NULL,'411', 'Clients divers','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'413', 'Clients effets à recevoir','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'416', 'Clients douteux ou litigieux','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'417', 'Créanc. sur trav. non encore fact.','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'418', 'Clients produits non encore fact.','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'4181', 'Clients factures à établir','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'4188', 'Clients intérêts courus','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'419', 'Clients créditeurs','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'4191', 'Clts avanc. & acomp. reçus sur cde','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'4196', 'Clts dett. pour emb. & mat. consig','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'4197', 'Clients - autres avoirs','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'4198', 'Rabais remises rist. à accorder','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'421', 'Personnel rémunérations dûes','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'422', 'Comités d''entreprise, d''établis.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'424', 'Particip. des salar. aux résultats','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4246', 'Réserve spéciale (art l442.2)','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4248', 'Comptes courants','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'425', 'Personnel avances et acomptes','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'426', 'Personnel dépôts','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'427', 'Personnel oppositions','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'428', 'Pers. charg. à pay. & prod. à rec.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4282', 'Dettes provisio. pour congés payés','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4284', 'Dett. prov. part. sal. aux résult.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4286', 'Autres charges à payer','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4287', 'Produits à recevoir','A',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'431','Sécurité sociale','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'437','Autres organismes sociaux','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'438', 'Org. soc. charg. à pay. & prod.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4382', 'Charges sociales sur congés payés','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4386','Autres charges à payer','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4387', 'Produits à recevoir','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'441', 'États subventions à recevoir','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4411', 'Subventions d''investissement','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4417', 'Subventions d''exploitation','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4418', 'Subventions d''équilibre','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4419', 'Avances sur subventions','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'442', 'État imp. & tax. recouv. sur tiers','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4424', 'Obligataires','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4425', 'Associés','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'443', 'Opérations part. avec l''état,...','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4431', 'Créances état suppr. décal. TVA','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4438', 'Intérêts courus créances cpte 4431','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'444', 'État impôts sur les bénéfices','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4445', 'État taxes sur le chiffre d''aff.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4452', 'TVA due intracommunautaire','L',NULL, NULL, false, true, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4455', 'Taxes sur ca à decaisser','L',NULL, NULL, false, true, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'44551', 'TVA à décaisser','L',NULL, NULL, false, true, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'44558', 'Taxes assimilées à TVA','L',NULL, NULL, false, true, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4456', 'Taxes sur le ca déductibles','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445621', 'TVA sur immo.  5.5%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart', ':'), false, false);
SELECT account__save(NULL,'445622', 'TVA sur immo. 20.6%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart', ':'), false, false);
SELECT account__save(NULL,'445623', 'TVA sur immo. 19.6%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart', ':'), false, false);
SELECT account__save(NULL,'44563', 'TVA transférée par d''autres ets','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart', ':'), false, false);
SELECT account__save(NULL,'445661','TVA déductible 5.5%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445662', 'TVA déductible 20.6%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445663','TVA déductible 19.6%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'44567', 'Crédit de TVA à reporter','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'44568', 'Taxes assimilées à la TVA','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'4457', 'Taxe sur le c.a. collect. entrepr.','A',NULL, NULL, false, false, string_to_array('AR_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445711','TVA collectée 5.5%','A',NULL, NULL, false, false, string_to_array('AR_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445712', 'TVA collectée 20.6%','A',NULL, NULL, false, false, string_to_array('AR_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445713','TVA collectée 19.6%','A',NULL, NULL, false, false, string_to_array('AR_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'4458', 'Taxes sur ca à regular. ou en att.','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'44581', 'Acomptes regime simplifié d''impos.','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'44582', 'Acomptes regime du forfait','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'44583', 'Rembours. taxes sur ca demandé','A',NULL, NULL, false, false, string_to_array('AR_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'44584', 'TVA récupérée d''avance','A',NULL, NULL, false, false, string_to_array('AR_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445861', 'TVA en attente déductible  5.5%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445862', 'TVA en attente déductible 20.6%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445863', 'TVA en attente déductible 19.6%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445871', 'TVA en attente collectée  5.5%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445872', 'TVA en attente collectée 20.6%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'445873', 'TVA en attente collectée 19.6%','L',NULL, NULL, false, true, string_to_array('AP_tax:IC_taxpart:IC_taxservice', ':'), false, false);
SELECT account__save(NULL,'446', 'Titres sur TVA','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4461', 'Obligations cautionnées','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4469', 'Créance TVA décalage d''un mois','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'447', 'Autres impôts, tax. et vers. assim','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'448', 'État charg. à pay. & prod. à recev','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4482', 'Charges fiscales sur cong. à payer','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4486', 'Autres charges à payer','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4487', 'Produits à recevoir','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'451', 'Groupe','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'455', 'Associés comptes courants','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4551', 'Principal','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4558', 'Intérêts courus','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'456', 'Associés opérations sur le capital','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4561', 'Associés comptes d''apport en ste','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'45611', 'Apports en nature','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'45615', 'Apports en numéraire','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4562', 'Apporteurs capit. appelé non versé','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'45621', 'Action. cap. sousc. app. non versé','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'45625', 'Associés capital appelé non versé','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4563', 'Assoc. vers. reçus sur augm. capit','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4564', 'Associés versements anticipés','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4566', 'Actionnaires défaillants','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4567', 'Associés capital à rembourser','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'457', 'Associés dividendes à payer','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'458', 'Assoc. opérat. en commun et en gie','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4581', 'Opérations courantes','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4588', 'Intérêts courus','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'462', 'Créances sur cessions d''immobilis.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'464', 'Dettes sur acquis. valeurs mobi.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'465', 'Créanc. sur cessions valeurs mob.','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'467', 'Autres comptes débit. ou crédit.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4672', 'Débours payés','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'468', 'Divers charg. à pay. & prod. à rec','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4686', 'Charges à payer','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4687', 'Produits à recevoir','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'471', 'Comptes d''attente','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4711', 'Réimputation','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'472','Moins values à court terme','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'473','Divers à déduire','L',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'474','Déficit SCM','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4741','Divers à réintegrer','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4742','Bénéfice SCM','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'475','Plus values à court terme','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'476', 'Différences de conversion actif','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4761', 'Diminution des créances','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4762', 'Augmentation des dettes','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4768', 'Différ. compens. par couv. change','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'477', 'Différences de conversion passif','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4771', 'Augmentation des créances','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4772', 'Diminution des dettes','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4778', 'Différ. compens. par couv. change','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'478', 'Autres comptes transitoires','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'481', 'Charg. à repart. sur plus. exerc.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4811', 'Charges différées','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4812', 'Frais d''acquisition des immobilis.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4816', 'Frais d''émission des emprunts','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4818', 'Charges à étaler','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'486', 'Charges constatées d''avance','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'487', 'Produits constatés d''avance','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'488', 'Cptes répart. pério. charg. & prod','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4886', 'Charges','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4887', 'Produits','L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'491', 'Provis. pour dépréc. cptes clients','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'495', 'Prov. pour dépréc. cptes grpe ass','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4951', 'Comptes du groupe','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4955', 'Comptes courants des associés','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4958', 'Opérat. faites en commun & en gie','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'496', 'Provis. pour dépréc. cptes débit.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4962', 'Créances sur cessions d''immobilis.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4965', 'Créanc. sur cessions valeurs mob.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'4967', 'Autres comptes débiteurs','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
--
SELECT account_heading_save(NULL,'5', 'Classe 5: Comptes financiers', null);
--
SELECT account__save(NULL,'501', 'Parts dans des entreprises liées','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'502', 'Actions propres','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'503', 'Actions','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5031', 'Titres cotés','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5035', 'Titres non cotés','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'504', 'Autres titres conférant droit prop','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'505', 'Oblig. & bons émis par la société','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'506', 'Obligations','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5061', 'Titres cotés','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5065', 'Titres non cotés','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'507', 'Bons trésor & bons caisse à ct','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'508', 'Autres valeurs mob. et créanc. ass','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5081', 'Autres valeurs mobilières','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5082', 'Bons de souscription','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5088', 'Intér. courus sur obligations bons','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'509', 'Vers. à effect. sur valeurs mobil.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'511', 'Valeurs à l''encaissement','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5111', 'Coupons echus à l''encaissement','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5112', 'Chèques à encaisser','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5113', 'Effets à l''encaissement','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5114', 'Effets à l''escompte','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'512','Banque','A',NULL, NULL, false, false, string_to_array('AR_paid:AP_paid', ':'), false, false);
SELECT account__save(NULL,'51201','Banque crédit','I',NULL, NULL, false, false, string_to_array('AR_amount', ':'), false, false);
SELECT account__save(NULL,'51202','Banque débit','E',NULL, NULL, false, false, string_to_array('AP', ':'), false, false);
SELECT account__save(NULL,'51203','Épargne','A',NULL, NULL, false, false, string_to_array('AR_paid:AP_paid', ':'), false, false);
SELECT account__save(NULL,'51204','Exploitant','E',NULL, NULL, false, false, string_to_array('AP_paid', ':'), false, false);
SELECT account__save(NULL,'5121', 'Comptes en monnaie nationale','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5124', 'Comptes en devises','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'514', 'Chèques postaux','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'515', 'Caisses du trésor et ets publics','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'516', 'Société de bourse','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'517', 'Autres organismes financiers','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'518', 'Intérêts en cours', 'A',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'5186', 'Intérêts courus à payer', 'L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5187', 'Intérêts courus à recevoir', 'A',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'519', 'Concours bancaires courants', 'L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5191', 'Crédit mobil. créanc. cciales cmcc','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5193', 'Mobil. créances nées à l''étranger','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5198', 'Int. courus sur concours bancaires', 'L',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'52', 'Instruments de trésorerie','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'53','Caisse','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'531', 'Caisse siège social','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5311', 'Caisse en monnaie nationale','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5314', 'Caisse en devises','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'532', 'Caisse succursale (ou usine) a','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'533', 'Caisse succursale (ou usine) b','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'58','Virement interne','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5801', 'Virement de trésorerie à trésorerie','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'59', 'Provis. pour dépréc. valeurs mob.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5903', 'Actions','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5904', 'Autres tit. conférant droit prop.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5906', 'Obligations','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'5908', 'Autres valeurs mob. & créanc. ass.','A',NULL, NULL, false, false, string_to_array('', ':'), false, false);
--
SELECT account_heading_save(NULL,'6', 'Classe 6: Comptes de charges', null);
--
SELECT account__save(NULL,'601','Achats stockés mat. prem. (fourn.)','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'6011', 'Matière (ou groupe) a','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'6012', 'Matière (ou groupe) b','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'6017', 'Fournitures a, b, c...','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'602', 'Achats stockés autres approv.','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'6021', 'Matières consommables','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'60211', 'Matière (ou groupe) c','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'60212', 'Matière (ou groupe) d','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'6022', 'Fournitures consommables','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'60221', 'Combustibles','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'60222', 'Produits d''entretien','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'60223', 'Fournitures d''atelier / usines','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'60224', 'Fournitures de magasins','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'60225', 'Fournitures de bureau','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'6026', 'Emballages','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'60261', 'Emballages perdus','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'60265', 'Emball. reçupera. non identif.','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'60267', 'Emballages à usage mixte','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'603', 'Variation des stocks','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'6031', 'Variat. stocks mat. prem. et fourn','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'6032', 'Variat. stocks autres approvision.','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'6037', 'Variation stocks de marchandises','E',NULL, NULL, false, false, string_to_array('AP_amount:IC_cogs', ':'), false, false);
SELECT account__save(NULL,'604', 'Achats études et prestat. services','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'605', 'Achats matériel équipem. travaux','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'606', 'Achats non stockés de mat. prem.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6061','Fournitures non stock. eau énerg.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6063','Fournit. entretien & petit équip.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6064', 'Fournitures administratives','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6065', 'Achats spéciaux','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6068', 'Autres matières et fournitures','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'607','Achats de marchandises','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6071', 'Marchandise (ou groupe) a','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6072', 'Marchandise (ou groupe) b','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'608', 'Frais accessoires d''achat','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'609', 'Rabais remises rist. sur achats','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6091', 'De matières premières (et fourn.)','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6092', 'D''autres approvisionn. stockés','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6094','Rabais d''études & prestations de services', 'E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6095', 'De materiel équipements de travaux','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6096', 'D''approvisionnements non stockés','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6097', 'De marchandises','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6098', 'Rabais remises rist. non affectés','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'611','Sous-traitance générale','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'612', 'Redevances de crédit-bail','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6122', 'Crédit-bail mobilier','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6125', 'Crédit-bail immobilier','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'613', 'Locations','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6132','Locations immobilières','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6135','Locations mobilières','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6136', 'Malis sur emballages', 'E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'614', 'Charges locatives & de copropriété','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'615','Entretien et réparations','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6152', 'Sur biens immobiliers', 'E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6155', 'Sur biens mobiliers','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6156', 'Maintenance','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'616','Primes d''assurance','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6161', 'Multirisques','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6162', 'Assur. obligat. dommage-construct.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6163', 'Assurance-transport','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'61636', 'Sur achats','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'61637', 'Sur ventes','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'61638', 'Sur autres biens','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6164', 'Risques d''exploitation','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6165', 'Insolvabilité clients','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'617','Études et recherches','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'618', 'Divers','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6181', 'Documentation générale','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6183','Documentation technique','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6185', 'Frais de colloques, sémin., confér','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'619', 'Rabais remises rist. sur serv. ext','E',NULL, NULL, true, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'621', 'Personnel extérieur à l''entreprise','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6211', 'Personnel intérimaire','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6214', 'Personnel détaché ou prêté à l''ets','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'622', 'Rémunérat. d''interm. et honoraires','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6221', 'Commissions & courtages sur achats','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6222', 'Commissions & courtages sur ventes','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6224', 'Rémunérations des transitaires','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6225', 'Rémunérations d''affacturage','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6226', 'Honoraires','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6227','Frais d''actes et de contentieux','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6228', 'Divers','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'623', 'Publicité publicat. relat. publiq.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6231', 'Annonces et insertions','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6232', 'Échantillons','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6233', 'Foires et expositions','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6234','Cadeaux à la clientèle','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6235', 'Primes','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6236', 'Catalogues et imprimés','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6237', 'Publications','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6238', 'Divers (pourboires, dons courants)','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'624', 'Transp. biens & transp. coll. pers','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6241', 'Transports sur achats','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6242', 'Transports sur ventes','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6243', 'Transports entre ets ou chantiers','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6244', 'Transports administratifs','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6247', 'Transports collectifs du personnel','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6248', 'Divers','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'625', 'Déplacem. missions et réceptions','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'62501','Déplacements auto','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'62502','Deplacements moto','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6251','Voyages et déplacements','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6255','Frais de déménagement','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6256','Missions','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6257','Réceptions','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'626','Frais postaux et télécommunic.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'627', 'Services bancaires et assimilés','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6271', 'Frais sur titres (achat, vente,.).','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6272', 'Commissions & frais sur emprunts','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6275', 'Frais sur effets (comm. d''endos,.)','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6276', 'Location de coffres','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6278', 'Autres frais & comm. prest. serv.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'628', 'Divers','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6281','Concours divers (cotisations,...)','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6284', 'Frais de recrutement du personnel','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'629', 'Rabais remises rist. sur serv. ext','E',NULL, NULL, true, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'631', 'Impôts taxes & vers. sur rémunér.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6311', 'Taxe sur les salaires','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6312', 'Taxe d''apprentissage','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6313', 'Part. employ. à form. prof. cont.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6314', 'Cotis. défaut invest. dans const.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6318', 'Autres','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'633', 'Impôts taxes & vers. sur rémunér.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6331', 'Versement sur le transport','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6332', 'Allocation logement','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6333', 'Part. employ. à form.  prof. cont.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6334', 'Part. employ. à effort construct.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6335', 'Vers. liberat. à exoner. taxe app.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6338','Autres','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'635', 'Autres impôts taxes & vers. ass.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6351', 'Impôts directs (sauf impôt bénéf.)','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'63511','Taxe professionnelle','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'63512', 'Taxes foncières','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'63513', 'Autres impôts locaux','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'63514', 'Taxe sur les véhicules sociétés','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6352', 'Taxes sur ca non récupérables','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6353', 'Impôts indirects','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6354', 'Droits d''enregistrement et timbre','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'63541', 'Droit de mutation','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6358', 'Autres droits','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'637', 'Autres impôts taxes et vers. ass.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6371', 'Contrib. soc. solid. à charge stes','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6372', 'Taxes percues par org. publics int','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6374', 'Impôts & taxes exigib. à l''étrang.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6378', 'Taxes diverses','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'641', 'Rémunérations du personnel','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6411', 'Salaires appoint. commis. de base','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6412', 'Conges payés','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6413', 'Primes et gratifications','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6414', 'Salaires, appointements','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6415', 'Supplément familial','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'644', 'Rémunération travail de l''exploit.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'645','Charges de secur. soc. et prevoy.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'645001','CSG','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6451','Cotisations à l''URSSAF','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6452','Cotisations aux mutueles','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6453','Cotisations aux caisses retr.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6458','Cotisations aux autres org. soc.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'646','Cotis. social. person. exploitant','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6464','Cotisations aux assedic','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'647', 'Autres charges sociales','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6471', 'Prestations directes','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6472', 'Vers. aux comités d''ets & d''étab.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6473', 'Vers. aux comités hygiène et sécur','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6474', 'Versements aux oeuvres sociales','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6475', 'Médecine du travail, pharmacie','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'648', 'Autres charges de personnel','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'651', 'Redevanc. concess. brèv. licenc,..','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6511', 'Redev. concess. brèv, lic, marq,..','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6516', 'Droits d''auteur et de reproduct.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6518', 'Autres droits & valeurs similaires','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'653', 'Jetons de présence','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'654', 'Pertes sur créances irrécouvrab.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6541', 'Créances de l''exercice','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6544', 'Créances des exercices antérieurs','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'655', 'Quote-parts résult. opér. en comm.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6551', 'Q-p bénéf. transf. (cpta gérant)','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6555', 'Quote-part perte supp. (cpta ass)','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'658', 'Charges diverses gestion courante','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'66','Charges financières','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'661', 'Charges d''intérêts','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6611', 'Intérêts des emprunts et dettes','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'66116', 'Des emprunts et dettes assimilées','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'66117', 'Des dettes ratt. à participations','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6615', 'Intérêts cptes cour. & dép. crédit','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6616', 'Intérêts banc. & sur opér. financ.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6617', 'Intérêts obligations cautionnées','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6618', 'Intérêts des autres dettes','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'66181', 'Des dettes commerciales','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'66188', 'Des dettes diverses','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'664', 'Pertes créances liees à particip.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'665', 'Escomptes accordés','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'666','Pertes de change','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'667', 'Charg. nettes sur cess. val. mobil','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'668', 'Autres charges financières','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6688', 'Écart de conversion','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'67','Charges financières','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'671', 'Charg. except. sur opérat. gestion','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6711', 'Pénalités sur marchés','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6712', 'Pénalités amendes fisc. & pénales','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6713', 'Dons, libéralités','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6714', 'Créanc. deven. irrécouv. sur bénéf','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6715', 'Subventions accordées','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6717', 'Rappel d''impôts (autre que bénéf)','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6718', 'Aut. charg. excep. sur opér. gest.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'672', 'Charges sur exercices antérieurs','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'675', 'Val. compt. des élem. actif cédés','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6751', 'Immobilisations incorporelles','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6752', 'Immobilisations corporelles','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6756', 'Immobilisations financières','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6758', 'Autres éléments d''actif','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'678', 'Autres charges exceptionnelles','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6781', 'Malis provenant de clauses indexat','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6782', 'Lots','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6783', 'Malis du rachat par ets d''actions','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6788', 'Charges exceptionnelles diverses','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'681','Dotations aux amort. & aux provis.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6811', 'Dotat. aux amort. des immob. corpo','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'68111', 'Immobilisations incorporelles','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'68112', 'Immobilisations corporelles','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6812', 'Dotat. aux amort. charg. exploit.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6815', 'Dotat. aux prov. risq. & charg. ex','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6816', 'Dotat. aux prov. dépréc. immob.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'68161', 'Immobilisations incorporelles','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'68162', 'Immobilisations corporelles','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6817', 'Dotat. aux prov. dépréc. actifs','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'68173','Stocks et en-cours','I',NULL, NULL, false, false, string_to_array('IC', ':'), false, false);
SELECT account__save(NULL,'68174', 'Créances','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'686', 'Dotat. aux amort. et aux provis.','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6861', 'Dot. aux amort. prime remb. oblig.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6865', 'Dot. aux prov. risq. & charg. fin.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6866', 'Dot. aux prov. dépréc. élém. finan','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'68662', 'Immobilisations financières','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'68665', 'Valeurs mobilières de placement','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6868', 'Autres dotations','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'687', 'Dotat. aux amort. et provisions','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6871', 'Dotat. aux amort. except. immob.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6872', 'Dotat. aux prov. réglem. (immob)','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'68725', 'Amortissements dérogatoires','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6873', 'Dotat. aux prov. règlem. (stocks)','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6874', 'Dotat. aux autres prov. règlement.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6875', 'Dotat. prov. risq. & charg. excep.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6876','Dotat. aux prov. dépréc. except.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'69','Particip. sal. / impôts sur bén.','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'691', 'Participations des salariés','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'695','Impôts sur les bénéfices','E',NULL, NULL, false, false, string_to_array('AP_amount', ':'), false, false);
SELECT account__save(NULL,'6951','Impôts dus en France','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6952', 'Contrib. additio. impot bénéfices','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6954', 'Impôts dus à l''étranger','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6955','Débours payés pour le compte','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'696', 'Supplément d''impôts','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'697', 'Imposition forf. anuelle','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'698', 'Intégration fiscale','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6981', 'Intégration fiscale - charges','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'6989', 'Intégration fiscale - produits','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'699', 'Produits rep. en arr. des déficits','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
--
SELECT account_heading_save(NULL,'7', 'Classe 7: Comptes de produits', null);
--
SELECT account__save(NULL,'701', 'Ventes de produits finis','I',NULL, NULL, false, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7011', 'Produit fini (ou groupe) a','I',NULL, NULL, false, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7012', 'Produit fini (ou groupe) b','I',NULL, NULL, false, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'702', 'Ventes de produits intermédiaires','I',NULL, NULL, false, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'703', 'Ventes de produits résiduels','I',NULL, NULL, false, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'704', 'Travaux', 'I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'7041', 'Travaux de categ. (ou activ.) a', 'I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'7042', 'Travaux de categ. (ou activ.) b', 'I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'705', 'Études', 'I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'706','Prestations de services','I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'707','Ventes de marchandises','I',NULL, NULL, false, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7071', 'Marchandise (ou groupe) a', 'I',NULL, NULL, false, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7072', 'Marchandise (ou groupe) b', 'I',NULL, NULL, false, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'708', 'Produits des activités annexes','I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'7081', 'Prod. serv. exploit. inter. person','I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'7082', 'Commissions et courtages','I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'7083', 'Locations diverses','I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'7084', 'Mise à dispos. personnel facturée','I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'7085', 'Ports et frais accessoires fact.','I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'7086', 'Bonis sur reprises emball. consig.','I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'7087', 'Bonificat. clts & primes ventes','I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'7088', 'Autres produits activités annexes','I',NULL, NULL, false, false, string_to_array('IC_income', ':'), false, false);
SELECT account__save(NULL,'709', 'Rabais remises rist. accord. à ets','I',NULL, NULL, true, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7091', 'Sur ventes de produits finis','I',NULL, NULL, true, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7092', 'Sur ventes produits intermédiaires','I',NULL, NULL, true, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7094', 'Sur travaux','I',NULL, NULL, true, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7095', 'Sur études','I',NULL, NULL, true, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7096', 'Sur prestations de services','I',NULL, NULL, true, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7097', 'Sur ventes marchandises','I',NULL, NULL, true, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'7098', 'Sur produits activités annexes','I',NULL, NULL, true, false, string_to_array('IC_sale', ':'), false, false);
SELECT account__save(NULL,'713', 'Variat. stocks (en-cours product.)','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7133', 'Variation en-cours produc. biens','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'71331', 'Produits en cours','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'71335', 'Travaux en cours','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7134', 'Variation en-cours prod. services','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'71341', 'Études en cours','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'71345', 'Prestations services en cours','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7135', 'Variation stocks de produits','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'71351', 'Produits intermédiaires','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'71355', 'Produits finis','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'71358', 'Produits résiduels','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'721', 'Immobilisations incorporelles','I',NULL, NULL, false, false, string_to_array('', ':'), false, false); -- A?
SELECT account__save(NULL,'722', 'Immobilisations corporelles','I',NULL, NULL, false, false, string_to_array('', ':'), false, false); -- A?
SELECT account__save(NULL,'740', 'Subventions d''exploitation','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'751', 'Redev. pour conces. brev. lic....','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7511', 'Redev. pour conces. brev. lic...','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7516', 'Droits d''auteur et de reproduction','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7518', 'Autres droits & valeurs similaires','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'752', 'Rev. immeub. non affect. act. prof','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'753', 'Jetons présence et remun. administ','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'754', 'Ristournes perçues coopératives','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'755', 'Quotes-parts résult. op. en commun','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7551', 'Quote-part perte transférée','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7555', 'Quote-part bénéfice attribuée','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'758', 'Produits divers gestion courante','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'76','Produits financiers','I',NULL, NULL, false, false, string_to_array('AR_amount', ':'), false, false);
SELECT account__save(NULL,'761', 'Produits de participations','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7611', 'Revenus titres de participation','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7616', 'Revenus autres formes particip.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'762', 'Produits autres immob. financ.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7621', 'Revenus des titres immobilisés','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7624', 'Revenus des prêts','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7627', 'Revenus créances immobilisées','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'763', 'Revenus des autres créances','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7631', 'Revenus créances commerciales','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7638', 'Revenus des créances diverses','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'764', 'Revenus valeurs mobil. placement','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'765', 'Escomptes obtenus','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'766','Gains de change','I','8', NULL, false, false, string_to_array('AR_amount:IC_income', ':'), false, false);
SELECT account__save(NULL,'767', 'Prod. nets sur cess. valeurs mob.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7671', 'Revenus cre. ratt. participations','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'768', 'Autres produits financiers','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'77','Produits exceptionnels','I',NULL, NULL, false, false, string_to_array('AR_amount', ':'), false, false);
SELECT account__save(NULL,'771', 'Produits except. sur opér. gestion','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7711', 'Dédits pénal. sur achats & ventes','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7713', 'Libéralités perçues','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7714', 'Rentrées sur créances amorties','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7715', 'Subventions d''équilibre','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7717', 'Dégrevem. impôts (aut. imp. benef)','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7718', 'Autres prod. except. sur op. gest.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'772', 'Produits sur exercices antérieurs','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'775', 'Produits cessions éléments d''actif','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7751', 'Immobilisations incorporelles','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7752', 'Immobilisations corporelles','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7756', 'Immobilisations financières','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7758', 'Autres éléments d''actif','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'777', 'Q-p subv. invest. au résult. exerc','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'778', 'Autres produits exceptionnels','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7781', 'Bonis provenant clauses d''indexat.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7782', 'Lots','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7783', 'Bonis rachat par ets act. & oblig.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7788', 'Produits exceptionnels divers','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'781', 'Reprises sur amortiss. & provis.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7811', 'Repris. amort. immob. corp. & inc','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78111', 'Immobilisations incorporelles','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78112', 'Immobilisations corporelles','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7815', 'Repris. provis. risq. & ch. exploi','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7816', 'Rep. prov. deprec. imm. corp & inc','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78161', 'Immobilisations incorporelles','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78162', 'Immobilisations corporelles','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7817', 'Repris. prov. dépréc. act. circul.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78173', 'Stocks et en-cours','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78174', 'Créances','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'786', 'Reprises sur provis. pour risques','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7865', 'Rep. prov. risq. & charg. financ.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7866', 'Repris. prov. dépréc. élém. financ','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78662', 'Immobilisations financières','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78665', 'Valeurs mobilières de placement','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'787', 'Reprises sur provisions','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7872', 'Reprises sur prov. règlementées','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78725', 'Amortissements dérogatoires','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78726', 'Provision spéciale de réévaluation','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'78727', 'Plus-values réinvesties','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7873', 'Reprises sur prov. réglementées','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7874', 'Repris. sur autres prov. règlement','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7875', 'Repris. prov. risq. & charg. expl.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'7876', 'Repris. prov. pour dépréc. except.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'791', 'Transferts de charges d''exploit.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'796', 'Transferts de charges financ.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
SELECT account__save(NULL,'797', 'Transferts de charges except.','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
--
SELECT account_heading_save(NULL,'8', 'Classe 8: Comptes spéciaux', null);
--
SELECT pg_temp._account_heading_save(NULL,'10', 'Capital et réserves', null);
SELECT pg_temp._account_heading_save(NULL,'20', 'Immobilisations incorporelles', null);
--SELECT pg_temp._account_heading_save(NULL,'30', '', null);
SELECT pg_temp._account_heading_save(NULL,'40', 'Fournisseurs et comptes rattachés', null);
SELECT pg_temp._account_heading_save(NULL,'50', 'Valeurs mobilières de placement', null);
SELECT pg_temp._account_heading_save(NULL,'60', 'Achats (sauf 603)', null);
SELECT pg_temp._account_heading_save(NULL,'603', 'Variation des stocks (approvisionnements et marchandises)', null);
SELECT pg_temp._account_heading_save(NULL,'70', 'Ventes de produits fabriqués prestations de services, marchandises', null);

SELECT pg_temp._account_heading_save(NULL,'11', 'Report à nouveau', '10');
SELECT pg_temp._account_heading_save(NULL,'12', 'Résultat de l''exercice', '10');
SELECT pg_temp._account_heading_save(NULL,'13', 'Subventions d''investissement', '10');
SELECT pg_temp._account_heading_save(NULL,'14', 'Provisions réglementées', '10');
SELECT pg_temp._account_heading_save(NULL,'15', 'Provisions pour risques et charges', '10');
SELECT pg_temp._account_heading_save(NULL,'16', 'Emprunts et dettes assimilées', '10');
SELECT pg_temp._account_heading_save(NULL,'17', 'Dettes rattachées à des participations', '10');
SELECT pg_temp._account_heading_save(NULL,'18', 'Comptes de liaison des établissements et sociétés en participation', '10');
--SELECT pg_temp._account_heading_save(NULL,'19', '', '10');

SELECT pg_temp._account_heading_save(NULL,'21', 'Immobilisations corporelles', '20');
SELECT pg_temp._account_heading_save(NULL,'22', 'Immobilisations mises en concession', '20');
SELECT pg_temp._account_heading_save(NULL,'23', 'Immobilisations en cours', '20');
--SELECT pg_temp._account_heading_save(NULL,'24', '', '20');
--SELECT pg_temp._account_heading_save(NULL,'25', '', '20');
SELECT pg_temp._account_heading_save(NULL,'26', 'Participations et créances rattachées à des participations', '20');
SELECT pg_temp._account_heading_save(NULL,'27', 'Autres immobilisations finacières', '20');
SELECT pg_temp._account_heading_save(NULL,'28', 'Amortissements des immobilisations', '20');
SELECT pg_temp._account_heading_save(NULL,'29', 'Dépréciations des immobilisations', '20');

SELECT pg_temp._account_heading_save(NULL,'31', 'Matières premières (et fournitures)', '30');
SELECT pg_temp._account_heading_save(NULL,'32', 'Autres approvisionnements', '30');
SELECT pg_temp._account_heading_save(NULL,'33', 'En-cours de production de biens', '30');
SELECT pg_temp._account_heading_save(NULL,'34', 'En-cours de production de services', '30');
SELECT pg_temp._account_heading_save(NULL,'35', 'Stocks de produits', '30');
--SELECT pg_temp._account_heading_save(NULL,'36', '', '30');
SELECT pg_temp._account_heading_save(NULL,'37', 'Stocks de marchandises', '30');
--SELECT pg_temp._account_heading_save(NULL,'38', '', '30');
SELECT pg_temp._account_heading_save(NULL,'39', 'Provisions pour dépréciation des stocks et encours', '30');

SELECT pg_temp._account_heading_save(NULL,'41', 'Clients et comptes rattachés', '40');
SELECT pg_temp._account_heading_save(NULL,'42', 'Personnel et comptes rattachés', '40');
SELECT pg_temp._account_heading_save(NULL,'43', 'Sécurité sociale et autres organismes sociaux', '40');
SELECT pg_temp._account_heading_save(NULL,'44', 'Etat et autres collectivités publiques', '40');
SELECT pg_temp._account_heading_save(NULL,'45', 'Groupe et associés', '40');
SELECT pg_temp._account_heading_save(NULL,'46', 'Débiteurs divers et créditeurs divers', '40');
SELECT pg_temp._account_heading_save(NULL,'47', 'Comptes transitoires ou d''attente', '40');
SELECT pg_temp._account_heading_save(NULL,'48', 'Comptes de régularisation', '40');
SELECT pg_temp._account_heading_save(NULL,'49', 'Provision pour dépréciation des comptes de tiers', '40');

SELECT pg_temp._account_heading_save(NULL,'51', 'Banques, établissements financiers et assimilés', '50');
SELECT pg_temp._account_heading_save(NULL,'52', 'Instruments de trésorerie', '50');
SELECT pg_temp._account_heading_save(NULL,'53', 'Caisse', '50');
SELECT pg_temp._account_heading_save(NULL,'54', 'Régies d''avances et accréditifs', '50');
--SELECT pg_temp._account_heading_save(NULL,'55', '', '50');
--SELECT pg_temp._account_heading_save(NULL,'56', '', '50');
--SELECT pg_temp._account_heading_save(NULL,'57', '', '50');
SELECT pg_temp._account_heading_save(NULL,'58', 'Virements internes', '50');
SELECT pg_temp._account_heading_save(NULL,'59', 'Provisions pour dépréciation des comptes financiers', '50');

SELECT pg_temp._account_heading_save(NULL,'61', 'Services extérieurs ', '60');
SELECT pg_temp._account_heading_save(NULL,'62', 'Autres services extérieurs', '60');
SELECT pg_temp._account_heading_save(NULL,'63', 'Impôts, taxes et versements assimilés', '60');
SELECT pg_temp._account_heading_save(NULL,'64', 'Charges de personnel', '60');
SELECT pg_temp._account_heading_save(NULL,'65', 'Autres charges de gestion courante', '60');
SELECT pg_temp._account_heading_save(NULL,'66', 'Charges financières', '60');
SELECT pg_temp._account_heading_save(NULL,'67', 'Charges exceptionnelles', '60');
SELECT pg_temp._account_heading_save(NULL,'68', 'Dotations aux amortissements et aux provisions', '60');
SELECT pg_temp._account_heading_save(NULL,'69', 'Participation des salariés, impôts sur les bénéfices et assimilés', '60');

SELECT pg_temp._account_heading_save(NULL,'71', 'Production stockée (ou déstockage)', '70');
SELECT pg_temp._account_heading_save(NULL,'72', 'Production immobilisée', '70');
--SELECT pg_temp._account_heading_save(NULL,'73', '', '70');
SELECT pg_temp._account_heading_save(NULL,'74', 'Subventions d''exploitation', '70');
SELECT pg_temp._account_heading_save(NULL,'75', 'Autre produits de gestion courante', '70');
SELECT pg_temp._account_heading_save(NULL,'76', 'Produits financiers', '70');
SELECT pg_temp._account_heading_save(NULL,'77', 'Produits exceptionnels', '70');
SELECT pg_temp._account_heading_save(NULL,'78', 'Reprises sur amortissements et provisions', '70');
SELECT pg_temp._account_heading_save(NULL,'79', 'Transferts de charges', '70');
--
-- SELECT account_heading_save(NULL,'90', 'Classe 9: comptabilité analytique', null);
-- SELECT account__save(NULL,'99900','Foreign Exchange Gain','I',NULL, NULL, false, false, string_to_array('', ':'), false, false);
-- SELECT account__save(NULL,'99901','Foreign Exchange Loss','E',NULL, NULL, false, false, string_to_array('', ':'), false, false);
--
-- Reconciliations accounts
--
SELECT cr_coa_to_account_save(accno, accno || '--' || description)
FROM account WHERE accno in ('512', '51203');
--
-- insert taxes
--
INSERT INTO tax (chart_id, rate)
SELECT id,0.055 FROM (
    SELECT id FROM account
    WHERE accno IN ('445621','445661','445711','445861','445871')
) a;
INSERT INTO tax (chart_id, rate)
SELECT id,0.206 FROM (
    SELECT id FROM account
    WHERE accno IN ('445622','445662','445712','445862','445872')
) a;
INSERT INTO tax (chart_id, rate)
SELECT id,0.196 FROM (
    SELECT id FROM account
    WHERE accno IN ('445623','445663','445713','445863','445873')
) a;
--
-- Set defaults
--
INSERT INTO defaults (setting_key, value) VALUES ('inventory_accno_id', (SELECT id FROM account WHERE accno = '68173'));
INSERT INTO defaults (setting_key, value) VALUES ('income_accno_id', (SELECT id FROM account WHERE accno = '707'));
INSERT INTO defaults (setting_key, value) VALUES ('expense_accno_id', (SELECT id FROM account WHERE accno = '601'));
INSERT INTO defaults (setting_key, value) VALUES ('fxgain_accno_id', (SELECT id FROM account WHERE accno = '999'));
INSERT INTO defaults (setting_key, value) VALUES ('fxloss_accno_id', (SELECT id FROM account WHERE accno = '99901'));
INSERT INTO defaults (setting_key, value) VALUES ('curr', 'EUR:USD');
INSERT INTO defaults (setting_key, value) VALUES ('weightunit', 'kg');
COMMIT;
--
UPDATE account
   SET tax = true
WHERE id
   IN (SELECT account_id
       FROM account_link
       WHERE description LIKE '%_tax');
