//
// Widget panel for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2021 by Bill Spitzak and others.
//
// This library is free software. Distribution and use rights are outlined in
// the file "COPYING" which should have been included with this file.  If this
// file is missing or damaged, see the license at:
//
//     https://www.fltk.org/COPYING.php
//
// Please see the following page on how to report bugs and issues:
//
//     https://www.fltk.org/bugs.php
//

// generated by Fast Light User Interface Designer (fluid) version 1.0402

#include "widget_panel.h"
#include "undo.h"
#include "Fl_Widget_Type.h"
#include "Fl_Grid_Type.h"
#include <FL/Fl_Grid.H>
extern void set_modflag(int mf, int mfc=-1);

Fl_Double_Window *image_panel_window=(Fl_Double_Window *)0;

static void cb_image_panel_window(Fl_Double_Window* o, void* v) {
  propagate_load(o, v);
}

Fl_Group *image_panel_imagegroup=(Fl_Group *)0;

Fl_Box *image_panel_data=(Fl_Box *)0;

static void cb_image_panel_data(Fl_Box* o, void* v) {
  if (v == LOAD) {
    Fl_Shared_Image *img = Fl_Shared_Image::get(widget_image_input->value());
    o->user_data(img);
    if (img) {
      char buf[256];
      snprintf(buf, 255, "%d x %d pixels, %d channels", img->data_w(), img->data_h(), img->d());
      o->copy_label(buf);
      image_panel_imagegroup->activate();
    } else if (widget_image_input->value() && widget_image_input->value()[0]) {
      o->label("Can't load image");
      image_panel_imagegroup->activate();
    } else {
      o->label("... x ... pixels, ...");
      image_panel_imagegroup->deactivate();
    }
  }
}

Fluid_Coord_Input *image_panel_imagew=(Fluid_Coord_Input *)0;

static void cb_image_panel_imagew(Fluid_Coord_Input* o, void* v) {
  if (v == LOAD) {
      if (current_widget->is_widget() && !current_widget->is_a(ID_Window)) {
        o->value(current_widget->scale_image_w_);
      }
    } else {
      int mod = 0;
      for (Fl_Type *t = Fl_Type::first; t; t = t->next) {
        if (t->selected && t->is_widget()) {
          Fl_Widget_Type* wt = ((Fl_Widget_Type*)t);
          wt->scale_image_w_ = o->value();
          Fl_Image *img = wt->o->image();
          if (img) {
            int iw = wt->scale_image_w_;
            if (iw<=0) iw = img->data_w();
            int ih = wt->scale_image_h_;
            if (ih<=0) ih = img->data_w();
            img->scale(iw, ih, 0, 1);
            wt->o->redraw();
            if (wt->o->parent()) wt->o->parent()->redraw();
          }
          mod = 1;
        }
      }
      if (mod) set_modflag(1);
    }
}

Fluid_Coord_Input *image_panel_imageh=(Fluid_Coord_Input *)0;

static void cb_image_panel_imageh(Fluid_Coord_Input* o, void* v) {
  if (v == LOAD) {
      if (current_widget->is_widget() && !current_widget->is_a(ID_Window)) {
        o->value(current_widget->scale_image_h_);
      }
    } else {
      int mod = 0;
      for (Fl_Type *t = Fl_Type::first; t; t = t->next) {
        if (t->selected && t->is_widget()) {
          Fl_Widget_Type* wt = ((Fl_Widget_Type*)t);
          wt->scale_image_h_ = o->value();
          Fl_Image *img = wt->o->image();
          if (img) {
            int iw = wt->scale_image_w_;
            if (iw<=0) iw = img->data_w();
            int ih = wt->scale_image_h_;
            if (ih<=0) ih = img->data_w();
            img->scale(iw, ih, 0, 1);
            wt->o->redraw();
            if (wt->o->parent()) wt->o->parent()->redraw();
          }
          mod = 1;
        }
      }
      if (mod) set_modflag(1);
    }
}

static void cb_Reset(Fl_Button*, void* v) {
  if (v != LOAD) {
    image_panel_imagew->value(0);
    image_panel_imageh->value(0);
    image_panel_imagew->do_callback();
    image_panel_imageh->do_callback();
  }
}

Fl_Group *image_panel_deimagegroup=(Fl_Group *)0;

Fl_Box *image_panel_dedata=(Fl_Box *)0;

static void cb_image_panel_dedata(Fl_Box* o, void* v) {
  if (v == LOAD) {
    Fl_Shared_Image *img = Fl_Shared_Image::get(widget_deimage_input->value());
    o->user_data(img);
    if (img) {
      char buf[256];
      snprintf(buf, 255, "%d x %d pixels, %d channels", img->data_w(), img->data_h(), img->d());
      o->copy_label(buf);
      image_panel_deimagegroup->activate();
    } else if (widget_deimage_input->value() && widget_deimage_input->value()[0]) {
      o->label("Can't load image");
      image_panel_deimagegroup->activate();
    } else {
      o->label("... x ... pixels, ...");
      image_panel_deimagegroup->deactivate();
    }
  }
}

Fluid_Coord_Input *image_panel_deimagew=(Fluid_Coord_Input *)0;

static void cb_image_panel_deimagew(Fluid_Coord_Input* o, void* v) {
  if (v == LOAD) {
      if (current_widget->is_widget() && !current_widget->is_a(ID_Window)) {
        o->value(current_widget->scale_deimage_w_);
      }
    } else {
      int mod = 0;
      for (Fl_Type *t = Fl_Type::first; t; t = t->next) {
        if (t->selected && t->is_widget()) {
          Fl_Widget_Type* wt = ((Fl_Widget_Type*)t);
          wt->scale_deimage_w_ = o->value();
          Fl_Image *img = wt->o->deimage();
          if (img) {
            int iw = wt->scale_deimage_w_;
            if (iw<=0) iw = img->data_w();
            int ih = wt->scale_deimage_h_;
            if (ih<=0) ih = img->data_w();
            img->scale(iw, ih, 0, 1);
            wt->o->redraw();
            if (wt->o->parent()) wt->o->parent()->redraw();
          }
          mod = 1;
        }
      }
      if (mod) set_modflag(1);
    }
}

Fluid_Coord_Input *image_panel_deimageh=(Fluid_Coord_Input *)0;

static void cb_image_panel_deimageh(Fluid_Coord_Input* o, void* v) {
  if (v == LOAD) {
      if (current_widget->is_widget() && !current_widget->is_a(ID_Window)) {
        o->value(current_widget->scale_deimage_h_);
      }
    } else {
      int mod = 0;
      for (Fl_Type *t = Fl_Type::first; t; t = t->next) {
        if (t->selected && t->is_widget()) {
          Fl_Widget_Type* wt = ((Fl_Widget_Type*)t);
          wt->scale_deimage_h_ = o->value();
          Fl_Image *img = wt->o->deimage();
          if (img) {
            int iw = wt->scale_deimage_w_;
            if (iw<=0) iw = img->data_w();
            int ih = wt->scale_deimage_h_;
            if (ih<=0) ih = img->data_w();
            img->scale(iw, ih, 0, 1);
            wt->o->redraw();
            if (wt->o->parent()) wt->o->parent()->redraw();
          }
          mod = 1;
        }
      }
      if (mod) set_modflag(1);
    }
}

static void cb_Reset1(Fl_Button*, void* v) {
  if (v != LOAD) {
    image_panel_deimagew->value(0);
    image_panel_deimageh->value(0);
    image_panel_deimagew->do_callback();
    image_panel_deimageh->do_callback();
  }
}

Fl_Button *image_panel_close=(Fl_Button *)0;

static void cb_image_panel_close(Fl_Button*, void* v) {
  if (v != LOAD)
    image_panel_window->hide();
}

/**
 Create a panel for editing widget image data
*/
Fl_Double_Window* make_image_panel() {
  { image_panel_window = new Fl_Double_Window(260, 332, "Image Options");
    image_panel_window->callback((Fl_Callback*)cb_image_panel_window);
    { image_panel_imagegroup = new Fl_Group(10, 15, 235, 125);
      image_panel_imagegroup->callback((Fl_Callback*)propagate_load);
      { Fl_Box* o = new Fl_Box(75, 15, 170, 20, " ---- Active Image ----");
        o->labelfont(1);
        o->labelsize(11);
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { image_panel_data = new Fl_Box(75, 35, 170, 20, "... x ... pixels, ...");
        image_panel_data->labelsize(11);
        image_panel_data->callback((Fl_Callback*)cb_image_panel_data);
        image_panel_data->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* image_panel_data
      { Fl_Group* o = new Fl_Group(75, 75, 170, 20);
        o->callback((Fl_Callback*)propagate_load);
        { image_panel_imagew = new Fluid_Coord_Input(75, 75, 55, 20, "Width:");
          image_panel_imagew->tooltip("Scale image to this width in pixel units");
          image_panel_imagew->box(FL_DOWN_BOX);
          image_panel_imagew->color(FL_BACKGROUND2_COLOR);
          image_panel_imagew->selection_color(FL_SELECTION_COLOR);
          image_panel_imagew->labeltype(FL_NORMAL_LABEL);
          image_panel_imagew->labelfont(0);
          image_panel_imagew->labelsize(11);
          image_panel_imagew->labelcolor(FL_FOREGROUND_COLOR);
          image_panel_imagew->textsize(11);
          image_panel_imagew->callback((Fl_Callback*)cb_image_panel_imagew);
          image_panel_imagew->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          image_panel_imagew->when(FL_WHEN_RELEASE);
        } // Fluid_Coord_Input* image_panel_imagew
        { image_panel_imageh = new Fluid_Coord_Input(135, 75, 55, 20, "Height:");
          image_panel_imageh->tooltip("Scale image to this height in pixel units");
          image_panel_imageh->box(FL_DOWN_BOX);
          image_panel_imageh->color(FL_BACKGROUND2_COLOR);
          image_panel_imageh->selection_color(FL_SELECTION_COLOR);
          image_panel_imageh->labeltype(FL_NORMAL_LABEL);
          image_panel_imageh->labelfont(0);
          image_panel_imageh->labelsize(11);
          image_panel_imageh->labelcolor(FL_FOREGROUND_COLOR);
          image_panel_imageh->textsize(11);
          image_panel_imageh->callback((Fl_Callback*)cb_image_panel_imageh);
          image_panel_imageh->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          image_panel_imageh->when(FL_WHEN_RELEASE);
        } // Fluid_Coord_Input* image_panel_imageh
        { Fl_Button* o = new Fl_Button(195, 75, 50, 20, "Reset");
          o->tooltip("Reset scale to original size");
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_Reset);
        } // Fl_Button* o
        o->end();
      } // Fl_Group* o
      { Fl_Box* o = new Fl_Box(10, 75, 60, 20, "Scale:");
        o->labelfont(1);
        o->labelsize(11);
        o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Box* o = new Fl_Box(10, 100, 60, 20, "Storage:");
        o->labelfont(1);
        o->labelsize(11);
        o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Check_Button* o = new Fl_Check_Button(75, 100, 170, 20, "convert to raw pixel data");
        o->tooltip("if unchecked, keep the image in its original format and store the data as is;"
" if checked, convert the image and store it as uncompressed RGB or grayscale p"
"ixel data");
        o->down_box(FL_DOWN_BOX);
        o->labelsize(11);
        o->callback((Fl_Callback*)compress_image_cb);
      } // Fl_Check_Button* o
      { Fl_Check_Button* o = new Fl_Check_Button(75, 120, 170, 20, "bind to widget");
        o->tooltip("bind the image to the widget, so it will be deleted automatically");
        o->down_box(FL_DOWN_BOX);
        o->labelsize(11);
        o->callback((Fl_Callback*)bind_image_cb);
        o->window()->hotspot(o);
      } // Fl_Check_Button* o
      image_panel_imagegroup->end();
    } // Fl_Group* image_panel_imagegroup
    { image_panel_deimagegroup = new Fl_Group(10, 155, 235, 125);
      image_panel_deimagegroup->callback((Fl_Callback*)propagate_load);
      { Fl_Box* o = new Fl_Box(75, 155, 170, 20, " ---- Inactive Image ----");
        o->labelfont(1);
        o->labelsize(11);
        o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { image_panel_dedata = new Fl_Box(75, 175, 170, 20, "... x ... pixels, ...");
        image_panel_dedata->labelsize(11);
        image_panel_dedata->callback((Fl_Callback*)cb_image_panel_dedata);
        image_panel_dedata->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* image_panel_dedata
      { Fl_Group* o = new Fl_Group(75, 215, 170, 20);
        o->callback((Fl_Callback*)propagate_load);
        { image_panel_deimagew = new Fluid_Coord_Input(75, 215, 55, 20, "Width:");
          image_panel_deimagew->tooltip("Scale image to this width in pixel units");
          image_panel_deimagew->box(FL_DOWN_BOX);
          image_panel_deimagew->color(FL_BACKGROUND2_COLOR);
          image_panel_deimagew->selection_color(FL_SELECTION_COLOR);
          image_panel_deimagew->labeltype(FL_NORMAL_LABEL);
          image_panel_deimagew->labelfont(0);
          image_panel_deimagew->labelsize(11);
          image_panel_deimagew->labelcolor(FL_FOREGROUND_COLOR);
          image_panel_deimagew->textsize(11);
          image_panel_deimagew->callback((Fl_Callback*)cb_image_panel_deimagew);
          image_panel_deimagew->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          image_panel_deimagew->when(FL_WHEN_RELEASE);
        } // Fluid_Coord_Input* image_panel_deimagew
        { image_panel_deimageh = new Fluid_Coord_Input(135, 215, 55, 20, "Height:");
          image_panel_deimageh->tooltip("Scale image to this height in pixel units");
          image_panel_deimageh->box(FL_DOWN_BOX);
          image_panel_deimageh->color(FL_BACKGROUND2_COLOR);
          image_panel_deimageh->selection_color(FL_SELECTION_COLOR);
          image_panel_deimageh->labeltype(FL_NORMAL_LABEL);
          image_panel_deimageh->labelfont(0);
          image_panel_deimageh->labelsize(11);
          image_panel_deimageh->labelcolor(FL_FOREGROUND_COLOR);
          image_panel_deimageh->textsize(11);
          image_panel_deimageh->callback((Fl_Callback*)cb_image_panel_deimageh);
          image_panel_deimageh->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          image_panel_deimageh->when(FL_WHEN_RELEASE);
        } // Fluid_Coord_Input* image_panel_deimageh
        { Fl_Button* o = new Fl_Button(195, 215, 50, 20, "Reset");
          o->tooltip("Reset scale to original size");
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_Reset1);
        } // Fl_Button* o
        o->end();
      } // Fl_Group* o
      { Fl_Box* o = new Fl_Box(10, 215, 60, 20, "Scale:");
        o->labelfont(1);
        o->labelsize(11);
        o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Box* o = new Fl_Box(10, 240, 60, 20, "Storage:");
        o->labelfont(1);
        o->labelsize(11);
        o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { Fl_Check_Button* o = new Fl_Check_Button(75, 240, 170, 20, "convert to raw pixel data");
        o->tooltip("if unchecked, keep the image in its original format and store the data as is;"
" if checked, convert the image and store it as uncompressed RGB or grayscale p"
"ixel data");
        o->down_box(FL_DOWN_BOX);
        o->labelsize(11);
        o->callback((Fl_Callback*)compress_deimage_cb);
      } // Fl_Check_Button* o
      { Fl_Check_Button* o = new Fl_Check_Button(75, 260, 170, 20, "bind to widget");
        o->tooltip("bind the image to the widget, so it will be deleted automatically");
        o->down_box(FL_DOWN_BOX);
        o->labelsize(11);
        o->callback((Fl_Callback*)bind_deimage_cb);
      } // Fl_Check_Button* o
      image_panel_deimagegroup->end();
    } // Fl_Group* image_panel_deimagegroup
    { image_panel_close = new Fl_Button(165, 295, 80, 20, "Close");
      image_panel_close->labelsize(11);
      image_panel_close->callback((Fl_Callback*)cb_image_panel_close);
    } // Fl_Button* image_panel_close
    image_panel_window->set_modal();
    image_panel_window->end();
  } // Fl_Double_Window* image_panel_window
  return image_panel_window;
}

void run_image_panel() {
  if (!image_panel_window)
    make_image_panel();

  image_panel_window->do_callback(image_panel_window, LOAD);

  Fl::pushed(0);
  Fl_Window *g = Fl::grab();
  if (g) Fl::grab(0);
  image_panel_window->show();
  while (image_panel_window->shown())
    Fl::wait();
  if (g)
    Fl::grab(g);

  Fl_Shared_Image *img = (Fl_Shared_Image*)image_panel_data->user_data();
  if (img) {
    img->release();
    image_panel_data->user_data(NULL);
  }
}

Fl_Tabs *widget_tabs=(Fl_Tabs *)0;

static void cb_widget_tabs(Fl_Tabs* o, void* v) {
  propagate_load((Fl_Group *)o,v);
}

Fl_Group *wp_gui_tab=(Fl_Group *)0;

Fl_Input *wp_gui_label=(Fl_Input *)0;

Fl_Input *widget_image_input=(Fl_Input *)0;

static void cb_(Fl_Button*, void* v) {
  if (v != LOAD) {
    run_image_panel();
  }
}

Fl_Input *widget_deimage_input=(Fl_Input *)0;

Fl_Group *wp_gui_alignment=(Fl_Group *)0;

Fl_Menu_Item menu_[] = {
 {"   Image Alignment   ", 0,  0, (void*)((fl_intptr_t)0xFFFFFFFF), 1, (uchar)FL_NORMAL_LABEL, 2, 10, 0},
 {"image over text", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_IMAGE_OVER_TEXT), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"text over image", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_TEXT_OVER_IMAGE), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"text next to image", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_TEXT_NEXT_TO_IMAGE), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"image next to text", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_IMAGE_NEXT_TO_TEXT), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"image is backdrop", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_IMAGE_BACKDROP), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item menu_1[] = {
 {"   Inside && Outside   ", 0,  0, (void*)((fl_intptr_t)0xFFFFFFFF), 1, (uchar)FL_NORMAL_LABEL, 2, 10, 0},
 {"top left", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_TOP_LEFT), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"top", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_TOP), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"top right", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_TOP_RIGHT), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"left", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_LEFT), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"center", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_CENTER), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"right", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_RIGHT), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"bottom left", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_BOTTOM_LEFT), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"bottom", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_BOTTOM), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"bottom right", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_BOTTOM_RIGHT), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"   Outside Alignment   ", 0,  0, (void*)((fl_intptr_t)0xFFFFFFFF), 1, (uchar)FL_NORMAL_LABEL, 2, 10, 0},
 {"left top", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_LEFT_TOP), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"right top", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_RIGHT_TOP), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"left bottom", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_LEFT_BOTTOM), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {"right bottom", 0,  0, (void*)((fl_intptr_t)FL_ALIGN_RIGHT_BOTTOM), 0, (uchar)FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fluid_Coord_Input *widget_x_input=(Fluid_Coord_Input *)0;

Fluid_Coord_Input *widget_y_input=(Fluid_Coord_Input *)0;

Fluid_Coord_Input *widget_w_input=(Fluid_Coord_Input *)0;

Fluid_Coord_Input *widget_h_input=(Fluid_Coord_Input *)0;

Fl_Menu_Item menu_Children[] = {
 {"Fixed", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"Reposition", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"Resize", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Group *wp_gui_flexp=(Fl_Group *)0;

Fl_Value_Input *widget_flex_size=(Fl_Value_Input *)0;

Fl_Check_Button *widget_flex_fixed=(Fl_Check_Button *)0;

Fl_Group *wp_gui_values=(Fl_Group *)0;

Fl_Group *wp_gui_margins=(Fl_Group *)0;

Fl_Group *wp_gui_sizerange=(Fl_Group *)0;

Fl_Shortcut_Button *wp_gui_shortcut=(Fl_Shortcut_Button *)0;

Fl_Group *wp_gui_xclass=(Fl_Group *)0;

Fl_Group *wp_gui_attributes=(Fl_Group *)0;

Fl_Input *wp_gui_tooltip=(Fl_Input *)0;

Fl_Group *wp_style_tab=(Fl_Group *)0;

Fl_Group *wp_style_label=(Fl_Group *)0;

Fl_Button *w_labelcolor=(Fl_Button *)0;

Fl_Group *wp_style_box=(Fl_Group *)0;

Fl_Button *w_color=(Fl_Button *)0;

Fl_Group *wp_style_downbox=(Fl_Group *)0;

Fl_Button *w_selectcolor=(Fl_Button *)0;

Fl_Group *wp_style_text=(Fl_Group *)0;

Fl_Button *w_textcolor=(Fl_Button *)0;

Fl_Group *wp_cpp_tab=(Fl_Group *)0;

Fl_Group *wp_cpp_class=(Fl_Group *)0;

Fl_Group *wp_cpp_name=(Fl_Group *)0;

Fl_Menu_Item menu_2[] = {
 {"private", 0,  0, (void*)(0), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"public", 0,  0, (void*)(1), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"protected", 0,  0, (void*)(2), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item menu_3[] = {
 {"local", 0,  0, (void*)(0), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"global", 0,  0, (void*)(1), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Input *v_input[4]={(Fl_Input *)0};

static void cb_1(Fl_Tile*, void* v) {
  wComment->do_callback(wComment, v);
  wCallback->do_callback(wCallback, v);
}

Fl_Text_Editor *wComment=(Fl_Text_Editor *)0;

CodeEditor *wCallback=(CodeEditor *)0;

Fl_Group *wp_cpp_callback=(Fl_Group *)0;

Fl_Menu_Item menu_4[] = {
 {"void*", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {"long", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 4, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Box *w_when_box=(Fl_Box *)0;

Fl_Group *widget_tab_grid_child=(Fl_Group *)0;

Fluid_Coord_Input *widget_grid_row_input=(Fluid_Coord_Input *)0;

Fluid_Coord_Input *widget_grid_col_input=(Fluid_Coord_Input *)0;

Fl_Box *widget_grid_transient=(Fl_Box *)0;

static void cb_widget_grid_transient(Fl_Box* o, void* v) {
  if (v==LOAD) {
    Fl_Widget *child = ((Fl_Widget_Type*)current_widget)->o;
    Fl_Grid_Proxy *g = ((Fl_Grid_Proxy*)((Fl_Widget_Type*)current_widget->parent)->o);
  //  Fl_Grid::Cell *cell = g->cell(child);
  //  Fl_Grid::Cell *tcell = g->transient_cell(child);
    widget_grid_transient->hide();
    widget_grid_unlinked->hide();
    if (g->transient_cell(child)) {
      widget_grid_transient->show();
    } else if (!g->cell(child)) {
      widget_grid_unlinked->show();
    }
  }
}

Fl_Box *widget_grid_unlinked=(Fl_Box *)0;

Fl_Group *wp_gridc_align=(Fl_Group *)0;

Fl_Menu_Item menu_Horizontal[] = {
 {"GRID_LEFT", 0,  0, (void*)((fl_intptr_t)FL_GRID_LEFT), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"GRID_CENTER", 0,  0, (void*)((fl_intptr_t)FL_GRID_CENTER), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"GRID_RIGHT", 0,  0, (void*)((fl_intptr_t)FL_GRID_RIGHT), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"GRID_FILL", 0,  0, (void*)((fl_intptr_t)FL_GRID_HORIZONTAL), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item menu_Vertical[] = {
 {"GRID_TOP", 0,  0, (void*)((fl_intptr_t)FL_GRID_TOP), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"GRID_CENTER", 0,  0, (void*)((fl_intptr_t)FL_GRID_CENTER), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"GRID_BOTTOM", 0,  0, (void*)((fl_intptr_t)FL_GRID_BOTTOM), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"GRID_FILL", 0,  0, (void*)((fl_intptr_t)FL_GRID_VERTICAL), 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Group *wp_gridc_size=(Fl_Group *)0;

Fluid_Coord_Input *widget_grid_rowspan_input=(Fluid_Coord_Input *)0;

Fluid_Coord_Input *widget_grid_colspan_input=(Fluid_Coord_Input *)0;

Fl_Group *widget_tab_grid=(Fl_Group *)0;

Fluid_Coord_Input *widget_grid_rows=(Fluid_Coord_Input *)0;

static void cb_widget_grid_rows(Fluid_Coord_Input* o, void* v) {
  // grid_rows_cb
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  if (v == LOAD) {
    o->value(grid->rows());
  } else {
    int m = o->value(), old_m = grid->rows();
    if (m < 1) {
      m = 1;
      o->value(m);
    }
    if (m < old_m) {
      // TODO: verify that this will not unlink existings cells
      // Offer a dialog with "delete children", "unlink cells", "cancel"
    }
    if (m != old_m) {
      undo_checkpoint();
      grid->layout(m, grid->cols());
      grid->need_layout(true);
      set_modflag(1);
      widget_tab_grid->do_callback(widget_tab_grid, LOAD);
    }
  }
}

static void cb_2(Fl_Button*, void* v) {
  if (v != LOAD) {
    widget_grid_rows->value( widget_grid_rows->value()-1 );
    widget_grid_rows->do_callback();
  }
}

static void cb_3(Fl_Button*, void* v) {
  if (v != LOAD) {
    widget_grid_rows->value( widget_grid_rows->value()+1 );
    widget_grid_rows->do_callback();
  }
}

Fluid_Coord_Input *widget_grid_cols=(Fluid_Coord_Input *)0;

static void cb_widget_grid_cols(Fluid_Coord_Input* o, void* v) {
  // grid_rows_cb
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  if (v == LOAD) {
    o->value(grid->cols());
  } else {
    int m = o->value(), old_m = grid->cols();
    if (m < 1) {
      m = 1;
      o->value(m);
    }
    if (m < old_m) {
      // TODO: verify that this will not unlink existings cells
      // Offer a dialog with "delete children", "unlink cells", "cancel"
    }
    if (m != old_m) {
      undo_checkpoint();
      grid->layout(grid->rows(), m);
      grid->need_layout(true);
      set_modflag(1);
      widget_tab_grid->do_callback(widget_tab_grid, LOAD);
    }
  }
}

static void cb_4(Fl_Button*, void* v) {
  if (v != LOAD) {
    widget_grid_cols->value( widget_grid_cols->value()-1 );
    widget_grid_cols->do_callback();
  }
}

static void cb_5(Fl_Button*, void* v) {
  if (v != LOAD) {
    widget_grid_cols->value( widget_grid_cols->value()+1 );
    widget_grid_cols->do_callback();
  }
}

Fl_Group *wp_grid_margin=(Fl_Group *)0;

static void cb_Left(Fl_Value_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int m = 0;
  if (v == LOAD) {
    grid->margin(&m, NULL, NULL, NULL);
    o->value(m);
  } else {
    int m = (int)o->value(), old_m;
    grid->margin(&old_m, NULL, NULL, NULL);
    if (m != old_m) {
      undo_checkpoint();
      grid->margin(m, -1, -1, -1);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

static void cb_Top(Fl_Value_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int m = 0;
  if (v == LOAD) {
    grid->margin(NULL, &m, NULL, NULL);
    o->value(m);
  } else {
    int m = (int)o->value(), old_m;
    grid->margin(NULL, &old_m, NULL, NULL);
    if (m != old_m) {
      undo_checkpoint();
      grid->margin(-1, m, -1, -1);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

static void cb_Right(Fl_Value_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int m = 0;
  if (v == LOAD) {
    grid->margin(NULL, NULL, &m, NULL);
    o->value(m);
  } else {
    int m = (int)o->value(), old_m;
    grid->margin(NULL, NULL, &old_m, NULL);
    if (m != old_m) {
      undo_checkpoint();
      grid->margin(-1, -1, m, -1);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

static void cb_Bottom(Fl_Value_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int m = 0;
  if (v == LOAD) {
    grid->margin(NULL, NULL, NULL, &m);
    o->value(m);
  } else {
    int m = (int)o->value(), old_m;
    grid->margin(NULL, NULL, NULL, &old_m);
    if (m != old_m) {
      undo_checkpoint();
      grid->margin(-1, -1, -1, m);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

Fl_Group *wp_grid_gaps=(Fl_Group *)0;

static void cb_Row(Fl_Value_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  if (v == LOAD) {
    int m = 0;
    grid->gap(&m, NULL);
    o->value(m);
  } else {
    int m = (int)o->value(), old_m, m2;
    grid->gap(&old_m, &m2);
    if (m != old_m) {
      undo_checkpoint();
      grid->gap(m, m2);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

static void cb_Col(Fl_Value_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  if (v == LOAD) {
    int m = 0;
    grid->gap(NULL, &m);
    o->value(m);
  } else {
    int m = (int)o->value(), old_m, m2;
    grid->gap(&m2, &old_m);
    if (m != old_m) {
      undo_checkpoint();
      grid->gap(m2, m);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

static void cb_Row1(Fl_Group* o, void* v) {
  if (v == LOAD) {
    Fl_Grid *grid = Fl_Grid_Type::selected();
    if (grid)
      o->activate();
    else
      o->deactivate();
    propagate_load(o, v);
  }
}

Fluid_Coord_Input *widget_grid_curr_row=(Fluid_Coord_Input *)0;

static void cb_widget_grid_curr_row(Fluid_Coord_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int r = o->value(), old_r = r;
  if (r < 0) r = 0;
  if (r >= grid->rows()) r = grid->rows()-1;
  if (r != old_r) o->value(r);
  if (v == LOAD) {
    // will automatically propagate
  } else {
    widget_grid_curr_row_attributes->do_callback(widget_grid_curr_row_attributes, LOAD);
  }
}

static void cb_6(Fl_Button*, void* v) {
  if (v != LOAD) {
    widget_grid_curr_row->value( widget_grid_curr_row->value()-1 );
    widget_grid_curr_row->do_callback();
  }
}

static void cb_7(Fl_Button*, void* v) {
  if (v != LOAD) {
    widget_grid_curr_row->value( widget_grid_curr_row->value()+1 );
    widget_grid_curr_row->do_callback();
  }
}

Fl_Group *widget_grid_curr_row_attributes=(Fl_Group *)0;

static void cb_Height(Fluid_Coord_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int r = widget_grid_curr_row->value();
  if (v == LOAD) {
    o->value(grid->row_height(r));
  } else {
    int h = o->value(), old_h = grid->row_height(r);
    if (h < 0) h = 0;
    if (h != old_h) {
      undo_checkpoint();
      grid->row_height(r, h);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

static void cb_Weight(Fluid_Coord_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int r = widget_grid_curr_row->value();
  if (v == LOAD) {
    o->value(grid->row_weight(r));
  } else {
    int h = o->value(), old_h = grid->row_weight(r);
    if (h < 0) h = 0;
    if (h != old_h) {
      undo_checkpoint();
      grid->row_weight(r, h);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

static void cb_Gap(Fluid_Coord_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int r = widget_grid_curr_row->value();
  if (v == LOAD) {
    o->value(grid->row_gap(r));
  } else {
    int h = o->value(), old_h = grid->row_gap(r);
    if (h < -1) h = -1;
    if (h != old_h) {
      undo_checkpoint();
      grid->row_gap(r, h);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

Fluid_Coord_Input *widget_grid_curr_col=(Fluid_Coord_Input *)0;

static void cb_widget_grid_curr_col(Fluid_Coord_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int c = o->value(), old_c = c;
  if (c < 0) c = 0;
  if (c >= grid->cols()) c = grid->cols()-1;
  if (c != old_c) o->value(c);
  if (v == LOAD) {
    // will automatically propagate
  } else {
    widget_grid_curr_col_attributes->do_callback(widget_grid_curr_col_attributes, LOAD);
  }
}

static void cb_8(Fl_Button*, void* v) {
  if (v != LOAD) {
    widget_grid_curr_col->value( widget_grid_curr_col->value()-1 );
    widget_grid_curr_col->do_callback();
  }
}

static void cb_9(Fl_Button*, void* v) {
  if (v != LOAD) {
    widget_grid_curr_col->value( widget_grid_curr_col->value()+1 );
    widget_grid_curr_col->do_callback();
  }
}

Fl_Group *widget_grid_curr_col_attributes=(Fl_Group *)0;

static void cb_Width(Fluid_Coord_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int c = widget_grid_curr_col->value();
  if (v == LOAD) {
    o->value(grid->col_width(c));
  } else {
    int h = o->value(), old_h = grid->col_width(c);
    if (h < 0) h = 0;
    if (h != old_h) {
      undo_checkpoint();
      grid->col_width(c, h);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

static void cb_Weight1(Fluid_Coord_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int c = widget_grid_curr_col->value();
  if (v == LOAD) {
    o->value(grid->col_weight(c));
  } else {
    int h = o->value(), old_h = grid->col_weight(c);
    if (h < 0) h = 0;
    if (h != old_h) {
      undo_checkpoint();
      grid->col_weight(c, h);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

static void cb_Gap1(Fluid_Coord_Input* o, void* v) {
  Fl_Grid *grid = Fl_Grid_Type::selected();
  if (!grid) return;
  int c = widget_grid_curr_col->value();
  if (v == LOAD) {
    o->value(grid->col_gap(c));
  } else {
    int h = o->value(), old_h = grid->col_gap(c);
    if (h < -1) h = -1;
    if (h != old_h) {
      undo_checkpoint();
      grid->col_gap(c, h);
      grid->need_layout(true);
      set_modflag(1);
    }
  }
}

Fl_Tabs *widget_tabs_repo=(Fl_Tabs *)0;

Fl_Button *wLiveMode=(Fl_Button *)0;

Fl_Button *overlay_button=(Fl_Button *)0;

/**
 Create a panel that can be used with all known widgets
*/
Fl_Double_Window* make_widget_panel() {
  Fl_Double_Window* w;
  { // Use a Double Window to avoid flickering.
    Fl_Double_Window* o = new Fl_Double_Window(420, 400);
    w = o; (void)w;
    o->labelsize(11);
    o->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    o->hotspot(o);
    { Fl_Tabs* o = widget_tabs = new Fl_Tabs(10, 10, 400, 350);
      widget_tabs->selection_color((Fl_Color)12);
      widget_tabs->labelsize(11);
      widget_tabs->labelcolor(FL_BACKGROUND2_COLOR);
      widget_tabs->callback((Fl_Callback*)cb_widget_tabs);
      widget_tabs->when(FL_WHEN_NEVER);
      { wp_gui_tab = new Fl_Group(10, 30, 400, 330, "GUI");
        wp_gui_tab->labelsize(11);
        wp_gui_tab->callback((Fl_Callback*)propagate_load);
        wp_gui_tab->when(FL_WHEN_NEVER);
        { Fl_Group* o = new Fl_Group(95, 40, 309, 20, "Label:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { wp_gui_label = new Fl_Input(95, 40, 190, 20);
            wp_gui_label->tooltip("The label text for the widget.\nUse Ctrl-J for newlines.");
            wp_gui_label->labelfont(1);
            wp_gui_label->labelsize(11);
            wp_gui_label->textsize(11);
            wp_gui_label->callback((Fl_Callback*)label_cb);
            wp_gui_label->when(FL_WHEN_RELEASE | FL_WHEN_ENTER_KEY_CHANGED);
            Fl_Group::current()->resizable(wp_gui_label);
          } // Fl_Input* wp_gui_label
          { Fl_Choice* o = new Fl_Choice(285, 40, 119, 20);
            o->tooltip("The label style for the widget.");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)labeltype_cb);
            o->menu(labeltypemenu);
          } // Fl_Choice* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(95, 65, 309, 20, "Image:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { widget_image_input = new Fl_Input(95, 65, 200, 20);
            widget_image_input->tooltip("The active image for the widget.");
            widget_image_input->labelfont(1);
            widget_image_input->labelsize(11);
            widget_image_input->textsize(11);
            widget_image_input->callback((Fl_Callback*)image_cb);
            Fl_Group::current()->resizable(widget_image_input);
          } // Fl_Input* widget_image_input
          { Fl_Button* o = new Fl_Button(295, 65, 89, 20, "Browse...");
            o->tooltip("Click to choose the active image.");
            o->labelsize(11);
            o->callback((Fl_Callback*)image_browse_cb);
            o->align(Fl_Align(256));
          } // Fl_Button* o
          { Fl_Button* o = new Fl_Button(384, 65, 20, 20, "...");
            o->tooltip("more image options");
            o->callback((Fl_Callback*)cb_);
          } // Fl_Button* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(95, 90, 309, 20, "Inactive:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { widget_deimage_input = new Fl_Input(95, 90, 200, 20);
            widget_deimage_input->tooltip("The inactive image for the widget.");
            widget_deimage_input->labelfont(1);
            widget_deimage_input->labelsize(11);
            widget_deimage_input->textsize(11);
            widget_deimage_input->callback((Fl_Callback*)inactive_cb);
            Fl_Group::current()->resizable(widget_deimage_input);
          } // Fl_Input* widget_deimage_input
          { Fl_Button* o = new Fl_Button(295, 90, 89, 20, "Browse...");
            o->tooltip("Click to choose the inactive image.");
            o->labelsize(11);
            o->callback((Fl_Callback*)inactive_browse_cb);
          } // Fl_Button* o
          o->end();
        } // Fl_Group* o
        { wp_gui_alignment = new Fl_Group(95, 115, 312, 20, "Alignment:");
          wp_gui_alignment->labelfont(1);
          wp_gui_alignment->labelsize(11);
          wp_gui_alignment->callback((Fl_Callback*)propagate_load);
          wp_gui_alignment->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Button* o = new Fl_Button(95, 115, 30, 20, "Clip");
            o->tooltip("Clip the label to the inside of the widget.");
            o->type(1);
            o->selection_color(FL_INACTIVE_COLOR);
            o->labelsize(11);
            o->callback((Fl_Callback*)align_cb, (void*)((fl_intptr_t)FL_ALIGN_CLIP));
            o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
          } // Fl_Button* o
          { Fl_Button* o = new Fl_Button(130, 115, 38, 20, "Wrap");
            o->tooltip("Wrap the label text.");
            o->type(1);
            o->selection_color(FL_INACTIVE_COLOR);
            o->labelsize(11);
            o->callback((Fl_Callback*)align_cb, (void*)((fl_intptr_t)FL_ALIGN_WRAP));
          } // Fl_Button* o
          { Fl_Button* o = new Fl_Button(278, 115, 20, 20, "@-1<-");
            o->tooltip("Left-align the label.");
            o->type(1);
            o->selection_color(FL_INACTIVE_COLOR);
            o->labelsize(11);
            o->labelcolor(FL_INACTIVE_COLOR);
            o->callback((Fl_Callback*)align_cb, (void*)((fl_intptr_t)FL_ALIGN_LEFT));
            o->hide();
          } // Fl_Button* o
          { Fl_Button* o = new Fl_Button(303, 115, 20, 20, "@-1->");
            o->tooltip("Right-align the label.");
            o->type(1);
            o->selection_color(FL_INACTIVE_COLOR);
            o->labelsize(11);
            o->labelcolor(FL_INACTIVE_COLOR);
            o->callback((Fl_Callback*)align_cb, (void*)((fl_intptr_t)FL_ALIGN_RIGHT));
            o->hide();
          } // Fl_Button* o
          { Fl_Button* o = new Fl_Button(328, 115, 20, 20, "@-18");
            o->tooltip("Top-align the label.");
            o->type(1);
            o->selection_color(FL_INACTIVE_COLOR);
            o->labelsize(11);
            o->labelcolor(FL_INACTIVE_COLOR);
            o->callback((Fl_Callback*)align_cb, (void*)((fl_intptr_t)FL_ALIGN_TOP));
            o->hide();
          } // Fl_Button* o
          { Fl_Button* o = new Fl_Button(353, 115, 20, 20, "@-12");
            o->tooltip("Bottom-align the label.");
            o->type(1);
            o->selection_color(FL_INACTIVE_COLOR);
            o->labelsize(11);
            o->labelcolor(FL_INACTIVE_COLOR);
            o->callback((Fl_Callback*)align_cb, (void*)((fl_intptr_t)FL_ALIGN_BOTTOM));
            o->hide();
          } // Fl_Button* o
          { Fl_Choice* o = new Fl_Choice(172, 115, 116, 20);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)align_text_image_cb);
            o->menu(menu_);
          } // Fl_Choice* o
          { Fl_Choice* o = new Fl_Choice(293, 115, 86, 20);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)align_position_cb);
            o->menu(menu_1);
          } // Fl_Choice* o
          { Fl_Button* o = new Fl_Button(384, 115, 20, 20, "@-3square");
            o->tooltip("Show the label inside the widget.");
            o->type(1);
            o->selection_color(FL_INACTIVE_COLOR);
            o->labelsize(11);
            o->labelcolor(FL_INACTIVE_COLOR);
            o->callback((Fl_Callback*)align_cb, (void*)((fl_intptr_t)FL_ALIGN_INSIDE));
          } // Fl_Button* o
          { Fl_Box* o = new Fl_Box(406, 115, 1, 20);
            o->labelsize(11);
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          wp_gui_alignment->end();
        } // Fl_Group* wp_gui_alignment
        { Fl_Group* o = new Fl_Group(95, 150, 314, 20, "Position:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)position_group_cb);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { widget_x_input = new Fluid_Coord_Input(95, 150, 55, 20, "X:");
            widget_x_input->tooltip("The X position of the widget as a number or formula.\nFormulas can be simple "
"math, including the variables\nx, px, sx, cx, and i");
            widget_x_input->box(FL_DOWN_BOX);
            widget_x_input->color(FL_BACKGROUND2_COLOR);
            widget_x_input->selection_color(FL_SELECTION_COLOR);
            widget_x_input->labeltype(FL_NORMAL_LABEL);
            widget_x_input->labelfont(0);
            widget_x_input->labelsize(11);
            widget_x_input->labelcolor(FL_FOREGROUND_COLOR);
            widget_x_input->textsize(11);
            widget_x_input->callback((Fl_Callback*)x_cb);
            widget_x_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_x_input->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_x_input
          { widget_y_input = new Fluid_Coord_Input(155, 150, 55, 20, "Y:");
            widget_y_input->tooltip("The Y position of the widget as a number or formula.\nFormulas can be simple "
"math, including the variables\ny, py, sy, cy, and i");
            widget_y_input->box(FL_DOWN_BOX);
            widget_y_input->color(FL_BACKGROUND2_COLOR);
            widget_y_input->selection_color(FL_SELECTION_COLOR);
            widget_y_input->labeltype(FL_NORMAL_LABEL);
            widget_y_input->labelfont(0);
            widget_y_input->labelsize(11);
            widget_y_input->labelcolor(FL_FOREGROUND_COLOR);
            widget_y_input->textsize(11);
            widget_y_input->callback((Fl_Callback*)y_cb);
            widget_y_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_y_input->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_y_input
          { widget_w_input = new Fluid_Coord_Input(215, 150, 55, 20, "Width:");
            widget_w_input->tooltip("The width of the widget as a number or formula.\nFormulas can be simple math,"
" including the variables\nw, pw, sw, cw, and i");
            widget_w_input->box(FL_DOWN_BOX);
            widget_w_input->color(FL_BACKGROUND2_COLOR);
            widget_w_input->selection_color(FL_SELECTION_COLOR);
            widget_w_input->labeltype(FL_NORMAL_LABEL);
            widget_w_input->labelfont(0);
            widget_w_input->labelsize(11);
            widget_w_input->labelcolor(FL_FOREGROUND_COLOR);
            widget_w_input->textsize(11);
            widget_w_input->callback((Fl_Callback*)w_cb);
            widget_w_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_w_input->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_w_input
          { widget_h_input = new Fluid_Coord_Input(275, 150, 55, 20, "Height:");
            widget_h_input->tooltip("The height of the widget as a number or formula.\nFormulas can be simple math"
", including the variables\nh, ph, sh, ch, and i");
            widget_h_input->box(FL_DOWN_BOX);
            widget_h_input->color(FL_BACKGROUND2_COLOR);
            widget_h_input->selection_color(FL_SELECTION_COLOR);
            widget_h_input->labeltype(FL_NORMAL_LABEL);
            widget_h_input->labelfont(0);
            widget_h_input->labelsize(11);
            widget_h_input->labelcolor(FL_FOREGROUND_COLOR);
            widget_h_input->textsize(11);
            widget_h_input->callback((Fl_Callback*)h_cb);
            widget_h_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_h_input->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_h_input
          { Fl_Choice* o = new Fl_Choice(335, 150, 64, 20, "Children:");
            o->tooltip("When instantiating a widget class, the children can either be fixed in their "
"original position, automatically be repositioned, or both repsositioned and re"
"sized to fit the container.");
            o->down_box(FL_BORDER_BOX);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)wc_relative_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->menu(menu_Children);
          } // Fl_Choice* o
          { Fl_Box* o = new Fl_Box(399, 150, 1, 20);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        { // This group is only visible if the parent is an Fl_Flex widget
          wp_gui_flexp = new Fl_Group(95, 150, 314, 20, "Flex Parent:");
          wp_gui_flexp->labelfont(1);
          wp_gui_flexp->labelsize(11);
          wp_gui_flexp->callback((Fl_Callback*)flex_size_group_cb);
          wp_gui_flexp->align(Fl_Align(FL_ALIGN_LEFT));
          wp_gui_flexp->hide();
          { widget_flex_size = new Fl_Value_Input(95, 150, 55, 20, "Size:");
            widget_flex_size->tooltip("Fixed Width or Height for a horizontal or vertical Fl_Flex Parent.");
            widget_flex_size->labelsize(11);
            widget_flex_size->textsize(11);
            widget_flex_size->callback((Fl_Callback*)flex_size_cb);
            widget_flex_size->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* widget_flex_size
          { widget_flex_fixed = new Fl_Check_Button(155, 150, 55, 20, "fixed");
            widget_flex_fixed->tooltip("If checked, the size of the widget stays fixed.");
            widget_flex_fixed->down_box(FL_DOWN_BOX);
            widget_flex_fixed->labelsize(11);
            widget_flex_fixed->callback((Fl_Callback*)flex_fixed_cb);
          } // Fl_Check_Button* widget_flex_fixed
          { Fl_Box* o = new Fl_Box(398, 150, 1, 20);
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          wp_gui_flexp->end();
        } // Fl_Group* wp_gui_flexp
        { wp_gui_values = new Fl_Group(95, 185, 300, 20, "Values:");
          wp_gui_values->labelfont(1);
          wp_gui_values->labelsize(11);
          wp_gui_values->callback((Fl_Callback*)values_group_cb);
          wp_gui_values->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Value_Input* o = new Fl_Value_Input(95, 185, 55, 20, "Size:");
            o->tooltip("The size of the slider.");
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)slider_size_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(155, 185, 55, 20, "Minimum:");
            o->tooltip("The minimum value of the widget.");
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)min_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(215, 185, 55, 20, "Maximum:");
            o->tooltip("The maximum value of the widget.");
            o->labelsize(11);
            o->value(1);
            o->textsize(11);
            o->callback((Fl_Callback*)max_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(275, 185, 55, 20, "Step:");
            o->tooltip("The resolution of the widget value.");
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)step_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(335, 185, 55, 20, "Value:");
            o->tooltip("The current widget value.");
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)value_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Box* o = new Fl_Box(395, 185, 0, 20);
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          wp_gui_values->end();
        } // Fl_Group* wp_gui_values
        { // This group is only visible for Fl_Flex widgets
          wp_gui_margins = new Fl_Group(95, 185, 300, 20, "Margins:");
          wp_gui_margins->labelfont(1);
          wp_gui_margins->labelsize(11);
          wp_gui_margins->callback((Fl_Callback*)flex_margin_group_cb);
          wp_gui_margins->align(Fl_Align(FL_ALIGN_LEFT));
          wp_gui_margins->hide();
          { Fl_Value_Input* o = new Fl_Value_Input(95, 185, 55, 20, "Left:");
            o->tooltip("Left margin in group.");
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)flex_margin_left_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(155, 185, 55, 20, "Top:");
            o->tooltip("Top margin in group.");
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)flex_margin_top_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(215, 185, 55, 20, "Right:");
            o->tooltip("Right margin in group.");
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)flex_margin_right_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(275, 185, 55, 20, "Bottom:");
            o->tooltip("Bottom margin in group.");
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)flex_margin_bottom_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(335, 185, 55, 20, "Gap:");
            o->tooltip("Gap between children.");
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)flex_margin_gap_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Box* o = new Fl_Box(395, 185, 0, 20);
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          wp_gui_margins->end();
        } // Fl_Group* wp_gui_margins
        { wp_gui_sizerange = new Fl_Group(95, 185, 300, 20, "Size Range:");
          wp_gui_sizerange->labelfont(1);
          wp_gui_sizerange->labelsize(11);
          wp_gui_sizerange->callback((Fl_Callback*)size_range_group_cb);
          wp_gui_sizerange->align(Fl_Align(FL_ALIGN_LEFT));
          wp_gui_sizerange->hide();
          { Fl_Value_Input* o = new Fl_Value_Input(95, 185, 55, 20, "Minimum Size:");
            o->tooltip("The size of the slider.");
            o->labelsize(11);
            o->maximum(2048);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)min_w_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(155, 185, 55, 20);
            o->tooltip("The minimum value of the widget.");
            o->labelsize(11);
            o->maximum(2048);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)min_h_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Button* o = new Fl_Button(215, 185, 25, 20, "set");
            o->labelsize(11);
            o->callback((Fl_Callback*)set_min_size_cb);
          } // Fl_Button* o
          { Fl_Value_Input* o = new Fl_Value_Input(245, 185, 55, 20, "Maximum Size:");
            o->tooltip("The maximum value of the widget.");
            o->labelsize(11);
            o->maximum(2048);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)max_w_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(305, 185, 55, 20);
            o->tooltip("The resolution of the widget value.");
            o->labelsize(11);
            o->maximum(2048);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)max_h_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Button* o = new Fl_Button(365, 185, 25, 20, "set");
            o->labelsize(11);
            o->callback((Fl_Callback*)set_max_size_cb);
          } // Fl_Button* o
          { Fl_Box* o = new Fl_Box(395, 185, 0, 20);
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          wp_gui_sizerange->end();
        } // Fl_Group* wp_gui_sizerange
        { Fl_Group* o = new Fl_Group(95, 210, 310, 20, "Shortcut:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { // This is a special button that grabs keystrokes directly
            wp_gui_shortcut = new Fl_Shortcut_Button(95, 210, 310, 20);
            wp_gui_shortcut->tooltip("The shortcut key for the widget.\nUse \'Backspace\' key to clear.");
            wp_gui_shortcut->box(FL_DOWN_BOX);
            wp_gui_shortcut->color(FL_BACKGROUND2_COLOR);
            wp_gui_shortcut->selection_color((Fl_Color)12);
            wp_gui_shortcut->labeltype(FL_NORMAL_LABEL);
            wp_gui_shortcut->labelfont(0);
            wp_gui_shortcut->labelsize(11);
            wp_gui_shortcut->labelcolor(FL_FOREGROUND_COLOR);
            wp_gui_shortcut->callback((Fl_Callback*)shortcut_in_cb);
            wp_gui_shortcut->align(Fl_Align(FL_ALIGN_CENTER));
            wp_gui_shortcut->when(FL_WHEN_CHANGED);
          } // Fl_Shortcut_Button* wp_gui_shortcut
          o->end();
        } // Fl_Group* o
        { wp_gui_xclass = new Fl_Group(95, 235, 300, 20, "X Class:");
          wp_gui_xclass->labelfont(1);
          wp_gui_xclass->labelsize(11);
          wp_gui_xclass->callback((Fl_Callback*)propagate_load);
          wp_gui_xclass->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Input* o = new Fl_Input(95, 235, 95, 20, ":");
            o->tooltip("The X resource class.");
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)xclass_cb);
            Fl_Group::current()->resizable(o);
          } // Fl_Input* o
          { Fl_Light_Button* o = new Fl_Light_Button(195, 235, 60, 20, "Border");
            o->tooltip("Add a border around the window.");
            o->selection_color((Fl_Color)1);
            o->labelsize(11);
            o->callback((Fl_Callback*)border_cb);
          } // Fl_Light_Button* o
          { Fl_Light_Button* o = new Fl_Light_Button(260, 235, 55, 20, "Modal");
            o->tooltip("Make the window modal.");
            o->selection_color((Fl_Color)1);
            o->labelsize(11);
            o->callback((Fl_Callback*)modal_cb);
          } // Fl_Light_Button* o
          { Fl_Light_Button* o = new Fl_Light_Button(320, 235, 75, 20, "Nonmodal");
            o->tooltip("Make the window non-modal.");
            o->selection_color((Fl_Color)1);
            o->labelsize(11);
            o->callback((Fl_Callback*)non_modal_cb);
            o->align(Fl_Align(132|FL_ALIGN_INSIDE));
          } // Fl_Light_Button* o
          wp_gui_xclass->end();
        } // Fl_Group* wp_gui_xclass
        { wp_gui_attributes = new Fl_Group(95, 260, 305, 20, "Attributes:");
          wp_gui_attributes->labelfont(1);
          wp_gui_attributes->labelsize(11);
          wp_gui_attributes->callback((Fl_Callback*)propagate_load);
          wp_gui_attributes->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Light_Button* o = new Fl_Light_Button(95, 260, 60, 20, "Visible");
            o->tooltip("Show the widget.");
            o->selection_color((Fl_Color)1);
            o->labelsize(11);
            o->callback((Fl_Callback*)visible_cb);
          } // Fl_Light_Button* o
          { Fl_Light_Button* o = new Fl_Light_Button(160, 260, 60, 20, "Active");
            o->tooltip("Activate the widget.");
            o->selection_color((Fl_Color)1);
            o->labelsize(11);
            o->callback((Fl_Callback*)active_cb);
          } // Fl_Light_Button* o
          { Fl_Light_Button* o = new Fl_Light_Button(225, 260, 75, 20, "Resizable");
            o->tooltip("Make the widget resizable.");
            o->selection_color((Fl_Color)1);
            o->labelsize(11);
            o->callback((Fl_Callback*)resizable_cb);
            o->when(FL_WHEN_CHANGED);
          } // Fl_Light_Button* o
          { Fl_Light_Button* o = new Fl_Light_Button(305, 260, 70, 20, "Hotspot");
            o->tooltip("Center the window under this widget.");
            o->selection_color((Fl_Color)1);
            o->labelsize(11);
            o->callback((Fl_Callback*)hotspot_cb);
            o->when(FL_WHEN_CHANGED);
          } // Fl_Light_Button* o
          { Fl_Box* o = new Fl_Box(395, 260, 0, 20);
            o->labelsize(11);
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          wp_gui_attributes->end();
        } // Fl_Group* wp_gui_attributes
        { wp_gui_tooltip = new Fl_Input(95, 285, 310, 20, "Tooltip:");
          wp_gui_tooltip->tooltip("The tooltip text for the widget.\nUse Ctrl-J for newlines.");
          wp_gui_tooltip->labelfont(1);
          wp_gui_tooltip->labelsize(11);
          wp_gui_tooltip->textsize(11);
          wp_gui_tooltip->callback((Fl_Callback*)tooltip_cb);
        } // Fl_Input* wp_gui_tooltip
        { Fl_Box* o = new Fl_Box(95, 305, 300, 5);
          o->hide();
          Fl_Group::current()->resizable(o);
        } // Fl_Box* o
        wp_gui_tab->end();
        Fl_Group::current()->resizable(wp_gui_tab);
      } // Fl_Group* wp_gui_tab
      { wp_style_tab = new Fl_Group(10, 30, 400, 330, "Style");
        wp_style_tab->labelsize(11);
        wp_style_tab->callback((Fl_Callback*)propagate_load);
        wp_style_tab->when(FL_WHEN_NEVER);
        wp_style_tab->hide();
        { wp_style_label = new Fl_Group(99, 40, 305, 20, "Label Font:");
          wp_style_label->labelfont(1);
          wp_style_label->labelsize(11);
          wp_style_label->callback((Fl_Callback*)propagate_load);
          wp_style_label->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Choice* o = new Fl_Choice(99, 40, 148, 20);
            o->tooltip("The style of the label text.");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)labelfont_cb);
            Fl_Group::current()->resizable(o);
            o->menu(fontmenu);
          } // Fl_Choice* o
          { Fl_Value_Input* o = new Fl_Value_Input(247, 40, 49, 20);
            o->tooltip("The size of the label text.");
            o->labelsize(11);
            o->maximum(100);
            o->step(1);
            o->value(14);
            o->textsize(11);
            o->callback((Fl_Callback*)labelsize_cb);
          } // Fl_Value_Input* o
          { w_labelcolor = new Fl_Button(296, 40, 90, 20, "Label Color");
            w_labelcolor->tooltip("The color of the label text.");
            w_labelcolor->labelsize(11);
            w_labelcolor->callback((Fl_Callback*)labelcolor_cb);
          } // Fl_Button* w_labelcolor
          { Fl_Menu_Button* o = new Fl_Menu_Button(386, 40, 18, 20);
            o->callback((Fl_Callback*)labelcolor_menu_cb);
            o->menu(colormenu);
          } // Fl_Menu_Button* o
          wp_style_label->end();
        } // Fl_Group* wp_style_label
        { wp_style_box = new Fl_Group(99, 65, 305, 20, "Box:");
          wp_style_box->labelfont(1);
          wp_style_box->labelsize(11);
          wp_style_box->callback((Fl_Callback*)propagate_load);
          wp_style_box->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Choice* o = new Fl_Choice(100, 65, 196, 20);
            o->tooltip("The \"up\" box of the widget.");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)box_cb);
            Fl_Group::current()->resizable(o);
            o->menu(boxmenu);
          } // Fl_Choice* o
          { w_color = new Fl_Button(296, 65, 90, 20, "Color");
            w_color->tooltip("The background color of the widget.");
            w_color->labelsize(11);
            w_color->callback((Fl_Callback*)color_cb);
          } // Fl_Button* w_color
          { Fl_Menu_Button* o = new Fl_Menu_Button(386, 65, 18, 20);
            o->callback((Fl_Callback*)color_menu_cb);
            o->menu(colormenu);
          } // Fl_Menu_Button* o
          wp_style_box->end();
        } // Fl_Group* wp_style_box
        { wp_style_downbox = new Fl_Group(99, 90, 305, 20, "Down Box:");
          wp_style_downbox->labelfont(1);
          wp_style_downbox->labelsize(11);
          wp_style_downbox->callback((Fl_Callback*)propagate_load);
          wp_style_downbox->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Choice* o = new Fl_Choice(99, 90, 197, 20);
            o->tooltip("The \"down\" box of the widget.");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)down_box_cb);
            Fl_Group::current()->resizable(o);
            o->menu(boxmenu);
          } // Fl_Choice* o
          { w_selectcolor = new Fl_Button(296, 90, 90, 20, "Select Color");
            w_selectcolor->tooltip("The selection color of the widget.");
            w_selectcolor->labelsize(11);
            w_selectcolor->callback((Fl_Callback*)color2_cb);
          } // Fl_Button* w_selectcolor
          { Fl_Menu_Button* o = new Fl_Menu_Button(386, 90, 18, 20);
            o->callback((Fl_Callback*)color2_menu_cb);
            o->menu(colormenu);
          } // Fl_Menu_Button* o
          wp_style_downbox->end();
        } // Fl_Group* wp_style_downbox
        { wp_style_text = new Fl_Group(99, 115, 305, 20, "Text Font:");
          wp_style_text->labelfont(1);
          wp_style_text->labelsize(11);
          wp_style_text->callback((Fl_Callback*)propagate_load);
          wp_style_text->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Choice* o = new Fl_Choice(99, 115, 148, 20);
            o->tooltip("The value text style.");
            o->box(FL_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)textfont_cb);
            Fl_Group::current()->resizable(o);
            o->menu(fontmenu);
          } // Fl_Choice* o
          { Fl_Value_Input* o = new Fl_Value_Input(247, 115, 49, 20);
            o->tooltip("The value text size.");
            o->labelsize(11);
            o->maximum(100);
            o->step(1);
            o->value(14);
            o->textsize(11);
            o->callback((Fl_Callback*)textsize_cb);
          } // Fl_Value_Input* o
          { w_textcolor = new Fl_Button(296, 115, 90, 20, "Text Color");
            w_textcolor->tooltip("The value text color.");
            w_textcolor->labelsize(11);
            w_textcolor->callback((Fl_Callback*)textcolor_cb);
          } // Fl_Button* w_textcolor
          { Fl_Menu_Button* o = new Fl_Menu_Button(386, 115, 18, 20);
            o->callback((Fl_Callback*)textcolor_menu_cb);
            o->menu(colormenu);
          } // Fl_Menu_Button* o
          wp_style_text->end();
        } // Fl_Group* wp_style_text
        { Fl_Group* o = new Fl_Group(99, 150, 242, 20, "Label Margin:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Value_Input* o = new Fl_Value_Input(99, 150, 55, 20, "Horizontal:");
            o->tooltip("Spacing between label and the horizontally aligned side of the widget.");
            o->labelsize(11);
            o->minimum(-127);
            o->maximum(128);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)h_label_margin_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(159, 150, 55, 20, "Vertical:");
            o->tooltip("Spacing between label and the vertically aligned side of the widget.");
            o->labelsize(11);
            o->minimum(-127);
            o->maximum(127);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)v_label_margin_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(219, 150, 55, 20, "Text to Image:");
            o->tooltip("Gap between label image and text in pixels");
            o->labelsize(11);
            o->maximum(255);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)image_spacing_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Box* o = new Fl_Box(281, 150, 60, 20);
            o->labelsize(11);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        { Fl_Light_Button* o = new Fl_Light_Button(99, 175, 90, 20, "Compact");
          o->tooltip("use compact box types for closely set buttons");
          o->selection_color((Fl_Color)1);
          o->labelsize(11);
          o->callback((Fl_Callback*)compact_cb);
        } // Fl_Light_Button* o
        { Fl_Box* o = new Fl_Box(195, 205, 40, 40);
          o->labelsize(11);
          Fl_Group::current()->resizable(o);
        } // Fl_Box* o
        wp_style_tab->end();
      } // Fl_Group* wp_style_tab
      { wp_cpp_tab = new Fl_Group(10, 30, 400, 330, "C++");
        wp_cpp_tab->labelsize(11);
        wp_cpp_tab->callback((Fl_Callback*)propagate_load);
        wp_cpp_tab->when(FL_WHEN_NEVER);
        wp_cpp_tab->hide();
        { wp_cpp_class = new Fl_Group(95, 40, 310, 20, "Class:");
          wp_cpp_class->labelfont(1);
          wp_cpp_class->labelsize(11);
          wp_cpp_class->callback((Fl_Callback*)propagate_load);
          wp_cpp_class->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Input* o = new Fl_Input(95, 40, 172, 20);
            o->tooltip("The widget subclass.");
            o->labelfont(1);
            o->labelsize(11);
            o->textfont(4);
            o->textsize(11);
            o->callback((Fl_Callback*)subclass_cb, (void*)(4));
            Fl_Group::current()->resizable(o);
          } // Fl_Input* o
          { Fl_Choice* o = new Fl_Choice(267, 40, 138, 20);
            o->tooltip("The widget subtype.");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)subtype_cb);
          } // Fl_Choice* o
          wp_cpp_class->end();
        } // Fl_Group* wp_cpp_class
        { wp_cpp_name = new Fl_Group(95, 65, 310, 20, "Name:");
          wp_cpp_name->labelfont(1);
          wp_cpp_name->labelsize(11);
          wp_cpp_name->callback((Fl_Callback*)propagate_load);
          wp_cpp_name->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Input* o = new Fl_Input(95, 65, 235, 20);
            o->tooltip("The name of the widget.");
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)name_cb);
            Fl_Group::current()->resizable(o);
          } // Fl_Input* o
          { Fl_Choice* o = new Fl_Choice(330, 65, 75, 20);
            o->tooltip("Change member access attribute.");
            o->down_box(FL_BORDER_BOX);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)name_public_member_cb);
            o->when(FL_WHEN_CHANGED);
            o->menu(menu_2);
          } // Fl_Choice* o
          { Fl_Choice* o = new Fl_Choice(330, 65, 75, 20);
            o->tooltip("Change widget accessibility.");
            o->down_box(FL_BORDER_BOX);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)name_public_cb);
            o->when(FL_WHEN_CHANGED);
            o->hide();
            o->menu(menu_3);
          } // Fl_Choice* o
          wp_cpp_name->end();
        } // Fl_Group* wp_cpp_name
        { v_input[0] = new Fl_Input(95, 90, 310, 20, "Extra Code:");
          v_input[0]->tooltip("Extra initialization code for the widget.");
          v_input[0]->labelfont(1);
          v_input[0]->labelsize(11);
          v_input[0]->textfont(4);
          v_input[0]->textsize(11);
          v_input[0]->callback((Fl_Callback*)v_input_cb, (void*)(0));
        } // Fl_Input* v_input[0]
        { v_input[1] = new Fl_Input(95, 110, 310, 20);
          v_input[1]->tooltip("Extra initialization code for the widget.");
          v_input[1]->labelsize(11);
          v_input[1]->textfont(4);
          v_input[1]->textsize(11);
          v_input[1]->callback((Fl_Callback*)v_input_cb, (void*)(1));
        } // Fl_Input* v_input[1]
        { v_input[2] = new Fl_Input(95, 130, 310, 20);
          v_input[2]->tooltip("Extra initialization code for the widget.");
          v_input[2]->labelsize(11);
          v_input[2]->textfont(4);
          v_input[2]->textsize(11);
          v_input[2]->callback((Fl_Callback*)v_input_cb, (void*)(2));
        } // Fl_Input* v_input[2]
        { v_input[3] = new Fl_Input(95, 150, 310, 20);
          v_input[3]->tooltip("Extra initialization code for the widget.");
          v_input[3]->labelsize(11);
          v_input[3]->textfont(4);
          v_input[3]->textsize(11);
          v_input[3]->callback((Fl_Callback*)v_input_cb, (void*)(3));
        } // Fl_Input* v_input[3]
        { Fl_Tile* o = new Fl_Tile(95, 175, 310, 130);
          o->callback((Fl_Callback*)cb_1);
          { Fl_Group* o = new Fl_Group(95, 175, 310, 48);
            o->box(FL_FLAT_BOX);
            { wComment = new Fl_Text_Editor(95, 175, 310, 45, "Comment:");
              wComment->tooltip("Write a comment that will appear in the source code and in the widget tree ov"
"erview.");
              wComment->box(FL_DOWN_BOX);
              wComment->labelfont(1);
              wComment->labelsize(11);
              wComment->textfont(6);
              wComment->textsize(11);
              wComment->textcolor((Fl_Color)59);
              wComment->align(Fl_Align(FL_ALIGN_LEFT));
              wComment->when(FL_WHEN_CHANGED);
              Fl_Group::current()->resizable(wComment);
              wComment->buffer(new Fl_Text_Buffer());
              wComment->callback((Fl_Callback*)comment_cb);
            } // Fl_Text_Editor* wComment
            o->end();
          } // Fl_Group* o
          { Fl_Group* o = new Fl_Group(95, 223, 310, 82);
            o->box(FL_FLAT_BOX);
            { wCallback = new CodeEditor(95, 225, 310, 80, "Callback:");
              wCallback->tooltip("The callback function or code for the widget. Use the variable name \'o\' to "
"access the Widget pointer and \'v\' to access the user value.");
              wCallback->box(FL_DOWN_BOX);
              wCallback->color(FL_BACKGROUND2_COLOR);
              wCallback->selection_color(FL_SELECTION_COLOR);
              wCallback->labeltype(FL_NORMAL_LABEL);
              wCallback->labelfont(1);
              wCallback->labelsize(11);
              wCallback->labelcolor(FL_FOREGROUND_COLOR);
              wCallback->textfont(4);
              wCallback->textsize(11);
              wCallback->callback((Fl_Callback*)callback_cb);
              wCallback->align(Fl_Align(FL_ALIGN_LEFT));
              wCallback->when(FL_WHEN_RELEASE);
              Fl_Group::current()->resizable(wCallback);
            } // CodeEditor* wCallback
            o->end();
          } // Fl_Group* o
          o->end();
          Fl_Group::current()->resizable(o);
        } // Fl_Tile* o
        { wp_cpp_callback = new Fl_Group(95, 310, 310, 20, "User Data:");
          wp_cpp_callback->labelfont(1);
          wp_cpp_callback->labelsize(11);
          wp_cpp_callback->callback((Fl_Callback*)propagate_load);
          wp_cpp_callback->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Input* o = new Fl_Input(95, 310, 158, 20);
            o->tooltip("The user data to pass into the callback code.");
            o->labelfont(1);
            o->labelsize(11);
            o->textfont(4);
            o->textsize(11);
            o->callback((Fl_Callback*)user_data_cb);
            Fl_Group::current()->resizable(o);
          } // Fl_Input* o
          { Fl_Menu_Button* o = new Fl_Menu_Button(260, 310, 145, 20, "When");
            o->tooltip("When to call the callback function.");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)when_cb);
            o->when(FL_WHEN_CHANGED);
            o->menu(whenmenu);
          } // Fl_Menu_Button* o
          wp_cpp_callback->end();
        } // Fl_Group* wp_cpp_callback
        { Fl_Group* o = new Fl_Group(95, 332, 310, 26, "Type:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Input_Choice* o = new Fl_Input_Choice(95, 335, 158, 20);
            o->tooltip("The type of the user data.");
            o->labelfont(1);
            o->labelsize(11);
            o->textfont(4);
            o->textsize(11);
            o->callback((Fl_Callback*)user_data_type_cb);
            Fl_Group::current()->resizable(o);
            o->menu(menu_4);
          } // Fl_Input_Choice* o
          { w_when_box = new Fl_Box(260, 332, 145, 26, "FL_WHEN_NEVER");
            w_when_box->box(FL_FLAT_BOX);
            w_when_box->selection_color((Fl_Color)1);
            w_when_box->labelsize(8);
            w_when_box->align(Fl_Align(193|FL_ALIGN_INSIDE));
          } // Fl_Box* w_when_box
          o->end();
        } // Fl_Group* o
        wp_cpp_tab->end();
      } // Fl_Group* wp_cpp_tab
      { widget_tab_grid_child = new Fl_Group(10, 30, 400, 330, "Grid Child");
        widget_tab_grid_child->labelsize(11);
        widget_tab_grid_child->callback((Fl_Callback*)propagate_load);
        widget_tab_grid_child->hide();
        { Fl_Group* o = new Fl_Group(95, 60, 315, 20, "Location:");
          o->box(FL_FLAT_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { widget_grid_row_input = new Fluid_Coord_Input(95, 60, 40, 20, "Row:");
            widget_grid_row_input->box(FL_DOWN_BOX);
            widget_grid_row_input->color(FL_BACKGROUND2_COLOR);
            widget_grid_row_input->selection_color(FL_SELECTION_COLOR);
            widget_grid_row_input->labeltype(FL_NORMAL_LABEL);
            widget_grid_row_input->labelfont(0);
            widget_grid_row_input->labelsize(11);
            widget_grid_row_input->labelcolor(FL_FOREGROUND_COLOR);
            widget_grid_row_input->textsize(11);
            widget_grid_row_input->callback((Fl_Callback*)grid_set_row_cb);
            widget_grid_row_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_grid_row_input->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_grid_row_input
          { Fl_Group* o = new Fl_Group(135, 60, 30, 20);
            { Fl_Button* o = new Fl_Button(135, 60, 15, 20, "-");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)grid_dec_row_cb);
              o->clear_visible_focus();
            } // Fl_Button* o
            { Fl_Button* o = new Fl_Button(150, 60, 15, 20, "+");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)grid_inc_row_cb);
              o->clear_visible_focus();
            } // Fl_Button* o
            o->end();
          } // Fl_Group* o
          { widget_grid_col_input = new Fluid_Coord_Input(175, 60, 40, 20, "Column:");
            widget_grid_col_input->box(FL_DOWN_BOX);
            widget_grid_col_input->color(FL_BACKGROUND2_COLOR);
            widget_grid_col_input->selection_color(FL_SELECTION_COLOR);
            widget_grid_col_input->labeltype(FL_NORMAL_LABEL);
            widget_grid_col_input->labelfont(0);
            widget_grid_col_input->labelsize(11);
            widget_grid_col_input->labelcolor(FL_FOREGROUND_COLOR);
            widget_grid_col_input->textsize(11);
            widget_grid_col_input->callback((Fl_Callback*)grid_set_col_cb);
            widget_grid_col_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_grid_col_input->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_grid_col_input
          { Fl_Group* o = new Fl_Group(215, 60, 30, 20);
            { Fl_Button* o = new Fl_Button(215, 60, 15, 20, "-");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)grid_dec_col_cb);
              o->clear_visible_focus();
            } // Fl_Button* o
            { Fl_Button* o = new Fl_Button(230, 60, 15, 20, "+");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)grid_inc_col_cb);
              o->clear_visible_focus();
            } // Fl_Button* o
            o->end();
          } // Fl_Group* o
          { Fl_Box* o = new Fl_Box(395, 60, 1, 20);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          { widget_grid_transient = new Fl_Box(250, 60, 80, 20, "TRANSIENT");
            widget_grid_transient->labelsize(11);
            widget_grid_transient->labelcolor((Fl_Color)1);
            widget_grid_transient->callback((Fl_Callback*)cb_widget_grid_transient);
          } // Fl_Box* widget_grid_transient
          { widget_grid_unlinked = new Fl_Box(250, 60, 80, 20, "UNLINKED");
            widget_grid_unlinked->labelsize(11);
            widget_grid_unlinked->labelcolor((Fl_Color)1);
            widget_grid_unlinked->hide();
          } // Fl_Box* widget_grid_unlinked
          o->end();
        } // Fl_Group* o
        { wp_gridc_align = new Fl_Group(95, 100, 315, 20, "Align:");
          wp_gridc_align->labelfont(1);
          wp_gridc_align->labelsize(11);
          wp_gridc_align->callback((Fl_Callback*)propagate_load);
          wp_gridc_align->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Choice* o = new Fl_Choice(95, 100, 115, 20, "Horizontal");
            o->down_box(FL_BORDER_BOX);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)grid_align_horizontal_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->menu(menu_Horizontal);
          } // Fl_Choice* o
          { Fl_Choice* o = new Fl_Choice(215, 100, 115, 20, "Vertical");
            o->down_box(FL_BORDER_BOX);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)grid_align_vertical_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->menu(menu_Vertical);
          } // Fl_Choice* o
          { Fl_Box* o = new Fl_Box(395, 100, 1, 20);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          wp_gridc_align->end();
        } // Fl_Group* wp_gridc_align
        { wp_gridc_size = new Fl_Group(95, 135, 315, 20, "Min. Size:");
          wp_gridc_size->labelfont(1);
          wp_gridc_size->labelsize(11);
          wp_gridc_size->callback((Fl_Callback*)propagate_load);
          wp_gridc_size->align(Fl_Align(FL_ALIGN_LEFT));
          { Fluid_Coord_Input* o = new Fluid_Coord_Input(95, 135, 55, 20, "Width:");
            o->box(FL_DOWN_BOX);
            o->color(FL_BACKGROUND2_COLOR);
            o->selection_color(FL_SELECTION_COLOR);
            o->labeltype(FL_NORMAL_LABEL);
            o->labelfont(0);
            o->labelsize(11);
            o->labelcolor(FL_FOREGROUND_COLOR);
            o->textsize(11);
            o->callback((Fl_Callback*)grid_set_min_wdt_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* o
          { Fluid_Coord_Input* o = new Fluid_Coord_Input(155, 135, 55, 20, "Height:");
            o->box(FL_DOWN_BOX);
            o->color(FL_BACKGROUND2_COLOR);
            o->selection_color(FL_SELECTION_COLOR);
            o->labeltype(FL_NORMAL_LABEL);
            o->labelfont(0);
            o->labelsize(11);
            o->labelcolor(FL_FOREGROUND_COLOR);
            o->textsize(11);
            o->callback((Fl_Callback*)grid_set_min_hgt_cb);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* o
          { Fl_Box* o = new Fl_Box(395, 135, 1, 20);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          wp_gridc_size->end();
        } // Fl_Group* wp_gridc_size
        { Fl_Group* o = new Fl_Group(95, 170, 315, 20, "Span:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { widget_grid_rowspan_input = new Fluid_Coord_Input(95, 170, 40, 20, "Row Span:");
            widget_grid_rowspan_input->box(FL_DOWN_BOX);
            widget_grid_rowspan_input->color(FL_BACKGROUND2_COLOR);
            widget_grid_rowspan_input->selection_color(FL_SELECTION_COLOR);
            widget_grid_rowspan_input->labeltype(FL_NORMAL_LABEL);
            widget_grid_rowspan_input->labelfont(0);
            widget_grid_rowspan_input->labelsize(11);
            widget_grid_rowspan_input->labelcolor(FL_FOREGROUND_COLOR);
            widget_grid_rowspan_input->textsize(11);
            widget_grid_rowspan_input->callback((Fl_Callback*)grid_set_rowspan_cb);
            widget_grid_rowspan_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_grid_rowspan_input->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_grid_rowspan_input
          { Fl_Group* o = new Fl_Group(135, 170, 30, 20);
            { Fl_Button* o = new Fl_Button(135, 170, 15, 20, "-");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)grid_dec_rowspan_cb);
              o->clear_visible_focus();
            } // Fl_Button* o
            { Fl_Button* o = new Fl_Button(150, 170, 15, 20, "+");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)grid_inc_rowspan_cb);
              o->clear_visible_focus();
            } // Fl_Button* o
            o->end();
          } // Fl_Group* o
          { widget_grid_colspan_input = new Fluid_Coord_Input(175, 170, 40, 20, "Col. Span:");
            widget_grid_colspan_input->box(FL_DOWN_BOX);
            widget_grid_colspan_input->color(FL_BACKGROUND2_COLOR);
            widget_grid_colspan_input->selection_color(FL_SELECTION_COLOR);
            widget_grid_colspan_input->labeltype(FL_NORMAL_LABEL);
            widget_grid_colspan_input->labelfont(0);
            widget_grid_colspan_input->labelsize(11);
            widget_grid_colspan_input->labelcolor(FL_FOREGROUND_COLOR);
            widget_grid_colspan_input->textsize(11);
            widget_grid_colspan_input->callback((Fl_Callback*)grid_set_colspan_cb);
            widget_grid_colspan_input->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_grid_colspan_input->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_grid_colspan_input
          { Fl_Group* o = new Fl_Group(215, 170, 30, 20);
            { Fl_Button* o = new Fl_Button(215, 170, 15, 20, "-");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)grid_dec_colspan_cb);
              o->clear_visible_focus();
            } // Fl_Button* o
            { Fl_Button* o = new Fl_Button(230, 170, 15, 20, "+");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)grid_inc_colspan_cb);
              o->clear_visible_focus();
            } // Fl_Button* o
            o->end();
          } // Fl_Group* o
          { Fl_Box* o = new Fl_Box(395, 170, 1, 20);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        { Fl_Box* o = new Fl_Box(95, 350, 300, 5);
          o->labelsize(11);
          o->hide();
          Fl_Group::current()->resizable(o);
        } // Fl_Box* o
        widget_tab_grid_child->end();
      } // Fl_Group* widget_tab_grid_child
      { widget_tab_grid = new Fl_Group(10, 30, 400, 330, "Grid");
        widget_tab_grid->labelsize(11);
        widget_tab_grid->callback((Fl_Callback*)propagate_load);
        widget_tab_grid->hide();
        { Fl_Group* o = new Fl_Group(95, 60, 315, 20, "Grid Layout:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { widget_grid_rows = new Fluid_Coord_Input(95, 60, 40, 20, "Rows:");
            widget_grid_rows->tooltip("Number of horizontal rows in the Grid group");
            widget_grid_rows->box(FL_DOWN_BOX);
            widget_grid_rows->color(FL_BACKGROUND2_COLOR);
            widget_grid_rows->selection_color(FL_SELECTION_COLOR);
            widget_grid_rows->labeltype(FL_NORMAL_LABEL);
            widget_grid_rows->labelfont(0);
            widget_grid_rows->labelsize(11);
            widget_grid_rows->labelcolor(FL_FOREGROUND_COLOR);
            widget_grid_rows->textsize(11);
            widget_grid_rows->callback((Fl_Callback*)cb_widget_grid_rows);
            widget_grid_rows->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_grid_rows->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_grid_rows
          { Fl_Group* o = new Fl_Group(135, 60, 30, 20);
            { Fl_Button* o = new Fl_Button(135, 60, 15, 20, "-");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)cb_2);
              o->clear_visible_focus();
            } // Fl_Button* o
            { Fl_Button* o = new Fl_Button(150, 60, 15, 20, "+");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)cb_3);
              o->clear_visible_focus();
            } // Fl_Button* o
            o->end();
          } // Fl_Group* o
          { widget_grid_cols = new Fluid_Coord_Input(175, 60, 40, 20, "Columns:");
            widget_grid_cols->tooltip("Number of vertical columns in the Grid group");
            widget_grid_cols->box(FL_DOWN_BOX);
            widget_grid_cols->color(FL_BACKGROUND2_COLOR);
            widget_grid_cols->selection_color(FL_SELECTION_COLOR);
            widget_grid_cols->labeltype(FL_NORMAL_LABEL);
            widget_grid_cols->labelfont(0);
            widget_grid_cols->labelsize(11);
            widget_grid_cols->labelcolor(FL_FOREGROUND_COLOR);
            widget_grid_cols->textsize(11);
            widget_grid_cols->callback((Fl_Callback*)cb_widget_grid_cols);
            widget_grid_cols->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_grid_cols->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_grid_cols
          { Fl_Group* o = new Fl_Group(215, 60, 30, 20);
            { Fl_Button* o = new Fl_Button(215, 60, 15, 20, "-");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)cb_4);
              o->clear_visible_focus();
            } // Fl_Button* o
            { Fl_Button* o = new Fl_Button(230, 60, 15, 20, "+");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)cb_5);
              o->clear_visible_focus();
            } // Fl_Button* o
            o->end();
          } // Fl_Group* o
          { Fl_Box* o = new Fl_Box(396, 60, 0, 20);
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        { wp_grid_margin = new Fl_Group(95, 100, 315, 20, "Margins:");
          wp_grid_margin->labelfont(1);
          wp_grid_margin->labelsize(11);
          wp_grid_margin->callback((Fl_Callback*)propagate_load);
          wp_grid_margin->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Value_Input* o = new Fl_Value_Input(95, 100, 55, 20, "Left:");
            o->tooltip("Left margin in group.");
            o->labelsize(11);
            o->maximum(1000);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Left);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(155, 100, 55, 20, "Top:");
            o->tooltip("Top margin in group.");
            o->labelsize(11);
            o->maximum(1000);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Top);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(215, 100, 55, 20, "Right:");
            o->tooltip("Right margin in group.");
            o->labelsize(11);
            o->maximum(1000);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Right);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(275, 100, 55, 20, "Bottom:");
            o->tooltip("Bottom margin in group.");
            o->labelsize(11);
            o->maximum(1000);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Bottom);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Box* o = new Fl_Box(396, 100, 0, 20);
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          wp_grid_margin->end();
        } // Fl_Group* wp_grid_margin
        { wp_grid_gaps = new Fl_Group(95, 135, 315, 20, "Gaps:");
          wp_grid_gaps->labelfont(1);
          wp_grid_gaps->labelsize(11);
          wp_grid_gaps->callback((Fl_Callback*)propagate_load);
          wp_grid_gaps->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Value_Input* o = new Fl_Value_Input(95, 135, 55, 20, "Row:");
            o->tooltip("Gap between children.");
            o->labelsize(11);
            o->maximum(1000);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Row);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Value_Input* o = new Fl_Value_Input(155, 135, 55, 20, "Col:");
            o->tooltip("Gap between children.");
            o->labelsize(11);
            o->maximum(1000);
            o->step(1);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_Col);
            o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          } // Fl_Value_Input* o
          { Fl_Box* o = new Fl_Box(396, 135, 0, 20);
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          wp_grid_gaps->end();
        } // Fl_Group* wp_grid_gaps
        { Fl_Group* o = new Fl_Group(95, 175, 315, 20, "Row:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_Row1);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { widget_grid_curr_row = new Fluid_Coord_Input(95, 175, 40, 20, "Index");
            widget_grid_curr_row->box(FL_DOWN_BOX);
            widget_grid_curr_row->color(FL_BACKGROUND2_COLOR);
            widget_grid_curr_row->selection_color(FL_SELECTION_COLOR);
            widget_grid_curr_row->labeltype(FL_NORMAL_LABEL);
            widget_grid_curr_row->labelfont(0);
            widget_grid_curr_row->labelsize(11);
            widget_grid_curr_row->labelcolor(FL_FOREGROUND_COLOR);
            widget_grid_curr_row->textsize(11);
            widget_grid_curr_row->callback((Fl_Callback*)cb_widget_grid_curr_row);
            widget_grid_curr_row->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_grid_curr_row->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_grid_curr_row
          { Fl_Group* o = new Fl_Group(135, 175, 30, 20);
            o->callback((Fl_Callback*)propagate_load);
            { Fl_Button* o = new Fl_Button(135, 175, 15, 20, "-");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)cb_6);
              o->clear_visible_focus();
            } // Fl_Button* o
            { Fl_Button* o = new Fl_Button(150, 175, 15, 20, "+");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)cb_7);
              o->clear_visible_focus();
            } // Fl_Button* o
            o->end();
          } // Fl_Group* o
          { Fl_Box* o = new Fl_Box(165, 175, 15, 20, ":");
            o->labelsize(11);
          } // Fl_Box* o
          { widget_grid_curr_row_attributes = new Fl_Group(180, 175, 175, 20);
            widget_grid_curr_row_attributes->callback((Fl_Callback*)propagate_load);
            { Fluid_Coord_Input* o = new Fluid_Coord_Input(180, 175, 55, 20, "Height:");
              o->box(FL_DOWN_BOX);
              o->color(FL_BACKGROUND2_COLOR);
              o->selection_color(FL_SELECTION_COLOR);
              o->labeltype(FL_NORMAL_LABEL);
              o->labelfont(0);
              o->labelsize(11);
              o->labelcolor(FL_FOREGROUND_COLOR);
              o->textsize(11);
              o->callback((Fl_Callback*)cb_Height);
              o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->when(FL_WHEN_RELEASE);
            } // Fluid_Coord_Input* o
            { Fluid_Coord_Input* o = new Fluid_Coord_Input(240, 175, 55, 20, "Weight:");
              o->box(FL_DOWN_BOX);
              o->color(FL_BACKGROUND2_COLOR);
              o->selection_color(FL_SELECTION_COLOR);
              o->labeltype(FL_NORMAL_LABEL);
              o->labelfont(0);
              o->labelsize(11);
              o->labelcolor(FL_FOREGROUND_COLOR);
              o->textsize(11);
              o->callback((Fl_Callback*)cb_Weight);
              o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->when(FL_WHEN_RELEASE);
            } // Fluid_Coord_Input* o
            { Fluid_Coord_Input* o = new Fluid_Coord_Input(300, 175, 55, 20, "Gap:");
              o->box(FL_DOWN_BOX);
              o->color(FL_BACKGROUND2_COLOR);
              o->selection_color(FL_SELECTION_COLOR);
              o->labeltype(FL_NORMAL_LABEL);
              o->labelfont(0);
              o->labelsize(11);
              o->labelcolor(FL_FOREGROUND_COLOR);
              o->textsize(11);
              o->callback((Fl_Callback*)cb_Gap);
              o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->when(FL_WHEN_RELEASE);
            } // Fluid_Coord_Input* o
            widget_grid_curr_row_attributes->end();
          } // Fl_Group* widget_grid_curr_row_attributes
          { Fl_Box* o = new Fl_Box(400, 175, 1, 20);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(95, 210, 315, 20, "Column:");
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { widget_grid_curr_col = new Fluid_Coord_Input(95, 210, 40, 20, "Index");
            widget_grid_curr_col->box(FL_DOWN_BOX);
            widget_grid_curr_col->color(FL_BACKGROUND2_COLOR);
            widget_grid_curr_col->selection_color(FL_SELECTION_COLOR);
            widget_grid_curr_col->labeltype(FL_NORMAL_LABEL);
            widget_grid_curr_col->labelfont(0);
            widget_grid_curr_col->labelsize(11);
            widget_grid_curr_col->labelcolor(FL_FOREGROUND_COLOR);
            widget_grid_curr_col->textsize(11);
            widget_grid_curr_col->callback((Fl_Callback*)cb_widget_grid_curr_col);
            widget_grid_curr_col->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            widget_grid_curr_col->when(FL_WHEN_RELEASE);
          } // Fluid_Coord_Input* widget_grid_curr_col
          { Fl_Group* o = new Fl_Group(135, 210, 30, 20);
            { Fl_Button* o = new Fl_Button(135, 210, 15, 20, "-");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)cb_8);
              o->clear_visible_focus();
            } // Fl_Button* o
            { Fl_Button* o = new Fl_Button(150, 210, 15, 20, "+");
              o->compact(1);
              o->labelsize(11);
              o->callback((Fl_Callback*)cb_9);
              o->clear_visible_focus();
            } // Fl_Button* o
            o->end();
          } // Fl_Group* o
          { Fl_Box* o = new Fl_Box(165, 210, 15, 20, ":");
            o->labelsize(11);
          } // Fl_Box* o
          { widget_grid_curr_col_attributes = new Fl_Group(180, 210, 175, 20);
            widget_grid_curr_col_attributes->callback((Fl_Callback*)propagate_load);
            { Fluid_Coord_Input* o = new Fluid_Coord_Input(180, 210, 55, 20, "Width:");
              o->box(FL_DOWN_BOX);
              o->color(FL_BACKGROUND2_COLOR);
              o->selection_color(FL_SELECTION_COLOR);
              o->labeltype(FL_NORMAL_LABEL);
              o->labelfont(0);
              o->labelsize(11);
              o->labelcolor(FL_FOREGROUND_COLOR);
              o->textsize(11);
              o->callback((Fl_Callback*)cb_Width);
              o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->when(FL_WHEN_RELEASE);
            } // Fluid_Coord_Input* o
            { Fluid_Coord_Input* o = new Fluid_Coord_Input(240, 210, 55, 20, "Weight:");
              o->box(FL_DOWN_BOX);
              o->color(FL_BACKGROUND2_COLOR);
              o->selection_color(FL_SELECTION_COLOR);
              o->labeltype(FL_NORMAL_LABEL);
              o->labelfont(0);
              o->labelsize(11);
              o->labelcolor(FL_FOREGROUND_COLOR);
              o->textsize(11);
              o->callback((Fl_Callback*)cb_Weight1);
              o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->when(FL_WHEN_RELEASE);
            } // Fluid_Coord_Input* o
            { Fluid_Coord_Input* o = new Fluid_Coord_Input(300, 210, 55, 20, "Gap:");
              o->box(FL_DOWN_BOX);
              o->color(FL_BACKGROUND2_COLOR);
              o->selection_color(FL_SELECTION_COLOR);
              o->labeltype(FL_NORMAL_LABEL);
              o->labelfont(0);
              o->labelsize(11);
              o->labelcolor(FL_FOREGROUND_COLOR);
              o->textsize(11);
              o->callback((Fl_Callback*)cb_Gap1);
              o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->when(FL_WHEN_RELEASE);
            } // Fluid_Coord_Input* o
            widget_grid_curr_col_attributes->end();
          } // Fl_Group* widget_grid_curr_col_attributes
          { Fl_Box* o = new Fl_Box(400, 210, 1, 20);
            o->hide();
            Fl_Group::current()->resizable(o);
          } // Fl_Box* o
          o->end();
        } // Fl_Group* o
        { Fl_Box* o = new Fl_Box(95, 350, 300, 5);
          o->labelsize(11);
          o->hide();
          Fl_Group::current()->resizable(o);
        } // Fl_Box* o
        widget_tab_grid->end();
      } // Fl_Group* widget_tab_grid
      o->show();
      widget_tabs->end();
      Fl_Group::current()->resizable(widget_tabs);
    } // Fl_Tabs* widget_tabs
    { Fl_Tabs* o = widget_tabs_repo = new Fl_Tabs(10, 10, 400, 350);
      widget_tabs_repo->hide();
      { Fl_Group* o = new Fl_Group(10, 30, 400, 330);
        o->end();
        Fl_Group::current()->resizable(o);
      } // Fl_Group* o
      o->hide();
      widget_tabs_repo->end();
    } // Fl_Tabs* widget_tabs_repo
    { Fl_Group* o = new Fl_Group(10, 370, 400, 20);
      o->labelsize(11);
      { wLiveMode = new Fl_Button(10, 370, 80, 20, "Live &Resize");
        wLiveMode->tooltip("Create a live duplicate of the selected widgets to test resizing and menu beh"
"avior.");
        wLiveMode->type(1);
        wLiveMode->labelsize(10);
        wLiveMode->callback((Fl_Callback*)live_mode_cb);
      } // Fl_Button* wLiveMode
      { overlay_button = new Fl_Button(94, 370, 80, 20, "Hide &Overlays");
        overlay_button->tooltip("Hide the widget overlay box.");
        overlay_button->labelsize(10);
        overlay_button->callback((Fl_Callback*)overlay_cb);
      } // Fl_Button* overlay_button
      { // Hidden resizable box
        Fl_Box* o = new Fl_Box(258, 370, 72, 20);
        o->labelsize(11);
        o->hide();
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      { Fl_Return_Button* o = new Fl_Return_Button(330, 370, 80, 20, "Close");
        o->labelsize(11);
        o->callback((Fl_Callback*)ok_cb);
      } // Fl_Return_Button* o
      o->end();
    } // Fl_Group* o
    o->size_range(420, 400);
    o->size_range(o->w(), o->h());
    o->end();
  } // Fl_Double_Window* o
  return w;
}
