# pv - Pipe Viewer - is a terminal-based tool for monitoring the progress of
# data through a pipeline.
# See: http://www.ivarch.com/programs/pv.shtml

complete -c pv -l progress -s p -d 'Turn progress bar on'
complete -c pv -l timer -s t -d 'Show timer'
complete -c pv -l eta -s e -d 'Show estimated time left'
complete -c pv -l fineta -s I -d 'Show estimated time of arrival'
complete -c pv -l rate -s r -d 'Show rate counter'
complete -c pv -l average-rate -s a -d 'Show average rate'
complete -c pv -l bytes -s b -d 'Show total byte counter'
complete -c pv -l buffer-percent -s T -d 'Show transfer buffer percentage'
complete -c pv -l last-written -s A -d 'Show the last NUM bytes written'
complete -c pv -l format -s F -x -d 'Set output format'
complete -c pv -l numeric -s n -d 'Numeric output'
complete -c pv -l quiet -s q -d 'No output'
complete -c pv -l wait -s W -d 'Wait for first byte before showing progress'
complete -x -c pv -l delay-start -s D -d 'Wait given time (in secs) before showing progress'
complete -x -c pv -l size -s s -d 'Set total number of bytes to be transfered'
complete -c pv -l line-mode -s l -d 'Count lines instead of bytes'
complete -c pv -l null -s 0 -d 'Count null-terminated lines'
complete -x -c pv -l interval -s i -d 'Wait given time (in secs) between updates'
complete -x -c pv -l width -s w -d 'Set terminal width'
complete -x -c pv -l height -s H -d 'Set terminal height'
complete -x -c pv -l name -l N -d 'Prefix output with given name'
complete -c pv -l force -s f -d 'Force output'
complete -c pv -l cursor -s c -d 'Use cursor positioning escape sequence instead of \r'
complete -x -c pv -l rate-limit -s L -d 'Limit transfer rate'
complete -x -c pv -l buffer-size -s B -d 'Use transfer buffer size (in bytes)'
complete -c pv -l no-splice -s C -d 'Don\'t use slice'
complete -c pv -l skip-errors -s E -d 'Ignore read errors'
complete -c pv -l stop-at-size -s S -d 'Stop transfer after given number of bytes'
complete -x -c pv -l watchfd -s d -d 'Watch file given description from given process (PID:FD)'
complete -x -c pv -l remote -s R -d 'Change a running pv\'s options' -a '(__fish_complete_pids | string match \*\tpv\*)'
complete -x -c pv -l pidfile -s P -d 'Save pv PID in given file'
complete -c pv -l help -s h -d 'Show help and exit'
complete -c pv -l version -s V -d 'Show version and exit'
