package ONVIF::Analytics::Types::AudioSourceConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::Analytics::Types::ConfigurationEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %UseCount_of :ATTR(:get<UseCount>);
my %SourceToken_of :ATTR(:get<SourceToken>);

__PACKAGE__->_factory(
    [ qw(        Name
        UseCount
        SourceToken

    ) ],
    {
        'Name' => \%Name_of,
        'UseCount' => \%UseCount_of,
        'SourceToken' => \%SourceToken_of,
    },
    {
        'Name' => 'ONVIF::Analytics::Types::Name',
        'UseCount' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'SourceToken' => 'ONVIF::Analytics::Types::ReferenceToken',
    },
    {

        'Name' => 'Name',
        'UseCount' => 'UseCount',
        'SourceToken' => 'SourceToken',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::AudioSourceConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AudioSourceConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * SourceToken




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::AudioSourceConfiguration
   SourceToken => $some_value, # ReferenceToken
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

