#include "configs.h"
#include "xvid4.h"

typedef struct _xvid_transcode_module_t
{
	/* Options from the config file */
	xvid_enc_create_t    cfg_create;
	xvid_enc_frame_t     cfg_frame;
	xvid_plugin_single_t cfg_onepass;
	xvid_plugin_2pass2_t cfg_pass2;
	char *cfg_intra_matrix_file;
	char *cfg_inter_matrix_file;
	char *cfg_quant_method;
	char *cfg_payback_method;
	int cfg_packed;
	int cfg_closed_gop;
	int cfg_interlaced;
	int cfg_quarterpel;
	int cfg_gmc;
	int cfg_trellis;
	int cfg_cartoon;
	int cfg_hqacpred;
	int cfg_chromame;
	int cfg_vhq;
	int cfg_motion;
	int cfg_stats;
	int cfg_greyscale;
	int cfg_turbo;
} xvid_transcode_module_t;

int read_config_file(xvid_transcode_module_t *mod, char *file, int read);
int read_matrix(int *matrix, const char *filename);

extern GtkBuilder *builder; 
extern GtkWidget *window1;
extern GtkWidget *matrix_edit_dlg;

extern xvid_transcode_module_t xcfg;
extern xvid_transcode_module_t xcfg_sav;
extern char *ifile;
extern char *ofile;
int xvidcfg2window(void);
int window2xvidcfg(void);

int matrix2window(int *matrix);
int window2matrix(int *matrix);

