/* -----------------------------------------------------------------------------
The copyright in this software is being made available under the Clear BSD
License, included below. No patent rights, trademark rights and/or 
other Intellectual Property Rights other than the copyrights concerning 
the Software are granted under this license.

The Clear BSD License

Copyright (c) 2019-2023, Fraunhofer-Gesellschaft zur Förderung der angewandten Forschung e.V. & The VVenC Authors.
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted (subject to the limitations in the disclaimer below) provided that
the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

     * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived from this
     software without specific prior written permission.

NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY
THIS LICENSE. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.


------------------------------------------------------------------------------------------- */


/** \file     Rom.cpp
    \brief    global variables & functions
*/

#include "Rom.h"
#include "UnitTools.h"

#include <memory.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iomanip>

//! \ingroup CommonLib
//! \{

namespace vvenc {

// ====================================================================================================================
// Initialize / destroy functions
// ====================================================================================================================

#if ENABLE_TRACING
CDTrace *g_trace_ctx = nullptr;
#endif

#if ENABLE_TIME_PROFILING
TProfiler *g_timeProfiler = nullptr;
#endif
#if ENABLE_CU_MODE_COUNTERS
StatCounters::StatCounter2DSet<int64_t> g_cuCounters1D( std::vector<std::string> { g_cuCounterIdNames, std::end( g_cuCounterIdNames ) }, 8, 1 );
StatCounters::StatCounter2DSet<int64_t> g_cuCounters2D( std::vector<std::string> { g_cuCounterIdNames, std::end( g_cuCounterIdNames ) }, MAX_CU_SIZE_IDX, MAX_CU_SIZE_IDX );
#endif

// global logger message callback function - DEPRECATED - will be removed in next major version
std::function<void( void*, int, const char*, va_list )> g_msgFnc = nullptr;
void * g_msgFncCtx = nullptr;
// end global loger

// ====================================================================================================================
// LFNST Tables
// ====================================================================================================================
  const static uint8_t g_auiXYDiagScan8x8[64][2] = {
    { 0, 0 }, { 0, 1 }, { 1, 0 }, { 0, 2 }, { 1, 1 }, { 2, 0 }, { 0, 3 }, { 1, 2 }, { 2, 1 }, { 3, 0 }, { 1, 3 },
    { 2, 2 }, { 3, 1 }, { 2, 3 }, { 3, 2 }, { 3, 3 }, { 0, 4 }, { 0, 5 }, { 1, 4 }, { 0, 6 }, { 1, 5 }, { 2, 4 },
    { 0, 7 }, { 1, 6 }, { 2, 5 }, { 3, 4 }, { 1, 7 }, { 2, 6 }, { 3, 5 }, { 2, 7 }, { 3, 6 }, { 3, 7 }, { 4, 0 },
    { 4, 1 }, { 5, 0 }, { 4, 2 }, { 5, 1 }, { 6, 0 }, { 4, 3 }, { 5, 2 }, { 6, 1 }, { 7, 0 }, { 5, 3 }, { 6, 2 },
    { 7, 1 }, { 6, 3 }, { 7, 2 }, { 7, 3 }, { 4, 4 }, { 4, 5 }, { 5, 4 }, { 4, 6 }, { 5, 5 }, { 6, 4 }, { 4, 7 },
    { 5, 6 }, { 6, 5 }, { 7, 4 }, { 5, 7 }, { 6, 6 }, { 7, 5 }, { 6, 7 }, { 7, 6 }, { 7, 7 }
  };

  const uint8_t g_lfnstLut[NUM_INTRA_MODE + NUM_EXT_LUMA_MODE - 1] = {
  0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

const int8_t g_lfnstFwd8x8[4][2][16][48] = {
  { // 0
    {
      { -117, 28, 18, 2, 4, 1, 2, 1, 32, -18, -2, 0, -1, 0, 0, 0, 14, -1, -3, 0, -1, 0, 0, 0,
        2,    0,  0,  0, 0, 0, 0, 0, 3,  0,   -1, 0, 1,  0, 0, 0, 1,  0,  0,  0, 1,  0, 0, 0 },
      { -29, -91, 47, 1, 9, 0, 3, 0, -54, 26, -8, 3, 0,  1, 0, 0, 33, 5, -9, -1, -2, 0, -1, 0,
        -3,  3,   0,  0, 0, 0, 0, 0, 7,   2,  -2, 0, -1, 1, 0, 0, 2,  1, -1, 0,  0,  0, 0,  0 },
      { -10, 62, -11, -8, -2, -2, -1, -1, -95, 3,  32, 0, 4, 0, 2,  0, 32, -30, -4, 4, -1, 1, 0, 0,
        6,   2,  -5,  0,  0,  0,  0,  0,  6,   -3, 0,  0, 2, 0, -1, 0, 2,  -1,  0,  0, 1,  0, 0, 0 },
      { -15, 15,  -10, -2, 1, 0, 1, 0, 10, 112, -20, -17, -4, -4, -1, -2, -20, -26, 31, 1, 0, 0,  0, 0,
        2,   -16, -1,  6,  0, 1, 0, 0, 1,  -4,  0,   0,   0,  -3, 0,  1,  0,   -1,  0,  0, 0, -2, 0, 0 },
      { 32,  39, 92, -44, 4, -10, 1, -4, 26, 12, -15, 13, -5, 2, -2, 0, 29, -16, -22, 8, 0,  1, 0, 1,
        -20, 6,  4,  -3,  1, 0,   0, 0,  1,  -4, -3,  2,  -4, 1, 0,  0, 1,  -1,  -2,  1, -2, 0, 0, 0 },
      { -10, 1,   50,  -15, 2,  -3, 1,  -1, -28, -15, 14, 6, 1, 1,  1,  0, -99, -4, 9,  5, 5, 2, 2,  1,
        44,  -10, -11, 1,   -2, 0,  -1, 0,  -5,  4,   -3, 0, 8, -1, -2, 0, -2,  1,  -1, 0, 4, 0, -1, 0 },
      { 1,  -33, -11, -14, 7, -2, 2, 0,  29, -12, 37, -7, -4, 0, -1, 0, 6,  -99, 3, 26, -1, 5, 0,  2,
        14, 30,  -27, -2,  1, -1, 0, -1, -6, 6,   6,  -3, 1,  3, -3, 0, -1, 1,   1, 0,  0,  1, -1, 0 },
      { 0, 6,  -6, 21, -4, 2,  0, 0,  -20, -24, -104, 30, 5, 5, 1, 2,  -7, -46, 10, -14, 7, 0, 1, 0,
        9, 21, 7,  -6, -2, -1, 0, -1, 2,   2,   5,    -2, 0, 3, 4, -1, 0,  0,   1,  0,   0, 1, 2, -1 },
      { -13, -13, -37, -101, 29, -11, 8, -3, -12, -15, -20, 2, -11, 5, -2, 1, -12, 10, 26, 12, -6, 0, -1, 0,
        -32, -2,  11,  3,    3,  -1,  1, 0,  11,  -5,  -1,  6, -4,  2, 1,  0, 3,   -1, 1,  2,  -1, 0, 0,  0 },
      { 6,   1, -14, -36, 9,  -3, 2,  0, 10,  9,  -18, -1, -3, 1,  0,  0, 38, 26, -13, -1, -5, -1, -1, 0,
        102, 3, -14, -1,  -5, -1, -2, 0, -29, 10, 10,  0,  10, -4, -1, 1, -7, 1,  2,   1,  2,  -1, 0,  0 },
      { -12, -2, -26, -12, -9, 2,  -1, 1,  -3, 30, 4,  34, -4, 0, -1, 0,  -30, 3,  -92, 14, 19, 0, 3, 0,
        -11, 34, 21,  -33, 1,  -2, 0,  -1, -9, -4, 18, 3,  2,  0, 0,  -2, -1,  -1, 3,   0,  0,  0, 0, -1 },
      { 0,  -3,  0,  -4, -15, 6, -3, 1, -7,  -15, -28, -86, 19, -5, 4, -1, -5, -17, -41, 42, -6, 2,  -1, 1,
        -1, -40, 37, 13, -4,  2, -1, 1, -10, 13,  -1,  -4,  4,  -4, 3, 4,  -2, 2,   -1,  -1, 1,  -1, 1,  2 },
      { -1,  9,  13, 5,  14, -2, 2, -1, -8,  3,  -4, -62, 4, 1,  1,  0, -12, 23, 16, -11, -17, 0, -1, 0,
        -11, 97, -3, -3, 0,  -6, 0, -2, -21, -5, 23, 0,   2, -2, -1, 6, -3,  -3, 1,  0,   0,   0, 0,  2 },
      { 6,  2,  -3, 2,  10, -1, 2,  0, 8,   3,  -1,  -20, 0,   1,  0, 0,  -4, 4,  -16, 0, -2, 0, 1, 0,
        34, 23, 6,  -7, -4, -2, -1, 0, 108, -5, -30, 6,   -27, 10, 7, -2, 11, -3, -1,  1, -4, 1, 0, 1 },
      { 6,  9,   -2, 35, 110, -22, 11, -4, -2, 0, -3, 1,  -18, 12, -3, 2, -5, -4, -22, 8,  -25, 3, 0, 0,
        -3, -21, 2,  -3, 9,   -2,  1,  0,  -7, 1, 3,  -5, 3,   0,  -1, 0, 0,  1,  0,   -1, 1,   0, 0, 0 },
      { -1,  7, -2,  9,  -11, 5,  -1, 1, -7, 2,  -22, 4,   -13, 0,  -1, 0, 0, 28, 0, 76, 4,  -6, 0, -2,
        -13, 5, -76, -4, 33,  -1, 3,  0, 9,  18, -3,  -35, -4,  -1, 6,  1, 1, 2,  0, -3, -1, 0,  2, 0 },
    },
    {
      { -108, 48, 9, 1, 1, 1, 0, 0, 44, -6, -9, -1, -1, 0, -1, 0, 9, -9, -1, 1, 0, 0, 0, 0,
        3,    -1, 1, 0, 0, 0, 0, 0, 1,  -1, 0,  0,  1,  0, 0,  0, 0, -1, 0,  0, 0, 0, 0, 0 },
      { 55, 66, -37, -5, -6, -1, -2, 0, 67, -30, -20, 4, -2, 0, -1, 0, -31, -19, 14, 4, 1, 1, 1, 0,
        -6, 3,  5,   -2, 0,  0,  0,  0, -7, -1,  1,   0, -1, 1, 1,  0, -2,  -1,  1,  0, 0, 0, 0, 0 },
      { 2,  86, -21, -13, -4, -2, -1, -1, -88, 5,  6, 4, 5, 1,  1, 0, 14, -5, 0, 3, 0, 0, 0, 0,
        10, -5, -2,  0,   -1, 0,  0,  0,  6,   -5, 0, 1, 2, -1, 0, 0, 1,  -1, 0, 0, 1, 0, 0, 0 },
      { -24, -21, -38, 19, 0,  4,  -1, 2, -23, -89, 31, 20, 2, 3, 1,  1,  -30, 26, 36, -8, -2, -2, 0,  -1,
        14,  18,  -7,  -9, -1, -1, 0,  0, 1,   3,   -2, -1, 3, 2, -2, -1, 0,   1,  0,  0,  1,  1,  -1, 0 },
      { 9,  20, 98, -26, -3, -5, 0, -2, -9, -26, 15, -16, 2, 0, 1,  0, -61, -3, -2, 3, 7, 1, 1,  0,
        12, 16, -6, -1,  0,  -1, 0, 0,  2,  0,   -8, 1,   3, 1, -1, 1, 0,   -1, -2, 0, 1, 0, -1, 0 },
      { -21, -7, -37, 10, 2,  2, -1, 1, -10, 69, -5, -7, -2, -2, 0, -1, -93, 2, 19, 0, 3, 0,  2, 0,
        17,  4,  0,   0,  -1, 0, 0,  0, 5,   -4, -2, 0,  4,  -2, 0, 1,  0,   0, 0,  0, 2, -1, 0, 0 },
      { -10, -25, 4,  -17, 8,  -2, 2, -1, -27, -17, -71, 25, 8,  2, 1, 1,  -4, -66, 28, 36, -5, 3, 0, 1,
        -10, 20,  33, -13, -8, 0,  0, -1, 3,   6,   -3,  -7, -1, 3, 3, -1, 1,  0,   -1, 0,  0,  1, 1, -1 },
      { 2,   5, 10, 64, -9, 4, -3, 1, -4, 8,  62, 3,  -17, 1, -2, 0, -3, -75, 5,  -14, 1, 4, 0,  1,
        -36, 3, 18, -4, 4,  0, 1,  0, 1,  14, -2, -8, -2,  1, -3, 0, 2,  2,   -1, -2,  0, 1, -1, 0 },
      { -11, -15, -28, -97, 6, -1, 4, -1, 7,  3, 57, -15, 10, -2, 0,  -1, -1, -27, 13, 6, 1,  -1, 0,  0,
        -34, -6,  0,   3,   4, 1,  2, 0,  -2, 8, 1,  5,   -2, 0,  -3, 1,  1,  1,   0,  2, -1, 0,  -1, 0 },
      { 9, 13, 24, -6,  7,  -2, 1, -1, 16, 39, 20,  47, -2, -2, -2, 0,  28, 23, 76, -5, -25, -3, -3, -1,
        6, 36, -7, -39, -4, -1, 0, -1, 2,  -4, -18, -3, -1, -1, -2, -2, 1,  -2, -2, 0,  0,   0,  -1, -1 },
      { -7,   11,  12, 7, 2, -1, 0, -1, -14, -1, -24, 11, 2, 0, 0,  0,  -20, 48, 11, -13, -5, -2, 0, -1,
        -105, -19, 17, 0, 6, 2,  3, 0,  -14, 8,  8,   2,  1, 2, -1, -2, 3,   0,  -1, 0,   0,  0,  0, 0 },
      { 0,  0,   7,  -6, 23, -3, 3, -1, 5, 1,  18, 96, 13, -9, -1, -1, -21, -7, -42, 14, -24, -3, 0, 0,
        11, -47, -7, 3,  -5, 9,  1, 2,  0, -1, 19, -1, 1,  0,  -1, -6, -1,  1,  2,   0,  1,   0,  0, -2 },
      { -2,  -6, -1,  -10, 0,  1,  1, 0, -7, -2,  -28, 20, -15, 4, -3, 1,  -2, -32, -2, -66, 3,  7, 1, 2,
        -11, 13, -70, 5,   43, -2, 3, 0, 8,  -14, -3,  43, -1,  2, 7,  -1, 1,  -2,  1,  3,   -1, 1, 1, 0 },
      { -1,  6,  -16, 0,  24, -3, 1, -1, 2,  6,  6,   16, 18, -7, 1,  -1, -3, 11, -63, 9, 4, -5, 2, -1,
        -22, 94, -4,  -6, -4, -4, 1, -2, 10, 23, -19, -5, 0,  -6, -4, 6,  3,  -2, 1,   1, 0, -1, 0, 0 },
      { -5, -6, -3, -19, -104, 18, -4, 3, 0,  6, 0,  35, -41, 20, -2, 2,  -2, 10, -18, 16, 21, 3, -2, 0,
        -2, 11, 6,  -10, 6,    -3, -1, 0, -1, 5, -1, -6, -1,  -1, -1, -1, -1, 0,  0,   0,  0,  0, 0,  -1 },
      { -1,  -2, 0,   23, -9, 0,  -2, 0,  1,   1,   8,   -1, 29, 1, 1,  0, 3, -6, 13, 76, 30, -11, -1, -2,
        -26, -8, -69, 7,  -9, -7, 3,  -1, -10, -34, -25, 13, -1, 0, 11, 5, 1, -1, 1,  -2, 0,  0,   2,  0 },
    } },
  { // 1
    {
      { 110, -49, -3, -4, -1, -1, 0, -1, -38, -1, 10, 0, 2,  0, 1, 0, -9, 13, 1, -2, 0,  0, 0, 0,
        -4,  2,   -3, 0,  0,  0,  0, 0,  -2,  2,  0,  1, -1, 1, 0, 0, -1, 1,  0, 0,  -1, 0, 0, 0 },
      { -43, -19, 17, -1, 3, 0, 1, 0, -98, 46, 14, -1, 2, 0,  1, 0, 26, 26, -15, -3, -2, -1, -1, 0,
        11,  -7,  -9, 2,  0, 0, 0, 0, 9,   -3, -1, 2,  3, -3, 0, 0, 4,  -1, 0,   0,  2,  -1, 0,  0 },
      { -19, 17, -7,  3,   -2, 1,  -1, 0,  -32, -59, 29,  3, 4, 0, 2,  0, -72, 43, 34, -9, 3, -2, 1,  -1,
        13,  36, -18, -10, 0,  -2, 0,  -1, 3,   0,   -12, 3, 6, 1, -3, 2, 1,   -1, -2, 0,  3, 1,  -1, 1 },
      { -35, -103, 39, 1,  7, 0,  2, 0, 38, -13, 25, -6, 1,  -1, 0,  0, -1, 7, 6,  -7, 1,  -1, 0,  0,
        -13, 14,   2,  -4, 2, -1, 0, 0, -2, 11,  -6, -2, -2, 4,  -3, 0, 0,  3, -2, 0,  -1, 1,  -1, 0 },
      { 9,  5,   -6,  -1, -1, 0, -1, 0, 42, 4,   21, -11, 1, -3, 1,  -1, 21, 70, -32, -21, 0, -4, -1, -1,
        34, -26, -57, 11, 4,  2, 0,  1, -4, -32, 5,  24,  1, -6, 12, 4,  -3, -2, 4,   -2,  0, -1, 0,  0 },
      { -5, -5,  -28, 9,  -3, 2, -1, 1, -20, -78, 22, 16, 1,  3, 0, 1,  80, -6, 25, -5, -4, -1, -1, 0,
        6,  -24, 7,   -9, 0,  0, 0,  0, -7,  3,   13, -4, -3, 5, 1, -5, -2, 3,  1,  -2, -1, 2,  -1, -2 },
      { 14, 17, 27,  -12, 1, -3, 1, -1, 8,  19,  -13, 4,  -2, 1,   -1, 0,  48, -1, 48, -15, -4, -2, -1, -1,
        1,  60, -28, -42, 5, -6, 1, -2, 11, -11, -51, 11, -2, -10, -2, 13, 2,  -6, -4, 4,   -2, -3, 2,  2 },
      { 7,   35, 17, -4, -1, 0, 0, 0, 3,   8,  54, -17, 1, -2, 1,   -1, 10, 14, -11, -34, 4, -4, 1,  -1,
        -80, -7, -6, 2,  15, 0, 3, 0, -16, 46, 1,  3,   2, 7,  -24, 0,  2,  -2, -5,  8,   1, -1, -2, 2 },
      { -13, -27, -101, 24,  -8, 6, -3, 2, 11, 43, 6,   28, -6, 3,  -1, 1, -3, 14, 21, -12, -7, -2, -1, -1,
        -23, 10,  -4,   -12, 3,  0, 1,  0, 2,  9,  -10, 0,  1,  -5, -4, 4, 2,  -2, 2,  2,   0,  -2, 1,  0 },
      { -11, -13, -3,  -10, 3,  -1, 1, 0, -19, -19, -37, 8,  4,  2, 0,  1, -12, -30, 3, -9, 5,  0, 1, 0,
        -56, -9,  -47, 8,   21, 1,  4, 1, -11, -30, 10,  59, -2, 8, 41, 8, 2,   5,   6, -7, -1, 3, 5, -2 },
      { -4,  -10, -24, -11, 3, -2, 0, -1, -6, -37, -45, -17, 8,  -2,  2,   -1, 17, 14,  -58, 14, 15, 0,  2, 0,
        -10, 34,  -7,  28,  4, -1, 1, 0,  23, 34,  -31, 4,   10, -22, -30, 22, 4,  -15, 9,   20, 2,  -5, 9, 4 },
      { -2,  1,  13, -17, 3,   -5, 1,  -2, 3,   0, -55, 22,  6, 1,  1,  0,   8,  74, 21, 40, -14, 0, -2, 0,
        -36, -8, 11, -13, -23, 1,  -3, 0,  -36, 6, 16,  -14, 2, 19, -4, -12, -1, 0,  -7, -3, 0,   2, -2, -1 },
      { 3, 1,  5,   -15, 1,  -2, 1, -1, 7,  4,  -7, 29, -1, 2, -1, 1,   8, 3,   12,  -14, -9, -1, -1, 0,
        4, 29, -15, 31,  10, 4,  1, 1,  61, 22, 55, 14, 13, 3, -9, -65, 1, -11, -21, -7,  0,  0,  -1, 3 },
      { -4, -8,  -1,  -50, 6,  -4, 2, -2, -1,  5,  -22, 20, 6, 1, 0,   0,  -16, -15, 18, -29, -11, 2, -2, 1,
        40, -45, -19, -22, 31, 2,  4, 1,  -25, 41, 0,   12, 9, 7, -42, 12, -3,  -14, 2,  28,  5,   1, 6,  2 },
      { 5,  -1,  26,  102, -13, 12, -4, 4, -4, -2, -40, -7, -23, 3, -5,  1,  -1, 5,   8,  -23, 7, 2, 1, 1,
        10, -11, -13, -3,  12,  -3, 2,  0, -9, 23, 4,   9,  14,  9, -14, -4, 0,  -12, -7, 6,   3, 0, 6, 3 },
      { -5, -6, -27, -22, -12, 0,  -3, 0,  -5,  8,  -20, -83, 0,   0,  0, 0,   9,  7,  24,  -20, 41, 3, 6,  1,
        15, 20, 12,  11,  17,  -9, 1,  -2, -26, -1, 18,  -1,  -12, 32, 3, -18, -5, 10, -25, -5,  -2, 1, -8, 10 },
    },
    {
      { 80, -49, 6, -4, 1, -1, 1, -1, -72, 36, 4,  0,  1,  0,  0,  0, 26, 0, -12, 2, -2, 1,  -1, 0,
        -7, -9,  6, 1,  0, 0,  0, 0,  3,   5,  -1, -2, -2, -2, -1, 1, 1,  1, 0,   0, -1, -1, 0,  0 },
      { -72, -6, 17, 0,  3, 0,  1, 0, -23, 58, -21, 2, -3, 1,  -1, 0, 55, -46, -1, 6,  -2, 1,  -1, 0,
        -22, 7,  17, -7, 2, -1, 1, 0, 9,   5,  -12, 1, -3, -4, 4,  2, 4,  1,   -2, -1, -1, -1, 1,  0 },
      { -50, 19,  -15, 4,  -1, 1, -1, 1, -58, -2, 30, -3,  4, -1, 2,   0, 6,  57, -34, 0, -2, 0, -1, 0,
        34,  -48, -2,  14, -4, 3, -1, 1, -10, 7,  21, -10, 6, 1,  -11, 0, -1, -1, 4,   2, 3,  0, -2, -1 },
      { -33, -43, 28,  -7, 4,  -2, 2,  -1, -38, 11,  -8, 4,  1,  1,  0,  0,   -55, 24, 26,  -5, 2, -1, 1, 0,
        15,  46,  -40, -1, -1, 0,  -1, 0,  17,  -38, 1,  17, -3, 11, 15, -11, 3,   -1, -10, 1,  0, 1,  3, 2 },
      { 10,  66, -21, -3, -3, 0,  -1, 0,  -53, -41, -2, 16, -1, 4,  -1, 1,  36, -5, 41, -20, 3, -3, 1, -1,
        -30, 26, -32, -3, 7,  -2, 2,  -1, 15,  -8,  1,  17, -1, -2, 4,  -8, 2,  0,  -1, 3,   0, 0,  0, -1 },
      { 18, 14,  13,  -9, 2,  -2, 1,  -1, 34, 32,  -31, 12, -5,  2,  -2, 1,   40, 4,  -4, -9, -3, -2, -1, -1,
        27, -31, -43, 19, -2, 3,  -1, 1,  7,  -49, 52,  10, -11, 22, 7,  -26, -1, -6, -9, 6,  -2, 2,  4,  -2 },
      { 21, 66, -1, 9,   -4, 2,  -1, 1,  -21, 41,  -30, -10, 0, -2, 0,  -1, -35, -17, -3, 26, -6, 5,  -2, 2,
        56, 3,  18, -25, -1, -2, -1, -1, -15, -13, -27, 9,   9, -6, 20, 5,  -3,  2,   -6, -9, 3,  -3, 1,  5 },
      { 1,  -6, -24, 17,  -5, 3,  -2, 1, 24, 10,  39,  -21, 5, -4,  2,  -1, 33, 32, -30, 4,   -3, -1, -1, 0,
        -4, 13, -16, -10, 0,  -1, 0,  0, 24, -26, -37, 33,  5, -32, 55, -5, -7, 22, -14, -22, 1,  -9, -3, 13 },
      { 9,   33, -24, 1,  4,   0, 1,  0, 6,  50,  26, 1,   -10, 0,  -2,  0,  -27, 1,  -28, -21, 16, -5, 3,  -2,
        -23, 36, -2,  40, -17, 4, -3, 1, 43, -13, 4,  -41, -19, -2, -24, 17, 11,  -4, 8,   4,   -3, -3, -3, -3 },
      { -7,  -9,  -32, 14, -3, 3, -1, 1, -23, -28, 0,  -5, -1,  0,  0,  0,   -36, -59, -24, 14,  4,  2,  1, 1,
        -23, -26, 23,  26, -3, 5, 0,  2, 10,  -26, 38, 7,  -12, 11, 42, -22, -5,  20,  -14, -15, -1, -2, 1, 6 },
      { 6,   30,  69, -18, 5,  -4, 3,  -1, -3, -11, -34, -16, 9, -4,  2, -1,  -16, 35, -35, 30, -9, 3,  -2, 1,
        -57, -13, 6,  4,   -5, 5,  -1, 1,  28, 10,  4,   7,   0, -15, 7, -10, -1,  7,  -2,  2,  1,  -3, 0,  0 },
      { 1,  -8, 24, -3, 7,   -2, 2,  -1, -6, -51, -6, -4,  -5,  0, -1, 0,  38, -1, 0, 25, 6,  2,  1,  1,
        47, 20, 35, 1,  -27, 1,  -5, 0,  37, -37, -9, -47, -28, 5, 0,  18, 8,  6,  0, -8, -4, -3, -3, 1 },
      { 4, 10, 4,  17,  -9, 4,  -2, 1,  5,  14, 32, -15, 9,  -3, 2,   -1,  7,  13, 19,  15, -8, 1,   -1, 0,
        3, 25, 30, -18, 1,  -2, 0,  -1, 11, 24, 22, -11, -3, 37, -13, -58, -5, 12, -63, 26, 9,  -15, 11, 8 },
      { -3, -9, -23, 10,  -10, 3, -3, 1, -5, -14, -16, -27, 13,  -5,  2,   -1, -1, -13, -30, 11, -5, 2,   -1, 0,
        -5, -8, -22, -16, 10,  0, 1,  0, 0,  -29, -27, 6,   -27, -10, -30, 9,  -3, -10, -7,  77, 9,  -13, 45, -8 },
      { 2,   11, 22,  2, 9,   -2, 2,  0, -6,  -7,  20, -32, -3, -4, 0, -1, 13, -5,  -28, 6,   18, -4, 3, -1,
        -26, 27, -14, 6, -20, 0,  -2, 0, -76, -26, -4, -7,  12, 51, 5, 24, 7,  -17, -16, -12, -5, 4,  2, 13 },
      { 2,  -3, 8,  14, -5,  3, -1, 1, -2, -11, 5,  -18, 8,  -3,  2,  -1,  12,  -23, -19, 22, 2, 0,  1,  0,
        23, 41, -7, 35, -10, 4, -1, 1, 5,  7,   23, 5,   69, -38, -8, -32, -15, -31, 24,  11, 2, 18, 11, -15 },
    } },
  { // 2
    {
      { -121, 33, 4, 4, 1, 2, 0, 1, -1, -1, 1, 0, 0, 0,  0, 0, 24, -5, -1, -1, 0, 0, 0, 0,
        5,    -1, 0, 0, 0, 0, 0, 0, 3,  -1, 0, 0, 2, -1, 0, 0, 2,  -1, 0,  0,  1, 0, 0, 0 },
      { 0,   -2, 0, 0, 0, 0, 0, 0, 121, -23, -7, -3, -2, -1, -1, 0, 17, 1, -2, 0, 0,  0, 0, 0,
        -27, 4,  2, 0, 0, 0, 0, 0, -12, 2,   1,  0,  -5, 1,  0,  0, -1, 0, 0,  0, -2, 0, 0, 0 },
      { -20, 19, -5, 2, -1, 1, 0, 0, 16, 3,  -2, 0, 0, 0,  0,  0, -120, 14, 8, 1, 3, 1, 1, 0,
        -18, -2, 3,  0, 1,  0, 0, 0, 17, -3, -1, 0, 6, -1, -1, 0, 2,    0,  0, 0, 2, 0, 0, 0 },
      { 32, 108, -43, 10, -9, 3, -3, 1, 4,  19, -7, 1, -1, 0,  0, 0, 11, -30, 9, -2, 1, -1, 0, 0,
        0,  -8,  2,   0,  0,  0, 0,  0, -7, -1, 2,  0, -3, -1, 1, 0, -2, -2,  1, 0,  0, 0,  0, 0 },
      { -3,   0,  -1, 0, 0, 0, 0, 0, -29, 11, -2, 1, 0,  0,  0,  0, 12, 7, -1, 0, 0, 0, 0, 0,
        -117, 12, 9,  1, 3, 0, 1, 0, -32, -3, 3,  0, 12, -2, -1, 0, 7,  0, 0,  0, 1, 0, 0, 0 },
      { -4, -12, -3, 1,  -1, 0, 0, 0, 19, 105, -31, 7, -6, 1,  -2, 0, 9, 46, -6, 0, 0, 0,  0, 0,
        8,  -29, 9,  -3, 1,  0, 0, 0, -3, -19, 3,   0, -4, -6, 1,  0, 0, 0,  0,  0, 0, -1, 0, 0 },
      { 7,   1,  2, 0, 0, 0, 0, 0, 4,   3,   -2, 0, 0,  0, 0,  0, 22, -8, 1,  -1, 0,  0, 0, 0,
        -28, -9, 4, 0, 1, 0, 0, 0, 117, -10, -8, 0, 32, 1, -4, 0, 3,  1,  -1, 0,  -3, 1, 0, 0 },
      { -8, -31, 14, -4, 3, -1, 1, 0, 9,  43, 0,  1, -1, 0, 0, 0, -13, -105, 17, -2, 2, 0, 0,  0,
        -8, -25, -3, 0,  0, 0,  0, 0, -7, 32, -5, 1, -1, 4, 0, 0, 2,   -1,   0,  0,  1, 0, -1, 0 },
      { -15, -43, -100, 23, -12, 6,  -4, 2, -6, -17, -48, 10, -5, 2, -1, 1, 1,  -5, 19, -6, 3,  -1, 1, 0,
        2,   7,   15,   -3, 1,   -1, 0,  0, 4,  10,  5,   -1, 0,  3, 1,  0, -2, 1,  2,  0,  -1, 1,  1, 0 },
      { -3,  1, 2,  0, 0, 0, 0, 0, -6, 3,  1,  0, 0,    0, 0,  0, 0,   3,  -2, 0, 0,  0,  0, 0,
        -20, 8, -2, 0, 0, 0, 0, 0, 30, 13, -3, 0, -116, 6, 10, 0, -35, -5, 4,  0, -3, -1, 0, 0 },
      { -1, -6,   -3, 2,  -1, 0, 0, 0, -6,  -35, 9, 0, 2,   0, 0,  0, 1,  -6, 11, -2, 2, 0, 1,  0,
        -9, -100, 17, -1, 1,  0, 0, 0, -10, -63, 1, 2, -17, 3, -4, 0, -1, 9,  -1, 0,  3, 4, -1, 0 },
      { -5, -14, -48, 2, -5, 1, -2, 0, 10, 24, 99, -17, 10, -4, 3,  -1, 4, 14, 32, 0, 2, 0,  1,  0,
        -4, 0,   -39, 6, -4, 1, -1, 0, 2,  -3, -4, 0,   2,  -2, -2, 0,  0, 0,  -1, 0, 0, -1, -1, 0 },
      { -2, 0,  2, 0, 0, 0, 0, 0, -2, 0,  1,  0, 0,  0, 0,  0, -1,   -1, 1, -1, 0,   0,  0, 0,
        -1, -4, 2, 0, 0, 0, 0, 0, -8, -2, -1, 1, 30, 4, -4, 1, -102, 4,  8, -1, -69, -2, 6, -1 },
      { -2, -10, -4, 0, 0, 0, 0, 0, 3, 11,  -1, -1, 0,   0,   0,  0, -6, -40, -15, 6, -2, 1, 0, 0,
        5,  57,  -6, 2, 0, 0, 0, 0, 1, -95, 18, -6, -10, -34, -2, 0, -4, 17,  -2,  0, 0,  2, 1, 0 },
      { -2, -3,  -25, -2, -3, 0,  -1, 0,  -1, -3, -1, 4,  -2, 2, 0,  1,  -7, -8, -97, 17, -9, 3, -3, 1,
        -8, -26, -61, -1, -3, -1, -1, -1, 2,  10, 24, -7, 5,  9, 19, -1, 0,  1,  4,   0,  -2, 0, 1,  0 },
      { 4,  -4, 28,  103, -42, 24, -9, 7, 1,  2,  4,  0, 3, -1, 0, 0,  -1, 0, -9, -42, 17, -9, 3, -2,
        -1, 1,  -14, 6,   -4,  2,  -1, 0, -1, -2, -4, 4, 0, 3,  1, -1, 0,  2, 0,  -2,  2,  0,  0, 0 },
    },
    {
      { 87, -41, 3, -4, 1, -1, 0, -1, -73, 28, 2,  1, 1,  1,  0, 0, 30, -5, -6, 1, -1, 0, 0, 0,
        -8, -3,  3, 0,  0, 0,  0, 0,  3,   2,  -1, 0, -2, -1, 0, 0, 1,  1,  0,  0, -1, 0, 0, 0 },
      { -75, 4, 7, 0,  2, 0, 1, 0, -41, 36, -7, 3, -1, 1,  0, 0, 72, -29, -2, 0, -1, 0, -1, 0,
        -37, 6, 7, -2, 1, 0, 0, 0, 12,  3,  -4, 0, -3, -2, 1, 0, 4,  0,   0,  0, -1, 0, 0,  0 },
      { 26,  -44, 22, -6, 4, -2, 1, -1, 77, 24, -22, 2, -4,  0, -1, 0,  7, -38, 10, 0, 1,  0,  0, 0,
        -51, 27,  4,  -3, 2, -1, 1, 0,  31, -5, -8,  3, -14, 0, 5,  -1, 6, 1,   -3, 0, -4, -1, 1, 0 },
      { -39, -68, 37, -7, 6,  -2, 2, 0, -9,  56, -21, 1, -2, 0, -1, 0, -45, 4, -3, 6, -1, 2, 0, 1,
        49,  -13, 3,  -3, -1, 0,  0, 0, -19, 2,  0,   0, 5,  1, 1,  0, -2,  0, -1, 0, 1,  0, 0, 0 },
      { 10, -20, 2,  0, 1, 0, 0, 0, 50,  -1, 8, -5, 1,  -1, 0,   0, 66,  17, -24, 4, -3, 1, -1, 0,
        13, -49, 15, 1, 0, 0, 0, 0, -53, 34, 6, -5, 30, -7, -11, 3, -11, -2, 5,   1, 4,  2, -1, -1 },
      { -21, -45, 8,  -2, 3,  -1, 1, 0, -7, -30, 26, -8, 3,   -1, 1,  -1, -9, 69, -33, 5, -2, 0,  -1, 0,
        -44, -31, 10, 7,  -2, 2,  0, 1, 49, 7,   2,  -6, -23, -3, -2, 2,  9,  4,  0,   0, -2, -1, -1, 0 },
      { -4,  -2, -55, 28, -8, 5, -3, 2, -2,  37, 43, -19, 1,  -2,  1,  -1, -47, -34, -27, 5,  4, -1, 1,  0,
        -39, -2, 27,  4,  -2, 1, 0,  0, -11, 32, -8, -7,  27, -12, -6, 6,  -13, 0,   4,   -3, 3, -1, -2, 1 },
      { 2,   19,  47, -23, 6, -4, 2, -1, -23, -22, -44, 17, -2, 2,   -1, 0,  -33, 3,  22, -2, -4, 1, -1, 0,
        -58, -17, 6,  -6,  7, -1, 1, 0,  -23, 40,  -2,  5,  43, -11, -8, -1, -18, -4, 5,  2,  4,  3, 0,  -1 },
      { -19, -62, -9,  3, 0,  0, 0, 0, -12, -56, 27, -7, 3,  -1, 1, 0,  7,   -8, 16, -6, 4, -2, 1, -1,
        -15, 54,  -23, 2, -1, 0, 0, 0, -42, -25, 4,  6,  34, 8,  2, -2, -15, -1, 0,  -1, 3, 2,  0, 1 },
      { 1,   9,   -5,  0, -1, 0, 0, 0, 0,   22,  -1, 2,  0,   1,  0,  0,  -13, 17, 0,  -2, 0,   -1, 0, 0,
        -46, -10, -10, 4, -1, 1, 0, 0, -80, -27, 20, -4, -66, 23, -2, -2, 20,  -3, -2, 3,  -14, 2,  3, -1 },
      { 5,   17, -9,  0, -2, 1, 0,  0, 13, 54,  -2, 7, -1, 1,  0,  0,  4,   51, -3, -6, -1, -1, 0, 0,
        -20, 6,  -34, 9, -2, 2, -1, 0, 16, -52, 28, 1, 59, 15, -8, -5, -28, -7, 2,  2,  10, 3,  0, -1 },
      { 7, 27, 56, -2, 10, -3, 3,  -1, -2,  -6,  8,   -28, 3, -4, 1, -1, -1, -4, -68, 35, -5, 5,  -2, 1,
        0, 35, 43, -4, -6, 1,  -1, 0,  -14, -38, -12, -10, 9, 5,  7, 6,  -9, 7,  -4,  -3, 4,  -4, 0,  3 },
      { 0, 0,  19, -4, 3,  -2, 2,  -1, -3, -13, 10, -4,  1,  0,  0,   0, -6, -37, -18, -5, 2,   -2, 1, -1,
        6, -6, -7, 25, -6, 4,  -1, 1,  16, 10,  55, -24, 15, 46, -52, 1, 35, -43, 10,  12, -23, 13, 5, -8 },
      { -3, 0, -27, -80, 40, -16, 6, -4, 4,  3,  31, 61, -22, 7, -1, 1,  -4, -7, -26, -6, -10, 6, -4, 1,
        3,  8, 14,  -18, 15, -5,  2, -1, -2, -4, -1, 13, 0,   2, -4, -3, 3,  -1, 2,   1,  -2,  0, -2, -1 },
      { 1,  2,  -8, 6,   -1, 1,  0, 0, 2,  8,  -5,  -1, 0,  0,   0,  0, 1,  24, 3,   5,  -1,  1,  0, 0,
        -3, 12, 6,  -10, 1,  -1, 0, 0, -9, -1, -25, 10, 45, -11, 18, 2, 86, 1,  -13, -4, -65, -6, 7, 2 },
      { -4, -18, -57, 8,   -8, 1,  -3, 0, -5, -20, -69, 7,  -6, 2,  -2,  1, 1,  4,   0, 33, -7, 5, -2, 1,
        0,  -9,  53,  -22, 3,  -1, 0,  0, 4,  -27, -2,  -9, 5,  36, -13, 5, -7, -17, 1, 2,  4,  6, 4,  -1 },
    } },
  { // 3
    {
      { -115, 37, 9,  2,  2, 1, 1, 0, 10, -29, 8, 0,  1, 0, 1, 0, 23, -8, -8, 1, -1, 0, 0, 0,
        3,    3,  -2, -1, 0, 0, 0, 0, 4,  0,   0, -1, 1, 1, 0, 0, 2,  0,  0,  0, 0,  0, 0, 0 },
      { 15, 51, -18, 0, -3, 0, -1, 0, -95, 7,  34, -3, 5, -1, 2,  0, 23, -47, 1, 6, 0, 1, 0,  1,
        8,  5,  -12, 0, -1, 0, 0,  0, 3,   -3, 1,  -1, 2, 1,  -2, 0, 1,  -1,  0, 0, 1, 1, -1, 0 },
      { 29,  -22, 16, -6,  3, -2, 1, -1, -4, -80, 12, 15, 0,  3, 0, 1,  45, 7, -59, 7, -2, 1, -1, 0,
        -15, 41,  -3, -16, 2, -3, 0, -1, 1,  0,   7,  -2, -3, 6, 1, -2, 0,  0, 1,   0, -1, 2, 0,  -1 },
      { -36, -98, 25,  5, 4,  1, 2, 1, -59, 11, -17, 1,  1, 1, 0, 0, 6, -13, 7, -3, 0, 0, 0, 0,
        14,  -4,  -14, 3, -1, 0, 0, 0, 2,   8,  -3,  -5, 2, 0, 0, 0, 0, 3,   0, -1, 1, 0, 0, 0 },
      { -6,  18,  3,  -3, -1,  0, 0,  0, -50, -5,  -38, 12, 0,  2, 0, 1,  3, 67, -7, -40, 3,  -6, 1, -3,
        -12, -13, 65, -3, -10, 0, -1, 0, 9,   -20, -5,  22, -2, 0, 0, -1, 2, -3, -2, 3,   -1, 0,  1, 0 },
      { 4,  15,  52, -13, 5, -3, 2, -1, -17, -45, 16,  24, -2, 4,  -1, 2,  -87, -8, -14, 7, 8, 1, 2, 0,
        23, -35, -6, -3,  1, 1,  0, 0,  2,   5,   -17, 0,  3,  -1, -1, -5, 0,   1,  -4,  0, 1, 0, 0, -2 },
      { -20, -7, -43, 4,   0, 1,  -1, 1,  -7, 35,  0,  12, -4, 1,  -1, 0, -51, -2, -57, 5, 15, 0,  4,  0,
        7,   39, 5,   -55, 1, -7, 1,  -3, 1,  -10, 41, 2,  4,  -3, -2, 3, -1,  -2, 7,   1, 1,  -1, -1, 0 },
      { 4,   29, 1,   26, -5, 4,  -2, 1, -17, -7, -73, 6,   6, 2,  1,  1, -5, 21, -3, 5,  -1, -3, 0, -1,
        -11, 2,  -52, -3, 27, -2, 5,  0, 0,   27, 8,   -58, 2, -5, 25, 3, 0,  3,  0,  -5, 0,  -2, 7, 0 },
      { 12, 13, 10, 2,  -1,  3, -1, 1, 17,  -2, -46, 12, 7, 0, 2, 0,  16, -45, -9, -53, 6, 1, 1, 0,
        70, 16, 8,  -4, -37, 1, -7, 0, -12, 29, 3,   21, 4, 0, 5, -1, -3, 4,   1,  4,   2, 0, 1, 0 },
      { 5,   20, 90, -17, 4, -3, 2, -1, 6, 66, 8,  28, -7, 3,  -1, 1, 29, 5,  -19, 12, 9, -1, 1, 0,
        -10, 14, -1, -13, 7, 0,  1, 0,  0, -6, 13, -4, 0,  -4, 1,  5, 0,  -1, -1,  1,  0, -1, 0, 0 },
      { -3, -4,  -34, -12, 2, -1, -1, 0, 5,  25, 11,  43, -10, 4,  -2, 1,   23, 20, -40, 12, 21, -3, 4, -1,
        25, -28, -10, 5,   8, 6,  0,  2, -4, 21, -64, -8, -5,  19, 10, -48, 3,  -1, 10,  -3, 0,  4,  3, -6 },
      { -1,  -3,  2, 19, -2,  4, -1, 2, 9, 3,   -35, 22, 11, 1, 2,   0,   -7, -65, -19, -22, 11, 4, 2,  1,
        -75, -18, 3, -1, -10, 2, 0,  1, 2, -35, -27, 4,  1,  8, -17, -19, 3,  0,   3,   -6,  0,  2, -1, -2 },
      { 10, -4,  -6, 12,  5,  1, 1, 0, 11, -9,  -12, -2, -7, 0,  -1,  0,  33, -10, -4,  18, 18, -4, 4,  -1,
        28, -72, 1,  -49, 15, 2, 2, 1, 56, -23, 22,  -1, 4,  -1, -15, 26, 6,  4,   -10, 0,  0,  2,  -3, 2 },
      { 4,  6,  14, 53, -4, 4,  0, 2,  0,   -1,  -20, -13, 3, 2,  -1,  1,   -3, 1, -5, 35,  -16, -6, -1, -2,
        46, 29, 13, 21, 37, -5, 4, -1, -10, -53, -18, 8,   9, 12, -41, -25, -2, 2, 13, -16, 4,   1,  -5, 1 },
      { 2,   9,  13,  37,  19,  6, 2,  2, -9,  -3, -9, -28, -20, -4, -3,  -1,  1, 18, 9,  28,  24, 6,  2,  2,
        -20, -5, -25, -33, -36, 9, -2, 2, -13, 42, 1,  57,  -22, -2, -25, -28, 5, 6,  19, -12, -5, -3, -2, 4 },
      { 3, -3,  12, 84, -12, 8,  -2, 3,  6,  13, 50, -1,  45, 1, 7,  0, -2, 18, -22, -37, -13, 14, 0, 3,
        1, -12, -3, 2,  -15, -8, 1,  -1, 19, 14, -4, -12, -4, 5, 17, 8, 2,  -4, -4,  4,   -2,  2,  1, 0 },
    },
    {
      { 109, -26, -8, -3, -2, -1, -1, 0, -50, 28, 2, 1,  0, 0, 0, 0, -18, -8, 6, 0, 1, 0, 1, 0,
        6,   -2,  -3, 0,  0,  0,  0,  0, -3,  2,  1, -1, 0, 0, 0, 0, -2,  0,  0, 0, 0, 0, 0, 0 },
      { -39, 31, -5,  2, -1, 1, 0,  0, -95, 6, 18, 0,  4, 0, 1,  0,  32, -49, 5, 1, 1, 0, 0, 0,
        27,  -1, -14, 2, -2, 1, -1, 0, 3,   5, -3, -2, 4, 1, -1, -1, 2,  0,   0, 0, 2, 0, 0, 0 },
      { 29,  -3, -2, -2, 0, 0,  0, 0,  0,   -41, 9,  0, 2,  0,  1, 0, 86, 4,  -33, 2, -6, 1, -2, 0,
        -32, 58, 1,  -7, 0, -2, 0, -1, -14, -8,  20, 0, -2, -3, 0, 4, -1, -1, 0,   0, -1, 1, 0,  0 },
      { 18,  96, -23, 2,  -5, 1,  -2, 0, -10, 6,   10, -2, 1, -1, 1,   0, -14, 26, 2,  -4, 1, -1, 0,  0,
        -43, -9, 35,  -2, 4,  -1, 1,  0, 14,  -40, 1,  10, 2, 1,  -10, 1, 2,   -4, -1, -1, 0, 0,  -1, 0 },
      { -29, -60, 16, -2, 3, -1, 1, 0, -52, 9,   -17, 5,  -2, 1, -1,  1,  13, 56, -2, -9, 0, -2, 0,  -1,
        -34, -18, 41, 0,  3, 0,  1, 0, 19,  -36, -10, 13, 3,  6, -14, -1, 3,  1,  -1, -3, 1, 1,  -1, -1 },
      { -23, -5, -15, 5,   -2, 1,  -1, 1,  2,   79,  -13, -4, -2, -1,  -1, 0,  -9, 1, 5,   -1, 1, 0,  0, 0,
        -4,  49, 2,   -14, 1,  -3, 0,  -1, -31, -14, 56,  -1, 13, -37, -4, 20, -2, 2, -10, 0,  2, -4, 0, -1 },
      { -7, -3, 12, -3,  3, -1, 1, 0,  -31, -62, 8,  7,  0, 2,   0,  1,  -75, 9, -45, 5,  -1, 1, -1, 0,
        14, 35, 0,  -23, 2, -5, 1, -2, 1,   -8,  32, -1, 7, -12, -4, 10, 0,   2, -6,  -1, 2,  0, 0,  -2 },
      { 1,   -26, 5, 0, 1,  0, 1, 0, 24, -3,  43, -6, 4,  -2, 1,   -1, -7, -64, 9,  14,  0, 3, 0,  1,
        -12, -4,  5, 3, -1, 1, 0, 0, 8,  -59, -3, 26, 14, 6,  -58, 6,  -5, 17,  -7, -18, 3, 3, -1, -5 },
      { 11, 14, 6,  -3, 1,  -1, 1,  0, 10,  -7,  -9, 3,  -2, 1,  -1,  0, 22, 21, 1,  -21, 2, -4, 1, -2,
        92, 1,  53, 0,  -9, 1,  -2, 0, -21, -11, 1,  40, -5, -4, -24, 5, -4, 5,  -6, -5,  0, 0,  0, -3 },
      { -10, -11, -47, 3,   -4, 1,  -1, 0,  5,  28, 11,  -2, -1, 0,  0, 0,   -12, -2,  -38, 2, 0, 1,  0,  0,
        16,  38,  11,  -16, -1, -3, 0,  -2, 12, -9, -22, 7,  -8, 60, 4, -36, -6,  -15, 54,  7, 3, -7, -8, 14 },
      { -8, -24, -99, 11, -10, 3, -4, 1, -5, -36, 19, -26, 4,  -5,  1,  -2, 0, 25, 41,  5,  -3, 1, 0, 0,
        10, -5,  -7,  12, 2,   1, 0,  0, -1, 1,   9,  -3,  -3, -14, -3, 12, 2, 4,  -13, -2, -1, 3, 2, -4 },
      { -5,  1,  -1, 0,  1,  0, 0, 0, -10, -14, -6,  8,  0,  1,   0, 0,   -17, -2, 7, -5, 3, -1, 0, 0,
        -16, 13, 3,  31, -1, 6, 0, 2, -93, -15, -46, -3, 23, -19, 0, -47, 8,   4,  8, 3,  2, 3,  0, 0 },
      { 1,  12, -20, 21, -4, 5, -2, 2, -5, -2, -75, 9, -1,  2,  -1,  1,  -1, -2, -16, -4,  0, -1, 0,  0,
        -7, 7,  -31, 0,  3,  0, 0,  0, 4,  11, -12, 4, -12, 14, -50, -1, -8, 32, -4,  -54, 2, 0,  30, -15 },
      { 2,   -9, -18, 8,  -3,  3, -1, 1, 3,  -25, -62, -6, 0,  -2, 0,  -1, -6, -61, 14, -51, 2, -6, 0,   -2,
        -19, 0,  40,  -7, -17, 0, -3, 0, 13, -4,  11,  9,  17, 0,  24, 5,  1,  -12, 4,  28,  0, 0,  -15, 8 },
      { 4,  9,  39,  18, 0,  2, 0, 1, -6, -16, -22, -37, 5, -5, 1,  -2, -5,  15, 63, 9, -16, 0,   -3, 0,
        18, 42, -18, 27, 15, 1, 3, 1, 12, -34, 9,   -24, 4, 28, -2, 4,  -11, -4, 30, 2, 5,   -13, -4, 18 },
      { -7,  -2, 15, -6, 1,   -1, 1,  -1, -11, -3, 22, -14, 0,   -2, 1,   -1, -18, -7,  30, -9,  -4, 0,   -1, 0,
        -35, 23, 23, 10, -17, 1,  -3, 0,  -19, 53, 6,  48,  -65, 12, -12, 11, -8,  -16, 10, -21, -2, -12, 6,  2 },
    } }
};

const int8_t g_lfnstFwd4x4[4][2][16][16] = {
  { // 0
    {
      { 108, -44, -15, 1, -44, 19, 7, -1, -11, 6, 2, -1, 0, -1, -1, 0 },
      { -40, -97, 56, 12, -11, 29, -12, -3, 18, 18, -15, -3, -1, -3, 2, 1 },
      { 25, -31, -1, 7, 100, -16, -29, 1, -54, 21, 14, -4, -7, 2, 4, 0 },
      { -32, -39, -92, 51, -6, -16, 36, -8, 3, 22, 18, -15, 4, 1, -5, 2 },
      { 8, -9, 33, -8, -16, -102, 36, 23, -4, 38, -27, -5, 5, 16, -8, -6 },
      { -25, 5, 16, -3, -38, 14, 11, -3, -97, 7, 26, 1, 55, -10, -19, 3 },
      { 8, 9, 16, 1, 37, 36, 94, -38, -7, 3, -47, 11, -6, -13, -17, 10 },
      { 2, 34, -5, 1, -7, 24, -25, -3, 8, 99, -28, -29, 6, -43, 21, 11 },
      { -16, -27, -39, -109, 6, 10, 16, 24, 3, 19, 10, 24, -4, -7, -2, -3 },
      { -9, -10, -34, 4, -9, -5, -29, 5, -33, -26, -96, 33, 14, 4, 39, -14 },
      { -13, 1, 4, -9, -30, -17, -3, -64, -35, 11, 17, 19, -86, 6, 36, 14 },
      { 8, -7, -5, -15, 7, -30, -28, -87, 31, 4, 4, 33, 61, -5, -17, 22 },
      { -2, 13, -6, -4, -2, 28, -13, -14, -3, 37, -15, -3, -2, 107, -36, -24 },
      { 4, 9, 11, 31, 4, 9, 16, 19, 12, 33, 32, 94, 12, 0, 34, -45 },
      { 2, -2, 8, -16, 8, 5, 28, -17, 6, -7, 18, -45, 40, 36, 97, -8 },
      { 0, -2, 0, -10, -1, -7, -3, -35, -1, -7, -2, -32, -6, -33, -16, -112 },
    },
    {
      { 119, -30, -22, -3, -23, -2, 3, 2, -16, 3, 6, 0, -3, 2, 1, 0 },
      { -27, -101, 31, 17, -47, 2, 22, 3, 19, 30, -7, -9, 5, 3, -5, -1 },
      { 0, 58, 22, -15, -102, 2, 38, 2, 10, -13, -5, 4, 14, -1, -9, 0 },
      { 23, 4, 66, -11, 22, 89, -2, -26, 13, -8, -38, -1, -9, -20, -2, 8 },
      { -19, -5, -89, 2, -26, 76, -11, -17, 20, 13, 18, -4, 1, -15, 3, 5 },
      { -10, -1, -1, 6, 23, 25, 87, -7, -74, 4, 39, -5, 0, -1, -20, -1 },
      { -17, -28, 12, -8, -32, 14, -53, -6, -68, -67, 17, 29, 2, 6, 25, 4 },
      { 1, -24, -23, 1, 17, -7, 52, 9, 50, -92, -15, 27, -15, -10, -6, 3 },
      { -6, -17, -2, -111, 7, -17, 8, -42, 9, 18, 16, 25, -4, 2, -1, 11 },
      { 9, 5, 35, 0, 6, 21, -9, 34, 44, -3, 102, 11, -7, 13, 11, -20 },
      { 4, -5, -5, -10, 15, 19, -2, 6, 6, -12, -13, 6, 95, 69, -29, -24 },
      { -6, -4, -9, -39, 1, 22, 0, 102, -19, 19, -32, 30, -16, -14, -8, -23 },
      { 4, -4, 7, 8, 4, -13, -18, 5, 0, 0, 21, 22, 58, -88, -54, 28 },
      { -4, -7, 0, -24, -7, 0, -25, 3, -3, -30, 8, -76, -34, 4, -80, -26 },
      { 0, 6, 0, 30, -6, 1, -13, -23, 1, 20, -2, 80, -44, 37, -68, 1 },
      { 0, 0, -1, 5, -1, -7, 1, -34, -2, 3, -6, 19, 5, -38, 11, -115 },
    } },
  { // 1
    {
      { -111, 39, 4, 3, 44, 11, -12, -1, 7, -16, -5, 2, 3, -1, 4, 2 },
      { -47, -27, 15, -1, -92, 43, 20, -2, 20, 39, -16, -5, 10, -5, -13, 2 },
      { -35, -23, 4, 4, -17, -72, 32, 6, -59, 18, 50, -6, 0, 40, 0, -13 },
      { 13, 93, -27, -4, -48, 13, -34, 4, -52, 11, 1, 10, 3, 16, -3, 1 },
      { -11, -27, 1, 2, -47, -4, -36, 10, -2, -85, 14, 29, -20, -2, 57, 4 },
      { 0, -35, 32, -2, 26, 60, -3, -17, -82, 1, -30, 0, -37, 21, 3, 12 },
      { -17, -46, -92, 14, 7, -10, -39, 29, -17, 27, -28, 17, 1, -15, -13, 17 },
      { 4, -10, -23, 4, 16, 58, -17, 26, 30, 21, 67, 2, -13, 59, 13, -40 },
      { 5, -20, 32, -5, 8, -3, -46, -7, -4, 2, -15, 24, 100, 44, 0, 5 },
      { -4, -1, 38, -18, -7, -42, -63, -6, 33, 34, -23, 15, -65, 33, -20, 2 },
      { -2, -10, 35, -19, 5, 8, -44, 14, -25, 25, 58, 17, 7, -84, -16, -18 },
      { 5, 13, 18, 34, 11, -4, 18, 18, 5, 58, -3, 42, -2, -10, 85, 38 },
      { -5, -7, -34, -83, 2, -1, -4, -73, 4, 20, 15, -12, 4, -3, 44, 12 },
      { 0, 4, -2, -60, 5, 9, 42, 34, 5, -14, 9, 80, -5, 13, -38, 37 },
      { -1, 2, 7, -57, 3, -7, 9, 68, -9, 6, -49, -20, 6, -4, 36, -64 },
      { -1, 0, -12, 23, 1, -4, 17, -53, -3, 4, -21, 72, -4, -8, -3, -83 },
    },
    {
      { 88, -55, 6, -3, -66, 27, 9, -2, 11, 11, -13, 1, -2, -7, 1, 2 },
      { -58, -20, 27, -2, -27, 75, -29, 0, 47, -42, -11, 11, -9, -3, 19, -4 },
      { -51, 23, -22, 5, -63, 3, 37, -5, 1, 64, -35, -4, 29, -31, -11, 13 },
      { -27, -76, 49, -2, 40, 14, 9, -17, -56, 36, -25, 6, 14, 3, -6, 8 },
      { 19, -4, -36, 22, 52, 7, 36, -23, 28, -17, -64, 15, -5, -44, 48, 9 },
      { 29, 50, 13, -10, 1, 34, -59, 1, -51, 4, -16, 30, 52, -33, 24, -5 },
      { -12, -21, -74, 43, -13, 39, 18, -5, -58, -35, 27, -5, 19, 26, 6, -5 },
      { 19, 38, -10, -5, 28, 66, 0, -5, -4, 19, -30, -26, -40, 28, -60, 37 },
      { -6, 27, 18, -5, -37, -18, 12, -25, -44, -10, -38, 37, -66, 45, 40, -7 },
      { -13, -28, -45, -39, 0, -5, -39, 69, -23, 16, -12, -18, -50, -31, 24, 13 },
      { -1, 8, 24, -51, -15, -9, 44, 10, -28, -70, -12, -39, 24, -18, -4, 51 },
      { -8, -22, -17, 33, -18, -45, -57, -27, 0, -31, -30, 29, -2, -13, -53, 49 },
      { 1, 12, 32, 51, -8, 8, -2, -31, -22, 4, 46, -39, -49, -67, 14, 17 },
      { 4, 5, 24, 60, -5, -14, -23, 38, 9, 8, -34, -59, 24, 47, 42, 28 },
      { -1, -5, -20, -34, 4, 4, -15, -46, 18, 31, 42, 10, 10, 27, 49, 78 },
      { -3, -7, -22, -34, -5, -11, -36, -69, -1, -3, -25, -73, 5, 4, 4, -49 },
    } },
  { // 2
    {
      { -112, 47, -2, 2, -34, 13, 2, 0, 15, -7, 1, 0, 8, -3, -1, 0 },
      { 29, -7, 1, -1, -108, 40, 2, 0, -45, 13, 4, -1, 8, -5, 1, 0 },
      { -36, -87, 69, -10, -17, -33, 26, -2, 7, 14, -11, 2, 6, 8, -7, 0 },
      { 28, -5, 2, -2, -29, 13, -2, 0, 103, -36, -4, 1, 48, -16, -4, 1 },
      { -12, -24, 15, -3, 26, 80, -61, 9, 15, 54, -36, 2, 0, -4, 6, -2 },
      { 18, 53, 69, -74, 14, 24, 28, -30, -6, -7, -11, 12, -5, -7, -6, 8 },
      { 5, -1, 2, 0, -26, 6, 0, 1, 45, -9, -1, 0, -113, 28, 8, -1 },
      { -13, -32, 18, -2, 15, 34, -27, 7, -25, -80, 47, -1, -16, -50, 28, 2 },
      { -4, -13, -10, 19, 18, 46, 60, -48, 16, 33, 60, -48, 1, 0, 5, -2 },
      { 15, 33, 63, 89, 8, 15, 25, 40, -4, -8, -15, -8, -2, -6, -9, -7 },
      { -8, -24, -27, 15, 12, 41, 26, -29, -17, -50, -39, 27, 0, 35, -67, 26 },
      { -2, -6, -24, 13, -1, -8, 37, -22, 3, 18, -51, 22, -23, -95, 17, 17 },
      { -3, -7, -16, -21, 10, 24, 46, 75, 8, 20, 38, 72, 1, 2, 1, 7 },
      { 2, 6, 10, -3, -5, -16, -31, 12, 7, 24, 41, -16, -16, -41, -89, 49 },
      { 4, 8, 21, 40, -4, -11, -28, -57, 5, 14, 31, 70, 7, 18, 32, 52 },
      { 0, 1, 4, 11, -2, -4, -13, -34, 3, 7, 20, 47, -6, -19, -42, -101 },
    },
    {
      { -99, 39, -1, 2, 65, -20, -5, 0, -15, -2, 5, -1, 0, 3, -1, 0 },
      { 58, 42, -33, 3, 33, -63, 23, -1, -55, 32, 3, -5, 21, -2, -8, 3 },
      { -15, 71, -44, 5, -58, -29, 25, 3, 62, -7, -4, -4, -19, 4, 0, 1 },
      { 46, 5, 4, -6, 71, -12, -15, 5, 52, -38, 13, -2, -63, 23, 3, -3 },
      { -14, -54, -29, 29, 25, -9, 61, -29, 27, 44, -48, 5, -27, -21, 12, 7 },
      { -3, 3, 69, -42, -11, -50, -26, 26, 24, 63, -19, -5, -18, -22, 12, 0 },
      { 17, 16, -2, 1, 38, 18, -12, 0, 62, 1, -14, 5, 89, -42, 8, -2 },
      { 15, 54, -8, 6, 6, 60, -26, -8, -30, 17, -38, 22, -43, -45, 42, -7 },
      { -6, -17, -55, -28, 9, 30, -8, 58, 4, 34, 41, -52, -16, -36, -20, 16 },
      { -2, -1, -9, -79, 7, 11, 48, 44, -13, -34, -55, 6, 12, 23, 20, -11 },
      { 7, 29, 14, -6, 12, 53, 10, -11, 14, 59, -15, -3, 5, 71, -54, 13 },
      { -5, -24, -53, 15, -3, -15, -61, 26, 6, 30, -16, 23, 13, 56, 44, -35 },
      { 4, 8, 21, 52, -1, -1, -5, 29, -7, -17, -44, -84, 8, 20, 31, 39 },
      { -2, -11, -25, -4, -4, -21, -53, 2, -5, -26, -64, 19, -8, -19, -73, 39 },
      { -3, -5, -23, -57, -2, -4, -24, -75, 1, 3, 9, -25, 6, 15, 41, 61 },
      { 1, 1, 7, 18, 1, 2, 16, 47, 2, 5, 24, 67, 3, 9, 25, 88 },
    } },
  { // 3
    {
      { -114, 37, 3, 2, -22, -23, 14, 0, 21, -17, -5, 2, 5, 2, -4, -1 },
      { -19, -41, 19, -2, 85, -60, -11, 7, 17, 31, -34, 2, -11, 19, 2, -8 },
      { 36, -25, 18, -2, -42, -53, 35, 5, 46, -60, -25, 19, 8, 21, -33, -1 },
      { -27, -80, 44, -3, -58, 1, -29, 19, -41, 18, -12, -7, 12, -17, 7, -6 },
      { -11, -21, 37, -10, 44, -4, 47, -12, -37, -41, 58, 18, 10, -46, -16, 31 },
      { 15, 47, 10, -6, -16, -44, 42, 10, -80, 25, -40, 21, -23, -2, 3, -14 },
      { 13, 25, 79, -39, -13, 10, 31, -4, 49, 45, 12, -8, 3, -1, 43, 7 },
      { 16, 11, -26, 13, -13, -74, -20, -1, 5, -6, 29, -47, 26, -49, 54, 2 },
      { -8, -34, -26, 7, -26, -19, 29, -37, 1, 22, 46, -9, -81, 37, 14, 20 },
      { -6, -30, -42, -12, -3, 5, 57, -52, -2, 37, -12, 6, 74, 10, 6, -15 },
      { 5, 9, -6, 42, -15, -18, -9, 26, 15, 58, 14, 43, 23, -10, -37, 75 },
      { -5, -23, -23, 36, 3, 22, 36, 40, 27, -4, -16, 56, -25, -46, 56, -24 },
      { 1, 3, 23, 73, 8, 5, 34, 46, -12, 2, 35, -38, 26, 52, 2, -31 },
      { -3, -2, -21, -52, 1, -10, -17, 44, -19, -20, 30, 45, 27, 61, 49, 21 },
      { -2, -7, -33, -56, -4, -6, 21, 63, 15, 31, 32, -22, -10, -26, -52, -38 },
      { -5, -12, -18, -12, 8, 22, 38, 36, -5, -15, -51, -63, -5, 0, 15, 73 },
    },
    {
      { -102, 22, 7, 2, 66, -25, -6, -1, -15, 14, 1, -1, 2, -2, 1, 0 },
      { 12, 93, -27, -6, -27, -64, 36, 6, 13, 5, -23, 0, -2, 6, 5, -3 },
      { -59, -24, 17, 1, -62, -2, -3, 2, 83, -12, -17, -2, -24, 14, 7, -2 },
      { -33, 23, -36, 11, -21, 50, 35, -16, -23, -78, 16, 19, 22, 15, -30, -5 },
      { 0, -38, -81, 30, 27, 5, 51, -32, 24, 36, -16, 12, -24, -8, 9, 1 },
      { 28, 38, 8, -9, 62, 32, -13, 2, 51, -32, 15, 5, -66, 28, 0, -1 },
      { 11, -35, 21, -17, 30, -18, 31, 18, -11, -36, -80, 12, 16, 49, 13, -32 },
      { -13, 23, 22, -36, -12, 64, 39, 25, -19, 23, -36, 9, -30, -58, 33, -7 },
      { -9, -20, -55, -83, 3, -2, 1, 62, 8, 2, 27, -28, 7, 15, -11, 5 },
      { -6, 24, -38, 23, -8, 40, -49, 0, -7, 9, -25, -44, 23, 39, 70, -3 },
      { 12, 17, 17, 0, 32, 27, 21, 2, 67, 11, -6, -10, 89, -22, -12, 16 },
      { 2, -9, 8, 45, 7, -8, 27, 35, -9, -31, -17, -87, -23, -22, -19, 44 },
      { -1, -9, 28, -24, -1, -10, 49, -30, -8, -7, 40, 1, 4, 33, 65, 67 },
      { 5, -12, -24, -17, 13, -34, -32, -16, 14, -67, -7, 9, 7, -74, 49, 1 },
      { 2, -6, 11, 45, 3, -10, 33, 55, 8, -5, 59, 4, 7, -4, 44, -66 },
      { -1, 1, -14, 36, -1, 2, -20, 69, 0, 0, -15, 72, 3, 4, 5, 65 },
    } }
};

const int8_t g_lfnstInv8x8[4][2][48][16] = {
 {  //0
  {
   { -117,  -29,  -10,  -15,  +32,  -10,   +1,   +0,  -13,   +6,  -12,   +0,   -1,   +6,   +6,   -1,  },
   {  +28,  -91,  +62,  +15,  +39,   +1,  -33,   +6,  -13,   +1,   -2,   -3,   +9,   +2,   +9,   +7,  },
   {  +18,  +47,  -11,  -10,  +92,  +50,  -11,   -6,  -37,  -14,  -26,   +0,  +13,   -3,   -2,   -2,  },
   {   +2,   +1,   -8,   -2,  -44,  -15,  -14,  +21, -101,  -36,  -12,   -4,   +5,   +2,  +35,   +9,  },
   {   +4,   +9,   -2,   +1,   +4,   +2,   +7,   -4,  +29,   +9,   -9,  -15,  +14,  +10, +110,  -11,  },
   {   +1,   +0,   -2,   +0,  -10,   -3,   -2,   +2,  -11,   -3,   +2,   +6,   -2,   -1,  -22,   +5,  },
   {   +2,   +3,   -1,   +1,   +1,   +1,   +2,   +0,   +8,   +2,   -1,   -3,   +2,   +2,  +11,   -1,  },
   {   +1,   +0,   -1,   +0,   -4,   -1,   +0,   +0,   -3,   +0,   +1,   +1,   -1,   +0,   -4,   +1,  },
   {  +32,  -54,  -95,  +10,  +26,  -28,  +29,  -20,  -12,  +10,   -3,   -7,   -8,   +8,   -2,   -7,  },
   {  -18,  +26,   +3, +112,  +12,  -15,  -12,  -24,  -15,   +9,  +30,  -15,   +3,   +3,   +0,   +2,  },
   {   -2,   -8,  +32,  -20,  -15,  +14,  +37, -104,  -20,  -18,   +4,  -28,   -4,   -1,   -3,  -22,  },
   {   +0,   +3,   +0,  -17,  +13,   +6,   -7,  +30,   +2,   -1,  +34,  -86,  -62,  -20,   +1,   +4,  },
   {   -1,   +0,   +4,   -4,   -5,   +1,   -4,   +5,  -11,   -3,   -4,  +19,   +4,   +0,  -18,  -13,  },
   {   +0,   +1,   +0,   -4,   +2,   +1,   +0,   +5,   +5,   +1,   +0,   -5,   +1,   +1,  +12,   +0,  },
   {   +0,   +0,   +2,   -1,   -2,   +1,   -1,   +1,   -2,   +0,   -1,   +4,   +1,   +0,   -3,   -1,  },
   {   +0,   +0,   +0,   -2,   +0,   +0,   +0,   +2,   +1,   +0,   +0,   -1,   +0,   +0,   +2,   +0,  },
   {  +14,  +33,  +32,  -20,  +29,  -99,   +6,   -7,  -12,  +38,  -30,   -5,  -12,   -4,   -5,   +0,  },
   {   -1,   +5,  -30,  -26,  -16,   -4,  -99,  -46,  +10,  +26,   +3,  -17,  +23,   +4,   -4,  +28,  },
   {   -3,   -9,   -4,  +31,  -22,   +9,   +3,  +10,  +26,  -13,  -92,  -41,  +16,  -16,  -22,   +0,  },
   {   +0,   -1,   +4,   +1,   +8,   +5,  +26,  -14,  +12,   -1,  +14,  +42,  -11,   +0,   +8,  +76,  },
   {   -1,   -2,   -1,   +0,   +0,   +5,   -1,   +7,   -6,   -5,  +19,   -6,  -17,   -2,  -25,   +4,  },
   {   +0,   +0,   +1,   +0,   +1,   +2,   +5,   +0,   +0,   -1,   +0,   +2,   +0,   +0,   +3,   -6,  },
   {   +0,   -1,   +0,   +0,   +0,   +2,   +0,   +1,   -1,   -1,   +3,   -1,   -1,   +1,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +1,   +1,   +2,   +0,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   -2,  },
   {   +2,   -3,   +6,   +2,  -20,  +44,  +14,   +9,  -32, +102,  -11,   -1,  -11,  +34,   -3,  -13,  },
   {   +0,   +3,   +2,  -16,   +6,  -10,  +30,  +21,   -2,   +3,  +34,  -40,  +97,  +23,  -21,   +5,  },
   {   +0,   +0,   -5,   -1,   +4,  -11,  -27,   +7,  +11,  -14,  +21,  +37,   -3,   +6,   +2,  -76,  },
   {   +0,   +0,   +0,   +6,   -3,   +1,   -2,   -6,   +3,   -1,  -33,  +13,   -3,   -7,   -3,   -4,  },
   {   +0,   +0,   +0,   +0,   +1,   -2,   +1,   -2,   +3,   -5,   +1,   -4,   +0,   -4,   +9,  +33,  },
   {   +0,   +0,   +0,   +1,   +0,   +0,   -1,   -1,   -1,   -1,   -2,   +2,   -6,   -2,   -2,   -1,  },
   {   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +1,   -2,   +0,   -1,   +0,   -1,   +1,   +3,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   -1,   -1,   +0,   +0,   -1,   +1,   -2,   +0,   +0,   +0,  },
   {   +3,   +7,   +6,   +1,   +1,   -5,   -6,   +2,  +11,  -29,   -9,  -10,  -21, +108,   -7,   +9,  },
   {   +0,   +2,   -3,   -4,   -4,   +4,   +6,   +2,   -5,  +10,   -4,  +13,   -5,   -5,   +1,  +18,  },
   {   -1,   -2,   +0,   +0,   -3,   -3,   +6,   +5,   -1,  +10,  +18,   -1,  +23,  -30,   +3,   -3,  },
   {   +0,   +0,   +0,   +0,   +2,   +0,   -3,   -2,   +6,   +0,   +3,   -4,   +0,   +6,   -5,  -35,  },
   {   +1,   -1,   +2,   +0,   -4,   +8,   +1,   +0,   -4,  +10,   +2,   +4,   +2,  -27,   +3,   -4,  },
   {   +0,   +1,   +0,   -3,   +1,   -1,   +3,   +3,   +2,   -4,   +0,   -4,   -2,  +10,   +0,   -1,  },
   {   +0,   +0,   -1,   +0,   +0,   -2,   -3,   +4,   +1,   -1,   +0,   +3,   -1,   +7,   -1,   +6,  },
   {   +0,   +0,   +0,   +1,   +0,   +0,   +0,   -1,   +0,   +1,   -2,   +4,   +6,   -2,   +0,   +1,  },
   {   +1,   +2,   +2,   +0,   +1,   -2,   -1,   +0,   +3,   -7,   -1,   -2,   -3,  +11,   +0,   +1,  },
   {   +0,   +1,   -1,   -1,   -1,   +1,   +1,   +0,   -1,   +1,   -1,   +2,   -3,   -3,   +1,   +2,  },
   {   +0,   -1,   +0,   +0,   -2,   -1,   +1,   +1,   +1,   +2,   +3,   -1,   +1,   -1,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +2,   +1,   +0,   -1,   +0,   +1,   -1,   -3,  },
   {   +1,   +0,   +1,   +0,   -2,   +4,   +0,   +0,   -1,   +2,   +0,   +1,   +0,   -4,   +1,   -1,  },
   {   +0,   +0,   +0,   -2,   +0,   +0,   +1,   +1,   +0,   -1,   +0,   -1,   +0,   +1,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   -1,   -1,   +2,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +2,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   -1,   +2,   +2,   +1,   +0,   +0,  },
  },
  {
   { -108,  +55,   +2,  -24,   +9,  -21,  -10,   +2,  -11,   +9,   -7,   +0,   -2,   -1,   -5,   -1,  },
   {  +48,  +66,  +86,  -21,  +20,   -7,  -25,   +5,  -15,  +13,  +11,   +0,   -6,   +6,   -6,   -2,  },
   {   +9,  -37,  -21,  -38,  +98,  -37,   +4,  +10,  -28,  +24,  +12,   +7,   -1,  -16,   -3,   +0,  },
   {   +1,   -5,  -13,  +19,  -26,  +10,  -17,  +64,  -97,   -6,   +7,   -6,  -10,   +0,  -19,  +23,  },
   {   +1,   -6,   -4,   +0,   -3,   +2,   +8,   -9,   +6,   +7,   +2,  +23,   +0,  +24, -104,   -9,  },
   {   +1,   -1,   -2,   +4,   -5,   +2,   -2,   +4,   -1,   -2,   -1,   -3,   +1,   -3,  +18,   +0,  },
   {   +0,   -2,   -1,   -1,   +0,   -1,   +2,   -3,   +4,   +1,   +0,   +3,   +1,   +1,   -4,   -2,  },
   {   +0,   +0,   -1,   +2,   -2,   +1,   -1,   +1,   -1,   -1,   -1,   -1,   +0,   -1,   +3,   +0,  },
   {  +44,  +67,  -88,  -23,   -9,  -10,  -27,   -4,   +7,  +16,  -14,   +5,   -7,   +2,   +0,   +1,  },
   {   -6,  -30,   +5,  -89,  -26,  +69,  -17,   +8,   +3,  +39,   -1,   +1,   -2,   +6,   +6,   +1,  },
   {   -9,  -20,   +6,  +31,  +15,   -5,  -71,  +62,  +57,  +20,  -24,  +18,  -28,   +6,   +0,   +8,  },
   {   -1,   +4,   +4,  +20,  -16,   -7,  +25,   +3,  -15,  +47,  +11,  +96,  +20,  +16,  +35,   -1,  },
   {   -1,   -2,   +5,   +2,   +2,   -2,   +8,  -17,  +10,   -2,   +2,  +13,  -15,  +18,  -41,  +29,  },
   {   +0,   +0,   +1,   +3,   +0,   -2,   +2,   +1,   -2,   -2,   +0,   -9,   +4,   -7,  +20,   +1,  },
   {   -1,   -1,   +1,   +1,   +1,   +0,   +1,   -2,   +0,   -2,   +0,   -1,   -3,   +1,   -2,   +1,  },
   {   +0,   +0,   +0,   +1,   +0,   -1,   +1,   +0,   -1,   +0,   +0,   -1,   +1,   -1,   +2,   +0,  },
   {   +9,  -31,  +14,  -30,  -61,  -93,   -4,   -3,   -1,  +28,  -20,  -21,   -2,   -3,   -2,   +3,  },
   {   -9,  -19,   -5,  +26,   -3,   +2,  -66,  -75,  -27,  +23,  +48,   -7,  -32,  +11,  +10,   -6,  },
   {   -1,  +14,   +0,  +36,   -2,  +19,  +28,   +5,  +13,  +76,  +11,  -42,   -2,  -63,  -18,  +13,  },
   {   +1,   +4,   +3,   -8,   +3,   +0,  +36,  -14,   +6,   -5,  -13,  +14,  -66,   +9,  +16,  +76,  },
   {   +0,   +1,   +0,   -2,   +7,   +3,   -5,   +1,   +1,  -25,   -5,  -24,   +3,   +4,  +21,  +30,  },
   {   +0,   +1,   +0,   -2,   +1,   +0,   +3,   +4,   -1,   -3,   -2,   -3,   +7,   -5,   +3,  -11,  },
   {   +0,   +1,   +0,   +0,   +1,   +2,   +0,   +0,   +0,   -3,   +0,   +0,   +1,   +2,   -2,   -1,  },
   {   +0,   +0,   +0,   -1,   +0,   +0,   +1,   +1,   +0,   -1,   -1,   +0,   +2,   -1,   +0,   -2,  },
   {   +3,   -6,  +10,  +14,  +12,  +17,  -10,  -36,  -34,   +6, -105,  +11,  -11,  -22,   -2,  -26,  },
   {   -1,   +3,   -5,  +18,  +16,   +4,  +20,   +3,   -6,  +36,  -19,  -47,  +13,  +94,  +11,   -8,  },
   {   +1,   +5,   -2,   -7,   -6,   +0,  +33,  +18,   +0,   -7,  +17,   -7,  -70,   -4,   +6,  -69,  },
   {   +0,   -2,   +0,   -9,   -1,   +0,  -13,   -4,   +3,  -39,   +0,   +3,   +5,   -6,  -10,   +7,  },
   {   +0,   +0,   -1,   -1,   +0,   -1,   -8,   +4,   +4,   -4,   +6,   -5,  +43,   -4,   +6,   -9,  },
   {   +0,   +0,   +0,   -1,   -1,   +0,   +0,   +0,   +1,   -1,   +2,   +9,   -2,   -4,   -3,   -7,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   +2,   +0,   +3,   +1,   +3,   +1,   -1,   +3,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   -1,   +0,   +2,   +0,   -2,   +0,   -1,  },
   {   +1,   -7,   +6,   +1,   +2,   +5,   +3,   +1,   -2,   +2,  -14,   +0,   +8,  +10,   -1,  -10,  },
   {   -1,   -1,   -5,   +3,   +0,   -4,   +6,  +14,   +8,   -4,   +8,   -1,  -14,  +23,   +5,  -34,  },
   {   +0,   +1,   +0,   -2,   -8,   -2,   -3,   -2,   +1,  -18,   +8,  +19,   -3,  -19,   -1,  -25,  },
   {   +0,   +0,   +1,   -1,   +1,   +0,   -7,   -8,   +5,   -3,   +2,   -1,  +43,   -5,   -6,  +13,  },
   {   +1,   -1,   +2,   +3,   +3,   +4,   -1,   -2,   -2,   -1,   +1,   +1,   -1,   +0,   -1,   -1,  },
   {   +0,   +1,   -1,   +2,   +1,   -2,   +3,   +1,   +0,   -1,   +2,   +0,   +2,   -6,   -1,   +0,  },
   {   +0,   +1,   +0,   -2,   -1,   +0,   +3,   -3,   -3,   -2,   -1,   -1,   +7,   -4,   -1,  +11,  },
   {   +0,   +0,   +0,   -1,   +1,   +1,   -1,   +0,   +1,   -2,   -2,   -6,   -1,   +6,   -1,   +5,  },
   {   +0,   -2,   +1,   +0,   +0,   +0,   +1,   +2,   +1,   +1,   +3,   -1,   +1,   +3,   -1,   +1,  },
   {   -1,   -1,   -1,   +1,   -1,   +0,   +0,   +2,   +1,   -2,   +0,   +1,   -2,   -2,   +0,   -1,  },
   {   +0,   +1,   +0,   +0,   -2,   +0,   -1,   -1,   +0,   -2,   -1,   +2,   +1,   +1,   +0,   +1,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -2,   +2,   +0,   +0,   +0,   +3,   +1,   +0,   -2,  },
   {   +0,   +0,   +1,   +1,   +1,   +2,   +0,   +0,   -1,   +0,   +0,   +1,   -1,   +0,   +0,   +0,  },
   {   +0,   +0,   +0,   +1,   +0,   -1,   +1,   +1,   +0,   +0,   +0,   +0,   +1,   -1,   +0,   +0,  },
   {   +0,   +0,   +0,   -1,   -1,   +0,   +1,   -1,   -1,   -1,   +0,   +0,   +1,   +0,   +0,   +2,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   -1,   +0,   -2,   +0,   +0,   -1,   +0,  },
  },
 },
 {  //1
  {
   { +110,  -43,  -19,  -35,   +9,   -5,  +14,   +7,  -13,  -11,   -4,   -2,   +3,   -4,   +5,   -5,  },
   {  -49,  -19,  +17, -103,   +5,   -5,  +17,  +35,  -27,  -13,  -10,   +1,   +1,   -8,   -1,   -6,  },
   {   -3,  +17,   -7,  +39,   -6,  -28,  +27,  +17, -101,   -3,  -24,  +13,   +5,   -1,  +26,  -27,  },
   {   -4,   -1,   +3,   +1,   -1,   +9,  -12,   -4,  +24,  -10,  -11,  -17,  -15,  -50, +102,  -22,  },
   {   -1,   +3,   -2,   +7,   -1,   -3,   +1,   -1,   -8,   +3,   +3,   +3,   +1,   +6,  -13,  -12,  },
   {   -1,   +0,   +1,   +0,   +0,   +2,   -3,   +0,   +6,   -1,   -2,   -5,   -2,   -4,  +12,   +0,  },
   {   +0,   +1,   -1,   +2,   -1,   -1,   +1,   +0,   -3,   +1,   +0,   +1,   +1,   +2,   -4,   -3,  },
   {   -1,   +0,   +0,   +0,   +0,   +1,   -1,   +0,   +2,   +0,   -1,   -2,   -1,   -2,   +4,   +0,  },
   {  -38,  -98,  -32,  +38,  +42,  -20,   +8,   +3,  +11,  -19,   -6,   +3,   +7,   -1,   -4,   -5,  },
   {   -1,  +46,  -59,  -13,   +4,  -78,  +19,   +8,  +43,  -19,  -37,   +0,   +4,   +5,   -2,   +8,  },
   {  +10,  +14,  +29,  +25,  +21,  +22,  -13,  +54,   +6,  -37,  -45,  -55,   -7,  -22,  -40,  -20,  },
   {   +0,   -1,   +3,   -6,  -11,  +16,   +4,  -17,  +28,   +8,  -17,  +22,  +29,  +20,   -7,  -83,  },
   {   +2,   +2,   +4,   +1,   +1,   +1,   -2,   +1,   -6,   +4,   +8,   +6,   -1,   +6,  -23,   +0,  },
   {   +0,   +0,   +0,   -1,   -3,   +3,   +1,   -2,   +3,   +2,   -2,   +1,   +2,   +1,   +3,   +0,  },
   {   +1,   +1,   +2,   +0,   +1,   +0,   -1,   +1,   -1,   +0,   +2,   +1,   -1,   +0,   -5,   +0,  },
   {   +0,   +0,   +0,   +0,   -1,   +1,   +0,   -1,   +1,   +1,   -1,   +0,   +1,   +0,   +1,   +0,  },
   {   -9,  +26,  -72,   -1,  +21,  +80,  +48,  +10,   -3,  -12,  +17,   +8,   +8,  -16,   -1,   +9,  },
   {  +13,  +26,  +43,   +7,  +70,   -6,   -1,  +14,  +14,  -30,  +14,  +74,   +3,  -15,   +5,   +7,  },
   {   +1,  -15,  +34,   +6,  -32,  +25,  +48,  -11,  +21,   +3,  -58,  +21,  +12,  +18,   +8,  +24,  },
   {   -2,   -3,   -9,   -7,  -21,   -5,  -15,  -34,  -12,   -9,  +14,  +40,  -14,  -29,  -23,  -20,  },
   {   +0,   -2,   +3,   +1,   +0,   -4,   -4,   +4,   -7,   +5,  +15,  -14,   -9,  -11,   +7,  +41,  },
   {   +0,   -1,   -2,   -1,   -4,   -1,   -2,   -4,   -2,   +0,   +0,   +0,   -1,   +2,   +2,   +3,  },
   {   +0,   -1,   +1,   +0,   -1,   -1,   -1,   +1,   -1,   +1,   +2,   -2,   -1,   -2,   +1,   +6,  },
   {   +0,   +0,   -1,   +0,   -1,   +0,   -1,   -1,   -1,   +0,   +0,   +0,   +0,   +1,   +1,   +1,  },
   {   -4,  +11,  +13,  -13,  +34,   +6,   +1,  -80,  -23,  -56,  -10,  -36,   +4,  +40,  +10,  +15,  },
   {   +2,   -7,  +36,  +14,  -26,  -24,  +60,   -7,  +10,   -9,  +34,   -8,  +29,  -45,  -11,  +20,  },
   {   -3,   -9,  -18,   +2,  -57,   +7,  -28,   -6,   -4,  -47,   -7,  +11,  -15,  -19,  -13,  +12,  },
   {   +0,   +2,  -10,   -4,  +11,   -9,  -42,   +2,  -12,   +8,  +28,  -13,  +31,  -22,   -3,  +11,  },
   {   +0,   +0,   +0,   +2,   +4,   +0,   +5,  +15,   +3,  +21,   +4,  -23,  +10,  +31,  +12,  +17,  },
   {   +0,   +0,   -2,   -1,   +2,   +0,   -6,   +0,   +0,   +1,   -1,   +1,   +4,   +2,   -3,   -9,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +1,   +3,   +1,   +4,   +1,   -3,   +1,   +4,   +2,   +1,  },
   {   +0,   +0,   -1,   +0,   +1,   +0,   -2,   +0,   +0,   +1,   +0,   +0,   +1,   +1,   +0,   -2,  },
   {   -2,   +9,   +3,   -2,   -4,   -7,  +11,  -16,   +2,  -11,  +23,  -36,  +61,  -25,   -9,  -26,  },
   {   +2,   -3,   +0,  +11,  -32,   +3,  -11,  +46,   +9,  -30,  +34,   +6,  +22,  +41,  +23,   -1,  },
   {   +0,   -1,  -12,   -6,   +5,  +13,  -51,   +1,  -10,  +10,  -31,  +16,  +55,   +0,   +4,  +18,  },
   {   +1,   +2,   +3,   -2,  +24,   -4,  +11,   +3,   +0,  +59,   +4,  -14,  +14,  +12,   +9,   -1,  },
   {   -1,   +3,   +6,   -2,   +1,   -3,   -2,   +2,   +1,   -2,  +10,   +2,  +13,   +9,  +14,  -12,  },
   {   +1,   -3,   +1,   +4,   -6,   +5,  -10,   +7,   -5,   +8,  -22,  +19,   +3,   +7,   +9,  +32,  },
   {   +0,   +0,   -3,   -3,  +12,   +1,   -2,  -24,   -4,  +41,  -30,   -4,   -9,  -42,  -14,   +3,  },
   {   +0,   +0,   +2,   +0,   +4,   -5,  +13,   +0,   +4,   +8,  +22,  -12,  -65,  +12,   -4,  -18,  },
   {   -1,   +4,   +1,   +0,   -3,   -2,   +2,   +2,   +2,   +2,   +4,   -1,   +1,   -3,   +0,   -5,  },
   {   +1,   -1,   -1,   +3,   -2,   +3,   -6,   -2,   -2,   +5,  -15,   +0,  -11,  -14,  -12,  +10,  },
   {   +0,   +0,   -2,   -2,   +4,   +1,   -4,   -5,   +2,   +6,   +9,   -7,  -21,   +2,   -7,  -25,  },
   {   +0,   +0,   +0,   +0,   -2,   -2,   +4,   +8,   +2,   -7,  +20,   -3,   -7,  +28,   +6,   -5,  },
   {   -1,   +2,   +3,   -1,   +0,   -1,   -2,   +1,   +0,   -1,   +2,   +0,   +0,   +5,   +3,   -2,  },
   {   +0,   -1,   +1,   +1,   -1,   +2,   -3,   -1,   -2,   +3,   -5,   +2,   +0,   +1,   +0,   +1,  },
   {   +0,   +0,   -1,   -1,   +0,   -1,   +2,   -2,   +1,   +5,   +9,   -2,   -1,   +6,   +6,   -8,  },
   {   +0,   +0,   +1,   +0,   +0,   -2,   +2,   +2,   +0,   -2,   +4,   -1,   +3,   +2,   +3,  +10,  },
  },
  {
   {  +80,  -72,  -50,  -33,  +10,  +18,  +21,   +1,   +9,   -7,   +6,   +1,   +4,   -3,   +2,   +2,  },
   {  -49,   -6,  +19,  -43,  +66,  +14,  +66,   -6,  +33,   -9,  +30,   -8,  +10,   -9,  +11,   -3,  },
   {   +6,  +17,  -15,  +28,  -21,  +13,   -1,  -24,  -24,  -32,  +69,  +24,   +4,  -23,  +22,   +8,  },
   {   -4,   +0,   +4,   -7,   -3,   -9,   +9,  +17,   +1,  +14,  -18,   -3,  +17,  +10,   +2,  +14,  },
   {   +1,   +3,   -1,   +4,   -3,   +2,   -4,   -5,   +4,   -3,   +5,   +7,   -9,  -10,   +9,   -5,  },
   {   -1,   +0,   +1,   -2,   +0,   -2,   +2,   +3,   +0,   +3,   -4,   -2,   +4,   +3,   -2,   +3,  },
   {   +1,   +1,   -1,   +2,   -1,   +1,   -1,   -2,   +1,   -1,   +3,   +2,   -2,   -3,   +2,   -1,  },
   {   -1,   +0,   +1,   -1,   +0,   -1,   +1,   +1,   +0,   +1,   -1,   -1,   +1,   +1,   +0,   +1,  },
   {  -72,  -23,  -58,  -38,  -53,  +34,  -21,  +24,   +6,  -23,   -3,   -6,   +5,   -5,   -6,   -2,  },
   {  +36,  +58,   -2,  +11,  -41,  +32,  +41,  +10,  +50,  -28,  -11,  -51,  +14,  -14,   -7,  -11,  },
   {   +4,  -21,  +30,   -8,   -2,  -31,  -30,  +39,  +26,   +0,  -34,   -6,  +32,  -16,  +20,   +5,  },
   {   +0,   +2,   -3,   +4,  +16,  +12,  -10,  -21,   +1,   -5,  -16,   -4,  -15,  -27,  -32,  -18,  },
   {   +1,   -3,   +4,   +1,   -1,   -5,   +0,   +5,  -10,   -1,   +9,   -5,   +9,  +13,   -3,   +8,  },
   {   +0,   +1,   -1,   +1,   +4,   +2,   -2,   -4,   +0,   +0,   -4,   +0,   -3,   -5,   -4,   -3,  },
   {   +0,   -1,   +2,   +0,   -1,   -2,   +0,   +2,   -2,   +0,   +2,   -1,   +2,   +2,   +0,   +2,  },
   {   +0,   +0,   +0,   +0,   +1,   +1,   -1,   -1,   +0,   +0,   -1,   +0,   -1,   -1,   -1,   -1,  },
   {  +26,  +55,   +6,  -55,  +36,  +40,  -35,  +33,  -27,  -36,  -16,  +38,   +7,   -1,  +13,  +12,  },
   {   +0,  -46,  +57,  +24,   -5,   +4,  -17,  +32,   +1,  -59,  +35,   -1,  +13,  -13,   -5,  -23,  },
   {  -12,   -1,  -34,  +26,  +41,   -4,   -3,  -30,  -28,  -24,  -35,   +0,  +19,  -30,  -28,  -19,  },
   {   +2,   +6,   +0,   -5,  -20,   -9,  +26,   +4,  -21,  +14,  +30,  +25,  +15,  +11,   +6,  +22,  },
   {   -2,   -2,   -2,   +2,   +3,   -3,   -6,   -3,  +16,   +4,   -9,   +6,   -8,   -5,  +18,   +2,  },
   {   +1,   +1,   +0,   -1,   -3,   -2,   +5,   -1,   -5,   +2,   +3,   +2,   +1,   +2,   -4,   +0,  },
   {   -1,   -1,   -1,   +1,   +1,   -1,   -2,   -1,   +3,   +1,   -2,   +1,   -1,   -1,   +3,   +1,  },
   {   +0,   +0,   +0,   +0,   -1,   -1,   +2,   +0,   -2,   +1,   +1,   +1,   +0,   +0,   -1,   +0,  },
   {   -7,  -22,  +34,  +15,  -30,  +27,  +56,   -4,  -23,  -23,  -57,  +47,   +3,   -5,  -26,  +23,  },
   {   -9,   +7,  -48,  +46,  +26,  -31,   +3,  +13,  +36,  -26,  -13,  +20,  +25,   -8,  +27,  +41,  },
   {   +6,  +17,   -2,  -40,  -32,  -43,  +18,  -16,   -2,  +23,   +6,  +35,  +30,  -22,  -14,   -7,  },
   {   +1,   -7,  +14,   -1,   -3,  +19,  -25,  -10,  +40,  +26,   +4,   +1,  -18,  -16,   +6,  +35,  },
   {   +0,   +2,   -4,   -1,   +7,   -2,   -1,   +0,  -17,   -3,   -5,  -27,   +1,  +10,  -20,  -10,  },
   {   +0,   -1,   +3,   +0,   -2,   +3,   -2,   -1,   +4,   +5,   +5,   +1,   -2,   +0,   +0,   +4,  },
   {   +0,   +1,   -1,   -1,   +2,   -1,   -1,   +0,   -3,   +0,   -1,   -5,   +0,   +1,   -2,   -1,  },
   {   +0,   +0,   +1,   +0,   -1,   +1,   -1,   +0,   +1,   +2,   +1,   +0,   -1,   +0,   +0,   +1,  },
   {   +3,   +9,  -10,  +17,  +15,   +7,  -15,  +24,  +43,  +10,  +28,  +37,  +11,   +0,  -76,   +5,  },
   {   +5,   +5,   +7,  -38,   -8,  -49,  -13,  -26,  -13,  -26,  +10,  -37,  +24,  -29,  -26,   +7,  },
   {   -1,  -12,  +21,   +1,   +1,  +52,  -27,  -37,   +4,  +38,   +4,   -9,  +22,  -27,   -4,  +23,  },
   {   -2,   +1,  -10,  +17,  +17,  +10,   +9,  +33,  -41,   +7,   +7,  -47,  -11,   +6,   -7,   +5,  },
   {   -2,   -3,   +6,   -3,   -1,  -11,   +9,   +5,  -19,  -12,   +0,  -28,   -3,  -27,  +12,  +69,  },
   {   -2,   -4,   +1,  +11,   -2,  +22,   -6,  -32,   -2,  +11,  -15,   +5,  +37,  -10,  +51,  -38,  },
   {   -1,   +4,  -11,  +15,   +4,   +7,  +20,  +55,  -24,  +42,   +7,   +0,  -13,  -30,   +5,   -8,  },
   {   +1,   +2,   +0,  -11,   -8,  -26,   +5,   -5,  +17,  -22,  -10,  +18,  -58,   +9,  +24,  -32,  },
   {   +1,   +4,   -1,   +3,   +2,   -1,   -3,   -7,  +11,   -5,   -1,   +8,   -5,   -3,   +7,  -15,  },
   {   +1,   +1,   -1,   -1,   +0,   -6,   +2,  +22,   -4,  +20,   +7,   +6,  +12,  -10,  -17,  -31,  },
   {   +0,   -2,   +4,  -10,   -1,   -9,   -6,  -14,   +8,  -14,   -2,   +0,  -63,   -7,  -16,  +24,  },
   {   +0,   -1,   +2,   +1,   +3,   +6,   -9,  -22,   +4,  -15,   +2,   -8,  +26,  +77,  -12,  +11,  },
   {   -1,   -1,   +3,   +0,   +0,   -2,   +3,   +1,   -3,   -1,   +1,   -4,   +9,   +9,   -5,   +2,  },
   {   -1,   -1,   +0,   +1,   +0,   +2,   -3,   -9,   -3,   -2,   -3,   -3,  -15,  -13,   +4,  +18,  },
   {   +0,   +1,   -2,   +3,   +0,   +4,   +1,   -3,   -3,   +1,   +0,   -3,  +11,  +45,   +2,  +11,  },
   {   +0,   +0,   -1,   +2,   -1,   -2,   +5,  +13,   -3,   +6,   +0,   +1,   +8,   -8,  +13,  -15,  },
  },
 },
 {  //2
  {
   { -121,   +0,  -20,  +32,   -3,   -4,   +7,   -8,  -15,   -3,   -1,   -5,   -2,   -2,   -2,   +4,  },
   {  +33,   -2,  +19, +108,   +0,  -12,   +1,  -31,  -43,   +1,   -6,  -14,   +0,  -10,   -3,   -4,  },
   {   +4,   +0,   -5,  -43,   -1,   -3,   +2,  +14, -100,   +2,   -3,  -48,   +2,   -4,  -25,  +28,  },
   {   +4,   +0,   +2,  +10,   +0,   +1,   +0,   -4,  +23,   +0,   +2,   +2,   +0,   +0,   -2, +103,  },
   {   +1,   +0,   -1,   -9,   +0,   -1,   +0,   +3,  -12,   +0,   -1,   -5,   +0,   +0,   -3,  -42,  },
   {   +2,   +0,   +1,   +3,   +0,   +0,   +0,   -1,   +6,   +0,   +0,   +1,   +0,   +0,   +0,  +24,  },
   {   +0,   +0,   +0,   -3,   +0,   +0,   +0,   +1,   -4,   +0,   +0,   -2,   +0,   +0,   -1,   -9,  },
   {   +1,   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +2,   +0,   +0,   +0,   +0,   +0,   +0,   +7,  },
   {   -1, +121,  +16,   +4,  -29,  +19,   +4,   +9,   -6,   -6,   -6,  +10,   -2,   +3,   -1,   +1,  },
   {   -1,  -23,   +3,  +19,  +11, +105,   +3,  +43,  -17,   +3,  -35,  +24,   +0,  +11,   -3,   +2,  },
   {   +1,   -7,   -2,   -7,   -2,  -31,   -2,   +0,  -48,   +1,   +9,  +99,   +1,   -1,   -1,   +4,  },
   {   +0,   -3,   +0,   +1,   +1,   +7,   +0,   +1,  +10,   +0,   +0,  -17,   +0,   -1,   +4,   +0,  },
   {   +0,   -2,   +0,   -1,   +0,   -6,   +0,   -1,   -5,   +0,   +2,  +10,   +0,   +0,   -2,   +3,  },
   {   +0,   -1,   +0,   +0,   +0,   +1,   +0,   +0,   +2,   +0,   +0,   -4,   +0,   +0,   +2,   -1,  },
   {   +0,   -1,   +0,   +0,   +0,   -2,   +0,   +0,   -1,   +0,   +0,   +3,   +0,   +0,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   +0,   +0,   -1,   +0,   +0,   +1,   +0,  },
   {  +24,  +17, -120,  +11,  +12,   +9,  +22,  -13,   +1,   +0,   +1,   +4,   -1,   -6,   -7,   -1,  },
   {   -5,   +1,  +14,  -30,   +7,  +46,   -8, -105,   -5,   +3,   -6,  +14,   -1,  -40,   -8,   +0,  },
   {   -1,   -2,   +8,   +9,   -1,   -6,   +1,  +17,  +19,   -2,  +11,  +32,   +1,  -15,  -97,   -9,  },
   {   -1,   +0,   +1,   -2,   +0,   +0,   -1,   -2,   -6,   +0,   -2,   +0,   -1,   +6,  +17,  -42,  },
   {   +0,   +0,   +3,   +1,   +0,   +0,   +0,   +2,   +3,   +0,   +2,   +2,   +0,   -2,   -9,  +17,  },
   {   +0,   +0,   +1,   -1,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +0,   +0,   +1,   +3,   -9,  },
   {   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +0,   +1,   +0,   +1,   +1,   +0,   +0,   -3,   +3,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   -2,  },
   {   +5,  -27,  -18,   +0, -117,   +8,  -28,   -8,   +2,  -20,   -9,   -4,   -1,   +5,   -8,   -1,  },
   {   -1,   +4,   -2,   -8,  +12,  -29,   -9,  -25,   +7,   +8, -100,   +0,   -4,  +57,  -26,   +1,  },
   {   +0,   +2,   +3,   +2,   +9,   +9,   +4,   -3,  +15,   -2,  +17,  -39,   +2,   -6,  -61,  -14,  },
   {   +0,   +0,   +0,   +0,   +1,   -3,   +0,   +0,   -3,   +0,   -1,   +6,   +0,   +2,   -1,   +6,  },
   {   +0,   +0,   +1,   +0,   +3,   +1,   +1,   +0,   +1,   +0,   +1,   -4,   +0,   +0,   -3,   -4,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +1,   +0,   +0,   -1,   +2,  },
   {   +0,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   -1,   -1,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,  },
   {   +3,  -12,  +17,   -7,  -32,   -3, +117,   -7,   +4,  +30,  -10,   +2,   -8,   +1,   +2,   -1,  },
   {   -1,   +2,   -3,   -1,   -3,  -19,  -10,  +32,  +10,  +13,  -63,   -3,   -2,  -95,  +10,   -2,  },
   {   +0,   +1,   -1,   +2,   +3,   +3,   -8,   -5,   +5,   -3,   +1,   -4,   -1,  +18,  +24,   -4,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   -1,   +0,   +2,   +0,   +1,   -6,   -7,   +4,  },
   {   +2,   -5,   +6,   -3,  +12,   -4,  +32,   -1,   +0, -116,  -17,   +2,  +30,  -10,   +5,   +0,  },
   {   -1,   +1,   -1,   -1,   -2,   -6,   +1,   +4,   +3,   +6,   +3,   -2,   +4,  -34,   +9,   +3,  },
   {   +0,   +0,   -1,   +1,   -1,   +1,   -4,   +0,   +1,  +10,   -4,   -2,   -4,   -2,  +19,   +1,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   +0,   -1,   -1,  },
   {   +2,   -1,   +2,   -2,   +7,   +0,   +3,   +2,   -2,  -35,   -1,   +0, -102,   -4,   +0,   +0,  },
   {   -1,   +0,   +0,   -2,   +0,   +0,   +1,   -1,   +1,   -5,   +9,   +0,   +4,  +17,   +1,   +2,  },
   {   +0,   +0,   +0,   +1,   +0,   +0,   -1,   +0,   +2,   +4,   -1,   -1,   +8,   -2,   +4,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   -2,  },
   {   +1,   -2,   +2,   +0,   +1,   +0,   -3,   +1,   -1,   -3,   +3,   +0,  -69,   +0,   -2,   +2,  },
   {   +0,   +0,   +0,   +0,   +0,   -1,   +1,   +0,   +1,   -1,   +4,   -1,   -2,   +2,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +1,   +0,   -1,   -1,   +6,   +1,   +1,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +0,  },
  },
  {
   {  +87,  -75,  +26,  -39,  +10,  -21,   -4,   +2,  -19,   +1,   +5,   +7,   +0,   -3,   +1,   -4,  },
   {  -41,   +4,  -44,  -68,  -20,  -45,   -2,  +19,  -62,   +9,  +17,  +27,   +0,   +0,   +2,  -18,  },
   {   +3,   +7,  +22,  +37,   +2,   +8,  -55,  +47,   -9,   -5,   -9,  +56,  +19,  -27,   -8,  -57,  },
   {   -4,   +0,   -6,   -7,   +0,   -2,  +28,  -23,   +3,   +0,   +0,   -2,   -4,  -80,   +6,   +8,  },
   {   +1,   +2,   +4,   +6,   +1,   +3,   -8,   +6,   +0,   -1,   -2,  +10,   +3,  +40,   -1,   -8,  },
   {   -1,   +0,   -2,   -2,   +0,   -1,   +5,   -4,   +0,   +0,   +1,   -3,   -2,  -16,   +1,   +1,  },
   {   +0,   +1,   +1,   +2,   +0,   +1,   -3,   +2,   +0,   +0,   +0,   +3,   +2,   +6,   +0,   -3,  },
   {   -1,   +0,   -1,   +0,   +0,   +0,   +2,   -1,   +0,   +0,   +0,   -1,   -1,   -4,   +0,   +0,  },
   {  -73,  -41,  +77,   -9,  +50,   -7,   -2,  -23,  -12,   +0,  +13,   -2,   -3,   +4,   +2,   -5,  },
   {  +28,  +36,  +24,  +56,   -1,  -30,  +37,  -22,  -56,  +22,  +54,   -6,  -13,   +3,   +8,  -20,  },
   {   +2,   -7,  -22,  -21,   +8,  +26,  +43,  -44,  +27,   -1,   -2,   +8,  +10,  +31,   -5,  -69,  },
   {   +1,   +3,   +2,   +1,   -5,   -8,  -19,  +17,   -7,   +2,   +7,  -28,   -4,  +61,   -1,   +7,  },
   {   +1,   -1,   -4,   -2,   +1,   +3,   +1,   -2,   +3,   +0,   -1,   +3,   +1,  -22,   +0,   -6,  },
   {   +1,   +1,   +0,   +0,   -1,   -1,   -2,   +2,   -1,   +1,   +1,   -4,   +0,   +7,   +0,   +2,  },
   {   +0,   +0,   -1,   -1,   +0,   +1,   +1,   -1,   +1,   +0,   +0,   +1,   +0,   -1,   +0,   -2,  },
   {   +0,   +0,   +0,   +0,   +0,   -1,   -1,   +0,   +0,   +0,   +0,   -1,   +0,   +1,   +0,   +1,  },
   {  +30,  +72,   +7,  -45,  +66,   -9,  -47,  -33,   +7,  -13,   +4,   -1,   -6,   -4,   +1,   +1,  },
   {   -5,  -29,  -38,   +4,  +17,  +69,  -34,   +3,   -8,  +17,  +51,   -4,  -37,   -7,  +24,   +4,  },
   {   -6,   -2,  +10,   -3,  -24,  -33,  -27,  +22,  +16,   +0,   -3,  -68,  -18,  -26,   +3,   +0,  },
   {   +1,   +0,   +0,   +6,   +4,   +5,   +5,   -2,   -6,   -2,   -6,  +35,   -5,   -6,   +5,  +33,  },
   {   -1,   -1,   +1,   -1,   -3,   -2,   +4,   -4,   +4,   +0,   -1,   -5,   +2,  -10,   -1,   -7,  },
   {   +0,   +0,   +0,   +2,   +1,   +0,   -1,   +1,   -2,   -1,   -1,   +5,   -2,   +6,   +1,   +5,  },
   {   +0,   -1,   +0,   +0,   -1,   -1,   +1,   -1,   +1,   +0,   +0,   -2,   +1,   -4,   +0,   -2,  },
   {   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +1,   -1,   +1,   +0,   +1,  },
   {   -8,  -37,  -51,  +49,  +13,  -44,  -39,  -58,  -15,  -46,  -20,   +0,   +6,   +3,   -3,   +0,  },
   {   -3,   +6,  +27,  -13,  -49,  -31,   -2,  -17,  +54,  -10,   +6,  +35,   -6,   +8,  +12,   -9,  },
   {   +3,   +7,   +4,   +3,  +15,  +10,  +27,   +6,  -23,  -10,  -34,  +43,   -7,  +14,   +6,  +53,  },
   {   +0,   -2,   -3,   -3,   +1,   +7,   +4,   -6,   +2,   +4,   +9,   -4,  +25,  -18,  -10,  -22,  },
   {   +0,   +1,   +2,   -1,   +0,   -2,   -2,   +7,   -1,   -1,   -2,   -6,   -6,  +15,   +1,   +3,  },
   {   +0,   +0,   -1,   +0,   +0,   +2,   +1,   -1,   +0,   +1,   +2,   +1,   +4,   -5,   -1,   -1,  },
   {   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +1,   +0,   +0,   -1,   -1,   -1,   +2,   +0,   +0,  },
   {   +0,   +0,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +0,   +0,   +1,   -1,   +0,   +0,  },
   {   +3,  +12,  +31,  -19,  -53,  +49,  -11,  -23,  -42,  -80,  +16,  -14,  +16,   -2,   -9,   +4,  },
   {   +2,   +3,   -5,   +2,  +34,   +7,  +32,  +40,  -25,  -27,  -52,  -38,  +10,   -4,   -1,  -27,  },
   {   -1,   -4,   -8,   +0,   +6,   +2,   -8,   -2,   +4,  +20,  +28,  -12,  +55,   -1,  -25,   -2,  },
   {   +0,   +0,   +3,   +0,   -5,   -6,   -7,   +5,   +6,   -4,   +1,  -10,  -24,  +13,  +10,   -9,  },
   {   -2,   -3,  -14,   +5,  +30,  -23,  +27,  +43,  +34,  -66,  +59,   +9,  +15,   +0,  +45,   +5,  },
   {   -1,   -2,   +0,   +1,   -7,   -3,  -12,  -11,   +8,  +23,  +15,   +5,  +46,   +2,  -11,  +36,  },
   {   +0,   +1,   +5,   +1,  -11,   -2,   -6,   -8,   +2,   -2,   -8,   +7,  -52,   -4,  +18,  -13,  },
   {   +0,   +0,   -1,   +0,   +3,   +2,   +6,   -1,   -2,   -2,   -5,   +6,   +1,   -3,   +2,   +5,  },
   {   +1,   +4,   +6,   -2,  -11,   +9,  -13,  -18,  -15,  +20,  -28,   -9,  +35,   +3,  +86,   -7,  },
   {   +1,   +0,   +1,   +0,   -2,   +4,   +0,   -4,   -1,   -3,   -7,   +7,  -43,   -1,   +1,  -17,  },
   {   +0,   +0,   -3,   -1,   +5,   +0,   +4,   +5,   +0,   -2,   +2,   -4,  +10,   +2,  -13,   +1,  },
   {   +0,   +0,   +0,   +0,   +1,   +0,   -3,   +2,   -1,   +3,   +2,   -3,  +12,   +1,   -4,   +2,  },
   {   -1,   -1,   -4,   +1,   +4,   -2,   +3,   +4,   +3,  -14,  +10,   +4,  -23,   -2,  -65,   +4,  },
   {   +0,   +0,   -1,   +0,   +2,   -1,   -1,   +3,   +2,   +2,   +3,   -4,  +13,   +0,   -6,   +6,  },
   {   +0,   +0,   +1,   +0,   -1,   -1,   -2,   +0,   +0,   +3,   +0,   +0,   +5,   -2,   +7,   +4,  },
   {   +0,   +0,   +0,   +0,   -1,   +0,   +1,   -1,   +1,   -1,   -1,   +3,   -8,   -1,   +2,   -1,  },
  },
 },
 {  //3
  {
   { -115,  +15,  +29,  -36,   -6,   +4,  -20,   +4,  +12,   +5,   -3,   -1,  +10,   +4,   +2,   +3,  },
   {  +37,  +51,  -22,  -98,  +18,  +15,   -7,  +29,  +13,  +20,   -4,   -3,   -4,   +6,   +9,   -3,  },
   {   +9,  -18,  +16,  +25,   +3,  +52,  -43,   +1,  +10,  +90,  -34,   +2,   -6,  +14,  +13,  +12,  },
   {   +2,   +0,   -6,   +5,   -3,  -13,   +4,  +26,   +2,  -17,  -12,  +19,  +12,  +53,  +37,  +84,  },
   {   +2,   -3,   +3,   +4,   -1,   +5,   +0,   -5,   -1,   +4,   +2,   -2,   +5,   -4,  +19,  -12,  },
   {   +1,   +0,   -2,   +1,   +0,   -3,   +1,   +4,   +3,   -3,   -1,   +4,   +1,   +4,   +6,   +8,  },
   {   +1,   -1,   +1,   +2,   +0,   +2,   -1,   -2,   -1,   +2,   -1,   -1,   +1,   +0,   +2,   -2,  },
   {   +0,   +0,   -1,   +1,   +0,   -1,   +1,   +1,   +1,   -1,   +0,   +2,   +0,   +2,   +2,   +3,  },
   {  +10,  -95,   -4,  -59,  -50,  -17,   -7,  -17,  +17,   +6,   +5,   +9,  +11,   +0,   -9,   +6,  },
   {  -29,   +7,  -80,  +11,   -5,  -45,  +35,   -7,   -2,  +66,  +25,   +3,   -9,   -1,   -3,  +13,  },
   {   +8,  +34,  +12,  -17,  -38,  +16,   +0,  -73,  -46,   +8,  +11,  -35,  -12,  -20,   -9,  +50,  },
   {   +0,   -3,  +15,   +1,  +12,  +24,  +12,   +6,  +12,  +28,  +43,  +22,   -2,  -13,  -28,   -1,  },
   {   +1,   +5,   +0,   +1,   +0,   -2,   -4,   +6,   +7,   -7,  -10,  +11,   -7,   +3,  -20,  +45,  },
   {   +0,   -1,   +3,   +1,   +2,   +4,   +1,   +2,   +0,   +3,   +4,   +1,   +0,   +2,   -4,   +1,  },
   {   +1,   +2,   +0,   +0,   +0,   -1,   -1,   +1,   +2,   -1,   -2,   +2,   -1,   -1,   -3,   +7,  },
   {   +0,   +0,   +1,   +0,   +1,   +2,   +0,   +1,   +0,   +1,   +1,   +0,   +0,   +1,   -1,   +0,  },
   {  +23,  +23,  +45,   +6,   +3,  -87,  -51,   -5,  +16,  +29,  +23,   -7,  +33,   -3,   +1,   -2,  },
   {   -8,  -47,   +7,  -13,  +67,   -8,   -2,  +21,  -45,   +5,  +20,  -65,  -10,   +1,  +18,  +18,  },
   {   -8,   +1,  -59,   +7,   -7,  -14,  -57,   -3,   -9,  -19,  -40,  -19,   -4,   -5,   +9,  -22,  },
   {   +1,   +6,   +7,   -3,  -40,   +7,   +5,   +5,  -53,  +12,  +12,  -22,  +18,  +35,  +28,  -37,  },
   {   -1,   +0,   -2,   +0,   +3,   +8,  +15,   -1,   +6,   +9,  +21,  +11,  +18,  -16,  +24,  -13,  },
   {   +0,   +1,   +1,   +0,   -6,   +1,   +0,   -3,   +1,   -1,   -3,   +4,   -4,   -6,   +6,  +14,  },
   {   +0,   +0,   -1,   +0,   +1,   +2,   +4,   +0,   +1,   +1,   +4,   +2,   +4,   -1,   +2,   +0,  },
   {   +0,   +1,   +0,   +0,   -3,   +0,   +0,   -1,   +0,   +0,   -1,   +1,   -1,   -2,   +2,   +3,  },
   {   +3,   +8,  -15,  +14,  -12,  +23,   +7,  -11,  +70,  -10,  +25,  -75,  +28,  +46,  -20,   +1,  },
   {   +3,   +5,  +41,   -4,  -13,  -35,  +39,   +2,  +16,  +14,  -28,  -18,  -72,  +29,   -5,  -12,  },
   {   -2,  -12,   -3,  -14,  +65,   -6,   +5,  -52,   +8,   -1,  -10,   +3,   +1,  +13,  -25,   -3,  },
   {   -1,   +0,  -16,   +3,   -3,   -3,  -55,   -3,   -4,  -13,   +5,   -1,  -49,  +21,  -33,   +2,  },
   {   +0,   -1,   +2,   -1,  -10,   +1,   +1,  +27,  -37,   +7,   +8,  -10,  +15,  +37,  -36,  -15,  },
   {   +0,   +0,   -3,   +0,   +0,   +1,   -7,   -2,   +1,   +0,   +6,   +2,   +2,   -5,   +9,   -8,  },
   {   +0,   +0,   +0,   +0,   -1,   +0,   +1,   +5,   -7,   +1,   +0,   +0,   +2,   +4,   -2,   +1,  },
   {   +0,   +0,   -1,   +0,   +0,   +0,   -3,   +0,   +0,   +0,   +2,   +1,   +1,   -1,   +2,   -1,  },
   {   +4,   +3,   +1,   +2,   +9,   +2,   +1,   +0,  -12,   +0,   -4,   +2,  +56,  -10,  -13,  +19,  },
   {   +0,   -3,   +0,   +8,  -20,   +5,  -10,  +27,  +29,   -6,  +21,  -35,  -23,  -53,  +42,  +14,  },
   {   +0,   +1,   +7,   -3,   -5,  -17,  +41,   +8,   +3,  +13,  -64,  -27,  +22,  -18,   +1,   -4,  },
   {   -1,   -1,   -2,   -5,  +22,   +0,   +2,  -58,  +21,   -4,   -8,   +4,   -1,   +8,  +57,  -12,  },
   {   +1,   +2,   -3,   +2,   -2,   +3,   +4,   +2,   +4,   +0,   -5,   +1,   +4,   +9,  -22,   -4,  },
   {   +1,   +1,   +6,   +0,   +0,   -1,   -3,   -5,   +0,   -4,  +19,   +8,   -1,  +12,   -2,   +5,  },
   {   +0,   -2,   +1,   +0,   +0,   -1,   -2,  +25,   +5,   +1,  +10,  -17,  -15,  -41,  -25,  +17,  },
   {   +0,   +0,   -2,   +0,   -1,   -5,   +3,   +3,   -1,   +5,  -48,  -19,  +26,  -25,  -28,   +8,  },
   {   +2,   +1,   +0,   +0,   +2,   +0,   -1,   +0,   -3,   +0,   +3,   +3,   +6,   -2,   +5,   +2,  },
   {   +0,   -1,   +0,   +3,   -3,   +1,   -2,   +3,   +4,   -1,   -1,   +0,   +4,   +2,   +6,   -4,  },
   {   +0,   +0,   +1,   +0,   -2,   -4,   +7,   +0,   +1,   -1,  +10,   +3,  -10,  +13,  +19,   -4,  },
   {   +0,   +0,   +0,   -1,   +3,   +0,   +1,   -5,   +4,   +1,   -3,   -6,   +0,  -16,  -12,   +4,  },
   {   +0,   +1,   -1,   +1,   -1,   +1,   +1,   +0,   +2,   +0,   +0,   +0,   +0,   +4,   -5,   -2,  },
   {   +0,   +1,   +2,   +0,   +0,   +0,   -1,   -2,   +0,   -1,   +4,   +2,   +2,   +1,   -3,   +2,  },
   {   +0,   -1,   +0,   +0,   +1,   +0,   -1,   +7,   +1,   +0,   +3,   -1,   -3,   -5,   -2,   +1,  },
   {   +0,   +0,   -1,   +0,   +0,   -2,   +0,   +0,   +0,   +0,   -6,   -2,   +2,   +1,   +4,   +0,  },
  },
  {
   { +109,  -39,  +29,  +18,  -29,  -23,   -7,   +1,  +11,  -10,   -8,   -5,   +1,   +2,   +4,   -7,  },
   {  -26,  +31,   -3,  +96,  -60,   -5,   -3,  -26,  +14,  -11,  -24,   +1,  +12,   -9,   +9,   -2,  },
   {   -8,   -5,   -2,  -23,  +16,  -15,  +12,   +5,   +6,  -47,  -99,   -1,  -20,  -18,  +39,  +15,  },
   {   -3,   +2,   -2,   +2,   -2,   +5,   -3,   +0,   -3,   +3,  +11,   +0,  +21,   +8,  +18,   -6,  },
   {   -2,   -1,   +0,   -5,   +3,   -2,   +3,   +1,   +1,   -4,  -10,   +1,   -4,   -3,   +0,   +1,  },
   {   -1,   +1,   +0,   +1,   -1,   +1,   -1,   +0,   -1,   +1,   +3,   +0,   +5,   +3,   +2,   -1,  },
   {   -1,   +0,   +0,   -2,   +1,   -1,   +1,   +1,   +1,   -1,   -4,   +0,   -2,   -1,   +0,   +1,  },
   {   +0,   +0,   +0,   +0,   +0,   +1,   +0,   +0,   +0,   +0,   +1,   +0,   +2,   +1,   +1,   -1,  },
   {  -50,  -95,   +0,  -10,  -52,   +2,  -31,  +24,  +10,   +5,   -5,  -10,   -5,   +3,   -6,  -11,  },
   {  +28,   +6,  -41,   +6,   +9,  +79,  -62,   -3,   -7,  +28,  -36,  -14,   -2,  -25,  -16,   -3,  },
   {   +2,  +18,   +9,  +10,  -17,  -13,   +8,  +43,   -9,  +11,  +19,   -6,  -75,  -62,  -22,  +22,  },
   {   +1,   +0,   +0,   -2,   +5,   -4,   +7,   -6,   +3,   -2,  -26,   +8,   +9,   -6,  -37,  -14,  },
   {   +0,   +4,   +2,   +1,   -2,   -2,   +0,   +4,   -2,   -1,   +4,   +0,   -1,   +0,   +5,   +0,  },
   {   +0,   +0,   +0,   -1,   +1,   -1,   +2,   -2,   +1,   +0,   -5,   +1,   +2,   -2,   -5,   -2,  },
   {   +0,   +1,   +1,   +1,   -1,   -1,   +0,   +1,   -1,   +0,   +1,   +0,   -1,   +0,   +1,   +1,  },
   {   +0,   +0,   +0,   +0,   +1,   +0,   +1,   -1,   +0,   +0,   -2,   +0,   +1,   -1,   -2,   -1,  },
   {  -18,  +32,  +86,  -14,  +13,   -9,  -75,   -7,  +22,  -12,   +0,  -17,   -1,   -6,   -5,  -18,  },
   {   -8,  -49,   +4,  +26,  +56,   +1,   +9,  -64,  +21,   -2,  +25,   -2,   -2,  -61,  +15,   -7,  },
   {   +6,   +5,  -33,   +2,   -2,   +5,  -45,   +9,   +1,  -38,  +41,   +7,  -16,  +14,  +63,  +30,  },
   {   +0,   +1,   +2,   -4,   -9,   -1,   +5,  +14,  -21,   +2,   +5,   -5,   -4,  -51,   +9,   -9,  },
   {   +1,   +1,   -6,   +1,   +0,   +1,   -1,   +0,   +2,   +0,   -3,   +3,   +0,   +2,  -16,   -4,  },
   {   +0,   +0,   +1,   -1,   -2,   +0,   +1,   +3,   -4,   +1,   +1,   -1,   -1,   -6,   +0,   +0,  },
   {   +1,   +0,   -2,   +0,   +0,   +0,   -1,   +0,   +1,   +0,   +0,   +0,   +0,   +0,   -3,   -1,  },
   {   +0,   +0,   +0,   +0,   -1,   +0,   +0,   +1,   -2,   +0,   +0,   +0,   +0,   -2,   +0,   +0,  },
   {   +6,  +27,  -32,  -43,  -34,   -4,  +14,  -12,  +92,  +16,  +10,  -16,   -7,  -19,  +18,  -35,  },
   {   -2,   -1,  +58,   -9,  -18,  +49,  +35,   -4,   +1,  +38,   -5,  +13,   +7,   +0,  +42,  +23,  },
   {   -3,  -14,   +1,  +35,  +41,   +2,   +0,   +5,  +53,  +11,   -7,   +3,  -31,  +40,  -18,  +23,  },
   {   +0,   +2,   -7,   -2,   +0,  -14,  -23,   +3,   +0,  -16,  +12,  +31,   +0,   -7,  +27,  +10,  },
   {   +0,   -2,   +0,   +4,   +3,   +1,   +2,   -1,   -9,   -1,   +2,   -1,   +3,  -17,  +15,  -17,  },
   {   +0,   +1,   -2,   -1,   +0,   -3,   -5,   +1,   +1,   -3,   +1,   +6,   +0,   +0,   +1,   +1,  },
   {   +0,   -1,   +0,   +1,   +1,   +0,   +1,   +0,   -2,   +0,   +0,   +0,   +0,   -3,   +3,   -3,  },
   {   +0,   +0,   -1,   +0,   +0,   -1,   -2,   +0,   +0,   -2,   +0,   +2,   +0,   +0,   +1,   +0,  },
   {   -3,   +3,  -14,  +14,  +19,  -31,   +1,   +8,  -21,  +12,   -1,  -93,   +4,  +13,  +12,  -19,  },
   {   +2,   +5,   -8,  -40,  -36,  -14,   -8,  -59,  -11,   -9,   +1,  -15,  +11,   -4,  -34,  +53,  },
   {   +1,   -3,  +20,   +1,  -10,  +56,  +32,   -3,   +1,  -22,   +9,  -46,  -12,  +11,   +9,   +6,  },
   {   -1,   -2,   +0,  +10,  +13,   -1,   -1,  +26,  +40,   +7,   -3,   -3,   +4,   +9,  -24,  +48,  },
   {   +0,   +4,   -2,   +2,   +3,  +13,   +7,  +14,   -5,   -8,   -3,  +23,  -12,  +17,   +4,  -65,  },
   {   +0,   +1,   -3,   +1,   +6,  -37,  -12,   +6,   -4,  +60,  -14,  -19,  +14,   +0,  +28,  +12,  },
   {   +0,   -1,   +0,  -10,  -14,   -4,   -4,  -58,  -24,   +4,   -3,   +0,  -50,  +24,   -2,  -12,  },
   {   +0,   -1,   +4,   +1,   -1,  +20,  +10,   +6,   +5,  -36,  +12,  -47,   -1,   +5,   +4,  +11,  },
   {   -2,   +2,   -1,   +2,   +3,   -2,   +0,   -5,   -4,   -6,   +2,   +8,   -8,   +1,  -11,   -8,  },
   {   +0,   +0,   -1,   -4,   +1,   +2,   +2,  +17,   +5,  -15,   +4,   +4,  +32,  -12,   -4,  -16,  },
   {   +0,   +0,   +0,   -1,   -1,  -10,   -6,   -7,   -6,  +54,  -13,   +8,   -4,   +4,  +30,  +10,  },
   {   +0,   +0,   +0,   -1,   -3,   +0,   -1,  -18,   -5,   +7,   -2,   +3,  -54,  +28,   +2,  -21,  },
   {   +0,   +2,   -1,   +0,   +1,   +2,   +2,   +3,   +0,   +3,   -1,   +2,   +2,   +0,   +5,   -2,  },
   {   +0,   +0,   +1,   +0,   +1,   -4,   +0,   +3,   +0,   -7,   +3,   +3,   +0,   +0,  -13,  -12,  },
   {   +0,   +0,   +0,   -1,   -1,   +0,   +0,   -1,   +0,   -8,   +2,   +0,  +30,  -15,   -4,   +6,  },
   {   +0,   +0,   +0,   +0,   -1,   -1,   -2,   -5,   -3,  +14,   -4,   +0,  -15,   +8,  +18,   +2,  },
  },
 },
};
const int8_t g_lfnstInv4x4[4][2][16][16] = {
 {  //0
  {
   { +108,  -40,  +25,  -32,   +8,  -25,   +8,   +2,  -16,   -9,  -13,   +8,   -2,   +4,   +2,   +0,  },
   {  -44,  -97,  -31,  -39,   -9,   +5,   +9,  +34,  -27,  -10,   +1,   -7,  +13,   +9,   -2,   -2,  },
   {  -15,  +56,   -1,  -92,  +33,  +16,  +16,   -5,  -39,  -34,   +4,   -5,   -6,  +11,   +8,   +0,  },
   {   +1,  +12,   +7,  +51,   -8,   -3,   +1,   +1, -109,   +4,   -9,  -15,   -4,  +31,  -16,  -10,  },
   {  -44,  -11, +100,   -6,  -16,  -38,  +37,   -7,   +6,   -9,  -30,   +7,   -2,   +4,   +8,   -1,  },
   {  +19,  +29,  -16,  -16, -102,  +14,  +36,  +24,  +10,   -5,  -17,  -30,  +28,   +9,   +5,   -7,  },
   {   +7,  -12,  -29,  +36,  +36,  +11,  +94,  -25,  +16,  -29,   -3,  -28,  -13,  +16,  +28,   -3,  },
   {   -1,   -3,   +1,   -8,  +23,   -3,  -38,   -3,  +24,   +5,  -64,  -87,  -14,  +19,  -17,  -35,  },
   {  -11,  +18,  -54,   +3,   -4,  -97,   -7,   +8,   +3,  -33,  -35,  +31,   -3,  +12,   +6,   -1,  },
   {   +6,  +18,  +21,  +22,  +38,   +7,   +3,  +99,  +19,  -26,  +11,   +4,  +37,  +33,   -7,   -7,  },
   {   +2,  -15,  +14,  +18,  -27,  +26,  -47,  -28,  +10,  -96,  +17,   +4,  -15,  +32,  +18,   -2,  },
   {   -1,   -3,   -4,  -15,   -5,   +1,  +11,  -29,  +24,  +33,  +19,  +33,   -3,  +94,  -45,  -32,  },
   {   +0,   -1,   -7,   +4,   +5,  +55,   -6,   +6,   -4,  +14,  -86,  +61,   -2,  +12,  +40,   -6,  },
   {   -1,   -3,   +2,   +1,  +16,  -10,  -13,  -43,   -7,   +4,   +6,   -5, +107,   +0,  +36,  -33,  },
   {   -1,   +2,   +4,   -5,   -8,  -19,  -17,  +21,   -2,  +39,  +36,  -17,  -36,  +34,  +97,  -16,  },
   {   +0,   +1,   +0,   +2,   -6,   +3,  +10,  +11,   -3,  -14,  +14,  +22,  -24,  -45,   -8, -112,  },
  },
  {
   { +119,  -27,   +0,  +23,  -19,  -10,  -17,   +1,   -6,   +9,   +4,   -6,   +4,   -4,   +0,   +0,  },
   {  -30, -101,  +58,   +4,   -5,   -1,  -28,  -24,  -17,   +5,   -5,   -4,   -4,   -7,   +6,   +0,  },
   {  -22,  +31,  +22,  +66,  -89,   -1,  +12,  -23,   -2,  +35,   -5,   -9,   +7,   +0,   +0,   -1,  },
   {   -3,  +17,  -15,  -11,   +2,   +6,   -8,   +1, -111,   +0,  -10,  -39,   +8,  -24,  +30,   +5,  },
   {  -23,  -47, -102,  +22,  -26,  +23,  -32,  +17,   +7,   +6,  +15,   +1,   +4,   -7,   -6,   -1,  },
   {   -2,   +2,   +2,  +89,  +76,  +25,  +14,   -7,  -17,  +21,  +19,  +22,  -13,   +0,   +1,   -7,  },
   {   +3,  +22,  +38,   -2,  -11,  +87,  -53,  +52,   +8,   -9,   -2,   +0,  -18,  -25,  -13,   +1,  },
   {   +2,   +3,   +2,  -26,  -17,   -7,   -6,   +9,  -42,  +34,   +6, +102,   +5,   +3,  -23,  -34,  },
   {  -16,  +19,  +10,  +13,  +20,  -74,  -68,  +50,   +9,  +44,   +6,  -19,   +0,   -3,   +1,   -2,  },
   {   +3,  +30,  -13,   -8,  +13,   +4,  -67,  -92,  +18,   -3,  -12,  +19,   +0,  -30,  +20,   +3,  },
   {   +6,   -7,   -5,  -38,  +18,  +39,  +17,  -15,  +16, +102,  -13,  -32,  +21,   +8,   -2,   -6,  },
   {   +0,   -9,   +4,   -1,   -4,   -5,  +29,  +27,  +25,  +11,   +6,  +30,  +22,  -76,  +80,  +19,  },
   {   -3,   +5,  +14,   -9,   +1,   +0,   +2,  -15,   -4,   -7,  +95,  -16,  +58,  -34,  -44,   +5,  },
   {   +2,   +3,   -1,  -20,  -15,   -1,   +6,  -10,   +2,  +13,  +69,  -14,  -88,   +4,  +37,  -38,  },
   {   +1,   -5,   -9,   -2,   +3,  -20,  +25,   -6,   -1,  +11,  -29,   -8,  -54,  -80,  -68,  +11,  },
   {   +0,   -1,   +0,   +8,   +5,   -1,   +4,   +3,  +11,  -20,  -24,  -23,  +28,  -26,   +1, -115,  },
  },
 },
 {  //1
  {
   { -111,  -47,  -35,  +13,  -11,   +0,  -17,   +4,   +5,   -4,   -2,   +5,   -5,   +0,   -1,   -1,  },
   {  +39,  -27,  -23,  +93,  -27,  -35,  -46,  -10,  -20,   -1,  -10,  +13,   -7,   +4,   +2,   +0,  },
   {   +4,  +15,   +4,  -27,   +1,  +32,  -92,  -23,  +32,  +38,  +35,  +18,  -34,   -2,   +7,  -12,  },
   {   +3,   -1,   +4,   -4,   +2,   -2,  +14,   +4,   -5,  -18,  -19,  +34,  -83,  -60,  -57,  +23,  },
   {  +44,  -92,  -17,  -48,  -47,  +26,   +7,  +16,   +8,   -7,   +5,  +11,   +2,   +5,   +3,   +1,  },
   {  +11,  +43,  -72,  +13,   -4,  +60,  -10,  +58,   -3,  -42,   +8,   -4,   -1,   +9,   -7,   -4,  },
   {  -12,  +20,  +32,  -34,  -36,   -3,  -39,  -17,  -46,  -63,  -44,  +18,   -4,  +42,   +9,  +17,  },
   {   -1,   -2,   +6,   +4,  +10,  -17,  +29,  +26,   -7,   -6,  +14,  +18,  -73,  +34,  +68,  -53,  },
   {   +7,  +20,  -59,  -52,   -2,  -82,  -17,  +30,   -4,  +33,  -25,   +5,   +4,   +5,   -9,   -3,  },
   {  -16,  +39,  +18,  +11,  -85,   +1,  +27,  +21,   +2,  +34,  +25,  +58,  +20,  -14,   +6,   +4,  },
   {   -5,  -16,  +50,   +1,  +14,  -30,  -28,  +67,  -15,  -23,  +58,   -3,  +15,   +9,  -49,  -21,  },
   {   +2,   -5,   -6,  +10,  +29,   +0,  +17,   +2,  +24,  +15,  +17,  +42,  -12,  +80,  -20,  +72,  },
   {   +3,  +10,   +0,   +3,  -20,  -37,   +1,  -13, +100,  -65,   +7,   -2,   +4,   -5,   +6,   -4,  },
   {   -1,   -5,  +40,  +16,   -2,  +21,  -15,  +59,  +44,  +33,  -84,  -10,   -3,  +13,   -4,   -8,  },
   {   +4,  -13,   +0,   -3,  +57,   +3,  -13,  +13,   +0,  -20,  -16,  +85,  +44,  -38,  +36,   -3,  },
   {   +2,   +2,  -13,   +1,   +4,  +12,  +17,  -40,   +5,   +2,  -18,  +38,  +12,  +37,  -64,  -83,  },
  },
  {
   {  +88,  -58,  -51,  -27,  +19,  +29,  -12,  +19,   -6,  -13,   -1,   -8,   +1,   +4,   -1,   -3,  },
   {  -55,  -20,  +23,  -76,   -4,  +50,  -21,  +38,  +27,  -28,   +8,  -22,  +12,   +5,   -5,   -7,  },
   {   +6,  +27,  -22,  +49,  -36,  +13,  -74,  -10,  +18,  -45,  +24,  -17,  +32,  +24,  -20,  -22,  },
   {   -3,   -2,   +5,   -2,  +22,  -10,  +43,   -5,   -5,  -39,  -51,  +33,  +51,  +60,  -34,  -34,  },
   {  -66,  -27,  -63,  +40,  +52,   +1,  -13,  +28,  -37,   +0,  -15,  -18,   -8,   -5,   +4,   -5,  },
   {  +27,  +75,   +3,  +14,   +7,  +34,  +39,  +66,  -18,   -5,   -9,  -45,   +8,  -14,   +4,  -11,  },
   {   +9,  -29,  +37,   +9,  +36,  -59,  +18,   +0,  +12,  -39,  +44,  -57,   -2,  -23,  -15,  -36,  },
   {   -2,   +0,   -5,  -17,  -23,   +1,   -5,   -5,  -25,  +69,  +10,  -27,  -31,  +38,  -46,  -69,  },
   {  +11,  +47,   +1,  -56,  +28,  -51,  -58,   -4,  -44,  -23,  -28,   +0,  -22,   +9,  +18,   -1,  },
   {  +11,  -42,  +64,  +36,  -17,   +4,  -35,  +19,  -10,  +16,  -70,  -31,   +4,   +8,  +31,   -3,  },
   {  -13,  -11,  -35,  -25,  -64,  -16,  +27,  -30,  -38,  -12,  -12,  -30,  +46,  -34,  +42,  -25,  },
   {   +1,  +11,   -4,   +6,  +15,  +30,   -5,  -26,  +37,  -18,  -39,  +29,  -39,  -59,  +10,  -73,  },
   {   -2,   -9,  +29,  +14,   -5,  +52,  +19,  -40,  -66,  -50,  +24,   -2,  -49,  +24,  +10,   +5,  },
   {   -7,   -3,  -31,   +3,  -44,  -33,  +26,  +28,  +45,  -31,  -18,  -13,  -67,  +47,  +27,   +4,  },
   {   +1,  +19,  -11,   -6,  +48,  +24,   +6,  -60,  +40,  +24,   -4,  -53,  +14,  +42,  +49,   +4,  },
   {   +2,   -4,  +13,   +8,   +9,   -5,   -5,  +37,   -7,  +13,  +51,  +49,  +17,  +28,  +78,  -49,  },
  },
 },
 {  //2
  {
   { -112,  +29,  -36,  +28,  -12,  +18,   +5,  -13,   -4,  +15,   -8,   -2,   -3,   +2,   +4,   +0,  },
   {  +47,   -7,  -87,   -5,  -24,  +53,   -1,  -32,  -13,  +33,  -24,   -6,   -7,   +6,   +8,   +1,  },
   {   -2,   +1,  +69,   +2,  +15,  +69,   +2,  +18,  -10,  +63,  -27,  -24,  -16,  +10,  +21,   +4,  },
   {   +2,   -1,  -10,   -2,   -3,  -74,   +0,   -2,  +19,  +89,  +15,  +13,  -21,   -3,  +40,  +11,  },
   {  -34, -108,  -17,  -29,  +26,  +14,  -26,  +15,  +18,   +8,  +12,   -1,  +10,   -5,   -4,   -2,  },
   {  +13,  +40,  -33,  +13,  +80,  +24,   +6,  +34,  +46,  +15,  +41,   -8,  +24,  -16,  -11,   -4,  },
   {   +2,   +2,  +26,   -2,  -61,  +28,   +0,  -27,  +60,  +25,  +26,  +37,  +46,  -31,  -28,  -13,  },
   {   +0,   +0,   -2,   +0,   +9,  -30,   +1,   +7,  -48,  +40,  -29,  -22,  +75,  +12,  -57,  -34,  },
   {  +15,  -45,   +7, +103,  +15,   -6,  +45,  -25,  +16,   -4,  -17,   +3,   +8,   +7,   +5,   +3,  },
   {   -7,  +13,  +14,  -36,  +54,   -7,   -9,  -80,  +33,   -8,  -50,  +18,  +20,  +24,  +14,   +7,  },
   {   +1,   +4,  -11,   -4,  -36,  -11,   -1,  +47,  +60,  -15,  -39,  -51,  +38,  +41,  +31,  +20,  },
   {   +0,   -1,   +2,   +1,   +2,  +12,   +0,   -1,  -48,   -8,  +27,  +22,  +72,  -16,  +70,  +47,  },
   {   +8,   +8,   +6,  +48,   +0,   -5, -113,  -16,   +1,   -2,   +0,  -23,   +1,  -16,   +7,   -6,  },
   {   -3,   -5,   +8,  -16,   -4,   -7,  +28,  -50,   +0,   -6,  +35,  -95,   +2,  -41,  +18,  -19,  },
   {   -1,   +1,   -7,   -4,   +6,   -6,   +8,  +28,   +5,   -9,  -67,  +17,   +1,  -89,  +32,  -42,  },
   {   +0,   +0,   +0,   +1,   -2,   +8,   -1,   +2,   -2,   -7,  +26,  +17,   +7,  +49,  +52, -101,  },
  },
  {
   {  -99,  +58,  -15,  +46,  -14,   -3,  +17,  +15,   -6,   -2,   +7,   -5,   +4,   -2,   -3,   +1,  },
   {  +39,  +42,  +71,   +5,  -54,   +3,  +16,  +54,  -17,   -1,  +29,  -24,   +8,  -11,   -5,   +1,  },
   {   -1,  -33,  -44,   +4,  -29,  +69,   -2,   -8,  -55,   -9,  +14,  -53,  +21,  -25,  -23,   +7,  },
   {   +2,   +3,   +5,   -6,  +29,  -42,   +1,   +6,  -28,  -79,   -6,  +15,  +52,   -4,  -57,  +18,  },
   {  +65,  +33,  -58,  +71,  +25,  -11,  +38,   +6,   +9,   +7,  +12,   -3,   -1,   -4,   -2,   +1,  },
   {  -20,  -63,  -29,  -12,   -9,  -50,  +18,  +60,  +30,  +11,  +53,  -15,   -1,  -21,   -4,   +2,  },
   {   -5,  +23,  +25,  -15,  +61,  -26,  -12,  -26,   -8,  +48,  +10,  -61,   -5,  -53,  -24,  +16,  },
   {   +0,   -1,   +3,   +5,  -29,  +26,   +0,   -8,  +58,  +44,  -11,  +26,  +29,   +2,  -75,  +47,  },
   {  -15,  -55,  +62,  +52,  +27,  +24,  +62,  -30,   +4,  -13,  +14,   +6,   -7,   -5,   +1,   +2,  },
   {   -2,  +32,   -7,  -38,  +44,  +63,   +1,  +17,  +34,  -34,  +59,  +30,  -17,  -26,   +3,   +5,  },
   {   +5,   +3,   -4,  +13,  -48,  -19,  -14,  -38,  +41,  -55,  -15,  -16,  -44,  -64,   +9,  +24,  },
   {   -1,   -5,   -4,   -2,   +5,   -5,   +5,  +22,  -52,   +6,   -3,  +23,  -84,  +19,  -25,  +67,  },
   {   +0,  +21,  -19,  -63,  -27,  -18,  +89,  -43,  -16,  +12,   +5,  +13,   +8,   -8,   +6,   +3,  },
   {   +3,   -2,   +4,  +23,  -21,  -22,  -42,  -45,  -36,  +23,  +71,  +56,  +20,  -19,  +15,   +9,  },
   {   -1,   -8,   +0,   +3,  +12,  +12,   +8,  +42,  -20,  +20,  -54,  +44,  +31,  -73,  +41,  +25,  },
   {   +0,   +3,   +1,   -3,   +7,   +0,   -2,   -7,  +16,  -11,  +13,  -35,  +39,  +39,  +61,  +88,  },
  },
 },
 {  //3
  {
   { -114,  -19,  +36,  -27,  -11,  +15,  +13,  +16,   -8,   -6,   +5,   -5,   +1,   -3,   -2,   -5,  },
   {  +37,  -41,  -25,  -80,  -21,  +47,  +25,  +11,  -34,  -30,   +9,  -23,   +3,   -2,   -7,  -12,  },
   {   +3,  +19,  +18,  +44,  +37,  +10,  +79,  -26,  -26,  -42,   -6,  -23,  +23,  -21,  -33,  -18,  },
   {   +2,   -2,   -2,   -3,  -10,   -6,  -39,  +13,   +7,  -12,  +42,  +36,  +73,  -52,  -56,  -12,  },
   {  -22,  +85,  -42,  -58,  +44,  -16,  -13,  -13,  -26,   -3,  -15,   +3,   +8,   +1,   -4,   +8,  },
   {  -23,  -60,  -53,   +1,   -4,  -44,  +10,  -74,  -19,   +5,  -18,  +22,   +5,  -10,   -6,  +22,  },
   {  +14,  -11,  +35,  -29,  +47,  +42,  +31,  -20,  +29,  +57,   -9,  +36,  +34,  -17,  +21,  +38,  },
   {   +0,   +7,   +5,  +19,  -12,  +10,   -4,   -1,  -37,  -52,  +26,  +40,  +46,  +44,  +63,  +36,  },
   {  +21,  +17,  +46,  -41,  -37,  -80,  +49,   +5,   +1,   -2,  +15,  +27,  -12,  -19,  +15,   -5,  },
   {  -17,  +31,  -60,  +18,  -41,  +25,  +45,   -6,  +22,  +37,  +58,   -4,   +2,  -20,  +31,  -15,  },
   {   -5,  -34,  -25,  -12,  +58,  -40,  +12,  +29,  +46,  -12,  +14,  -16,  +35,  +30,  +32,  -51,  },
   {   +2,   +2,  +19,   -7,  +18,  +21,   -8,  -47,   -9,   +6,  +43,  +56,  -38,  +45,  -22,  -63,  },
   {   +5,  -11,   +8,  +12,  +10,  -23,   +3,  +26,  -81,  +74,  +23,  -25,  +26,  +27,  -10,   -5,  },
   {   +2,  +19,  +21,  -17,  -46,   -2,   -1,  -49,  +37,  +10,  -10,  -46,  +52,  +61,  -26,   +0,  },
   {   -4,   +2,  -33,   +7,  -16,   +3,  +43,  +54,  +14,   +6,  -37,  +56,   +2,  +49,  -52,  +15,  },
   {   -1,   -8,   -1,   -6,  +31,  -14,   +7,   +2,  +20,  -15,  +75,  -24,  -31,  +21,  -38,  +73,  },
  },
  {
   { -102,  +12,  -59,  -33,   +0,  +28,  +11,  -13,   -9,   -6,  +12,   +2,   -1,   +5,   +2,   -1,  },
   {  +22,  +93,  -24,  +23,  -38,  +38,  -35,  +23,  -20,  +24,  +17,   -9,   -9,  -12,   -6,   +1,  },
   {   +7,  -27,  +17,  -36,  -81,   +8,  +21,  +22,  -55,  -38,  +17,   +8,  +28,  -24,  +11,  -14,  },
   {   +2,   -6,   +1,  +11,  +30,   -9,  -17,  -36,  -83,  +23,   +0,  +45,  -24,  -17,  +45,  +36,  },
   {  +66,  -27,  -62,  -21,  +27,  +62,  +30,  -12,   +3,   -8,  +32,   +7,   -1,  +13,   +3,   -1,  },
   {  -25,  -64,   -2,  +50,   +5,  +32,  -18,  +64,   -2,  +40,  +27,   -8,  -10,  -34,  -10,   +2,  },
   {   -6,  +36,   -3,  +35,  +51,  -13,  +31,  +39,   +1,  -49,  +21,  +27,  +49,  -32,  +33,  -20,  },
   {   -1,   +6,   +2,  -16,  -32,   +2,  +18,  +25,  +62,   +0,   +2,  +35,  -30,  -16,  +55,  +69,  },
   {  -15,  +13,  +83,  -23,  +24,  +51,  -11,  -19,   +8,   -7,  +67,   -9,   -8,  +14,   +8,   +0,  },
   {  +14,   +5,  -12,  -78,  +36,  -32,  -36,  +23,   +2,   +9,  +11,  -31,   -7,  -67,   -5,   +0,  },
   {   +1,  -23,  -17,  +16,  -16,  +15,  -80,  -36,  +27,  -25,   -6,  -17,  +40,   -7,  +59,  -15,  },
   {   -1,   +0,   -2,  +19,  +12,   +5,  +12,   +9,  -28,  -44,  -10,  -87,   +1,   +9,   +4,  +72,  },
   {   +2,   -2,  -24,  +22,  -24,  -66,  +16,  -30,   +7,  +23,  +89,  -23,   +4,   +7,   +7,   +3,  },
   {   -2,   +6,  +14,  +15,   -8,  +28,  +49,  -58,  +15,  +39,  -22,  -22,  +33,  -74,   -4,   +4,  },
   {   +1,   +5,   +7,  -30,   +9,   +0,  +13,  +33,  -11,  +70,  -12,  -19,  +65,  +49,  +44,   +5,  },
   {   +0,   -3,   -2,   -5,   +1,   -1,  -32,   -7,   +5,   -3,  +16,  +44,  +67,   +1,  -66,  +65,  },
  },
 },
};

//--------------------------------------------------------------------------------------------------

class ScanGenerator
{
private:
  uint32_t m_line, m_column;
  const uint32_t m_blockWidth, m_blockHeight;
  const uint32_t m_stride;

public:
  ScanGenerator(uint32_t blockWidth, uint32_t blockHeight, uint32_t stride)
    : m_line(0), m_column(0), m_blockWidth(blockWidth), m_blockHeight(blockHeight), m_stride(stride)
  { }

  uint32_t GetCurrentX() const { return m_column; }
  uint32_t GetCurrentY() const { return m_line; }

  uint32_t GetNextIndex(uint32_t blockOffsetX, uint32_t blockOffsetY)
  {
    const uint32_t rtn = ((m_line + blockOffsetY) * m_stride) + m_column + blockOffsetX;

    if ((m_column == m_blockWidth - 1) || (m_line == 0)) //if we reach the end of a rank, go diagonally down to the next one
    {
      m_line += m_column + 1;
      m_column = 0;

      if (m_line >= m_blockHeight) //if that takes us outside the block, adjust so that we are back on the bottom row
      {
        m_column += m_line - (m_blockHeight - 1);
        m_line = m_blockHeight - 1;
      }
    }
    else
    {
      m_column++;
      m_line--;
    }

    return rtn;
  }
};

uint32_t const g_log2SbbSize[MAX_TU_SIZE_IDX][MAX_TU_SIZE_IDX][2] =
//===== luma/chroma =====
{
  { { 0,0 },{ 0,1 },{ 0,2 },{ 0,3 },{ 0,4 },{ 0,4 },{ 0,4 } },
  { { 1,0 },{ 1,1 },{ 1,1 },{ 1,3 },{ 1,3 },{ 1,3 },{ 1,3 } },
  { { 2,0 },{ 1,1 },{ 2,2 },{ 2,2 },{ 2,2 },{ 2,2 },{ 2,2 } },
  { { 3,0 },{ 3,1 },{ 2,2 },{ 2,2 },{ 2,2 },{ 2,2 },{ 2,2 } },
  { { 4,0 },{ 3,1 },{ 2,2 },{ 2,2 },{ 2,2 },{ 2,2 },{ 2,2 } },
  { { 4,0 },{ 3,1 },{ 2,2 },{ 2,2 },{ 2,2 },{ 2,2 },{ 2,2 } },
  { { 4,0 },{ 3,1 },{ 2,2 },{ 2,2 },{ 2,2 },{ 2,2 },{ 2,2 } }
};

const int8_t g_BcwLog2WeightBase = 3;
const int8_t g_BcwWeightBase = (1 << g_BcwLog2WeightBase);
const int8_t g_BcwWeights[BCW_NUM]      = { -2, 3, 4, 5, 10 };
const int8_t g_BcwSearchOrder[BCW_NUM]  = { BCW_DEFAULT, BCW_DEFAULT - 2, BCW_DEFAULT + 2, BCW_DEFAULT - 1, BCW_DEFAULT + 1 };
const int8_t g_BcwParsingOrder[BCW_NUM] = { 2, 3, 1, 4, 0 };
const int8_t g_BcwCodingOrder[BCW_NUM]  = { 4, 2, 0, 1, 3 };


int8_t getBcwWeight(uint8_t bcwIdx, uint8_t uhRefFrmList)
{
  // Weghts for the model: P0 + w * (P1 - P0) = (1-w) * P0 + w * P1
  // Retuning  1-w for P0 or w for P1
  return (uhRefFrmList == REF_PIC_LIST_0 ? g_BcwWeightBase - g_BcwWeights[bcwIdx] : g_BcwWeights[bcwIdx]);
}

uint32_t deriveWeightIdxBits(uint8_t bcwIdx) // Note: align this with TEncSbac::codeBcwIdx and TDecSbac::parseBcwIdx
{
  uint32_t numBits = 1;
  uint8_t  bcwCodingIdx = (uint8_t)g_BcwCodingOrder[bcwIdx];

  if (BCW_NUM > 2 && bcwCodingIdx != 0)
  {
    uint32_t prefixNumBits = BCW_NUM - 2;
    uint32_t step = 1;
    uint8_t  prefixSymbol = bcwCodingIdx;

    // Truncated unary code
    uint8_t idx = 1;
    for (int ui = 0; ui < prefixNumBits; ++ui)
    {
      if (prefixSymbol == idx)
      {
        ++numBits;
        break;
      }
      else
      {
        ++numBits;
        idx += step;
      }
    }
  }
  return numBits;
}

// ---------------------------------------------------------------------------------------------------------------------

//void ScanOrderRom::initScanOrderRom()
//{
//  const uint32_t maxSizeIdx = MAX_TU_SIZE_IDX;
//  // initialize scan orders
//  for (uint32_t blockHeightIdx = 0; blockHeightIdx < maxSizeIdx; blockHeightIdx++)
//  {
//    for (uint32_t blockWidthIdx = 0; blockWidthIdx < maxSizeIdx; blockWidthIdx++)
//    {
//      const uint32_t blockWidth  = 1<<blockWidthIdx;
//      const uint32_t blockHeight = 1<<blockHeightIdx;
//      const uint32_t totalValues = blockWidth * blockHeight;
//
//      //--------------------------------------------------------------------------------------------------
//
//      //non-grouped scan orders
//
//      {
//        ScanElement* scan = m_scanOrder[SCAN_UNGROUPED][blockWidthIdx][blockHeightIdx];
//
//        ScanGenerator fullBlockScan(blockWidth, blockHeight, blockWidth);
//
//        for (uint32_t scanPosition = 0; scanPosition < totalValues; scanPosition++)
//        {
//          const int rasterPos = fullBlockScan.GetNextIndex( 0, 0 );
//          const int posY      = rasterPos / blockWidth;
//          const int posX      = rasterPos - ( posY * blockWidth );
//
//          scan[scanPosition].idx = rasterPos;
//          scan[scanPosition].x   = posX;
//          scan[scanPosition].y   = posY;
//        }
//      }
//
//      //--------------------------------------------------------------------------------------------------
//
//      //grouped scan orders
//      const uint32_t* log2Sbb        = g_log2SbbSize[Log2(blockWidth)][Log2(blockHeight)];
//      const uint32_t  log2CGWidth    = log2Sbb[0];
//      const uint32_t  log2CGHeight   = log2Sbb[1];
//
//      const uint32_t  groupWidth     = 1 << log2CGWidth;
//      const uint32_t  groupHeight    = 1 << log2CGHeight;
//      const uint32_t  widthInGroups = std::min<unsigned>(JVET_C0024_ZERO_OUT_TH, blockWidth) >> log2CGWidth;
//      const uint32_t  heightInGroups = std::min<unsigned>(JVET_C0024_ZERO_OUT_TH, blockHeight) >> log2CGHeight;
//
//      const uint32_t  groupSize      = groupWidth    * groupHeight;
//      const uint32_t  totalGroups    = widthInGroups * heightInGroups;
//
//      //for (uint32_t scanTypeIndex = 0; scanTypeIndex < SCAN_NUMBER_OF_TYPES; scanTypeIndex++)
//      {
//        ScanElement *scan = m_scanOrder[SCAN_GROUPED_4x4][blockWidthIdx][blockHeightIdx];
//
//        if ( blockWidth > JVET_C0024_ZERO_OUT_TH || blockHeight > JVET_C0024_ZERO_OUT_TH )
//        {
//          for (uint32_t i = 0; i < totalValues; i++)
//          {
//            scan[i].idx = totalValues - 1;
//            scan[i].x   = blockWidth - 1;
//            scan[i].y   = blockHeight - 1;
//          }
//        }
//
//        ScanGenerator fullBlockScan(widthInGroups, heightInGroups, groupWidth);
//
//        for (uint32_t groupIndex = 0; groupIndex < totalGroups; groupIndex++)
//        {
//          const uint32_t groupPositionY  = fullBlockScan.GetCurrentY();
//          const uint32_t groupPositionX  = fullBlockScan.GetCurrentX();
//          const uint32_t groupOffsetX    = groupPositionX * groupWidth;
//          const uint32_t groupOffsetY    = groupPositionY * groupHeight;
//          const uint32_t groupOffsetScan = groupIndex     * groupSize;
//
//          ScanGenerator groupScan(groupWidth, groupHeight, blockWidth);
//
//          for (uint32_t scanPosition = 0; scanPosition < groupSize; scanPosition++)
//          {
//            const int rasterPos = groupScan.GetNextIndex( groupOffsetX, groupOffsetY );
//            const int posY      = rasterPos / blockWidth;
//            const int posX      = rasterPos - ( posY * blockWidth );
//
//            scan[groupOffsetScan + scanPosition].idx = rasterPos;
//            scan[groupOffsetScan + scanPosition].x   = posX;
//            scan[groupOffsetScan + scanPosition].y   = posY;
//          }
//
//          fullBlockScan.GetNextIndex(0, 0);
//        }
//      }
//
//      for (int i = 0; i < 64; i++)
//      {
//        g_coefTopLeftDiagScan8x8[blockWidthIdx][i].idx = g_auiXYDiagScan8x8[i][0] + g_auiXYDiagScan8x8[i][1] * blockWidth;
//        g_coefTopLeftDiagScan8x8[blockWidthIdx][i].x   = g_auiXYDiagScan8x8[i][0];
//        g_coefTopLeftDiagScan8x8[blockWidthIdx][i].y   = g_auiXYDiagScan8x8[i][1];
//      }
//      //--------------------------------------------------------------------------------------------------
//    }
//  }
//
//  printf( "    " );
//  for( int i = 0; i < 32258; i++ )
//  {
//    printf( "{%d,%d,%d}, ", m_scanOrderBuf[i].idx, m_scanOrderBuf[i].x, m_scanOrderBuf[i].y );
//    if( ( i + 1 ) % 20 == 0 ) printf( "\n    " );
//  }
//}

void InitGeoRom::initGeoTemplate() const
{
  int modeIdx = 0;
  for (int angleIdx = 0; angleIdx < GEO_NUM_ANGLES; angleIdx++)
  {
    for (int distanceIdx = 0; distanceIdx < GEO_NUM_DISTANCES; distanceIdx++)
    {
      if ((distanceIdx == 0 && angleIdx >= 16)
          || ((distanceIdx == 2 || distanceIdx == 0) && (g_angle2mask[angleIdx] == 0 || g_angle2mask[angleIdx] == 5))
          || g_angle2mask[angleIdx] == -1)
        continue;
      g_GeoParams[modeIdx][0] = (int16_t) angleIdx;
      g_GeoParams[modeIdx][1] = (int16_t) distanceIdx;
      modeIdx++;
    }
  }
  for (int angleIdx = 0; angleIdx < (GEO_NUM_ANGLES >> 2) + 1; angleIdx++)
  {
    if (g_angle2mask[angleIdx] == -1)
      continue;

    int     distanceX = angleIdx;
    int     distanceY = (distanceX + (GEO_NUM_ANGLES >> 2)) % GEO_NUM_ANGLES;
    int16_t rho = (g_Dis[distanceX] * 2 * GEO_MAX_CU_SIZE) + (g_Dis[distanceY] * 2 * GEO_MAX_CU_SIZE);
    static const int16_t maskOffset = (2 * GEO_MAX_CU_SIZE - GEO_WEIGHT_MASK_SIZE) >> 1;
    int                  index      = 0;
    for (int y = 0; y < GEO_WEIGHT_MASK_SIZE; y++)
    {
      int16_t lookUpY = (((y + maskOffset) << 1) + 1) * g_Dis[distanceY];
      for (int x = 0; x < GEO_WEIGHT_MASK_SIZE; x++, index++)
      {
        int16_t sx_i                                         = ((x + maskOffset) << 1) + 1;
        int16_t weightIdx                                    = sx_i * g_Dis[distanceX] + lookUpY - rho;
        int     weightLinearIdx                              = 32 + weightIdx;
        g_globalGeoWeights[g_angle2mask[angleIdx]][index]    = Clip3(0, 8, (weightLinearIdx + 4) >> 3);
        g_globalGeoEncSADmask[g_angle2mask[angleIdx]][index] = weightIdx > 0 ? 1 : 0;
      }
    }
  }

  for (int hIdx = 0; hIdx < GEO_NUM_CU_SIZE; hIdx++)
  {
    int16_t height = 1 << (hIdx + GEO_MIN_CU_LOG2);
    for (int wIdx = 0; wIdx < GEO_NUM_CU_SIZE; wIdx++)
    {
      int16_t width = 1 << (wIdx + GEO_MIN_CU_LOG2);
      for (int splitDir = 0; splitDir < GEO_NUM_PARTITION_MODE; splitDir++)
      {
        int16_t angle    = g_GeoParams[splitDir][0];
        int16_t distance = g_GeoParams[splitDir][1];
        int16_t offsetX  = (GEO_WEIGHT_MASK_SIZE - width) >> 1;
        int16_t offsetY  = (GEO_WEIGHT_MASK_SIZE - height) >> 1;
        if (distance > 0)
        {
          if (angle % 16 == 8 || (angle % 16 != 0 && height >= width))
          {
            offsetY += angle < 16 ? ((distance * (int32_t) height) >> 3) : -((distance * (int32_t) height) >> 3);
          }
          else
          {
            offsetX += angle < 16 ? ((distance * (int32_t) width) >> 3) : -((distance * (int32_t) width) >> 3);
          }
        }
        g_weightOffset[hIdx][wIdx][splitDir][0] = offsetX;
        g_weightOffset[hIdx][wIdx][splitDir][1] = offsetY;
      }
    }
  }
}
int16_t   g_GeoParams[GEO_NUM_PARTITION_MODE][2];
int16_t   g_globalGeoWeights[GEO_NUM_PRESTORED_MASK]   [GEO_WEIGHT_MASK_SIZE * GEO_WEIGHT_MASK_SIZE];
int16_t   g_globalGeoEncSADmask[GEO_NUM_PRESTORED_MASK][GEO_WEIGHT_MASK_SIZE * GEO_WEIGHT_MASK_SIZE];
const int8_t    g_angle2mask[GEO_NUM_ANGLES]   = { 0, -1, 1, 2, 3, 4, -1, -1, 5, -1, -1, 4, 3, 2, 1, -1,
                                             0, -1, 1, 2, 3, 4, -1, -1, 5, -1, -1, 4, 3, 2, 1, -1 };
const int8_t    g_Dis[GEO_NUM_ANGLES]          = { 8,  8,  8,  8,  4,  4,  2,  1,  0, -1, -2, -4, -4, -8, -8, -8,
                                            -8, -8, -8, -8, -4, -4, -2, -1, 0, 1,  2,  4,  4,  8,  8,  8 };
const int8_t    g_angle2mirror[GEO_NUM_ANGLES] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2,
                                             0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 2 };
int16_t   g_weightOffset[GEO_NUM_CU_SIZE][GEO_NUM_CU_SIZE][GEO_NUM_PARTITION_MODE][2];

const InitGeoRom g_scanOrderRom;

// ====================================================================================================================
// Data structure related table & variable
// ====================================================================================================================

const int g_quantScales[2][SCALING_LIST_REM_NUM] = // can be represented as a 9 element table
{
    { 26214,23302,20560,18396,16384,14564 },
    { 18396,16384,14564,13107,11651,10280 } // Note: last 3 values of second row == half of the first 3 values of the first row
};

const int g_invQuantScales[2][SCALING_LIST_REM_NUM] = // can be represented as a 9 element table
{
  { 40,45,51,57,64,72 },
  { 57,64,72,80,90,102 } // Note: last 3 values of second row == double of the first 3 values of the first row
};

//--------------------------------------------------------------------------------------------------
//structures
//--------------------------------------------------------------------------------------------------
//coefficients
//--------------------------------------------------------------------------------------------------
// ====================================================================================================================
// Intra prediction
// ====================================================================================================================

const uint8_t g_aucIntraModeNumFast_UseMPM_2D[7 - MIN_CU_LOG2 + 1][7 - MIN_CU_LOG2 + 1] =
{
  {3, 3, 3, 3, 2, 2},  //   4x4,   4x8,   4x16,   4x32,   4x64,   4x128,
  {3, 3, 3, 3, 3, 2},  //   8x4,   8x8,   8x16,   8x32,   8x64,   8x128,
  {3, 3, 3, 3, 3, 2},  //  16x4,  16x8,  16x16,  16x32,  16x64,  16x128,
  {3, 3, 3, 3, 3, 2},  //  32x4,  32x8,  32x16,  32x32,  32x64,  32x128,
  {2, 3, 3, 3, 3, 2},  //  64x4,  64x8,  64x16,  64x32,  64x64,  64x128,
  {2, 2, 2, 2, 2, 3},  // 128x4, 128x8, 128x16, 128x32, 128x64, 128x128,
};

const uint8_t g_aucIntraModeNumFast_UseMPM[MAX_CU_DEPTH] =
{
  3,  //   2x2
  8,  //   4x4
  8,  //   8x8
  3,  //  16x16
  3,  //  32x32
  3,  //  64x64
  3   // 128x128
};
const uint8_t g_aucIntraModeNumFast_NotUseMPM[MAX_CU_DEPTH] =
{
  3,  //   2x2
  9,  //   4x4
  9,  //   8x8
  4,  //  16x16   33
  4,  //  32x32   33
  5,  //  64x64   33
  5   // 128x128
};

const uint8_t g_chroma422IntraAngleMappingTable[NUM_INTRA_MODE] =
//                                                                     H                                                               D                                                               V
//0, 1,  2,  3,  4,  5,  6,  7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, DM
{ 0, 1, 61, 62, 63, 64, 65, 66, 2, 3,  4,  6,  8, 10, 12, 13, 14, 16, 18, 20, 22, 23, 24, 26, 28, 30, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 44, 44, 45, 46, 46, 46, 47, 48, 48, 48, 49, 50, 51, 52, 52, 52, 53, 54, 54, 54, 55, 56, 56, 56, 57, 58, 59, 60, DM_CHROMA_IDX };




// ====================================================================================================================
// Misc.
// ====================================================================================================================
const int                 g_ictModes[2][4] = { { 0, 3, 1, 2 }, { 0, -3, -1, -2 } };

const UnitScale g_miScaling( MIN_CU_LOG2, MIN_CU_LOG2 );


// ====================================================================================================================
// Context model mapping
// ====================================================================================================================

const uint32_t g_uiMinInGroup[LAST_SIGNIFICANT_GROUPS] = { 0,1,2,3,4,6,8,12,16,24,32,48,64,96 };
const uint32_t g_uiGroupIdx[MAX_TB_SIZEY] = { 0,1,2,3,4,4,5,5,6,6,6,6,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9, 10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11 };
const uint32_t g_auiGoRiceParsCoeff[32] =
{
  0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3
};

const char *MatrixType[SCALING_LIST_SIZE_NUM][SCALING_LIST_NUM] =
{
  {
    "INTRA1X1_LUMA",
    "INTRA1X1_CHROMAU",
    "INTRA1X1_CHROMAV",
    "INTER1X1_LUMA",
    "INTER1X1_CHROMAU",
    "INTER1X1_CHROMAV"
  },
  {
    "INTRA2X2_LUMA",
    "INTRA2X2_CHROMAU",
    "INTRA2X2_CHROMAV",
    "INTER2X2_LUMA",
    "INTER2X2_CHROMAU",
    "INTER2X2_CHROMAV"
  },
  {
    "INTRA4X4_LUMA",
    "INTRA4X4_CHROMAU",
    "INTRA4X4_CHROMAV",
    "INTER4X4_LUMA",
    "INTER4X4_CHROMAU",
    "INTER4X4_CHROMAV"
  },
  {
    "INTRA8X8_LUMA",
    "INTRA8X8_CHROMAU",
    "INTRA8X8_CHROMAV",
    "INTER8X8_LUMA",
    "INTER8X8_CHROMAU",
    "INTER8X8_CHROMAV"
  },
  {
    "INTRA16X16_LUMA",
    "INTRA16X16_CHROMAU",
    "INTRA16X16_CHROMAV",
    "INTER16X16_LUMA",
    "INTER16X16_CHROMAU",
    "INTER16X16_CHROMAV"
  },
  {
    "INTRA32X32_LUMA",
    "INTRA32X32_CHROMAU",
    "INTRA32X32_CHROMAV",
    "INTER32X32_LUMA",
    "INTER32X32_CHROMAU",
    "INTER32X32_CHROMAV"
  },
  {
    "INTRA64X64_LUMA",
    "INTRA64X64_CHROMAU_FROM16x16_CHROMAU",
    "INTRA64X64_CHROMAV_FROM16x16_CHROMAV",
    "INTER64X64_LUMA",
    "INTER64X64_CHROMAU_FROM16x16_CHROMAU",
    "INTER64X64_CHROMAV_FROM16x16_CHROMAV"
  },
};

const char *MatrixType_DC[SCALING_LIST_SIZE_NUM][SCALING_LIST_NUM] =
{
  {  //1x1
  },
  {
  },
  {
  },
  {
  },
  {
    "INTRA16X16_LUMA_DC",
    "INTRA16X16_CHROMAU_DC",
    "INTRA16X16_CHROMAV_DC",
    "INTER16X16_LUMA_DC",
    "INTER16X16_CHROMAU_DC",
    "INTER16X16_CHROMAV_DC"
  },
  {
    "INTRA32X32_LUMA_DC",
    "INTRA32X32_CHROMAU_DC",
    "INTRA32X32_CHROMAV_DC",
    "INTER32X32_LUMA_DC",
    "INTER32X32_CHROMAU_DC",
    "INTER32X32_CHROMAV_DC"
  },
  {
    "INTRA64X64_LUMA_DC",
    "INTRA64X64_CHROMAU_DC_FROM16x16_CHROMAU",
    "INTRA64X64_CHROMAV_DC_FROM16x16_CHROMAV",
    "INTER64X64_LUMA_DC",
    "INTER64X64_CHROMAU_DC_FROM16x16_CHROMAU",
    "INTER64X64_CHROMAV_DC_FROM16x16_CHROMAV"
  },
};

const int g_quantTSDefault4x4[4 * 4] =
{
  16,16,16,16,
  16,16,16,16,
  16,16,16,16,
  16,16,16,16
};

const int g_quantIntraDefault8x8[8 * 8] =
{
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16
};

const int g_quantInterDefault8x8[8 * 8] =
{
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16,
  16,16,16,16,16,16,16,16
};

const uint32_t g_scalingListSize [SCALING_LIST_SIZE_NUM] = { 1, 4, 16, 64, 256, 1024, 4096 };
const uint32_t g_scalingListSizeX[SCALING_LIST_SIZE_NUM] = { 1, 2,  4,  8,  16,   32,   64 };

const uint8_t g_aucChromaScale[NUM_CHROMA_FORMAT][chromaQPMappingTableSize] =
{
  //0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69
  { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
  { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,29,30,31,32,33,33,34,34,35,35,36,36,37,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63 },
  { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,63,63,63,63,63,63 },
  { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,63,63,63,63,63,63 }
};

const ScanElement g_coefTopLeftDiagScan8x8[MAX_TU_SIZE_IDX][64] =
{
  {{0,0,0},{1,0,1},{1,1,0},{2,0,2},{2,1,1},{2,2,0},{3,0,3},{3,1,2},{3,2,1},{3,3,0},{4,1,3},{4,2,2},{4,3,1},{5,2,3},{5,3,2},{6,3,3},{4,0,4},{5,0,5},{5,1,4},{6,0,6},{6,1,5},{6,2,4},{7,0,7},{7,1,6},{7,2,5},{7,3,4},{8,1,7},{8,2,6},{8,3,5},{9,2,7},{9,3,6},{10,3,7},{4,4,0},{5,4,1},{5,5,0},{6,4,2},{6,5,1},{6,6,0},{7,4,3},{7,5,2},{7,6,1},{7,7,0},{8,5,3},{8,6,2},{8,7,1},{9,6,3},{9,7,2},{10,7,3},{8,4,4},{9,4,5},{9,5,4},{10,4,6},{10,5,5},{10,6,4},{11,4,7},{11,5,6},{11,6,5},{11,7,4},{12,5,7},{12,6,6},{12,7,5},{13,6,7},{13,7,6},{14,7,7},},
  {{0,0,0},{2,0,1},{1,1,0},{4,0,2},{3,1,1},{2,2,0},{6,0,3},{5,1,2},{4,2,1},{3,3,0},{7,1,3},{6,2,2},{5,3,1},{8,2,3},{7,3,2},{9,3,3},{8,0,4},{10,0,5},{9,1,4},{12,0,6},{11,1,5},{10,2,4},{14,0,7},{13,1,6},{12,2,5},{11,3,4},{15,1,7},{14,2,6},{13,3,5},{16,2,7},{15,3,6},{17,3,7},{4,4,0},{6,4,1},{5,5,0},{8,4,2},{7,5,1},{6,6,0},{10,4,3},{9,5,2},{8,6,1},{7,7,0},{11,5,3},{10,6,2},{9,7,1},{12,6,3},{11,7,2},{13,7,3},{12,4,4},{14,4,5},{13,5,4},{16,4,6},{15,5,5},{14,6,4},{18,4,7},{17,5,6},{16,6,5},{15,7,4},{19,5,7},{18,6,6},{17,7,5},{20,6,7},{19,7,6},{21,7,7},},
  {{0,0,0},{4,0,1},{1,1,0},{8,0,2},{5,1,1},{2,2,0},{12,0,3},{9,1,2},{6,2,1},{3,3,0},{13,1,3},{10,2,2},{7,3,1},{14,2,3},{11,3,2},{15,3,3},{16,0,4},{20,0,5},{17,1,4},{24,0,6},{21,1,5},{18,2,4},{28,0,7},{25,1,6},{22,2,5},{19,3,4},{29,1,7},{26,2,6},{23,3,5},{30,2,7},{27,3,6},{31,3,7},{4,4,0},{8,4,1},{5,5,0},{12,4,2},{9,5,1},{6,6,0},{16,4,3},{13,5,2},{10,6,1},{7,7,0},{17,5,3},{14,6,2},{11,7,1},{18,6,3},{15,7,2},{19,7,3},{20,4,4},{24,4,5},{21,5,4},{28,4,6},{25,5,5},{22,6,4},{32,4,7},{29,5,6},{26,6,5},{23,7,4},{33,5,7},{30,6,6},{27,7,5},{34,6,7},{31,7,6},{35,7,7},},
  {{0,0,0},{8,0,1},{1,1,0},{16,0,2},{9,1,1},{2,2,0},{24,0,3},{17,1,2},{10,2,1},{3,3,0},{25,1,3},{18,2,2},{11,3,1},{26,2,3},{19,3,2},{27,3,3},{32,0,4},{40,0,5},{33,1,4},{48,0,6},{41,1,5},{34,2,4},{56,0,7},{49,1,6},{42,2,5},{35,3,4},{57,1,7},{50,2,6},{43,3,5},{58,2,7},{51,3,6},{59,3,7},{4,4,0},{12,4,1},{5,5,0},{20,4,2},{13,5,1},{6,6,0},{28,4,3},{21,5,2},{14,6,1},{7,7,0},{29,5,3},{22,6,2},{15,7,1},{30,6,3},{23,7,2},{31,7,3},{36,4,4},{44,4,5},{37,5,4},{52,4,6},{45,5,5},{38,6,4},{60,4,7},{53,5,6},{46,6,5},{39,7,4},{61,5,7},{54,6,6},{47,7,5},{62,6,7},{55,7,6},{63,7,7},},
  {{0,0,0},{16,0,1},{1,1,0},{32,0,2},{17,1,1},{2,2,0},{48,0,3},{33,1,2},{18,2,1},{3,3,0},{49,1,3},{34,2,2},{19,3,1},{50,2,3},{35,3,2},{51,3,3},{64,0,4},{80,0,5},{65,1,4},{96,0,6},{81,1,5},{66,2,4},{112,0,7},{97,1,6},{82,2,5},{67,3,4},{113,1,7},{98,2,6},{83,3,5},{114,2,7},{99,3,6},{115,3,7},{4,4,0},{20,4,1},{5,5,0},{36,4,2},{21,5,1},{6,6,0},{52,4,3},{37,5,2},{22,6,1},{7,7,0},{53,5,3},{38,6,2},{23,7,1},{54,6,3},{39,7,2},{55,7,3},{68,4,4},{84,4,5},{69,5,4},{100,4,6},{85,5,5},{70,6,4},{116,4,7},{101,5,6},{86,6,5},{71,7,4},{117,5,7},{102,6,6},{87,7,5},{118,6,7},{103,7,6},{119,7,7},},
  {{0,0,0},{32,0,1},{1,1,0},{64,0,2},{33,1,1},{2,2,0},{96,0,3},{65,1,2},{34,2,1},{3,3,0},{97,1,3},{66,2,2},{35,3,1},{98,2,3},{67,3,2},{99,3,3},{128,0,4},{160,0,5},{129,1,4},{192,0,6},{161,1,5},{130,2,4},{224,0,7},{193,1,6},{162,2,5},{131,3,4},{225,1,7},{194,2,6},{163,3,5},{226,2,7},{195,3,6},{227,3,7},{4,4,0},{36,4,1},{5,5,0},{68,4,2},{37,5,1},{6,6,0},{100,4,3},{69,5,2},{38,6,1},{7,7,0},{101,5,3},{70,6,2},{39,7,1},{102,6,3},{71,7,2},{103,7,3},{132,4,4},{164,4,5},{133,5,4},{196,4,6},{165,5,5},{134,6,4},{228,4,7},{197,5,6},{166,6,5},{135,7,4},{229,5,7},{198,6,6},{167,7,5},{230,6,7},{199,7,6},{231,7,7},},
  {{0,0,0},{64,0,1},{1,1,0},{128,0,2},{65,1,1},{2,2,0},{192,0,3},{129,1,2},{66,2,1},{3,3,0},{193,1,3},{130,2,2},{67,3,1},{194,2,3},{131,3,2},{195,3,3},{256,0,4},{320,0,5},{257,1,4},{384,0,6},{321,1,5},{258,2,4},{448,0,7},{385,1,6},{322,2,5},{259,3,4},{449,1,7},{386,2,6},{323,3,5},{450,2,7},{387,3,6},{451,3,7},{4,4,0},{68,4,1},{5,5,0},{132,4,2},{69,5,1},{6,6,0},{196,4,3},{133,5,2},{70,6,1},{7,7,0},{197,5,3},{134,6,2},{71,7,1},{198,6,3},{135,7,2},{199,7,3},{260,4,4},{324,4,5},{261,5,4},{388,4,6},{325,5,5},{262,6,4},{452,4,7},{389,5,6},{326,6,5},{263,7,4},{453,5,7},{390,6,6},{327,7,5},{454,6,7},{391,7,6},{455,7,7},},
};

const ScanElement* const getScanOrder( int g, int w2, int h2 ) { return m_scanOrder[g][w2][h2]; };

const ScanElement* m_scanOrder[SCAN_NUMBER_OF_GROUP_TYPES][MAX_TU_SIZE_IDX][MAX_TU_SIZE_IDX] =
{
  {
    { m_scanOrderBuf + 0, m_scanOrderBuf + 1, m_scanOrderBuf + 3, m_scanOrderBuf + 7, m_scanOrderBuf + 15, m_scanOrderBuf + 31, m_scanOrderBuf + 63, },
    { m_scanOrderBuf + 127, m_scanOrderBuf + 129, m_scanOrderBuf + 133, m_scanOrderBuf + 141, m_scanOrderBuf + 157, m_scanOrderBuf + 189, m_scanOrderBuf + 253, },
    { m_scanOrderBuf + 381, m_scanOrderBuf + 385, m_scanOrderBuf + 393, m_scanOrderBuf + 409, m_scanOrderBuf + 441, m_scanOrderBuf + 505, m_scanOrderBuf + 633, },
    { m_scanOrderBuf + 889, m_scanOrderBuf + 897, m_scanOrderBuf + 913, m_scanOrderBuf + 945, m_scanOrderBuf + 1009, m_scanOrderBuf + 1137, m_scanOrderBuf + 1393, },
    { m_scanOrderBuf + 1905, m_scanOrderBuf + 1921, m_scanOrderBuf + 1953, m_scanOrderBuf + 2017, m_scanOrderBuf + 2145, m_scanOrderBuf + 2401, m_scanOrderBuf + 2913, },
    { m_scanOrderBuf + 3937, m_scanOrderBuf + 3969, m_scanOrderBuf + 4033, m_scanOrderBuf + 4161, m_scanOrderBuf + 4417, m_scanOrderBuf + 4929, m_scanOrderBuf + 5953, },
    { m_scanOrderBuf + 8001, m_scanOrderBuf + 8065, m_scanOrderBuf + 8193, m_scanOrderBuf + 8449, m_scanOrderBuf + 8961, m_scanOrderBuf + 9985, m_scanOrderBuf + 12033, },
  },
  {
    { m_scanOrderBuf + 16129, m_scanOrderBuf + 16130, m_scanOrderBuf + 16132, m_scanOrderBuf + 16136, m_scanOrderBuf + 16144, m_scanOrderBuf + 16160, m_scanOrderBuf + 16192, },
    { m_scanOrderBuf + 16256, m_scanOrderBuf + 16258, m_scanOrderBuf + 16262, m_scanOrderBuf + 16270, m_scanOrderBuf + 16286, m_scanOrderBuf + 16318, m_scanOrderBuf + 16382, },
    { m_scanOrderBuf + 16510, m_scanOrderBuf + 16514, m_scanOrderBuf + 16522, m_scanOrderBuf + 16538, m_scanOrderBuf + 16570, m_scanOrderBuf + 16634, m_scanOrderBuf + 16762, },
    { m_scanOrderBuf + 17018, m_scanOrderBuf + 17026, m_scanOrderBuf + 17042, m_scanOrderBuf + 17074, m_scanOrderBuf + 17138, m_scanOrderBuf + 17266, m_scanOrderBuf + 17522, },
    { m_scanOrderBuf + 18034, m_scanOrderBuf + 18050, m_scanOrderBuf + 18082, m_scanOrderBuf + 18146, m_scanOrderBuf + 18274, m_scanOrderBuf + 18530, m_scanOrderBuf + 19042, },
    { m_scanOrderBuf + 20066, m_scanOrderBuf + 20098, m_scanOrderBuf + 20162, m_scanOrderBuf + 20290, m_scanOrderBuf + 20546, m_scanOrderBuf + 21058, m_scanOrderBuf + 22082, },
    { m_scanOrderBuf + 24130, m_scanOrderBuf + 24194, m_scanOrderBuf + 24322, m_scanOrderBuf + 24578, m_scanOrderBuf + 25090, m_scanOrderBuf + 26114, m_scanOrderBuf + 28162, },
  }
};
const ScanElement  m_scanOrderBuf[32258] =
{
  { 0, 0, 0 }, { 0,0,0 }, { 1,0,1 }, { 0,0,0 }, { 1,0,1 }, { 2,0,2 }, { 3,0,3 }, { 0,0,0 }, { 1,0,1 }, { 2,0,2 }, { 3,0,3 }, { 4,0,4 }, { 5,0,5 }, { 6,0,6 }, { 7,0,7 }, { 0,0,0 }, { 1,0,1 }, { 2,0,2 }, { 3,0,3 }, { 4,0,4 },
  { 5,0,5 }, { 6,0,6 }, { 7,0,7 }, { 8,0,8 }, { 9,0,9 }, { 10,0,10 }, { 11,0,11 }, { 12,0,12 }, { 13,0,13 }, { 14,0,14 }, { 15,0,15 }, { 0,0,0 }, { 1,0,1 }, { 2,0,2 }, { 3,0,3 }, { 4,0,4 }, { 5,0,5 }, { 6,0,6 }, { 7,0,7 }, { 8,0,8 },
  { 9,0,9 }, { 10,0,10 }, { 11,0,11 }, { 12,0,12 }, { 13,0,13 }, { 14,0,14 }, { 15,0,15 }, { 16,0,16 }, { 17,0,17 }, { 18,0,18 }, { 19,0,19 }, { 20,0,20 }, { 21,0,21 }, { 22,0,22 }, { 23,0,23 }, { 24,0,24 }, { 25,0,25 }, { 26,0,26 }, { 27,0,27 }, { 28,0,28 },
  { 29,0,29 }, { 30,0,30 }, { 31,0,31 }, { 0,0,0 }, { 1,0,1 }, { 2,0,2 }, { 3,0,3 }, { 4,0,4 }, { 5,0,5 }, { 6,0,6 }, { 7,0,7 }, { 8,0,8 }, { 9,0,9 }, { 10,0,10 }, { 11,0,11 }, { 12,0,12 }, { 13,0,13 }, { 14,0,14 }, { 15,0,15 }, { 16,0,16 },
  { 17,0,17 }, { 18,0,18 }, { 19,0,19 }, { 20,0,20 }, { 21,0,21 }, { 22,0,22 }, { 23,0,23 }, { 24,0,24 }, { 25,0,25 }, { 26,0,26 }, { 27,0,27 }, { 28,0,28 }, { 29,0,29 }, { 30,0,30 }, { 31,0,31 }, { 32,0,32 }, { 33,0,33 }, { 34,0,34 }, { 35,0,35 }, { 36,0,36 },
  { 37,0,37 }, { 38,0,38 }, { 39,0,39 }, { 40,0,40 }, { 41,0,41 }, { 42,0,42 }, { 43,0,43 }, { 44,0,44 }, { 45,0,45 }, { 46,0,46 }, { 47,0,47 }, { 48,0,48 }, { 49,0,49 }, { 50,0,50 }, { 51,0,51 }, { 52,0,52 }, { 53,0,53 }, { 54,0,54 }, { 55,0,55 }, { 56,0,56 },
  { 57,0,57 }, { 58,0,58 }, { 59,0,59 }, { 60,0,60 }, { 61,0,61 }, { 62,0,62 }, { 63,0,63 }, { 0,0,0 }, { 1,1,0 }, { 0,0,0 }, { 2,0,1 }, { 1,1,0 }, { 3,1,1 }, { 0,0,0 }, { 2,0,1 }, { 1,1,0 }, { 4,0,2 }, { 3,1,1 }, { 6,0,3 }, { 5,1,2 },
  { 7,1,3 }, { 0,0,0 }, { 2,0,1 }, { 1,1,0 }, { 4,0,2 }, { 3,1,1 }, { 6,0,3 }, { 5,1,2 }, { 8,0,4 }, { 7,1,3 }, { 10,0,5 }, { 9,1,4 }, { 12,0,6 }, { 11,1,5 }, { 14,0,7 }, { 13,1,6 }, { 15,1,7 }, { 0,0,0 }, { 2,0,1 }, { 1,1,0 },
  { 4,0,2 }, { 3,1,1 }, { 6,0,3 }, { 5,1,2 }, { 8,0,4 }, { 7,1,3 }, { 10,0,5 }, { 9,1,4 }, { 12,0,6 }, { 11,1,5 }, { 14,0,7 }, { 13,1,6 }, { 16,0,8 }, { 15,1,7 }, { 18,0,9 }, { 17,1,8 }, { 20,0,10 }, { 19,1,9 }, { 22,0,11 }, { 21,1,10 },
  { 24,0,12 }, { 23,1,11 }, { 26,0,13 }, { 25,1,12 }, { 28,0,14 }, { 27,1,13 }, { 30,0,15 }, { 29,1,14 }, { 31,1,15 }, { 0,0,0 }, { 2,0,1 }, { 1,1,0 }, { 4,0,2 }, { 3,1,1 }, { 6,0,3 }, { 5,1,2 }, { 8,0,4 }, { 7,1,3 }, { 10,0,5 }, { 9,1,4 },
  { 12,0,6 }, { 11,1,5 }, { 14,0,7 }, { 13,1,6 }, { 16,0,8 }, { 15,1,7 }, { 18,0,9 }, { 17,1,8 }, { 20,0,10 }, { 19,1,9 }, { 22,0,11 }, { 21,1,10 }, { 24,0,12 }, { 23,1,11 }, { 26,0,13 }, { 25,1,12 }, { 28,0,14 }, { 27,1,13 }, { 30,0,15 }, { 29,1,14 },
  { 32,0,16 }, { 31,1,15 }, { 34,0,17 }, { 33,1,16 }, { 36,0,18 }, { 35,1,17 }, { 38,0,19 }, { 37,1,18 }, { 40,0,20 }, { 39,1,19 }, { 42,0,21 }, { 41,1,20 }, { 44,0,22 }, { 43,1,21 }, { 46,0,23 }, { 45,1,22 }, { 48,0,24 }, { 47,1,23 }, { 50,0,25 }, { 49,1,24 },
  { 52,0,26 }, { 51,1,25 }, { 54,0,27 }, { 53,1,26 }, { 56,0,28 }, { 55,1,27 }, { 58,0,29 }, { 57,1,28 }, { 60,0,30 }, { 59,1,29 }, { 62,0,31 }, { 61,1,30 }, { 63,1,31 }, { 0,0,0 }, { 2,0,1 }, { 1,1,0 }, { 4,0,2 }, { 3,1,1 }, { 6,0,3 }, { 5,1,2 },
  { 8,0,4 }, { 7,1,3 }, { 10,0,5 }, { 9,1,4 }, { 12,0,6 }, { 11,1,5 }, { 14,0,7 }, { 13,1,6 }, { 16,0,8 }, { 15,1,7 }, { 18,0,9 }, { 17,1,8 }, { 20,0,10 }, { 19,1,9 }, { 22,0,11 }, { 21,1,10 }, { 24,0,12 }, { 23,1,11 }, { 26,0,13 }, { 25,1,12 },
  { 28,0,14 }, { 27,1,13 }, { 30,0,15 }, { 29,1,14 }, { 32,0,16 }, { 31,1,15 }, { 34,0,17 }, { 33,1,16 }, { 36,0,18 }, { 35,1,17 }, { 38,0,19 }, { 37,1,18 }, { 40,0,20 }, { 39,1,19 }, { 42,0,21 }, { 41,1,20 }, { 44,0,22 }, { 43,1,21 }, { 46,0,23 }, { 45,1,22 },
  { 48,0,24 }, { 47,1,23 }, { 50,0,25 }, { 49,1,24 }, { 52,0,26 }, { 51,1,25 }, { 54,0,27 }, { 53,1,26 }, { 56,0,28 }, { 55,1,27 }, { 58,0,29 }, { 57,1,28 }, { 60,0,30 }, { 59,1,29 }, { 62,0,31 }, { 61,1,30 }, { 64,0,32 }, { 63,1,31 }, { 66,0,33 }, { 65,1,32 },
  { 68,0,34 }, { 67,1,33 }, { 70,0,35 }, { 69,1,34 }, { 72,0,36 }, { 71,1,35 }, { 74,0,37 }, { 73,1,36 }, { 76,0,38 }, { 75,1,37 }, { 78,0,39 }, { 77,1,38 }, { 80,0,40 }, { 79,1,39 }, { 82,0,41 }, { 81,1,40 }, { 84,0,42 }, { 83,1,41 }, { 86,0,43 }, { 85,1,42 },
  { 88,0,44 }, { 87,1,43 }, { 90,0,45 }, { 89,1,44 }, { 92,0,46 }, { 91,1,45 }, { 94,0,47 }, { 93,1,46 }, { 96,0,48 }, { 95,1,47 }, { 98,0,49 }, { 97,1,48 }, { 100,0,50 }, { 99,1,49 }, { 102,0,51 }, { 101,1,50 }, { 104,0,52 }, { 103,1,51 }, { 106,0,53 }, { 105,1,52 },
  { 108,0,54 }, { 107,1,53 }, { 110,0,55 }, { 109,1,54 }, { 112,0,56 }, { 111,1,55 }, { 114,0,57 }, { 113,1,56 }, { 116,0,58 }, { 115,1,57 }, { 118,0,59 }, { 117,1,58 }, { 120,0,60 }, { 119,1,59 }, { 122,0,61 }, { 121,1,60 }, { 124,0,62 }, { 123,1,61 }, { 126,0,63 }, { 125,1,62 },
  { 127,1,63 }, { 0,0,0 }, { 1,1,0 }, { 2,2,0 }, { 3,3,0 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 5,1,1 }, { 2,2,0 }, { 6,2,1 }, { 3,3,0 }, { 7,3,1 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 8,0,2 }, { 5,1,1 }, { 2,2,0 }, { 12,0,3 },
  { 9,1,2 }, { 6,2,1 }, { 3,3,0 }, { 13,1,3 }, { 10,2,2 }, { 7,3,1 }, { 14,2,3 }, { 11,3,2 }, { 15,3,3 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 8,0,2 }, { 5,1,1 }, { 2,2,0 }, { 12,0,3 }, { 9,1,2 }, { 6,2,1 }, { 3,3,0 }, { 16,0,4 },
  { 13,1,3 }, { 10,2,2 }, { 7,3,1 }, { 20,0,5 }, { 17,1,4 }, { 14,2,3 }, { 11,3,2 }, { 24,0,6 }, { 21,1,5 }, { 18,2,4 }, { 15,3,3 }, { 28,0,7 }, { 25,1,6 }, { 22,2,5 }, { 19,3,4 }, { 29,1,7 }, { 26,2,6 }, { 23,3,5 }, { 30,2,7 }, { 27,3,6 },
  { 31,3,7 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 8,0,2 }, { 5,1,1 }, { 2,2,0 }, { 12,0,3 }, { 9,1,2 }, { 6,2,1 }, { 3,3,0 }, { 16,0,4 }, { 13,1,3 }, { 10,2,2 }, { 7,3,1 }, { 20,0,5 }, { 17,1,4 }, { 14,2,3 }, { 11,3,2 }, { 24,0,6 },
  { 21,1,5 }, { 18,2,4 }, { 15,3,3 }, { 28,0,7 }, { 25,1,6 }, { 22,2,5 }, { 19,3,4 }, { 32,0,8 }, { 29,1,7 }, { 26,2,6 }, { 23,3,5 }, { 36,0,9 }, { 33,1,8 }, { 30,2,7 }, { 27,3,6 }, { 40,0,10 }, { 37,1,9 }, { 34,2,8 }, { 31,3,7 }, { 44,0,11 },
  { 41,1,10 }, { 38,2,9 }, { 35,3,8 }, { 48,0,12 }, { 45,1,11 }, { 42,2,10 }, { 39,3,9 }, { 52,0,13 }, { 49,1,12 }, { 46,2,11 }, { 43,3,10 }, { 56,0,14 }, { 53,1,13 }, { 50,2,12 }, { 47,3,11 }, { 60,0,15 }, { 57,1,14 }, { 54,2,13 }, { 51,3,12 }, { 61,1,15 },
  { 58,2,14 }, { 55,3,13 }, { 62,2,15 }, { 59,3,14 }, { 63,3,15 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 8,0,2 }, { 5,1,1 }, { 2,2,0 }, { 12,0,3 }, { 9,1,2 }, { 6,2,1 }, { 3,3,0 }, { 16,0,4 }, { 13,1,3 }, { 10,2,2 }, { 7,3,1 }, { 20,0,5 },
  { 17,1,4 }, { 14,2,3 }, { 11,3,2 }, { 24,0,6 }, { 21,1,5 }, { 18,2,4 }, { 15,3,3 }, { 28,0,7 }, { 25,1,6 }, { 22,2,5 }, { 19,3,4 }, { 32,0,8 }, { 29,1,7 }, { 26,2,6 }, { 23,3,5 }, { 36,0,9 }, { 33,1,8 }, { 30,2,7 }, { 27,3,6 }, { 40,0,10 },
  { 37,1,9 }, { 34,2,8 }, { 31,3,7 }, { 44,0,11 }, { 41,1,10 }, { 38,2,9 }, { 35,3,8 }, { 48,0,12 }, { 45,1,11 }, { 42,2,10 }, { 39,3,9 }, { 52,0,13 }, { 49,1,12 }, { 46,2,11 }, { 43,3,10 }, { 56,0,14 }, { 53,1,13 }, { 50,2,12 }, { 47,3,11 }, { 60,0,15 },
  { 57,1,14 }, { 54,2,13 }, { 51,3,12 }, { 64,0,16 }, { 61,1,15 }, { 58,2,14 }, { 55,3,13 }, { 68,0,17 }, { 65,1,16 }, { 62,2,15 }, { 59,3,14 }, { 72,0,18 }, { 69,1,17 }, { 66,2,16 }, { 63,3,15 }, { 76,0,19 }, { 73,1,18 }, { 70,2,17 }, { 67,3,16 }, { 80,0,20 },
  { 77,1,19 }, { 74,2,18 }, { 71,3,17 }, { 84,0,21 }, { 81,1,20 }, { 78,2,19 }, { 75,3,18 }, { 88,0,22 }, { 85,1,21 }, { 82,2,20 }, { 79,3,19 }, { 92,0,23 }, { 89,1,22 }, { 86,2,21 }, { 83,3,20 }, { 96,0,24 }, { 93,1,23 }, { 90,2,22 }, { 87,3,21 }, { 100,0,25 },
  { 97,1,24 }, { 94,2,23 }, { 91,3,22 }, { 104,0,26 }, { 101,1,25 }, { 98,2,24 }, { 95,3,23 }, { 108,0,27 }, { 105,1,26 }, { 102,2,25 }, { 99,3,24 }, { 112,0,28 }, { 109,1,27 }, { 106,2,26 }, { 103,3,25 }, { 116,0,29 }, { 113,1,28 }, { 110,2,27 }, { 107,3,26 }, { 120,0,30 },
  { 117,1,29 }, { 114,2,28 }, { 111,3,27 }, { 124,0,31 }, { 121,1,30 }, { 118,2,29 }, { 115,3,28 }, { 125,1,31 }, { 122,2,30 }, { 119,3,29 }, { 126,2,31 }, { 123,3,30 }, { 127,3,31 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 8,0,2 }, { 5,1,1 }, { 2,2,0 }, { 12,0,3 },
  { 9,1,2 }, { 6,2,1 }, { 3,3,0 }, { 16,0,4 }, { 13,1,3 }, { 10,2,2 }, { 7,3,1 }, { 20,0,5 }, { 17,1,4 }, { 14,2,3 }, { 11,3,2 }, { 24,0,6 }, { 21,1,5 }, { 18,2,4 }, { 15,3,3 }, { 28,0,7 }, { 25,1,6 }, { 22,2,5 }, { 19,3,4 }, { 32,0,8 },
  { 29,1,7 }, { 26,2,6 }, { 23,3,5 }, { 36,0,9 }, { 33,1,8 }, { 30,2,7 }, { 27,3,6 }, { 40,0,10 }, { 37,1,9 }, { 34,2,8 }, { 31,3,7 }, { 44,0,11 }, { 41,1,10 }, { 38,2,9 }, { 35,3,8 }, { 48,0,12 }, { 45,1,11 }, { 42,2,10 }, { 39,3,9 }, { 52,0,13 },
  { 49,1,12 }, { 46,2,11 }, { 43,3,10 }, { 56,0,14 }, { 53,1,13 }, { 50,2,12 }, { 47,3,11 }, { 60,0,15 }, { 57,1,14 }, { 54,2,13 }, { 51,3,12 }, { 64,0,16 }, { 61,1,15 }, { 58,2,14 }, { 55,3,13 }, { 68,0,17 }, { 65,1,16 }, { 62,2,15 }, { 59,3,14 }, { 72,0,18 },
  { 69,1,17 }, { 66,2,16 }, { 63,3,15 }, { 76,0,19 }, { 73,1,18 }, { 70,2,17 }, { 67,3,16 }, { 80,0,20 }, { 77,1,19 }, { 74,2,18 }, { 71,3,17 }, { 84,0,21 }, { 81,1,20 }, { 78,2,19 }, { 75,3,18 }, { 88,0,22 }, { 85,1,21 }, { 82,2,20 }, { 79,3,19 }, { 92,0,23 },
  { 89,1,22 }, { 86,2,21 }, { 83,3,20 }, { 96,0,24 }, { 93,1,23 }, { 90,2,22 }, { 87,3,21 }, { 100,0,25 }, { 97,1,24 }, { 94,2,23 }, { 91,3,22 }, { 104,0,26 }, { 101,1,25 }, { 98,2,24 }, { 95,3,23 }, { 108,0,27 }, { 105,1,26 }, { 102,2,25 }, { 99,3,24 }, { 112,0,28 },
  { 109,1,27 }, { 106,2,26 }, { 103,3,25 }, { 116,0,29 }, { 113,1,28 }, { 110,2,27 }, { 107,3,26 }, { 120,0,30 }, { 117,1,29 }, { 114,2,28 }, { 111,3,27 }, { 124,0,31 }, { 121,1,30 }, { 118,2,29 }, { 115,3,28 }, { 128,0,32 }, { 125,1,31 }, { 122,2,30 }, { 119,3,29 }, { 132,0,33 },
  { 129,1,32 }, { 126,2,31 }, { 123,3,30 }, { 136,0,34 }, { 133,1,33 }, { 130,2,32 }, { 127,3,31 }, { 140,0,35 }, { 137,1,34 }, { 134,2,33 }, { 131,3,32 }, { 144,0,36 }, { 141,1,35 }, { 138,2,34 }, { 135,3,33 }, { 148,0,37 }, { 145,1,36 }, { 142,2,35 }, { 139,3,34 }, { 152,0,38 },
  { 149,1,37 }, { 146,2,36 }, { 143,3,35 }, { 156,0,39 }, { 153,1,38 }, { 150,2,37 }, { 147,3,36 }, { 160,0,40 }, { 157,1,39 }, { 154,2,38 }, { 151,3,37 }, { 164,0,41 }, { 161,1,40 }, { 158,2,39 }, { 155,3,38 }, { 168,0,42 }, { 165,1,41 }, { 162,2,40 }, { 159,3,39 }, { 172,0,43 },
  { 169,1,42 }, { 166,2,41 }, { 163,3,40 }, { 176,0,44 }, { 173,1,43 }, { 170,2,42 }, { 167,3,41 }, { 180,0,45 }, { 177,1,44 }, { 174,2,43 }, { 171,3,42 }, { 184,0,46 }, { 181,1,45 }, { 178,2,44 }, { 175,3,43 }, { 188,0,47 }, { 185,1,46 }, { 182,2,45 }, { 179,3,44 }, { 192,0,48 },
  { 189,1,47 }, { 186,2,46 }, { 183,3,45 }, { 196,0,49 }, { 193,1,48 }, { 190,2,47 }, { 187,3,46 }, { 200,0,50 }, { 197,1,49 }, { 194,2,48 }, { 191,3,47 }, { 204,0,51 }, { 201,1,50 }, { 198,2,49 }, { 195,3,48 }, { 208,0,52 }, { 205,1,51 }, { 202,2,50 }, { 199,3,49 }, { 212,0,53 },
  { 209,1,52 }, { 206,2,51 }, { 203,3,50 }, { 216,0,54 }, { 213,1,53 }, { 210,2,52 }, { 207,3,51 }, { 220,0,55 }, { 217,1,54 }, { 214,2,53 }, { 211,3,52 }, { 224,0,56 }, { 221,1,55 }, { 218,2,54 }, { 215,3,53 }, { 228,0,57 }, { 225,1,56 }, { 222,2,55 }, { 219,3,54 }, { 232,0,58 },
  { 229,1,57 }, { 226,2,56 }, { 223,3,55 }, { 236,0,59 }, { 233,1,58 }, { 230,2,57 }, { 227,3,56 }, { 240,0,60 }, { 237,1,59 }, { 234,2,58 }, { 231,3,57 }, { 244,0,61 }, { 241,1,60 }, { 238,2,59 }, { 235,3,58 }, { 248,0,62 }, { 245,1,61 }, { 242,2,60 }, { 239,3,59 }, { 252,0,63 },
  { 249,1,62 }, { 246,2,61 }, { 243,3,60 }, { 253,1,63 }, { 250,2,62 }, { 247,3,61 }, { 254,2,63 }, { 251,3,62 }, { 255,3,63 }, { 0,0,0 }, { 1,1,0 }, { 2,2,0 }, { 3,3,0 }, { 4,4,0 }, { 5,5,0 }, { 6,6,0 }, { 7,7,0 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 },
  { 9,1,1 }, { 2,2,0 }, { 10,2,1 }, { 3,3,0 }, { 11,3,1 }, { 4,4,0 }, { 12,4,1 }, { 5,5,0 }, { 13,5,1 }, { 6,6,0 }, { 14,6,1 }, { 7,7,0 }, { 15,7,1 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 }, { 16,0,2 }, { 9,1,1 }, { 2,2,0 }, { 24,0,3 },
  { 17,1,2 }, { 10,2,1 }, { 3,3,0 }, { 25,1,3 }, { 18,2,2 }, { 11,3,1 }, { 4,4,0 }, { 26,2,3 }, { 19,3,2 }, { 12,4,1 }, { 5,5,0 }, { 27,3,3 }, { 20,4,2 }, { 13,5,1 }, { 6,6,0 }, { 28,4,3 }, { 21,5,2 }, { 14,6,1 }, { 7,7,0 }, { 29,5,3 },
  { 22,6,2 }, { 15,7,1 }, { 30,6,3 }, { 23,7,2 }, { 31,7,3 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 }, { 16,0,2 }, { 9,1,1 }, { 2,2,0 }, { 24,0,3 }, { 17,1,2 }, { 10,2,1 }, { 3,3,0 }, { 32,0,4 }, { 25,1,3 }, { 18,2,2 }, { 11,3,1 }, { 4,4,0 },
  { 40,0,5 }, { 33,1,4 }, { 26,2,3 }, { 19,3,2 }, { 12,4,1 }, { 5,5,0 }, { 48,0,6 }, { 41,1,5 }, { 34,2,4 }, { 27,3,3 }, { 20,4,2 }, { 13,5,1 }, { 6,6,0 }, { 56,0,7 }, { 49,1,6 }, { 42,2,5 }, { 35,3,4 }, { 28,4,3 }, { 21,5,2 }, { 14,6,1 },
  { 7,7,0 }, { 57,1,7 }, { 50,2,6 }, { 43,3,5 }, { 36,4,4 }, { 29,5,3 }, { 22,6,2 }, { 15,7,1 }, { 58,2,7 }, { 51,3,6 }, { 44,4,5 }, { 37,5,4 }, { 30,6,3 }, { 23,7,2 }, { 59,3,7 }, { 52,4,6 }, { 45,5,5 }, { 38,6,4 }, { 31,7,3 }, { 60,4,7 },
  { 53,5,6 }, { 46,6,5 }, { 39,7,4 }, { 61,5,7 }, { 54,6,6 }, { 47,7,5 }, { 62,6,7 }, { 55,7,6 }, { 63,7,7 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 }, { 16,0,2 }, { 9,1,1 }, { 2,2,0 }, { 24,0,3 }, { 17,1,2 }, { 10,2,1 }, { 3,3,0 }, { 32,0,4 },
  { 25,1,3 }, { 18,2,2 }, { 11,3,1 }, { 4,4,0 }, { 40,0,5 }, { 33,1,4 }, { 26,2,3 }, { 19,3,2 }, { 12,4,1 }, { 5,5,0 }, { 48,0,6 }, { 41,1,5 }, { 34,2,4 }, { 27,3,3 }, { 20,4,2 }, { 13,5,1 }, { 6,6,0 }, { 56,0,7 }, { 49,1,6 }, { 42,2,5 },
  { 35,3,4 }, { 28,4,3 }, { 21,5,2 }, { 14,6,1 }, { 7,7,0 }, { 64,0,8 }, { 57,1,7 }, { 50,2,6 }, { 43,3,5 }, { 36,4,4 }, { 29,5,3 }, { 22,6,2 }, { 15,7,1 }, { 72,0,9 }, { 65,1,8 }, { 58,2,7 }, { 51,3,6 }, { 44,4,5 }, { 37,5,4 }, { 30,6,3 },
  { 23,7,2 }, { 80,0,10 }, { 73,1,9 }, { 66,2,8 }, { 59,3,7 }, { 52,4,6 }, { 45,5,5 }, { 38,6,4 }, { 31,7,3 }, { 88,0,11 }, { 81,1,10 }, { 74,2,9 }, { 67,3,8 }, { 60,4,7 }, { 53,5,6 }, { 46,6,5 }, { 39,7,4 }, { 96,0,12 }, { 89,1,11 }, { 82,2,10 },
  { 75,3,9 }, { 68,4,8 }, { 61,5,7 }, { 54,6,6 }, { 47,7,5 }, { 104,0,13 }, { 97,1,12 }, { 90,2,11 }, { 83,3,10 }, { 76,4,9 }, { 69,5,8 }, { 62,6,7 }, { 55,7,6 }, { 112,0,14 }, { 105,1,13 }, { 98,2,12 }, { 91,3,11 }, { 84,4,10 }, { 77,5,9 }, { 70,6,8 },
  { 63,7,7 }, { 120,0,15 }, { 113,1,14 }, { 106,2,13 }, { 99,3,12 }, { 92,4,11 }, { 85,5,10 }, { 78,6,9 }, { 71,7,8 }, { 121,1,15 }, { 114,2,14 }, { 107,3,13 }, { 100,4,12 }, { 93,5,11 }, { 86,6,10 }, { 79,7,9 }, { 122,2,15 }, { 115,3,14 }, { 108,4,13 }, { 101,5,12 },
  { 94,6,11 }, { 87,7,10 }, { 123,3,15 }, { 116,4,14 }, { 109,5,13 }, { 102,6,12 }, { 95,7,11 }, { 124,4,15 }, { 117,5,14 }, { 110,6,13 }, { 103,7,12 }, { 125,5,15 }, { 118,6,14 }, { 111,7,13 }, { 126,6,15 }, { 119,7,14 }, { 127,7,15 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 },
  { 16,0,2 }, { 9,1,1 }, { 2,2,0 }, { 24,0,3 }, { 17,1,2 }, { 10,2,1 }, { 3,3,0 }, { 32,0,4 }, { 25,1,3 }, { 18,2,2 }, { 11,3,1 }, { 4,4,0 }, { 40,0,5 }, { 33,1,4 }, { 26,2,3 }, { 19,3,2 }, { 12,4,1 }, { 5,5,0 }, { 48,0,6 }, { 41,1,5 },
  { 34,2,4 }, { 27,3,3 }, { 20,4,2 }, { 13,5,1 }, { 6,6,0 }, { 56,0,7 }, { 49,1,6 }, { 42,2,5 }, { 35,3,4 }, { 28,4,3 }, { 21,5,2 }, { 14,6,1 }, { 7,7,0 }, { 64,0,8 }, { 57,1,7 }, { 50,2,6 }, { 43,3,5 }, { 36,4,4 }, { 29,5,3 }, { 22,6,2 },
  { 15,7,1 }, { 72,0,9 }, { 65,1,8 }, { 58,2,7 }, { 51,3,6 }, { 44,4,5 }, { 37,5,4 }, { 30,6,3 }, { 23,7,2 }, { 80,0,10 }, { 73,1,9 }, { 66,2,8 }, { 59,3,7 }, { 52,4,6 }, { 45,5,5 }, { 38,6,4 }, { 31,7,3 }, { 88,0,11 }, { 81,1,10 }, { 74,2,9 },
  { 67,3,8 }, { 60,4,7 }, { 53,5,6 }, { 46,6,5 }, { 39,7,4 }, { 96,0,12 }, { 89,1,11 }, { 82,2,10 }, { 75,3,9 }, { 68,4,8 }, { 61,5,7 }, { 54,6,6 }, { 47,7,5 }, { 104,0,13 }, { 97,1,12 }, { 90,2,11 }, { 83,3,10 }, { 76,4,9 }, { 69,5,8 }, { 62,6,7 },
  { 55,7,6 }, { 112,0,14 }, { 105,1,13 }, { 98,2,12 }, { 91,3,11 }, { 84,4,10 }, { 77,5,9 }, { 70,6,8 }, { 63,7,7 }, { 120,0,15 }, { 113,1,14 }, { 106,2,13 }, { 99,3,12 }, { 92,4,11 }, { 85,5,10 }, { 78,6,9 }, { 71,7,8 }, { 128,0,16 }, { 121,1,15 }, { 114,2,14 },
  { 107,3,13 }, { 100,4,12 }, { 93,5,11 }, { 86,6,10 }, { 79,7,9 }, { 136,0,17 }, { 129,1,16 }, { 122,2,15 }, { 115,3,14 }, { 108,4,13 }, { 101,5,12 }, { 94,6,11 }, { 87,7,10 }, { 144,0,18 }, { 137,1,17 }, { 130,2,16 }, { 123,3,15 }, { 116,4,14 }, { 109,5,13 }, { 102,6,12 },
  { 95,7,11 }, { 152,0,19 }, { 145,1,18 }, { 138,2,17 }, { 131,3,16 }, { 124,4,15 }, { 117,5,14 }, { 110,6,13 }, { 103,7,12 }, { 160,0,20 }, { 153,1,19 }, { 146,2,18 }, { 139,3,17 }, { 132,4,16 }, { 125,5,15 }, { 118,6,14 }, { 111,7,13 }, { 168,0,21 }, { 161,1,20 }, { 154,2,19 },
  { 147,3,18 }, { 140,4,17 }, { 133,5,16 }, { 126,6,15 }, { 119,7,14 }, { 176,0,22 }, { 169,1,21 }, { 162,2,20 }, { 155,3,19 }, { 148,4,18 }, { 141,5,17 }, { 134,6,16 }, { 127,7,15 }, { 184,0,23 }, { 177,1,22 }, { 170,2,21 }, { 163,3,20 }, { 156,4,19 }, { 149,5,18 }, { 142,6,17 },
  { 135,7,16 }, { 192,0,24 }, { 185,1,23 }, { 178,2,22 }, { 171,3,21 }, { 164,4,20 }, { 157,5,19 }, { 150,6,18 }, { 143,7,17 }, { 200,0,25 }, { 193,1,24 }, { 186,2,23 }, { 179,3,22 }, { 172,4,21 }, { 165,5,20 }, { 158,6,19 }, { 151,7,18 }, { 208,0,26 }, { 201,1,25 }, { 194,2,24 },
  { 187,3,23 }, { 180,4,22 }, { 173,5,21 }, { 166,6,20 }, { 159,7,19 }, { 216,0,27 }, { 209,1,26 }, { 202,2,25 }, { 195,3,24 }, { 188,4,23 }, { 181,5,22 }, { 174,6,21 }, { 167,7,20 }, { 224,0,28 }, { 217,1,27 }, { 210,2,26 }, { 203,3,25 }, { 196,4,24 }, { 189,5,23 }, { 182,6,22 },
  { 175,7,21 }, { 232,0,29 }, { 225,1,28 }, { 218,2,27 }, { 211,3,26 }, { 204,4,25 }, { 197,5,24 }, { 190,6,23 }, { 183,7,22 }, { 240,0,30 }, { 233,1,29 }, { 226,2,28 }, { 219,3,27 }, { 212,4,26 }, { 205,5,25 }, { 198,6,24 }, { 191,7,23 }, { 248,0,31 }, { 241,1,30 }, { 234,2,29 },
  { 227,3,28 }, { 220,4,27 }, { 213,5,26 }, { 206,6,25 }, { 199,7,24 }, { 249,1,31 }, { 242,2,30 }, { 235,3,29 }, { 228,4,28 }, { 221,5,27 }, { 214,6,26 }, { 207,7,25 }, { 250,2,31 }, { 243,3,30 }, { 236,4,29 }, { 229,5,28 }, { 222,6,27 }, { 215,7,26 }, { 251,3,31 }, { 244,4,30 },
  { 237,5,29 }, { 230,6,28 }, { 223,7,27 }, { 252,4,31 }, { 245,5,30 }, { 238,6,29 }, { 231,7,28 }, { 253,5,31 }, { 246,6,30 }, { 239,7,29 }, { 254,6,31 }, { 247,7,30 }, { 255,7,31 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 }, { 16,0,2 }, { 9,1,1 }, { 2,2,0 }, { 24,0,3 },
  { 17,1,2 }, { 10,2,1 }, { 3,3,0 }, { 32,0,4 }, { 25,1,3 }, { 18,2,2 }, { 11,3,1 }, { 4,4,0 }, { 40,0,5 }, { 33,1,4 }, { 26,2,3 }, { 19,3,2 }, { 12,4,1 }, { 5,5,0 }, { 48,0,6 }, { 41,1,5 }, { 34,2,4 }, { 27,3,3 }, { 20,4,2 }, { 13,5,1 },
  { 6,6,0 }, { 56,0,7 }, { 49,1,6 }, { 42,2,5 }, { 35,3,4 }, { 28,4,3 }, { 21,5,2 }, { 14,6,1 }, { 7,7,0 }, { 64,0,8 }, { 57,1,7 }, { 50,2,6 }, { 43,3,5 }, { 36,4,4 }, { 29,5,3 }, { 22,6,2 }, { 15,7,1 }, { 72,0,9 }, { 65,1,8 }, { 58,2,7 },
  { 51,3,6 }, { 44,4,5 }, { 37,5,4 }, { 30,6,3 }, { 23,7,2 }, { 80,0,10 }, { 73,1,9 }, { 66,2,8 }, { 59,3,7 }, { 52,4,6 }, { 45,5,5 }, { 38,6,4 }, { 31,7,3 }, { 88,0,11 }, { 81,1,10 }, { 74,2,9 }, { 67,3,8 }, { 60,4,7 }, { 53,5,6 }, { 46,6,5 },
  { 39,7,4 }, { 96,0,12 }, { 89,1,11 }, { 82,2,10 }, { 75,3,9 }, { 68,4,8 }, { 61,5,7 }, { 54,6,6 }, { 47,7,5 }, { 104,0,13 }, { 97,1,12 }, { 90,2,11 }, { 83,3,10 }, { 76,4,9 }, { 69,5,8 }, { 62,6,7 }, { 55,7,6 }, { 112,0,14 }, { 105,1,13 }, { 98,2,12 },
  { 91,3,11 }, { 84,4,10 }, { 77,5,9 }, { 70,6,8 }, { 63,7,7 }, { 120,0,15 }, { 113,1,14 }, { 106,2,13 }, { 99,3,12 }, { 92,4,11 }, { 85,5,10 }, { 78,6,9 }, { 71,7,8 }, { 128,0,16 }, { 121,1,15 }, { 114,2,14 }, { 107,3,13 }, { 100,4,12 }, { 93,5,11 }, { 86,6,10 },
  { 79,7,9 }, { 136,0,17 }, { 129,1,16 }, { 122,2,15 }, { 115,3,14 }, { 108,4,13 }, { 101,5,12 }, { 94,6,11 }, { 87,7,10 }, { 144,0,18 }, { 137,1,17 }, { 130,2,16 }, { 123,3,15 }, { 116,4,14 }, { 109,5,13 }, { 102,6,12 }, { 95,7,11 }, { 152,0,19 }, { 145,1,18 }, { 138,2,17 },
  { 131,3,16 }, { 124,4,15 }, { 117,5,14 }, { 110,6,13 }, { 103,7,12 }, { 160,0,20 }, { 153,1,19 }, { 146,2,18 }, { 139,3,17 }, { 132,4,16 }, { 125,5,15 }, { 118,6,14 }, { 111,7,13 }, { 168,0,21 }, { 161,1,20 }, { 154,2,19 }, { 147,3,18 }, { 140,4,17 }, { 133,5,16 }, { 126,6,15 },
  { 119,7,14 }, { 176,0,22 }, { 169,1,21 }, { 162,2,20 }, { 155,3,19 }, { 148,4,18 }, { 141,5,17 }, { 134,6,16 }, { 127,7,15 }, { 184,0,23 }, { 177,1,22 }, { 170,2,21 }, { 163,3,20 }, { 156,4,19 }, { 149,5,18 }, { 142,6,17 }, { 135,7,16 }, { 192,0,24 }, { 185,1,23 }, { 178,2,22 },
  { 171,3,21 }, { 164,4,20 }, { 157,5,19 }, { 150,6,18 }, { 143,7,17 }, { 200,0,25 }, { 193,1,24 }, { 186,2,23 }, { 179,3,22 }, { 172,4,21 }, { 165,5,20 }, { 158,6,19 }, { 151,7,18 }, { 208,0,26 }, { 201,1,25 }, { 194,2,24 }, { 187,3,23 }, { 180,4,22 }, { 173,5,21 }, { 166,6,20 },
  { 159,7,19 }, { 216,0,27 }, { 209,1,26 }, { 202,2,25 }, { 195,3,24 }, { 188,4,23 }, { 181,5,22 }, { 174,6,21 }, { 167,7,20 }, { 224,0,28 }, { 217,1,27 }, { 210,2,26 }, { 203,3,25 }, { 196,4,24 }, { 189,5,23 }, { 182,6,22 }, { 175,7,21 }, { 232,0,29 }, { 225,1,28 }, { 218,2,27 },
  { 211,3,26 }, { 204,4,25 }, { 197,5,24 }, { 190,6,23 }, { 183,7,22 }, { 240,0,30 }, { 233,1,29 }, { 226,2,28 }, { 219,3,27 }, { 212,4,26 }, { 205,5,25 }, { 198,6,24 }, { 191,7,23 }, { 248,0,31 }, { 241,1,30 }, { 234,2,29 }, { 227,3,28 }, { 220,4,27 }, { 213,5,26 }, { 206,6,25 },
  { 199,7,24 }, { 256,0,32 }, { 249,1,31 }, { 242,2,30 }, { 235,3,29 }, { 228,4,28 }, { 221,5,27 }, { 214,6,26 }, { 207,7,25 }, { 264,0,33 }, { 257,1,32 }, { 250,2,31 }, { 243,3,30 }, { 236,4,29 }, { 229,5,28 }, { 222,6,27 }, { 215,7,26 }, { 272,0,34 }, { 265,1,33 }, { 258,2,32 },
  { 251,3,31 }, { 244,4,30 }, { 237,5,29 }, { 230,6,28 }, { 223,7,27 }, { 280,0,35 }, { 273,1,34 }, { 266,2,33 }, { 259,3,32 }, { 252,4,31 }, { 245,5,30 }, { 238,6,29 }, { 231,7,28 }, { 288,0,36 }, { 281,1,35 }, { 274,2,34 }, { 267,3,33 }, { 260,4,32 }, { 253,5,31 }, { 246,6,30 },
  { 239,7,29 }, { 296,0,37 }, { 289,1,36 }, { 282,2,35 }, { 275,3,34 }, { 268,4,33 }, { 261,5,32 }, { 254,6,31 }, { 247,7,30 }, { 304,0,38 }, { 297,1,37 }, { 290,2,36 }, { 283,3,35 }, { 276,4,34 }, { 269,5,33 }, { 262,6,32 }, { 255,7,31 }, { 312,0,39 }, { 305,1,38 }, { 298,2,37 },
  { 291,3,36 }, { 284,4,35 }, { 277,5,34 }, { 270,6,33 }, { 263,7,32 }, { 320,0,40 }, { 313,1,39 }, { 306,2,38 }, { 299,3,37 }, { 292,4,36 }, { 285,5,35 }, { 278,6,34 }, { 271,7,33 }, { 328,0,41 }, { 321,1,40 }, { 314,2,39 }, { 307,3,38 }, { 300,4,37 }, { 293,5,36 }, { 286,6,35 },
  { 279,7,34 }, { 336,0,42 }, { 329,1,41 }, { 322,2,40 }, { 315,3,39 }, { 308,4,38 }, { 301,5,37 }, { 294,6,36 }, { 287,7,35 }, { 344,0,43 }, { 337,1,42 }, { 330,2,41 }, { 323,3,40 }, { 316,4,39 }, { 309,5,38 }, { 302,6,37 }, { 295,7,36 }, { 352,0,44 }, { 345,1,43 }, { 338,2,42 },
  { 331,3,41 }, { 324,4,40 }, { 317,5,39 }, { 310,6,38 }, { 303,7,37 }, { 360,0,45 }, { 353,1,44 }, { 346,2,43 }, { 339,3,42 }, { 332,4,41 }, { 325,5,40 }, { 318,6,39 }, { 311,7,38 }, { 368,0,46 }, { 361,1,45 }, { 354,2,44 }, { 347,3,43 }, { 340,4,42 }, { 333,5,41 }, { 326,6,40 },
  { 319,7,39 }, { 376,0,47 }, { 369,1,46 }, { 362,2,45 }, { 355,3,44 }, { 348,4,43 }, { 341,5,42 }, { 334,6,41 }, { 327,7,40 }, { 384,0,48 }, { 377,1,47 }, { 370,2,46 }, { 363,3,45 }, { 356,4,44 }, { 349,5,43 }, { 342,6,42 }, { 335,7,41 }, { 392,0,49 }, { 385,1,48 }, { 378,2,47 },
  { 371,3,46 }, { 364,4,45 }, { 357,5,44 }, { 350,6,43 }, { 343,7,42 }, { 400,0,50 }, { 393,1,49 }, { 386,2,48 }, { 379,3,47 }, { 372,4,46 }, { 365,5,45 }, { 358,6,44 }, { 351,7,43 }, { 408,0,51 }, { 401,1,50 }, { 394,2,49 }, { 387,3,48 }, { 380,4,47 }, { 373,5,46 }, { 366,6,45 },
  { 359,7,44 }, { 416,0,52 }, { 409,1,51 }, { 402,2,50 }, { 395,3,49 }, { 388,4,48 }, { 381,5,47 }, { 374,6,46 }, { 367,7,45 }, { 424,0,53 }, { 417,1,52 }, { 410,2,51 }, { 403,3,50 }, { 396,4,49 }, { 389,5,48 }, { 382,6,47 }, { 375,7,46 }, { 432,0,54 }, { 425,1,53 }, { 418,2,52 },
  { 411,3,51 }, { 404,4,50 }, { 397,5,49 }, { 390,6,48 }, { 383,7,47 }, { 440,0,55 }, { 433,1,54 }, { 426,2,53 }, { 419,3,52 }, { 412,4,51 }, { 405,5,50 }, { 398,6,49 }, { 391,7,48 }, { 448,0,56 }, { 441,1,55 }, { 434,2,54 }, { 427,3,53 }, { 420,4,52 }, { 413,5,51 }, { 406,6,50 },
  { 399,7,49 }, { 456,0,57 }, { 449,1,56 }, { 442,2,55 }, { 435,3,54 }, { 428,4,53 }, { 421,5,52 }, { 414,6,51 }, { 407,7,50 }, { 464,0,58 }, { 457,1,57 }, { 450,2,56 }, { 443,3,55 }, { 436,4,54 }, { 429,5,53 }, { 422,6,52 }, { 415,7,51 }, { 472,0,59 }, { 465,1,58 }, { 458,2,57 },
  { 451,3,56 }, { 444,4,55 }, { 437,5,54 }, { 430,6,53 }, { 423,7,52 }, { 480,0,60 }, { 473,1,59 }, { 466,2,58 }, { 459,3,57 }, { 452,4,56 }, { 445,5,55 }, { 438,6,54 }, { 431,7,53 }, { 488,0,61 }, { 481,1,60 }, { 474,2,59 }, { 467,3,58 }, { 460,4,57 }, { 453,5,56 }, { 446,6,55 },
  { 439,7,54 }, { 496,0,62 }, { 489,1,61 }, { 482,2,60 }, { 475,3,59 }, { 468,4,58 }, { 461,5,57 }, { 454,6,56 }, { 447,7,55 }, { 504,0,63 }, { 497,1,62 }, { 490,2,61 }, { 483,3,60 }, { 476,4,59 }, { 469,5,58 }, { 462,6,57 }, { 455,7,56 }, { 505,1,63 }, { 498,2,62 }, { 491,3,61 },
  { 484,4,60 }, { 477,5,59 }, { 470,6,58 }, { 463,7,57 }, { 506,2,63 }, { 499,3,62 }, { 492,4,61 }, { 485,5,60 }, { 478,6,59 }, { 471,7,58 }, { 507,3,63 }, { 500,4,62 }, { 493,5,61 }, { 486,6,60 }, { 479,7,59 }, { 508,4,63 }, { 501,5,62 }, { 494,6,61 }, { 487,7,60 }, { 509,5,63 },
  { 502,6,62 }, { 495,7,61 }, { 510,6,63 }, { 503,7,62 }, { 511,7,63 }, { 0,0,0 }, { 1,1,0 }, { 2,2,0 }, { 3,3,0 }, { 4,4,0 }, { 5,5,0 }, { 6,6,0 }, { 7,7,0 }, { 8,8,0 }, { 9,9,0 }, { 10,10,0 }, { 11,11,0 }, { 12,12,0 }, { 13,13,0 }, { 14,14,0 },
  { 15,15,0 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 17,1,1 }, { 2,2,0 }, { 18,2,1 }, { 3,3,0 }, { 19,3,1 }, { 4,4,0 }, { 20,4,1 }, { 5,5,0 }, { 21,5,1 }, { 6,6,0 }, { 22,6,1 }, { 7,7,0 }, { 23,7,1 }, { 8,8,0 }, { 24,8,1 }, { 9,9,0 },
  { 25,9,1 }, { 10,10,0 }, { 26,10,1 }, { 11,11,0 }, { 27,11,1 }, { 12,12,0 }, { 28,12,1 }, { 13,13,0 }, { 29,13,1 }, { 14,14,0 }, { 30,14,1 }, { 15,15,0 }, { 31,15,1 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 32,0,2 }, { 17,1,1 }, { 2,2,0 }, { 48,0,3 },
  { 33,1,2 }, { 18,2,1 }, { 3,3,0 }, { 49,1,3 }, { 34,2,2 }, { 19,3,1 }, { 4,4,0 }, { 50,2,3 }, { 35,3,2 }, { 20,4,1 }, { 5,5,0 }, { 51,3,3 }, { 36,4,2 }, { 21,5,1 }, { 6,6,0 }, { 52,4,3 }, { 37,5,2 }, { 22,6,1 }, { 7,7,0 }, { 53,5,3 },
  { 38,6,2 }, { 23,7,1 }, { 8,8,0 }, { 54,6,3 }, { 39,7,2 }, { 24,8,1 }, { 9,9,0 }, { 55,7,3 }, { 40,8,2 }, { 25,9,1 }, { 10,10,0 }, { 56,8,3 }, { 41,9,2 }, { 26,10,1 }, { 11,11,0 }, { 57,9,3 }, { 42,10,2 }, { 27,11,1 }, { 12,12,0 }, { 58,10,3 },
  { 43,11,2 }, { 28,12,1 }, { 13,13,0 }, { 59,11,3 }, { 44,12,2 }, { 29,13,1 }, { 14,14,0 }, { 60,12,3 }, { 45,13,2 }, { 30,14,1 }, { 15,15,0 }, { 61,13,3 }, { 46,14,2 }, { 31,15,1 }, { 62,14,3 }, { 47,15,2 }, { 63,15,3 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 },
  { 32,0,2 }, { 17,1,1 }, { 2,2,0 }, { 48,0,3 }, { 33,1,2 }, { 18,2,1 }, { 3,3,0 }, { 64,0,4 }, { 49,1,3 }, { 34,2,2 }, { 19,3,1 }, { 4,4,0 }, { 80,0,5 }, { 65,1,4 }, { 50,2,3 }, { 35,3,2 }, { 20,4,1 }, { 5,5,0 }, { 96,0,6 }, { 81,1,5 },
  { 66,2,4 }, { 51,3,3 }, { 36,4,2 }, { 21,5,1 }, { 6,6,0 }, { 112,0,7 }, { 97,1,6 }, { 82,2,5 }, { 67,3,4 }, { 52,4,3 }, { 37,5,2 }, { 22,6,1 }, { 7,7,0 }, { 113,1,7 }, { 98,2,6 }, { 83,3,5 }, { 68,4,4 }, { 53,5,3 }, { 38,6,2 }, { 23,7,1 },
  { 8,8,0 }, { 114,2,7 }, { 99,3,6 }, { 84,4,5 }, { 69,5,4 }, { 54,6,3 }, { 39,7,2 }, { 24,8,1 }, { 9,9,0 }, { 115,3,7 }, { 100,4,6 }, { 85,5,5 }, { 70,6,4 }, { 55,7,3 }, { 40,8,2 }, { 25,9,1 }, { 10,10,0 }, { 116,4,7 }, { 101,5,6 }, { 86,6,5 },
  { 71,7,4 }, { 56,8,3 }, { 41,9,2 }, { 26,10,1 }, { 11,11,0 }, { 117,5,7 }, { 102,6,6 }, { 87,7,5 }, { 72,8,4 }, { 57,9,3 }, { 42,10,2 }, { 27,11,1 }, { 12,12,0 }, { 118,6,7 }, { 103,7,6 }, { 88,8,5 }, { 73,9,4 }, { 58,10,3 }, { 43,11,2 }, { 28,12,1 },
  { 13,13,0 }, { 119,7,7 }, { 104,8,6 }, { 89,9,5 }, { 74,10,4 }, { 59,11,3 }, { 44,12,2 }, { 29,13,1 }, { 14,14,0 }, { 120,8,7 }, { 105,9,6 }, { 90,10,5 }, { 75,11,4 }, { 60,12,3 }, { 45,13,2 }, { 30,14,1 }, { 15,15,0 }, { 121,9,7 }, { 106,10,6 }, { 91,11,5 },
  { 76,12,4 }, { 61,13,3 }, { 46,14,2 }, { 31,15,1 }, { 122,10,7 }, { 107,11,6 }, { 92,12,5 }, { 77,13,4 }, { 62,14,3 }, { 47,15,2 }, { 123,11,7 }, { 108,12,6 }, { 93,13,5 }, { 78,14,4 }, { 63,15,3 }, { 124,12,7 }, { 109,13,6 }, { 94,14,5 }, { 79,15,4 }, { 125,13,7 },
  { 110,14,6 }, { 95,15,5 }, { 126,14,7 }, { 111,15,6 }, { 127,15,7 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 32,0,2 }, { 17,1,1 }, { 2,2,0 }, { 48,0,3 }, { 33,1,2 }, { 18,2,1 }, { 3,3,0 }, { 64,0,4 }, { 49,1,3 }, { 34,2,2 }, { 19,3,1 }, { 4,4,0 },
  { 80,0,5 }, { 65,1,4 }, { 50,2,3 }, { 35,3,2 }, { 20,4,1 }, { 5,5,0 }, { 96,0,6 }, { 81,1,5 }, { 66,2,4 }, { 51,3,3 }, { 36,4,2 }, { 21,5,1 }, { 6,6,0 }, { 112,0,7 }, { 97,1,6 }, { 82,2,5 }, { 67,3,4 }, { 52,4,3 }, { 37,5,2 }, { 22,6,1 },
  { 7,7,0 }, { 128,0,8 }, { 113,1,7 }, { 98,2,6 }, { 83,3,5 }, { 68,4,4 }, { 53,5,3 }, { 38,6,2 }, { 23,7,1 }, { 8,8,0 }, { 144,0,9 }, { 129,1,8 }, { 114,2,7 }, { 99,3,6 }, { 84,4,5 }, { 69,5,4 }, { 54,6,3 }, { 39,7,2 }, { 24,8,1 }, { 9,9,0 },
  { 160,0,10 }, { 145,1,9 }, { 130,2,8 }, { 115,3,7 }, { 100,4,6 }, { 85,5,5 }, { 70,6,4 }, { 55,7,3 }, { 40,8,2 }, { 25,9,1 }, { 10,10,0 }, { 176,0,11 }, { 161,1,10 }, { 146,2,9 }, { 131,3,8 }, { 116,4,7 }, { 101,5,6 }, { 86,6,5 }, { 71,7,4 }, { 56,8,3 },
  { 41,9,2 }, { 26,10,1 }, { 11,11,0 }, { 192,0,12 }, { 177,1,11 }, { 162,2,10 }, { 147,3,9 }, { 132,4,8 }, { 117,5,7 }, { 102,6,6 }, { 87,7,5 }, { 72,8,4 }, { 57,9,3 }, { 42,10,2 }, { 27,11,1 }, { 12,12,0 }, { 208,0,13 }, { 193,1,12 }, { 178,2,11 }, { 163,3,10 },
  { 148,4,9 }, { 133,5,8 }, { 118,6,7 }, { 103,7,6 }, { 88,8,5 }, { 73,9,4 }, { 58,10,3 }, { 43,11,2 }, { 28,12,1 }, { 13,13,0 }, { 224,0,14 }, { 209,1,13 }, { 194,2,12 }, { 179,3,11 }, { 164,4,10 }, { 149,5,9 }, { 134,6,8 }, { 119,7,7 }, { 104,8,6 }, { 89,9,5 },
  { 74,10,4 }, { 59,11,3 }, { 44,12,2 }, { 29,13,1 }, { 14,14,0 }, { 240,0,15 }, { 225,1,14 }, { 210,2,13 }, { 195,3,12 }, { 180,4,11 }, { 165,5,10 }, { 150,6,9 }, { 135,7,8 }, { 120,8,7 }, { 105,9,6 }, { 90,10,5 }, { 75,11,4 }, { 60,12,3 }, { 45,13,2 }, { 30,14,1 },
  { 15,15,0 }, { 241,1,15 }, { 226,2,14 }, { 211,3,13 }, { 196,4,12 }, { 181,5,11 }, { 166,6,10 }, { 151,7,9 }, { 136,8,8 }, { 121,9,7 }, { 106,10,6 }, { 91,11,5 }, { 76,12,4 }, { 61,13,3 }, { 46,14,2 }, { 31,15,1 }, { 242,2,15 }, { 227,3,14 }, { 212,4,13 }, { 197,5,12 },
  { 182,6,11 }, { 167,7,10 }, { 152,8,9 }, { 137,9,8 }, { 122,10,7 }, { 107,11,6 }, { 92,12,5 }, { 77,13,4 }, { 62,14,3 }, { 47,15,2 }, { 243,3,15 }, { 228,4,14 }, { 213,5,13 }, { 198,6,12 }, { 183,7,11 }, { 168,8,10 }, { 153,9,9 }, { 138,10,8 }, { 123,11,7 }, { 108,12,6 },
  { 93,13,5 }, { 78,14,4 }, { 63,15,3 }, { 244,4,15 }, { 229,5,14 }, { 214,6,13 }, { 199,7,12 }, { 184,8,11 }, { 169,9,10 }, { 154,10,9 }, { 139,11,8 }, { 124,12,7 }, { 109,13,6 }, { 94,14,5 }, { 79,15,4 }, { 245,5,15 }, { 230,6,14 }, { 215,7,13 }, { 200,8,12 }, { 185,9,11 },
  { 170,10,10 }, { 155,11,9 }, { 140,12,8 }, { 125,13,7 }, { 110,14,6 }, { 95,15,5 }, { 246,6,15 }, { 231,7,14 }, { 216,8,13 }, { 201,9,12 }, { 186,10,11 }, { 171,11,10 }, { 156,12,9 }, { 141,13,8 }, { 126,14,7 }, { 111,15,6 }, { 247,7,15 }, { 232,8,14 }, { 217,9,13 }, { 202,10,12 },
  { 187,11,11 }, { 172,12,10 }, { 157,13,9 }, { 142,14,8 }, { 127,15,7 }, { 248,8,15 }, { 233,9,14 }, { 218,10,13 }, { 203,11,12 }, { 188,12,11 }, { 173,13,10 }, { 158,14,9 }, { 143,15,8 }, { 249,9,15 }, { 234,10,14 }, { 219,11,13 }, { 204,12,12 }, { 189,13,11 }, { 174,14,10 }, { 159,15,9 },
  { 250,10,15 }, { 235,11,14 }, { 220,12,13 }, { 205,13,12 }, { 190,14,11 }, { 175,15,10 }, { 251,11,15 }, { 236,12,14 }, { 221,13,13 }, { 206,14,12 }, { 191,15,11 }, { 252,12,15 }, { 237,13,14 }, { 222,14,13 }, { 207,15,12 }, { 253,13,15 }, { 238,14,14 }, { 223,15,13 }, { 254,14,15 }, { 239,15,14 },
  { 255,15,15 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 32,0,2 }, { 17,1,1 }, { 2,2,0 }, { 48,0,3 }, { 33,1,2 }, { 18,2,1 }, { 3,3,0 }, { 64,0,4 }, { 49,1,3 }, { 34,2,2 }, { 19,3,1 }, { 4,4,0 }, { 80,0,5 }, { 65,1,4 }, { 50,2,3 }, { 35,3,2 },
  { 20,4,1 }, { 5,5,0 }, { 96,0,6 }, { 81,1,5 }, { 66,2,4 }, { 51,3,3 }, { 36,4,2 }, { 21,5,1 }, { 6,6,0 }, { 112,0,7 }, { 97,1,6 }, { 82,2,5 }, { 67,3,4 }, { 52,4,3 }, { 37,5,2 }, { 22,6,1 }, { 7,7,0 }, { 128,0,8 }, { 113,1,7 }, { 98,2,6 },
  { 83,3,5 }, { 68,4,4 }, { 53,5,3 }, { 38,6,2 }, { 23,7,1 }, { 8,8,0 }, { 144,0,9 }, { 129,1,8 }, { 114,2,7 }, { 99,3,6 }, { 84,4,5 }, { 69,5,4 }, { 54,6,3 }, { 39,7,2 }, { 24,8,1 }, { 9,9,0 }, { 160,0,10 }, { 145,1,9 }, { 130,2,8 }, { 115,3,7 },
  { 100,4,6 }, { 85,5,5 }, { 70,6,4 }, { 55,7,3 }, { 40,8,2 }, { 25,9,1 }, { 10,10,0 }, { 176,0,11 }, { 161,1,10 }, { 146,2,9 }, { 131,3,8 }, { 116,4,7 }, { 101,5,6 }, { 86,6,5 }, { 71,7,4 }, { 56,8,3 }, { 41,9,2 }, { 26,10,1 }, { 11,11,0 }, { 192,0,12 },
  { 177,1,11 }, { 162,2,10 }, { 147,3,9 }, { 132,4,8 }, { 117,5,7 }, { 102,6,6 }, { 87,7,5 }, { 72,8,4 }, { 57,9,3 }, { 42,10,2 }, { 27,11,1 }, { 12,12,0 }, { 208,0,13 }, { 193,1,12 }, { 178,2,11 }, { 163,3,10 }, { 148,4,9 }, { 133,5,8 }, { 118,6,7 }, { 103,7,6 },
  { 88,8,5 }, { 73,9,4 }, { 58,10,3 }, { 43,11,2 }, { 28,12,1 }, { 13,13,0 }, { 224,0,14 }, { 209,1,13 }, { 194,2,12 }, { 179,3,11 }, { 164,4,10 }, { 149,5,9 }, { 134,6,8 }, { 119,7,7 }, { 104,8,6 }, { 89,9,5 }, { 74,10,4 }, { 59,11,3 }, { 44,12,2 }, { 29,13,1 },
  { 14,14,0 }, { 240,0,15 }, { 225,1,14 }, { 210,2,13 }, { 195,3,12 }, { 180,4,11 }, { 165,5,10 }, { 150,6,9 }, { 135,7,8 }, { 120,8,7 }, { 105,9,6 }, { 90,10,5 }, { 75,11,4 }, { 60,12,3 }, { 45,13,2 }, { 30,14,1 }, { 15,15,0 }, { 256,0,16 }, { 241,1,15 }, { 226,2,14 },
  { 211,3,13 }, { 196,4,12 }, { 181,5,11 }, { 166,6,10 }, { 151,7,9 }, { 136,8,8 }, { 121,9,7 }, { 106,10,6 }, { 91,11,5 }, { 76,12,4 }, { 61,13,3 }, { 46,14,2 }, { 31,15,1 }, { 272,0,17 }, { 257,1,16 }, { 242,2,15 }, { 227,3,14 }, { 212,4,13 }, { 197,5,12 }, { 182,6,11 },
  { 167,7,10 }, { 152,8,9 }, { 137,9,8 }, { 122,10,7 }, { 107,11,6 }, { 92,12,5 }, { 77,13,4 }, { 62,14,3 }, { 47,15,2 }, { 288,0,18 }, { 273,1,17 }, { 258,2,16 }, { 243,3,15 }, { 228,4,14 }, { 213,5,13 }, { 198,6,12 }, { 183,7,11 }, { 168,8,10 }, { 153,9,9 }, { 138,10,8 },
  { 123,11,7 }, { 108,12,6 }, { 93,13,5 }, { 78,14,4 }, { 63,15,3 }, { 304,0,19 }, { 289,1,18 }, { 274,2,17 }, { 259,3,16 }, { 244,4,15 }, { 229,5,14 }, { 214,6,13 }, { 199,7,12 }, { 184,8,11 }, { 169,9,10 }, { 154,10,9 }, { 139,11,8 }, { 124,12,7 }, { 109,13,6 }, { 94,14,5 },
  { 79,15,4 }, { 320,0,20 }, { 305,1,19 }, { 290,2,18 }, { 275,3,17 }, { 260,4,16 }, { 245,5,15 }, { 230,6,14 }, { 215,7,13 }, { 200,8,12 }, { 185,9,11 }, { 170,10,10 }, { 155,11,9 }, { 140,12,8 }, { 125,13,7 }, { 110,14,6 }, { 95,15,5 }, { 336,0,21 }, { 321,1,20 }, { 306,2,19 },
  { 291,3,18 }, { 276,4,17 }, { 261,5,16 }, { 246,6,15 }, { 231,7,14 }, { 216,8,13 }, { 201,9,12 }, { 186,10,11 }, { 171,11,10 }, { 156,12,9 }, { 141,13,8 }, { 126,14,7 }, { 111,15,6 }, { 352,0,22 }, { 337,1,21 }, { 322,2,20 }, { 307,3,19 }, { 292,4,18 }, { 277,5,17 }, { 262,6,16 },
  { 247,7,15 }, { 232,8,14 }, { 217,9,13 }, { 202,10,12 }, { 187,11,11 }, { 172,12,10 }, { 157,13,9 }, { 142,14,8 }, { 127,15,7 }, { 368,0,23 }, { 353,1,22 }, { 338,2,21 }, { 323,3,20 }, { 308,4,19 }, { 293,5,18 }, { 278,6,17 }, { 263,7,16 }, { 248,8,15 }, { 233,9,14 }, { 218,10,13 },
  { 203,11,12 }, { 188,12,11 }, { 173,13,10 }, { 158,14,9 }, { 143,15,8 }, { 384,0,24 }, { 369,1,23 }, { 354,2,22 }, { 339,3,21 }, { 324,4,20 }, { 309,5,19 }, { 294,6,18 }, { 279,7,17 }, { 264,8,16 }, { 249,9,15 }, { 234,10,14 }, { 219,11,13 }, { 204,12,12 }, { 189,13,11 }, { 174,14,10 },
  { 159,15,9 }, { 400,0,25 }, { 385,1,24 }, { 370,2,23 }, { 355,3,22 }, { 340,4,21 }, { 325,5,20 }, { 310,6,19 }, { 295,7,18 }, { 280,8,17 }, { 265,9,16 }, { 250,10,15 }, { 235,11,14 }, { 220,12,13 }, { 205,13,12 }, { 190,14,11 }, { 175,15,10 }, { 416,0,26 }, { 401,1,25 }, { 386,2,24 },
  { 371,3,23 }, { 356,4,22 }, { 341,5,21 }, { 326,6,20 }, { 311,7,19 }, { 296,8,18 }, { 281,9,17 }, { 266,10,16 }, { 251,11,15 }, { 236,12,14 }, { 221,13,13 }, { 206,14,12 }, { 191,15,11 }, { 432,0,27 }, { 417,1,26 }, { 402,2,25 }, { 387,3,24 }, { 372,4,23 }, { 357,5,22 }, { 342,6,21 },
  { 327,7,20 }, { 312,8,19 }, { 297,9,18 }, { 282,10,17 }, { 267,11,16 }, { 252,12,15 }, { 237,13,14 }, { 222,14,13 }, { 207,15,12 }, { 448,0,28 }, { 433,1,27 }, { 418,2,26 }, { 403,3,25 }, { 388,4,24 }, { 373,5,23 }, { 358,6,22 }, { 343,7,21 }, { 328,8,20 }, { 313,9,19 }, { 298,10,18 },
  { 283,11,17 }, { 268,12,16 }, { 253,13,15 }, { 238,14,14 }, { 223,15,13 }, { 464,0,29 }, { 449,1,28 }, { 434,2,27 }, { 419,3,26 }, { 404,4,25 }, { 389,5,24 }, { 374,6,23 }, { 359,7,22 }, { 344,8,21 }, { 329,9,20 }, { 314,10,19 }, { 299,11,18 }, { 284,12,17 }, { 269,13,16 }, { 254,14,15 },
  { 239,15,14 }, { 480,0,30 }, { 465,1,29 }, { 450,2,28 }, { 435,3,27 }, { 420,4,26 }, { 405,5,25 }, { 390,6,24 }, { 375,7,23 }, { 360,8,22 }, { 345,9,21 }, { 330,10,20 }, { 315,11,19 }, { 300,12,18 }, { 285,13,17 }, { 270,14,16 }, { 255,15,15 }, { 496,0,31 }, { 481,1,30 }, { 466,2,29 },
  { 451,3,28 }, { 436,4,27 }, { 421,5,26 }, { 406,6,25 }, { 391,7,24 }, { 376,8,23 }, { 361,9,22 }, { 346,10,21 }, { 331,11,20 }, { 316,12,19 }, { 301,13,18 }, { 286,14,17 }, { 271,15,16 }, { 497,1,31 }, { 482,2,30 }, { 467,3,29 }, { 452,4,28 }, { 437,5,27 }, { 422,6,26 }, { 407,7,25 },
  { 392,8,24 }, { 377,9,23 }, { 362,10,22 }, { 347,11,21 }, { 332,12,20 }, { 317,13,19 }, { 302,14,18 }, { 287,15,17 }, { 498,2,31 }, { 483,3,30 }, { 468,4,29 }, { 453,5,28 }, { 438,6,27 }, { 423,7,26 }, { 408,8,25 }, { 393,9,24 }, { 378,10,23 }, { 363,11,22 }, { 348,12,21 }, { 333,13,20 },
  { 318,14,19 }, { 303,15,18 }, { 499,3,31 }, { 484,4,30 }, { 469,5,29 }, { 454,6,28 }, { 439,7,27 }, { 424,8,26 }, { 409,9,25 }, { 394,10,24 }, { 379,11,23 }, { 364,12,22 }, { 349,13,21 }, { 334,14,20 }, { 319,15,19 }, { 500,4,31 }, { 485,5,30 }, { 470,6,29 }, { 455,7,28 }, { 440,8,27 },
  { 425,9,26 }, { 410,10,25 }, { 395,11,24 }, { 380,12,23 }, { 365,13,22 }, { 350,14,21 }, { 335,15,20 }, { 501,5,31 }, { 486,6,30 }, { 471,7,29 }, { 456,8,28 }, { 441,9,27 }, { 426,10,26 }, { 411,11,25 }, { 396,12,24 }, { 381,13,23 }, { 366,14,22 }, { 351,15,21 }, { 502,6,31 }, { 487,7,30 },
  { 472,8,29 }, { 457,9,28 }, { 442,10,27 }, { 427,11,26 }, { 412,12,25 }, { 397,13,24 }, { 382,14,23 }, { 367,15,22 }, { 503,7,31 }, { 488,8,30 }, { 473,9,29 }, { 458,10,28 }, { 443,11,27 }, { 428,12,26 }, { 413,13,25 }, { 398,14,24 }, { 383,15,23 }, { 504,8,31 }, { 489,9,30 }, { 474,10,29 },
  { 459,11,28 }, { 444,12,27 }, { 429,13,26 }, { 414,14,25 }, { 399,15,24 }, { 505,9,31 }, { 490,10,30 }, { 475,11,29 }, { 460,12,28 }, { 445,13,27 }, { 430,14,26 }, { 415,15,25 }, { 506,10,31 }, { 491,11,30 }, { 476,12,29 }, { 461,13,28 }, { 446,14,27 }, { 431,15,26 }, { 507,11,31 }, { 492,12,30 },
  { 477,13,29 }, { 462,14,28 }, { 447,15,27 }, { 508,12,31 }, { 493,13,30 }, { 478,14,29 }, { 463,15,28 }, { 509,13,31 }, { 494,14,30 }, { 479,15,29 }, { 510,14,31 }, { 495,15,30 }, { 511,15,31 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 32,0,2 }, { 17,1,1 }, { 2,2,0 }, { 48,0,3 },
  { 33,1,2 }, { 18,2,1 }, { 3,3,0 }, { 64,0,4 }, { 49,1,3 }, { 34,2,2 }, { 19,3,1 }, { 4,4,0 }, { 80,0,5 }, { 65,1,4 }, { 50,2,3 }, { 35,3,2 }, { 20,4,1 }, { 5,5,0 }, { 96,0,6 }, { 81,1,5 }, { 66,2,4 }, { 51,3,3 }, { 36,4,2 }, { 21,5,1 },
  { 6,6,0 }, { 112,0,7 }, { 97,1,6 }, { 82,2,5 }, { 67,3,4 }, { 52,4,3 }, { 37,5,2 }, { 22,6,1 }, { 7,7,0 }, { 128,0,8 }, { 113,1,7 }, { 98,2,6 }, { 83,3,5 }, { 68,4,4 }, { 53,5,3 }, { 38,6,2 }, { 23,7,1 }, { 8,8,0 }, { 144,0,9 }, { 129,1,8 },
  { 114,2,7 }, { 99,3,6 }, { 84,4,5 }, { 69,5,4 }, { 54,6,3 }, { 39,7,2 }, { 24,8,1 }, { 9,9,0 }, { 160,0,10 }, { 145,1,9 }, { 130,2,8 }, { 115,3,7 }, { 100,4,6 }, { 85,5,5 }, { 70,6,4 }, { 55,7,3 }, { 40,8,2 }, { 25,9,1 }, { 10,10,0 }, { 176,0,11 },
  { 161,1,10 }, { 146,2,9 }, { 131,3,8 }, { 116,4,7 }, { 101,5,6 }, { 86,6,5 }, { 71,7,4 }, { 56,8,3 }, { 41,9,2 }, { 26,10,1 }, { 11,11,0 }, { 192,0,12 }, { 177,1,11 }, { 162,2,10 }, { 147,3,9 }, { 132,4,8 }, { 117,5,7 }, { 102,6,6 }, { 87,7,5 }, { 72,8,4 },
  { 57,9,3 }, { 42,10,2 }, { 27,11,1 }, { 12,12,0 }, { 208,0,13 }, { 193,1,12 }, { 178,2,11 }, { 163,3,10 }, { 148,4,9 }, { 133,5,8 }, { 118,6,7 }, { 103,7,6 }, { 88,8,5 }, { 73,9,4 }, { 58,10,3 }, { 43,11,2 }, { 28,12,1 }, { 13,13,0 }, { 224,0,14 }, { 209,1,13 },
  { 194,2,12 }, { 179,3,11 }, { 164,4,10 }, { 149,5,9 }, { 134,6,8 }, { 119,7,7 }, { 104,8,6 }, { 89,9,5 }, { 74,10,4 }, { 59,11,3 }, { 44,12,2 }, { 29,13,1 }, { 14,14,0 }, { 240,0,15 }, { 225,1,14 }, { 210,2,13 }, { 195,3,12 }, { 180,4,11 }, { 165,5,10 }, { 150,6,9 },
  { 135,7,8 }, { 120,8,7 }, { 105,9,6 }, { 90,10,5 }, { 75,11,4 }, { 60,12,3 }, { 45,13,2 }, { 30,14,1 }, { 15,15,0 }, { 256,0,16 }, { 241,1,15 }, { 226,2,14 }, { 211,3,13 }, { 196,4,12 }, { 181,5,11 }, { 166,6,10 }, { 151,7,9 }, { 136,8,8 }, { 121,9,7 }, { 106,10,6 },
  { 91,11,5 }, { 76,12,4 }, { 61,13,3 }, { 46,14,2 }, { 31,15,1 }, { 272,0,17 }, { 257,1,16 }, { 242,2,15 }, { 227,3,14 }, { 212,4,13 }, { 197,5,12 }, { 182,6,11 }, { 167,7,10 }, { 152,8,9 }, { 137,9,8 }, { 122,10,7 }, { 107,11,6 }, { 92,12,5 }, { 77,13,4 }, { 62,14,3 },
  { 47,15,2 }, { 288,0,18 }, { 273,1,17 }, { 258,2,16 }, { 243,3,15 }, { 228,4,14 }, { 213,5,13 }, { 198,6,12 }, { 183,7,11 }, { 168,8,10 }, { 153,9,9 }, { 138,10,8 }, { 123,11,7 }, { 108,12,6 }, { 93,13,5 }, { 78,14,4 }, { 63,15,3 }, { 304,0,19 }, { 289,1,18 }, { 274,2,17 },
  { 259,3,16 }, { 244,4,15 }, { 229,5,14 }, { 214,6,13 }, { 199,7,12 }, { 184,8,11 }, { 169,9,10 }, { 154,10,9 }, { 139,11,8 }, { 124,12,7 }, { 109,13,6 }, { 94,14,5 }, { 79,15,4 }, { 320,0,20 }, { 305,1,19 }, { 290,2,18 }, { 275,3,17 }, { 260,4,16 }, { 245,5,15 }, { 230,6,14 },
  { 215,7,13 }, { 200,8,12 }, { 185,9,11 }, { 170,10,10 }, { 155,11,9 }, { 140,12,8 }, { 125,13,7 }, { 110,14,6 }, { 95,15,5 }, { 336,0,21 }, { 321,1,20 }, { 306,2,19 }, { 291,3,18 }, { 276,4,17 }, { 261,5,16 }, { 246,6,15 }, { 231,7,14 }, { 216,8,13 }, { 201,9,12 }, { 186,10,11 },
  { 171,11,10 }, { 156,12,9 }, { 141,13,8 }, { 126,14,7 }, { 111,15,6 }, { 352,0,22 }, { 337,1,21 }, { 322,2,20 }, { 307,3,19 }, { 292,4,18 }, { 277,5,17 }, { 262,6,16 }, { 247,7,15 }, { 232,8,14 }, { 217,9,13 }, { 202,10,12 }, { 187,11,11 }, { 172,12,10 }, { 157,13,9 }, { 142,14,8 },
  { 127,15,7 }, { 368,0,23 }, { 353,1,22 }, { 338,2,21 }, { 323,3,20 }, { 308,4,19 }, { 293,5,18 }, { 278,6,17 }, { 263,7,16 }, { 248,8,15 }, { 233,9,14 }, { 218,10,13 }, { 203,11,12 }, { 188,12,11 }, { 173,13,10 }, { 158,14,9 }, { 143,15,8 }, { 384,0,24 }, { 369,1,23 }, { 354,2,22 },
  { 339,3,21 }, { 324,4,20 }, { 309,5,19 }, { 294,6,18 }, { 279,7,17 }, { 264,8,16 }, { 249,9,15 }, { 234,10,14 }, { 219,11,13 }, { 204,12,12 }, { 189,13,11 }, { 174,14,10 }, { 159,15,9 }, { 400,0,25 }, { 385,1,24 }, { 370,2,23 }, { 355,3,22 }, { 340,4,21 }, { 325,5,20 }, { 310,6,19 },
  { 295,7,18 }, { 280,8,17 }, { 265,9,16 }, { 250,10,15 }, { 235,11,14 }, { 220,12,13 }, { 205,13,12 }, { 190,14,11 }, { 175,15,10 }, { 416,0,26 }, { 401,1,25 }, { 386,2,24 }, { 371,3,23 }, { 356,4,22 }, { 341,5,21 }, { 326,6,20 }, { 311,7,19 }, { 296,8,18 }, { 281,9,17 }, { 266,10,16 },
  { 251,11,15 }, { 236,12,14 }, { 221,13,13 }, { 206,14,12 }, { 191,15,11 }, { 432,0,27 }, { 417,1,26 }, { 402,2,25 }, { 387,3,24 }, { 372,4,23 }, { 357,5,22 }, { 342,6,21 }, { 327,7,20 }, { 312,8,19 }, { 297,9,18 }, { 282,10,17 }, { 267,11,16 }, { 252,12,15 }, { 237,13,14 }, { 222,14,13 },
  { 207,15,12 }, { 448,0,28 }, { 433,1,27 }, { 418,2,26 }, { 403,3,25 }, { 388,4,24 }, { 373,5,23 }, { 358,6,22 }, { 343,7,21 }, { 328,8,20 }, { 313,9,19 }, { 298,10,18 }, { 283,11,17 }, { 268,12,16 }, { 253,13,15 }, { 238,14,14 }, { 223,15,13 }, { 464,0,29 }, { 449,1,28 }, { 434,2,27 },
  { 419,3,26 }, { 404,4,25 }, { 389,5,24 }, { 374,6,23 }, { 359,7,22 }, { 344,8,21 }, { 329,9,20 }, { 314,10,19 }, { 299,11,18 }, { 284,12,17 }, { 269,13,16 }, { 254,14,15 }, { 239,15,14 }, { 480,0,30 }, { 465,1,29 }, { 450,2,28 }, { 435,3,27 }, { 420,4,26 }, { 405,5,25 }, { 390,6,24 },
  { 375,7,23 }, { 360,8,22 }, { 345,9,21 }, { 330,10,20 }, { 315,11,19 }, { 300,12,18 }, { 285,13,17 }, { 270,14,16 }, { 255,15,15 }, { 496,0,31 }, { 481,1,30 }, { 466,2,29 }, { 451,3,28 }, { 436,4,27 }, { 421,5,26 }, { 406,6,25 }, { 391,7,24 }, { 376,8,23 }, { 361,9,22 }, { 346,10,21 },
  { 331,11,20 }, { 316,12,19 }, { 301,13,18 }, { 286,14,17 }, { 271,15,16 }, { 512,0,32 }, { 497,1,31 }, { 482,2,30 }, { 467,3,29 }, { 452,4,28 }, { 437,5,27 }, { 422,6,26 }, { 407,7,25 }, { 392,8,24 }, { 377,9,23 }, { 362,10,22 }, { 347,11,21 }, { 332,12,20 }, { 317,13,19 }, { 302,14,18 },
  { 287,15,17 }, { 528,0,33 }, { 513,1,32 }, { 498,2,31 }, { 483,3,30 }, { 468,4,29 }, { 453,5,28 }, { 438,6,27 }, { 423,7,26 }, { 408,8,25 }, { 393,9,24 }, { 378,10,23 }, { 363,11,22 }, { 348,12,21 }, { 333,13,20 }, { 318,14,19 }, { 303,15,18 }, { 544,0,34 }, { 529,1,33 }, { 514,2,32 },
  { 499,3,31 }, { 484,4,30 }, { 469,5,29 }, { 454,6,28 }, { 439,7,27 }, { 424,8,26 }, { 409,9,25 }, { 394,10,24 }, { 379,11,23 }, { 364,12,22 }, { 349,13,21 }, { 334,14,20 }, { 319,15,19 }, { 560,0,35 }, { 545,1,34 }, { 530,2,33 }, { 515,3,32 }, { 500,4,31 }, { 485,5,30 }, { 470,6,29 },
  { 455,7,28 }, { 440,8,27 }, { 425,9,26 }, { 410,10,25 }, { 395,11,24 }, { 380,12,23 }, { 365,13,22 }, { 350,14,21 }, { 335,15,20 }, { 576,0,36 }, { 561,1,35 }, { 546,2,34 }, { 531,3,33 }, { 516,4,32 }, { 501,5,31 }, { 486,6,30 }, { 471,7,29 }, { 456,8,28 }, { 441,9,27 }, { 426,10,26 },
  { 411,11,25 }, { 396,12,24 }, { 381,13,23 }, { 366,14,22 }, { 351,15,21 }, { 592,0,37 }, { 577,1,36 }, { 562,2,35 }, { 547,3,34 }, { 532,4,33 }, { 517,5,32 }, { 502,6,31 }, { 487,7,30 }, { 472,8,29 }, { 457,9,28 }, { 442,10,27 }, { 427,11,26 }, { 412,12,25 }, { 397,13,24 }, { 382,14,23 },
  { 367,15,22 }, { 608,0,38 }, { 593,1,37 }, { 578,2,36 }, { 563,3,35 }, { 548,4,34 }, { 533,5,33 }, { 518,6,32 }, { 503,7,31 }, { 488,8,30 }, { 473,9,29 }, { 458,10,28 }, { 443,11,27 }, { 428,12,26 }, { 413,13,25 }, { 398,14,24 }, { 383,15,23 }, { 624,0,39 }, { 609,1,38 }, { 594,2,37 },
  { 579,3,36 }, { 564,4,35 }, { 549,5,34 }, { 534,6,33 }, { 519,7,32 }, { 504,8,31 }, { 489,9,30 }, { 474,10,29 }, { 459,11,28 }, { 444,12,27 }, { 429,13,26 }, { 414,14,25 }, { 399,15,24 }, { 640,0,40 }, { 625,1,39 }, { 610,2,38 }, { 595,3,37 }, { 580,4,36 }, { 565,5,35 }, { 550,6,34 },
  { 535,7,33 }, { 520,8,32 }, { 505,9,31 }, { 490,10,30 }, { 475,11,29 }, { 460,12,28 }, { 445,13,27 }, { 430,14,26 }, { 415,15,25 }, { 656,0,41 }, { 641,1,40 }, { 626,2,39 }, { 611,3,38 }, { 596,4,37 }, { 581,5,36 }, { 566,6,35 }, { 551,7,34 }, { 536,8,33 }, { 521,9,32 }, { 506,10,31 },
  { 491,11,30 }, { 476,12,29 }, { 461,13,28 }, { 446,14,27 }, { 431,15,26 }, { 672,0,42 }, { 657,1,41 }, { 642,2,40 }, { 627,3,39 }, { 612,4,38 }, { 597,5,37 }, { 582,6,36 }, { 567,7,35 }, { 552,8,34 }, { 537,9,33 }, { 522,10,32 }, { 507,11,31 }, { 492,12,30 }, { 477,13,29 }, { 462,14,28 },
  { 447,15,27 }, { 688,0,43 }, { 673,1,42 }, { 658,2,41 }, { 643,3,40 }, { 628,4,39 }, { 613,5,38 }, { 598,6,37 }, { 583,7,36 }, { 568,8,35 }, { 553,9,34 }, { 538,10,33 }, { 523,11,32 }, { 508,12,31 }, { 493,13,30 }, { 478,14,29 }, { 463,15,28 }, { 704,0,44 }, { 689,1,43 }, { 674,2,42 },
  { 659,3,41 }, { 644,4,40 }, { 629,5,39 }, { 614,6,38 }, { 599,7,37 }, { 584,8,36 }, { 569,9,35 }, { 554,10,34 }, { 539,11,33 }, { 524,12,32 }, { 509,13,31 }, { 494,14,30 }, { 479,15,29 }, { 720,0,45 }, { 705,1,44 }, { 690,2,43 }, { 675,3,42 }, { 660,4,41 }, { 645,5,40 }, { 630,6,39 },
  { 615,7,38 }, { 600,8,37 }, { 585,9,36 }, { 570,10,35 }, { 555,11,34 }, { 540,12,33 }, { 525,13,32 }, { 510,14,31 }, { 495,15,30 }, { 736,0,46 }, { 721,1,45 }, { 706,2,44 }, { 691,3,43 }, { 676,4,42 }, { 661,5,41 }, { 646,6,40 }, { 631,7,39 }, { 616,8,38 }, { 601,9,37 }, { 586,10,36 },
  { 571,11,35 }, { 556,12,34 }, { 541,13,33 }, { 526,14,32 }, { 511,15,31 }, { 752,0,47 }, { 737,1,46 }, { 722,2,45 }, { 707,3,44 }, { 692,4,43 }, { 677,5,42 }, { 662,6,41 }, { 647,7,40 }, { 632,8,39 }, { 617,9,38 }, { 602,10,37 }, { 587,11,36 }, { 572,12,35 }, { 557,13,34 }, { 542,14,33 },
  { 527,15,32 }, { 768,0,48 }, { 753,1,47 }, { 738,2,46 }, { 723,3,45 }, { 708,4,44 }, { 693,5,43 }, { 678,6,42 }, { 663,7,41 }, { 648,8,40 }, { 633,9,39 }, { 618,10,38 }, { 603,11,37 }, { 588,12,36 }, { 573,13,35 }, { 558,14,34 }, { 543,15,33 }, { 784,0,49 }, { 769,1,48 }, { 754,2,47 },
  { 739,3,46 }, { 724,4,45 }, { 709,5,44 }, { 694,6,43 }, { 679,7,42 }, { 664,8,41 }, { 649,9,40 }, { 634,10,39 }, { 619,11,38 }, { 604,12,37 }, { 589,13,36 }, { 574,14,35 }, { 559,15,34 }, { 800,0,50 }, { 785,1,49 }, { 770,2,48 }, { 755,3,47 }, { 740,4,46 }, { 725,5,45 }, { 710,6,44 },
  { 695,7,43 }, { 680,8,42 }, { 665,9,41 }, { 650,10,40 }, { 635,11,39 }, { 620,12,38 }, { 605,13,37 }, { 590,14,36 }, { 575,15,35 }, { 816,0,51 }, { 801,1,50 }, { 786,2,49 }, { 771,3,48 }, { 756,4,47 }, { 741,5,46 }, { 726,6,45 }, { 711,7,44 }, { 696,8,43 }, { 681,9,42 }, { 666,10,41 },
  { 651,11,40 }, { 636,12,39 }, { 621,13,38 }, { 606,14,37 }, { 591,15,36 }, { 832,0,52 }, { 817,1,51 }, { 802,2,50 }, { 787,3,49 }, { 772,4,48 }, { 757,5,47 }, { 742,6,46 }, { 727,7,45 }, { 712,8,44 }, { 697,9,43 }, { 682,10,42 }, { 667,11,41 }, { 652,12,40 }, { 637,13,39 }, { 622,14,38 },
  { 607,15,37 }, { 848,0,53 }, { 833,1,52 }, { 818,2,51 }, { 803,3,50 }, { 788,4,49 }, { 773,5,48 }, { 758,6,47 }, { 743,7,46 }, { 728,8,45 }, { 713,9,44 }, { 698,10,43 }, { 683,11,42 }, { 668,12,41 }, { 653,13,40 }, { 638,14,39 }, { 623,15,38 }, { 864,0,54 }, { 849,1,53 }, { 834,2,52 },
  { 819,3,51 }, { 804,4,50 }, { 789,5,49 }, { 774,6,48 }, { 759,7,47 }, { 744,8,46 }, { 729,9,45 }, { 714,10,44 }, { 699,11,43 }, { 684,12,42 }, { 669,13,41 }, { 654,14,40 }, { 639,15,39 }, { 880,0,55 }, { 865,1,54 }, { 850,2,53 }, { 835,3,52 }, { 820,4,51 }, { 805,5,50 }, { 790,6,49 },
  { 775,7,48 }, { 760,8,47 }, { 745,9,46 }, { 730,10,45 }, { 715,11,44 }, { 700,12,43 }, { 685,13,42 }, { 670,14,41 }, { 655,15,40 }, { 896,0,56 }, { 881,1,55 }, { 866,2,54 }, { 851,3,53 }, { 836,4,52 }, { 821,5,51 }, { 806,6,50 }, { 791,7,49 }, { 776,8,48 }, { 761,9,47 }, { 746,10,46 },
  { 731,11,45 }, { 716,12,44 }, { 701,13,43 }, { 686,14,42 }, { 671,15,41 }, { 912,0,57 }, { 897,1,56 }, { 882,2,55 }, { 867,3,54 }, { 852,4,53 }, { 837,5,52 }, { 822,6,51 }, { 807,7,50 }, { 792,8,49 }, { 777,9,48 }, { 762,10,47 }, { 747,11,46 }, { 732,12,45 }, { 717,13,44 }, { 702,14,43 },
  { 687,15,42 }, { 928,0,58 }, { 913,1,57 }, { 898,2,56 }, { 883,3,55 }, { 868,4,54 }, { 853,5,53 }, { 838,6,52 }, { 823,7,51 }, { 808,8,50 }, { 793,9,49 }, { 778,10,48 }, { 763,11,47 }, { 748,12,46 }, { 733,13,45 }, { 718,14,44 }, { 703,15,43 }, { 944,0,59 }, { 929,1,58 }, { 914,2,57 },
  { 899,3,56 }, { 884,4,55 }, { 869,5,54 }, { 854,6,53 }, { 839,7,52 }, { 824,8,51 }, { 809,9,50 }, { 794,10,49 }, { 779,11,48 }, { 764,12,47 }, { 749,13,46 }, { 734,14,45 }, { 719,15,44 }, { 960,0,60 }, { 945,1,59 }, { 930,2,58 }, { 915,3,57 }, { 900,4,56 }, { 885,5,55 }, { 870,6,54 },
  { 855,7,53 }, { 840,8,52 }, { 825,9,51 }, { 810,10,50 }, { 795,11,49 }, { 780,12,48 }, { 765,13,47 }, { 750,14,46 }, { 735,15,45 }, { 976,0,61 }, { 961,1,60 }, { 946,2,59 }, { 931,3,58 }, { 916,4,57 }, { 901,5,56 }, { 886,6,55 }, { 871,7,54 }, { 856,8,53 }, { 841,9,52 }, { 826,10,51 },
  { 811,11,50 }, { 796,12,49 }, { 781,13,48 }, { 766,14,47 }, { 751,15,46 }, { 992,0,62 }, { 977,1,61 }, { 962,2,60 }, { 947,3,59 }, { 932,4,58 }, { 917,5,57 }, { 902,6,56 }, { 887,7,55 }, { 872,8,54 }, { 857,9,53 }, { 842,10,52 }, { 827,11,51 }, { 812,12,50 }, { 797,13,49 }, { 782,14,48 },
  { 767,15,47 }, { 1008,0,63 }, { 993,1,62 }, { 978,2,61 }, { 963,3,60 }, { 948,4,59 }, { 933,5,58 }, { 918,6,57 }, { 903,7,56 }, { 888,8,55 }, { 873,9,54 }, { 858,10,53 }, { 843,11,52 }, { 828,12,51 }, { 813,13,50 }, { 798,14,49 }, { 783,15,48 }, { 1009,1,63 }, { 994,2,62 }, { 979,3,61 },
  { 964,4,60 }, { 949,5,59 }, { 934,6,58 }, { 919,7,57 }, { 904,8,56 }, { 889,9,55 }, { 874,10,54 }, { 859,11,53 }, { 844,12,52 }, { 829,13,51 }, { 814,14,50 }, { 799,15,49 }, { 1010,2,63 }, { 995,3,62 }, { 980,4,61 }, { 965,5,60 }, { 950,6,59 }, { 935,7,58 }, { 920,8,57 }, { 905,9,56 },
  { 890,10,55 }, { 875,11,54 }, { 860,12,53 }, { 845,13,52 }, { 830,14,51 }, { 815,15,50 }, { 1011,3,63 }, { 996,4,62 }, { 981,5,61 }, { 966,6,60 }, { 951,7,59 }, { 936,8,58 }, { 921,9,57 }, { 906,10,56 }, { 891,11,55 }, { 876,12,54 }, { 861,13,53 }, { 846,14,52 }, { 831,15,51 }, { 1012,4,63 },
  { 997,5,62 }, { 982,6,61 }, { 967,7,60 }, { 952,8,59 }, { 937,9,58 }, { 922,10,57 }, { 907,11,56 }, { 892,12,55 }, { 877,13,54 }, { 862,14,53 }, { 847,15,52 }, { 1013,5,63 }, { 998,6,62 }, { 983,7,61 }, { 968,8,60 }, { 953,9,59 }, { 938,10,58 }, { 923,11,57 }, { 908,12,56 }, { 893,13,55 },
  { 878,14,54 }, { 863,15,53 }, { 1014,6,63 }, { 999,7,62 }, { 984,8,61 }, { 969,9,60 }, { 954,10,59 }, { 939,11,58 }, { 924,12,57 }, { 909,13,56 }, { 894,14,55 }, { 879,15,54 }, { 1015,7,63 }, { 1000,8,62 }, { 985,9,61 }, { 970,10,60 }, { 955,11,59 }, { 940,12,58 }, { 925,13,57 }, { 910,14,56 },
  { 895,15,55 }, { 1016,8,63 }, { 1001,9,62 }, { 986,10,61 }, { 971,11,60 }, { 956,12,59 }, { 941,13,58 }, { 926,14,57 }, { 911,15,56 }, { 1017,9,63 }, { 1002,10,62 }, { 987,11,61 }, { 972,12,60 }, { 957,13,59 }, { 942,14,58 }, { 927,15,57 }, { 1018,10,63 }, { 1003,11,62 }, { 988,12,61 }, { 973,13,60 },
  { 958,14,59 }, { 943,15,58 }, { 1019,11,63 }, { 1004,12,62 }, { 989,13,61 }, { 974,14,60 }, { 959,15,59 }, { 1020,12,63 }, { 1005,13,62 }, { 990,14,61 }, { 975,15,60 }, { 1021,13,63 }, { 1006,14,62 }, { 991,15,61 }, { 1022,14,63 }, { 1007,15,62 }, { 1023,15,63 }, { 0,0,0 }, { 1,1,0 }, { 2,2,0 },
  { 3,3,0 }, { 4,4,0 }, { 5,5,0 }, { 6,6,0 }, { 7,7,0 }, { 8,8,0 }, { 9,9,0 }, { 10,10,0 }, { 11,11,0 }, { 12,12,0 }, { 13,13,0 }, { 14,14,0 }, { 15,15,0 }, { 16,16,0 }, { 17,17,0 }, { 18,18,0 }, { 19,19,0 }, { 20,20,0 }, { 21,21,0 }, { 22,22,0 },
  { 23,23,0 }, { 24,24,0 }, { 25,25,0 }, { 26,26,0 }, { 27,27,0 }, { 28,28,0 }, { 29,29,0 }, { 30,30,0 }, { 31,31,0 }, { 0,0,0 }, { 32,0,1 }, { 1,1,0 }, { 33,1,1 }, { 2,2,0 }, { 34,2,1 }, { 3,3,0 }, { 35,3,1 }, { 4,4,0 }, { 36,4,1 }, { 5,5,0 },
  { 37,5,1 }, { 6,6,0 }, { 38,6,1 }, { 7,7,0 }, { 39,7,1 }, { 8,8,0 }, { 40,8,1 }, { 9,9,0 }, { 41,9,1 }, { 10,10,0 }, { 42,10,1 }, { 11,11,0 }, { 43,11,1 }, { 12,12,0 }, { 44,12,1 }, { 13,13,0 }, { 45,13,1 }, { 14,14,0 }, { 46,14,1 }, { 15,15,0 },
  { 47,15,1 }, { 16,16,0 }, { 48,16,1 }, { 17,17,0 }, { 49,17,1 }, { 18,18,0 }, { 50,18,1 }, { 19,19,0 }, { 51,19,1 }, { 20,20,0 }, { 52,20,1 }, { 21,21,0 }, { 53,21,1 }, { 22,22,0 }, { 54,22,1 }, { 23,23,0 }, { 55,23,1 }, { 24,24,0 }, { 56,24,1 }, { 25,25,0 },
  { 57,25,1 }, { 26,26,0 }, { 58,26,1 }, { 27,27,0 }, { 59,27,1 }, { 28,28,0 }, { 60,28,1 }, { 29,29,0 }, { 61,29,1 }, { 30,30,0 }, { 62,30,1 }, { 31,31,0 }, { 63,31,1 }, { 0,0,0 }, { 32,0,1 }, { 1,1,0 }, { 64,0,2 }, { 33,1,1 }, { 2,2,0 }, { 96,0,3 },
  { 65,1,2 }, { 34,2,1 }, { 3,3,0 }, { 97,1,3 }, { 66,2,2 }, { 35,3,1 }, { 4,4,0 }, { 98,2,3 }, { 67,3,2 }, { 36,4,1 }, { 5,5,0 }, { 99,3,3 }, { 68,4,2 }, { 37,5,1 }, { 6,6,0 }, { 100,4,3 }, { 69,5,2 }, { 38,6,1 }, { 7,7,0 }, { 101,5,3 },
  { 70,6,2 }, { 39,7,1 }, { 8,8,0 }, { 102,6,3 }, { 71,7,2 }, { 40,8,1 }, { 9,9,0 }, { 103,7,3 }, { 72,8,2 }, { 41,9,1 }, { 10,10,0 }, { 104,8,3 }, { 73,9,2 }, { 42,10,1 }, { 11,11,0 }, { 105,9,3 }, { 74,10,2 }, { 43,11,1 }, { 12,12,0 }, { 106,10,3 },
  { 75,11,2 }, { 44,12,1 }, { 13,13,0 }, { 107,11,3 }, { 76,12,2 }, { 45,13,1 }, { 14,14,0 }, { 108,12,3 }, { 77,13,2 }, { 46,14,1 }, { 15,15,0 }, { 109,13,3 }, { 78,14,2 }, { 47,15,1 }, { 16,16,0 }, { 110,14,3 }, { 79,15,2 }, { 48,16,1 }, { 17,17,0 }, { 111,15,3 },
  { 80,16,2 }, { 49,17,1 }, { 18,18,0 }, { 112,16,3 }, { 81,17,2 }, { 50,18,1 }, { 19,19,0 }, { 113,17,3 }, { 82,18,2 }, { 51,19,1 }, { 20,20,0 }, { 114,18,3 }, { 83,19,2 }, { 52,20,1 }, { 21,21,0 }, { 115,19,3 }, { 84,20,2 }, { 53,21,1 }, { 22,22,0 }, { 116,20,3 },
  { 85,21,2 }, { 54,22,1 }, { 23,23,0 }, { 117,21,3 }, { 86,22,2 }, { 55,23,1 }, { 24,24,0 }, { 118,22,3 }, { 87,23,2 }, { 56,24,1 }, { 25,25,0 }, { 119,23,3 }, { 88,24,2 }, { 57,25,1 }, { 26,26,0 }, { 120,24,3 }, { 89,25,2 }, { 58,26,1 }, { 27,27,0 }, { 121,25,3 },
  { 90,26,2 }, { 59,27,1 }, { 28,28,0 }, { 122,26,3 }, { 91,27,2 }, { 60,28,1 }, { 29,29,0 }, { 123,27,3 }, { 92,28,2 }, { 61,29,1 }, { 30,30,0 }, { 124,28,3 }, { 93,29,2 }, { 62,30,1 }, { 31,31,0 }, { 125,29,3 }, { 94,30,2 }, { 63,31,1 }, { 126,30,3 }, { 95,31,2 },
  { 127,31,3 }, { 0,0,0 }, { 32,0,1 }, { 1,1,0 }, { 64,0,2 }, { 33,1,1 }, { 2,2,0 }, { 96,0,3 }, { 65,1,2 }, { 34,2,1 }, { 3,3,0 }, { 128,0,4 }, { 97,1,3 }, { 66,2,2 }, { 35,3,1 }, { 4,4,0 }, { 160,0,5 }, { 129,1,4 }, { 98,2,3 }, { 67,3,2 },
  { 36,4,1 }, { 5,5,0 }, { 192,0,6 }, { 161,1,5 }, { 130,2,4 }, { 99,3,3 }, { 68,4,2 }, { 37,5,1 }, { 6,6,0 }, { 224,0,7 }, { 193,1,6 }, { 162,2,5 }, { 131,3,4 }, { 100,4,3 }, { 69,5,2 }, { 38,6,1 }, { 7,7,0 }, { 225,1,7 }, { 194,2,6 }, { 163,3,5 },
  { 132,4,4 }, { 101,5,3 }, { 70,6,2 }, { 39,7,1 }, { 8,8,0 }, { 226,2,7 }, { 195,3,6 }, { 164,4,5 }, { 133,5,4 }, { 102,6,3 }, { 71,7,2 }, { 40,8,1 }, { 9,9,0 }, { 227,3,7 }, { 196,4,6 }, { 165,5,5 }, { 134,6,4 }, { 103,7,3 }, { 72,8,2 }, { 41,9,1 },
  { 10,10,0 }, { 228,4,7 }, { 197,5,6 }, { 166,6,5 }, { 135,7,4 }, { 104,8,3 }, { 73,9,2 }, { 42,10,1 }, { 11,11,0 }, { 229,5,7 }, { 198,6,6 }, { 167,7,5 }, { 136,8,4 }, { 105,9,3 }, { 74,10,2 }, { 43,11,1 }, { 12,12,0 }, { 230,6,7 }, { 199,7,6 }, { 168,8,5 },
  { 137,9,4 }, { 106,10,3 }, { 75,11,2 }, { 44,12,1 }, { 13,13,0 }, { 231,7,7 }, { 200,8,6 }, { 169,9,5 }, { 138,10,4 }, { 107,11,3 }, { 76,12,2 }, { 45,13,1 }, { 14,14,0 }, { 232,8,7 }, { 201,9,6 }, { 170,10,5 }, { 139,11,4 }, { 108,12,3 }, { 77,13,2 }, { 46,14,1 },
  { 15,15,0 }, { 233,9,7 }, { 202,10,6 }, { 171,11,5 }, { 140,12,4 }, { 109,13,3 }, { 78,14,2 }, { 47,15,1 }, { 16,16,0 }, { 234,10,7 }, { 203,11,6 }, { 172,12,5 }, { 141,13,4 }, { 110,14,3 }, { 79,15,2 }, { 48,16,1 }, { 17,17,0 }, { 235,11,7 }, { 204,12,6 }, { 173,13,5 },
  { 142,14,4 }, { 111,15,3 }, { 80,16,2 }, { 49,17,1 }, { 18,18,0 }, { 236,12,7 }, { 205,13,6 }, { 174,14,5 }, { 143,15,4 }, { 112,16,3 }, { 81,17,2 }, { 50,18,1 }, { 19,19,0 }, { 237,13,7 }, { 206,14,6 }, { 175,15,5 }, { 144,16,4 }, { 113,17,3 }, { 82,18,2 }, { 51,19,1 },
  { 20,20,0 }, { 238,14,7 }, { 207,15,6 }, { 176,16,5 }, { 145,17,4 }, { 114,18,3 }, { 83,19,2 }, { 52,20,1 }, { 21,21,0 }, { 239,15,7 }, { 208,16,6 }, { 177,17,5 }, { 146,18,4 }, { 115,19,3 }, { 84,20,2 }, { 53,21,1 }, { 22,22,0 }, { 240,16,7 }, { 209,17,6 }, { 178,18,5 },
  { 147,19,4 }, { 116,20,3 }, { 85,21,2 }, { 54,22,1 }, { 23,23,0 }, { 241,17,7 }, { 210,18,6 }, { 179,19,5 }, { 148,20,4 }, { 117,21,3 }, { 86,22,2 }, { 55,23,1 }, { 24,24,0 }, { 242,18,7 }, { 211,19,6 }, { 180,20,5 }, { 149,21,4 }, { 118,22,3 }, { 87,23,2 }, { 56,24,1 },
  { 25,25,0 }, { 243,19,7 }, { 212,20,6 }, { 181,21,5 }, { 150,22,4 }, { 119,23,3 }, { 88,24,2 }, { 57,25,1 }, { 26,26,0 }, { 244,20,7 }, { 213,21,6 }, { 182,22,5 }, { 151,23,4 }, { 120,24,3 }, { 89,25,2 }, { 58,26,1 }, { 27,27,0 }, { 245,21,7 }, { 214,22,6 }, { 183,23,5 },
  { 152,24,4 }, { 121,25,3 }, { 90,26,2 }, { 59,27,1 }, { 28,28,0 }, { 246,22,7 }, { 215,23,6 }, { 184,24,5 }, { 153,25,4 }, { 122,26,3 }, { 91,27,2 }, { 60,28,1 }, { 29,29,0 }, { 247,23,7 }, { 216,24,6 }, { 185,25,5 }, { 154,26,4 }, { 123,27,3 }, { 92,28,2 }, { 61,29,1 },
  { 30,30,0 }, { 248,24,7 }, { 217,25,6 }, { 186,26,5 }, { 155,27,4 }, { 124,28,3 }, { 93,29,2 }, { 62,30,1 }, { 31,31,0 }, { 249,25,7 }, { 218,26,6 }, { 187,27,5 }, { 156,28,4 }, { 125,29,3 }, { 94,30,2 }, { 63,31,1 }, { 250,26,7 }, { 219,27,6 }, { 188,28,5 }, { 157,29,4 },
  { 126,30,3 }, { 95,31,2 }, { 251,27,7 }, { 220,28,6 }, { 189,29,5 }, { 158,30,4 }, { 127,31,3 }, { 252,28,7 }, { 221,29,6 }, { 190,30,5 }, { 159,31,4 }, { 253,29,7 }, { 222,30,6 }, { 191,31,5 }, { 254,30,7 }, { 223,31,6 }, { 255,31,7 }, { 0,0,0 }, { 32,0,1 }, { 1,1,0 },
  { 64,0,2 }, { 33,1,1 }, { 2,2,0 }, { 96,0,3 }, { 65,1,2 }, { 34,2,1 }, { 3,3,0 }, { 128,0,4 }, { 97,1,3 }, { 66,2,2 }, { 35,3,1 }, { 4,4,0 }, { 160,0,5 }, { 129,1,4 }, { 98,2,3 }, { 67,3,2 }, { 36,4,1 }, { 5,5,0 }, { 192,0,6 }, { 161,1,5 },
  { 130,2,4 }, { 99,3,3 }, { 68,4,2 }, { 37,5,1 }, { 6,6,0 }, { 224,0,7 }, { 193,1,6 }, { 162,2,5 }, { 131,3,4 }, { 100,4,3 }, { 69,5,2 }, { 38,6,1 }, { 7,7,0 }, { 256,0,8 }, { 225,1,7 }, { 194,2,6 }, { 163,3,5 }, { 132,4,4 }, { 101,5,3 }, { 70,6,2 },
  { 39,7,1 }, { 8,8,0 }, { 288,0,9 }, { 257,1,8 }, { 226,2,7 }, { 195,3,6 }, { 164,4,5 }, { 133,5,4 }, { 102,6,3 }, { 71,7,2 }, { 40,8,1 }, { 9,9,0 }, { 320,0,10 }, { 289,1,9 }, { 258,2,8 }, { 227,3,7 }, { 196,4,6 }, { 165,5,5 }, { 134,6,4 }, { 103,7,3 },
  { 72,8,2 }, { 41,9,1 }, { 10,10,0 }, { 352,0,11 }, { 321,1,10 }, { 290,2,9 }, { 259,3,8 }, { 228,4,7 }, { 197,5,6 }, { 166,6,5 }, { 135,7,4 }, { 104,8,3 }, { 73,9,2 }, { 42,10,1 }, { 11,11,0 }, { 384,0,12 }, { 353,1,11 }, { 322,2,10 }, { 291,3,9 }, { 260,4,8 },
  { 229,5,7 }, { 198,6,6 }, { 167,7,5 }, { 136,8,4 }, { 105,9,3 }, { 74,10,2 }, { 43,11,1 }, { 12,12,0 }, { 416,0,13 }, { 385,1,12 }, { 354,2,11 }, { 323,3,10 }, { 292,4,9 }, { 261,5,8 }, { 230,6,7 }, { 199,7,6 }, { 168,8,5 }, { 137,9,4 }, { 106,10,3 }, { 75,11,2 },
  { 44,12,1 }, { 13,13,0 }, { 448,0,14 }, { 417,1,13 }, { 386,2,12 }, { 355,3,11 }, { 324,4,10 }, { 293,5,9 }, { 262,6,8 }, { 231,7,7 }, { 200,8,6 }, { 169,9,5 }, { 138,10,4 }, { 107,11,3 }, { 76,12,2 }, { 45,13,1 }, { 14,14,0 }, { 480,0,15 }, { 449,1,14 }, { 418,2,13 },
  { 387,3,12 }, { 356,4,11 }, { 325,5,10 }, { 294,6,9 }, { 263,7,8 }, { 232,8,7 }, { 201,9,6 }, { 170,10,5 }, { 139,11,4 }, { 108,12,3 }, { 77,13,2 }, { 46,14,1 }, { 15,15,0 }, { 481,1,15 }, { 450,2,14 }, { 419,3,13 }, { 388,4,12 }, { 357,5,11 }, { 326,6,10 }, { 295,7,9 },
  { 264,8,8 }, { 233,9,7 }, { 202,10,6 }, { 171,11,5 }, { 140,12,4 }, { 109,13,3 }, { 78,14,2 }, { 47,15,1 }, { 16,16,0 }, { 482,2,15 }, { 451,3,14 }, { 420,4,13 }, { 389,5,12 }, { 358,6,11 }, { 327,7,10 }, { 296,8,9 }, { 265,9,8 }, { 234,10,7 }, { 203,11,6 }, { 172,12,5 },
  { 141,13,4 }, { 110,14,3 }, { 79,15,2 }, { 48,16,1 }, { 17,17,0 }, { 483,3,15 }, { 452,4,14 }, { 421,5,13 }, { 390,6,12 }, { 359,7,11 }, { 328,8,10 }, { 297,9,9 }, { 266,10,8 }, { 235,11,7 }, { 204,12,6 }, { 173,13,5 }, { 142,14,4 }, { 111,15,3 }, { 80,16,2 }, { 49,17,1 },
  { 18,18,0 }, { 484,4,15 }, { 453,5,14 }, { 422,6,13 }, { 391,7,12 }, { 360,8,11 }, { 329,9,10 }, { 298,10,9 }, { 267,11,8 }, { 236,12,7 }, { 205,13,6 }, { 174,14,5 }, { 143,15,4 }, { 112,16,3 }, { 81,17,2 }, { 50,18,1 }, { 19,19,0 }, { 485,5,15 }, { 454,6,14 }, { 423,7,13 },
  { 392,8,12 }, { 361,9,11 }, { 330,10,10 }, { 299,11,9 }, { 268,12,8 }, { 237,13,7 }, { 206,14,6 }, { 175,15,5 }, { 144,16,4 }, { 113,17,3 }, { 82,18,2 }, { 51,19,1 }, { 20,20,0 }, { 486,6,15 }, { 455,7,14 }, { 424,8,13 }, { 393,9,12 }, { 362,10,11 }, { 331,11,10 }, { 300,12,9 },
  { 269,13,8 }, { 238,14,7 }, { 207,15,6 }, { 176,16,5 }, { 145,17,4 }, { 114,18,3 }, { 83,19,2 }, { 52,20,1 }, { 21,21,0 }, { 487,7,15 }, { 456,8,14 }, { 425,9,13 }, { 394,10,12 }, { 363,11,11 }, { 332,12,10 }, { 301,13,9 }, { 270,14,8 }, { 239,15,7 }, { 208,16,6 }, { 177,17,5 },
  { 146,18,4 }, { 115,19,3 }, { 84,20,2 }, { 53,21,1 }, { 22,22,0 }, { 488,8,15 }, { 457,9,14 }, { 426,10,13 }, { 395,11,12 }, { 364,12,11 }, { 333,13,10 }, { 302,14,9 }, { 271,15,8 }, { 240,16,7 }, { 209,17,6 }, { 178,18,5 }, { 147,19,4 }, { 116,20,3 }, { 85,21,2 }, { 54,22,1 },
  { 23,23,0 }, { 489,9,15 }, { 458,10,14 }, { 427,11,13 }, { 396,12,12 }, { 365,13,11 }, { 334,14,10 }, { 303,15,9 }, { 272,16,8 }, { 241,17,7 }, { 210,18,6 }, { 179,19,5 }, { 148,20,4 }, { 117,21,3 }, { 86,22,2 }, { 55,23,1 }, { 24,24,0 }, { 490,10,15 }, { 459,11,14 }, { 428,12,13 },
  { 397,13,12 }, { 366,14,11 }, { 335,15,10 }, { 304,16,9 }, { 273,17,8 }, { 242,18,7 }, { 211,19,6 }, { 180,20,5 }, { 149,21,4 }, { 118,22,3 }, { 87,23,2 }, { 56,24,1 }, { 25,25,0 }, { 491,11,15 }, { 460,12,14 }, { 429,13,13 }, { 398,14,12 }, { 367,15,11 }, { 336,16,10 }, { 305,17,9 },
  { 274,18,8 }, { 243,19,7 }, { 212,20,6 }, { 181,21,5 }, { 150,22,4 }, { 119,23,3 }, { 88,24,2 }, { 57,25,1 }, { 26,26,0 }, { 492,12,15 }, { 461,13,14 }, { 430,14,13 }, { 399,15,12 }, { 368,16,11 }, { 337,17,10 }, { 306,18,9 }, { 275,19,8 }, { 244,20,7 }, { 213,21,6 }, { 182,22,5 },
  { 151,23,4 }, { 120,24,3 }, { 89,25,2 }, { 58,26,1 }, { 27,27,0 }, { 493,13,15 }, { 462,14,14 }, { 431,15,13 }, { 400,16,12 }, { 369,17,11 }, { 338,18,10 }, { 307,19,9 }, { 276,20,8 }, { 245,21,7 }, { 214,22,6 }, { 183,23,5 }, { 152,24,4 }, { 121,25,3 }, { 90,26,2 }, { 59,27,1 },
  { 28,28,0 }, { 494,14,15 }, { 463,15,14 }, { 432,16,13 }, { 401,17,12 }, { 370,18,11 }, { 339,19,10 }, { 308,20,9 }, { 277,21,8 }, { 246,22,7 }, { 215,23,6 }, { 184,24,5 }, { 153,25,4 }, { 122,26,3 }, { 91,27,2 }, { 60,28,1 }, { 29,29,0 }, { 495,15,15 }, { 464,16,14 }, { 433,17,13 },
  { 402,18,12 }, { 371,19,11 }, { 340,20,10 }, { 309,21,9 }, { 278,22,8 }, { 247,23,7 }, { 216,24,6 }, { 185,25,5 }, { 154,26,4 }, { 123,27,3 }, { 92,28,2 }, { 61,29,1 }, { 30,30,0 }, { 496,16,15 }, { 465,17,14 }, { 434,18,13 }, { 403,19,12 }, { 372,20,11 }, { 341,21,10 }, { 310,22,9 },
  { 279,23,8 }, { 248,24,7 }, { 217,25,6 }, { 186,26,5 }, { 155,27,4 }, { 124,28,3 }, { 93,29,2 }, { 62,30,1 }, { 31,31,0 }, { 497,17,15 }, { 466,18,14 }, { 435,19,13 }, { 404,20,12 }, { 373,21,11 }, { 342,22,10 }, { 311,23,9 }, { 280,24,8 }, { 249,25,7 }, { 218,26,6 }, { 187,27,5 },
  { 156,28,4 }, { 125,29,3 }, { 94,30,2 }, { 63,31,1 }, { 498,18,15 }, { 467,19,14 }, { 436,20,13 }, { 405,21,12 }, { 374,22,11 }, { 343,23,10 }, { 312,24,9 }, { 281,25,8 }, { 250,26,7 }, { 219,27,6 }, { 188,28,5 }, { 157,29,4 }, { 126,30,3 }, { 95,31,2 }, { 499,19,15 }, { 468,20,14 },
  { 437,21,13 }, { 406,22,12 }, { 375,23,11 }, { 344,24,10 }, { 313,25,9 }, { 282,26,8 }, { 251,27,7 }, { 220,28,6 }, { 189,29,5 }, { 158,30,4 }, { 127,31,3 }, { 500,20,15 }, { 469,21,14 }, { 438,22,13 }, { 407,23,12 }, { 376,24,11 }, { 345,25,10 }, { 314,26,9 }, { 283,27,8 }, { 252,28,7 },
  { 221,29,6 }, { 190,30,5 }, { 159,31,4 }, { 501,21,15 }, { 470,22,14 }, { 439,23,13 }, { 408,24,12 }, { 377,25,11 }, { 346,26,10 }, { 315,27,9 }, { 284,28,8 }, { 253,29,7 }, { 222,30,6 }, { 191,31,5 }, { 502,22,15 }, { 471,23,14 }, { 440,24,13 }, { 409,25,12 }, { 378,26,11 }, { 347,27,10 },
  { 316,28,9 }, { 285,29,8 }, { 254,30,7 }, { 223,31,6 }, { 503,23,15 }, { 472,24,14 }, { 441,25,13 }, { 410,26,12 }, { 379,27,11 }, { 348,28,10 }, { 317,29,9 }, { 286,30,8 }, { 255,31,7 }, { 504,24,15 }, { 473,25,14 }, { 442,26,13 }, { 411,27,12 }, { 380,28,11 }, { 349,29,10 }, { 318,30,9 },
  { 287,31,8 }, { 505,25,15 }, { 474,26,14 }, { 443,27,13 }, { 412,28,12 }, { 381,29,11 }, { 350,30,10 }, { 319,31,9 }, { 506,26,15 }, { 475,27,14 }, { 444,28,13 }, { 413,29,12 }, { 382,30,11 }, { 351,31,10 }, { 507,27,15 }, { 476,28,14 }, { 445,29,13 }, { 414,30,12 }, { 383,31,11 }, { 508,28,15 },
  { 477,29,14 }, { 446,30,13 }, { 415,31,12 }, { 509,29,15 }, { 478,30,14 }, { 447,31,13 }, { 510,30,15 }, { 479,31,14 }, { 511,31,15 }, { 0,0,0 }, { 32,0,1 }, { 1,1,0 }, { 64,0,2 }, { 33,1,1 }, { 2,2,0 }, { 96,0,3 }, { 65,1,2 }, { 34,2,1 }, { 3,3,0 }, { 128,0,4 },
  { 97,1,3 }, { 66,2,2 }, { 35,3,1 }, { 4,4,0 }, { 160,0,5 }, { 129,1,4 }, { 98,2,3 }, { 67,3,2 }, { 36,4,1 }, { 5,5,0 }, { 192,0,6 }, { 161,1,5 }, { 130,2,4 }, { 99,3,3 }, { 68,4,2 }, { 37,5,1 }, { 6,6,0 }, { 224,0,7 }, { 193,1,6 }, { 162,2,5 },
  { 131,3,4 }, { 100,4,3 }, { 69,5,2 }, { 38,6,1 }, { 7,7,0 }, { 256,0,8 }, { 225,1,7 }, { 194,2,6 }, { 163,3,5 }, { 132,4,4 }, { 101,5,3 }, { 70,6,2 }, { 39,7,1 }, { 8,8,0 }, { 288,0,9 }, { 257,1,8 }, { 226,2,7 }, { 195,3,6 }, { 164,4,5 }, { 133,5,4 },
  { 102,6,3 }, { 71,7,2 }, { 40,8,1 }, { 9,9,0 }, { 320,0,10 }, { 289,1,9 }, { 258,2,8 }, { 227,3,7 }, { 196,4,6 }, { 165,5,5 }, { 134,6,4 }, { 103,7,3 }, { 72,8,2 }, { 41,9,1 }, { 10,10,0 }, { 352,0,11 }, { 321,1,10 }, { 290,2,9 }, { 259,3,8 }, { 228,4,7 },
  { 197,5,6 }, { 166,6,5 }, { 135,7,4 }, { 104,8,3 }, { 73,9,2 }, { 42,10,1 }, { 11,11,0 }, { 384,0,12 }, { 353,1,11 }, { 322,2,10 }, { 291,3,9 }, { 260,4,8 }, { 229,5,7 }, { 198,6,6 }, { 167,7,5 }, { 136,8,4 }, { 105,9,3 }, { 74,10,2 }, { 43,11,1 }, { 12,12,0 },
  { 416,0,13 }, { 385,1,12 }, { 354,2,11 }, { 323,3,10 }, { 292,4,9 }, { 261,5,8 }, { 230,6,7 }, { 199,7,6 }, { 168,8,5 }, { 137,9,4 }, { 106,10,3 }, { 75,11,2 }, { 44,12,1 }, { 13,13,0 }, { 448,0,14 }, { 417,1,13 }, { 386,2,12 }, { 355,3,11 }, { 324,4,10 }, { 293,5,9 },
  { 262,6,8 }, { 231,7,7 }, { 200,8,6 }, { 169,9,5 }, { 138,10,4 }, { 107,11,3 }, { 76,12,2 }, { 45,13,1 }, { 14,14,0 }, { 480,0,15 }, { 449,1,14 }, { 418,2,13 }, { 387,3,12 }, { 356,4,11 }, { 325,5,10 }, { 294,6,9 }, { 263,7,8 }, { 232,8,7 }, { 201,9,6 }, { 170,10,5 },
  { 139,11,4 }, { 108,12,3 }, { 77,13,2 }, { 46,14,1 }, { 15,15,0 }, { 512,0,16 }, { 481,1,15 }, { 450,2,14 }, { 419,3,13 }, { 388,4,12 }, { 357,5,11 }, { 326,6,10 }, { 295,7,9 }, { 264,8,8 }, { 233,9,7 }, { 202,10,6 }, { 171,11,5 }, { 140,12,4 }, { 109,13,3 }, { 78,14,2 },
  { 47,15,1 }, { 16,16,0 }, { 544,0,17 }, { 513,1,16 }, { 482,2,15 }, { 451,3,14 }, { 420,4,13 }, { 389,5,12 }, { 358,6,11 }, { 327,7,10 }, { 296,8,9 }, { 265,9,8 }, { 234,10,7 }, { 203,11,6 }, { 172,12,5 }, { 141,13,4 }, { 110,14,3 }, { 79,15,2 }, { 48,16,1 }, { 17,17,0 },
  { 576,0,18 }, { 545,1,17 }, { 514,2,16 }, { 483,3,15 }, { 452,4,14 }, { 421,5,13 }, { 390,6,12 }, { 359,7,11 }, { 328,8,10 }, { 297,9,9 }, { 266,10,8 }, { 235,11,7 }, { 204,12,6 }, { 173,13,5 }, { 142,14,4 }, { 111,15,3 }, { 80,16,2 }, { 49,17,1 }, { 18,18,0 }, { 608,0,19 },
  { 577,1,18 }, { 546,2,17 }, { 515,3,16 }, { 484,4,15 }, { 453,5,14 }, { 422,6,13 }, { 391,7,12 }, { 360,8,11 }, { 329,9,10 }, { 298,10,9 }, { 267,11,8 }, { 236,12,7 }, { 205,13,6 }, { 174,14,5 }, { 143,15,4 }, { 112,16,3 }, { 81,17,2 }, { 50,18,1 }, { 19,19,0 }, { 640,0,20 },
  { 609,1,19 }, { 578,2,18 }, { 547,3,17 }, { 516,4,16 }, { 485,5,15 }, { 454,6,14 }, { 423,7,13 }, { 392,8,12 }, { 361,9,11 }, { 330,10,10 }, { 299,11,9 }, { 268,12,8 }, { 237,13,7 }, { 206,14,6 }, { 175,15,5 }, { 144,16,4 }, { 113,17,3 }, { 82,18,2 }, { 51,19,1 }, { 20,20,0 },
  { 672,0,21 }, { 641,1,20 }, { 610,2,19 }, { 579,3,18 }, { 548,4,17 }, { 517,5,16 }, { 486,6,15 }, { 455,7,14 }, { 424,8,13 }, { 393,9,12 }, { 362,10,11 }, { 331,11,10 }, { 300,12,9 }, { 269,13,8 }, { 238,14,7 }, { 207,15,6 }, { 176,16,5 }, { 145,17,4 }, { 114,18,3 }, { 83,19,2 },
  { 52,20,1 }, { 21,21,0 }, { 704,0,22 }, { 673,1,21 }, { 642,2,20 }, { 611,3,19 }, { 580,4,18 }, { 549,5,17 }, { 518,6,16 }, { 487,7,15 }, { 456,8,14 }, { 425,9,13 }, { 394,10,12 }, { 363,11,11 }, { 332,12,10 }, { 301,13,9 }, { 270,14,8 }, { 239,15,7 }, { 208,16,6 }, { 177,17,5 },
  { 146,18,4 }, { 115,19,3 }, { 84,20,2 }, { 53,21,1 }, { 22,22,0 }, { 736,0,23 }, { 705,1,22 }, { 674,2,21 }, { 643,3,20 }, { 612,4,19 }, { 581,5,18 }, { 550,6,17 }, { 519,7,16 }, { 488,8,15 }, { 457,9,14 }, { 426,10,13 }, { 395,11,12 }, { 364,12,11 }, { 333,13,10 }, { 302,14,9 },
  { 271,15,8 }, { 240,16,7 }, { 209,17,6 }, { 178,18,5 }, { 147,19,4 }, { 116,20,3 }, { 85,21,2 }, { 54,22,1 }, { 23,23,0 }, { 768,0,24 }, { 737,1,23 }, { 706,2,22 }, { 675,3,21 }, { 644,4,20 }, { 613,5,19 }, { 582,6,18 }, { 551,7,17 }, { 520,8,16 }, { 489,9,15 }, { 458,10,14 },
  { 427,11,13 }, { 396,12,12 }, { 365,13,11 }, { 334,14,10 }, { 303,15,9 }, { 272,16,8 }, { 241,17,7 }, { 210,18,6 }, { 179,19,5 }, { 148,20,4 }, { 117,21,3 }, { 86,22,2 }, { 55,23,1 }, { 24,24,0 }, { 800,0,25 }, { 769,1,24 }, { 738,2,23 }, { 707,3,22 }, { 676,4,21 }, { 645,5,20 },
  { 614,6,19 }, { 583,7,18 }, { 552,8,17 }, { 521,9,16 }, { 490,10,15 }, { 459,11,14 }, { 428,12,13 }, { 397,13,12 }, { 366,14,11 }, { 335,15,10 }, { 304,16,9 }, { 273,17,8 }, { 242,18,7 }, { 211,19,6 }, { 180,20,5 }, { 149,21,4 }, { 118,22,3 }, { 87,23,2 }, { 56,24,1 }, { 25,25,0 },
  { 832,0,26 }, { 801,1,25 }, { 770,2,24 }, { 739,3,23 }, { 708,4,22 }, { 677,5,21 }, { 646,6,20 }, { 615,7,19 }, { 584,8,18 }, { 553,9,17 }, { 522,10,16 }, { 491,11,15 }, { 460,12,14 }, { 429,13,13 }, { 398,14,12 }, { 367,15,11 }, { 336,16,10 }, { 305,17,9 }, { 274,18,8 }, { 243,19,7 },
  { 212,20,6 }, { 181,21,5 }, { 150,22,4 }, { 119,23,3 }, { 88,24,2 }, { 57,25,1 }, { 26,26,0 }, { 864,0,27 }, { 833,1,26 }, { 802,2,25 }, { 771,3,24 }, { 740,4,23 }, { 709,5,22 }, { 678,6,21 }, { 647,7,20 }, { 616,8,19 }, { 585,9,18 }, { 554,10,17 }, { 523,11,16 }, { 492,12,15 },
  { 461,13,14 }, { 430,14,13 }, { 399,15,12 }, { 368,16,11 }, { 337,17,10 }, { 306,18,9 }, { 275,19,8 }, { 244,20,7 }, { 213,21,6 }, { 182,22,5 }, { 151,23,4 }, { 120,24,3 }, { 89,25,2 }, { 58,26,1 }, { 27,27,0 }, { 896,0,28 }, { 865,1,27 }, { 834,2,26 }, { 803,3,25 }, { 772,4,24 },
  { 741,5,23 }, { 710,6,22 }, { 679,7,21 }, { 648,8,20 }, { 617,9,19 }, { 586,10,18 }, { 555,11,17 }, { 524,12,16 }, { 493,13,15 }, { 462,14,14 }, { 431,15,13 }, { 400,16,12 }, { 369,17,11 }, { 338,18,10 }, { 307,19,9 }, { 276,20,8 }, { 245,21,7 }, { 214,22,6 }, { 183,23,5 }, { 152,24,4 },
  { 121,25,3 }, { 90,26,2 }, { 59,27,1 }, { 28,28,0 }, { 928,0,29 }, { 897,1,28 }, { 866,2,27 }, { 835,3,26 }, { 804,4,25 }, { 773,5,24 }, { 742,6,23 }, { 711,7,22 }, { 680,8,21 }, { 649,9,20 }, { 618,10,19 }, { 587,11,18 }, { 556,12,17 }, { 525,13,16 }, { 494,14,15 }, { 463,15,14 },
  { 432,16,13 }, { 401,17,12 }, { 370,18,11 }, { 339,19,10 }, { 308,20,9 }, { 277,21,8 }, { 246,22,7 }, { 215,23,6 }, { 184,24,5 }, { 153,25,4 }, { 122,26,3 }, { 91,27,2 }, { 60,28,1 }, { 29,29,0 }, { 960,0,30 }, { 929,1,29 }, { 898,2,28 }, { 867,3,27 }, { 836,4,26 }, { 805,5,25 },
  { 774,6,24 }, { 743,7,23 }, { 712,8,22 }, { 681,9,21 }, { 650,10,20 }, { 619,11,19 }, { 588,12,18 }, { 557,13,17 }, { 526,14,16 }, { 495,15,15 }, { 464,16,14 }, { 433,17,13 }, { 402,18,12 }, { 371,19,11 }, { 340,20,10 }, { 309,21,9 }, { 278,22,8 }, { 247,23,7 }, { 216,24,6 }, { 185,25,5 },
  { 154,26,4 }, { 123,27,3 }, { 92,28,2 }, { 61,29,1 }, { 30,30,0 }, { 992,0,31 }, { 961,1,30 }, { 930,2,29 }, { 899,3,28 }, { 868,4,27 }, { 837,5,26 }, { 806,6,25 }, { 775,7,24 }, { 744,8,23 }, { 713,9,22 }, { 682,10,21 }, { 651,11,20 }, { 620,12,19 }, { 589,13,18 }, { 558,14,17 },
  { 527,15,16 }, { 496,16,15 }, { 465,17,14 }, { 434,18,13 }, { 403,19,12 }, { 372,20,11 }, { 341,21,10 }, { 310,22,9 }, { 279,23,8 }, { 248,24,7 }, { 217,25,6 }, { 186,26,5 }, { 155,27,4 }, { 124,28,3 }, { 93,29,2 }, { 62,30,1 }, { 31,31,0 }, { 993,1,31 }, { 962,2,30 }, { 931,3,29 },
  { 900,4,28 }, { 869,5,27 }, { 838,6,26 }, { 807,7,25 }, { 776,8,24 }, { 745,9,23 }, { 714,10,22 }, { 683,11,21 }, { 652,12,20 }, { 621,13,19 }, { 590,14,18 }, { 559,15,17 }, { 528,16,16 }, { 497,17,15 }, { 466,18,14 }, { 435,19,13 }, { 404,20,12 }, { 373,21,11 }, { 342,22,10 }, { 311,23,9 },
  { 280,24,8 }, { 249,25,7 }, { 218,26,6 }, { 187,27,5 }, { 156,28,4 }, { 125,29,3 }, { 94,30,2 }, { 63,31,1 }, { 994,2,31 }, { 963,3,30 }, { 932,4,29 }, { 901,5,28 }, { 870,6,27 }, { 839,7,26 }, { 808,8,25 }, { 777,9,24 }, { 746,10,23 }, { 715,11,22 }, { 684,12,21 }, { 653,13,20 },
  { 622,14,19 }, { 591,15,18 }, { 560,16,17 }, { 529,17,16 }, { 498,18,15 }, { 467,19,14 }, { 436,20,13 }, { 405,21,12 }, { 374,22,11 }, { 343,23,10 }, { 312,24,9 }, { 281,25,8 }, { 250,26,7 }, { 219,27,6 }, { 188,28,5 }, { 157,29,4 }, { 126,30,3 }, { 95,31,2 }, { 995,3,31 }, { 964,4,30 },
  { 933,5,29 }, { 902,6,28 }, { 871,7,27 }, { 840,8,26 }, { 809,9,25 }, { 778,10,24 }, { 747,11,23 }, { 716,12,22 }, { 685,13,21 }, { 654,14,20 }, { 623,15,19 }, { 592,16,18 }, { 561,17,17 }, { 530,18,16 }, { 499,19,15 }, { 468,20,14 }, { 437,21,13 }, { 406,22,12 }, { 375,23,11 }, { 344,24,10 },
  { 313,25,9 }, { 282,26,8 }, { 251,27,7 }, { 220,28,6 }, { 189,29,5 }, { 158,30,4 }, { 127,31,3 }, { 996,4,31 }, { 965,5,30 }, { 934,6,29 }, { 903,7,28 }, { 872,8,27 }, { 841,9,26 }, { 810,10,25 }, { 779,11,24 }, { 748,12,23 }, { 717,13,22 }, { 686,14,21 }, { 655,15,20 }, { 624,16,19 },
  { 593,17,18 }, { 562,18,17 }, { 531,19,16 }, { 500,20,15 }, { 469,21,14 }, { 438,22,13 }, { 407,23,12 }, { 376,24,11 }, { 345,25,10 }, { 314,26,9 }, { 283,27,8 }, { 252,28,7 }, { 221,29,6 }, { 190,30,5 }, { 159,31,4 }, { 997,5,31 }, { 966,6,30 }, { 935,7,29 }, { 904,8,28 }, { 873,9,27 },
  { 842,10,26 }, { 811,11,25 }, { 780,12,24 }, { 749,13,23 }, { 718,14,22 }, { 687,15,21 }, { 656,16,20 }, { 625,17,19 }, { 594,18,18 }, { 563,19,17 }, { 532,20,16 }, { 501,21,15 }, { 470,22,14 }, { 439,23,13 }, { 408,24,12 }, { 377,25,11 }, { 346,26,10 }, { 315,27,9 }, { 284,28,8 }, { 253,29,7 },
  { 222,30,6 }, { 191,31,5 }, { 998,6,31 }, { 967,7,30 }, { 936,8,29 }, { 905,9,28 }, { 874,10,27 }, { 843,11,26 }, { 812,12,25 }, { 781,13,24 }, { 750,14,23 }, { 719,15,22 }, { 688,16,21 }, { 657,17,20 }, { 626,18,19 }, { 595,19,18 }, { 564,20,17 }, { 533,21,16 }, { 502,22,15 }, { 471,23,14 },
  { 440,24,13 }, { 409,25,12 }, { 378,26,11 }, { 347,27,10 }, { 316,28,9 }, { 285,29,8 }, { 254,30,7 }, { 223,31,6 }, { 999,7,31 }, { 968,8,30 }, { 937,9,29 }, { 906,10,28 }, { 875,11,27 }, { 844,12,26 }, { 813,13,25 }, { 782,14,24 }, { 751,15,23 }, { 720,16,22 }, { 689,17,21 }, { 658,18,20 },
  { 627,19,19 }, { 596,20,18 }, { 565,21,17 }, { 534,22,16 }, { 503,23,15 }, { 472,24,14 }, { 441,25,13 }, { 410,26,12 }, { 379,27,11 }, { 348,28,10 }, { 317,29,9 }, { 286,30,8 }, { 255,31,7 }, { 1000,8,31 }, { 969,9,30 }, { 938,10,29 }, { 907,11,28 }, { 876,12,27 }, { 845,13,26 }, { 814,14,25 },
  { 783,15,24 }, { 752,16,23 }, { 721,17,22 }, { 690,18,21 }, { 659,19,20 }, { 628,20,19 }, { 597,21,18 }, { 566,22,17 }, { 535,23,16 }, { 504,24,15 }, { 473,25,14 }, { 442,26,13 }, { 411,27,12 }, { 380,28,11 }, { 349,29,10 }, { 318,30,9 }, { 287,31,8 }, { 1001,9,31 }, { 970,10,30 }, { 939,11,29 },
  { 908,12,28 }, { 877,13,27 }, { 846,14,26 }, { 815,15,25 }, { 784,16,24 }, { 753,17,23 }, { 722,18,22 }, { 691,19,21 }, { 660,20,20 }, { 629,21,19 }, { 598,22,18 }, { 567,23,17 }, { 536,24,16 }, { 505,25,15 }, { 474,26,14 }, { 443,27,13 }, { 412,28,12 }, { 381,29,11 }, { 350,30,10 }, { 319,31,9 },
  { 1002,10,31 }, { 971,11,30 }, { 940,12,29 }, { 909,13,28 }, { 878,14,27 }, { 847,15,26 }, { 816,16,25 }, { 785,17,24 }, { 754,18,23 }, { 723,19,22 }, { 692,20,21 }, { 661,21,20 }, { 630,22,19 }, { 599,23,18 }, { 568,24,17 }, { 537,25,16 }, { 506,26,15 }, { 475,27,14 }, { 444,28,13 }, { 413,29,12 },
  { 382,30,11 }, { 351,31,10 }, { 1003,11,31 }, { 972,12,30 }, { 941,13,29 }, { 910,14,28 }, { 879,15,27 }, { 848,16,26 }, { 817,17,25 }, { 786,18,24 }, { 755,19,23 }, { 724,20,22 }, { 693,21,21 }, { 662,22,20 }, { 631,23,19 }, { 600,24,18 }, { 569,25,17 }, { 538,26,16 }, { 507,27,15 }, { 476,28,14 },
  { 445,29,13 }, { 414,30,12 }, { 383,31,11 }, { 1004,12,31 }, { 973,13,30 }, { 942,14,29 }, { 911,15,28 }, { 880,16,27 }, { 849,17,26 }, { 818,18,25 }, { 787,19,24 }, { 756,20,23 }, { 725,21,22 }, { 694,22,21 }, { 663,23,20 }, { 632,24,19 }, { 601,25,18 }, { 570,26,17 }, { 539,27,16 }, { 508,28,15 },
  { 477,29,14 }, { 446,30,13 }, { 415,31,12 }, { 1005,13,31 }, { 974,14,30 }, { 943,15,29 }, { 912,16,28 }, { 881,17,27 }, { 850,18,26 }, { 819,19,25 }, { 788,20,24 }, { 757,21,23 }, { 726,22,22 }, { 695,23,21 }, { 664,24,20 }, { 633,25,19 }, { 602,26,18 }, { 571,27,17 }, { 540,28,16 }, { 509,29,15 },
  { 478,30,14 }, { 447,31,13 }, { 1006,14,31 }, { 975,15,30 }, { 944,16,29 }, { 913,17,28 }, { 882,18,27 }, { 851,19,26 }, { 820,20,25 }, { 789,21,24 }, { 758,22,23 }, { 727,23,22 }, { 696,24,21 }, { 665,25,20 }, { 634,26,19 }, { 603,27,18 }, { 572,28,17 }, { 541,29,16 }, { 510,30,15 }, { 479,31,14 },
  { 1007,15,31 }, { 976,16,30 }, { 945,17,29 }, { 914,18,28 }, { 883,19,27 }, { 852,20,26 }, { 821,21,25 }, { 790,22,24 }, { 759,23,23 }, { 728,24,22 }, { 697,25,21 }, { 666,26,20 }, { 635,27,19 }, { 604,28,18 }, { 573,29,17 }, { 542,30,16 }, { 511,31,15 }, { 1008,16,31 }, { 977,17,30 }, { 946,18,29 },
  { 915,19,28 }, { 884,20,27 }, { 853,21,26 }, { 822,22,25 }, { 791,23,24 }, { 760,24,23 }, { 729,25,22 }, { 698,26,21 }, { 667,27,20 }, { 636,28,19 }, { 605,29,18 }, { 574,30,17 }, { 543,31,16 }, { 1009,17,31 }, { 978,18,30 }, { 947,19,29 }, { 916,20,28 }, { 885,21,27 }, { 854,22,26 }, { 823,23,25 },
  { 792,24,24 }, { 761,25,23 }, { 730,26,22 }, { 699,27,21 }, { 668,28,20 }, { 637,29,19 }, { 606,30,18 }, { 575,31,17 }, { 1010,18,31 }, { 979,19,30 }, { 948,20,29 }, { 917,21,28 }, { 886,22,27 }, { 855,23,26 }, { 824,24,25 }, { 793,25,24 }, { 762,26,23 }, { 731,27,22 }, { 700,28,21 }, { 669,29,20 },
  { 638,30,19 }, { 607,31,18 }, { 1011,19,31 }, { 980,20,30 }, { 949,21,29 }, { 918,22,28 }, { 887,23,27 }, { 856,24,26 }, { 825,25,25 }, { 794,26,24 }, { 763,27,23 }, { 732,28,22 }, { 701,29,21 }, { 670,30,20 }, { 639,31,19 }, { 1012,20,31 }, { 981,21,30 }, { 950,22,29 }, { 919,23,28 }, { 888,24,27 },
  { 857,25,26 }, { 826,26,25 }, { 795,27,24 }, { 764,28,23 }, { 733,29,22 }, { 702,30,21 }, { 671,31,20 }, { 1013,21,31 }, { 982,22,30 }, { 951,23,29 }, { 920,24,28 }, { 889,25,27 }, { 858,26,26 }, { 827,27,25 }, { 796,28,24 }, { 765,29,23 }, { 734,30,22 }, { 703,31,21 }, { 1014,22,31 }, { 983,23,30 },
  { 952,24,29 }, { 921,25,28 }, { 890,26,27 }, { 859,27,26 }, { 828,28,25 }, { 797,29,24 }, { 766,30,23 }, { 735,31,22 }, { 1015,23,31 }, { 984,24,30 }, { 953,25,29 }, { 922,26,28 }, { 891,27,27 }, { 860,28,26 }, { 829,29,25 }, { 798,30,24 }, { 767,31,23 }, { 1016,24,31 }, { 985,25,30 }, { 954,26,29 },
  { 923,27,28 }, { 892,28,27 }, { 861,29,26 }, { 830,30,25 }, { 799,31,24 }, { 1017,25,31 }, { 986,26,30 }, { 955,27,29 }, { 924,28,28 }, { 893,29,27 }, { 862,30,26 }, { 831,31,25 }, { 1018,26,31 }, { 987,27,30 }, { 956,28,29 }, { 925,29,28 }, { 894,30,27 }, { 863,31,26 }, { 1019,27,31 }, { 988,28,30 },
  { 957,29,29 }, { 926,30,28 }, { 895,31,27 }, { 1020,28,31 }, { 989,29,30 }, { 958,30,29 }, { 927,31,28 }, { 1021,29,31 }, { 990,30,30 }, { 959,31,29 }, { 1022,30,31 }, { 991,31,30 }, { 1023,31,31 }, { 0,0,0 }, { 32,0,1 }, { 1,1,0 }, { 64,0,2 }, { 33,1,1 }, { 2,2,0 }, { 96,0,3 },
  { 65,1,2 }, { 34,2,1 }, { 3,3,0 }, { 128,0,4 }, { 97,1,3 }, { 66,2,2 }, { 35,3,1 }, { 4,4,0 }, { 160,0,5 }, { 129,1,4 }, { 98,2,3 }, { 67,3,2 }, { 36,4,1 }, { 5,5,0 }, { 192,0,6 }, { 161,1,5 }, { 130,2,4 }, { 99,3,3 }, { 68,4,2 }, { 37,5,1 },
  { 6,6,0 }, { 224,0,7 }, { 193,1,6 }, { 162,2,5 }, { 131,3,4 }, { 100,4,3 }, { 69,5,2 }, { 38,6,1 }, { 7,7,0 }, { 256,0,8 }, { 225,1,7 }, { 194,2,6 }, { 163,3,5 }, { 132,4,4 }, { 101,5,3 }, { 70,6,2 }, { 39,7,1 }, { 8,8,0 }, { 288,0,9 }, { 257,1,8 },
  { 226,2,7 }, { 195,3,6 }, { 164,4,5 }, { 133,5,4 }, { 102,6,3 }, { 71,7,2 }, { 40,8,1 }, { 9,9,0 }, { 320,0,10 }, { 289,1,9 }, { 258,2,8 }, { 227,3,7 }, { 196,4,6 }, { 165,5,5 }, { 134,6,4 }, { 103,7,3 }, { 72,8,2 }, { 41,9,1 }, { 10,10,0 }, { 352,0,11 },
  { 321,1,10 }, { 290,2,9 }, { 259,3,8 }, { 228,4,7 }, { 197,5,6 }, { 166,6,5 }, { 135,7,4 }, { 104,8,3 }, { 73,9,2 }, { 42,10,1 }, { 11,11,0 }, { 384,0,12 }, { 353,1,11 }, { 322,2,10 }, { 291,3,9 }, { 260,4,8 }, { 229,5,7 }, { 198,6,6 }, { 167,7,5 }, { 136,8,4 },
  { 105,9,3 }, { 74,10,2 }, { 43,11,1 }, { 12,12,0 }, { 416,0,13 }, { 385,1,12 }, { 354,2,11 }, { 323,3,10 }, { 292,4,9 }, { 261,5,8 }, { 230,6,7 }, { 199,7,6 }, { 168,8,5 }, { 137,9,4 }, { 106,10,3 }, { 75,11,2 }, { 44,12,1 }, { 13,13,0 }, { 448,0,14 }, { 417,1,13 },
  { 386,2,12 }, { 355,3,11 }, { 324,4,10 }, { 293,5,9 }, { 262,6,8 }, { 231,7,7 }, { 200,8,6 }, { 169,9,5 }, { 138,10,4 }, { 107,11,3 }, { 76,12,2 }, { 45,13,1 }, { 14,14,0 }, { 480,0,15 }, { 449,1,14 }, { 418,2,13 }, { 387,3,12 }, { 356,4,11 }, { 325,5,10 }, { 294,6,9 },
  { 263,7,8 }, { 232,8,7 }, { 201,9,6 }, { 170,10,5 }, { 139,11,4 }, { 108,12,3 }, { 77,13,2 }, { 46,14,1 }, { 15,15,0 }, { 512,0,16 }, { 481,1,15 }, { 450,2,14 }, { 419,3,13 }, { 388,4,12 }, { 357,5,11 }, { 326,6,10 }, { 295,7,9 }, { 264,8,8 }, { 233,9,7 }, { 202,10,6 },
  { 171,11,5 }, { 140,12,4 }, { 109,13,3 }, { 78,14,2 }, { 47,15,1 }, { 16,16,0 }, { 544,0,17 }, { 513,1,16 }, { 482,2,15 }, { 451,3,14 }, { 420,4,13 }, { 389,5,12 }, { 358,6,11 }, { 327,7,10 }, { 296,8,9 }, { 265,9,8 }, { 234,10,7 }, { 203,11,6 }, { 172,12,5 }, { 141,13,4 },
  { 110,14,3 }, { 79,15,2 }, { 48,16,1 }, { 17,17,0 }, { 576,0,18 }, { 545,1,17 }, { 514,2,16 }, { 483,3,15 }, { 452,4,14 }, { 421,5,13 }, { 390,6,12 }, { 359,7,11 }, { 328,8,10 }, { 297,9,9 }, { 266,10,8 }, { 235,11,7 }, { 204,12,6 }, { 173,13,5 }, { 142,14,4 }, { 111,15,3 },
  { 80,16,2 }, { 49,17,1 }, { 18,18,0 }, { 608,0,19 }, { 577,1,18 }, { 546,2,17 }, { 515,3,16 }, { 484,4,15 }, { 453,5,14 }, { 422,6,13 }, { 391,7,12 }, { 360,8,11 }, { 329,9,10 }, { 298,10,9 }, { 267,11,8 }, { 236,12,7 }, { 205,13,6 }, { 174,14,5 }, { 143,15,4 }, { 112,16,3 },
  { 81,17,2 }, { 50,18,1 }, { 19,19,0 }, { 640,0,20 }, { 609,1,19 }, { 578,2,18 }, { 547,3,17 }, { 516,4,16 }, { 485,5,15 }, { 454,6,14 }, { 423,7,13 }, { 392,8,12 }, { 361,9,11 }, { 330,10,10 }, { 299,11,9 }, { 268,12,8 }, { 237,13,7 }, { 206,14,6 }, { 175,15,5 }, { 144,16,4 },
  { 113,17,3 }, { 82,18,2 }, { 51,19,1 }, { 20,20,0 }, { 672,0,21 }, { 641,1,20 }, { 610,2,19 }, { 579,3,18 }, { 548,4,17 }, { 517,5,16 }, { 486,6,15 }, { 455,7,14 }, { 424,8,13 }, { 393,9,12 }, { 362,10,11 }, { 331,11,10 }, { 300,12,9 }, { 269,13,8 }, { 238,14,7 }, { 207,15,6 },
  { 176,16,5 }, { 145,17,4 }, { 114,18,3 }, { 83,19,2 }, { 52,20,1 }, { 21,21,0 }, { 704,0,22 }, { 673,1,21 }, { 642,2,20 }, { 611,3,19 }, { 580,4,18 }, { 549,5,17 }, { 518,6,16 }, { 487,7,15 }, { 456,8,14 }, { 425,9,13 }, { 394,10,12 }, { 363,11,11 }, { 332,12,10 }, { 301,13,9 },
  { 270,14,8 }, { 239,15,7 }, { 208,16,6 }, { 177,17,5 }, { 146,18,4 }, { 115,19,3 }, { 84,20,2 }, { 53,21,1 }, { 22,22,0 }, { 736,0,23 }, { 705,1,22 }, { 674,2,21 }, { 643,3,20 }, { 612,4,19 }, { 581,5,18 }, { 550,6,17 }, { 519,7,16 }, { 488,8,15 }, { 457,9,14 }, { 426,10,13 },
  { 395,11,12 }, { 364,12,11 }, { 333,13,10 }, { 302,14,9 }, { 271,15,8 }, { 240,16,7 }, { 209,17,6 }, { 178,18,5 }, { 147,19,4 }, { 116,20,3 }, { 85,21,2 }, { 54,22,1 }, { 23,23,0 }, { 768,0,24 }, { 737,1,23 }, { 706,2,22 }, { 675,3,21 }, { 644,4,20 }, { 613,5,19 }, { 582,6,18 },
  { 551,7,17 }, { 520,8,16 }, { 489,9,15 }, { 458,10,14 }, { 427,11,13 }, { 396,12,12 }, { 365,13,11 }, { 334,14,10 }, { 303,15,9 }, { 272,16,8 }, { 241,17,7 }, { 210,18,6 }, { 179,19,5 }, { 148,20,4 }, { 117,21,3 }, { 86,22,2 }, { 55,23,1 }, { 24,24,0 }, { 800,0,25 }, { 769,1,24 },
  { 738,2,23 }, { 707,3,22 }, { 676,4,21 }, { 645,5,20 }, { 614,6,19 }, { 583,7,18 }, { 552,8,17 }, { 521,9,16 }, { 490,10,15 }, { 459,11,14 }, { 428,12,13 }, { 397,13,12 }, { 366,14,11 }, { 335,15,10 }, { 304,16,9 }, { 273,17,8 }, { 242,18,7 }, { 211,19,6 }, { 180,20,5 }, { 149,21,4 },
  { 118,22,3 }, { 87,23,2 }, { 56,24,1 }, { 25,25,0 }, { 832,0,26 }, { 801,1,25 }, { 770,2,24 }, { 739,3,23 }, { 708,4,22 }, { 677,5,21 }, { 646,6,20 }, { 615,7,19 }, { 584,8,18 }, { 553,9,17 }, { 522,10,16 }, { 491,11,15 }, { 460,12,14 }, { 429,13,13 }, { 398,14,12 }, { 367,15,11 },
  { 336,16,10 }, { 305,17,9 }, { 274,18,8 }, { 243,19,7 }, { 212,20,6 }, { 181,21,5 }, { 150,22,4 }, { 119,23,3 }, { 88,24,2 }, { 57,25,1 }, { 26,26,0 }, { 864,0,27 }, { 833,1,26 }, { 802,2,25 }, { 771,3,24 }, { 740,4,23 }, { 709,5,22 }, { 678,6,21 }, { 647,7,20 }, { 616,8,19 },
  { 585,9,18 }, { 554,10,17 }, { 523,11,16 }, { 492,12,15 }, { 461,13,14 }, { 430,14,13 }, { 399,15,12 }, { 368,16,11 }, { 337,17,10 }, { 306,18,9 }, { 275,19,8 }, { 244,20,7 }, { 213,21,6 }, { 182,22,5 }, { 151,23,4 }, { 120,24,3 }, { 89,25,2 }, { 58,26,1 }, { 27,27,0 }, { 896,0,28 },
  { 865,1,27 }, { 834,2,26 }, { 803,3,25 }, { 772,4,24 }, { 741,5,23 }, { 710,6,22 }, { 679,7,21 }, { 648,8,20 }, { 617,9,19 }, { 586,10,18 }, { 555,11,17 }, { 524,12,16 }, { 493,13,15 }, { 462,14,14 }, { 431,15,13 }, { 400,16,12 }, { 369,17,11 }, { 338,18,10 }, { 307,19,9 }, { 276,20,8 },
  { 245,21,7 }, { 214,22,6 }, { 183,23,5 }, { 152,24,4 }, { 121,25,3 }, { 90,26,2 }, { 59,27,1 }, { 28,28,0 }, { 928,0,29 }, { 897,1,28 }, { 866,2,27 }, { 835,3,26 }, { 804,4,25 }, { 773,5,24 }, { 742,6,23 }, { 711,7,22 }, { 680,8,21 }, { 649,9,20 }, { 618,10,19 }, { 587,11,18 },
  { 556,12,17 }, { 525,13,16 }, { 494,14,15 }, { 463,15,14 }, { 432,16,13 }, { 401,17,12 }, { 370,18,11 }, { 339,19,10 }, { 308,20,9 }, { 277,21,8 }, { 246,22,7 }, { 215,23,6 }, { 184,24,5 }, { 153,25,4 }, { 122,26,3 }, { 91,27,2 }, { 60,28,1 }, { 29,29,0 }, { 960,0,30 }, { 929,1,29 },
  { 898,2,28 }, { 867,3,27 }, { 836,4,26 }, { 805,5,25 }, { 774,6,24 }, { 743,7,23 }, { 712,8,22 }, { 681,9,21 }, { 650,10,20 }, { 619,11,19 }, { 588,12,18 }, { 557,13,17 }, { 526,14,16 }, { 495,15,15 }, { 464,16,14 }, { 433,17,13 }, { 402,18,12 }, { 371,19,11 }, { 340,20,10 }, { 309,21,9 },
  { 278,22,8 }, { 247,23,7 }, { 216,24,6 }, { 185,25,5 }, { 154,26,4 }, { 123,27,3 }, { 92,28,2 }, { 61,29,1 }, { 30,30,0 }, { 992,0,31 }, { 961,1,30 }, { 930,2,29 }, { 899,3,28 }, { 868,4,27 }, { 837,5,26 }, { 806,6,25 }, { 775,7,24 }, { 744,8,23 }, { 713,9,22 }, { 682,10,21 },
  { 651,11,20 }, { 620,12,19 }, { 589,13,18 }, { 558,14,17 }, { 527,15,16 }, { 496,16,15 }, { 465,17,14 }, { 434,18,13 }, { 403,19,12 }, { 372,20,11 }, { 341,21,10 }, { 310,22,9 }, { 279,23,8 }, { 248,24,7 }, { 217,25,6 }, { 186,26,5 }, { 155,27,4 }, { 124,28,3 }, { 93,29,2 }, { 62,30,1 },
  { 31,31,0 }, { 1024,0,32 }, { 993,1,31 }, { 962,2,30 }, { 931,3,29 }, { 900,4,28 }, { 869,5,27 }, { 838,6,26 }, { 807,7,25 }, { 776,8,24 }, { 745,9,23 }, { 714,10,22 }, { 683,11,21 }, { 652,12,20 }, { 621,13,19 }, { 590,14,18 }, { 559,15,17 }, { 528,16,16 }, { 497,17,15 }, { 466,18,14 },
  { 435,19,13 }, { 404,20,12 }, { 373,21,11 }, { 342,22,10 }, { 311,23,9 }, { 280,24,8 }, { 249,25,7 }, { 218,26,6 }, { 187,27,5 }, { 156,28,4 }, { 125,29,3 }, { 94,30,2 }, { 63,31,1 }, { 1056,0,33 }, { 1025,1,32 }, { 994,2,31 }, { 963,3,30 }, { 932,4,29 }, { 901,5,28 }, { 870,6,27 },
  { 839,7,26 }, { 808,8,25 }, { 777,9,24 }, { 746,10,23 }, { 715,11,22 }, { 684,12,21 }, { 653,13,20 }, { 622,14,19 }, { 591,15,18 }, { 560,16,17 }, { 529,17,16 }, { 498,18,15 }, { 467,19,14 }, { 436,20,13 }, { 405,21,12 }, { 374,22,11 }, { 343,23,10 }, { 312,24,9 }, { 281,25,8 }, { 250,26,7 },
  { 219,27,6 }, { 188,28,5 }, { 157,29,4 }, { 126,30,3 }, { 95,31,2 }, { 1088,0,34 }, { 1057,1,33 }, { 1026,2,32 }, { 995,3,31 }, { 964,4,30 }, { 933,5,29 }, { 902,6,28 }, { 871,7,27 }, { 840,8,26 }, { 809,9,25 }, { 778,10,24 }, { 747,11,23 }, { 716,12,22 }, { 685,13,21 }, { 654,14,20 },
  { 623,15,19 }, { 592,16,18 }, { 561,17,17 }, { 530,18,16 }, { 499,19,15 }, { 468,20,14 }, { 437,21,13 }, { 406,22,12 }, { 375,23,11 }, { 344,24,10 }, { 313,25,9 }, { 282,26,8 }, { 251,27,7 }, { 220,28,6 }, { 189,29,5 }, { 158,30,4 }, { 127,31,3 }, { 1120,0,35 }, { 1089,1,34 }, { 1058,2,33 },
  { 1027,3,32 }, { 996,4,31 }, { 965,5,30 }, { 934,6,29 }, { 903,7,28 }, { 872,8,27 }, { 841,9,26 }, { 810,10,25 }, { 779,11,24 }, { 748,12,23 }, { 717,13,22 }, { 686,14,21 }, { 655,15,20 }, { 624,16,19 }, { 593,17,18 }, { 562,18,17 }, { 531,19,16 }, { 500,20,15 }, { 469,21,14 }, { 438,22,13 },
  { 407,23,12 }, { 376,24,11 }, { 345,25,10 }, { 314,26,9 }, { 283,27,8 }, { 252,28,7 }, { 221,29,6 }, { 190,30,5 }, { 159,31,4 }, { 1152,0,36 }, { 1121,1,35 }, { 1090,2,34 }, { 1059,3,33 }, { 1028,4,32 }, { 997,5,31 }, { 966,6,30 }, { 935,7,29 }, { 904,8,28 }, { 873,9,27 }, { 842,10,26 },
  { 811,11,25 }, { 780,12,24 }, { 749,13,23 }, { 718,14,22 }, { 687,15,21 }, { 656,16,20 }, { 625,17,19 }, { 594,18,18 }, { 563,19,17 }, { 532,20,16 }, { 501,21,15 }, { 470,22,14 }, { 439,23,13 }, { 408,24,12 }, { 377,25,11 }, { 346,26,10 }, { 315,27,9 }, { 284,28,8 }, { 253,29,7 }, { 222,30,6 },
  { 191,31,5 }, { 1184,0,37 }, { 1153,1,36 }, { 1122,2,35 }, { 1091,3,34 }, { 1060,4,33 }, { 1029,5,32 }, { 998,6,31 }, { 967,7,30 }, { 936,8,29 }, { 905,9,28 }, { 874,10,27 }, { 843,11,26 }, { 812,12,25 }, { 781,13,24 }, { 750,14,23 }, { 719,15,22 }, { 688,16,21 }, { 657,17,20 }, { 626,18,19 },
  { 595,19,18 }, { 564,20,17 }, { 533,21,16 }, { 502,22,15 }, { 471,23,14 }, { 440,24,13 }, { 409,25,12 }, { 378,26,11 }, { 347,27,10 }, { 316,28,9 }, { 285,29,8 }, { 254,30,7 }, { 223,31,6 }, { 1216,0,38 }, { 1185,1,37 }, { 1154,2,36 }, { 1123,3,35 }, { 1092,4,34 }, { 1061,5,33 }, { 1030,6,32 },
  { 999,7,31 }, { 968,8,30 }, { 937,9,29 }, { 906,10,28 }, { 875,11,27 }, { 844,12,26 }, { 813,13,25 }, { 782,14,24 }, { 751,15,23 }, { 720,16,22 }, { 689,17,21 }, { 658,18,20 }, { 627,19,19 }, { 596,20,18 }, { 565,21,17 }, { 534,22,16 }, { 503,23,15 }, { 472,24,14 }, { 441,25,13 }, { 410,26,12 },
  { 379,27,11 }, { 348,28,10 }, { 317,29,9 }, { 286,30,8 }, { 255,31,7 }, { 1248,0,39 }, { 1217,1,38 }, { 1186,2,37 }, { 1155,3,36 }, { 1124,4,35 }, { 1093,5,34 }, { 1062,6,33 }, { 1031,7,32 }, { 1000,8,31 }, { 969,9,30 }, { 938,10,29 }, { 907,11,28 }, { 876,12,27 }, { 845,13,26 }, { 814,14,25 },
  { 783,15,24 }, { 752,16,23 }, { 721,17,22 }, { 690,18,21 }, { 659,19,20 }, { 628,20,19 }, { 597,21,18 }, { 566,22,17 }, { 535,23,16 }, { 504,24,15 }, { 473,25,14 }, { 442,26,13 }, { 411,27,12 }, { 380,28,11 }, { 349,29,10 }, { 318,30,9 }, { 287,31,8 }, { 1280,0,40 }, { 1249,1,39 }, { 1218,2,38 },
  { 1187,3,37 }, { 1156,4,36 }, { 1125,5,35 }, { 1094,6,34 }, { 1063,7,33 }, { 1032,8,32 }, { 1001,9,31 }, { 970,10,30 }, { 939,11,29 }, { 908,12,28 }, { 877,13,27 }, { 846,14,26 }, { 815,15,25 }, { 784,16,24 }, { 753,17,23 }, { 722,18,22 }, { 691,19,21 }, { 660,20,20 }, { 629,21,19 }, { 598,22,18 },
  { 567,23,17 }, { 536,24,16 }, { 505,25,15 }, { 474,26,14 }, { 443,27,13 }, { 412,28,12 }, { 381,29,11 }, { 350,30,10 }, { 319,31,9 }, { 1312,0,41 }, { 1281,1,40 }, { 1250,2,39 }, { 1219,3,38 }, { 1188,4,37 }, { 1157,5,36 }, { 1126,6,35 }, { 1095,7,34 }, { 1064,8,33 }, { 1033,9,32 }, { 1002,10,31 },
  { 971,11,30 }, { 940,12,29 }, { 909,13,28 }, { 878,14,27 }, { 847,15,26 }, { 816,16,25 }, { 785,17,24 }, { 754,18,23 }, { 723,19,22 }, { 692,20,21 }, { 661,21,20 }, { 630,22,19 }, { 599,23,18 }, { 568,24,17 }, { 537,25,16 }, { 506,26,15 }, { 475,27,14 }, { 444,28,13 }, { 413,29,12 }, { 382,30,11 },
  { 351,31,10 }, { 1344,0,42 }, { 1313,1,41 }, { 1282,2,40 }, { 1251,3,39 }, { 1220,4,38 }, { 1189,5,37 }, { 1158,6,36 }, { 1127,7,35 }, { 1096,8,34 }, { 1065,9,33 }, { 1034,10,32 }, { 1003,11,31 }, { 972,12,30 }, { 941,13,29 }, { 910,14,28 }, { 879,15,27 }, { 848,16,26 }, { 817,17,25 }, { 786,18,24 },
  { 755,19,23 }, { 724,20,22 }, { 693,21,21 }, { 662,22,20 }, { 631,23,19 }, { 600,24,18 }, { 569,25,17 }, { 538,26,16 }, { 507,27,15 }, { 476,28,14 }, { 445,29,13 }, { 414,30,12 }, { 383,31,11 }, { 1376,0,43 }, { 1345,1,42 }, { 1314,2,41 }, { 1283,3,40 }, { 1252,4,39 }, { 1221,5,38 }, { 1190,6,37 },
  { 1159,7,36 }, { 1128,8,35 }, { 1097,9,34 }, { 1066,10,33 }, { 1035,11,32 }, { 1004,12,31 }, { 973,13,30 }, { 942,14,29 }, { 911,15,28 }, { 880,16,27 }, { 849,17,26 }, { 818,18,25 }, { 787,19,24 }, { 756,20,23 }, { 725,21,22 }, { 694,22,21 }, { 663,23,20 }, { 632,24,19 }, { 601,25,18 }, { 570,26,17 },
  { 539,27,16 }, { 508,28,15 }, { 477,29,14 }, { 446,30,13 }, { 415,31,12 }, { 1408,0,44 }, { 1377,1,43 }, { 1346,2,42 }, { 1315,3,41 }, { 1284,4,40 }, { 1253,5,39 }, { 1222,6,38 }, { 1191,7,37 }, { 1160,8,36 }, { 1129,9,35 }, { 1098,10,34 }, { 1067,11,33 }, { 1036,12,32 }, { 1005,13,31 }, { 974,14,30 },
  { 943,15,29 }, { 912,16,28 }, { 881,17,27 }, { 850,18,26 }, { 819,19,25 }, { 788,20,24 }, { 757,21,23 }, { 726,22,22 }, { 695,23,21 }, { 664,24,20 }, { 633,25,19 }, { 602,26,18 }, { 571,27,17 }, { 540,28,16 }, { 509,29,15 }, { 478,30,14 }, { 447,31,13 }, { 1440,0,45 }, { 1409,1,44 }, { 1378,2,43 },
  { 1347,3,42 }, { 1316,4,41 }, { 1285,5,40 }, { 1254,6,39 }, { 1223,7,38 }, { 1192,8,37 }, { 1161,9,36 }, { 1130,10,35 }, { 1099,11,34 }, { 1068,12,33 }, { 1037,13,32 }, { 1006,14,31 }, { 975,15,30 }, { 944,16,29 }, { 913,17,28 }, { 882,18,27 }, { 851,19,26 }, { 820,20,25 }, { 789,21,24 }, { 758,22,23 },
  { 727,23,22 }, { 696,24,21 }, { 665,25,20 }, { 634,26,19 }, { 603,27,18 }, { 572,28,17 }, { 541,29,16 }, { 510,30,15 }, { 479,31,14 }, { 1472,0,46 }, { 1441,1,45 }, { 1410,2,44 }, { 1379,3,43 }, { 1348,4,42 }, { 1317,5,41 }, { 1286,6,40 }, { 1255,7,39 }, { 1224,8,38 }, { 1193,9,37 }, { 1162,10,36 },
  { 1131,11,35 }, { 1100,12,34 }, { 1069,13,33 }, { 1038,14,32 }, { 1007,15,31 }, { 976,16,30 }, { 945,17,29 }, { 914,18,28 }, { 883,19,27 }, { 852,20,26 }, { 821,21,25 }, { 790,22,24 }, { 759,23,23 }, { 728,24,22 }, { 697,25,21 }, { 666,26,20 }, { 635,27,19 }, { 604,28,18 }, { 573,29,17 }, { 542,30,16 },
  { 511,31,15 }, { 1504,0,47 }, { 1473,1,46 }, { 1442,2,45 }, { 1411,3,44 }, { 1380,4,43 }, { 1349,5,42 }, { 1318,6,41 }, { 1287,7,40 }, { 1256,8,39 }, { 1225,9,38 }, { 1194,10,37 }, { 1163,11,36 }, { 1132,12,35 }, { 1101,13,34 }, { 1070,14,33 }, { 1039,15,32 }, { 1008,16,31 }, { 977,17,30 }, { 946,18,29 },
  { 915,19,28 }, { 884,20,27 }, { 853,21,26 }, { 822,22,25 }, { 791,23,24 }, { 760,24,23 }, { 729,25,22 }, { 698,26,21 }, { 667,27,20 }, { 636,28,19 }, { 605,29,18 }, { 574,30,17 }, { 543,31,16 }, { 1536,0,48 }, { 1505,1,47 }, { 1474,2,46 }, { 1443,3,45 }, { 1412,4,44 }, { 1381,5,43 }, { 1350,6,42 },
  { 1319,7,41 }, { 1288,8,40 }, { 1257,9,39 }, { 1226,10,38 }, { 1195,11,37 }, { 1164,12,36 }, { 1133,13,35 }, { 1102,14,34 }, { 1071,15,33 }, { 1040,16,32 }, { 1009,17,31 }, { 978,18,30 }, { 947,19,29 }, { 916,20,28 }, { 885,21,27 }, { 854,22,26 }, { 823,23,25 }, { 792,24,24 }, { 761,25,23 }, { 730,26,22 },
  { 699,27,21 }, { 668,28,20 }, { 637,29,19 }, { 606,30,18 }, { 575,31,17 }, { 1568,0,49 }, { 1537,1,48 }, { 1506,2,47 }, { 1475,3,46 }, { 1444,4,45 }, { 1413,5,44 }, { 1382,6,43 }, { 1351,7,42 }, { 1320,8,41 }, { 1289,9,40 }, { 1258,10,39 }, { 1227,11,38 }, { 1196,12,37 }, { 1165,13,36 }, { 1134,14,35 },
  { 1103,15,34 }, { 1072,16,33 }, { 1041,17,32 }, { 1010,18,31 }, { 979,19,30 }, { 948,20,29 }, { 917,21,28 }, { 886,22,27 }, { 855,23,26 }, { 824,24,25 }, { 793,25,24 }, { 762,26,23 }, { 731,27,22 }, { 700,28,21 }, { 669,29,20 }, { 638,30,19 }, { 607,31,18 }, { 1600,0,50 }, { 1569,1,49 }, { 1538,2,48 },
  { 1507,3,47 }, { 1476,4,46 }, { 1445,5,45 }, { 1414,6,44 }, { 1383,7,43 }, { 1352,8,42 }, { 1321,9,41 }, { 1290,10,40 }, { 1259,11,39 }, { 1228,12,38 }, { 1197,13,37 }, { 1166,14,36 }, { 1135,15,35 }, { 1104,16,34 }, { 1073,17,33 }, { 1042,18,32 }, { 1011,19,31 }, { 980,20,30 }, { 949,21,29 }, { 918,22,28 },
  { 887,23,27 }, { 856,24,26 }, { 825,25,25 }, { 794,26,24 }, { 763,27,23 }, { 732,28,22 }, { 701,29,21 }, { 670,30,20 }, { 639,31,19 }, { 1632,0,51 }, { 1601,1,50 }, { 1570,2,49 }, { 1539,3,48 }, { 1508,4,47 }, { 1477,5,46 }, { 1446,6,45 }, { 1415,7,44 }, { 1384,8,43 }, { 1353,9,42 }, { 1322,10,41 },
  { 1291,11,40 }, { 1260,12,39 }, { 1229,13,38 }, { 1198,14,37 }, { 1167,15,36 }, { 1136,16,35 }, { 1105,17,34 }, { 1074,18,33 }, { 1043,19,32 }, { 1012,20,31 }, { 981,21,30 }, { 950,22,29 }, { 919,23,28 }, { 888,24,27 }, { 857,25,26 }, { 826,26,25 }, { 795,27,24 }, { 764,28,23 }, { 733,29,22 }, { 702,30,21 },
  { 671,31,20 }, { 1664,0,52 }, { 1633,1,51 }, { 1602,2,50 }, { 1571,3,49 }, { 1540,4,48 }, { 1509,5,47 }, { 1478,6,46 }, { 1447,7,45 }, { 1416,8,44 }, { 1385,9,43 }, { 1354,10,42 }, { 1323,11,41 }, { 1292,12,40 }, { 1261,13,39 }, { 1230,14,38 }, { 1199,15,37 }, { 1168,16,36 }, { 1137,17,35 }, { 1106,18,34 },
  { 1075,19,33 }, { 1044,20,32 }, { 1013,21,31 }, { 982,22,30 }, { 951,23,29 }, { 920,24,28 }, { 889,25,27 }, { 858,26,26 }, { 827,27,25 }, { 796,28,24 }, { 765,29,23 }, { 734,30,22 }, { 703,31,21 }, { 1696,0,53 }, { 1665,1,52 }, { 1634,2,51 }, { 1603,3,50 }, { 1572,4,49 }, { 1541,5,48 }, { 1510,6,47 },
  { 1479,7,46 }, { 1448,8,45 }, { 1417,9,44 }, { 1386,10,43 }, { 1355,11,42 }, { 1324,12,41 }, { 1293,13,40 }, { 1262,14,39 }, { 1231,15,38 }, { 1200,16,37 }, { 1169,17,36 }, { 1138,18,35 }, { 1107,19,34 }, { 1076,20,33 }, { 1045,21,32 }, { 1014,22,31 }, { 983,23,30 }, { 952,24,29 }, { 921,25,28 }, { 890,26,27 },
  { 859,27,26 }, { 828,28,25 }, { 797,29,24 }, { 766,30,23 }, { 735,31,22 }, { 1728,0,54 }, { 1697,1,53 }, { 1666,2,52 }, { 1635,3,51 }, { 1604,4,50 }, { 1573,5,49 }, { 1542,6,48 }, { 1511,7,47 }, { 1480,8,46 }, { 1449,9,45 }, { 1418,10,44 }, { 1387,11,43 }, { 1356,12,42 }, { 1325,13,41 }, { 1294,14,40 },
  { 1263,15,39 }, { 1232,16,38 }, { 1201,17,37 }, { 1170,18,36 }, { 1139,19,35 }, { 1108,20,34 }, { 1077,21,33 }, { 1046,22,32 }, { 1015,23,31 }, { 984,24,30 }, { 953,25,29 }, { 922,26,28 }, { 891,27,27 }, { 860,28,26 }, { 829,29,25 }, { 798,30,24 }, { 767,31,23 }, { 1760,0,55 }, { 1729,1,54 }, { 1698,2,53 },
  { 1667,3,52 }, { 1636,4,51 }, { 1605,5,50 }, { 1574,6,49 }, { 1543,7,48 }, { 1512,8,47 }, { 1481,9,46 }, { 1450,10,45 }, { 1419,11,44 }, { 1388,12,43 }, { 1357,13,42 }, { 1326,14,41 }, { 1295,15,40 }, { 1264,16,39 }, { 1233,17,38 }, { 1202,18,37 }, { 1171,19,36 }, { 1140,20,35 }, { 1109,21,34 }, { 1078,22,33 },
  { 1047,23,32 }, { 1016,24,31 }, { 985,25,30 }, { 954,26,29 }, { 923,27,28 }, { 892,28,27 }, { 861,29,26 }, { 830,30,25 }, { 799,31,24 }, { 1792,0,56 }, { 1761,1,55 }, { 1730,2,54 }, { 1699,3,53 }, { 1668,4,52 }, { 1637,5,51 }, { 1606,6,50 }, { 1575,7,49 }, { 1544,8,48 }, { 1513,9,47 }, { 1482,10,46 },
  { 1451,11,45 }, { 1420,12,44 }, { 1389,13,43 }, { 1358,14,42 }, { 1327,15,41 }, { 1296,16,40 }, { 1265,17,39 }, { 1234,18,38 }, { 1203,19,37 }, { 1172,20,36 }, { 1141,21,35 }, { 1110,22,34 }, { 1079,23,33 }, { 1048,24,32 }, { 1017,25,31 }, { 986,26,30 }, { 955,27,29 }, { 924,28,28 }, { 893,29,27 }, { 862,30,26 },
  { 831,31,25 }, { 1824,0,57 }, { 1793,1,56 }, { 1762,2,55 }, { 1731,3,54 }, { 1700,4,53 }, { 1669,5,52 }, { 1638,6,51 }, { 1607,7,50 }, { 1576,8,49 }, { 1545,9,48 }, { 1514,10,47 }, { 1483,11,46 }, { 1452,12,45 }, { 1421,13,44 }, { 1390,14,43 }, { 1359,15,42 }, { 1328,16,41 }, { 1297,17,40 }, { 1266,18,39 },
  { 1235,19,38 }, { 1204,20,37 }, { 1173,21,36 }, { 1142,22,35 }, { 1111,23,34 }, { 1080,24,33 }, { 1049,25,32 }, { 1018,26,31 }, { 987,27,30 }, { 956,28,29 }, { 925,29,28 }, { 894,30,27 }, { 863,31,26 }, { 1856,0,58 }, { 1825,1,57 }, { 1794,2,56 }, { 1763,3,55 }, { 1732,4,54 }, { 1701,5,53 }, { 1670,6,52 },
  { 1639,7,51 }, { 1608,8,50 }, { 1577,9,49 }, { 1546,10,48 }, { 1515,11,47 }, { 1484,12,46 }, { 1453,13,45 }, { 1422,14,44 }, { 1391,15,43 }, { 1360,16,42 }, { 1329,17,41 }, { 1298,18,40 }, { 1267,19,39 }, { 1236,20,38 }, { 1205,21,37 }, { 1174,22,36 }, { 1143,23,35 }, { 1112,24,34 }, { 1081,25,33 }, { 1050,26,32 },
  { 1019,27,31 }, { 988,28,30 }, { 957,29,29 }, { 926,30,28 }, { 895,31,27 }, { 1888,0,59 }, { 1857,1,58 }, { 1826,2,57 }, { 1795,3,56 }, { 1764,4,55 }, { 1733,5,54 }, { 1702,6,53 }, { 1671,7,52 }, { 1640,8,51 }, { 1609,9,50 }, { 1578,10,49 }, { 1547,11,48 }, { 1516,12,47 }, { 1485,13,46 }, { 1454,14,45 },
  { 1423,15,44 }, { 1392,16,43 }, { 1361,17,42 }, { 1330,18,41 }, { 1299,19,40 }, { 1268,20,39 }, { 1237,21,38 }, { 1206,22,37 }, { 1175,23,36 }, { 1144,24,35 }, { 1113,25,34 }, { 1082,26,33 }, { 1051,27,32 }, { 1020,28,31 }, { 989,29,30 }, { 958,30,29 }, { 927,31,28 }, { 1920,0,60 }, { 1889,1,59 }, { 1858,2,58 },
  { 1827,3,57 }, { 1796,4,56 }, { 1765,5,55 }, { 1734,6,54 }, { 1703,7,53 }, { 1672,8,52 }, { 1641,9,51 }, { 1610,10,50 }, { 1579,11,49 }, { 1548,12,48 }, { 1517,13,47 }, { 1486,14,46 }, { 1455,15,45 }, { 1424,16,44 }, { 1393,17,43 }, { 1362,18,42 }, { 1331,19,41 }, { 1300,20,40 }, { 1269,21,39 }, { 1238,22,38 },
  { 1207,23,37 }, { 1176,24,36 }, { 1145,25,35 }, { 1114,26,34 }, { 1083,27,33 }, { 1052,28,32 }, { 1021,29,31 }, { 990,30,30 }, { 959,31,29 }, { 1952,0,61 }, { 1921,1,60 }, { 1890,2,59 }, { 1859,3,58 }, { 1828,4,57 }, { 1797,5,56 }, { 1766,6,55 }, { 1735,7,54 }, { 1704,8,53 }, { 1673,9,52 }, { 1642,10,51 },
  { 1611,11,50 }, { 1580,12,49 }, { 1549,13,48 }, { 1518,14,47 }, { 1487,15,46 }, { 1456,16,45 }, { 1425,17,44 }, { 1394,18,43 }, { 1363,19,42 }, { 1332,20,41 }, { 1301,21,40 }, { 1270,22,39 }, { 1239,23,38 }, { 1208,24,37 }, { 1177,25,36 }, { 1146,26,35 }, { 1115,27,34 }, { 1084,28,33 }, { 1053,29,32 }, { 1022,30,31 },
  { 991,31,30 }, { 1984,0,62 }, { 1953,1,61 }, { 1922,2,60 }, { 1891,3,59 }, { 1860,4,58 }, { 1829,5,57 }, { 1798,6,56 }, { 1767,7,55 }, { 1736,8,54 }, { 1705,9,53 }, { 1674,10,52 }, { 1643,11,51 }, { 1612,12,50 }, { 1581,13,49 }, { 1550,14,48 }, { 1519,15,47 }, { 1488,16,46 }, { 1457,17,45 }, { 1426,18,44 },
  { 1395,19,43 }, { 1364,20,42 }, { 1333,21,41 }, { 1302,22,40 }, { 1271,23,39 }, { 1240,24,38 }, { 1209,25,37 }, { 1178,26,36 }, { 1147,27,35 }, { 1116,28,34 }, { 1085,29,33 }, { 1054,30,32 }, { 1023,31,31 }, { 2016,0,63 }, { 1985,1,62 }, { 1954,2,61 }, { 1923,3,60 }, { 1892,4,59 }, { 1861,5,58 }, { 1830,6,57 },
  { 1799,7,56 }, { 1768,8,55 }, { 1737,9,54 }, { 1706,10,53 }, { 1675,11,52 }, { 1644,12,51 }, { 1613,13,50 }, { 1582,14,49 }, { 1551,15,48 }, { 1520,16,47 }, { 1489,17,46 }, { 1458,18,45 }, { 1427,19,44 }, { 1396,20,43 }, { 1365,21,42 }, { 1334,22,41 }, { 1303,23,40 }, { 1272,24,39 }, { 1241,25,38 }, { 1210,26,37 },
  { 1179,27,36 }, { 1148,28,35 }, { 1117,29,34 }, { 1086,30,33 }, { 1055,31,32 }, { 2017,1,63 }, { 1986,2,62 }, { 1955,3,61 }, { 1924,4,60 }, { 1893,5,59 }, { 1862,6,58 }, { 1831,7,57 }, { 1800,8,56 }, { 1769,9,55 }, { 1738,10,54 }, { 1707,11,53 }, { 1676,12,52 }, { 1645,13,51 }, { 1614,14,50 }, { 1583,15,49 },
  { 1552,16,48 }, { 1521,17,47 }, { 1490,18,46 }, { 1459,19,45 }, { 1428,20,44 }, { 1397,21,43 }, { 1366,22,42 }, { 1335,23,41 }, { 1304,24,40 }, { 1273,25,39 }, { 1242,26,38 }, { 1211,27,37 }, { 1180,28,36 }, { 1149,29,35 }, { 1118,30,34 }, { 1087,31,33 }, { 2018,2,63 }, { 1987,3,62 }, { 1956,4,61 }, { 1925,5,60 },
  { 1894,6,59 }, { 1863,7,58 }, { 1832,8,57 }, { 1801,9,56 }, { 1770,10,55 }, { 1739,11,54 }, { 1708,12,53 }, { 1677,13,52 }, { 1646,14,51 }, { 1615,15,50 }, { 1584,16,49 }, { 1553,17,48 }, { 1522,18,47 }, { 1491,19,46 }, { 1460,20,45 }, { 1429,21,44 }, { 1398,22,43 }, { 1367,23,42 }, { 1336,24,41 }, { 1305,25,40 },
  { 1274,26,39 }, { 1243,27,38 }, { 1212,28,37 }, { 1181,29,36 }, { 1150,30,35 }, { 1119,31,34 }, { 2019,3,63 }, { 1988,4,62 }, { 1957,5,61 }, { 1926,6,60 }, { 1895,7,59 }, { 1864,8,58 }, { 1833,9,57 }, { 1802,10,56 }, { 1771,11,55 }, { 1740,12,54 }, { 1709,13,53 }, { 1678,14,52 }, { 1647,15,51 }, { 1616,16,50 },
  { 1585,17,49 }, { 1554,18,48 }, { 1523,19,47 }, { 1492,20,46 }, { 1461,21,45 }, { 1430,22,44 }, { 1399,23,43 }, { 1368,24,42 }, { 1337,25,41 }, { 1306,26,40 }, { 1275,27,39 }, { 1244,28,38 }, { 1213,29,37 }, { 1182,30,36 }, { 1151,31,35 }, { 2020,4,63 }, { 1989,5,62 }, { 1958,6,61 }, { 1927,7,60 }, { 1896,8,59 },
  { 1865,9,58 }, { 1834,10,57 }, { 1803,11,56 }, { 1772,12,55 }, { 1741,13,54 }, { 1710,14,53 }, { 1679,15,52 }, { 1648,16,51 }, { 1617,17,50 }, { 1586,18,49 }, { 1555,19,48 }, { 1524,20,47 }, { 1493,21,46 }, { 1462,22,45 }, { 1431,23,44 }, { 1400,24,43 }, { 1369,25,42 }, { 1338,26,41 }, { 1307,27,40 }, { 1276,28,39 },
  { 1245,29,38 }, { 1214,30,37 }, { 1183,31,36 }, { 2021,5,63 }, { 1990,6,62 }, { 1959,7,61 }, { 1928,8,60 }, { 1897,9,59 }, { 1866,10,58 }, { 1835,11,57 }, { 1804,12,56 }, { 1773,13,55 }, { 1742,14,54 }, { 1711,15,53 }, { 1680,16,52 }, { 1649,17,51 }, { 1618,18,50 }, { 1587,19,49 }, { 1556,20,48 }, { 1525,21,47 },
  { 1494,22,46 }, { 1463,23,45 }, { 1432,24,44 }, { 1401,25,43 }, { 1370,26,42 }, { 1339,27,41 }, { 1308,28,40 }, { 1277,29,39 }, { 1246,30,38 }, { 1215,31,37 }, { 2022,6,63 }, { 1991,7,62 }, { 1960,8,61 }, { 1929,9,60 }, { 1898,10,59 }, { 1867,11,58 }, { 1836,12,57 }, { 1805,13,56 }, { 1774,14,55 }, { 1743,15,54 },
  { 1712,16,53 }, { 1681,17,52 }, { 1650,18,51 }, { 1619,19,50 }, { 1588,20,49 }, { 1557,21,48 }, { 1526,22,47 }, { 1495,23,46 }, { 1464,24,45 }, { 1433,25,44 }, { 1402,26,43 }, { 1371,27,42 }, { 1340,28,41 }, { 1309,29,40 }, { 1278,30,39 }, { 1247,31,38 }, { 2023,7,63 }, { 1992,8,62 }, { 1961,9,61 }, { 1930,10,60 },
  { 1899,11,59 }, { 1868,12,58 }, { 1837,13,57 }, { 1806,14,56 }, { 1775,15,55 }, { 1744,16,54 }, { 1713,17,53 }, { 1682,18,52 }, { 1651,19,51 }, { 1620,20,50 }, { 1589,21,49 }, { 1558,22,48 }, { 1527,23,47 }, { 1496,24,46 }, { 1465,25,45 }, { 1434,26,44 }, { 1403,27,43 }, { 1372,28,42 }, { 1341,29,41 }, { 1310,30,40 },
  { 1279,31,39 }, { 2024,8,63 }, { 1993,9,62 }, { 1962,10,61 }, { 1931,11,60 }, { 1900,12,59 }, { 1869,13,58 }, { 1838,14,57 }, { 1807,15,56 }, { 1776,16,55 }, { 1745,17,54 }, { 1714,18,53 }, { 1683,19,52 }, { 1652,20,51 }, { 1621,21,50 }, { 1590,22,49 }, { 1559,23,48 }, { 1528,24,47 }, { 1497,25,46 }, { 1466,26,45 },
  { 1435,27,44 }, { 1404,28,43 }, { 1373,29,42 }, { 1342,30,41 }, { 1311,31,40 }, { 2025,9,63 }, { 1994,10,62 }, { 1963,11,61 }, { 1932,12,60 }, { 1901,13,59 }, { 1870,14,58 }, { 1839,15,57 }, { 1808,16,56 }, { 1777,17,55 }, { 1746,18,54 }, { 1715,19,53 }, { 1684,20,52 }, { 1653,21,51 }, { 1622,22,50 }, { 1591,23,49 },
  { 1560,24,48 }, { 1529,25,47 }, { 1498,26,46 }, { 1467,27,45 }, { 1436,28,44 }, { 1405,29,43 }, { 1374,30,42 }, { 1343,31,41 }, { 2026,10,63 }, { 1995,11,62 }, { 1964,12,61 }, { 1933,13,60 }, { 1902,14,59 }, { 1871,15,58 }, { 1840,16,57 }, { 1809,17,56 }, { 1778,18,55 }, { 1747,19,54 }, { 1716,20,53 }, { 1685,21,52 },
  { 1654,22,51 }, { 1623,23,50 }, { 1592,24,49 }, { 1561,25,48 }, { 1530,26,47 }, { 1499,27,46 }, { 1468,28,45 }, { 1437,29,44 }, { 1406,30,43 }, { 1375,31,42 }, { 2027,11,63 }, { 1996,12,62 }, { 1965,13,61 }, { 1934,14,60 }, { 1903,15,59 }, { 1872,16,58 }, { 1841,17,57 }, { 1810,18,56 }, { 1779,19,55 }, { 1748,20,54 },
  { 1717,21,53 }, { 1686,22,52 }, { 1655,23,51 }, { 1624,24,50 }, { 1593,25,49 }, { 1562,26,48 }, { 1531,27,47 }, { 1500,28,46 }, { 1469,29,45 }, { 1438,30,44 }, { 1407,31,43 }, { 2028,12,63 }, { 1997,13,62 }, { 1966,14,61 }, { 1935,15,60 }, { 1904,16,59 }, { 1873,17,58 }, { 1842,18,57 }, { 1811,19,56 }, { 1780,20,55 },
  { 1749,21,54 }, { 1718,22,53 }, { 1687,23,52 }, { 1656,24,51 }, { 1625,25,50 }, { 1594,26,49 }, { 1563,27,48 }, { 1532,28,47 }, { 1501,29,46 }, { 1470,30,45 }, { 1439,31,44 }, { 2029,13,63 }, { 1998,14,62 }, { 1967,15,61 }, { 1936,16,60 }, { 1905,17,59 }, { 1874,18,58 }, { 1843,19,57 }, { 1812,20,56 }, { 1781,21,55 },
  { 1750,22,54 }, { 1719,23,53 }, { 1688,24,52 }, { 1657,25,51 }, { 1626,26,50 }, { 1595,27,49 }, { 1564,28,48 }, { 1533,29,47 }, { 1502,30,46 }, { 1471,31,45 }, { 2030,14,63 }, { 1999,15,62 }, { 1968,16,61 }, { 1937,17,60 }, { 1906,18,59 }, { 1875,19,58 }, { 1844,20,57 }, { 1813,21,56 }, { 1782,22,55 }, { 1751,23,54 },
  { 1720,24,53 }, { 1689,25,52 }, { 1658,26,51 }, { 1627,27,50 }, { 1596,28,49 }, { 1565,29,48 }, { 1534,30,47 }, { 1503,31,46 }, { 2031,15,63 }, { 2000,16,62 }, { 1969,17,61 }, { 1938,18,60 }, { 1907,19,59 }, { 1876,20,58 }, { 1845,21,57 }, { 1814,22,56 }, { 1783,23,55 }, { 1752,24,54 }, { 1721,25,53 }, { 1690,26,52 },
  { 1659,27,51 }, { 1628,28,50 }, { 1597,29,49 }, { 1566,30,48 }, { 1535,31,47 }, { 2032,16,63 }, { 2001,17,62 }, { 1970,18,61 }, { 1939,19,60 }, { 1908,20,59 }, { 1877,21,58 }, { 1846,22,57 }, { 1815,23,56 }, { 1784,24,55 }, { 1753,25,54 }, { 1722,26,53 }, { 1691,27,52 }, { 1660,28,51 }, { 1629,29,50 }, { 1598,30,49 },
  { 1567,31,48 }, { 2033,17,63 }, { 2002,18,62 }, { 1971,19,61 }, { 1940,20,60 }, { 1909,21,59 }, { 1878,22,58 }, { 1847,23,57 }, { 1816,24,56 }, { 1785,25,55 }, { 1754,26,54 }, { 1723,27,53 }, { 1692,28,52 }, { 1661,29,51 }, { 1630,30,50 }, { 1599,31,49 }, { 2034,18,63 }, { 2003,19,62 }, { 1972,20,61 }, { 1941,21,60 },
  { 1910,22,59 }, { 1879,23,58 }, { 1848,24,57 }, { 1817,25,56 }, { 1786,26,55 }, { 1755,27,54 }, { 1724,28,53 }, { 1693,29,52 }, { 1662,30,51 }, { 1631,31,50 }, { 2035,19,63 }, { 2004,20,62 }, { 1973,21,61 }, { 1942,22,60 }, { 1911,23,59 }, { 1880,24,58 }, { 1849,25,57 }, { 1818,26,56 }, { 1787,27,55 }, { 1756,28,54 },
  { 1725,29,53 }, { 1694,30,52 }, { 1663,31,51 }, { 2036,20,63 }, { 2005,21,62 }, { 1974,22,61 }, { 1943,23,60 }, { 1912,24,59 }, { 1881,25,58 }, { 1850,26,57 }, { 1819,27,56 }, { 1788,28,55 }, { 1757,29,54 }, { 1726,30,53 }, { 1695,31,52 }, { 2037,21,63 }, { 2006,22,62 }, { 1975,23,61 }, { 1944,24,60 }, { 1913,25,59 },
  { 1882,26,58 }, { 1851,27,57 }, { 1820,28,56 }, { 1789,29,55 }, { 1758,30,54 }, { 1727,31,53 }, { 2038,22,63 }, { 2007,23,62 }, { 1976,24,61 }, { 1945,25,60 }, { 1914,26,59 }, { 1883,27,58 }, { 1852,28,57 }, { 1821,29,56 }, { 1790,30,55 }, { 1759,31,54 }, { 2039,23,63 }, { 2008,24,62 }, { 1977,25,61 }, { 1946,26,60 },
  { 1915,27,59 }, { 1884,28,58 }, { 1853,29,57 }, { 1822,30,56 }, { 1791,31,55 }, { 2040,24,63 }, { 2009,25,62 }, { 1978,26,61 }, { 1947,27,60 }, { 1916,28,59 }, { 1885,29,58 }, { 1854,30,57 }, { 1823,31,56 }, { 2041,25,63 }, { 2010,26,62 }, { 1979,27,61 }, { 1948,28,60 }, { 1917,29,59 }, { 1886,30,58 }, { 1855,31,57 },
  { 2042,26,63 }, { 2011,27,62 }, { 1980,28,61 }, { 1949,29,60 }, { 1918,30,59 }, { 1887,31,58 }, { 2043,27,63 }, { 2012,28,62 }, { 1981,29,61 }, { 1950,30,60 }, { 1919,31,59 }, { 2044,28,63 }, { 2013,29,62 }, { 1982,30,61 }, { 1951,31,60 }, { 2045,29,63 }, { 2014,30,62 }, { 1983,31,61 }, { 2046,30,63 }, { 2015,31,62 },
  { 2047,31,63 }, { 0,0,0 }, { 1,1,0 }, { 2,2,0 }, { 3,3,0 }, { 4,4,0 }, { 5,5,0 }, { 6,6,0 }, { 7,7,0 }, { 8,8,0 }, { 9,9,0 }, { 10,10,0 }, { 11,11,0 }, { 12,12,0 }, { 13,13,0 }, { 14,14,0 }, { 15,15,0 }, { 16,16,0 }, { 17,17,0 }, { 18,18,0 },
  { 19,19,0 }, { 20,20,0 }, { 21,21,0 }, { 22,22,0 }, { 23,23,0 }, { 24,24,0 }, { 25,25,0 }, { 26,26,0 }, { 27,27,0 }, { 28,28,0 }, { 29,29,0 }, { 30,30,0 }, { 31,31,0 }, { 32,32,0 }, { 33,33,0 }, { 34,34,0 }, { 35,35,0 }, { 36,36,0 }, { 37,37,0 }, { 38,38,0 },
  { 39,39,0 }, { 40,40,0 }, { 41,41,0 }, { 42,42,0 }, { 43,43,0 }, { 44,44,0 }, { 45,45,0 }, { 46,46,0 }, { 47,47,0 }, { 48,48,0 }, { 49,49,0 }, { 50,50,0 }, { 51,51,0 }, { 52,52,0 }, { 53,53,0 }, { 54,54,0 }, { 55,55,0 }, { 56,56,0 }, { 57,57,0 }, { 58,58,0 },
  { 59,59,0 }, { 60,60,0 }, { 61,61,0 }, { 62,62,0 }, { 63,63,0 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 65,1,1 }, { 2,2,0 }, { 66,2,1 }, { 3,3,0 }, { 67,3,1 }, { 4,4,0 }, { 68,4,1 }, { 5,5,0 }, { 69,5,1 }, { 6,6,0 }, { 70,6,1 }, { 7,7,0 },
  { 71,7,1 }, { 8,8,0 }, { 72,8,1 }, { 9,9,0 }, { 73,9,1 }, { 10,10,0 }, { 74,10,1 }, { 11,11,0 }, { 75,11,1 }, { 12,12,0 }, { 76,12,1 }, { 13,13,0 }, { 77,13,1 }, { 14,14,0 }, { 78,14,1 }, { 15,15,0 }, { 79,15,1 }, { 16,16,0 }, { 80,16,1 }, { 17,17,0 },
  { 81,17,1 }, { 18,18,0 }, { 82,18,1 }, { 19,19,0 }, { 83,19,1 }, { 20,20,0 }, { 84,20,1 }, { 21,21,0 }, { 85,21,1 }, { 22,22,0 }, { 86,22,1 }, { 23,23,0 }, { 87,23,1 }, { 24,24,0 }, { 88,24,1 }, { 25,25,0 }, { 89,25,1 }, { 26,26,0 }, { 90,26,1 }, { 27,27,0 },
  { 91,27,1 }, { 28,28,0 }, { 92,28,1 }, { 29,29,0 }, { 93,29,1 }, { 30,30,0 }, { 94,30,1 }, { 31,31,0 }, { 95,31,1 }, { 32,32,0 }, { 96,32,1 }, { 33,33,0 }, { 97,33,1 }, { 34,34,0 }, { 98,34,1 }, { 35,35,0 }, { 99,35,1 }, { 36,36,0 }, { 100,36,1 }, { 37,37,0 },
  { 101,37,1 }, { 38,38,0 }, { 102,38,1 }, { 39,39,0 }, { 103,39,1 }, { 40,40,0 }, { 104,40,1 }, { 41,41,0 }, { 105,41,1 }, { 42,42,0 }, { 106,42,1 }, { 43,43,0 }, { 107,43,1 }, { 44,44,0 }, { 108,44,1 }, { 45,45,0 }, { 109,45,1 }, { 46,46,0 }, { 110,46,1 }, { 47,47,0 },
  { 111,47,1 }, { 48,48,0 }, { 112,48,1 }, { 49,49,0 }, { 113,49,1 }, { 50,50,0 }, { 114,50,1 }, { 51,51,0 }, { 115,51,1 }, { 52,52,0 }, { 116,52,1 }, { 53,53,0 }, { 117,53,1 }, { 54,54,0 }, { 118,54,1 }, { 55,55,0 }, { 119,55,1 }, { 56,56,0 }, { 120,56,1 }, { 57,57,0 },
  { 121,57,1 }, { 58,58,0 }, { 122,58,1 }, { 59,59,0 }, { 123,59,1 }, { 60,60,0 }, { 124,60,1 }, { 61,61,0 }, { 125,61,1 }, { 62,62,0 }, { 126,62,1 }, { 63,63,0 }, { 127,63,1 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 128,0,2 }, { 65,1,1 }, { 2,2,0 }, { 192,0,3 },
  { 129,1,2 }, { 66,2,1 }, { 3,3,0 }, { 193,1,3 }, { 130,2,2 }, { 67,3,1 }, { 4,4,0 }, { 194,2,3 }, { 131,3,2 }, { 68,4,1 }, { 5,5,0 }, { 195,3,3 }, { 132,4,2 }, { 69,5,1 }, { 6,6,0 }, { 196,4,3 }, { 133,5,2 }, { 70,6,1 }, { 7,7,0 }, { 197,5,3 },
  { 134,6,2 }, { 71,7,1 }, { 8,8,0 }, { 198,6,3 }, { 135,7,2 }, { 72,8,1 }, { 9,9,0 }, { 199,7,3 }, { 136,8,2 }, { 73,9,1 }, { 10,10,0 }, { 200,8,3 }, { 137,9,2 }, { 74,10,1 }, { 11,11,0 }, { 201,9,3 }, { 138,10,2 }, { 75,11,1 }, { 12,12,0 }, { 202,10,3 },
  { 139,11,2 }, { 76,12,1 }, { 13,13,0 }, { 203,11,3 }, { 140,12,2 }, { 77,13,1 }, { 14,14,0 }, { 204,12,3 }, { 141,13,2 }, { 78,14,1 }, { 15,15,0 }, { 205,13,3 }, { 142,14,2 }, { 79,15,1 }, { 16,16,0 }, { 206,14,3 }, { 143,15,2 }, { 80,16,1 }, { 17,17,0 }, { 207,15,3 },
  { 144,16,2 }, { 81,17,1 }, { 18,18,0 }, { 208,16,3 }, { 145,17,2 }, { 82,18,1 }, { 19,19,0 }, { 209,17,3 }, { 146,18,2 }, { 83,19,1 }, { 20,20,0 }, { 210,18,3 }, { 147,19,2 }, { 84,20,1 }, { 21,21,0 }, { 211,19,3 }, { 148,20,2 }, { 85,21,1 }, { 22,22,0 }, { 212,20,3 },
  { 149,21,2 }, { 86,22,1 }, { 23,23,0 }, { 213,21,3 }, { 150,22,2 }, { 87,23,1 }, { 24,24,0 }, { 214,22,3 }, { 151,23,2 }, { 88,24,1 }, { 25,25,0 }, { 215,23,3 }, { 152,24,2 }, { 89,25,1 }, { 26,26,0 }, { 216,24,3 }, { 153,25,2 }, { 90,26,1 }, { 27,27,0 }, { 217,25,3 },
  { 154,26,2 }, { 91,27,1 }, { 28,28,0 }, { 218,26,3 }, { 155,27,2 }, { 92,28,1 }, { 29,29,0 }, { 219,27,3 }, { 156,28,2 }, { 93,29,1 }, { 30,30,0 }, { 220,28,3 }, { 157,29,2 }, { 94,30,1 }, { 31,31,0 }, { 221,29,3 }, { 158,30,2 }, { 95,31,1 }, { 32,32,0 }, { 222,30,3 },
  { 159,31,2 }, { 96,32,1 }, { 33,33,0 }, { 223,31,3 }, { 160,32,2 }, { 97,33,1 }, { 34,34,0 }, { 224,32,3 }, { 161,33,2 }, { 98,34,1 }, { 35,35,0 }, { 225,33,3 }, { 162,34,2 }, { 99,35,1 }, { 36,36,0 }, { 226,34,3 }, { 163,35,2 }, { 100,36,1 }, { 37,37,0 }, { 227,35,3 },
  { 164,36,2 }, { 101,37,1 }, { 38,38,0 }, { 228,36,3 }, { 165,37,2 }, { 102,38,1 }, { 39,39,0 }, { 229,37,3 }, { 166,38,2 }, { 103,39,1 }, { 40,40,0 }, { 230,38,3 }, { 167,39,2 }, { 104,40,1 }, { 41,41,0 }, { 231,39,3 }, { 168,40,2 }, { 105,41,1 }, { 42,42,0 }, { 232,40,3 },
  { 169,41,2 }, { 106,42,1 }, { 43,43,0 }, { 233,41,3 }, { 170,42,2 }, { 107,43,1 }, { 44,44,0 }, { 234,42,3 }, { 171,43,2 }, { 108,44,1 }, { 45,45,0 }, { 235,43,3 }, { 172,44,2 }, { 109,45,1 }, { 46,46,0 }, { 236,44,3 }, { 173,45,2 }, { 110,46,1 }, { 47,47,0 }, { 237,45,3 },
  { 174,46,2 }, { 111,47,1 }, { 48,48,0 }, { 238,46,3 }, { 175,47,2 }, { 112,48,1 }, { 49,49,0 }, { 239,47,3 }, { 176,48,2 }, { 113,49,1 }, { 50,50,0 }, { 240,48,3 }, { 177,49,2 }, { 114,50,1 }, { 51,51,0 }, { 241,49,3 }, { 178,50,2 }, { 115,51,1 }, { 52,52,0 }, { 242,50,3 },
  { 179,51,2 }, { 116,52,1 }, { 53,53,0 }, { 243,51,3 }, { 180,52,2 }, { 117,53,1 }, { 54,54,0 }, { 244,52,3 }, { 181,53,2 }, { 118,54,1 }, { 55,55,0 }, { 245,53,3 }, { 182,54,2 }, { 119,55,1 }, { 56,56,0 }, { 246,54,3 }, { 183,55,2 }, { 120,56,1 }, { 57,57,0 }, { 247,55,3 },
  { 184,56,2 }, { 121,57,1 }, { 58,58,0 }, { 248,56,3 }, { 185,57,2 }, { 122,58,1 }, { 59,59,0 }, { 249,57,3 }, { 186,58,2 }, { 123,59,1 }, { 60,60,0 }, { 250,58,3 }, { 187,59,2 }, { 124,60,1 }, { 61,61,0 }, { 251,59,3 }, { 188,60,2 }, { 125,61,1 }, { 62,62,0 }, { 252,60,3 },
  { 189,61,2 }, { 126,62,1 }, { 63,63,0 }, { 253,61,3 }, { 190,62,2 }, { 127,63,1 }, { 254,62,3 }, { 191,63,2 }, { 255,63,3 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 128,0,2 }, { 65,1,1 }, { 2,2,0 }, { 192,0,3 }, { 129,1,2 }, { 66,2,1 }, { 3,3,0 }, { 256,0,4 },
  { 193,1,3 }, { 130,2,2 }, { 67,3,1 }, { 4,4,0 }, { 320,0,5 }, { 257,1,4 }, { 194,2,3 }, { 131,3,2 }, { 68,4,1 }, { 5,5,0 }, { 384,0,6 }, { 321,1,5 }, { 258,2,4 }, { 195,3,3 }, { 132,4,2 }, { 69,5,1 }, { 6,6,0 }, { 448,0,7 }, { 385,1,6 }, { 322,2,5 },
  { 259,3,4 }, { 196,4,3 }, { 133,5,2 }, { 70,6,1 }, { 7,7,0 }, { 449,1,7 }, { 386,2,6 }, { 323,3,5 }, { 260,4,4 }, { 197,5,3 }, { 134,6,2 }, { 71,7,1 }, { 8,8,0 }, { 450,2,7 }, { 387,3,6 }, { 324,4,5 }, { 261,5,4 }, { 198,6,3 }, { 135,7,2 }, { 72,8,1 },
  { 9,9,0 }, { 451,3,7 }, { 388,4,6 }, { 325,5,5 }, { 262,6,4 }, { 199,7,3 }, { 136,8,2 }, { 73,9,1 }, { 10,10,0 }, { 452,4,7 }, { 389,5,6 }, { 326,6,5 }, { 263,7,4 }, { 200,8,3 }, { 137,9,2 }, { 74,10,1 }, { 11,11,0 }, { 453,5,7 }, { 390,6,6 }, { 327,7,5 },
  { 264,8,4 }, { 201,9,3 }, { 138,10,2 }, { 75,11,1 }, { 12,12,0 }, { 454,6,7 }, { 391,7,6 }, { 328,8,5 }, { 265,9,4 }, { 202,10,3 }, { 139,11,2 }, { 76,12,1 }, { 13,13,0 }, { 455,7,7 }, { 392,8,6 }, { 329,9,5 }, { 266,10,4 }, { 203,11,3 }, { 140,12,2 }, { 77,13,1 },
  { 14,14,0 }, { 456,8,7 }, { 393,9,6 }, { 330,10,5 }, { 267,11,4 }, { 204,12,3 }, { 141,13,2 }, { 78,14,1 }, { 15,15,0 }, { 457,9,7 }, { 394,10,6 }, { 331,11,5 }, { 268,12,4 }, { 205,13,3 }, { 142,14,2 }, { 79,15,1 }, { 16,16,0 }, { 458,10,7 }, { 395,11,6 }, { 332,12,5 },
  { 269,13,4 }, { 206,14,3 }, { 143,15,2 }, { 80,16,1 }, { 17,17,0 }, { 459,11,7 }, { 396,12,6 }, { 333,13,5 }, { 270,14,4 }, { 207,15,3 }, { 144,16,2 }, { 81,17,1 }, { 18,18,0 }, { 460,12,7 }, { 397,13,6 }, { 334,14,5 }, { 271,15,4 }, { 208,16,3 }, { 145,17,2 }, { 82,18,1 },
  { 19,19,0 }, { 461,13,7 }, { 398,14,6 }, { 335,15,5 }, { 272,16,4 }, { 209,17,3 }, { 146,18,2 }, { 83,19,1 }, { 20,20,0 }, { 462,14,7 }, { 399,15,6 }, { 336,16,5 }, { 273,17,4 }, { 210,18,3 }, { 147,19,2 }, { 84,20,1 }, { 21,21,0 }, { 463,15,7 }, { 400,16,6 }, { 337,17,5 },
  { 274,18,4 }, { 211,19,3 }, { 148,20,2 }, { 85,21,1 }, { 22,22,0 }, { 464,16,7 }, { 401,17,6 }, { 338,18,5 }, { 275,19,4 }, { 212,20,3 }, { 149,21,2 }, { 86,22,1 }, { 23,23,0 }, { 465,17,7 }, { 402,18,6 }, { 339,19,5 }, { 276,20,4 }, { 213,21,3 }, { 150,22,2 }, { 87,23,1 },
  { 24,24,0 }, { 466,18,7 }, { 403,19,6 }, { 340,20,5 }, { 277,21,4 }, { 214,22,3 }, { 151,23,2 }, { 88,24,1 }, { 25,25,0 }, { 467,19,7 }, { 404,20,6 }, { 341,21,5 }, { 278,22,4 }, { 215,23,3 }, { 152,24,2 }, { 89,25,1 }, { 26,26,0 }, { 468,20,7 }, { 405,21,6 }, { 342,22,5 },
  { 279,23,4 }, { 216,24,3 }, { 153,25,2 }, { 90,26,1 }, { 27,27,0 }, { 469,21,7 }, { 406,22,6 }, { 343,23,5 }, { 280,24,4 }, { 217,25,3 }, { 154,26,2 }, { 91,27,1 }, { 28,28,0 }, { 470,22,7 }, { 407,23,6 }, { 344,24,5 }, { 281,25,4 }, { 218,26,3 }, { 155,27,2 }, { 92,28,1 },
  { 29,29,0 }, { 471,23,7 }, { 408,24,6 }, { 345,25,5 }, { 282,26,4 }, { 219,27,3 }, { 156,28,2 }, { 93,29,1 }, { 30,30,0 }, { 472,24,7 }, { 409,25,6 }, { 346,26,5 }, { 283,27,4 }, { 220,28,3 }, { 157,29,2 }, { 94,30,1 }, { 31,31,0 }, { 473,25,7 }, { 410,26,6 }, { 347,27,5 },
  { 284,28,4 }, { 221,29,3 }, { 158,30,2 }, { 95,31,1 }, { 32,32,0 }, { 474,26,7 }, { 411,27,6 }, { 348,28,5 }, { 285,29,4 }, { 222,30,3 }, { 159,31,2 }, { 96,32,1 }, { 33,33,0 }, { 475,27,7 }, { 412,28,6 }, { 349,29,5 }, { 286,30,4 }, { 223,31,3 }, { 160,32,2 }, { 97,33,1 },
  { 34,34,0 }, { 476,28,7 }, { 413,29,6 }, { 350,30,5 }, { 287,31,4 }, { 224,32,3 }, { 161,33,2 }, { 98,34,1 }, { 35,35,0 }, { 477,29,7 }, { 414,30,6 }, { 351,31,5 }, { 288,32,4 }, { 225,33,3 }, { 162,34,2 }, { 99,35,1 }, { 36,36,0 }, { 478,30,7 }, { 415,31,6 }, { 352,32,5 },
  { 289,33,4 }, { 226,34,3 }, { 163,35,2 }, { 100,36,1 }, { 37,37,0 }, { 479,31,7 }, { 416,32,6 }, { 353,33,5 }, { 290,34,4 }, { 227,35,3 }, { 164,36,2 }, { 101,37,1 }, { 38,38,0 }, { 480,32,7 }, { 417,33,6 }, { 354,34,5 }, { 291,35,4 }, { 228,36,3 }, { 165,37,2 }, { 102,38,1 },
  { 39,39,0 }, { 481,33,7 }, { 418,34,6 }, { 355,35,5 }, { 292,36,4 }, { 229,37,3 }, { 166,38,2 }, { 103,39,1 }, { 40,40,0 }, { 482,34,7 }, { 419,35,6 }, { 356,36,5 }, { 293,37,4 }, { 230,38,3 }, { 167,39,2 }, { 104,40,1 }, { 41,41,0 }, { 483,35,7 }, { 420,36,6 }, { 357,37,5 },
  { 294,38,4 }, { 231,39,3 }, { 168,40,2 }, { 105,41,1 }, { 42,42,0 }, { 484,36,7 }, { 421,37,6 }, { 358,38,5 }, { 295,39,4 }, { 232,40,3 }, { 169,41,2 }, { 106,42,1 }, { 43,43,0 }, { 485,37,7 }, { 422,38,6 }, { 359,39,5 }, { 296,40,4 }, { 233,41,3 }, { 170,42,2 }, { 107,43,1 },
  { 44,44,0 }, { 486,38,7 }, { 423,39,6 }, { 360,40,5 }, { 297,41,4 }, { 234,42,3 }, { 171,43,2 }, { 108,44,1 }, { 45,45,0 }, { 487,39,7 }, { 424,40,6 }, { 361,41,5 }, { 298,42,4 }, { 235,43,3 }, { 172,44,2 }, { 109,45,1 }, { 46,46,0 }, { 488,40,7 }, { 425,41,6 }, { 362,42,5 },
  { 299,43,4 }, { 236,44,3 }, { 173,45,2 }, { 110,46,1 }, { 47,47,0 }, { 489,41,7 }, { 426,42,6 }, { 363,43,5 }, { 300,44,4 }, { 237,45,3 }, { 174,46,2 }, { 111,47,1 }, { 48,48,0 }, { 490,42,7 }, { 427,43,6 }, { 364,44,5 }, { 301,45,4 }, { 238,46,3 }, { 175,47,2 }, { 112,48,1 },
  { 49,49,0 }, { 491,43,7 }, { 428,44,6 }, { 365,45,5 }, { 302,46,4 }, { 239,47,3 }, { 176,48,2 }, { 113,49,1 }, { 50,50,0 }, { 492,44,7 }, { 429,45,6 }, { 366,46,5 }, { 303,47,4 }, { 240,48,3 }, { 177,49,2 }, { 114,50,1 }, { 51,51,0 }, { 493,45,7 }, { 430,46,6 }, { 367,47,5 },
  { 304,48,4 }, { 241,49,3 }, { 178,50,2 }, { 115,51,1 }, { 52,52,0 }, { 494,46,7 }, { 431,47,6 }, { 368,48,5 }, { 305,49,4 }, { 242,50,3 }, { 179,51,2 }, { 116,52,1 }, { 53,53,0 }, { 495,47,7 }, { 432,48,6 }, { 369,49,5 }, { 306,50,4 }, { 243,51,3 }, { 180,52,2 }, { 117,53,1 },
  { 54,54,0 }, { 496,48,7 }, { 433,49,6 }, { 370,50,5 }, { 307,51,4 }, { 244,52,3 }, { 181,53,2 }, { 118,54,1 }, { 55,55,0 }, { 497,49,7 }, { 434,50,6 }, { 371,51,5 }, { 308,52,4 }, { 245,53,3 }, { 182,54,2 }, { 119,55,1 }, { 56,56,0 }, { 498,50,7 }, { 435,51,6 }, { 372,52,5 },
  { 309,53,4 }, { 246,54,3 }, { 183,55,2 }, { 120,56,1 }, { 57,57,0 }, { 499,51,7 }, { 436,52,6 }, { 373,53,5 }, { 310,54,4 }, { 247,55,3 }, { 184,56,2 }, { 121,57,1 }, { 58,58,0 }, { 500,52,7 }, { 437,53,6 }, { 374,54,5 }, { 311,55,4 }, { 248,56,3 }, { 185,57,2 }, { 122,58,1 },
  { 59,59,0 }, { 501,53,7 }, { 438,54,6 }, { 375,55,5 }, { 312,56,4 }, { 249,57,3 }, { 186,58,2 }, { 123,59,1 }, { 60,60,0 }, { 502,54,7 }, { 439,55,6 }, { 376,56,5 }, { 313,57,4 }, { 250,58,3 }, { 187,59,2 }, { 124,60,1 }, { 61,61,0 }, { 503,55,7 }, { 440,56,6 }, { 377,57,5 },
  { 314,58,4 }, { 251,59,3 }, { 188,60,2 }, { 125,61,1 }, { 62,62,0 }, { 504,56,7 }, { 441,57,6 }, { 378,58,5 }, { 315,59,4 }, { 252,60,3 }, { 189,61,2 }, { 126,62,1 }, { 63,63,0 }, { 505,57,7 }, { 442,58,6 }, { 379,59,5 }, { 316,60,4 }, { 253,61,3 }, { 190,62,2 }, { 127,63,1 },
  { 506,58,7 }, { 443,59,6 }, { 380,60,5 }, { 317,61,4 }, { 254,62,3 }, { 191,63,2 }, { 507,59,7 }, { 444,60,6 }, { 381,61,5 }, { 318,62,4 }, { 255,63,3 }, { 508,60,7 }, { 445,61,6 }, { 382,62,5 }, { 319,63,4 }, { 509,61,7 }, { 446,62,6 }, { 383,63,5 }, { 510,62,7 }, { 447,63,6 },
  { 511,63,7 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 128,0,2 }, { 65,1,1 }, { 2,2,0 }, { 192,0,3 }, { 129,1,2 }, { 66,2,1 }, { 3,3,0 }, { 256,0,4 }, { 193,1,3 }, { 130,2,2 }, { 67,3,1 }, { 4,4,0 }, { 320,0,5 }, { 257,1,4 }, { 194,2,3 }, { 131,3,2 },
  { 68,4,1 }, { 5,5,0 }, { 384,0,6 }, { 321,1,5 }, { 258,2,4 }, { 195,3,3 }, { 132,4,2 }, { 69,5,1 }, { 6,6,0 }, { 448,0,7 }, { 385,1,6 }, { 322,2,5 }, { 259,3,4 }, { 196,4,3 }, { 133,5,2 }, { 70,6,1 }, { 7,7,0 }, { 512,0,8 }, { 449,1,7 }, { 386,2,6 },
  { 323,3,5 }, { 260,4,4 }, { 197,5,3 }, { 134,6,2 }, { 71,7,1 }, { 8,8,0 }, { 576,0,9 }, { 513,1,8 }, { 450,2,7 }, { 387,3,6 }, { 324,4,5 }, { 261,5,4 }, { 198,6,3 }, { 135,7,2 }, { 72,8,1 }, { 9,9,0 }, { 640,0,10 }, { 577,1,9 }, { 514,2,8 }, { 451,3,7 },
  { 388,4,6 }, { 325,5,5 }, { 262,6,4 }, { 199,7,3 }, { 136,8,2 }, { 73,9,1 }, { 10,10,0 }, { 704,0,11 }, { 641,1,10 }, { 578,2,9 }, { 515,3,8 }, { 452,4,7 }, { 389,5,6 }, { 326,6,5 }, { 263,7,4 }, { 200,8,3 }, { 137,9,2 }, { 74,10,1 }, { 11,11,0 }, { 768,0,12 },
  { 705,1,11 }, { 642,2,10 }, { 579,3,9 }, { 516,4,8 }, { 453,5,7 }, { 390,6,6 }, { 327,7,5 }, { 264,8,4 }, { 201,9,3 }, { 138,10,2 }, { 75,11,1 }, { 12,12,0 }, { 832,0,13 }, { 769,1,12 }, { 706,2,11 }, { 643,3,10 }, { 580,4,9 }, { 517,5,8 }, { 454,6,7 }, { 391,7,6 },
  { 328,8,5 }, { 265,9,4 }, { 202,10,3 }, { 139,11,2 }, { 76,12,1 }, { 13,13,0 }, { 896,0,14 }, { 833,1,13 }, { 770,2,12 }, { 707,3,11 }, { 644,4,10 }, { 581,5,9 }, { 518,6,8 }, { 455,7,7 }, { 392,8,6 }, { 329,9,5 }, { 266,10,4 }, { 203,11,3 }, { 140,12,2 }, { 77,13,1 },
  { 14,14,0 }, { 960,0,15 }, { 897,1,14 }, { 834,2,13 }, { 771,3,12 }, { 708,4,11 }, { 645,5,10 }, { 582,6,9 }, { 519,7,8 }, { 456,8,7 }, { 393,9,6 }, { 330,10,5 }, { 267,11,4 }, { 204,12,3 }, { 141,13,2 }, { 78,14,1 }, { 15,15,0 }, { 961,1,15 }, { 898,2,14 }, { 835,3,13 },
  { 772,4,12 }, { 709,5,11 }, { 646,6,10 }, { 583,7,9 }, { 520,8,8 }, { 457,9,7 }, { 394,10,6 }, { 331,11,5 }, { 268,12,4 }, { 205,13,3 }, { 142,14,2 }, { 79,15,1 }, { 16,16,0 }, { 962,2,15 }, { 899,3,14 }, { 836,4,13 }, { 773,5,12 }, { 710,6,11 }, { 647,7,10 }, { 584,8,9 },
  { 521,9,8 }, { 458,10,7 }, { 395,11,6 }, { 332,12,5 }, { 269,13,4 }, { 206,14,3 }, { 143,15,2 }, { 80,16,1 }, { 17,17,0 }, { 963,3,15 }, { 900,4,14 }, { 837,5,13 }, { 774,6,12 }, { 711,7,11 }, { 648,8,10 }, { 585,9,9 }, { 522,10,8 }, { 459,11,7 }, { 396,12,6 }, { 333,13,5 },
  { 270,14,4 }, { 207,15,3 }, { 144,16,2 }, { 81,17,1 }, { 18,18,0 }, { 964,4,15 }, { 901,5,14 }, { 838,6,13 }, { 775,7,12 }, { 712,8,11 }, { 649,9,10 }, { 586,10,9 }, { 523,11,8 }, { 460,12,7 }, { 397,13,6 }, { 334,14,5 }, { 271,15,4 }, { 208,16,3 }, { 145,17,2 }, { 82,18,1 },
  { 19,19,0 }, { 965,5,15 }, { 902,6,14 }, { 839,7,13 }, { 776,8,12 }, { 713,9,11 }, { 650,10,10 }, { 587,11,9 }, { 524,12,8 }, { 461,13,7 }, { 398,14,6 }, { 335,15,5 }, { 272,16,4 }, { 209,17,3 }, { 146,18,2 }, { 83,19,1 }, { 20,20,0 }, { 966,6,15 }, { 903,7,14 }, { 840,8,13 },
  { 777,9,12 }, { 714,10,11 }, { 651,11,10 }, { 588,12,9 }, { 525,13,8 }, { 462,14,7 }, { 399,15,6 }, { 336,16,5 }, { 273,17,4 }, { 210,18,3 }, { 147,19,2 }, { 84,20,1 }, { 21,21,0 }, { 967,7,15 }, { 904,8,14 }, { 841,9,13 }, { 778,10,12 }, { 715,11,11 }, { 652,12,10 }, { 589,13,9 },
  { 526,14,8 }, { 463,15,7 }, { 400,16,6 }, { 337,17,5 }, { 274,18,4 }, { 211,19,3 }, { 148,20,2 }, { 85,21,1 }, { 22,22,0 }, { 968,8,15 }, { 905,9,14 }, { 842,10,13 }, { 779,11,12 }, { 716,12,11 }, { 653,13,10 }, { 590,14,9 }, { 527,15,8 }, { 464,16,7 }, { 401,17,6 }, { 338,18,5 },
  { 275,19,4 }, { 212,20,3 }, { 149,21,2 }, { 86,22,1 }, { 23,23,0 }, { 969,9,15 }, { 906,10,14 }, { 843,11,13 }, { 780,12,12 }, { 717,13,11 }, { 654,14,10 }, { 591,15,9 }, { 528,16,8 }, { 465,17,7 }, { 402,18,6 }, { 339,19,5 }, { 276,20,4 }, { 213,21,3 }, { 150,22,2 }, { 87,23,1 },
  { 24,24,0 }, { 970,10,15 }, { 907,11,14 }, { 844,12,13 }, { 781,13,12 }, { 718,14,11 }, { 655,15,10 }, { 592,16,9 }, { 529,17,8 }, { 466,18,7 }, { 403,19,6 }, { 340,20,5 }, { 277,21,4 }, { 214,22,3 }, { 151,23,2 }, { 88,24,1 }, { 25,25,0 }, { 971,11,15 }, { 908,12,14 }, { 845,13,13 },
  { 782,14,12 }, { 719,15,11 }, { 656,16,10 }, { 593,17,9 }, { 530,18,8 }, { 467,19,7 }, { 404,20,6 }, { 341,21,5 }, { 278,22,4 }, { 215,23,3 }, { 152,24,2 }, { 89,25,1 }, { 26,26,0 }, { 972,12,15 }, { 909,13,14 }, { 846,14,13 }, { 783,15,12 }, { 720,16,11 }, { 657,17,10 }, { 594,18,9 },
  { 531,19,8 }, { 468,20,7 }, { 405,21,6 }, { 342,22,5 }, { 279,23,4 }, { 216,24,3 }, { 153,25,2 }, { 90,26,1 }, { 27,27,0 }, { 973,13,15 }, { 910,14,14 }, { 847,15,13 }, { 784,16,12 }, { 721,17,11 }, { 658,18,10 }, { 595,19,9 }, { 532,20,8 }, { 469,21,7 }, { 406,22,6 }, { 343,23,5 },
  { 280,24,4 }, { 217,25,3 }, { 154,26,2 }, { 91,27,1 }, { 28,28,0 }, { 974,14,15 }, { 911,15,14 }, { 848,16,13 }, { 785,17,12 }, { 722,18,11 }, { 659,19,10 }, { 596,20,9 }, { 533,21,8 }, { 470,22,7 }, { 407,23,6 }, { 344,24,5 }, { 281,25,4 }, { 218,26,3 }, { 155,27,2 }, { 92,28,1 },
  { 29,29,0 }, { 975,15,15 }, { 912,16,14 }, { 849,17,13 }, { 786,18,12 }, { 723,19,11 }, { 660,20,10 }, { 597,21,9 }, { 534,22,8 }, { 471,23,7 }, { 408,24,6 }, { 345,25,5 }, { 282,26,4 }, { 219,27,3 }, { 156,28,2 }, { 93,29,1 }, { 30,30,0 }, { 976,16,15 }, { 913,17,14 }, { 850,18,13 },
  { 787,19,12 }, { 724,20,11 }, { 661,21,10 }, { 598,22,9 }, { 535,23,8 }, { 472,24,7 }, { 409,25,6 }, { 346,26,5 }, { 283,27,4 }, { 220,28,3 }, { 157,29,2 }, { 94,30,1 }, { 31,31,0 }, { 977,17,15 }, { 914,18,14 }, { 851,19,13 }, { 788,20,12 }, { 725,21,11 }, { 662,22,10 }, { 599,23,9 },
  { 536,24,8 }, { 473,25,7 }, { 410,26,6 }, { 347,27,5 }, { 284,28,4 }, { 221,29,3 }, { 158,30,2 }, { 95,31,1 }, { 32,32,0 }, { 978,18,15 }, { 915,19,14 }, { 852,20,13 }, { 789,21,12 }, { 726,22,11 }, { 663,23,10 }, { 600,24,9 }, { 537,25,8 }, { 474,26,7 }, { 411,27,6 }, { 348,28,5 },
  { 285,29,4 }, { 222,30,3 }, { 159,31,2 }, { 96,32,1 }, { 33,33,0 }, { 979,19,15 }, { 916,20,14 }, { 853,21,13 }, { 790,22,12 }, { 727,23,11 }, { 664,24,10 }, { 601,25,9 }, { 538,26,8 }, { 475,27,7 }, { 412,28,6 }, { 349,29,5 }, { 286,30,4 }, { 223,31,3 }, { 160,32,2 }, { 97,33,1 },
  { 34,34,0 }, { 980,20,15 }, { 917,21,14 }, { 854,22,13 }, { 791,23,12 }, { 728,24,11 }, { 665,25,10 }, { 602,26,9 }, { 539,27,8 }, { 476,28,7 }, { 413,29,6 }, { 350,30,5 }, { 287,31,4 }, { 224,32,3 }, { 161,33,2 }, { 98,34,1 }, { 35,35,0 }, { 981,21,15 }, { 918,22,14 }, { 855,23,13 },
  { 792,24,12 }, { 729,25,11 }, { 666,26,10 }, { 603,27,9 }, { 540,28,8 }, { 477,29,7 }, { 414,30,6 }, { 351,31,5 }, { 288,32,4 }, { 225,33,3 }, { 162,34,2 }, { 99,35,1 }, { 36,36,0 }, { 982,22,15 }, { 919,23,14 }, { 856,24,13 }, { 793,25,12 }, { 730,26,11 }, { 667,27,10 }, { 604,28,9 },
  { 541,29,8 }, { 478,30,7 }, { 415,31,6 }, { 352,32,5 }, { 289,33,4 }, { 226,34,3 }, { 163,35,2 }, { 100,36,1 }, { 37,37,0 }, { 983,23,15 }, { 920,24,14 }, { 857,25,13 }, { 794,26,12 }, { 731,27,11 }, { 668,28,10 }, { 605,29,9 }, { 542,30,8 }, { 479,31,7 }, { 416,32,6 }, { 353,33,5 },
  { 290,34,4 }, { 227,35,3 }, { 164,36,2 }, { 101,37,1 }, { 38,38,0 }, { 984,24,15 }, { 921,25,14 }, { 858,26,13 }, { 795,27,12 }, { 732,28,11 }, { 669,29,10 }, { 606,30,9 }, { 543,31,8 }, { 480,32,7 }, { 417,33,6 }, { 354,34,5 }, { 291,35,4 }, { 228,36,3 }, { 165,37,2 }, { 102,38,1 },
  { 39,39,0 }, { 985,25,15 }, { 922,26,14 }, { 859,27,13 }, { 796,28,12 }, { 733,29,11 }, { 670,30,10 }, { 607,31,9 }, { 544,32,8 }, { 481,33,7 }, { 418,34,6 }, { 355,35,5 }, { 292,36,4 }, { 229,37,3 }, { 166,38,2 }, { 103,39,1 }, { 40,40,0 }, { 986,26,15 }, { 923,27,14 }, { 860,28,13 },
  { 797,29,12 }, { 734,30,11 }, { 671,31,10 }, { 608,32,9 }, { 545,33,8 }, { 482,34,7 }, { 419,35,6 }, { 356,36,5 }, { 293,37,4 }, { 230,38,3 }, { 167,39,2 }, { 104,40,1 }, { 41,41,0 }, { 987,27,15 }, { 924,28,14 }, { 861,29,13 }, { 798,30,12 }, { 735,31,11 }, { 672,32,10 }, { 609,33,9 },
  { 546,34,8 }, { 483,35,7 }, { 420,36,6 }, { 357,37,5 }, { 294,38,4 }, { 231,39,3 }, { 168,40,2 }, { 105,41,1 }, { 42,42,0 }, { 988,28,15 }, { 925,29,14 }, { 862,30,13 }, { 799,31,12 }, { 736,32,11 }, { 673,33,10 }, { 610,34,9 }, { 547,35,8 }, { 484,36,7 }, { 421,37,6 }, { 358,38,5 },
  { 295,39,4 }, { 232,40,3 }, { 169,41,2 }, { 106,42,1 }, { 43,43,0 }, { 989,29,15 }, { 926,30,14 }, { 863,31,13 }, { 800,32,12 }, { 737,33,11 }, { 674,34,10 }, { 611,35,9 }, { 548,36,8 }, { 485,37,7 }, { 422,38,6 }, { 359,39,5 }, { 296,40,4 }, { 233,41,3 }, { 170,42,2 }, { 107,43,1 },
  { 44,44,0 }, { 990,30,15 }, { 927,31,14 }, { 864,32,13 }, { 801,33,12 }, { 738,34,11 }, { 675,35,10 }, { 612,36,9 }, { 549,37,8 }, { 486,38,7 }, { 423,39,6 }, { 360,40,5 }, { 297,41,4 }, { 234,42,3 }, { 171,43,2 }, { 108,44,1 }, { 45,45,0 }, { 991,31,15 }, { 928,32,14 }, { 865,33,13 },
  { 802,34,12 }, { 739,35,11 }, { 676,36,10 }, { 613,37,9 }, { 550,38,8 }, { 487,39,7 }, { 424,40,6 }, { 361,41,5 }, { 298,42,4 }, { 235,43,3 }, { 172,44,2 }, { 109,45,1 }, { 46,46,0 }, { 992,32,15 }, { 929,33,14 }, { 866,34,13 }, { 803,35,12 }, { 740,36,11 }, { 677,37,10 }, { 614,38,9 },
  { 551,39,8 }, { 488,40,7 }, { 425,41,6 }, { 362,42,5 }, { 299,43,4 }, { 236,44,3 }, { 173,45,2 }, { 110,46,1 }, { 47,47,0 }, { 993,33,15 }, { 930,34,14 }, { 867,35,13 }, { 804,36,12 }, { 741,37,11 }, { 678,38,10 }, { 615,39,9 }, { 552,40,8 }, { 489,41,7 }, { 426,42,6 }, { 363,43,5 },
  { 300,44,4 }, { 237,45,3 }, { 174,46,2 }, { 111,47,1 }, { 48,48,0 }, { 994,34,15 }, { 931,35,14 }, { 868,36,13 }, { 805,37,12 }, { 742,38,11 }, { 679,39,10 }, { 616,40,9 }, { 553,41,8 }, { 490,42,7 }, { 427,43,6 }, { 364,44,5 }, { 301,45,4 }, { 238,46,3 }, { 175,47,2 }, { 112,48,1 },
  { 49,49,0 }, { 995,35,15 }, { 932,36,14 }, { 869,37,13 }, { 806,38,12 }, { 743,39,11 }, { 680,40,10 }, { 617,41,9 }, { 554,42,8 }, { 491,43,7 }, { 428,44,6 }, { 365,45,5 }, { 302,46,4 }, { 239,47,3 }, { 176,48,2 }, { 113,49,1 }, { 50,50,0 }, { 996,36,15 }, { 933,37,14 }, { 870,38,13 },
  { 807,39,12 }, { 744,40,11 }, { 681,41,10 }, { 618,42,9 }, { 555,43,8 }, { 492,44,7 }, { 429,45,6 }, { 366,46,5 }, { 303,47,4 }, { 240,48,3 }, { 177,49,2 }, { 114,50,1 }, { 51,51,0 }, { 997,37,15 }, { 934,38,14 }, { 871,39,13 }, { 808,40,12 }, { 745,41,11 }, { 682,42,10 }, { 619,43,9 },
  { 556,44,8 }, { 493,45,7 }, { 430,46,6 }, { 367,47,5 }, { 304,48,4 }, { 241,49,3 }, { 178,50,2 }, { 115,51,1 }, { 52,52,0 }, { 998,38,15 }, { 935,39,14 }, { 872,40,13 }, { 809,41,12 }, { 746,42,11 }, { 683,43,10 }, { 620,44,9 }, { 557,45,8 }, { 494,46,7 }, { 431,47,6 }, { 368,48,5 },
  { 305,49,4 }, { 242,50,3 }, { 179,51,2 }, { 116,52,1 }, { 53,53,0 }, { 999,39,15 }, { 936,40,14 }, { 873,41,13 }, { 810,42,12 }, { 747,43,11 }, { 684,44,10 }, { 621,45,9 }, { 558,46,8 }, { 495,47,7 }, { 432,48,6 }, { 369,49,5 }, { 306,50,4 }, { 243,51,3 }, { 180,52,2 }, { 117,53,1 },
  { 54,54,0 }, { 1000,40,15 }, { 937,41,14 }, { 874,42,13 }, { 811,43,12 }, { 748,44,11 }, { 685,45,10 }, { 622,46,9 }, { 559,47,8 }, { 496,48,7 }, { 433,49,6 }, { 370,50,5 }, { 307,51,4 }, { 244,52,3 }, { 181,53,2 }, { 118,54,1 }, { 55,55,0 }, { 1001,41,15 }, { 938,42,14 }, { 875,43,13 },
  { 812,44,12 }, { 749,45,11 }, { 686,46,10 }, { 623,47,9 }, { 560,48,8 }, { 497,49,7 }, { 434,50,6 }, { 371,51,5 }, { 308,52,4 }, { 245,53,3 }, { 182,54,2 }, { 119,55,1 }, { 56,56,0 }, { 1002,42,15 }, { 939,43,14 }, { 876,44,13 }, { 813,45,12 }, { 750,46,11 }, { 687,47,10 }, { 624,48,9 },
  { 561,49,8 }, { 498,50,7 }, { 435,51,6 }, { 372,52,5 }, { 309,53,4 }, { 246,54,3 }, { 183,55,2 }, { 120,56,1 }, { 57,57,0 }, { 1003,43,15 }, { 940,44,14 }, { 877,45,13 }, { 814,46,12 }, { 751,47,11 }, { 688,48,10 }, { 625,49,9 }, { 562,50,8 }, { 499,51,7 }, { 436,52,6 }, { 373,53,5 },
  { 310,54,4 }, { 247,55,3 }, { 184,56,2 }, { 121,57,1 }, { 58,58,0 }, { 1004,44,15 }, { 941,45,14 }, { 878,46,13 }, { 815,47,12 }, { 752,48,11 }, { 689,49,10 }, { 626,50,9 }, { 563,51,8 }, { 500,52,7 }, { 437,53,6 }, { 374,54,5 }, { 311,55,4 }, { 248,56,3 }, { 185,57,2 }, { 122,58,1 },
  { 59,59,0 }, { 1005,45,15 }, { 942,46,14 }, { 879,47,13 }, { 816,48,12 }, { 753,49,11 }, { 690,50,10 }, { 627,51,9 }, { 564,52,8 }, { 501,53,7 }, { 438,54,6 }, { 375,55,5 }, { 312,56,4 }, { 249,57,3 }, { 186,58,2 }, { 123,59,1 }, { 60,60,0 }, { 1006,46,15 }, { 943,47,14 }, { 880,48,13 },
  { 817,49,12 }, { 754,50,11 }, { 691,51,10 }, { 628,52,9 }, { 565,53,8 }, { 502,54,7 }, { 439,55,6 }, { 376,56,5 }, { 313,57,4 }, { 250,58,3 }, { 187,59,2 }, { 124,60,1 }, { 61,61,0 }, { 1007,47,15 }, { 944,48,14 }, { 881,49,13 }, { 818,50,12 }, { 755,51,11 }, { 692,52,10 }, { 629,53,9 },
  { 566,54,8 }, { 503,55,7 }, { 440,56,6 }, { 377,57,5 }, { 314,58,4 }, { 251,59,3 }, { 188,60,2 }, { 125,61,1 }, { 62,62,0 }, { 1008,48,15 }, { 945,49,14 }, { 882,50,13 }, { 819,51,12 }, { 756,52,11 }, { 693,53,10 }, { 630,54,9 }, { 567,55,8 }, { 504,56,7 }, { 441,57,6 }, { 378,58,5 },
  { 315,59,4 }, { 252,60,3 }, { 189,61,2 }, { 126,62,1 }, { 63,63,0 }, { 1009,49,15 }, { 946,50,14 }, { 883,51,13 }, { 820,52,12 }, { 757,53,11 }, { 694,54,10 }, { 631,55,9 }, { 568,56,8 }, { 505,57,7 }, { 442,58,6 }, { 379,59,5 }, { 316,60,4 }, { 253,61,3 }, { 190,62,2 }, { 127,63,1 },
  { 1010,50,15 }, { 947,51,14 }, { 884,52,13 }, { 821,53,12 }, { 758,54,11 }, { 695,55,10 }, { 632,56,9 }, { 569,57,8 }, { 506,58,7 }, { 443,59,6 }, { 380,60,5 }, { 317,61,4 }, { 254,62,3 }, { 191,63,2 }, { 1011,51,15 }, { 948,52,14 }, { 885,53,13 }, { 822,54,12 }, { 759,55,11 }, { 696,56,10 },
  { 633,57,9 }, { 570,58,8 }, { 507,59,7 }, { 444,60,6 }, { 381,61,5 }, { 318,62,4 }, { 255,63,3 }, { 1012,52,15 }, { 949,53,14 }, { 886,54,13 }, { 823,55,12 }, { 760,56,11 }, { 697,57,10 }, { 634,58,9 }, { 571,59,8 }, { 508,60,7 }, { 445,61,6 }, { 382,62,5 }, { 319,63,4 }, { 1013,53,15 },
  { 950,54,14 }, { 887,55,13 }, { 824,56,12 }, { 761,57,11 }, { 698,58,10 }, { 635,59,9 }, { 572,60,8 }, { 509,61,7 }, { 446,62,6 }, { 383,63,5 }, { 1014,54,15 }, { 951,55,14 }, { 888,56,13 }, { 825,57,12 }, { 762,58,11 }, { 699,59,10 }, { 636,60,9 }, { 573,61,8 }, { 510,62,7 }, { 447,63,6 },
  { 1015,55,15 }, { 952,56,14 }, { 889,57,13 }, { 826,58,12 }, { 763,59,11 }, { 700,60,10 }, { 637,61,9 }, { 574,62,8 }, { 511,63,7 }, { 1016,56,15 }, { 953,57,14 }, { 890,58,13 }, { 827,59,12 }, { 764,60,11 }, { 701,61,10 }, { 638,62,9 }, { 575,63,8 }, { 1017,57,15 }, { 954,58,14 }, { 891,59,13 },
  { 828,60,12 }, { 765,61,11 }, { 702,62,10 }, { 639,63,9 }, { 1018,58,15 }, { 955,59,14 }, { 892,60,13 }, { 829,61,12 }, { 766,62,11 }, { 703,63,10 }, { 1019,59,15 }, { 956,60,14 }, { 893,61,13 }, { 830,62,12 }, { 767,63,11 }, { 1020,60,15 }, { 957,61,14 }, { 894,62,13 }, { 831,63,12 }, { 1021,61,15 },
  { 958,62,14 }, { 895,63,13 }, { 1022,62,15 }, { 959,63,14 }, { 1023,63,15 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 128,0,2 }, { 65,1,1 }, { 2,2,0 }, { 192,0,3 }, { 129,1,2 }, { 66,2,1 }, { 3,3,0 }, { 256,0,4 }, { 193,1,3 }, { 130,2,2 }, { 67,3,1 }, { 4,4,0 },
  { 320,0,5 }, { 257,1,4 }, { 194,2,3 }, { 131,3,2 }, { 68,4,1 }, { 5,5,0 }, { 384,0,6 }, { 321,1,5 }, { 258,2,4 }, { 195,3,3 }, { 132,4,2 }, { 69,5,1 }, { 6,6,0 }, { 448,0,7 }, { 385,1,6 }, { 322,2,5 }, { 259,3,4 }, { 196,4,3 }, { 133,5,2 }, { 70,6,1 },
  { 7,7,0 }, { 512,0,8 }, { 449,1,7 }, { 386,2,6 }, { 323,3,5 }, { 260,4,4 }, { 197,5,3 }, { 134,6,2 }, { 71,7,1 }, { 8,8,0 }, { 576,0,9 }, { 513,1,8 }, { 450,2,7 }, { 387,3,6 }, { 324,4,5 }, { 261,5,4 }, { 198,6,3 }, { 135,7,2 }, { 72,8,1 }, { 9,9,0 },
  { 640,0,10 }, { 577,1,9 }, { 514,2,8 }, { 451,3,7 }, { 388,4,6 }, { 325,5,5 }, { 262,6,4 }, { 199,7,3 }, { 136,8,2 }, { 73,9,1 }, { 10,10,0 }, { 704,0,11 }, { 641,1,10 }, { 578,2,9 }, { 515,3,8 }, { 452,4,7 }, { 389,5,6 }, { 326,6,5 }, { 263,7,4 }, { 200,8,3 },
  { 137,9,2 }, { 74,10,1 }, { 11,11,0 }, { 768,0,12 }, { 705,1,11 }, { 642,2,10 }, { 579,3,9 }, { 516,4,8 }, { 453,5,7 }, { 390,6,6 }, { 327,7,5 }, { 264,8,4 }, { 201,9,3 }, { 138,10,2 }, { 75,11,1 }, { 12,12,0 }, { 832,0,13 }, { 769,1,12 }, { 706,2,11 }, { 643,3,10 },
  { 580,4,9 }, { 517,5,8 }, { 454,6,7 }, { 391,7,6 }, { 328,8,5 }, { 265,9,4 }, { 202,10,3 }, { 139,11,2 }, { 76,12,1 }, { 13,13,0 }, { 896,0,14 }, { 833,1,13 }, { 770,2,12 }, { 707,3,11 }, { 644,4,10 }, { 581,5,9 }, { 518,6,8 }, { 455,7,7 }, { 392,8,6 }, { 329,9,5 },
  { 266,10,4 }, { 203,11,3 }, { 140,12,2 }, { 77,13,1 }, { 14,14,0 }, { 960,0,15 }, { 897,1,14 }, { 834,2,13 }, { 771,3,12 }, { 708,4,11 }, { 645,5,10 }, { 582,6,9 }, { 519,7,8 }, { 456,8,7 }, { 393,9,6 }, { 330,10,5 }, { 267,11,4 }, { 204,12,3 }, { 141,13,2 }, { 78,14,1 },
  { 15,15,0 }, { 1024,0,16 }, { 961,1,15 }, { 898,2,14 }, { 835,3,13 }, { 772,4,12 }, { 709,5,11 }, { 646,6,10 }, { 583,7,9 }, { 520,8,8 }, { 457,9,7 }, { 394,10,6 }, { 331,11,5 }, { 268,12,4 }, { 205,13,3 }, { 142,14,2 }, { 79,15,1 }, { 16,16,0 }, { 1088,0,17 }, { 1025,1,16 },
  { 962,2,15 }, { 899,3,14 }, { 836,4,13 }, { 773,5,12 }, { 710,6,11 }, { 647,7,10 }, { 584,8,9 }, { 521,9,8 }, { 458,10,7 }, { 395,11,6 }, { 332,12,5 }, { 269,13,4 }, { 206,14,3 }, { 143,15,2 }, { 80,16,1 }, { 17,17,0 }, { 1152,0,18 }, { 1089,1,17 }, { 1026,2,16 }, { 963,3,15 },
  { 900,4,14 }, { 837,5,13 }, { 774,6,12 }, { 711,7,11 }, { 648,8,10 }, { 585,9,9 }, { 522,10,8 }, { 459,11,7 }, { 396,12,6 }, { 333,13,5 }, { 270,14,4 }, { 207,15,3 }, { 144,16,2 }, { 81,17,1 }, { 18,18,0 }, { 1216,0,19 }, { 1153,1,18 }, { 1090,2,17 }, { 1027,3,16 }, { 964,4,15 },
  { 901,5,14 }, { 838,6,13 }, { 775,7,12 }, { 712,8,11 }, { 649,9,10 }, { 586,10,9 }, { 523,11,8 }, { 460,12,7 }, { 397,13,6 }, { 334,14,5 }, { 271,15,4 }, { 208,16,3 }, { 145,17,2 }, { 82,18,1 }, { 19,19,0 }, { 1280,0,20 }, { 1217,1,19 }, { 1154,2,18 }, { 1091,3,17 }, { 1028,4,16 },
  { 965,5,15 }, { 902,6,14 }, { 839,7,13 }, { 776,8,12 }, { 713,9,11 }, { 650,10,10 }, { 587,11,9 }, { 524,12,8 }, { 461,13,7 }, { 398,14,6 }, { 335,15,5 }, { 272,16,4 }, { 209,17,3 }, { 146,18,2 }, { 83,19,1 }, { 20,20,0 }, { 1344,0,21 }, { 1281,1,20 }, { 1218,2,19 }, { 1155,3,18 },
  { 1092,4,17 }, { 1029,5,16 }, { 966,6,15 }, { 903,7,14 }, { 840,8,13 }, { 777,9,12 }, { 714,10,11 }, { 651,11,10 }, { 588,12,9 }, { 525,13,8 }, { 462,14,7 }, { 399,15,6 }, { 336,16,5 }, { 273,17,4 }, { 210,18,3 }, { 147,19,2 }, { 84,20,1 }, { 21,21,0 }, { 1408,0,22 }, { 1345,1,21 },
  { 1282,2,20 }, { 1219,3,19 }, { 1156,4,18 }, { 1093,5,17 }, { 1030,6,16 }, { 967,7,15 }, { 904,8,14 }, { 841,9,13 }, { 778,10,12 }, { 715,11,11 }, { 652,12,10 }, { 589,13,9 }, { 526,14,8 }, { 463,15,7 }, { 400,16,6 }, { 337,17,5 }, { 274,18,4 }, { 211,19,3 }, { 148,20,2 }, { 85,21,1 },
  { 22,22,0 }, { 1472,0,23 }, { 1409,1,22 }, { 1346,2,21 }, { 1283,3,20 }, { 1220,4,19 }, { 1157,5,18 }, { 1094,6,17 }, { 1031,7,16 }, { 968,8,15 }, { 905,9,14 }, { 842,10,13 }, { 779,11,12 }, { 716,12,11 }, { 653,13,10 }, { 590,14,9 }, { 527,15,8 }, { 464,16,7 }, { 401,17,6 }, { 338,18,5 },
  { 275,19,4 }, { 212,20,3 }, { 149,21,2 }, { 86,22,1 }, { 23,23,0 }, { 1536,0,24 }, { 1473,1,23 }, { 1410,2,22 }, { 1347,3,21 }, { 1284,4,20 }, { 1221,5,19 }, { 1158,6,18 }, { 1095,7,17 }, { 1032,8,16 }, { 969,9,15 }, { 906,10,14 }, { 843,11,13 }, { 780,12,12 }, { 717,13,11 }, { 654,14,10 },
  { 591,15,9 }, { 528,16,8 }, { 465,17,7 }, { 402,18,6 }, { 339,19,5 }, { 276,20,4 }, { 213,21,3 }, { 150,22,2 }, { 87,23,1 }, { 24,24,0 }, { 1600,0,25 }, { 1537,1,24 }, { 1474,2,23 }, { 1411,3,22 }, { 1348,4,21 }, { 1285,5,20 }, { 1222,6,19 }, { 1159,7,18 }, { 1096,8,17 }, { 1033,9,16 },
  { 970,10,15 }, { 907,11,14 }, { 844,12,13 }, { 781,13,12 }, { 718,14,11 }, { 655,15,10 }, { 592,16,9 }, { 529,17,8 }, { 466,18,7 }, { 403,19,6 }, { 340,20,5 }, { 277,21,4 }, { 214,22,3 }, { 151,23,2 }, { 88,24,1 }, { 25,25,0 }, { 1664,0,26 }, { 1601,1,25 }, { 1538,2,24 }, { 1475,3,23 },
  { 1412,4,22 }, { 1349,5,21 }, { 1286,6,20 }, { 1223,7,19 }, { 1160,8,18 }, { 1097,9,17 }, { 1034,10,16 }, { 971,11,15 }, { 908,12,14 }, { 845,13,13 }, { 782,14,12 }, { 719,15,11 }, { 656,16,10 }, { 593,17,9 }, { 530,18,8 }, { 467,19,7 }, { 404,20,6 }, { 341,21,5 }, { 278,22,4 }, { 215,23,3 },
  { 152,24,2 }, { 89,25,1 }, { 26,26,0 }, { 1728,0,27 }, { 1665,1,26 }, { 1602,2,25 }, { 1539,3,24 }, { 1476,4,23 }, { 1413,5,22 }, { 1350,6,21 }, { 1287,7,20 }, { 1224,8,19 }, { 1161,9,18 }, { 1098,10,17 }, { 1035,11,16 }, { 972,12,15 }, { 909,13,14 }, { 846,14,13 }, { 783,15,12 }, { 720,16,11 },
  { 657,17,10 }, { 594,18,9 }, { 531,19,8 }, { 468,20,7 }, { 405,21,6 }, { 342,22,5 }, { 279,23,4 }, { 216,24,3 }, { 153,25,2 }, { 90,26,1 }, { 27,27,0 }, { 1792,0,28 }, { 1729,1,27 }, { 1666,2,26 }, { 1603,3,25 }, { 1540,4,24 }, { 1477,5,23 }, { 1414,6,22 }, { 1351,7,21 }, { 1288,8,20 },
  { 1225,9,19 }, { 1162,10,18 }, { 1099,11,17 }, { 1036,12,16 }, { 973,13,15 }, { 910,14,14 }, { 847,15,13 }, { 784,16,12 }, { 721,17,11 }, { 658,18,10 }, { 595,19,9 }, { 532,20,8 }, { 469,21,7 }, { 406,22,6 }, { 343,23,5 }, { 280,24,4 }, { 217,25,3 }, { 154,26,2 }, { 91,27,1 }, { 28,28,0 },
  { 1856,0,29 }, { 1793,1,28 }, { 1730,2,27 }, { 1667,3,26 }, { 1604,4,25 }, { 1541,5,24 }, { 1478,6,23 }, { 1415,7,22 }, { 1352,8,21 }, { 1289,9,20 }, { 1226,10,19 }, { 1163,11,18 }, { 1100,12,17 }, { 1037,13,16 }, { 974,14,15 }, { 911,15,14 }, { 848,16,13 }, { 785,17,12 }, { 722,18,11 }, { 659,19,10 },
  { 596,20,9 }, { 533,21,8 }, { 470,22,7 }, { 407,23,6 }, { 344,24,5 }, { 281,25,4 }, { 218,26,3 }, { 155,27,2 }, { 92,28,1 }, { 29,29,0 }, { 1920,0,30 }, { 1857,1,29 }, { 1794,2,28 }, { 1731,3,27 }, { 1668,4,26 }, { 1605,5,25 }, { 1542,6,24 }, { 1479,7,23 }, { 1416,8,22 }, { 1353,9,21 },
  { 1290,10,20 }, { 1227,11,19 }, { 1164,12,18 }, { 1101,13,17 }, { 1038,14,16 }, { 975,15,15 }, { 912,16,14 }, { 849,17,13 }, { 786,18,12 }, { 723,19,11 }, { 660,20,10 }, { 597,21,9 }, { 534,22,8 }, { 471,23,7 }, { 408,24,6 }, { 345,25,5 }, { 282,26,4 }, { 219,27,3 }, { 156,28,2 }, { 93,29,1 },
  { 30,30,0 }, { 1984,0,31 }, { 1921,1,30 }, { 1858,2,29 }, { 1795,3,28 }, { 1732,4,27 }, { 1669,5,26 }, { 1606,6,25 }, { 1543,7,24 }, { 1480,8,23 }, { 1417,9,22 }, { 1354,10,21 }, { 1291,11,20 }, { 1228,12,19 }, { 1165,13,18 }, { 1102,14,17 }, { 1039,15,16 }, { 976,16,15 }, { 913,17,14 }, { 850,18,13 },
  { 787,19,12 }, { 724,20,11 }, { 661,21,10 }, { 598,22,9 }, { 535,23,8 }, { 472,24,7 }, { 409,25,6 }, { 346,26,5 }, { 283,27,4 }, { 220,28,3 }, { 157,29,2 }, { 94,30,1 }, { 31,31,0 }, { 1985,1,31 }, { 1922,2,30 }, { 1859,3,29 }, { 1796,4,28 }, { 1733,5,27 }, { 1670,6,26 }, { 1607,7,25 },
  { 1544,8,24 }, { 1481,9,23 }, { 1418,10,22 }, { 1355,11,21 }, { 1292,12,20 }, { 1229,13,19 }, { 1166,14,18 }, { 1103,15,17 }, { 1040,16,16 }, { 977,17,15 }, { 914,18,14 }, { 851,19,13 }, { 788,20,12 }, { 725,21,11 }, { 662,22,10 }, { 599,23,9 }, { 536,24,8 }, { 473,25,7 }, { 410,26,6 }, { 347,27,5 },
  { 284,28,4 }, { 221,29,3 }, { 158,30,2 }, { 95,31,1 }, { 32,32,0 }, { 1986,2,31 }, { 1923,3,30 }, { 1860,4,29 }, { 1797,5,28 }, { 1734,6,27 }, { 1671,7,26 }, { 1608,8,25 }, { 1545,9,24 }, { 1482,10,23 }, { 1419,11,22 }, { 1356,12,21 }, { 1293,13,20 }, { 1230,14,19 }, { 1167,15,18 }, { 1104,16,17 },
  { 1041,17,16 }, { 978,18,15 }, { 915,19,14 }, { 852,20,13 }, { 789,21,12 }, { 726,22,11 }, { 663,23,10 }, { 600,24,9 }, { 537,25,8 }, { 474,26,7 }, { 411,27,6 }, { 348,28,5 }, { 285,29,4 }, { 222,30,3 }, { 159,31,2 }, { 96,32,1 }, { 33,33,0 }, { 1987,3,31 }, { 1924,4,30 }, { 1861,5,29 },
  { 1798,6,28 }, { 1735,7,27 }, { 1672,8,26 }, { 1609,9,25 }, { 1546,10,24 }, { 1483,11,23 }, { 1420,12,22 }, { 1357,13,21 }, { 1294,14,20 }, { 1231,15,19 }, { 1168,16,18 }, { 1105,17,17 }, { 1042,18,16 }, { 979,19,15 }, { 916,20,14 }, { 853,21,13 }, { 790,22,12 }, { 727,23,11 }, { 664,24,10 }, { 601,25,9 },
  { 538,26,8 }, { 475,27,7 }, { 412,28,6 }, { 349,29,5 }, { 286,30,4 }, { 223,31,3 }, { 160,32,2 }, { 97,33,1 }, { 34,34,0 }, { 1988,4,31 }, { 1925,5,30 }, { 1862,6,29 }, { 1799,7,28 }, { 1736,8,27 }, { 1673,9,26 }, { 1610,10,25 }, { 1547,11,24 }, { 1484,12,23 }, { 1421,13,22 }, { 1358,14,21 },
  { 1295,15,20 }, { 1232,16,19 }, { 1169,17,18 }, { 1106,18,17 }, { 1043,19,16 }, { 980,20,15 }, { 917,21,14 }, { 854,22,13 }, { 791,23,12 }, { 728,24,11 }, { 665,25,10 }, { 602,26,9 }, { 539,27,8 }, { 476,28,7 }, { 413,29,6 }, { 350,30,5 }, { 287,31,4 }, { 224,32,3 }, { 161,33,2 }, { 98,34,1 },
  { 35,35,0 }, { 1989,5,31 }, { 1926,6,30 }, { 1863,7,29 }, { 1800,8,28 }, { 1737,9,27 }, { 1674,10,26 }, { 1611,11,25 }, { 1548,12,24 }, { 1485,13,23 }, { 1422,14,22 }, { 1359,15,21 }, { 1296,16,20 }, { 1233,17,19 }, { 1170,18,18 }, { 1107,19,17 }, { 1044,20,16 }, { 981,21,15 }, { 918,22,14 }, { 855,23,13 },
  { 792,24,12 }, { 729,25,11 }, { 666,26,10 }, { 603,27,9 }, { 540,28,8 }, { 477,29,7 }, { 414,30,6 }, { 351,31,5 }, { 288,32,4 }, { 225,33,3 }, { 162,34,2 }, { 99,35,1 }, { 36,36,0 }, { 1990,6,31 }, { 1927,7,30 }, { 1864,8,29 }, { 1801,9,28 }, { 1738,10,27 }, { 1675,11,26 }, { 1612,12,25 },
  { 1549,13,24 }, { 1486,14,23 }, { 1423,15,22 }, { 1360,16,21 }, { 1297,17,20 }, { 1234,18,19 }, { 1171,19,18 }, { 1108,20,17 }, { 1045,21,16 }, { 982,22,15 }, { 919,23,14 }, { 856,24,13 }, { 793,25,12 }, { 730,26,11 }, { 667,27,10 }, { 604,28,9 }, { 541,29,8 }, { 478,30,7 }, { 415,31,6 }, { 352,32,5 },
  { 289,33,4 }, { 226,34,3 }, { 163,35,2 }, { 100,36,1 }, { 37,37,0 }, { 1991,7,31 }, { 1928,8,30 }, { 1865,9,29 }, { 1802,10,28 }, { 1739,11,27 }, { 1676,12,26 }, { 1613,13,25 }, { 1550,14,24 }, { 1487,15,23 }, { 1424,16,22 }, { 1361,17,21 }, { 1298,18,20 }, { 1235,19,19 }, { 1172,20,18 }, { 1109,21,17 },
  { 1046,22,16 }, { 983,23,15 }, { 920,24,14 }, { 857,25,13 }, { 794,26,12 }, { 731,27,11 }, { 668,28,10 }, { 605,29,9 }, { 542,30,8 }, { 479,31,7 }, { 416,32,6 }, { 353,33,5 }, { 290,34,4 }, { 227,35,3 }, { 164,36,2 }, { 101,37,1 }, { 38,38,0 }, { 1992,8,31 }, { 1929,9,30 }, { 1866,10,29 },
  { 1803,11,28 }, { 1740,12,27 }, { 1677,13,26 }, { 1614,14,25 }, { 1551,15,24 }, { 1488,16,23 }, { 1425,17,22 }, { 1362,18,21 }, { 1299,19,20 }, { 1236,20,19 }, { 1173,21,18 }, { 1110,22,17 }, { 1047,23,16 }, { 984,24,15 }, { 921,25,14 }, { 858,26,13 }, { 795,27,12 }, { 732,28,11 }, { 669,29,10 }, { 606,30,9 },
  { 543,31,8 }, { 480,32,7 }, { 417,33,6 }, { 354,34,5 }, { 291,35,4 }, { 228,36,3 }, { 165,37,2 }, { 102,38,1 }, { 39,39,0 }, { 1993,9,31 }, { 1930,10,30 }, { 1867,11,29 }, { 1804,12,28 }, { 1741,13,27 }, { 1678,14,26 }, { 1615,15,25 }, { 1552,16,24 }, { 1489,17,23 }, { 1426,18,22 }, { 1363,19,21 },
  { 1300,20,20 }, { 1237,21,19 }, { 1174,22,18 }, { 1111,23,17 }, { 1048,24,16 }, { 985,25,15 }, { 922,26,14 }, { 859,27,13 }, { 796,28,12 }, { 733,29,11 }, { 670,30,10 }, { 607,31,9 }, { 544,32,8 }, { 481,33,7 }, { 418,34,6 }, { 355,35,5 }, { 292,36,4 }, { 229,37,3 }, { 166,38,2 }, { 103,39,1 },
  { 40,40,0 }, { 1994,10,31 }, { 1931,11,30 }, { 1868,12,29 }, { 1805,13,28 }, { 1742,14,27 }, { 1679,15,26 }, { 1616,16,25 }, { 1553,17,24 }, { 1490,18,23 }, { 1427,19,22 }, { 1364,20,21 }, { 1301,21,20 }, { 1238,22,19 }, { 1175,23,18 }, { 1112,24,17 }, { 1049,25,16 }, { 986,26,15 }, { 923,27,14 }, { 860,28,13 },
  { 797,29,12 }, { 734,30,11 }, { 671,31,10 }, { 608,32,9 }, { 545,33,8 }, { 482,34,7 }, { 419,35,6 }, { 356,36,5 }, { 293,37,4 }, { 230,38,3 }, { 167,39,2 }, { 104,40,1 }, { 41,41,0 }, { 1995,11,31 }, { 1932,12,30 }, { 1869,13,29 }, { 1806,14,28 }, { 1743,15,27 }, { 1680,16,26 }, { 1617,17,25 },
  { 1554,18,24 }, { 1491,19,23 }, { 1428,20,22 }, { 1365,21,21 }, { 1302,22,20 }, { 1239,23,19 }, { 1176,24,18 }, { 1113,25,17 }, { 1050,26,16 }, { 987,27,15 }, { 924,28,14 }, { 861,29,13 }, { 798,30,12 }, { 735,31,11 }, { 672,32,10 }, { 609,33,9 }, { 546,34,8 }, { 483,35,7 }, { 420,36,6 }, { 357,37,5 },
  { 294,38,4 }, { 231,39,3 }, { 168,40,2 }, { 105,41,1 }, { 42,42,0 }, { 1996,12,31 }, { 1933,13,30 }, { 1870,14,29 }, { 1807,15,28 }, { 1744,16,27 }, { 1681,17,26 }, { 1618,18,25 }, { 1555,19,24 }, { 1492,20,23 }, { 1429,21,22 }, { 1366,22,21 }, { 1303,23,20 }, { 1240,24,19 }, { 1177,25,18 }, { 1114,26,17 },
  { 1051,27,16 }, { 988,28,15 }, { 925,29,14 }, { 862,30,13 }, { 799,31,12 }, { 736,32,11 }, { 673,33,10 }, { 610,34,9 }, { 547,35,8 }, { 484,36,7 }, { 421,37,6 }, { 358,38,5 }, { 295,39,4 }, { 232,40,3 }, { 169,41,2 }, { 106,42,1 }, { 43,43,0 }, { 1997,13,31 }, { 1934,14,30 }, { 1871,15,29 },
  { 1808,16,28 }, { 1745,17,27 }, { 1682,18,26 }, { 1619,19,25 }, { 1556,20,24 }, { 1493,21,23 }, { 1430,22,22 }, { 1367,23,21 }, { 1304,24,20 }, { 1241,25,19 }, { 1178,26,18 }, { 1115,27,17 }, { 1052,28,16 }, { 989,29,15 }, { 926,30,14 }, { 863,31,13 }, { 800,32,12 }, { 737,33,11 }, { 674,34,10 }, { 611,35,9 },
  { 548,36,8 }, { 485,37,7 }, { 422,38,6 }, { 359,39,5 }, { 296,40,4 }, { 233,41,3 }, { 170,42,2 }, { 107,43,1 }, { 44,44,0 }, { 1998,14,31 }, { 1935,15,30 }, { 1872,16,29 }, { 1809,17,28 }, { 1746,18,27 }, { 1683,19,26 }, { 1620,20,25 }, { 1557,21,24 }, { 1494,22,23 }, { 1431,23,22 }, { 1368,24,21 },
  { 1305,25,20 }, { 1242,26,19 }, { 1179,27,18 }, { 1116,28,17 }, { 1053,29,16 }, { 990,30,15 }, { 927,31,14 }, { 864,32,13 }, { 801,33,12 }, { 738,34,11 }, { 675,35,10 }, { 612,36,9 }, { 549,37,8 }, { 486,38,7 }, { 423,39,6 }, { 360,40,5 }, { 297,41,4 }, { 234,42,3 }, { 171,43,2 }, { 108,44,1 },
  { 45,45,0 }, { 1999,15,31 }, { 1936,16,30 }, { 1873,17,29 }, { 1810,18,28 }, { 1747,19,27 }, { 1684,20,26 }, { 1621,21,25 }, { 1558,22,24 }, { 1495,23,23 }, { 1432,24,22 }, { 1369,25,21 }, { 1306,26,20 }, { 1243,27,19 }, { 1180,28,18 }, { 1117,29,17 }, { 1054,30,16 }, { 991,31,15 }, { 928,32,14 }, { 865,33,13 },
  { 802,34,12 }, { 739,35,11 }, { 676,36,10 }, { 613,37,9 }, { 550,38,8 }, { 487,39,7 }, { 424,40,6 }, { 361,41,5 }, { 298,42,4 }, { 235,43,3 }, { 172,44,2 }, { 109,45,1 }, { 46,46,0 }, { 2000,16,31 }, { 1937,17,30 }, { 1874,18,29 }, { 1811,19,28 }, { 1748,20,27 }, { 1685,21,26 }, { 1622,22,25 },
  { 1559,23,24 }, { 1496,24,23 }, { 1433,25,22 }, { 1370,26,21 }, { 1307,27,20 }, { 1244,28,19 }, { 1181,29,18 }, { 1118,30,17 }, { 1055,31,16 }, { 992,32,15 }, { 929,33,14 }, { 866,34,13 }, { 803,35,12 }, { 740,36,11 }, { 677,37,10 }, { 614,38,9 }, { 551,39,8 }, { 488,40,7 }, { 425,41,6 }, { 362,42,5 },
  { 299,43,4 }, { 236,44,3 }, { 173,45,2 }, { 110,46,1 }, { 47,47,0 }, { 2001,17,31 }, { 1938,18,30 }, { 1875,19,29 }, { 1812,20,28 }, { 1749,21,27 }, { 1686,22,26 }, { 1623,23,25 }, { 1560,24,24 }, { 1497,25,23 }, { 1434,26,22 }, { 1371,27,21 }, { 1308,28,20 }, { 1245,29,19 }, { 1182,30,18 }, { 1119,31,17 },
  { 1056,32,16 }, { 993,33,15 }, { 930,34,14 }, { 867,35,13 }, { 804,36,12 }, { 741,37,11 }, { 678,38,10 }, { 615,39,9 }, { 552,40,8 }, { 489,41,7 }, { 426,42,6 }, { 363,43,5 }, { 300,44,4 }, { 237,45,3 }, { 174,46,2 }, { 111,47,1 }, { 48,48,0 }, { 2002,18,31 }, { 1939,19,30 }, { 1876,20,29 },
  { 1813,21,28 }, { 1750,22,27 }, { 1687,23,26 }, { 1624,24,25 }, { 1561,25,24 }, { 1498,26,23 }, { 1435,27,22 }, { 1372,28,21 }, { 1309,29,20 }, { 1246,30,19 }, { 1183,31,18 }, { 1120,32,17 }, { 1057,33,16 }, { 994,34,15 }, { 931,35,14 }, { 868,36,13 }, { 805,37,12 }, { 742,38,11 }, { 679,39,10 }, { 616,40,9 },
  { 553,41,8 }, { 490,42,7 }, { 427,43,6 }, { 364,44,5 }, { 301,45,4 }, { 238,46,3 }, { 175,47,2 }, { 112,48,1 }, { 49,49,0 }, { 2003,19,31 }, { 1940,20,30 }, { 1877,21,29 }, { 1814,22,28 }, { 1751,23,27 }, { 1688,24,26 }, { 1625,25,25 }, { 1562,26,24 }, { 1499,27,23 }, { 1436,28,22 }, { 1373,29,21 },
  { 1310,30,20 }, { 1247,31,19 }, { 1184,32,18 }, { 1121,33,17 }, { 1058,34,16 }, { 995,35,15 }, { 932,36,14 }, { 869,37,13 }, { 806,38,12 }, { 743,39,11 }, { 680,40,10 }, { 617,41,9 }, { 554,42,8 }, { 491,43,7 }, { 428,44,6 }, { 365,45,5 }, { 302,46,4 }, { 239,47,3 }, { 176,48,2 }, { 113,49,1 },
  { 50,50,0 }, { 2004,20,31 }, { 1941,21,30 }, { 1878,22,29 }, { 1815,23,28 }, { 1752,24,27 }, { 1689,25,26 }, { 1626,26,25 }, { 1563,27,24 }, { 1500,28,23 }, { 1437,29,22 }, { 1374,30,21 }, { 1311,31,20 }, { 1248,32,19 }, { 1185,33,18 }, { 1122,34,17 }, { 1059,35,16 }, { 996,36,15 }, { 933,37,14 }, { 870,38,13 },
  { 807,39,12 }, { 744,40,11 }, { 681,41,10 }, { 618,42,9 }, { 555,43,8 }, { 492,44,7 }, { 429,45,6 }, { 366,46,5 }, { 303,47,4 }, { 240,48,3 }, { 177,49,2 }, { 114,50,1 }, { 51,51,0 }, { 2005,21,31 }, { 1942,22,30 }, { 1879,23,29 }, { 1816,24,28 }, { 1753,25,27 }, { 1690,26,26 }, { 1627,27,25 },
  { 1564,28,24 }, { 1501,29,23 }, { 1438,30,22 }, { 1375,31,21 }, { 1312,32,20 }, { 1249,33,19 }, { 1186,34,18 }, { 1123,35,17 }, { 1060,36,16 }, { 997,37,15 }, { 934,38,14 }, { 871,39,13 }, { 808,40,12 }, { 745,41,11 }, { 682,42,10 }, { 619,43,9 }, { 556,44,8 }, { 493,45,7 }, { 430,46,6 }, { 367,47,5 },
  { 304,48,4 }, { 241,49,3 }, { 178,50,2 }, { 115,51,1 }, { 52,52,0 }, { 2006,22,31 }, { 1943,23,30 }, { 1880,24,29 }, { 1817,25,28 }, { 1754,26,27 }, { 1691,27,26 }, { 1628,28,25 }, { 1565,29,24 }, { 1502,30,23 }, { 1439,31,22 }, { 1376,32,21 }, { 1313,33,20 }, { 1250,34,19 }, { 1187,35,18 }, { 1124,36,17 },
  { 1061,37,16 }, { 998,38,15 }, { 935,39,14 }, { 872,40,13 }, { 809,41,12 }, { 746,42,11 }, { 683,43,10 }, { 620,44,9 }, { 557,45,8 }, { 494,46,7 }, { 431,47,6 }, { 368,48,5 }, { 305,49,4 }, { 242,50,3 }, { 179,51,2 }, { 116,52,1 }, { 53,53,0 }, { 2007,23,31 }, { 1944,24,30 }, { 1881,25,29 },
  { 1818,26,28 }, { 1755,27,27 }, { 1692,28,26 }, { 1629,29,25 }, { 1566,30,24 }, { 1503,31,23 }, { 1440,32,22 }, { 1377,33,21 }, { 1314,34,20 }, { 1251,35,19 }, { 1188,36,18 }, { 1125,37,17 }, { 1062,38,16 }, { 999,39,15 }, { 936,40,14 }, { 873,41,13 }, { 810,42,12 }, { 747,43,11 }, { 684,44,10 }, { 621,45,9 },
  { 558,46,8 }, { 495,47,7 }, { 432,48,6 }, { 369,49,5 }, { 306,50,4 }, { 243,51,3 }, { 180,52,2 }, { 117,53,1 }, { 54,54,0 }, { 2008,24,31 }, { 1945,25,30 }, { 1882,26,29 }, { 1819,27,28 }, { 1756,28,27 }, { 1693,29,26 }, { 1630,30,25 }, { 1567,31,24 }, { 1504,32,23 }, { 1441,33,22 }, { 1378,34,21 },
  { 1315,35,20 }, { 1252,36,19 }, { 1189,37,18 }, { 1126,38,17 }, { 1063,39,16 }, { 1000,40,15 }, { 937,41,14 }, { 874,42,13 }, { 811,43,12 }, { 748,44,11 }, { 685,45,10 }, { 622,46,9 }, { 559,47,8 }, { 496,48,7 }, { 433,49,6 }, { 370,50,5 }, { 307,51,4 }, { 244,52,3 }, { 181,53,2 }, { 118,54,1 },
  { 55,55,0 }, { 2009,25,31 }, { 1946,26,30 }, { 1883,27,29 }, { 1820,28,28 }, { 1757,29,27 }, { 1694,30,26 }, { 1631,31,25 }, { 1568,32,24 }, { 1505,33,23 }, { 1442,34,22 }, { 1379,35,21 }, { 1316,36,20 }, { 1253,37,19 }, { 1190,38,18 }, { 1127,39,17 }, { 1064,40,16 }, { 1001,41,15 }, { 938,42,14 }, { 875,43,13 },
  { 812,44,12 }, { 749,45,11 }, { 686,46,10 }, { 623,47,9 }, { 560,48,8 }, { 497,49,7 }, { 434,50,6 }, { 371,51,5 }, { 308,52,4 }, { 245,53,3 }, { 182,54,2 }, { 119,55,1 }, { 56,56,0 }, { 2010,26,31 }, { 1947,27,30 }, { 1884,28,29 }, { 1821,29,28 }, { 1758,30,27 }, { 1695,31,26 }, { 1632,32,25 },
  { 1569,33,24 }, { 1506,34,23 }, { 1443,35,22 }, { 1380,36,21 }, { 1317,37,20 }, { 1254,38,19 }, { 1191,39,18 }, { 1128,40,17 }, { 1065,41,16 }, { 1002,42,15 }, { 939,43,14 }, { 876,44,13 }, { 813,45,12 }, { 750,46,11 }, { 687,47,10 }, { 624,48,9 }, { 561,49,8 }, { 498,50,7 }, { 435,51,6 }, { 372,52,5 },
  { 309,53,4 }, { 246,54,3 }, { 183,55,2 }, { 120,56,1 }, { 57,57,0 }, { 2011,27,31 }, { 1948,28,30 }, { 1885,29,29 }, { 1822,30,28 }, { 1759,31,27 }, { 1696,32,26 }, { 1633,33,25 }, { 1570,34,24 }, { 1507,35,23 }, { 1444,36,22 }, { 1381,37,21 }, { 1318,38,20 }, { 1255,39,19 }, { 1192,40,18 }, { 1129,41,17 },
  { 1066,42,16 }, { 1003,43,15 }, { 940,44,14 }, { 877,45,13 }, { 814,46,12 }, { 751,47,11 }, { 688,48,10 }, { 625,49,9 }, { 562,50,8 }, { 499,51,7 }, { 436,52,6 }, { 373,53,5 }, { 310,54,4 }, { 247,55,3 }, { 184,56,2 }, { 121,57,1 }, { 58,58,0 }, { 2012,28,31 }, { 1949,29,30 }, { 1886,30,29 },
  { 1823,31,28 }, { 1760,32,27 }, { 1697,33,26 }, { 1634,34,25 }, { 1571,35,24 }, { 1508,36,23 }, { 1445,37,22 }, { 1382,38,21 }, { 1319,39,20 }, { 1256,40,19 }, { 1193,41,18 }, { 1130,42,17 }, { 1067,43,16 }, { 1004,44,15 }, { 941,45,14 }, { 878,46,13 }, { 815,47,12 }, { 752,48,11 }, { 689,49,10 }, { 626,50,9 },
  { 563,51,8 }, { 500,52,7 }, { 437,53,6 }, { 374,54,5 }, { 311,55,4 }, { 248,56,3 }, { 185,57,2 }, { 122,58,1 }, { 59,59,0 }, { 2013,29,31 }, { 1950,30,30 }, { 1887,31,29 }, { 1824,32,28 }, { 1761,33,27 }, { 1698,34,26 }, { 1635,35,25 }, { 1572,36,24 }, { 1509,37,23 }, { 1446,38,22 }, { 1383,39,21 },
  { 1320,40,20 }, { 1257,41,19 }, { 1194,42,18 }, { 1131,43,17 }, { 1068,44,16 }, { 1005,45,15 }, { 942,46,14 }, { 879,47,13 }, { 816,48,12 }, { 753,49,11 }, { 690,50,10 }, { 627,51,9 }, { 564,52,8 }, { 501,53,7 }, { 438,54,6 }, { 375,55,5 }, { 312,56,4 }, { 249,57,3 }, { 186,58,2 }, { 123,59,1 },
  { 60,60,0 }, { 2014,30,31 }, { 1951,31,30 }, { 1888,32,29 }, { 1825,33,28 }, { 1762,34,27 }, { 1699,35,26 }, { 1636,36,25 }, { 1573,37,24 }, { 1510,38,23 }, { 1447,39,22 }, { 1384,40,21 }, { 1321,41,20 }, { 1258,42,19 }, { 1195,43,18 }, { 1132,44,17 }, { 1069,45,16 }, { 1006,46,15 }, { 943,47,14 }, { 880,48,13 },
  { 817,49,12 }, { 754,50,11 }, { 691,51,10 }, { 628,52,9 }, { 565,53,8 }, { 502,54,7 }, { 439,55,6 }, { 376,56,5 }, { 313,57,4 }, { 250,58,3 }, { 187,59,2 }, { 124,60,1 }, { 61,61,0 }, { 2015,31,31 }, { 1952,32,30 }, { 1889,33,29 }, { 1826,34,28 }, { 1763,35,27 }, { 1700,36,26 }, { 1637,37,25 },
  { 1574,38,24 }, { 1511,39,23 }, { 1448,40,22 }, { 1385,41,21 }, { 1322,42,20 }, { 1259,43,19 }, { 1196,44,18 }, { 1133,45,17 }, { 1070,46,16 }, { 1007,47,15 }, { 944,48,14 }, { 881,49,13 }, { 818,50,12 }, { 755,51,11 }, { 692,52,10 }, { 629,53,9 }, { 566,54,8 }, { 503,55,7 }, { 440,56,6 }, { 377,57,5 },
  { 314,58,4 }, { 251,59,3 }, { 188,60,2 }, { 125,61,1 }, { 62,62,0 }, { 2016,32,31 }, { 1953,33,30 }, { 1890,34,29 }, { 1827,35,28 }, { 1764,36,27 }, { 1701,37,26 }, { 1638,38,25 }, { 1575,39,24 }, { 1512,40,23 }, { 1449,41,22 }, { 1386,42,21 }, { 1323,43,20 }, { 1260,44,19 }, { 1197,45,18 }, { 1134,46,17 },
  { 1071,47,16 }, { 1008,48,15 }, { 945,49,14 }, { 882,50,13 }, { 819,51,12 }, { 756,52,11 }, { 693,53,10 }, { 630,54,9 }, { 567,55,8 }, { 504,56,7 }, { 441,57,6 }, { 378,58,5 }, { 315,59,4 }, { 252,60,3 }, { 189,61,2 }, { 126,62,1 }, { 63,63,0 }, { 2017,33,31 }, { 1954,34,30 }, { 1891,35,29 },
  { 1828,36,28 }, { 1765,37,27 }, { 1702,38,26 }, { 1639,39,25 }, { 1576,40,24 }, { 1513,41,23 }, { 1450,42,22 }, { 1387,43,21 }, { 1324,44,20 }, { 1261,45,19 }, { 1198,46,18 }, { 1135,47,17 }, { 1072,48,16 }, { 1009,49,15 }, { 946,50,14 }, { 883,51,13 }, { 820,52,12 }, { 757,53,11 }, { 694,54,10 }, { 631,55,9 },
  { 568,56,8 }, { 505,57,7 }, { 442,58,6 }, { 379,59,5 }, { 316,60,4 }, { 253,61,3 }, { 190,62,2 }, { 127,63,1 }, { 2018,34,31 }, { 1955,35,30 }, { 1892,36,29 }, { 1829,37,28 }, { 1766,38,27 }, { 1703,39,26 }, { 1640,40,25 }, { 1577,41,24 }, { 1514,42,23 }, { 1451,43,22 }, { 1388,44,21 }, { 1325,45,20 },
  { 1262,46,19 }, { 1199,47,18 }, { 1136,48,17 }, { 1073,49,16 }, { 1010,50,15 }, { 947,51,14 }, { 884,52,13 }, { 821,53,12 }, { 758,54,11 }, { 695,55,10 }, { 632,56,9 }, { 569,57,8 }, { 506,58,7 }, { 443,59,6 }, { 380,60,5 }, { 317,61,4 }, { 254,62,3 }, { 191,63,2 }, { 2019,35,31 }, { 1956,36,30 },
  { 1893,37,29 }, { 1830,38,28 }, { 1767,39,27 }, { 1704,40,26 }, { 1641,41,25 }, { 1578,42,24 }, { 1515,43,23 }, { 1452,44,22 }, { 1389,45,21 }, { 1326,46,20 }, { 1263,47,19 }, { 1200,48,18 }, { 1137,49,17 }, { 1074,50,16 }, { 1011,51,15 }, { 948,52,14 }, { 885,53,13 }, { 822,54,12 }, { 759,55,11 }, { 696,56,10 },
  { 633,57,9 }, { 570,58,8 }, { 507,59,7 }, { 444,60,6 }, { 381,61,5 }, { 318,62,4 }, { 255,63,3 }, { 2020,36,31 }, { 1957,37,30 }, { 1894,38,29 }, { 1831,39,28 }, { 1768,40,27 }, { 1705,41,26 }, { 1642,42,25 }, { 1579,43,24 }, { 1516,44,23 }, { 1453,45,22 }, { 1390,46,21 }, { 1327,47,20 }, { 1264,48,19 },
  { 1201,49,18 }, { 1138,50,17 }, { 1075,51,16 }, { 1012,52,15 }, { 949,53,14 }, { 886,54,13 }, { 823,55,12 }, { 760,56,11 }, { 697,57,10 }, { 634,58,9 }, { 571,59,8 }, { 508,60,7 }, { 445,61,6 }, { 382,62,5 }, { 319,63,4 }, { 2021,37,31 }, { 1958,38,30 }, { 1895,39,29 }, { 1832,40,28 }, { 1769,41,27 },
  { 1706,42,26 }, { 1643,43,25 }, { 1580,44,24 }, { 1517,45,23 }, { 1454,46,22 }, { 1391,47,21 }, { 1328,48,20 }, { 1265,49,19 }, { 1202,50,18 }, { 1139,51,17 }, { 1076,52,16 }, { 1013,53,15 }, { 950,54,14 }, { 887,55,13 }, { 824,56,12 }, { 761,57,11 }, { 698,58,10 }, { 635,59,9 }, { 572,60,8 }, { 509,61,7 },
  { 446,62,6 }, { 383,63,5 }, { 2022,38,31 }, { 1959,39,30 }, { 1896,40,29 }, { 1833,41,28 }, { 1770,42,27 }, { 1707,43,26 }, { 1644,44,25 }, { 1581,45,24 }, { 1518,46,23 }, { 1455,47,22 }, { 1392,48,21 }, { 1329,49,20 }, { 1266,50,19 }, { 1203,51,18 }, { 1140,52,17 }, { 1077,53,16 }, { 1014,54,15 }, { 951,55,14 },
  { 888,56,13 }, { 825,57,12 }, { 762,58,11 }, { 699,59,10 }, { 636,60,9 }, { 573,61,8 }, { 510,62,7 }, { 447,63,6 }, { 2023,39,31 }, { 1960,40,30 }, { 1897,41,29 }, { 1834,42,28 }, { 1771,43,27 }, { 1708,44,26 }, { 1645,45,25 }, { 1582,46,24 }, { 1519,47,23 }, { 1456,48,22 }, { 1393,49,21 }, { 1330,50,20 },
  { 1267,51,19 }, { 1204,52,18 }, { 1141,53,17 }, { 1078,54,16 }, { 1015,55,15 }, { 952,56,14 }, { 889,57,13 }, { 826,58,12 }, { 763,59,11 }, { 700,60,10 }, { 637,61,9 }, { 574,62,8 }, { 511,63,7 }, { 2024,40,31 }, { 1961,41,30 }, { 1898,42,29 }, { 1835,43,28 }, { 1772,44,27 }, { 1709,45,26 }, { 1646,46,25 },
  { 1583,47,24 }, { 1520,48,23 }, { 1457,49,22 }, { 1394,50,21 }, { 1331,51,20 }, { 1268,52,19 }, { 1205,53,18 }, { 1142,54,17 }, { 1079,55,16 }, { 1016,56,15 }, { 953,57,14 }, { 890,58,13 }, { 827,59,12 }, { 764,60,11 }, { 701,61,10 }, { 638,62,9 }, { 575,63,8 }, { 2025,41,31 }, { 1962,42,30 }, { 1899,43,29 },
  { 1836,44,28 }, { 1773,45,27 }, { 1710,46,26 }, { 1647,47,25 }, { 1584,48,24 }, { 1521,49,23 }, { 1458,50,22 }, { 1395,51,21 }, { 1332,52,20 }, { 1269,53,19 }, { 1206,54,18 }, { 1143,55,17 }, { 1080,56,16 }, { 1017,57,15 }, { 954,58,14 }, { 891,59,13 }, { 828,60,12 }, { 765,61,11 }, { 702,62,10 }, { 639,63,9 },
  { 2026,42,31 }, { 1963,43,30 }, { 1900,44,29 }, { 1837,45,28 }, { 1774,46,27 }, { 1711,47,26 }, { 1648,48,25 }, { 1585,49,24 }, { 1522,50,23 }, { 1459,51,22 }, { 1396,52,21 }, { 1333,53,20 }, { 1270,54,19 }, { 1207,55,18 }, { 1144,56,17 }, { 1081,57,16 }, { 1018,58,15 }, { 955,59,14 }, { 892,60,13 }, { 829,61,12 },
  { 766,62,11 }, { 703,63,10 }, { 2027,43,31 }, { 1964,44,30 }, { 1901,45,29 }, { 1838,46,28 }, { 1775,47,27 }, { 1712,48,26 }, { 1649,49,25 }, { 1586,50,24 }, { 1523,51,23 }, { 1460,52,22 }, { 1397,53,21 }, { 1334,54,20 }, { 1271,55,19 }, { 1208,56,18 }, { 1145,57,17 }, { 1082,58,16 }, { 1019,59,15 }, { 956,60,14 },
  { 893,61,13 }, { 830,62,12 }, { 767,63,11 }, { 2028,44,31 }, { 1965,45,30 }, { 1902,46,29 }, { 1839,47,28 }, { 1776,48,27 }, { 1713,49,26 }, { 1650,50,25 }, { 1587,51,24 }, { 1524,52,23 }, { 1461,53,22 }, { 1398,54,21 }, { 1335,55,20 }, { 1272,56,19 }, { 1209,57,18 }, { 1146,58,17 }, { 1083,59,16 }, { 1020,60,15 },
  { 957,61,14 }, { 894,62,13 }, { 831,63,12 }, { 2029,45,31 }, { 1966,46,30 }, { 1903,47,29 }, { 1840,48,28 }, { 1777,49,27 }, { 1714,50,26 }, { 1651,51,25 }, { 1588,52,24 }, { 1525,53,23 }, { 1462,54,22 }, { 1399,55,21 }, { 1336,56,20 }, { 1273,57,19 }, { 1210,58,18 }, { 1147,59,17 }, { 1084,60,16 }, { 1021,61,15 },
  { 958,62,14 }, { 895,63,13 }, { 2030,46,31 }, { 1967,47,30 }, { 1904,48,29 }, { 1841,49,28 }, { 1778,50,27 }, { 1715,51,26 }, { 1652,52,25 }, { 1589,53,24 }, { 1526,54,23 }, { 1463,55,22 }, { 1400,56,21 }, { 1337,57,20 }, { 1274,58,19 }, { 1211,59,18 }, { 1148,60,17 }, { 1085,61,16 }, { 1022,62,15 }, { 959,63,14 },
  { 2031,47,31 }, { 1968,48,30 }, { 1905,49,29 }, { 1842,50,28 }, { 1779,51,27 }, { 1716,52,26 }, { 1653,53,25 }, { 1590,54,24 }, { 1527,55,23 }, { 1464,56,22 }, { 1401,57,21 }, { 1338,58,20 }, { 1275,59,19 }, { 1212,60,18 }, { 1149,61,17 }, { 1086,62,16 }, { 1023,63,15 }, { 2032,48,31 }, { 1969,49,30 }, { 1906,50,29 },
  { 1843,51,28 }, { 1780,52,27 }, { 1717,53,26 }, { 1654,54,25 }, { 1591,55,24 }, { 1528,56,23 }, { 1465,57,22 }, { 1402,58,21 }, { 1339,59,20 }, { 1276,60,19 }, { 1213,61,18 }, { 1150,62,17 }, { 1087,63,16 }, { 2033,49,31 }, { 1970,50,30 }, { 1907,51,29 }, { 1844,52,28 }, { 1781,53,27 }, { 1718,54,26 }, { 1655,55,25 },
  { 1592,56,24 }, { 1529,57,23 }, { 1466,58,22 }, { 1403,59,21 }, { 1340,60,20 }, { 1277,61,19 }, { 1214,62,18 }, { 1151,63,17 }, { 2034,50,31 }, { 1971,51,30 }, { 1908,52,29 }, { 1845,53,28 }, { 1782,54,27 }, { 1719,55,26 }, { 1656,56,25 }, { 1593,57,24 }, { 1530,58,23 }, { 1467,59,22 }, { 1404,60,21 }, { 1341,61,20 },
  { 1278,62,19 }, { 1215,63,18 }, { 2035,51,31 }, { 1972,52,30 }, { 1909,53,29 }, { 1846,54,28 }, { 1783,55,27 }, { 1720,56,26 }, { 1657,57,25 }, { 1594,58,24 }, { 1531,59,23 }, { 1468,60,22 }, { 1405,61,21 }, { 1342,62,20 }, { 1279,63,19 }, { 2036,52,31 }, { 1973,53,30 }, { 1910,54,29 }, { 1847,55,28 }, { 1784,56,27 },
  { 1721,57,26 }, { 1658,58,25 }, { 1595,59,24 }, { 1532,60,23 }, { 1469,61,22 }, { 1406,62,21 }, { 1343,63,20 }, { 2037,53,31 }, { 1974,54,30 }, { 1911,55,29 }, { 1848,56,28 }, { 1785,57,27 }, { 1722,58,26 }, { 1659,59,25 }, { 1596,60,24 }, { 1533,61,23 }, { 1470,62,22 }, { 1407,63,21 }, { 2038,54,31 }, { 1975,55,30 },
  { 1912,56,29 }, { 1849,57,28 }, { 1786,58,27 }, { 1723,59,26 }, { 1660,60,25 }, { 1597,61,24 }, { 1534,62,23 }, { 1471,63,22 }, { 2039,55,31 }, { 1976,56,30 }, { 1913,57,29 }, { 1850,58,28 }, { 1787,59,27 }, { 1724,60,26 }, { 1661,61,25 }, { 1598,62,24 }, { 1535,63,23 }, { 2040,56,31 }, { 1977,57,30 }, { 1914,58,29 },
  { 1851,59,28 }, { 1788,60,27 }, { 1725,61,26 }, { 1662,62,25 }, { 1599,63,24 }, { 2041,57,31 }, { 1978,58,30 }, { 1915,59,29 }, { 1852,60,28 }, { 1789,61,27 }, { 1726,62,26 }, { 1663,63,25 }, { 2042,58,31 }, { 1979,59,30 }, { 1916,60,29 }, { 1853,61,28 }, { 1790,62,27 }, { 1727,63,26 }, { 2043,59,31 }, { 1980,60,30 },
  { 1917,61,29 }, { 1854,62,28 }, { 1791,63,27 }, { 2044,60,31 }, { 1981,61,30 }, { 1918,62,29 }, { 1855,63,28 }, { 2045,61,31 }, { 1982,62,30 }, { 1919,63,29 }, { 2046,62,31 }, { 1983,63,30 }, { 2047,63,31 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 128,0,2 }, { 65,1,1 }, { 2,2,0 }, { 192,0,3 },
  { 129,1,2 }, { 66,2,1 }, { 3,3,0 }, { 256,0,4 }, { 193,1,3 }, { 130,2,2 }, { 67,3,1 }, { 4,4,0 }, { 320,0,5 }, { 257,1,4 }, { 194,2,3 }, { 131,3,2 }, { 68,4,1 }, { 5,5,0 }, { 384,0,6 }, { 321,1,5 }, { 258,2,4 }, { 195,3,3 }, { 132,4,2 }, { 69,5,1 },
  { 6,6,0 }, { 448,0,7 }, { 385,1,6 }, { 322,2,5 }, { 259,3,4 }, { 196,4,3 }, { 133,5,2 }, { 70,6,1 }, { 7,7,0 }, { 512,0,8 }, { 449,1,7 }, { 386,2,6 }, { 323,3,5 }, { 260,4,4 }, { 197,5,3 }, { 134,6,2 }, { 71,7,1 }, { 8,8,0 }, { 576,0,9 }, { 513,1,8 },
  { 450,2,7 }, { 387,3,6 }, { 324,4,5 }, { 261,5,4 }, { 198,6,3 }, { 135,7,2 }, { 72,8,1 }, { 9,9,0 }, { 640,0,10 }, { 577,1,9 }, { 514,2,8 }, { 451,3,7 }, { 388,4,6 }, { 325,5,5 }, { 262,6,4 }, { 199,7,3 }, { 136,8,2 }, { 73,9,1 }, { 10,10,0 }, { 704,0,11 },
  { 641,1,10 }, { 578,2,9 }, { 515,3,8 }, { 452,4,7 }, { 389,5,6 }, { 326,6,5 }, { 263,7,4 }, { 200,8,3 }, { 137,9,2 }, { 74,10,1 }, { 11,11,0 }, { 768,0,12 }, { 705,1,11 }, { 642,2,10 }, { 579,3,9 }, { 516,4,8 }, { 453,5,7 }, { 390,6,6 }, { 327,7,5 }, { 264,8,4 },
  { 201,9,3 }, { 138,10,2 }, { 75,11,1 }, { 12,12,0 }, { 832,0,13 }, { 769,1,12 }, { 706,2,11 }, { 643,3,10 }, { 580,4,9 }, { 517,5,8 }, { 454,6,7 }, { 391,7,6 }, { 328,8,5 }, { 265,9,4 }, { 202,10,3 }, { 139,11,2 }, { 76,12,1 }, { 13,13,0 }, { 896,0,14 }, { 833,1,13 },
  { 770,2,12 }, { 707,3,11 }, { 644,4,10 }, { 581,5,9 }, { 518,6,8 }, { 455,7,7 }, { 392,8,6 }, { 329,9,5 }, { 266,10,4 }, { 203,11,3 }, { 140,12,2 }, { 77,13,1 }, { 14,14,0 }, { 960,0,15 }, { 897,1,14 }, { 834,2,13 }, { 771,3,12 }, { 708,4,11 }, { 645,5,10 }, { 582,6,9 },
  { 519,7,8 }, { 456,8,7 }, { 393,9,6 }, { 330,10,5 }, { 267,11,4 }, { 204,12,3 }, { 141,13,2 }, { 78,14,1 }, { 15,15,0 }, { 1024,0,16 }, { 961,1,15 }, { 898,2,14 }, { 835,3,13 }, { 772,4,12 }, { 709,5,11 }, { 646,6,10 }, { 583,7,9 }, { 520,8,8 }, { 457,9,7 }, { 394,10,6 },
  { 331,11,5 }, { 268,12,4 }, { 205,13,3 }, { 142,14,2 }, { 79,15,1 }, { 16,16,0 }, { 1088,0,17 }, { 1025,1,16 }, { 962,2,15 }, { 899,3,14 }, { 836,4,13 }, { 773,5,12 }, { 710,6,11 }, { 647,7,10 }, { 584,8,9 }, { 521,9,8 }, { 458,10,7 }, { 395,11,6 }, { 332,12,5 }, { 269,13,4 },
  { 206,14,3 }, { 143,15,2 }, { 80,16,1 }, { 17,17,0 }, { 1152,0,18 }, { 1089,1,17 }, { 1026,2,16 }, { 963,3,15 }, { 900,4,14 }, { 837,5,13 }, { 774,6,12 }, { 711,7,11 }, { 648,8,10 }, { 585,9,9 }, { 522,10,8 }, { 459,11,7 }, { 396,12,6 }, { 333,13,5 }, { 270,14,4 }, { 207,15,3 },
  { 144,16,2 }, { 81,17,1 }, { 18,18,0 }, { 1216,0,19 }, { 1153,1,18 }, { 1090,2,17 }, { 1027,3,16 }, { 964,4,15 }, { 901,5,14 }, { 838,6,13 }, { 775,7,12 }, { 712,8,11 }, { 649,9,10 }, { 586,10,9 }, { 523,11,8 }, { 460,12,7 }, { 397,13,6 }, { 334,14,5 }, { 271,15,4 }, { 208,16,3 },
  { 145,17,2 }, { 82,18,1 }, { 19,19,0 }, { 1280,0,20 }, { 1217,1,19 }, { 1154,2,18 }, { 1091,3,17 }, { 1028,4,16 }, { 965,5,15 }, { 902,6,14 }, { 839,7,13 }, { 776,8,12 }, { 713,9,11 }, { 650,10,10 }, { 587,11,9 }, { 524,12,8 }, { 461,13,7 }, { 398,14,6 }, { 335,15,5 }, { 272,16,4 },
  { 209,17,3 }, { 146,18,2 }, { 83,19,1 }, { 20,20,0 }, { 1344,0,21 }, { 1281,1,20 }, { 1218,2,19 }, { 1155,3,18 }, { 1092,4,17 }, { 1029,5,16 }, { 966,6,15 }, { 903,7,14 }, { 840,8,13 }, { 777,9,12 }, { 714,10,11 }, { 651,11,10 }, { 588,12,9 }, { 525,13,8 }, { 462,14,7 }, { 399,15,6 },
  { 336,16,5 }, { 273,17,4 }, { 210,18,3 }, { 147,19,2 }, { 84,20,1 }, { 21,21,0 }, { 1408,0,22 }, { 1345,1,21 }, { 1282,2,20 }, { 1219,3,19 }, { 1156,4,18 }, { 1093,5,17 }, { 1030,6,16 }, { 967,7,15 }, { 904,8,14 }, { 841,9,13 }, { 778,10,12 }, { 715,11,11 }, { 652,12,10 }, { 589,13,9 },
  { 526,14,8 }, { 463,15,7 }, { 400,16,6 }, { 337,17,5 }, { 274,18,4 }, { 211,19,3 }, { 148,20,2 }, { 85,21,1 }, { 22,22,0 }, { 1472,0,23 }, { 1409,1,22 }, { 1346,2,21 }, { 1283,3,20 }, { 1220,4,19 }, { 1157,5,18 }, { 1094,6,17 }, { 1031,7,16 }, { 968,8,15 }, { 905,9,14 }, { 842,10,13 },
  { 779,11,12 }, { 716,12,11 }, { 653,13,10 }, { 590,14,9 }, { 527,15,8 }, { 464,16,7 }, { 401,17,6 }, { 338,18,5 }, { 275,19,4 }, { 212,20,3 }, { 149,21,2 }, { 86,22,1 }, { 23,23,0 }, { 1536,0,24 }, { 1473,1,23 }, { 1410,2,22 }, { 1347,3,21 }, { 1284,4,20 }, { 1221,5,19 }, { 1158,6,18 },
  { 1095,7,17 }, { 1032,8,16 }, { 969,9,15 }, { 906,10,14 }, { 843,11,13 }, { 780,12,12 }, { 717,13,11 }, { 654,14,10 }, { 591,15,9 }, { 528,16,8 }, { 465,17,7 }, { 402,18,6 }, { 339,19,5 }, { 276,20,4 }, { 213,21,3 }, { 150,22,2 }, { 87,23,1 }, { 24,24,0 }, { 1600,0,25 }, { 1537,1,24 },
  { 1474,2,23 }, { 1411,3,22 }, { 1348,4,21 }, { 1285,5,20 }, { 1222,6,19 }, { 1159,7,18 }, { 1096,8,17 }, { 1033,9,16 }, { 970,10,15 }, { 907,11,14 }, { 844,12,13 }, { 781,13,12 }, { 718,14,11 }, { 655,15,10 }, { 592,16,9 }, { 529,17,8 }, { 466,18,7 }, { 403,19,6 }, { 340,20,5 }, { 277,21,4 },
  { 214,22,3 }, { 151,23,2 }, { 88,24,1 }, { 25,25,0 }, { 1664,0,26 }, { 1601,1,25 }, { 1538,2,24 }, { 1475,3,23 }, { 1412,4,22 }, { 1349,5,21 }, { 1286,6,20 }, { 1223,7,19 }, { 1160,8,18 }, { 1097,9,17 }, { 1034,10,16 }, { 971,11,15 }, { 908,12,14 }, { 845,13,13 }, { 782,14,12 }, { 719,15,11 },
  { 656,16,10 }, { 593,17,9 }, { 530,18,8 }, { 467,19,7 }, { 404,20,6 }, { 341,21,5 }, { 278,22,4 }, { 215,23,3 }, { 152,24,2 }, { 89,25,1 }, { 26,26,0 }, { 1728,0,27 }, { 1665,1,26 }, { 1602,2,25 }, { 1539,3,24 }, { 1476,4,23 }, { 1413,5,22 }, { 1350,6,21 }, { 1287,7,20 }, { 1224,8,19 },
  { 1161,9,18 }, { 1098,10,17 }, { 1035,11,16 }, { 972,12,15 }, { 909,13,14 }, { 846,14,13 }, { 783,15,12 }, { 720,16,11 }, { 657,17,10 }, { 594,18,9 }, { 531,19,8 }, { 468,20,7 }, { 405,21,6 }, { 342,22,5 }, { 279,23,4 }, { 216,24,3 }, { 153,25,2 }, { 90,26,1 }, { 27,27,0 }, { 1792,0,28 },
  { 1729,1,27 }, { 1666,2,26 }, { 1603,3,25 }, { 1540,4,24 }, { 1477,5,23 }, { 1414,6,22 }, { 1351,7,21 }, { 1288,8,20 }, { 1225,9,19 }, { 1162,10,18 }, { 1099,11,17 }, { 1036,12,16 }, { 973,13,15 }, { 910,14,14 }, { 847,15,13 }, { 784,16,12 }, { 721,17,11 }, { 658,18,10 }, { 595,19,9 }, { 532,20,8 },
  { 469,21,7 }, { 406,22,6 }, { 343,23,5 }, { 280,24,4 }, { 217,25,3 }, { 154,26,2 }, { 91,27,1 }, { 28,28,0 }, { 1856,0,29 }, { 1793,1,28 }, { 1730,2,27 }, { 1667,3,26 }, { 1604,4,25 }, { 1541,5,24 }, { 1478,6,23 }, { 1415,7,22 }, { 1352,8,21 }, { 1289,9,20 }, { 1226,10,19 }, { 1163,11,18 },
  { 1100,12,17 }, { 1037,13,16 }, { 974,14,15 }, { 911,15,14 }, { 848,16,13 }, { 785,17,12 }, { 722,18,11 }, { 659,19,10 }, { 596,20,9 }, { 533,21,8 }, { 470,22,7 }, { 407,23,6 }, { 344,24,5 }, { 281,25,4 }, { 218,26,3 }, { 155,27,2 }, { 92,28,1 }, { 29,29,0 }, { 1920,0,30 }, { 1857,1,29 },
  { 1794,2,28 }, { 1731,3,27 }, { 1668,4,26 }, { 1605,5,25 }, { 1542,6,24 }, { 1479,7,23 }, { 1416,8,22 }, { 1353,9,21 }, { 1290,10,20 }, { 1227,11,19 }, { 1164,12,18 }, { 1101,13,17 }, { 1038,14,16 }, { 975,15,15 }, { 912,16,14 }, { 849,17,13 }, { 786,18,12 }, { 723,19,11 }, { 660,20,10 }, { 597,21,9 },
  { 534,22,8 }, { 471,23,7 }, { 408,24,6 }, { 345,25,5 }, { 282,26,4 }, { 219,27,3 }, { 156,28,2 }, { 93,29,1 }, { 30,30,0 }, { 1984,0,31 }, { 1921,1,30 }, { 1858,2,29 }, { 1795,3,28 }, { 1732,4,27 }, { 1669,5,26 }, { 1606,6,25 }, { 1543,7,24 }, { 1480,8,23 }, { 1417,9,22 }, { 1354,10,21 },
  { 1291,11,20 }, { 1228,12,19 }, { 1165,13,18 }, { 1102,14,17 }, { 1039,15,16 }, { 976,16,15 }, { 913,17,14 }, { 850,18,13 }, { 787,19,12 }, { 724,20,11 }, { 661,21,10 }, { 598,22,9 }, { 535,23,8 }, { 472,24,7 }, { 409,25,6 }, { 346,26,5 }, { 283,27,4 }, { 220,28,3 }, { 157,29,2 }, { 94,30,1 },
  { 31,31,0 }, { 2048,0,32 }, { 1985,1,31 }, { 1922,2,30 }, { 1859,3,29 }, { 1796,4,28 }, { 1733,5,27 }, { 1670,6,26 }, { 1607,7,25 }, { 1544,8,24 }, { 1481,9,23 }, { 1418,10,22 }, { 1355,11,21 }, { 1292,12,20 }, { 1229,13,19 }, { 1166,14,18 }, { 1103,15,17 }, { 1040,16,16 }, { 977,17,15 }, { 914,18,14 },
  { 851,19,13 }, { 788,20,12 }, { 725,21,11 }, { 662,22,10 }, { 599,23,9 }, { 536,24,8 }, { 473,25,7 }, { 410,26,6 }, { 347,27,5 }, { 284,28,4 }, { 221,29,3 }, { 158,30,2 }, { 95,31,1 }, { 32,32,0 }, { 2112,0,33 }, { 2049,1,32 }, { 1986,2,31 }, { 1923,3,30 }, { 1860,4,29 }, { 1797,5,28 },
  { 1734,6,27 }, { 1671,7,26 }, { 1608,8,25 }, { 1545,9,24 }, { 1482,10,23 }, { 1419,11,22 }, { 1356,12,21 }, { 1293,13,20 }, { 1230,14,19 }, { 1167,15,18 }, { 1104,16,17 }, { 1041,17,16 }, { 978,18,15 }, { 915,19,14 }, { 852,20,13 }, { 789,21,12 }, { 726,22,11 }, { 663,23,10 }, { 600,24,9 }, { 537,25,8 },
  { 474,26,7 }, { 411,27,6 }, { 348,28,5 }, { 285,29,4 }, { 222,30,3 }, { 159,31,2 }, { 96,32,1 }, { 33,33,0 }, { 2176,0,34 }, { 2113,1,33 }, { 2050,2,32 }, { 1987,3,31 }, { 1924,4,30 }, { 1861,5,29 }, { 1798,6,28 }, { 1735,7,27 }, { 1672,8,26 }, { 1609,9,25 }, { 1546,10,24 }, { 1483,11,23 },
  { 1420,12,22 }, { 1357,13,21 }, { 1294,14,20 }, { 1231,15,19 }, { 1168,16,18 }, { 1105,17,17 }, { 1042,18,16 }, { 979,19,15 }, { 916,20,14 }, { 853,21,13 }, { 790,22,12 }, { 727,23,11 }, { 664,24,10 }, { 601,25,9 }, { 538,26,8 }, { 475,27,7 }, { 412,28,6 }, { 349,29,5 }, { 286,30,4 }, { 223,31,3 },
  { 160,32,2 }, { 97,33,1 }, { 34,34,0 }, { 2240,0,35 }, { 2177,1,34 }, { 2114,2,33 }, { 2051,3,32 }, { 1988,4,31 }, { 1925,5,30 }, { 1862,6,29 }, { 1799,7,28 }, { 1736,8,27 }, { 1673,9,26 }, { 1610,10,25 }, { 1547,11,24 }, { 1484,12,23 }, { 1421,13,22 }, { 1358,14,21 }, { 1295,15,20 }, { 1232,16,19 },
  { 1169,17,18 }, { 1106,18,17 }, { 1043,19,16 }, { 980,20,15 }, { 917,21,14 }, { 854,22,13 }, { 791,23,12 }, { 728,24,11 }, { 665,25,10 }, { 602,26,9 }, { 539,27,8 }, { 476,28,7 }, { 413,29,6 }, { 350,30,5 }, { 287,31,4 }, { 224,32,3 }, { 161,33,2 }, { 98,34,1 }, { 35,35,0 }, { 2304,0,36 },
  { 2241,1,35 }, { 2178,2,34 }, { 2115,3,33 }, { 2052,4,32 }, { 1989,5,31 }, { 1926,6,30 }, { 1863,7,29 }, { 1800,8,28 }, { 1737,9,27 }, { 1674,10,26 }, { 1611,11,25 }, { 1548,12,24 }, { 1485,13,23 }, { 1422,14,22 }, { 1359,15,21 }, { 1296,16,20 }, { 1233,17,19 }, { 1170,18,18 }, { 1107,19,17 }, { 1044,20,16 },
  { 981,21,15 }, { 918,22,14 }, { 855,23,13 }, { 792,24,12 }, { 729,25,11 }, { 666,26,10 }, { 603,27,9 }, { 540,28,8 }, { 477,29,7 }, { 414,30,6 }, { 351,31,5 }, { 288,32,4 }, { 225,33,3 }, { 162,34,2 }, { 99,35,1 }, { 36,36,0 }, { 2368,0,37 }, { 2305,1,36 }, { 2242,2,35 }, { 2179,3,34 },
  { 2116,4,33 }, { 2053,5,32 }, { 1990,6,31 }, { 1927,7,30 }, { 1864,8,29 }, { 1801,9,28 }, { 1738,10,27 }, { 1675,11,26 }, { 1612,12,25 }, { 1549,13,24 }, { 1486,14,23 }, { 1423,15,22 }, { 1360,16,21 }, { 1297,17,20 }, { 1234,18,19 }, { 1171,19,18 }, { 1108,20,17 }, { 1045,21,16 }, { 982,22,15 }, { 919,23,14 },
  { 856,24,13 }, { 793,25,12 }, { 730,26,11 }, { 667,27,10 }, { 604,28,9 }, { 541,29,8 }, { 478,30,7 }, { 415,31,6 }, { 352,32,5 }, { 289,33,4 }, { 226,34,3 }, { 163,35,2 }, { 100,36,1 }, { 37,37,0 }, { 2432,0,38 }, { 2369,1,37 }, { 2306,2,36 }, { 2243,3,35 }, { 2180,4,34 }, { 2117,5,33 },
  { 2054,6,32 }, { 1991,7,31 }, { 1928,8,30 }, { 1865,9,29 }, { 1802,10,28 }, { 1739,11,27 }, { 1676,12,26 }, { 1613,13,25 }, { 1550,14,24 }, { 1487,15,23 }, { 1424,16,22 }, { 1361,17,21 }, { 1298,18,20 }, { 1235,19,19 }, { 1172,20,18 }, { 1109,21,17 }, { 1046,22,16 }, { 983,23,15 }, { 920,24,14 }, { 857,25,13 },
  { 794,26,12 }, { 731,27,11 }, { 668,28,10 }, { 605,29,9 }, { 542,30,8 }, { 479,31,7 }, { 416,32,6 }, { 353,33,5 }, { 290,34,4 }, { 227,35,3 }, { 164,36,2 }, { 101,37,1 }, { 38,38,0 }, { 2496,0,39 }, { 2433,1,38 }, { 2370,2,37 }, { 2307,3,36 }, { 2244,4,35 }, { 2181,5,34 }, { 2118,6,33 },
  { 2055,7,32 }, { 1992,8,31 }, { 1929,9,30 }, { 1866,10,29 }, { 1803,11,28 }, { 1740,12,27 }, { 1677,13,26 }, { 1614,14,25 }, { 1551,15,24 }, { 1488,16,23 }, { 1425,17,22 }, { 1362,18,21 }, { 1299,19,20 }, { 1236,20,19 }, { 1173,21,18 }, { 1110,22,17 }, { 1047,23,16 }, { 984,24,15 }, { 921,25,14 }, { 858,26,13 },
  { 795,27,12 }, { 732,28,11 }, { 669,29,10 }, { 606,30,9 }, { 543,31,8 }, { 480,32,7 }, { 417,33,6 }, { 354,34,5 }, { 291,35,4 }, { 228,36,3 }, { 165,37,2 }, { 102,38,1 }, { 39,39,0 }, { 2560,0,40 }, { 2497,1,39 }, { 2434,2,38 }, { 2371,3,37 }, { 2308,4,36 }, { 2245,5,35 }, { 2182,6,34 },
  { 2119,7,33 }, { 2056,8,32 }, { 1993,9,31 }, { 1930,10,30 }, { 1867,11,29 }, { 1804,12,28 }, { 1741,13,27 }, { 1678,14,26 }, { 1615,15,25 }, { 1552,16,24 }, { 1489,17,23 }, { 1426,18,22 }, { 1363,19,21 }, { 1300,20,20 }, { 1237,21,19 }, { 1174,22,18 }, { 1111,23,17 }, { 1048,24,16 }, { 985,25,15 }, { 922,26,14 },
  { 859,27,13 }, { 796,28,12 }, { 733,29,11 }, { 670,30,10 }, { 607,31,9 }, { 544,32,8 }, { 481,33,7 }, { 418,34,6 }, { 355,35,5 }, { 292,36,4 }, { 229,37,3 }, { 166,38,2 }, { 103,39,1 }, { 40,40,0 }, { 2624,0,41 }, { 2561,1,40 }, { 2498,2,39 }, { 2435,3,38 }, { 2372,4,37 }, { 2309,5,36 },
  { 2246,6,35 }, { 2183,7,34 }, { 2120,8,33 }, { 2057,9,32 }, { 1994,10,31 }, { 1931,11,30 }, { 1868,12,29 }, { 1805,13,28 }, { 1742,14,27 }, { 1679,15,26 }, { 1616,16,25 }, { 1553,17,24 }, { 1490,18,23 }, { 1427,19,22 }, { 1364,20,21 }, { 1301,21,20 }, { 1238,22,19 }, { 1175,23,18 }, { 1112,24,17 }, { 1049,25,16 },
  { 986,26,15 }, { 923,27,14 }, { 860,28,13 }, { 797,29,12 }, { 734,30,11 }, { 671,31,10 }, { 608,32,9 }, { 545,33,8 }, { 482,34,7 }, { 419,35,6 }, { 356,36,5 }, { 293,37,4 }, { 230,38,3 }, { 167,39,2 }, { 104,40,1 }, { 41,41,0 }, { 2688,0,42 }, { 2625,1,41 }, { 2562,2,40 }, { 2499,3,39 },
  { 2436,4,38 }, { 2373,5,37 }, { 2310,6,36 }, { 2247,7,35 }, { 2184,8,34 }, { 2121,9,33 }, { 2058,10,32 }, { 1995,11,31 }, { 1932,12,30 }, { 1869,13,29 }, { 1806,14,28 }, { 1743,15,27 }, { 1680,16,26 }, { 1617,17,25 }, { 1554,18,24 }, { 1491,19,23 }, { 1428,20,22 }, { 1365,21,21 }, { 1302,22,20 }, { 1239,23,19 },
  { 1176,24,18 }, { 1113,25,17 }, { 1050,26,16 }, { 987,27,15 }, { 924,28,14 }, { 861,29,13 }, { 798,30,12 }, { 735,31,11 }, { 672,32,10 }, { 609,33,9 }, { 546,34,8 }, { 483,35,7 }, { 420,36,6 }, { 357,37,5 }, { 294,38,4 }, { 231,39,3 }, { 168,40,2 }, { 105,41,1 }, { 42,42,0 }, { 2752,0,43 },
  { 2689,1,42 }, { 2626,2,41 }, { 2563,3,40 }, { 2500,4,39 }, { 2437,5,38 }, { 2374,6,37 }, { 2311,7,36 }, { 2248,8,35 }, { 2185,9,34 }, { 2122,10,33 }, { 2059,11,32 }, { 1996,12,31 }, { 1933,13,30 }, { 1870,14,29 }, { 1807,15,28 }, { 1744,16,27 }, { 1681,17,26 }, { 1618,18,25 }, { 1555,19,24 }, { 1492,20,23 },
  { 1429,21,22 }, { 1366,22,21 }, { 1303,23,20 }, { 1240,24,19 }, { 1177,25,18 }, { 1114,26,17 }, { 1051,27,16 }, { 988,28,15 }, { 925,29,14 }, { 862,30,13 }, { 799,31,12 }, { 736,32,11 }, { 673,33,10 }, { 610,34,9 }, { 547,35,8 }, { 484,36,7 }, { 421,37,6 }, { 358,38,5 }, { 295,39,4 }, { 232,40,3 },
  { 169,41,2 }, { 106,42,1 }, { 43,43,0 }, { 2816,0,44 }, { 2753,1,43 }, { 2690,2,42 }, { 2627,3,41 }, { 2564,4,40 }, { 2501,5,39 }, { 2438,6,38 }, { 2375,7,37 }, { 2312,8,36 }, { 2249,9,35 }, { 2186,10,34 }, { 2123,11,33 }, { 2060,12,32 }, { 1997,13,31 }, { 1934,14,30 }, { 1871,15,29 }, { 1808,16,28 },
  { 1745,17,27 }, { 1682,18,26 }, { 1619,19,25 }, { 1556,20,24 }, { 1493,21,23 }, { 1430,22,22 }, { 1367,23,21 }, { 1304,24,20 }, { 1241,25,19 }, { 1178,26,18 }, { 1115,27,17 }, { 1052,28,16 }, { 989,29,15 }, { 926,30,14 }, { 863,31,13 }, { 800,32,12 }, { 737,33,11 }, { 674,34,10 }, { 611,35,9 }, { 548,36,8 },
  { 485,37,7 }, { 422,38,6 }, { 359,39,5 }, { 296,40,4 }, { 233,41,3 }, { 170,42,2 }, { 107,43,1 }, { 44,44,0 }, { 2880,0,45 }, { 2817,1,44 }, { 2754,2,43 }, { 2691,3,42 }, { 2628,4,41 }, { 2565,5,40 }, { 2502,6,39 }, { 2439,7,38 }, { 2376,8,37 }, { 2313,9,36 }, { 2250,10,35 }, { 2187,11,34 },
  { 2124,12,33 }, { 2061,13,32 }, { 1998,14,31 }, { 1935,15,30 }, { 1872,16,29 }, { 1809,17,28 }, { 1746,18,27 }, { 1683,19,26 }, { 1620,20,25 }, { 1557,21,24 }, { 1494,22,23 }, { 1431,23,22 }, { 1368,24,21 }, { 1305,25,20 }, { 1242,26,19 }, { 1179,27,18 }, { 1116,28,17 }, { 1053,29,16 }, { 990,30,15 }, { 927,31,14 },
  { 864,32,13 }, { 801,33,12 }, { 738,34,11 }, { 675,35,10 }, { 612,36,9 }, { 549,37,8 }, { 486,38,7 }, { 423,39,6 }, { 360,40,5 }, { 297,41,4 }, { 234,42,3 }, { 171,43,2 }, { 108,44,1 }, { 45,45,0 }, { 2944,0,46 }, { 2881,1,45 }, { 2818,2,44 }, { 2755,3,43 }, { 2692,4,42 }, { 2629,5,41 },
  { 2566,6,40 }, { 2503,7,39 }, { 2440,8,38 }, { 2377,9,37 }, { 2314,10,36 }, { 2251,11,35 }, { 2188,12,34 }, { 2125,13,33 }, { 2062,14,32 }, { 1999,15,31 }, { 1936,16,30 }, { 1873,17,29 }, { 1810,18,28 }, { 1747,19,27 }, { 1684,20,26 }, { 1621,21,25 }, { 1558,22,24 }, { 1495,23,23 }, { 1432,24,22 }, { 1369,25,21 },
  { 1306,26,20 }, { 1243,27,19 }, { 1180,28,18 }, { 1117,29,17 }, { 1054,30,16 }, { 991,31,15 }, { 928,32,14 }, { 865,33,13 }, { 802,34,12 }, { 739,35,11 }, { 676,36,10 }, { 613,37,9 }, { 550,38,8 }, { 487,39,7 }, { 424,40,6 }, { 361,41,5 }, { 298,42,4 }, { 235,43,3 }, { 172,44,2 }, { 109,45,1 },
  { 46,46,0 }, { 3008,0,47 }, { 2945,1,46 }, { 2882,2,45 }, { 2819,3,44 }, { 2756,4,43 }, { 2693,5,42 }, { 2630,6,41 }, { 2567,7,40 }, { 2504,8,39 }, { 2441,9,38 }, { 2378,10,37 }, { 2315,11,36 }, { 2252,12,35 }, { 2189,13,34 }, { 2126,14,33 }, { 2063,15,32 }, { 2000,16,31 }, { 1937,17,30 }, { 1874,18,29 },
  { 1811,19,28 }, { 1748,20,27 }, { 1685,21,26 }, { 1622,22,25 }, { 1559,23,24 }, { 1496,24,23 }, { 1433,25,22 }, { 1370,26,21 }, { 1307,27,20 }, { 1244,28,19 }, { 1181,29,18 }, { 1118,30,17 }, { 1055,31,16 }, { 992,32,15 }, { 929,33,14 }, { 866,34,13 }, { 803,35,12 }, { 740,36,11 }, { 677,37,10 }, { 614,38,9 },
  { 551,39,8 }, { 488,40,7 }, { 425,41,6 }, { 362,42,5 }, { 299,43,4 }, { 236,44,3 }, { 173,45,2 }, { 110,46,1 }, { 47,47,0 }, { 3072,0,48 }, { 3009,1,47 }, { 2946,2,46 }, { 2883,3,45 }, { 2820,4,44 }, { 2757,5,43 }, { 2694,6,42 }, { 2631,7,41 }, { 2568,8,40 }, { 2505,9,39 }, { 2442,10,38 },
  { 2379,11,37 }, { 2316,12,36 }, { 2253,13,35 }, { 2190,14,34 }, { 2127,15,33 }, { 2064,16,32 }, { 2001,17,31 }, { 1938,18,30 }, { 1875,19,29 }, { 1812,20,28 }, { 1749,21,27 }, { 1686,22,26 }, { 1623,23,25 }, { 1560,24,24 }, { 1497,25,23 }, { 1434,26,22 }, { 1371,27,21 }, { 1308,28,20 }, { 1245,29,19 }, { 1182,30,18 },
  { 1119,31,17 }, { 1056,32,16 }, { 993,33,15 }, { 930,34,14 }, { 867,35,13 }, { 804,36,12 }, { 741,37,11 }, { 678,38,10 }, { 615,39,9 }, { 552,40,8 }, { 489,41,7 }, { 426,42,6 }, { 363,43,5 }, { 300,44,4 }, { 237,45,3 }, { 174,46,2 }, { 111,47,1 }, { 48,48,0 }, { 3136,0,49 }, { 3073,1,48 },
  { 3010,2,47 }, { 2947,3,46 }, { 2884,4,45 }, { 2821,5,44 }, { 2758,6,43 }, { 2695,7,42 }, { 2632,8,41 }, { 2569,9,40 }, { 2506,10,39 }, { 2443,11,38 }, { 2380,12,37 }, { 2317,13,36 }, { 2254,14,35 }, { 2191,15,34 }, { 2128,16,33 }, { 2065,17,32 }, { 2002,18,31 }, { 1939,19,30 }, { 1876,20,29 }, { 1813,21,28 },
  { 1750,22,27 }, { 1687,23,26 }, { 1624,24,25 }, { 1561,25,24 }, { 1498,26,23 }, { 1435,27,22 }, { 1372,28,21 }, { 1309,29,20 }, { 1246,30,19 }, { 1183,31,18 }, { 1120,32,17 }, { 1057,33,16 }, { 994,34,15 }, { 931,35,14 }, { 868,36,13 }, { 805,37,12 }, { 742,38,11 }, { 679,39,10 }, { 616,40,9 }, { 553,41,8 },
  { 490,42,7 }, { 427,43,6 }, { 364,44,5 }, { 301,45,4 }, { 238,46,3 }, { 175,47,2 }, { 112,48,1 }, { 49,49,0 }, { 3200,0,50 }, { 3137,1,49 }, { 3074,2,48 }, { 3011,3,47 }, { 2948,4,46 }, { 2885,5,45 }, { 2822,6,44 }, { 2759,7,43 }, { 2696,8,42 }, { 2633,9,41 }, { 2570,10,40 }, { 2507,11,39 },
  { 2444,12,38 }, { 2381,13,37 }, { 2318,14,36 }, { 2255,15,35 }, { 2192,16,34 }, { 2129,17,33 }, { 2066,18,32 }, { 2003,19,31 }, { 1940,20,30 }, { 1877,21,29 }, { 1814,22,28 }, { 1751,23,27 }, { 1688,24,26 }, { 1625,25,25 }, { 1562,26,24 }, { 1499,27,23 }, { 1436,28,22 }, { 1373,29,21 }, { 1310,30,20 }, { 1247,31,19 },
  { 1184,32,18 }, { 1121,33,17 }, { 1058,34,16 }, { 995,35,15 }, { 932,36,14 }, { 869,37,13 }, { 806,38,12 }, { 743,39,11 }, { 680,40,10 }, { 617,41,9 }, { 554,42,8 }, { 491,43,7 }, { 428,44,6 }, { 365,45,5 }, { 302,46,4 }, { 239,47,3 }, { 176,48,2 }, { 113,49,1 }, { 50,50,0 }, { 3264,0,51 },
  { 3201,1,50 }, { 3138,2,49 }, { 3075,3,48 }, { 3012,4,47 }, { 2949,5,46 }, { 2886,6,45 }, { 2823,7,44 }, { 2760,8,43 }, { 2697,9,42 }, { 2634,10,41 }, { 2571,11,40 }, { 2508,12,39 }, { 2445,13,38 }, { 2382,14,37 }, { 2319,15,36 }, { 2256,16,35 }, { 2193,17,34 }, { 2130,18,33 }, { 2067,19,32 }, { 2004,20,31 },
  { 1941,21,30 }, { 1878,22,29 }, { 1815,23,28 }, { 1752,24,27 }, { 1689,25,26 }, { 1626,26,25 }, { 1563,27,24 }, { 1500,28,23 }, { 1437,29,22 }, { 1374,30,21 }, { 1311,31,20 }, { 1248,32,19 }, { 1185,33,18 }, { 1122,34,17 }, { 1059,35,16 }, { 996,36,15 }, { 933,37,14 }, { 870,38,13 }, { 807,39,12 }, { 744,40,11 },
  { 681,41,10 }, { 618,42,9 }, { 555,43,8 }, { 492,44,7 }, { 429,45,6 }, { 366,46,5 }, { 303,47,4 }, { 240,48,3 }, { 177,49,2 }, { 114,50,1 }, { 51,51,0 }, { 3328,0,52 }, { 3265,1,51 }, { 3202,2,50 }, { 3139,3,49 }, { 3076,4,48 }, { 3013,5,47 }, { 2950,6,46 }, { 2887,7,45 }, { 2824,8,44 },
  { 2761,9,43 }, { 2698,10,42 }, { 2635,11,41 }, { 2572,12,40 }, { 2509,13,39 }, { 2446,14,38 }, { 2383,15,37 }, { 2320,16,36 }, { 2257,17,35 }, { 2194,18,34 }, { 2131,19,33 }, { 2068,20,32 }, { 2005,21,31 }, { 1942,22,30 }, { 1879,23,29 }, { 1816,24,28 }, { 1753,25,27 }, { 1690,26,26 }, { 1627,27,25 }, { 1564,28,24 },
  { 1501,29,23 }, { 1438,30,22 }, { 1375,31,21 }, { 1312,32,20 }, { 1249,33,19 }, { 1186,34,18 }, { 1123,35,17 }, { 1060,36,16 }, { 997,37,15 }, { 934,38,14 }, { 871,39,13 }, { 808,40,12 }, { 745,41,11 }, { 682,42,10 }, { 619,43,9 }, { 556,44,8 }, { 493,45,7 }, { 430,46,6 }, { 367,47,5 }, { 304,48,4 },
  { 241,49,3 }, { 178,50,2 }, { 115,51,1 }, { 52,52,0 }, { 3392,0,53 }, { 3329,1,52 }, { 3266,2,51 }, { 3203,3,50 }, { 3140,4,49 }, { 3077,5,48 }, { 3014,6,47 }, { 2951,7,46 }, { 2888,8,45 }, { 2825,9,44 }, { 2762,10,43 }, { 2699,11,42 }, { 2636,12,41 }, { 2573,13,40 }, { 2510,14,39 }, { 2447,15,38 },
  { 2384,16,37 }, { 2321,17,36 }, { 2258,18,35 }, { 2195,19,34 }, { 2132,20,33 }, { 2069,21,32 }, { 2006,22,31 }, { 1943,23,30 }, { 1880,24,29 }, { 1817,25,28 }, { 1754,26,27 }, { 1691,27,26 }, { 1628,28,25 }, { 1565,29,24 }, { 1502,30,23 }, { 1439,31,22 }, { 1376,32,21 }, { 1313,33,20 }, { 1250,34,19 }, { 1187,35,18 },
  { 1124,36,17 }, { 1061,37,16 }, { 998,38,15 }, { 935,39,14 }, { 872,40,13 }, { 809,41,12 }, { 746,42,11 }, { 683,43,10 }, { 620,44,9 }, { 557,45,8 }, { 494,46,7 }, { 431,47,6 }, { 368,48,5 }, { 305,49,4 }, { 242,50,3 }, { 179,51,2 }, { 116,52,1 }, { 53,53,0 }, { 3456,0,54 }, { 3393,1,53 },
  { 3330,2,52 }, { 3267,3,51 }, { 3204,4,50 }, { 3141,5,49 }, { 3078,6,48 }, { 3015,7,47 }, { 2952,8,46 }, { 2889,9,45 }, { 2826,10,44 }, { 2763,11,43 }, { 2700,12,42 }, { 2637,13,41 }, { 2574,14,40 }, { 2511,15,39 }, { 2448,16,38 }, { 2385,17,37 }, { 2322,18,36 }, { 2259,19,35 }, { 2196,20,34 }, { 2133,21,33 },
  { 2070,22,32 }, { 2007,23,31 }, { 1944,24,30 }, { 1881,25,29 }, { 1818,26,28 }, { 1755,27,27 }, { 1692,28,26 }, { 1629,29,25 }, { 1566,30,24 }, { 1503,31,23 }, { 1440,32,22 }, { 1377,33,21 }, { 1314,34,20 }, { 1251,35,19 }, { 1188,36,18 }, { 1125,37,17 }, { 1062,38,16 }, { 999,39,15 }, { 936,40,14 }, { 873,41,13 },
  { 810,42,12 }, { 747,43,11 }, { 684,44,10 }, { 621,45,9 }, { 558,46,8 }, { 495,47,7 }, { 432,48,6 }, { 369,49,5 }, { 306,50,4 }, { 243,51,3 }, { 180,52,2 }, { 117,53,1 }, { 54,54,0 }, { 3520,0,55 }, { 3457,1,54 }, { 3394,2,53 }, { 3331,3,52 }, { 3268,4,51 }, { 3205,5,50 }, { 3142,6,49 },
  { 3079,7,48 }, { 3016,8,47 }, { 2953,9,46 }, { 2890,10,45 }, { 2827,11,44 }, { 2764,12,43 }, { 2701,13,42 }, { 2638,14,41 }, { 2575,15,40 }, { 2512,16,39 }, { 2449,17,38 }, { 2386,18,37 }, { 2323,19,36 }, { 2260,20,35 }, { 2197,21,34 }, { 2134,22,33 }, { 2071,23,32 }, { 2008,24,31 }, { 1945,25,30 }, { 1882,26,29 },
  { 1819,27,28 }, { 1756,28,27 }, { 1693,29,26 }, { 1630,30,25 }, { 1567,31,24 }, { 1504,32,23 }, { 1441,33,22 }, { 1378,34,21 }, { 1315,35,20 }, { 1252,36,19 }, { 1189,37,18 }, { 1126,38,17 }, { 1063,39,16 }, { 1000,40,15 }, { 937,41,14 }, { 874,42,13 }, { 811,43,12 }, { 748,44,11 }, { 685,45,10 }, { 622,46,9 },
  { 559,47,8 }, { 496,48,7 }, { 433,49,6 }, { 370,50,5 }, { 307,51,4 }, { 244,52,3 }, { 181,53,2 }, { 118,54,1 }, { 55,55,0 }, { 3584,0,56 }, { 3521,1,55 }, { 3458,2,54 }, { 3395,3,53 }, { 3332,4,52 }, { 3269,5,51 }, { 3206,6,50 }, { 3143,7,49 }, { 3080,8,48 }, { 3017,9,47 }, { 2954,10,46 },
  { 2891,11,45 }, { 2828,12,44 }, { 2765,13,43 }, { 2702,14,42 }, { 2639,15,41 }, { 2576,16,40 }, { 2513,17,39 }, { 2450,18,38 }, { 2387,19,37 }, { 2324,20,36 }, { 2261,21,35 }, { 2198,22,34 }, { 2135,23,33 }, { 2072,24,32 }, { 2009,25,31 }, { 1946,26,30 }, { 1883,27,29 }, { 1820,28,28 }, { 1757,29,27 }, { 1694,30,26 },
  { 1631,31,25 }, { 1568,32,24 }, { 1505,33,23 }, { 1442,34,22 }, { 1379,35,21 }, { 1316,36,20 }, { 1253,37,19 }, { 1190,38,18 }, { 1127,39,17 }, { 1064,40,16 }, { 1001,41,15 }, { 938,42,14 }, { 875,43,13 }, { 812,44,12 }, { 749,45,11 }, { 686,46,10 }, { 623,47,9 }, { 560,48,8 }, { 497,49,7 }, { 434,50,6 },
  { 371,51,5 }, { 308,52,4 }, { 245,53,3 }, { 182,54,2 }, { 119,55,1 }, { 56,56,0 }, { 3648,0,57 }, { 3585,1,56 }, { 3522,2,55 }, { 3459,3,54 }, { 3396,4,53 }, { 3333,5,52 }, { 3270,6,51 }, { 3207,7,50 }, { 3144,8,49 }, { 3081,9,48 }, { 3018,10,47 }, { 2955,11,46 }, { 2892,12,45 }, { 2829,13,44 },
  { 2766,14,43 }, { 2703,15,42 }, { 2640,16,41 }, { 2577,17,40 }, { 2514,18,39 }, { 2451,19,38 }, { 2388,20,37 }, { 2325,21,36 }, { 2262,22,35 }, { 2199,23,34 }, { 2136,24,33 }, { 2073,25,32 }, { 2010,26,31 }, { 1947,27,30 }, { 1884,28,29 }, { 1821,29,28 }, { 1758,30,27 }, { 1695,31,26 }, { 1632,32,25 }, { 1569,33,24 },
  { 1506,34,23 }, { 1443,35,22 }, { 1380,36,21 }, { 1317,37,20 }, { 1254,38,19 }, { 1191,39,18 }, { 1128,40,17 }, { 1065,41,16 }, { 1002,42,15 }, { 939,43,14 }, { 876,44,13 }, { 813,45,12 }, { 750,46,11 }, { 687,47,10 }, { 624,48,9 }, { 561,49,8 }, { 498,50,7 }, { 435,51,6 }, { 372,52,5 }, { 309,53,4 },
  { 246,54,3 }, { 183,55,2 }, { 120,56,1 }, { 57,57,0 }, { 3712,0,58 }, { 3649,1,57 }, { 3586,2,56 }, { 3523,3,55 }, { 3460,4,54 }, { 3397,5,53 }, { 3334,6,52 }, { 3271,7,51 }, { 3208,8,50 }, { 3145,9,49 }, { 3082,10,48 }, { 3019,11,47 }, { 2956,12,46 }, { 2893,13,45 }, { 2830,14,44 }, { 2767,15,43 },
  { 2704,16,42 }, { 2641,17,41 }, { 2578,18,40 }, { 2515,19,39 }, { 2452,20,38 }, { 2389,21,37 }, { 2326,22,36 }, { 2263,23,35 }, { 2200,24,34 }, { 2137,25,33 }, { 2074,26,32 }, { 2011,27,31 }, { 1948,28,30 }, { 1885,29,29 }, { 1822,30,28 }, { 1759,31,27 }, { 1696,32,26 }, { 1633,33,25 }, { 1570,34,24 }, { 1507,35,23 },
  { 1444,36,22 }, { 1381,37,21 }, { 1318,38,20 }, { 1255,39,19 }, { 1192,40,18 }, { 1129,41,17 }, { 1066,42,16 }, { 1003,43,15 }, { 940,44,14 }, { 877,45,13 }, { 814,46,12 }, { 751,47,11 }, { 688,48,10 }, { 625,49,9 }, { 562,50,8 }, { 499,51,7 }, { 436,52,6 }, { 373,53,5 }, { 310,54,4 }, { 247,55,3 },
  { 184,56,2 }, { 121,57,1 }, { 58,58,0 }, { 3776,0,59 }, { 3713,1,58 }, { 3650,2,57 }, { 3587,3,56 }, { 3524,4,55 }, { 3461,5,54 }, { 3398,6,53 }, { 3335,7,52 }, { 3272,8,51 }, { 3209,9,50 }, { 3146,10,49 }, { 3083,11,48 }, { 3020,12,47 }, { 2957,13,46 }, { 2894,14,45 }, { 2831,15,44 }, { 2768,16,43 },
  { 2705,17,42 }, { 2642,18,41 }, { 2579,19,40 }, { 2516,20,39 }, { 2453,21,38 }, { 2390,22,37 }, { 2327,23,36 }, { 2264,24,35 }, { 2201,25,34 }, { 2138,26,33 }, { 2075,27,32 }, { 2012,28,31 }, { 1949,29,30 }, { 1886,30,29 }, { 1823,31,28 }, { 1760,32,27 }, { 1697,33,26 }, { 1634,34,25 }, { 1571,35,24 }, { 1508,36,23 },
  { 1445,37,22 }, { 1382,38,21 }, { 1319,39,20 }, { 1256,40,19 }, { 1193,41,18 }, { 1130,42,17 }, { 1067,43,16 }, { 1004,44,15 }, { 941,45,14 }, { 878,46,13 }, { 815,47,12 }, { 752,48,11 }, { 689,49,10 }, { 626,50,9 }, { 563,51,8 }, { 500,52,7 }, { 437,53,6 }, { 374,54,5 }, { 311,55,4 }, { 248,56,3 },
  { 185,57,2 }, { 122,58,1 }, { 59,59,0 }, { 3840,0,60 }, { 3777,1,59 }, { 3714,2,58 }, { 3651,3,57 }, { 3588,4,56 }, { 3525,5,55 }, { 3462,6,54 }, { 3399,7,53 }, { 3336,8,52 }, { 3273,9,51 }, { 3210,10,50 }, { 3147,11,49 }, { 3084,12,48 }, { 3021,13,47 }, { 2958,14,46 }, { 2895,15,45 }, { 2832,16,44 },
  { 2769,17,43 }, { 2706,18,42 }, { 2643,19,41 }, { 2580,20,40 }, { 2517,21,39 }, { 2454,22,38 }, { 2391,23,37 }, { 2328,24,36 }, { 2265,25,35 }, { 2202,26,34 }, { 2139,27,33 }, { 2076,28,32 }, { 2013,29,31 }, { 1950,30,30 }, { 1887,31,29 }, { 1824,32,28 }, { 1761,33,27 }, { 1698,34,26 }, { 1635,35,25 }, { 1572,36,24 },
  { 1509,37,23 }, { 1446,38,22 }, { 1383,39,21 }, { 1320,40,20 }, { 1257,41,19 }, { 1194,42,18 }, { 1131,43,17 }, { 1068,44,16 }, { 1005,45,15 }, { 942,46,14 }, { 879,47,13 }, { 816,48,12 }, { 753,49,11 }, { 690,50,10 }, { 627,51,9 }, { 564,52,8 }, { 501,53,7 }, { 438,54,6 }, { 375,55,5 }, { 312,56,4 },
  { 249,57,3 }, { 186,58,2 }, { 123,59,1 }, { 60,60,0 }, { 3904,0,61 }, { 3841,1,60 }, { 3778,2,59 }, { 3715,3,58 }, { 3652,4,57 }, { 3589,5,56 }, { 3526,6,55 }, { 3463,7,54 }, { 3400,8,53 }, { 3337,9,52 }, { 3274,10,51 }, { 3211,11,50 }, { 3148,12,49 }, { 3085,13,48 }, { 3022,14,47 }, { 2959,15,46 },
  { 2896,16,45 }, { 2833,17,44 }, { 2770,18,43 }, { 2707,19,42 }, { 2644,20,41 }, { 2581,21,40 }, { 2518,22,39 }, { 2455,23,38 }, { 2392,24,37 }, { 2329,25,36 }, { 2266,26,35 }, { 2203,27,34 }, { 2140,28,33 }, { 2077,29,32 }, { 2014,30,31 }, { 1951,31,30 }, { 1888,32,29 }, { 1825,33,28 }, { 1762,34,27 }, { 1699,35,26 },
  { 1636,36,25 }, { 1573,37,24 }, { 1510,38,23 }, { 1447,39,22 }, { 1384,40,21 }, { 1321,41,20 }, { 1258,42,19 }, { 1195,43,18 }, { 1132,44,17 }, { 1069,45,16 }, { 1006,46,15 }, { 943,47,14 }, { 880,48,13 }, { 817,49,12 }, { 754,50,11 }, { 691,51,10 }, { 628,52,9 }, { 565,53,8 }, { 502,54,7 }, { 439,55,6 },
  { 376,56,5 }, { 313,57,4 }, { 250,58,3 }, { 187,59,2 }, { 124,60,1 }, { 61,61,0 }, { 3968,0,62 }, { 3905,1,61 }, { 3842,2,60 }, { 3779,3,59 }, { 3716,4,58 }, { 3653,5,57 }, { 3590,6,56 }, { 3527,7,55 }, { 3464,8,54 }, { 3401,9,53 }, { 3338,10,52 }, { 3275,11,51 }, { 3212,12,50 }, { 3149,13,49 },
  { 3086,14,48 }, { 3023,15,47 }, { 2960,16,46 }, { 2897,17,45 }, { 2834,18,44 }, { 2771,19,43 }, { 2708,20,42 }, { 2645,21,41 }, { 2582,22,40 }, { 2519,23,39 }, { 2456,24,38 }, { 2393,25,37 }, { 2330,26,36 }, { 2267,27,35 }, { 2204,28,34 }, { 2141,29,33 }, { 2078,30,32 }, { 2015,31,31 }, { 1952,32,30 }, { 1889,33,29 },
  { 1826,34,28 }, { 1763,35,27 }, { 1700,36,26 }, { 1637,37,25 }, { 1574,38,24 }, { 1511,39,23 }, { 1448,40,22 }, { 1385,41,21 }, { 1322,42,20 }, { 1259,43,19 }, { 1196,44,18 }, { 1133,45,17 }, { 1070,46,16 }, { 1007,47,15 }, { 944,48,14 }, { 881,49,13 }, { 818,50,12 }, { 755,51,11 }, { 692,52,10 }, { 629,53,9 },
  { 566,54,8 }, { 503,55,7 }, { 440,56,6 }, { 377,57,5 }, { 314,58,4 }, { 251,59,3 }, { 188,60,2 }, { 125,61,1 }, { 62,62,0 }, { 4032,0,63 }, { 3969,1,62 }, { 3906,2,61 }, { 3843,3,60 }, { 3780,4,59 }, { 3717,5,58 }, { 3654,6,57 }, { 3591,7,56 }, { 3528,8,55 }, { 3465,9,54 }, { 3402,10,53 },
  { 3339,11,52 }, { 3276,12,51 }, { 3213,13,50 }, { 3150,14,49 }, { 3087,15,48 }, { 3024,16,47 }, { 2961,17,46 }, { 2898,18,45 }, { 2835,19,44 }, { 2772,20,43 }, { 2709,21,42 }, { 2646,22,41 }, { 2583,23,40 }, { 2520,24,39 }, { 2457,25,38 }, { 2394,26,37 }, { 2331,27,36 }, { 2268,28,35 }, { 2205,29,34 }, { 2142,30,33 },
  { 2079,31,32 }, { 2016,32,31 }, { 1953,33,30 }, { 1890,34,29 }, { 1827,35,28 }, { 1764,36,27 }, { 1701,37,26 }, { 1638,38,25 }, { 1575,39,24 }, { 1512,40,23 }, { 1449,41,22 }, { 1386,42,21 }, { 1323,43,20 }, { 1260,44,19 }, { 1197,45,18 }, { 1134,46,17 }, { 1071,47,16 }, { 1008,48,15 }, { 945,49,14 }, { 882,50,13 },
  { 819,51,12 }, { 756,52,11 }, { 693,53,10 }, { 630,54,9 }, { 567,55,8 }, { 504,56,7 }, { 441,57,6 }, { 378,58,5 }, { 315,59,4 }, { 252,60,3 }, { 189,61,2 }, { 126,62,1 }, { 63,63,0 }, { 4033,1,63 }, { 3970,2,62 }, { 3907,3,61 }, { 3844,4,60 }, { 3781,5,59 }, { 3718,6,58 }, { 3655,7,57 },
  { 3592,8,56 }, { 3529,9,55 }, { 3466,10,54 }, { 3403,11,53 }, { 3340,12,52 }, { 3277,13,51 }, { 3214,14,50 }, { 3151,15,49 }, { 3088,16,48 }, { 3025,17,47 }, { 2962,18,46 }, { 2899,19,45 }, { 2836,20,44 }, { 2773,21,43 }, { 2710,22,42 }, { 2647,23,41 }, { 2584,24,40 }, { 2521,25,39 }, { 2458,26,38 }, { 2395,27,37 },
  { 2332,28,36 }, { 2269,29,35 }, { 2206,30,34 }, { 2143,31,33 }, { 2080,32,32 }, { 2017,33,31 }, { 1954,34,30 }, { 1891,35,29 }, { 1828,36,28 }, { 1765,37,27 }, { 1702,38,26 }, { 1639,39,25 }, { 1576,40,24 }, { 1513,41,23 }, { 1450,42,22 }, { 1387,43,21 }, { 1324,44,20 }, { 1261,45,19 }, { 1198,46,18 }, { 1135,47,17 },
  { 1072,48,16 }, { 1009,49,15 }, { 946,50,14 }, { 883,51,13 }, { 820,52,12 }, { 757,53,11 }, { 694,54,10 }, { 631,55,9 }, { 568,56,8 }, { 505,57,7 }, { 442,58,6 }, { 379,59,5 }, { 316,60,4 }, { 253,61,3 }, { 190,62,2 }, { 127,63,1 }, { 4034,2,63 }, { 3971,3,62 }, { 3908,4,61 }, { 3845,5,60 },
  { 3782,6,59 }, { 3719,7,58 }, { 3656,8,57 }, { 3593,9,56 }, { 3530,10,55 }, { 3467,11,54 }, { 3404,12,53 }, { 3341,13,52 }, { 3278,14,51 }, { 3215,15,50 }, { 3152,16,49 }, { 3089,17,48 }, { 3026,18,47 }, { 2963,19,46 }, { 2900,20,45 }, { 2837,21,44 }, { 2774,22,43 }, { 2711,23,42 }, { 2648,24,41 }, { 2585,25,40 },
  { 2522,26,39 }, { 2459,27,38 }, { 2396,28,37 }, { 2333,29,36 }, { 2270,30,35 }, { 2207,31,34 }, { 2144,32,33 }, { 2081,33,32 }, { 2018,34,31 }, { 1955,35,30 }, { 1892,36,29 }, { 1829,37,28 }, { 1766,38,27 }, { 1703,39,26 }, { 1640,40,25 }, { 1577,41,24 }, { 1514,42,23 }, { 1451,43,22 }, { 1388,44,21 }, { 1325,45,20 },
  { 1262,46,19 }, { 1199,47,18 }, { 1136,48,17 }, { 1073,49,16 }, { 1010,50,15 }, { 947,51,14 }, { 884,52,13 }, { 821,53,12 }, { 758,54,11 }, { 695,55,10 }, { 632,56,9 }, { 569,57,8 }, { 506,58,7 }, { 443,59,6 }, { 380,60,5 }, { 317,61,4 }, { 254,62,3 }, { 191,63,2 }, { 4035,3,63 }, { 3972,4,62 },
  { 3909,5,61 }, { 3846,6,60 }, { 3783,7,59 }, { 3720,8,58 }, { 3657,9,57 }, { 3594,10,56 }, { 3531,11,55 }, { 3468,12,54 }, { 3405,13,53 }, { 3342,14,52 }, { 3279,15,51 }, { 3216,16,50 }, { 3153,17,49 }, { 3090,18,48 }, { 3027,19,47 }, { 2964,20,46 }, { 2901,21,45 }, { 2838,22,44 }, { 2775,23,43 }, { 2712,24,42 },
  { 2649,25,41 }, { 2586,26,40 }, { 2523,27,39 }, { 2460,28,38 }, { 2397,29,37 }, { 2334,30,36 }, { 2271,31,35 }, { 2208,32,34 }, { 2145,33,33 }, { 2082,34,32 }, { 2019,35,31 }, { 1956,36,30 }, { 1893,37,29 }, { 1830,38,28 }, { 1767,39,27 }, { 1704,40,26 }, { 1641,41,25 }, { 1578,42,24 }, { 1515,43,23 }, { 1452,44,22 },
  { 1389,45,21 }, { 1326,46,20 }, { 1263,47,19 }, { 1200,48,18 }, { 1137,49,17 }, { 1074,50,16 }, { 1011,51,15 }, { 948,52,14 }, { 885,53,13 }, { 822,54,12 }, { 759,55,11 }, { 696,56,10 }, { 633,57,9 }, { 570,58,8 }, { 507,59,7 }, { 444,60,6 }, { 381,61,5 }, { 318,62,4 }, { 255,63,3 }, { 4036,4,63 },
  { 3973,5,62 }, { 3910,6,61 }, { 3847,7,60 }, { 3784,8,59 }, { 3721,9,58 }, { 3658,10,57 }, { 3595,11,56 }, { 3532,12,55 }, { 3469,13,54 }, { 3406,14,53 }, { 3343,15,52 }, { 3280,16,51 }, { 3217,17,50 }, { 3154,18,49 }, { 3091,19,48 }, { 3028,20,47 }, { 2965,21,46 }, { 2902,22,45 }, { 2839,23,44 }, { 2776,24,43 },
  { 2713,25,42 }, { 2650,26,41 }, { 2587,27,40 }, { 2524,28,39 }, { 2461,29,38 }, { 2398,30,37 }, { 2335,31,36 }, { 2272,32,35 }, { 2209,33,34 }, { 2146,34,33 }, { 2083,35,32 }, { 2020,36,31 }, { 1957,37,30 }, { 1894,38,29 }, { 1831,39,28 }, { 1768,40,27 }, { 1705,41,26 }, { 1642,42,25 }, { 1579,43,24 }, { 1516,44,23 },
  { 1453,45,22 }, { 1390,46,21 }, { 1327,47,20 }, { 1264,48,19 }, { 1201,49,18 }, { 1138,50,17 }, { 1075,51,16 }, { 1012,52,15 }, { 949,53,14 }, { 886,54,13 }, { 823,55,12 }, { 760,56,11 }, { 697,57,10 }, { 634,58,9 }, { 571,59,8 }, { 508,60,7 }, { 445,61,6 }, { 382,62,5 }, { 319,63,4 }, { 4037,5,63 },
  { 3974,6,62 }, { 3911,7,61 }, { 3848,8,60 }, { 3785,9,59 }, { 3722,10,58 }, { 3659,11,57 }, { 3596,12,56 }, { 3533,13,55 }, { 3470,14,54 }, { 3407,15,53 }, { 3344,16,52 }, { 3281,17,51 }, { 3218,18,50 }, { 3155,19,49 }, { 3092,20,48 }, { 3029,21,47 }, { 2966,22,46 }, { 2903,23,45 }, { 2840,24,44 }, { 2777,25,43 },
  { 2714,26,42 }, { 2651,27,41 }, { 2588,28,40 }, { 2525,29,39 }, { 2462,30,38 }, { 2399,31,37 }, { 2336,32,36 }, { 2273,33,35 }, { 2210,34,34 }, { 2147,35,33 }, { 2084,36,32 }, { 2021,37,31 }, { 1958,38,30 }, { 1895,39,29 }, { 1832,40,28 }, { 1769,41,27 }, { 1706,42,26 }, { 1643,43,25 }, { 1580,44,24 }, { 1517,45,23 },
  { 1454,46,22 }, { 1391,47,21 }, { 1328,48,20 }, { 1265,49,19 }, { 1202,50,18 }, { 1139,51,17 }, { 1076,52,16 }, { 1013,53,15 }, { 950,54,14 }, { 887,55,13 }, { 824,56,12 }, { 761,57,11 }, { 698,58,10 }, { 635,59,9 }, { 572,60,8 }, { 509,61,7 }, { 446,62,6 }, { 383,63,5 }, { 4038,6,63 }, { 3975,7,62 },
  { 3912,8,61 }, { 3849,9,60 }, { 3786,10,59 }, { 3723,11,58 }, { 3660,12,57 }, { 3597,13,56 }, { 3534,14,55 }, { 3471,15,54 }, { 3408,16,53 }, { 3345,17,52 }, { 3282,18,51 }, { 3219,19,50 }, { 3156,20,49 }, { 3093,21,48 }, { 3030,22,47 }, { 2967,23,46 }, { 2904,24,45 }, { 2841,25,44 }, { 2778,26,43 }, { 2715,27,42 },
  { 2652,28,41 }, { 2589,29,40 }, { 2526,30,39 }, { 2463,31,38 }, { 2400,32,37 }, { 2337,33,36 }, { 2274,34,35 }, { 2211,35,34 }, { 2148,36,33 }, { 2085,37,32 }, { 2022,38,31 }, { 1959,39,30 }, { 1896,40,29 }, { 1833,41,28 }, { 1770,42,27 }, { 1707,43,26 }, { 1644,44,25 }, { 1581,45,24 }, { 1518,46,23 }, { 1455,47,22 },
  { 1392,48,21 }, { 1329,49,20 }, { 1266,50,19 }, { 1203,51,18 }, { 1140,52,17 }, { 1077,53,16 }, { 1014,54,15 }, { 951,55,14 }, { 888,56,13 }, { 825,57,12 }, { 762,58,11 }, { 699,59,10 }, { 636,60,9 }, { 573,61,8 }, { 510,62,7 }, { 447,63,6 }, { 4039,7,63 }, { 3976,8,62 }, { 3913,9,61 }, { 3850,10,60 },
  { 3787,11,59 }, { 3724,12,58 }, { 3661,13,57 }, { 3598,14,56 }, { 3535,15,55 }, { 3472,16,54 }, { 3409,17,53 }, { 3346,18,52 }, { 3283,19,51 }, { 3220,20,50 }, { 3157,21,49 }, { 3094,22,48 }, { 3031,23,47 }, { 2968,24,46 }, { 2905,25,45 }, { 2842,26,44 }, { 2779,27,43 }, { 2716,28,42 }, { 2653,29,41 }, { 2590,30,40 },
  { 2527,31,39 }, { 2464,32,38 }, { 2401,33,37 }, { 2338,34,36 }, { 2275,35,35 }, { 2212,36,34 }, { 2149,37,33 }, { 2086,38,32 }, { 2023,39,31 }, { 1960,40,30 }, { 1897,41,29 }, { 1834,42,28 }, { 1771,43,27 }, { 1708,44,26 }, { 1645,45,25 }, { 1582,46,24 }, { 1519,47,23 }, { 1456,48,22 }, { 1393,49,21 }, { 1330,50,20 },
  { 1267,51,19 }, { 1204,52,18 }, { 1141,53,17 }, { 1078,54,16 }, { 1015,55,15 }, { 952,56,14 }, { 889,57,13 }, { 826,58,12 }, { 763,59,11 }, { 700,60,10 }, { 637,61,9 }, { 574,62,8 }, { 511,63,7 }, { 4040,8,63 }, { 3977,9,62 }, { 3914,10,61 }, { 3851,11,60 }, { 3788,12,59 }, { 3725,13,58 }, { 3662,14,57 },
  { 3599,15,56 }, { 3536,16,55 }, { 3473,17,54 }, { 3410,18,53 }, { 3347,19,52 }, { 3284,20,51 }, { 3221,21,50 }, { 3158,22,49 }, { 3095,23,48 }, { 3032,24,47 }, { 2969,25,46 }, { 2906,26,45 }, { 2843,27,44 }, { 2780,28,43 }, { 2717,29,42 }, { 2654,30,41 }, { 2591,31,40 }, { 2528,32,39 }, { 2465,33,38 }, { 2402,34,37 },
  { 2339,35,36 }, { 2276,36,35 }, { 2213,37,34 }, { 2150,38,33 }, { 2087,39,32 }, { 2024,40,31 }, { 1961,41,30 }, { 1898,42,29 }, { 1835,43,28 }, { 1772,44,27 }, { 1709,45,26 }, { 1646,46,25 }, { 1583,47,24 }, { 1520,48,23 }, { 1457,49,22 }, { 1394,50,21 }, { 1331,51,20 }, { 1268,52,19 }, { 1205,53,18 }, { 1142,54,17 },
  { 1079,55,16 }, { 1016,56,15 }, { 953,57,14 }, { 890,58,13 }, { 827,59,12 }, { 764,60,11 }, { 701,61,10 }, { 638,62,9 }, { 575,63,8 }, { 4041,9,63 }, { 3978,10,62 }, { 3915,11,61 }, { 3852,12,60 }, { 3789,13,59 }, { 3726,14,58 }, { 3663,15,57 }, { 3600,16,56 }, { 3537,17,55 }, { 3474,18,54 }, { 3411,19,53 },
  { 3348,20,52 }, { 3285,21,51 }, { 3222,22,50 }, { 3159,23,49 }, { 3096,24,48 }, { 3033,25,47 }, { 2970,26,46 }, { 2907,27,45 }, { 2844,28,44 }, { 2781,29,43 }, { 2718,30,42 }, { 2655,31,41 }, { 2592,32,40 }, { 2529,33,39 }, { 2466,34,38 }, { 2403,35,37 }, { 2340,36,36 }, { 2277,37,35 }, { 2214,38,34 }, { 2151,39,33 },
  { 2088,40,32 }, { 2025,41,31 }, { 1962,42,30 }, { 1899,43,29 }, { 1836,44,28 }, { 1773,45,27 }, { 1710,46,26 }, { 1647,47,25 }, { 1584,48,24 }, { 1521,49,23 }, { 1458,50,22 }, { 1395,51,21 }, { 1332,52,20 }, { 1269,53,19 }, { 1206,54,18 }, { 1143,55,17 }, { 1080,56,16 }, { 1017,57,15 }, { 954,58,14 }, { 891,59,13 },
  { 828,60,12 }, { 765,61,11 }, { 702,62,10 }, { 639,63,9 }, { 4042,10,63 }, { 3979,11,62 }, { 3916,12,61 }, { 3853,13,60 }, { 3790,14,59 }, { 3727,15,58 }, { 3664,16,57 }, { 3601,17,56 }, { 3538,18,55 }, { 3475,19,54 }, { 3412,20,53 }, { 3349,21,52 }, { 3286,22,51 }, { 3223,23,50 }, { 3160,24,49 }, { 3097,25,48 },
  { 3034,26,47 }, { 2971,27,46 }, { 2908,28,45 }, { 2845,29,44 }, { 2782,30,43 }, { 2719,31,42 }, { 2656,32,41 }, { 2593,33,40 }, { 2530,34,39 }, { 2467,35,38 }, { 2404,36,37 }, { 2341,37,36 }, { 2278,38,35 }, { 2215,39,34 }, { 2152,40,33 }, { 2089,41,32 }, { 2026,42,31 }, { 1963,43,30 }, { 1900,44,29 }, { 1837,45,28 },
  { 1774,46,27 }, { 1711,47,26 }, { 1648,48,25 }, { 1585,49,24 }, { 1522,50,23 }, { 1459,51,22 }, { 1396,52,21 }, { 1333,53,20 }, { 1270,54,19 }, { 1207,55,18 }, { 1144,56,17 }, { 1081,57,16 }, { 1018,58,15 }, { 955,59,14 }, { 892,60,13 }, { 829,61,12 }, { 766,62,11 }, { 703,63,10 }, { 4043,11,63 }, { 3980,12,62 },
  { 3917,13,61 }, { 3854,14,60 }, { 3791,15,59 }, { 3728,16,58 }, { 3665,17,57 }, { 3602,18,56 }, { 3539,19,55 }, { 3476,20,54 }, { 3413,21,53 }, { 3350,22,52 }, { 3287,23,51 }, { 3224,24,50 }, { 3161,25,49 }, { 3098,26,48 }, { 3035,27,47 }, { 2972,28,46 }, { 2909,29,45 }, { 2846,30,44 }, { 2783,31,43 }, { 2720,32,42 },
  { 2657,33,41 }, { 2594,34,40 }, { 2531,35,39 }, { 2468,36,38 }, { 2405,37,37 }, { 2342,38,36 }, { 2279,39,35 }, { 2216,40,34 }, { 2153,41,33 }, { 2090,42,32 }, { 2027,43,31 }, { 1964,44,30 }, { 1901,45,29 }, { 1838,46,28 }, { 1775,47,27 }, { 1712,48,26 }, { 1649,49,25 }, { 1586,50,24 }, { 1523,51,23 }, { 1460,52,22 },
  { 1397,53,21 }, { 1334,54,20 }, { 1271,55,19 }, { 1208,56,18 }, { 1145,57,17 }, { 1082,58,16 }, { 1019,59,15 }, { 956,60,14 }, { 893,61,13 }, { 830,62,12 }, { 767,63,11 }, { 4044,12,63 }, { 3981,13,62 }, { 3918,14,61 }, { 3855,15,60 }, { 3792,16,59 }, { 3729,17,58 }, { 3666,18,57 }, { 3603,19,56 }, { 3540,20,55 },
  { 3477,21,54 }, { 3414,22,53 }, { 3351,23,52 }, { 3288,24,51 }, { 3225,25,50 }, { 3162,26,49 }, { 3099,27,48 }, { 3036,28,47 }, { 2973,29,46 }, { 2910,30,45 }, { 2847,31,44 }, { 2784,32,43 }, { 2721,33,42 }, { 2658,34,41 }, { 2595,35,40 }, { 2532,36,39 }, { 2469,37,38 }, { 2406,38,37 }, { 2343,39,36 }, { 2280,40,35 },
  { 2217,41,34 }, { 2154,42,33 }, { 2091,43,32 }, { 2028,44,31 }, { 1965,45,30 }, { 1902,46,29 }, { 1839,47,28 }, { 1776,48,27 }, { 1713,49,26 }, { 1650,50,25 }, { 1587,51,24 }, { 1524,52,23 }, { 1461,53,22 }, { 1398,54,21 }, { 1335,55,20 }, { 1272,56,19 }, { 1209,57,18 }, { 1146,58,17 }, { 1083,59,16 }, { 1020,60,15 },
  { 957,61,14 }, { 894,62,13 }, { 831,63,12 }, { 4045,13,63 }, { 3982,14,62 }, { 3919,15,61 }, { 3856,16,60 }, { 3793,17,59 }, { 3730,18,58 }, { 3667,19,57 }, { 3604,20,56 }, { 3541,21,55 }, { 3478,22,54 }, { 3415,23,53 }, { 3352,24,52 }, { 3289,25,51 }, { 3226,26,50 }, { 3163,27,49 }, { 3100,28,48 }, { 3037,29,47 },
  { 2974,30,46 }, { 2911,31,45 }, { 2848,32,44 }, { 2785,33,43 }, { 2722,34,42 }, { 2659,35,41 }, { 2596,36,40 }, { 2533,37,39 }, { 2470,38,38 }, { 2407,39,37 }, { 2344,40,36 }, { 2281,41,35 }, { 2218,42,34 }, { 2155,43,33 }, { 2092,44,32 }, { 2029,45,31 }, { 1966,46,30 }, { 1903,47,29 }, { 1840,48,28 }, { 1777,49,27 },
  { 1714,50,26 }, { 1651,51,25 }, { 1588,52,24 }, { 1525,53,23 }, { 1462,54,22 }, { 1399,55,21 }, { 1336,56,20 }, { 1273,57,19 }, { 1210,58,18 }, { 1147,59,17 }, { 1084,60,16 }, { 1021,61,15 }, { 958,62,14 }, { 895,63,13 }, { 4046,14,63 }, { 3983,15,62 }, { 3920,16,61 }, { 3857,17,60 }, { 3794,18,59 }, { 3731,19,58 },
  { 3668,20,57 }, { 3605,21,56 }, { 3542,22,55 }, { 3479,23,54 }, { 3416,24,53 }, { 3353,25,52 }, { 3290,26,51 }, { 3227,27,50 }, { 3164,28,49 }, { 3101,29,48 }, { 3038,30,47 }, { 2975,31,46 }, { 2912,32,45 }, { 2849,33,44 }, { 2786,34,43 }, { 2723,35,42 }, { 2660,36,41 }, { 2597,37,40 }, { 2534,38,39 }, { 2471,39,38 },
  { 2408,40,37 }, { 2345,41,36 }, { 2282,42,35 }, { 2219,43,34 }, { 2156,44,33 }, { 2093,45,32 }, { 2030,46,31 }, { 1967,47,30 }, { 1904,48,29 }, { 1841,49,28 }, { 1778,50,27 }, { 1715,51,26 }, { 1652,52,25 }, { 1589,53,24 }, { 1526,54,23 }, { 1463,55,22 }, { 1400,56,21 }, { 1337,57,20 }, { 1274,58,19 }, { 1211,59,18 },
  { 1148,60,17 }, { 1085,61,16 }, { 1022,62,15 }, { 959,63,14 }, { 4047,15,63 }, { 3984,16,62 }, { 3921,17,61 }, { 3858,18,60 }, { 3795,19,59 }, { 3732,20,58 }, { 3669,21,57 }, { 3606,22,56 }, { 3543,23,55 }, { 3480,24,54 }, { 3417,25,53 }, { 3354,26,52 }, { 3291,27,51 }, { 3228,28,50 }, { 3165,29,49 }, { 3102,30,48 },
  { 3039,31,47 }, { 2976,32,46 }, { 2913,33,45 }, { 2850,34,44 }, { 2787,35,43 }, { 2724,36,42 }, { 2661,37,41 }, { 2598,38,40 }, { 2535,39,39 }, { 2472,40,38 }, { 2409,41,37 }, { 2346,42,36 }, { 2283,43,35 }, { 2220,44,34 }, { 2157,45,33 }, { 2094,46,32 }, { 2031,47,31 }, { 1968,48,30 }, { 1905,49,29 }, { 1842,50,28 },
  { 1779,51,27 }, { 1716,52,26 }, { 1653,53,25 }, { 1590,54,24 }, { 1527,55,23 }, { 1464,56,22 }, { 1401,57,21 }, { 1338,58,20 }, { 1275,59,19 }, { 1212,60,18 }, { 1149,61,17 }, { 1086,62,16 }, { 1023,63,15 }, { 4048,16,63 }, { 3985,17,62 }, { 3922,18,61 }, { 3859,19,60 }, { 3796,20,59 }, { 3733,21,58 }, { 3670,22,57 },
  { 3607,23,56 }, { 3544,24,55 }, { 3481,25,54 }, { 3418,26,53 }, { 3355,27,52 }, { 3292,28,51 }, { 3229,29,50 }, { 3166,30,49 }, { 3103,31,48 }, { 3040,32,47 }, { 2977,33,46 }, { 2914,34,45 }, { 2851,35,44 }, { 2788,36,43 }, { 2725,37,42 }, { 2662,38,41 }, { 2599,39,40 }, { 2536,40,39 }, { 2473,41,38 }, { 2410,42,37 },
  { 2347,43,36 }, { 2284,44,35 }, { 2221,45,34 }, { 2158,46,33 }, { 2095,47,32 }, { 2032,48,31 }, { 1969,49,30 }, { 1906,50,29 }, { 1843,51,28 }, { 1780,52,27 }, { 1717,53,26 }, { 1654,54,25 }, { 1591,55,24 }, { 1528,56,23 }, { 1465,57,22 }, { 1402,58,21 }, { 1339,59,20 }, { 1276,60,19 }, { 1213,61,18 }, { 1150,62,17 },
  { 1087,63,16 }, { 4049,17,63 }, { 3986,18,62 }, { 3923,19,61 }, { 3860,20,60 }, { 3797,21,59 }, { 3734,22,58 }, { 3671,23,57 }, { 3608,24,56 }, { 3545,25,55 }, { 3482,26,54 }, { 3419,27,53 }, { 3356,28,52 }, { 3293,29,51 }, { 3230,30,50 }, { 3167,31,49 }, { 3104,32,48 }, { 3041,33,47 }, { 2978,34,46 }, { 2915,35,45 },
  { 2852,36,44 }, { 2789,37,43 }, { 2726,38,42 }, { 2663,39,41 }, { 2600,40,40 }, { 2537,41,39 }, { 2474,42,38 }, { 2411,43,37 }, { 2348,44,36 }, { 2285,45,35 }, { 2222,46,34 }, { 2159,47,33 }, { 2096,48,32 }, { 2033,49,31 }, { 1970,50,30 }, { 1907,51,29 }, { 1844,52,28 }, { 1781,53,27 }, { 1718,54,26 }, { 1655,55,25 },
  { 1592,56,24 }, { 1529,57,23 }, { 1466,58,22 }, { 1403,59,21 }, { 1340,60,20 }, { 1277,61,19 }, { 1214,62,18 }, { 1151,63,17 }, { 4050,18,63 }, { 3987,19,62 }, { 3924,20,61 }, { 3861,21,60 }, { 3798,22,59 }, { 3735,23,58 }, { 3672,24,57 }, { 3609,25,56 }, { 3546,26,55 }, { 3483,27,54 }, { 3420,28,53 }, { 3357,29,52 },
  { 3294,30,51 }, { 3231,31,50 }, { 3168,32,49 }, { 3105,33,48 }, { 3042,34,47 }, { 2979,35,46 }, { 2916,36,45 }, { 2853,37,44 }, { 2790,38,43 }, { 2727,39,42 }, { 2664,40,41 }, { 2601,41,40 }, { 2538,42,39 }, { 2475,43,38 }, { 2412,44,37 }, { 2349,45,36 }, { 2286,46,35 }, { 2223,47,34 }, { 2160,48,33 }, { 2097,49,32 },
  { 2034,50,31 }, { 1971,51,30 }, { 1908,52,29 }, { 1845,53,28 }, { 1782,54,27 }, { 1719,55,26 }, { 1656,56,25 }, { 1593,57,24 }, { 1530,58,23 }, { 1467,59,22 }, { 1404,60,21 }, { 1341,61,20 }, { 1278,62,19 }, { 1215,63,18 }, { 4051,19,63 }, { 3988,20,62 }, { 3925,21,61 }, { 3862,22,60 }, { 3799,23,59 }, { 3736,24,58 },
  { 3673,25,57 }, { 3610,26,56 }, { 3547,27,55 }, { 3484,28,54 }, { 3421,29,53 }, { 3358,30,52 }, { 3295,31,51 }, { 3232,32,50 }, { 3169,33,49 }, { 3106,34,48 }, { 3043,35,47 }, { 2980,36,46 }, { 2917,37,45 }, { 2854,38,44 }, { 2791,39,43 }, { 2728,40,42 }, { 2665,41,41 }, { 2602,42,40 }, { 2539,43,39 }, { 2476,44,38 },
  { 2413,45,37 }, { 2350,46,36 }, { 2287,47,35 }, { 2224,48,34 }, { 2161,49,33 }, { 2098,50,32 }, { 2035,51,31 }, { 1972,52,30 }, { 1909,53,29 }, { 1846,54,28 }, { 1783,55,27 }, { 1720,56,26 }, { 1657,57,25 }, { 1594,58,24 }, { 1531,59,23 }, { 1468,60,22 }, { 1405,61,21 }, { 1342,62,20 }, { 1279,63,19 }, { 4052,20,63 },
  { 3989,21,62 }, { 3926,22,61 }, { 3863,23,60 }, { 3800,24,59 }, { 3737,25,58 }, { 3674,26,57 }, { 3611,27,56 }, { 3548,28,55 }, { 3485,29,54 }, { 3422,30,53 }, { 3359,31,52 }, { 3296,32,51 }, { 3233,33,50 }, { 3170,34,49 }, { 3107,35,48 }, { 3044,36,47 }, { 2981,37,46 }, { 2918,38,45 }, { 2855,39,44 }, { 2792,40,43 },
  { 2729,41,42 }, { 2666,42,41 }, { 2603,43,40 }, { 2540,44,39 }, { 2477,45,38 }, { 2414,46,37 }, { 2351,47,36 }, { 2288,48,35 }, { 2225,49,34 }, { 2162,50,33 }, { 2099,51,32 }, { 2036,52,31 }, { 1973,53,30 }, { 1910,54,29 }, { 1847,55,28 }, { 1784,56,27 }, { 1721,57,26 }, { 1658,58,25 }, { 1595,59,24 }, { 1532,60,23 },
  { 1469,61,22 }, { 1406,62,21 }, { 1343,63,20 }, { 4053,21,63 }, { 3990,22,62 }, { 3927,23,61 }, { 3864,24,60 }, { 3801,25,59 }, { 3738,26,58 }, { 3675,27,57 }, { 3612,28,56 }, { 3549,29,55 }, { 3486,30,54 }, { 3423,31,53 }, { 3360,32,52 }, { 3297,33,51 }, { 3234,34,50 }, { 3171,35,49 }, { 3108,36,48 }, { 3045,37,47 },
  { 2982,38,46 }, { 2919,39,45 }, { 2856,40,44 }, { 2793,41,43 }, { 2730,42,42 }, { 2667,43,41 }, { 2604,44,40 }, { 2541,45,39 }, { 2478,46,38 }, { 2415,47,37 }, { 2352,48,36 }, { 2289,49,35 }, { 2226,50,34 }, { 2163,51,33 }, { 2100,52,32 }, { 2037,53,31 }, { 1974,54,30 }, { 1911,55,29 }, { 1848,56,28 }, { 1785,57,27 },
  { 1722,58,26 }, { 1659,59,25 }, { 1596,60,24 }, { 1533,61,23 }, { 1470,62,22 }, { 1407,63,21 }, { 4054,22,63 }, { 3991,23,62 }, { 3928,24,61 }, { 3865,25,60 }, { 3802,26,59 }, { 3739,27,58 }, { 3676,28,57 }, { 3613,29,56 }, { 3550,30,55 }, { 3487,31,54 }, { 3424,32,53 }, { 3361,33,52 }, { 3298,34,51 }, { 3235,35,50 },
  { 3172,36,49 }, { 3109,37,48 }, { 3046,38,47 }, { 2983,39,46 }, { 2920,40,45 }, { 2857,41,44 }, { 2794,42,43 }, { 2731,43,42 }, { 2668,44,41 }, { 2605,45,40 }, { 2542,46,39 }, { 2479,47,38 }, { 2416,48,37 }, { 2353,49,36 }, { 2290,50,35 }, { 2227,51,34 }, { 2164,52,33 }, { 2101,53,32 }, { 2038,54,31 }, { 1975,55,30 },
  { 1912,56,29 }, { 1849,57,28 }, { 1786,58,27 }, { 1723,59,26 }, { 1660,60,25 }, { 1597,61,24 }, { 1534,62,23 }, { 1471,63,22 }, { 4055,23,63 }, { 3992,24,62 }, { 3929,25,61 }, { 3866,26,60 }, { 3803,27,59 }, { 3740,28,58 }, { 3677,29,57 }, { 3614,30,56 }, { 3551,31,55 }, { 3488,32,54 }, { 3425,33,53 }, { 3362,34,52 },
  { 3299,35,51 }, { 3236,36,50 }, { 3173,37,49 }, { 3110,38,48 }, { 3047,39,47 }, { 2984,40,46 }, { 2921,41,45 }, { 2858,42,44 }, { 2795,43,43 }, { 2732,44,42 }, { 2669,45,41 }, { 2606,46,40 }, { 2543,47,39 }, { 2480,48,38 }, { 2417,49,37 }, { 2354,50,36 }, { 2291,51,35 }, { 2228,52,34 }, { 2165,53,33 }, { 2102,54,32 },
  { 2039,55,31 }, { 1976,56,30 }, { 1913,57,29 }, { 1850,58,28 }, { 1787,59,27 }, { 1724,60,26 }, { 1661,61,25 }, { 1598,62,24 }, { 1535,63,23 }, { 4056,24,63 }, { 3993,25,62 }, { 3930,26,61 }, { 3867,27,60 }, { 3804,28,59 }, { 3741,29,58 }, { 3678,30,57 }, { 3615,31,56 }, { 3552,32,55 }, { 3489,33,54 }, { 3426,34,53 },
  { 3363,35,52 }, { 3300,36,51 }, { 3237,37,50 }, { 3174,38,49 }, { 3111,39,48 }, { 3048,40,47 }, { 2985,41,46 }, { 2922,42,45 }, { 2859,43,44 }, { 2796,44,43 }, { 2733,45,42 }, { 2670,46,41 }, { 2607,47,40 }, { 2544,48,39 }, { 2481,49,38 }, { 2418,50,37 }, { 2355,51,36 }, { 2292,52,35 }, { 2229,53,34 }, { 2166,54,33 },
  { 2103,55,32 }, { 2040,56,31 }, { 1977,57,30 }, { 1914,58,29 }, { 1851,59,28 }, { 1788,60,27 }, { 1725,61,26 }, { 1662,62,25 }, { 1599,63,24 }, { 4057,25,63 }, { 3994,26,62 }, { 3931,27,61 }, { 3868,28,60 }, { 3805,29,59 }, { 3742,30,58 }, { 3679,31,57 }, { 3616,32,56 }, { 3553,33,55 }, { 3490,34,54 }, { 3427,35,53 },
  { 3364,36,52 }, { 3301,37,51 }, { 3238,38,50 }, { 3175,39,49 }, { 3112,40,48 }, { 3049,41,47 }, { 2986,42,46 }, { 2923,43,45 }, { 2860,44,44 }, { 2797,45,43 }, { 2734,46,42 }, { 2671,47,41 }, { 2608,48,40 }, { 2545,49,39 }, { 2482,50,38 }, { 2419,51,37 }, { 2356,52,36 }, { 2293,53,35 }, { 2230,54,34 }, { 2167,55,33 },
  { 2104,56,32 }, { 2041,57,31 }, { 1978,58,30 }, { 1915,59,29 }, { 1852,60,28 }, { 1789,61,27 }, { 1726,62,26 }, { 1663,63,25 }, { 4058,26,63 }, { 3995,27,62 }, { 3932,28,61 }, { 3869,29,60 }, { 3806,30,59 }, { 3743,31,58 }, { 3680,32,57 }, { 3617,33,56 }, { 3554,34,55 }, { 3491,35,54 }, { 3428,36,53 }, { 3365,37,52 },
  { 3302,38,51 }, { 3239,39,50 }, { 3176,40,49 }, { 3113,41,48 }, { 3050,42,47 }, { 2987,43,46 }, { 2924,44,45 }, { 2861,45,44 }, { 2798,46,43 }, { 2735,47,42 }, { 2672,48,41 }, { 2609,49,40 }, { 2546,50,39 }, { 2483,51,38 }, { 2420,52,37 }, { 2357,53,36 }, { 2294,54,35 }, { 2231,55,34 }, { 2168,56,33 }, { 2105,57,32 },
  { 2042,58,31 }, { 1979,59,30 }, { 1916,60,29 }, { 1853,61,28 }, { 1790,62,27 }, { 1727,63,26 }, { 4059,27,63 }, { 3996,28,62 }, { 3933,29,61 }, { 3870,30,60 }, { 3807,31,59 }, { 3744,32,58 }, { 3681,33,57 }, { 3618,34,56 }, { 3555,35,55 }, { 3492,36,54 }, { 3429,37,53 }, { 3366,38,52 }, { 3303,39,51 }, { 3240,40,50 },
  { 3177,41,49 }, { 3114,42,48 }, { 3051,43,47 }, { 2988,44,46 }, { 2925,45,45 }, { 2862,46,44 }, { 2799,47,43 }, { 2736,48,42 }, { 2673,49,41 }, { 2610,50,40 }, { 2547,51,39 }, { 2484,52,38 }, { 2421,53,37 }, { 2358,54,36 }, { 2295,55,35 }, { 2232,56,34 }, { 2169,57,33 }, { 2106,58,32 }, { 2043,59,31 }, { 1980,60,30 },
  { 1917,61,29 }, { 1854,62,28 }, { 1791,63,27 }, { 4060,28,63 }, { 3997,29,62 }, { 3934,30,61 }, { 3871,31,60 }, { 3808,32,59 }, { 3745,33,58 }, { 3682,34,57 }, { 3619,35,56 }, { 3556,36,55 }, { 3493,37,54 }, { 3430,38,53 }, { 3367,39,52 }, { 3304,40,51 }, { 3241,41,50 }, { 3178,42,49 }, { 3115,43,48 }, { 3052,44,47 },
  { 2989,45,46 }, { 2926,46,45 }, { 2863,47,44 }, { 2800,48,43 }, { 2737,49,42 }, { 2674,50,41 }, { 2611,51,40 }, { 2548,52,39 }, { 2485,53,38 }, { 2422,54,37 }, { 2359,55,36 }, { 2296,56,35 }, { 2233,57,34 }, { 2170,58,33 }, { 2107,59,32 }, { 2044,60,31 }, { 1981,61,30 }, { 1918,62,29 }, { 1855,63,28 }, { 4061,29,63 },
  { 3998,30,62 }, { 3935,31,61 }, { 3872,32,60 }, { 3809,33,59 }, { 3746,34,58 }, { 3683,35,57 }, { 3620,36,56 }, { 3557,37,55 }, { 3494,38,54 }, { 3431,39,53 }, { 3368,40,52 }, { 3305,41,51 }, { 3242,42,50 }, { 3179,43,49 }, { 3116,44,48 }, { 3053,45,47 }, { 2990,46,46 }, { 2927,47,45 }, { 2864,48,44 }, { 2801,49,43 },
  { 2738,50,42 }, { 2675,51,41 }, { 2612,52,40 }, { 2549,53,39 }, { 2486,54,38 }, { 2423,55,37 }, { 2360,56,36 }, { 2297,57,35 }, { 2234,58,34 }, { 2171,59,33 }, { 2108,60,32 }, { 2045,61,31 }, { 1982,62,30 }, { 1919,63,29 }, { 4062,30,63 }, { 3999,31,62 }, { 3936,32,61 }, { 3873,33,60 }, { 3810,34,59 }, { 3747,35,58 },
  { 3684,36,57 }, { 3621,37,56 }, { 3558,38,55 }, { 3495,39,54 }, { 3432,40,53 }, { 3369,41,52 }, { 3306,42,51 }, { 3243,43,50 }, { 3180,44,49 }, { 3117,45,48 }, { 3054,46,47 }, { 2991,47,46 }, { 2928,48,45 }, { 2865,49,44 }, { 2802,50,43 }, { 2739,51,42 }, { 2676,52,41 }, { 2613,53,40 }, { 2550,54,39 }, { 2487,55,38 },
  { 2424,56,37 }, { 2361,57,36 }, { 2298,58,35 }, { 2235,59,34 }, { 2172,60,33 }, { 2109,61,32 }, { 2046,62,31 }, { 1983,63,30 }, { 4063,31,63 }, { 4000,32,62 }, { 3937,33,61 }, { 3874,34,60 }, { 3811,35,59 }, { 3748,36,58 }, { 3685,37,57 }, { 3622,38,56 }, { 3559,39,55 }, { 3496,40,54 }, { 3433,41,53 }, { 3370,42,52 },
  { 3307,43,51 }, { 3244,44,50 }, { 3181,45,49 }, { 3118,46,48 }, { 3055,47,47 }, { 2992,48,46 }, { 2929,49,45 }, { 2866,50,44 }, { 2803,51,43 }, { 2740,52,42 }, { 2677,53,41 }, { 2614,54,40 }, { 2551,55,39 }, { 2488,56,38 }, { 2425,57,37 }, { 2362,58,36 }, { 2299,59,35 }, { 2236,60,34 }, { 2173,61,33 }, { 2110,62,32 },
  { 2047,63,31 }, { 4064,32,63 }, { 4001,33,62 }, { 3938,34,61 }, { 3875,35,60 }, { 3812,36,59 }, { 3749,37,58 }, { 3686,38,57 }, { 3623,39,56 }, { 3560,40,55 }, { 3497,41,54 }, { 3434,42,53 }, { 3371,43,52 }, { 3308,44,51 }, { 3245,45,50 }, { 3182,46,49 }, { 3119,47,48 }, { 3056,48,47 }, { 2993,49,46 }, { 2930,50,45 },
  { 2867,51,44 }, { 2804,52,43 }, { 2741,53,42 }, { 2678,54,41 }, { 2615,55,40 }, { 2552,56,39 }, { 2489,57,38 }, { 2426,58,37 }, { 2363,59,36 }, { 2300,60,35 }, { 2237,61,34 }, { 2174,62,33 }, { 2111,63,32 }, { 4065,33,63 }, { 4002,34,62 }, { 3939,35,61 }, { 3876,36,60 }, { 3813,37,59 }, { 3750,38,58 }, { 3687,39,57 },
  { 3624,40,56 }, { 3561,41,55 }, { 3498,42,54 }, { 3435,43,53 }, { 3372,44,52 }, { 3309,45,51 }, { 3246,46,50 }, { 3183,47,49 }, { 3120,48,48 }, { 3057,49,47 }, { 2994,50,46 }, { 2931,51,45 }, { 2868,52,44 }, { 2805,53,43 }, { 2742,54,42 }, { 2679,55,41 }, { 2616,56,40 }, { 2553,57,39 }, { 2490,58,38 }, { 2427,59,37 },
  { 2364,60,36 }, { 2301,61,35 }, { 2238,62,34 }, { 2175,63,33 }, { 4066,34,63 }, { 4003,35,62 }, { 3940,36,61 }, { 3877,37,60 }, { 3814,38,59 }, { 3751,39,58 }, { 3688,40,57 }, { 3625,41,56 }, { 3562,42,55 }, { 3499,43,54 }, { 3436,44,53 }, { 3373,45,52 }, { 3310,46,51 }, { 3247,47,50 }, { 3184,48,49 }, { 3121,49,48 },
  { 3058,50,47 }, { 2995,51,46 }, { 2932,52,45 }, { 2869,53,44 }, { 2806,54,43 }, { 2743,55,42 }, { 2680,56,41 }, { 2617,57,40 }, { 2554,58,39 }, { 2491,59,38 }, { 2428,60,37 }, { 2365,61,36 }, { 2302,62,35 }, { 2239,63,34 }, { 4067,35,63 }, { 4004,36,62 }, { 3941,37,61 }, { 3878,38,60 }, { 3815,39,59 }, { 3752,40,58 },
  { 3689,41,57 }, { 3626,42,56 }, { 3563,43,55 }, { 3500,44,54 }, { 3437,45,53 }, { 3374,46,52 }, { 3311,47,51 }, { 3248,48,50 }, { 3185,49,49 }, { 3122,50,48 }, { 3059,51,47 }, { 2996,52,46 }, { 2933,53,45 }, { 2870,54,44 }, { 2807,55,43 }, { 2744,56,42 }, { 2681,57,41 }, { 2618,58,40 }, { 2555,59,39 }, { 2492,60,38 },
  { 2429,61,37 }, { 2366,62,36 }, { 2303,63,35 }, { 4068,36,63 }, { 4005,37,62 }, { 3942,38,61 }, { 3879,39,60 }, { 3816,40,59 }, { 3753,41,58 }, { 3690,42,57 }, { 3627,43,56 }, { 3564,44,55 }, { 3501,45,54 }, { 3438,46,53 }, { 3375,47,52 }, { 3312,48,51 }, { 3249,49,50 }, { 3186,50,49 }, { 3123,51,48 }, { 3060,52,47 },
  { 2997,53,46 }, { 2934,54,45 }, { 2871,55,44 }, { 2808,56,43 }, { 2745,57,42 }, { 2682,58,41 }, { 2619,59,40 }, { 2556,60,39 }, { 2493,61,38 }, { 2430,62,37 }, { 2367,63,36 }, { 4069,37,63 }, { 4006,38,62 }, { 3943,39,61 }, { 3880,40,60 }, { 3817,41,59 }, { 3754,42,58 }, { 3691,43,57 }, { 3628,44,56 }, { 3565,45,55 },
  { 3502,46,54 }, { 3439,47,53 }, { 3376,48,52 }, { 3313,49,51 }, { 3250,50,50 }, { 3187,51,49 }, { 3124,52,48 }, { 3061,53,47 }, { 2998,54,46 }, { 2935,55,45 }, { 2872,56,44 }, { 2809,57,43 }, { 2746,58,42 }, { 2683,59,41 }, { 2620,60,40 }, { 2557,61,39 }, { 2494,62,38 }, { 2431,63,37 }, { 4070,38,63 }, { 4007,39,62 },
  { 3944,40,61 }, { 3881,41,60 }, { 3818,42,59 }, { 3755,43,58 }, { 3692,44,57 }, { 3629,45,56 }, { 3566,46,55 }, { 3503,47,54 }, { 3440,48,53 }, { 3377,49,52 }, { 3314,50,51 }, { 3251,51,50 }, { 3188,52,49 }, { 3125,53,48 }, { 3062,54,47 }, { 2999,55,46 }, { 2936,56,45 }, { 2873,57,44 }, { 2810,58,43 }, { 2747,59,42 },
  { 2684,60,41 }, { 2621,61,40 }, { 2558,62,39 }, { 2495,63,38 }, { 4071,39,63 }, { 4008,40,62 }, { 3945,41,61 }, { 3882,42,60 }, { 3819,43,59 }, { 3756,44,58 }, { 3693,45,57 }, { 3630,46,56 }, { 3567,47,55 }, { 3504,48,54 }, { 3441,49,53 }, { 3378,50,52 }, { 3315,51,51 }, { 3252,52,50 }, { 3189,53,49 }, { 3126,54,48 },
  { 3063,55,47 }, { 3000,56,46 }, { 2937,57,45 }, { 2874,58,44 }, { 2811,59,43 }, { 2748,60,42 }, { 2685,61,41 }, { 2622,62,40 }, { 2559,63,39 }, { 4072,40,63 }, { 4009,41,62 }, { 3946,42,61 }, { 3883,43,60 }, { 3820,44,59 }, { 3757,45,58 }, { 3694,46,57 }, { 3631,47,56 }, { 3568,48,55 }, { 3505,49,54 }, { 3442,50,53 },
  { 3379,51,52 }, { 3316,52,51 }, { 3253,53,50 }, { 3190,54,49 }, { 3127,55,48 }, { 3064,56,47 }, { 3001,57,46 }, { 2938,58,45 }, { 2875,59,44 }, { 2812,60,43 }, { 2749,61,42 }, { 2686,62,41 }, { 2623,63,40 }, { 4073,41,63 }, { 4010,42,62 }, { 3947,43,61 }, { 3884,44,60 }, { 3821,45,59 }, { 3758,46,58 }, { 3695,47,57 },
  { 3632,48,56 }, { 3569,49,55 }, { 3506,50,54 }, { 3443,51,53 }, { 3380,52,52 }, { 3317,53,51 }, { 3254,54,50 }, { 3191,55,49 }, { 3128,56,48 }, { 3065,57,47 }, { 3002,58,46 }, { 2939,59,45 }, { 2876,60,44 }, { 2813,61,43 }, { 2750,62,42 }, { 2687,63,41 }, { 4074,42,63 }, { 4011,43,62 }, { 3948,44,61 }, { 3885,45,60 },
  { 3822,46,59 }, { 3759,47,58 }, { 3696,48,57 }, { 3633,49,56 }, { 3570,50,55 }, { 3507,51,54 }, { 3444,52,53 }, { 3381,53,52 }, { 3318,54,51 }, { 3255,55,50 }, { 3192,56,49 }, { 3129,57,48 }, { 3066,58,47 }, { 3003,59,46 }, { 2940,60,45 }, { 2877,61,44 }, { 2814,62,43 }, { 2751,63,42 }, { 4075,43,63 }, { 4012,44,62 },
  { 3949,45,61 }, { 3886,46,60 }, { 3823,47,59 }, { 3760,48,58 }, { 3697,49,57 }, { 3634,50,56 }, { 3571,51,55 }, { 3508,52,54 }, { 3445,53,53 }, { 3382,54,52 }, { 3319,55,51 }, { 3256,56,50 }, { 3193,57,49 }, { 3130,58,48 }, { 3067,59,47 }, { 3004,60,46 }, { 2941,61,45 }, { 2878,62,44 }, { 2815,63,43 }, { 4076,44,63 },
  { 4013,45,62 }, { 3950,46,61 }, { 3887,47,60 }, { 3824,48,59 }, { 3761,49,58 }, { 3698,50,57 }, { 3635,51,56 }, { 3572,52,55 }, { 3509,53,54 }, { 3446,54,53 }, { 3383,55,52 }, { 3320,56,51 }, { 3257,57,50 }, { 3194,58,49 }, { 3131,59,48 }, { 3068,60,47 }, { 3005,61,46 }, { 2942,62,45 }, { 2879,63,44 }, { 4077,45,63 },
  { 4014,46,62 }, { 3951,47,61 }, { 3888,48,60 }, { 3825,49,59 }, { 3762,50,58 }, { 3699,51,57 }, { 3636,52,56 }, { 3573,53,55 }, { 3510,54,54 }, { 3447,55,53 }, { 3384,56,52 }, { 3321,57,51 }, { 3258,58,50 }, { 3195,59,49 }, { 3132,60,48 }, { 3069,61,47 }, { 3006,62,46 }, { 2943,63,45 }, { 4078,46,63 }, { 4015,47,62 },
  { 3952,48,61 }, { 3889,49,60 }, { 3826,50,59 }, { 3763,51,58 }, { 3700,52,57 }, { 3637,53,56 }, { 3574,54,55 }, { 3511,55,54 }, { 3448,56,53 }, { 3385,57,52 }, { 3322,58,51 }, { 3259,59,50 }, { 3196,60,49 }, { 3133,61,48 }, { 3070,62,47 }, { 3007,63,46 }, { 4079,47,63 }, { 4016,48,62 }, { 3953,49,61 }, { 3890,50,60 },
  { 3827,51,59 }, { 3764,52,58 }, { 3701,53,57 }, { 3638,54,56 }, { 3575,55,55 }, { 3512,56,54 }, { 3449,57,53 }, { 3386,58,52 }, { 3323,59,51 }, { 3260,60,50 }, { 3197,61,49 }, { 3134,62,48 }, { 3071,63,47 }, { 4080,48,63 }, { 4017,49,62 }, { 3954,50,61 }, { 3891,51,60 }, { 3828,52,59 }, { 3765,53,58 }, { 3702,54,57 },
  { 3639,55,56 }, { 3576,56,55 }, { 3513,57,54 }, { 3450,58,53 }, { 3387,59,52 }, { 3324,60,51 }, { 3261,61,50 }, { 3198,62,49 }, { 3135,63,48 }, { 4081,49,63 }, { 4018,50,62 }, { 3955,51,61 }, { 3892,52,60 }, { 3829,53,59 }, { 3766,54,58 }, { 3703,55,57 }, { 3640,56,56 }, { 3577,57,55 }, { 3514,58,54 }, { 3451,59,53 },
  { 3388,60,52 }, { 3325,61,51 }, { 3262,62,50 }, { 3199,63,49 }, { 4082,50,63 }, { 4019,51,62 }, { 3956,52,61 }, { 3893,53,60 }, { 3830,54,59 }, { 3767,55,58 }, { 3704,56,57 }, { 3641,57,56 }, { 3578,58,55 }, { 3515,59,54 }, { 3452,60,53 }, { 3389,61,52 }, { 3326,62,51 }, { 3263,63,50 }, { 4083,51,63 }, { 4020,52,62 },
  { 3957,53,61 }, { 3894,54,60 }, { 3831,55,59 }, { 3768,56,58 }, { 3705,57,57 }, { 3642,58,56 }, { 3579,59,55 }, { 3516,60,54 }, { 3453,61,53 }, { 3390,62,52 }, { 3327,63,51 }, { 4084,52,63 }, { 4021,53,62 }, { 3958,54,61 }, { 3895,55,60 }, { 3832,56,59 }, { 3769,57,58 }, { 3706,58,57 }, { 3643,59,56 }, { 3580,60,55 },
  { 3517,61,54 }, { 3454,62,53 }, { 3391,63,52 }, { 4085,53,63 }, { 4022,54,62 }, { 3959,55,61 }, { 3896,56,60 }, { 3833,57,59 }, { 3770,58,58 }, { 3707,59,57 }, { 3644,60,56 }, { 3581,61,55 }, { 3518,62,54 }, { 3455,63,53 }, { 4086,54,63 }, { 4023,55,62 }, { 3960,56,61 }, { 3897,57,60 }, { 3834,58,59 }, { 3771,59,58 },
  { 3708,60,57 }, { 3645,61,56 }, { 3582,62,55 }, { 3519,63,54 }, { 4087,55,63 }, { 4024,56,62 }, { 3961,57,61 }, { 3898,58,60 }, { 3835,59,59 }, { 3772,60,58 }, { 3709,61,57 }, { 3646,62,56 }, { 3583,63,55 }, { 4088,56,63 }, { 4025,57,62 }, { 3962,58,61 }, { 3899,59,60 }, { 3836,60,59 }, { 3773,61,58 }, { 3710,62,57 },
  { 3647,63,56 }, { 4089,57,63 }, { 4026,58,62 }, { 3963,59,61 }, { 3900,60,60 }, { 3837,61,59 }, { 3774,62,58 }, { 3711,63,57 }, { 4090,58,63 }, { 4027,59,62 }, { 3964,60,61 }, { 3901,61,60 }, { 3838,62,59 }, { 3775,63,58 }, { 4091,59,63 }, { 4028,60,62 }, { 3965,61,61 }, { 3902,62,60 }, { 3839,63,59 }, { 4092,60,63 },
  { 4029,61,62 }, { 3966,62,61 }, { 3903,63,60 }, { 4093,61,63 }, { 4030,62,62 }, { 3967,63,61 }, { 4094,62,63 }, { 4031,63,62 }, { 4095,63,63 }, { 0,0,0 }, { 0,0,0 }, { 1,0,1 }, { 0,0,0 }, { 1,0,1 }, { 2,0,2 }, { 3,0,3 }, { 0,0,0 }, { 1,0,1 }, { 2,0,2 }, { 3,0,3 },
  { 4,0,4 }, { 5,0,5 }, { 6,0,6 }, { 7,0,7 }, { 0,0,0 }, { 1,0,1 }, { 2,0,2 }, { 3,0,3 }, { 4,0,4 }, { 5,0,5 }, { 6,0,6 }, { 7,0,7 }, { 8,0,8 }, { 9,0,9 }, { 10,0,10 }, { 11,0,11 }, { 12,0,12 }, { 13,0,13 }, { 14,0,14 }, { 15,0,15 },
  { 0,0,0 }, { 1,0,1 }, { 2,0,2 }, { 3,0,3 }, { 4,0,4 }, { 5,0,5 }, { 6,0,6 }, { 7,0,7 }, { 8,0,8 }, { 9,0,9 }, { 10,0,10 }, { 11,0,11 }, { 12,0,12 }, { 13,0,13 }, { 14,0,14 }, { 15,0,15 }, { 16,0,16 }, { 17,0,17 }, { 18,0,18 }, { 19,0,19 },
  { 20,0,20 }, { 21,0,21 }, { 22,0,22 }, { 23,0,23 }, { 24,0,24 }, { 25,0,25 }, { 26,0,26 }, { 27,0,27 }, { 28,0,28 }, { 29,0,29 }, { 30,0,30 }, { 31,0,31 }, { 0,0,0 }, { 1,0,1 }, { 2,0,2 }, { 3,0,3 }, { 4,0,4 }, { 5,0,5 }, { 6,0,6 }, { 7,0,7 },
  { 8,0,8 }, { 9,0,9 }, { 10,0,10 }, { 11,0,11 }, { 12,0,12 }, { 13,0,13 }, { 14,0,14 }, { 15,0,15 }, { 16,0,16 }, { 17,0,17 }, { 18,0,18 }, { 19,0,19 }, { 20,0,20 }, { 21,0,21 }, { 22,0,22 }, { 23,0,23 }, { 24,0,24 }, { 25,0,25 }, { 26,0,26 }, { 27,0,27 },
  { 28,0,28 }, { 29,0,29 }, { 30,0,30 }, { 31,0,31 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 },
  { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 63,0,63 }, { 0,0,0 }, { 1,1,0 }, { 0,0,0 }, { 2,0,1 },
  { 1,1,0 }, { 3,1,1 }, { 0,0,0 }, { 2,0,1 }, { 1,1,0 }, { 3,1,1 }, { 4,0,2 }, { 6,0,3 }, { 5,1,2 }, { 7,1,3 }, { 0,0,0 }, { 2,0,1 }, { 1,1,0 }, { 4,0,2 }, { 3,1,1 }, { 6,0,3 }, { 5,1,2 }, { 8,0,4 }, { 7,1,3 }, { 10,0,5 },
  { 9,1,4 }, { 12,0,6 }, { 11,1,5 }, { 14,0,7 }, { 13,1,6 }, { 15,1,7 }, { 0,0,0 }, { 2,0,1 }, { 1,1,0 }, { 4,0,2 }, { 3,1,1 }, { 6,0,3 }, { 5,1,2 }, { 8,0,4 }, { 7,1,3 }, { 10,0,5 }, { 9,1,4 }, { 12,0,6 }, { 11,1,5 }, { 14,0,7 },
  { 13,1,6 }, { 15,1,7 }, { 16,0,8 }, { 18,0,9 }, { 17,1,8 }, { 20,0,10 }, { 19,1,9 }, { 22,0,11 }, { 21,1,10 }, { 24,0,12 }, { 23,1,11 }, { 26,0,13 }, { 25,1,12 }, { 28,0,14 }, { 27,1,13 }, { 30,0,15 }, { 29,1,14 }, { 31,1,15 }, { 0,0,0 }, { 2,0,1 },
  { 1,1,0 }, { 4,0,2 }, { 3,1,1 }, { 6,0,3 }, { 5,1,2 }, { 8,0,4 }, { 7,1,3 }, { 10,0,5 }, { 9,1,4 }, { 12,0,6 }, { 11,1,5 }, { 14,0,7 }, { 13,1,6 }, { 15,1,7 }, { 16,0,8 }, { 18,0,9 }, { 17,1,8 }, { 20,0,10 }, { 19,1,9 }, { 22,0,11 },
  { 21,1,10 }, { 24,0,12 }, { 23,1,11 }, { 26,0,13 }, { 25,1,12 }, { 28,0,14 }, { 27,1,13 }, { 30,0,15 }, { 29,1,14 }, { 31,1,15 }, { 32,0,16 }, { 34,0,17 }, { 33,1,16 }, { 36,0,18 }, { 35,1,17 }, { 38,0,19 }, { 37,1,18 }, { 40,0,20 }, { 39,1,19 }, { 42,0,21 },
  { 41,1,20 }, { 44,0,22 }, { 43,1,21 }, { 46,0,23 }, { 45,1,22 }, { 47,1,23 }, { 48,0,24 }, { 50,0,25 }, { 49,1,24 }, { 52,0,26 }, { 51,1,25 }, { 54,0,27 }, { 53,1,26 }, { 56,0,28 }, { 55,1,27 }, { 58,0,29 }, { 57,1,28 }, { 60,0,30 }, { 59,1,29 }, { 62,0,31 },
  { 61,1,30 }, { 63,1,31 }, { 0,0,0 }, { 2,0,1 }, { 1,1,0 }, { 4,0,2 }, { 3,1,1 }, { 6,0,3 }, { 5,1,2 }, { 8,0,4 }, { 7,1,3 }, { 10,0,5 }, { 9,1,4 }, { 12,0,6 }, { 11,1,5 }, { 14,0,7 }, { 13,1,6 }, { 15,1,7 }, { 16,0,8 }, { 18,0,9 },
  { 17,1,8 }, { 20,0,10 }, { 19,1,9 }, { 22,0,11 }, { 21,1,10 }, { 24,0,12 }, { 23,1,11 }, { 26,0,13 }, { 25,1,12 }, { 28,0,14 }, { 27,1,13 }, { 30,0,15 }, { 29,1,14 }, { 31,1,15 }, { 32,0,16 }, { 34,0,17 }, { 33,1,16 }, { 36,0,18 }, { 35,1,17 }, { 38,0,19 },
  { 37,1,18 }, { 40,0,20 }, { 39,1,19 }, { 42,0,21 }, { 41,1,20 }, { 44,0,22 }, { 43,1,21 }, { 46,0,23 }, { 45,1,22 }, { 47,1,23 }, { 48,0,24 }, { 50,0,25 }, { 49,1,24 }, { 52,0,26 }, { 51,1,25 }, { 54,0,27 }, { 53,1,26 }, { 56,0,28 }, { 55,1,27 }, { 58,0,29 },
  { 57,1,28 }, { 60,0,30 }, { 59,1,29 }, { 62,0,31 }, { 61,1,30 }, { 63,1,31 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 },
  { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 },
  { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 },
  { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 127,1,63 }, { 0,0,0 }, { 1,1,0 }, { 2,2,0 }, { 3,3,0 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 5,1,1 }, { 2,2,0 }, { 6,2,1 },
  { 3,3,0 }, { 7,3,1 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 8,0,2 }, { 5,1,1 }, { 2,2,0 }, { 12,0,3 }, { 9,1,2 }, { 6,2,1 }, { 3,3,0 }, { 13,1,3 }, { 10,2,2 }, { 7,3,1 }, { 14,2,3 }, { 11,3,2 }, { 15,3,3 }, { 0,0,0 }, { 4,0,1 },
  { 1,1,0 }, { 8,0,2 }, { 5,1,1 }, { 2,2,0 }, { 12,0,3 }, { 9,1,2 }, { 6,2,1 }, { 3,3,0 }, { 13,1,3 }, { 10,2,2 }, { 7,3,1 }, { 14,2,3 }, { 11,3,2 }, { 15,3,3 }, { 16,0,4 }, { 20,0,5 }, { 17,1,4 }, { 24,0,6 }, { 21,1,5 }, { 18,2,4 },
  { 28,0,7 }, { 25,1,6 }, { 22,2,5 }, { 19,3,4 }, { 29,1,7 }, { 26,2,6 }, { 23,3,5 }, { 30,2,7 }, { 27,3,6 }, { 31,3,7 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 8,0,2 }, { 5,1,1 }, { 2,2,0 }, { 12,0,3 }, { 9,1,2 }, { 6,2,1 }, { 3,3,0 },
  { 13,1,3 }, { 10,2,2 }, { 7,3,1 }, { 14,2,3 }, { 11,3,2 }, { 15,3,3 }, { 16,0,4 }, { 20,0,5 }, { 17,1,4 }, { 24,0,6 }, { 21,1,5 }, { 18,2,4 }, { 28,0,7 }, { 25,1,6 }, { 22,2,5 }, { 19,3,4 }, { 29,1,7 }, { 26,2,6 }, { 23,3,5 }, { 30,2,7 },
  { 27,3,6 }, { 31,3,7 }, { 32,0,8 }, { 36,0,9 }, { 33,1,8 }, { 40,0,10 }, { 37,1,9 }, { 34,2,8 }, { 44,0,11 }, { 41,1,10 }, { 38,2,9 }, { 35,3,8 }, { 45,1,11 }, { 42,2,10 }, { 39,3,9 }, { 46,2,11 }, { 43,3,10 }, { 47,3,11 }, { 48,0,12 }, { 52,0,13 },
  { 49,1,12 }, { 56,0,14 }, { 53,1,13 }, { 50,2,12 }, { 60,0,15 }, { 57,1,14 }, { 54,2,13 }, { 51,3,12 }, { 61,1,15 }, { 58,2,14 }, { 55,3,13 }, { 62,2,15 }, { 59,3,14 }, { 63,3,15 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 8,0,2 }, { 5,1,1 }, { 2,2,0 },
  { 12,0,3 }, { 9,1,2 }, { 6,2,1 }, { 3,3,0 }, { 13,1,3 }, { 10,2,2 }, { 7,3,1 }, { 14,2,3 }, { 11,3,2 }, { 15,3,3 }, { 16,0,4 }, { 20,0,5 }, { 17,1,4 }, { 24,0,6 }, { 21,1,5 }, { 18,2,4 }, { 28,0,7 }, { 25,1,6 }, { 22,2,5 }, { 19,3,4 },
  { 29,1,7 }, { 26,2,6 }, { 23,3,5 }, { 30,2,7 }, { 27,3,6 }, { 31,3,7 }, { 32,0,8 }, { 36,0,9 }, { 33,1,8 }, { 40,0,10 }, { 37,1,9 }, { 34,2,8 }, { 44,0,11 }, { 41,1,10 }, { 38,2,9 }, { 35,3,8 }, { 45,1,11 }, { 42,2,10 }, { 39,3,9 }, { 46,2,11 },
  { 43,3,10 }, { 47,3,11 }, { 48,0,12 }, { 52,0,13 }, { 49,1,12 }, { 56,0,14 }, { 53,1,13 }, { 50,2,12 }, { 60,0,15 }, { 57,1,14 }, { 54,2,13 }, { 51,3,12 }, { 61,1,15 }, { 58,2,14 }, { 55,3,13 }, { 62,2,15 }, { 59,3,14 }, { 63,3,15 }, { 64,0,16 }, { 68,0,17 },
  { 65,1,16 }, { 72,0,18 }, { 69,1,17 }, { 66,2,16 }, { 76,0,19 }, { 73,1,18 }, { 70,2,17 }, { 67,3,16 }, { 77,1,19 }, { 74,2,18 }, { 71,3,17 }, { 78,2,19 }, { 75,3,18 }, { 79,3,19 }, { 80,0,20 }, { 84,0,21 }, { 81,1,20 }, { 88,0,22 }, { 85,1,21 }, { 82,2,20 },
  { 92,0,23 }, { 89,1,22 }, { 86,2,21 }, { 83,3,20 }, { 93,1,23 }, { 90,2,22 }, { 87,3,21 }, { 94,2,23 }, { 91,3,22 }, { 95,3,23 }, { 96,0,24 }, { 100,0,25 }, { 97,1,24 }, { 104,0,26 }, { 101,1,25 }, { 98,2,24 }, { 108,0,27 }, { 105,1,26 }, { 102,2,25 }, { 99,3,24 },
  { 109,1,27 }, { 106,2,26 }, { 103,3,25 }, { 110,2,27 }, { 107,3,26 }, { 111,3,27 }, { 112,0,28 }, { 116,0,29 }, { 113,1,28 }, { 120,0,30 }, { 117,1,29 }, { 114,2,28 }, { 124,0,31 }, { 121,1,30 }, { 118,2,29 }, { 115,3,28 }, { 125,1,31 }, { 122,2,30 }, { 119,3,29 }, { 126,2,31 },
  { 123,3,30 }, { 127,3,31 }, { 0,0,0 }, { 4,0,1 }, { 1,1,0 }, { 8,0,2 }, { 5,1,1 }, { 2,2,0 }, { 12,0,3 }, { 9,1,2 }, { 6,2,1 }, { 3,3,0 }, { 13,1,3 }, { 10,2,2 }, { 7,3,1 }, { 14,2,3 }, { 11,3,2 }, { 15,3,3 }, { 16,0,4 }, { 20,0,5 },
  { 17,1,4 }, { 24,0,6 }, { 21,1,5 }, { 18,2,4 }, { 28,0,7 }, { 25,1,6 }, { 22,2,5 }, { 19,3,4 }, { 29,1,7 }, { 26,2,6 }, { 23,3,5 }, { 30,2,7 }, { 27,3,6 }, { 31,3,7 }, { 32,0,8 }, { 36,0,9 }, { 33,1,8 }, { 40,0,10 }, { 37,1,9 }, { 34,2,8 },
  { 44,0,11 }, { 41,1,10 }, { 38,2,9 }, { 35,3,8 }, { 45,1,11 }, { 42,2,10 }, { 39,3,9 }, { 46,2,11 }, { 43,3,10 }, { 47,3,11 }, { 48,0,12 }, { 52,0,13 }, { 49,1,12 }, { 56,0,14 }, { 53,1,13 }, { 50,2,12 }, { 60,0,15 }, { 57,1,14 }, { 54,2,13 }, { 51,3,12 },
  { 61,1,15 }, { 58,2,14 }, { 55,3,13 }, { 62,2,15 }, { 59,3,14 }, { 63,3,15 }, { 64,0,16 }, { 68,0,17 }, { 65,1,16 }, { 72,0,18 }, { 69,1,17 }, { 66,2,16 }, { 76,0,19 }, { 73,1,18 }, { 70,2,17 }, { 67,3,16 }, { 77,1,19 }, { 74,2,18 }, { 71,3,17 }, { 78,2,19 },
  { 75,3,18 }, { 79,3,19 }, { 80,0,20 }, { 84,0,21 }, { 81,1,20 }, { 88,0,22 }, { 85,1,21 }, { 82,2,20 }, { 92,0,23 }, { 89,1,22 }, { 86,2,21 }, { 83,3,20 }, { 93,1,23 }, { 90,2,22 }, { 87,3,21 }, { 94,2,23 }, { 91,3,22 }, { 95,3,23 }, { 96,0,24 }, { 100,0,25 },
  { 97,1,24 }, { 104,0,26 }, { 101,1,25 }, { 98,2,24 }, { 108,0,27 }, { 105,1,26 }, { 102,2,25 }, { 99,3,24 }, { 109,1,27 }, { 106,2,26 }, { 103,3,25 }, { 110,2,27 }, { 107,3,26 }, { 111,3,27 }, { 112,0,28 }, { 116,0,29 }, { 113,1,28 }, { 120,0,30 }, { 117,1,29 }, { 114,2,28 },
  { 124,0,31 }, { 121,1,30 }, { 118,2,29 }, { 115,3,28 }, { 125,1,31 }, { 122,2,30 }, { 119,3,29 }, { 126,2,31 }, { 123,3,30 }, { 127,3,31 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 },
  { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 },
  { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 },
  { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 },
  { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 },
  { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 },
  { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 255,3,63 }, { 0,0,0 }, { 1,1,0 },
  { 2,2,0 }, { 3,3,0 }, { 4,4,0 }, { 5,5,0 }, { 6,6,0 }, { 7,7,0 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 }, { 9,1,1 }, { 2,2,0 }, { 10,2,1 }, { 3,3,0 }, { 11,3,1 }, { 4,4,0 }, { 12,4,1 }, { 5,5,0 }, { 13,5,1 }, { 6,6,0 }, { 14,6,1 },
  { 7,7,0 }, { 15,7,1 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 }, { 16,0,2 }, { 9,1,1 }, { 2,2,0 }, { 24,0,3 }, { 17,1,2 }, { 10,2,1 }, { 3,3,0 }, { 25,1,3 }, { 18,2,2 }, { 11,3,1 }, { 26,2,3 }, { 19,3,2 }, { 27,3,3 }, { 4,4,0 }, { 12,4,1 },
  { 5,5,0 }, { 20,4,2 }, { 13,5,1 }, { 6,6,0 }, { 28,4,3 }, { 21,5,2 }, { 14,6,1 }, { 7,7,0 }, { 29,5,3 }, { 22,6,2 }, { 15,7,1 }, { 30,6,3 }, { 23,7,2 }, { 31,7,3 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 }, { 16,0,2 }, { 9,1,1 }, { 2,2,0 },
  { 24,0,3 }, { 17,1,2 }, { 10,2,1 }, { 3,3,0 }, { 25,1,3 }, { 18,2,2 }, { 11,3,1 }, { 26,2,3 }, { 19,3,2 }, { 27,3,3 }, { 32,0,4 }, { 40,0,5 }, { 33,1,4 }, { 48,0,6 }, { 41,1,5 }, { 34,2,4 }, { 56,0,7 }, { 49,1,6 }, { 42,2,5 }, { 35,3,4 },
  { 57,1,7 }, { 50,2,6 }, { 43,3,5 }, { 58,2,7 }, { 51,3,6 }, { 59,3,7 }, { 4,4,0 }, { 12,4,1 }, { 5,5,0 }, { 20,4,2 }, { 13,5,1 }, { 6,6,0 }, { 28,4,3 }, { 21,5,2 }, { 14,6,1 }, { 7,7,0 }, { 29,5,3 }, { 22,6,2 }, { 15,7,1 }, { 30,6,3 },
  { 23,7,2 }, { 31,7,3 }, { 36,4,4 }, { 44,4,5 }, { 37,5,4 }, { 52,4,6 }, { 45,5,5 }, { 38,6,4 }, { 60,4,7 }, { 53,5,6 }, { 46,6,5 }, { 39,7,4 }, { 61,5,7 }, { 54,6,6 }, { 47,7,5 }, { 62,6,7 }, { 55,7,6 }, { 63,7,7 }, { 0,0,0 }, { 8,0,1 },
  { 1,1,0 }, { 16,0,2 }, { 9,1,1 }, { 2,2,0 }, { 24,0,3 }, { 17,1,2 }, { 10,2,1 }, { 3,3,0 }, { 25,1,3 }, { 18,2,2 }, { 11,3,1 }, { 26,2,3 }, { 19,3,2 }, { 27,3,3 }, { 32,0,4 }, { 40,0,5 }, { 33,1,4 }, { 48,0,6 }, { 41,1,5 }, { 34,2,4 },
  { 56,0,7 }, { 49,1,6 }, { 42,2,5 }, { 35,3,4 }, { 57,1,7 }, { 50,2,6 }, { 43,3,5 }, { 58,2,7 }, { 51,3,6 }, { 59,3,7 }, { 4,4,0 }, { 12,4,1 }, { 5,5,0 }, { 20,4,2 }, { 13,5,1 }, { 6,6,0 }, { 28,4,3 }, { 21,5,2 }, { 14,6,1 }, { 7,7,0 },
  { 29,5,3 }, { 22,6,2 }, { 15,7,1 }, { 30,6,3 }, { 23,7,2 }, { 31,7,3 }, { 64,0,8 }, { 72,0,9 }, { 65,1,8 }, { 80,0,10 }, { 73,1,9 }, { 66,2,8 }, { 88,0,11 }, { 81,1,10 }, { 74,2,9 }, { 67,3,8 }, { 89,1,11 }, { 82,2,10 }, { 75,3,9 }, { 90,2,11 },
  { 83,3,10 }, { 91,3,11 }, { 36,4,4 }, { 44,4,5 }, { 37,5,4 }, { 52,4,6 }, { 45,5,5 }, { 38,6,4 }, { 60,4,7 }, { 53,5,6 }, { 46,6,5 }, { 39,7,4 }, { 61,5,7 }, { 54,6,6 }, { 47,7,5 }, { 62,6,7 }, { 55,7,6 }, { 63,7,7 }, { 96,0,12 }, { 104,0,13 },
  { 97,1,12 }, { 112,0,14 }, { 105,1,13 }, { 98,2,12 }, { 120,0,15 }, { 113,1,14 }, { 106,2,13 }, { 99,3,12 }, { 121,1,15 }, { 114,2,14 }, { 107,3,13 }, { 122,2,15 }, { 115,3,14 }, { 123,3,15 }, { 68,4,8 }, { 76,4,9 }, { 69,5,8 }, { 84,4,10 }, { 77,5,9 }, { 70,6,8 },
  { 92,4,11 }, { 85,5,10 }, { 78,6,9 }, { 71,7,8 }, { 93,5,11 }, { 86,6,10 }, { 79,7,9 }, { 94,6,11 }, { 87,7,10 }, { 95,7,11 }, { 100,4,12 }, { 108,4,13 }, { 101,5,12 }, { 116,4,14 }, { 109,5,13 }, { 102,6,12 }, { 124,4,15 }, { 117,5,14 }, { 110,6,13 }, { 103,7,12 },
  { 125,5,15 }, { 118,6,14 }, { 111,7,13 }, { 126,6,15 }, { 119,7,14 }, { 127,7,15 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 }, { 16,0,2 }, { 9,1,1 }, { 2,2,0 }, { 24,0,3 }, { 17,1,2 }, { 10,2,1 }, { 3,3,0 }, { 25,1,3 }, { 18,2,2 }, { 11,3,1 }, { 26,2,3 },
  { 19,3,2 }, { 27,3,3 }, { 32,0,4 }, { 40,0,5 }, { 33,1,4 }, { 48,0,6 }, { 41,1,5 }, { 34,2,4 }, { 56,0,7 }, { 49,1,6 }, { 42,2,5 }, { 35,3,4 }, { 57,1,7 }, { 50,2,6 }, { 43,3,5 }, { 58,2,7 }, { 51,3,6 }, { 59,3,7 }, { 4,4,0 }, { 12,4,1 },
  { 5,5,0 }, { 20,4,2 }, { 13,5,1 }, { 6,6,0 }, { 28,4,3 }, { 21,5,2 }, { 14,6,1 }, { 7,7,0 }, { 29,5,3 }, { 22,6,2 }, { 15,7,1 }, { 30,6,3 }, { 23,7,2 }, { 31,7,3 }, { 64,0,8 }, { 72,0,9 }, { 65,1,8 }, { 80,0,10 }, { 73,1,9 }, { 66,2,8 },
  { 88,0,11 }, { 81,1,10 }, { 74,2,9 }, { 67,3,8 }, { 89,1,11 }, { 82,2,10 }, { 75,3,9 }, { 90,2,11 }, { 83,3,10 }, { 91,3,11 }, { 36,4,4 }, { 44,4,5 }, { 37,5,4 }, { 52,4,6 }, { 45,5,5 }, { 38,6,4 }, { 60,4,7 }, { 53,5,6 }, { 46,6,5 }, { 39,7,4 },
  { 61,5,7 }, { 54,6,6 }, { 47,7,5 }, { 62,6,7 }, { 55,7,6 }, { 63,7,7 }, { 96,0,12 }, { 104,0,13 }, { 97,1,12 }, { 112,0,14 }, { 105,1,13 }, { 98,2,12 }, { 120,0,15 }, { 113,1,14 }, { 106,2,13 }, { 99,3,12 }, { 121,1,15 }, { 114,2,14 }, { 107,3,13 }, { 122,2,15 },
  { 115,3,14 }, { 123,3,15 }, { 68,4,8 }, { 76,4,9 }, { 69,5,8 }, { 84,4,10 }, { 77,5,9 }, { 70,6,8 }, { 92,4,11 }, { 85,5,10 }, { 78,6,9 }, { 71,7,8 }, { 93,5,11 }, { 86,6,10 }, { 79,7,9 }, { 94,6,11 }, { 87,7,10 }, { 95,7,11 }, { 128,0,16 }, { 136,0,17 },
  { 129,1,16 }, { 144,0,18 }, { 137,1,17 }, { 130,2,16 }, { 152,0,19 }, { 145,1,18 }, { 138,2,17 }, { 131,3,16 }, { 153,1,19 }, { 146,2,18 }, { 139,3,17 }, { 154,2,19 }, { 147,3,18 }, { 155,3,19 }, { 100,4,12 }, { 108,4,13 }, { 101,5,12 }, { 116,4,14 }, { 109,5,13 }, { 102,6,12 },
  { 124,4,15 }, { 117,5,14 }, { 110,6,13 }, { 103,7,12 }, { 125,5,15 }, { 118,6,14 }, { 111,7,13 }, { 126,6,15 }, { 119,7,14 }, { 127,7,15 }, { 160,0,20 }, { 168,0,21 }, { 161,1,20 }, { 176,0,22 }, { 169,1,21 }, { 162,2,20 }, { 184,0,23 }, { 177,1,22 }, { 170,2,21 }, { 163,3,20 },
  { 185,1,23 }, { 178,2,22 }, { 171,3,21 }, { 186,2,23 }, { 179,3,22 }, { 187,3,23 }, { 132,4,16 }, { 140,4,17 }, { 133,5,16 }, { 148,4,18 }, { 141,5,17 }, { 134,6,16 }, { 156,4,19 }, { 149,5,18 }, { 142,6,17 }, { 135,7,16 }, { 157,5,19 }, { 150,6,18 }, { 143,7,17 }, { 158,6,19 },
  { 151,7,18 }, { 159,7,19 }, { 192,0,24 }, { 200,0,25 }, { 193,1,24 }, { 208,0,26 }, { 201,1,25 }, { 194,2,24 }, { 216,0,27 }, { 209,1,26 }, { 202,2,25 }, { 195,3,24 }, { 217,1,27 }, { 210,2,26 }, { 203,3,25 }, { 218,2,27 }, { 211,3,26 }, { 219,3,27 }, { 164,4,20 }, { 172,4,21 },
  { 165,5,20 }, { 180,4,22 }, { 173,5,21 }, { 166,6,20 }, { 188,4,23 }, { 181,5,22 }, { 174,6,21 }, { 167,7,20 }, { 189,5,23 }, { 182,6,22 }, { 175,7,21 }, { 190,6,23 }, { 183,7,22 }, { 191,7,23 }, { 224,0,28 }, { 232,0,29 }, { 225,1,28 }, { 240,0,30 }, { 233,1,29 }, { 226,2,28 },
  { 248,0,31 }, { 241,1,30 }, { 234,2,29 }, { 227,3,28 }, { 249,1,31 }, { 242,2,30 }, { 235,3,29 }, { 250,2,31 }, { 243,3,30 }, { 251,3,31 }, { 196,4,24 }, { 204,4,25 }, { 197,5,24 }, { 212,4,26 }, { 205,5,25 }, { 198,6,24 }, { 220,4,27 }, { 213,5,26 }, { 206,6,25 }, { 199,7,24 },
  { 221,5,27 }, { 214,6,26 }, { 207,7,25 }, { 222,6,27 }, { 215,7,26 }, { 223,7,27 }, { 228,4,28 }, { 236,4,29 }, { 229,5,28 }, { 244,4,30 }, { 237,5,29 }, { 230,6,28 }, { 252,4,31 }, { 245,5,30 }, { 238,6,29 }, { 231,7,28 }, { 253,5,31 }, { 246,6,30 }, { 239,7,29 }, { 254,6,31 },
  { 247,7,30 }, { 255,7,31 }, { 0,0,0 }, { 8,0,1 }, { 1,1,0 }, { 16,0,2 }, { 9,1,1 }, { 2,2,0 }, { 24,0,3 }, { 17,1,2 }, { 10,2,1 }, { 3,3,0 }, { 25,1,3 }, { 18,2,2 }, { 11,3,1 }, { 26,2,3 }, { 19,3,2 }, { 27,3,3 }, { 32,0,4 }, { 40,0,5 },
  { 33,1,4 }, { 48,0,6 }, { 41,1,5 }, { 34,2,4 }, { 56,0,7 }, { 49,1,6 }, { 42,2,5 }, { 35,3,4 }, { 57,1,7 }, { 50,2,6 }, { 43,3,5 }, { 58,2,7 }, { 51,3,6 }, { 59,3,7 }, { 4,4,0 }, { 12,4,1 }, { 5,5,0 }, { 20,4,2 }, { 13,5,1 }, { 6,6,0 },
  { 28,4,3 }, { 21,5,2 }, { 14,6,1 }, { 7,7,0 }, { 29,5,3 }, { 22,6,2 }, { 15,7,1 }, { 30,6,3 }, { 23,7,2 }, { 31,7,3 }, { 64,0,8 }, { 72,0,9 }, { 65,1,8 }, { 80,0,10 }, { 73,1,9 }, { 66,2,8 }, { 88,0,11 }, { 81,1,10 }, { 74,2,9 }, { 67,3,8 },
  { 89,1,11 }, { 82,2,10 }, { 75,3,9 }, { 90,2,11 }, { 83,3,10 }, { 91,3,11 }, { 36,4,4 }, { 44,4,5 }, { 37,5,4 }, { 52,4,6 }, { 45,5,5 }, { 38,6,4 }, { 60,4,7 }, { 53,5,6 }, { 46,6,5 }, { 39,7,4 }, { 61,5,7 }, { 54,6,6 }, { 47,7,5 }, { 62,6,7 },
  { 55,7,6 }, { 63,7,7 }, { 96,0,12 }, { 104,0,13 }, { 97,1,12 }, { 112,0,14 }, { 105,1,13 }, { 98,2,12 }, { 120,0,15 }, { 113,1,14 }, { 106,2,13 }, { 99,3,12 }, { 121,1,15 }, { 114,2,14 }, { 107,3,13 }, { 122,2,15 }, { 115,3,14 }, { 123,3,15 }, { 68,4,8 }, { 76,4,9 },
  { 69,5,8 }, { 84,4,10 }, { 77,5,9 }, { 70,6,8 }, { 92,4,11 }, { 85,5,10 }, { 78,6,9 }, { 71,7,8 }, { 93,5,11 }, { 86,6,10 }, { 79,7,9 }, { 94,6,11 }, { 87,7,10 }, { 95,7,11 }, { 128,0,16 }, { 136,0,17 }, { 129,1,16 }, { 144,0,18 }, { 137,1,17 }, { 130,2,16 },
  { 152,0,19 }, { 145,1,18 }, { 138,2,17 }, { 131,3,16 }, { 153,1,19 }, { 146,2,18 }, { 139,3,17 }, { 154,2,19 }, { 147,3,18 }, { 155,3,19 }, { 100,4,12 }, { 108,4,13 }, { 101,5,12 }, { 116,4,14 }, { 109,5,13 }, { 102,6,12 }, { 124,4,15 }, { 117,5,14 }, { 110,6,13 }, { 103,7,12 },
  { 125,5,15 }, { 118,6,14 }, { 111,7,13 }, { 126,6,15 }, { 119,7,14 }, { 127,7,15 }, { 160,0,20 }, { 168,0,21 }, { 161,1,20 }, { 176,0,22 }, { 169,1,21 }, { 162,2,20 }, { 184,0,23 }, { 177,1,22 }, { 170,2,21 }, { 163,3,20 }, { 185,1,23 }, { 178,2,22 }, { 171,3,21 }, { 186,2,23 },
  { 179,3,22 }, { 187,3,23 }, { 132,4,16 }, { 140,4,17 }, { 133,5,16 }, { 148,4,18 }, { 141,5,17 }, { 134,6,16 }, { 156,4,19 }, { 149,5,18 }, { 142,6,17 }, { 135,7,16 }, { 157,5,19 }, { 150,6,18 }, { 143,7,17 }, { 158,6,19 }, { 151,7,18 }, { 159,7,19 }, { 192,0,24 }, { 200,0,25 },
  { 193,1,24 }, { 208,0,26 }, { 201,1,25 }, { 194,2,24 }, { 216,0,27 }, { 209,1,26 }, { 202,2,25 }, { 195,3,24 }, { 217,1,27 }, { 210,2,26 }, { 203,3,25 }, { 218,2,27 }, { 211,3,26 }, { 219,3,27 }, { 164,4,20 }, { 172,4,21 }, { 165,5,20 }, { 180,4,22 }, { 173,5,21 }, { 166,6,20 },
  { 188,4,23 }, { 181,5,22 }, { 174,6,21 }, { 167,7,20 }, { 189,5,23 }, { 182,6,22 }, { 175,7,21 }, { 190,6,23 }, { 183,7,22 }, { 191,7,23 }, { 224,0,28 }, { 232,0,29 }, { 225,1,28 }, { 240,0,30 }, { 233,1,29 }, { 226,2,28 }, { 248,0,31 }, { 241,1,30 }, { 234,2,29 }, { 227,3,28 },
  { 249,1,31 }, { 242,2,30 }, { 235,3,29 }, { 250,2,31 }, { 243,3,30 }, { 251,3,31 }, { 196,4,24 }, { 204,4,25 }, { 197,5,24 }, { 212,4,26 }, { 205,5,25 }, { 198,6,24 }, { 220,4,27 }, { 213,5,26 }, { 206,6,25 }, { 199,7,24 }, { 221,5,27 }, { 214,6,26 }, { 207,7,25 }, { 222,6,27 },
  { 215,7,26 }, { 223,7,27 }, { 228,4,28 }, { 236,4,29 }, { 229,5,28 }, { 244,4,30 }, { 237,5,29 }, { 230,6,28 }, { 252,4,31 }, { 245,5,30 }, { 238,6,29 }, { 231,7,28 }, { 253,5,31 }, { 246,6,30 }, { 239,7,29 }, { 254,6,31 }, { 247,7,30 }, { 255,7,31 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 },
  { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 511,7,63 }, { 0,0,0 }, { 1,1,0 }, { 2,2,0 }, { 3,3,0 }, { 4,4,0 }, { 5,5,0 },
  { 6,6,0 }, { 7,7,0 }, { 8,8,0 }, { 9,9,0 }, { 10,10,0 }, { 11,11,0 }, { 12,12,0 }, { 13,13,0 }, { 14,14,0 }, { 15,15,0 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 17,1,1 }, { 2,2,0 }, { 18,2,1 }, { 3,3,0 }, { 19,3,1 }, { 4,4,0 }, { 20,4,1 },
  { 5,5,0 }, { 21,5,1 }, { 6,6,0 }, { 22,6,1 }, { 7,7,0 }, { 23,7,1 }, { 8,8,0 }, { 24,8,1 }, { 9,9,0 }, { 25,9,1 }, { 10,10,0 }, { 26,10,1 }, { 11,11,0 }, { 27,11,1 }, { 12,12,0 }, { 28,12,1 }, { 13,13,0 }, { 29,13,1 }, { 14,14,0 }, { 30,14,1 },
  { 15,15,0 }, { 31,15,1 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 32,0,2 }, { 17,1,1 }, { 2,2,0 }, { 48,0,3 }, { 33,1,2 }, { 18,2,1 }, { 3,3,0 }, { 49,1,3 }, { 34,2,2 }, { 19,3,1 }, { 50,2,3 }, { 35,3,2 }, { 51,3,3 }, { 4,4,0 }, { 20,4,1 },
  { 5,5,0 }, { 36,4,2 }, { 21,5,1 }, { 6,6,0 }, { 52,4,3 }, { 37,5,2 }, { 22,6,1 }, { 7,7,0 }, { 53,5,3 }, { 38,6,2 }, { 23,7,1 }, { 54,6,3 }, { 39,7,2 }, { 55,7,3 }, { 8,8,0 }, { 24,8,1 }, { 9,9,0 }, { 40,8,2 }, { 25,9,1 }, { 10,10,0 },
  { 56,8,3 }, { 41,9,2 }, { 26,10,1 }, { 11,11,0 }, { 57,9,3 }, { 42,10,2 }, { 27,11,1 }, { 58,10,3 }, { 43,11,2 }, { 59,11,3 }, { 12,12,0 }, { 28,12,1 }, { 13,13,0 }, { 44,12,2 }, { 29,13,1 }, { 14,14,0 }, { 60,12,3 }, { 45,13,2 }, { 30,14,1 }, { 15,15,0 },
  { 61,13,3 }, { 46,14,2 }, { 31,15,1 }, { 62,14,3 }, { 47,15,2 }, { 63,15,3 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 32,0,2 }, { 17,1,1 }, { 2,2,0 }, { 48,0,3 }, { 33,1,2 }, { 18,2,1 }, { 3,3,0 }, { 49,1,3 }, { 34,2,2 }, { 19,3,1 }, { 50,2,3 },
  { 35,3,2 }, { 51,3,3 }, { 64,0,4 }, { 80,0,5 }, { 65,1,4 }, { 96,0,6 }, { 81,1,5 }, { 66,2,4 }, { 112,0,7 }, { 97,1,6 }, { 82,2,5 }, { 67,3,4 }, { 113,1,7 }, { 98,2,6 }, { 83,3,5 }, { 114,2,7 }, { 99,3,6 }, { 115,3,7 }, { 4,4,0 }, { 20,4,1 },
  { 5,5,0 }, { 36,4,2 }, { 21,5,1 }, { 6,6,0 }, { 52,4,3 }, { 37,5,2 }, { 22,6,1 }, { 7,7,0 }, { 53,5,3 }, { 38,6,2 }, { 23,7,1 }, { 54,6,3 }, { 39,7,2 }, { 55,7,3 }, { 68,4,4 }, { 84,4,5 }, { 69,5,4 }, { 100,4,6 }, { 85,5,5 }, { 70,6,4 },
  { 116,4,7 }, { 101,5,6 }, { 86,6,5 }, { 71,7,4 }, { 117,5,7 }, { 102,6,6 }, { 87,7,5 }, { 118,6,7 }, { 103,7,6 }, { 119,7,7 }, { 8,8,0 }, { 24,8,1 }, { 9,9,0 }, { 40,8,2 }, { 25,9,1 }, { 10,10,0 }, { 56,8,3 }, { 41,9,2 }, { 26,10,1 }, { 11,11,0 },
  { 57,9,3 }, { 42,10,2 }, { 27,11,1 }, { 58,10,3 }, { 43,11,2 }, { 59,11,3 }, { 72,8,4 }, { 88,8,5 }, { 73,9,4 }, { 104,8,6 }, { 89,9,5 }, { 74,10,4 }, { 120,8,7 }, { 105,9,6 }, { 90,10,5 }, { 75,11,4 }, { 121,9,7 }, { 106,10,6 }, { 91,11,5 }, { 122,10,7 },
  { 107,11,6 }, { 123,11,7 }, { 12,12,0 }, { 28,12,1 }, { 13,13,0 }, { 44,12,2 }, { 29,13,1 }, { 14,14,0 }, { 60,12,3 }, { 45,13,2 }, { 30,14,1 }, { 15,15,0 }, { 61,13,3 }, { 46,14,2 }, { 31,15,1 }, { 62,14,3 }, { 47,15,2 }, { 63,15,3 }, { 76,12,4 }, { 92,12,5 },
  { 77,13,4 }, { 108,12,6 }, { 93,13,5 }, { 78,14,4 }, { 124,12,7 }, { 109,13,6 }, { 94,14,5 }, { 79,15,4 }, { 125,13,7 }, { 110,14,6 }, { 95,15,5 }, { 126,14,7 }, { 111,15,6 }, { 127,15,7 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 32,0,2 }, { 17,1,1 }, { 2,2,0 },
  { 48,0,3 }, { 33,1,2 }, { 18,2,1 }, { 3,3,0 }, { 49,1,3 }, { 34,2,2 }, { 19,3,1 }, { 50,2,3 }, { 35,3,2 }, { 51,3,3 }, { 64,0,4 }, { 80,0,5 }, { 65,1,4 }, { 96,0,6 }, { 81,1,5 }, { 66,2,4 }, { 112,0,7 }, { 97,1,6 }, { 82,2,5 }, { 67,3,4 },
  { 113,1,7 }, { 98,2,6 }, { 83,3,5 }, { 114,2,7 }, { 99,3,6 }, { 115,3,7 }, { 4,4,0 }, { 20,4,1 }, { 5,5,0 }, { 36,4,2 }, { 21,5,1 }, { 6,6,0 }, { 52,4,3 }, { 37,5,2 }, { 22,6,1 }, { 7,7,0 }, { 53,5,3 }, { 38,6,2 }, { 23,7,1 }, { 54,6,3 },
  { 39,7,2 }, { 55,7,3 }, { 128,0,8 }, { 144,0,9 }, { 129,1,8 }, { 160,0,10 }, { 145,1,9 }, { 130,2,8 }, { 176,0,11 }, { 161,1,10 }, { 146,2,9 }, { 131,3,8 }, { 177,1,11 }, { 162,2,10 }, { 147,3,9 }, { 178,2,11 }, { 163,3,10 }, { 179,3,11 }, { 68,4,4 }, { 84,4,5 },
  { 69,5,4 }, { 100,4,6 }, { 85,5,5 }, { 70,6,4 }, { 116,4,7 }, { 101,5,6 }, { 86,6,5 }, { 71,7,4 }, { 117,5,7 }, { 102,6,6 }, { 87,7,5 }, { 118,6,7 }, { 103,7,6 }, { 119,7,7 }, { 8,8,0 }, { 24,8,1 }, { 9,9,0 }, { 40,8,2 }, { 25,9,1 }, { 10,10,0 },
  { 56,8,3 }, { 41,9,2 }, { 26,10,1 }, { 11,11,0 }, { 57,9,3 }, { 42,10,2 }, { 27,11,1 }, { 58,10,3 }, { 43,11,2 }, { 59,11,3 }, { 192,0,12 }, { 208,0,13 }, { 193,1,12 }, { 224,0,14 }, { 209,1,13 }, { 194,2,12 }, { 240,0,15 }, { 225,1,14 }, { 210,2,13 }, { 195,3,12 },
  { 241,1,15 }, { 226,2,14 }, { 211,3,13 }, { 242,2,15 }, { 227,3,14 }, { 243,3,15 }, { 132,4,8 }, { 148,4,9 }, { 133,5,8 }, { 164,4,10 }, { 149,5,9 }, { 134,6,8 }, { 180,4,11 }, { 165,5,10 }, { 150,6,9 }, { 135,7,8 }, { 181,5,11 }, { 166,6,10 }, { 151,7,9 }, { 182,6,11 },
  { 167,7,10 }, { 183,7,11 }, { 72,8,4 }, { 88,8,5 }, { 73,9,4 }, { 104,8,6 }, { 89,9,5 }, { 74,10,4 }, { 120,8,7 }, { 105,9,6 }, { 90,10,5 }, { 75,11,4 }, { 121,9,7 }, { 106,10,6 }, { 91,11,5 }, { 122,10,7 }, { 107,11,6 }, { 123,11,7 }, { 12,12,0 }, { 28,12,1 },
  { 13,13,0 }, { 44,12,2 }, { 29,13,1 }, { 14,14,0 }, { 60,12,3 }, { 45,13,2 }, { 30,14,1 }, { 15,15,0 }, { 61,13,3 }, { 46,14,2 }, { 31,15,1 }, { 62,14,3 }, { 47,15,2 }, { 63,15,3 }, { 196,4,12 }, { 212,4,13 }, { 197,5,12 }, { 228,4,14 }, { 213,5,13 }, { 198,6,12 },
  { 244,4,15 }, { 229,5,14 }, { 214,6,13 }, { 199,7,12 }, { 245,5,15 }, { 230,6,14 }, { 215,7,13 }, { 246,6,15 }, { 231,7,14 }, { 247,7,15 }, { 136,8,8 }, { 152,8,9 }, { 137,9,8 }, { 168,8,10 }, { 153,9,9 }, { 138,10,8 }, { 184,8,11 }, { 169,9,10 }, { 154,10,9 }, { 139,11,8 },
  { 185,9,11 }, { 170,10,10 }, { 155,11,9 }, { 186,10,11 }, { 171,11,10 }, { 187,11,11 }, { 76,12,4 }, { 92,12,5 }, { 77,13,4 }, { 108,12,6 }, { 93,13,5 }, { 78,14,4 }, { 124,12,7 }, { 109,13,6 }, { 94,14,5 }, { 79,15,4 }, { 125,13,7 }, { 110,14,6 }, { 95,15,5 }, { 126,14,7 },
  { 111,15,6 }, { 127,15,7 }, { 200,8,12 }, { 216,8,13 }, { 201,9,12 }, { 232,8,14 }, { 217,9,13 }, { 202,10,12 }, { 248,8,15 }, { 233,9,14 }, { 218,10,13 }, { 203,11,12 }, { 249,9,15 }, { 234,10,14 }, { 219,11,13 }, { 250,10,15 }, { 235,11,14 }, { 251,11,15 }, { 140,12,8 }, { 156,12,9 },
  { 141,13,8 }, { 172,12,10 }, { 157,13,9 }, { 142,14,8 }, { 188,12,11 }, { 173,13,10 }, { 158,14,9 }, { 143,15,8 }, { 189,13,11 }, { 174,14,10 }, { 159,15,9 }, { 190,14,11 }, { 175,15,10 }, { 191,15,11 }, { 204,12,12 }, { 220,12,13 }, { 205,13,12 }, { 236,12,14 }, { 221,13,13 }, { 206,14,12 },
  { 252,12,15 }, { 237,13,14 }, { 222,14,13 }, { 207,15,12 }, { 253,13,15 }, { 238,14,14 }, { 223,15,13 }, { 254,14,15 }, { 239,15,14 }, { 255,15,15 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 32,0,2 }, { 17,1,1 }, { 2,2,0 }, { 48,0,3 }, { 33,1,2 }, { 18,2,1 }, { 3,3,0 },
  { 49,1,3 }, { 34,2,2 }, { 19,3,1 }, { 50,2,3 }, { 35,3,2 }, { 51,3,3 }, { 64,0,4 }, { 80,0,5 }, { 65,1,4 }, { 96,0,6 }, { 81,1,5 }, { 66,2,4 }, { 112,0,7 }, { 97,1,6 }, { 82,2,5 }, { 67,3,4 }, { 113,1,7 }, { 98,2,6 }, { 83,3,5 }, { 114,2,7 },
  { 99,3,6 }, { 115,3,7 }, { 4,4,0 }, { 20,4,1 }, { 5,5,0 }, { 36,4,2 }, { 21,5,1 }, { 6,6,0 }, { 52,4,3 }, { 37,5,2 }, { 22,6,1 }, { 7,7,0 }, { 53,5,3 }, { 38,6,2 }, { 23,7,1 }, { 54,6,3 }, { 39,7,2 }, { 55,7,3 }, { 128,0,8 }, { 144,0,9 },
  { 129,1,8 }, { 160,0,10 }, { 145,1,9 }, { 130,2,8 }, { 176,0,11 }, { 161,1,10 }, { 146,2,9 }, { 131,3,8 }, { 177,1,11 }, { 162,2,10 }, { 147,3,9 }, { 178,2,11 }, { 163,3,10 }, { 179,3,11 }, { 68,4,4 }, { 84,4,5 }, { 69,5,4 }, { 100,4,6 }, { 85,5,5 }, { 70,6,4 },
  { 116,4,7 }, { 101,5,6 }, { 86,6,5 }, { 71,7,4 }, { 117,5,7 }, { 102,6,6 }, { 87,7,5 }, { 118,6,7 }, { 103,7,6 }, { 119,7,7 }, { 8,8,0 }, { 24,8,1 }, { 9,9,0 }, { 40,8,2 }, { 25,9,1 }, { 10,10,0 }, { 56,8,3 }, { 41,9,2 }, { 26,10,1 }, { 11,11,0 },
  { 57,9,3 }, { 42,10,2 }, { 27,11,1 }, { 58,10,3 }, { 43,11,2 }, { 59,11,3 }, { 192,0,12 }, { 208,0,13 }, { 193,1,12 }, { 224,0,14 }, { 209,1,13 }, { 194,2,12 }, { 240,0,15 }, { 225,1,14 }, { 210,2,13 }, { 195,3,12 }, { 241,1,15 }, { 226,2,14 }, { 211,3,13 }, { 242,2,15 },
  { 227,3,14 }, { 243,3,15 }, { 132,4,8 }, { 148,4,9 }, { 133,5,8 }, { 164,4,10 }, { 149,5,9 }, { 134,6,8 }, { 180,4,11 }, { 165,5,10 }, { 150,6,9 }, { 135,7,8 }, { 181,5,11 }, { 166,6,10 }, { 151,7,9 }, { 182,6,11 }, { 167,7,10 }, { 183,7,11 }, { 72,8,4 }, { 88,8,5 },
  { 73,9,4 }, { 104,8,6 }, { 89,9,5 }, { 74,10,4 }, { 120,8,7 }, { 105,9,6 }, { 90,10,5 }, { 75,11,4 }, { 121,9,7 }, { 106,10,6 }, { 91,11,5 }, { 122,10,7 }, { 107,11,6 }, { 123,11,7 }, { 12,12,0 }, { 28,12,1 }, { 13,13,0 }, { 44,12,2 }, { 29,13,1 }, { 14,14,0 },
  { 60,12,3 }, { 45,13,2 }, { 30,14,1 }, { 15,15,0 }, { 61,13,3 }, { 46,14,2 }, { 31,15,1 }, { 62,14,3 }, { 47,15,2 }, { 63,15,3 }, { 256,0,16 }, { 272,0,17 }, { 257,1,16 }, { 288,0,18 }, { 273,1,17 }, { 258,2,16 }, { 304,0,19 }, { 289,1,18 }, { 274,2,17 }, { 259,3,16 },
  { 305,1,19 }, { 290,2,18 }, { 275,3,17 }, { 306,2,19 }, { 291,3,18 }, { 307,3,19 }, { 196,4,12 }, { 212,4,13 }, { 197,5,12 }, { 228,4,14 }, { 213,5,13 }, { 198,6,12 }, { 244,4,15 }, { 229,5,14 }, { 214,6,13 }, { 199,7,12 }, { 245,5,15 }, { 230,6,14 }, { 215,7,13 }, { 246,6,15 },
  { 231,7,14 }, { 247,7,15 }, { 136,8,8 }, { 152,8,9 }, { 137,9,8 }, { 168,8,10 }, { 153,9,9 }, { 138,10,8 }, { 184,8,11 }, { 169,9,10 }, { 154,10,9 }, { 139,11,8 }, { 185,9,11 }, { 170,10,10 }, { 155,11,9 }, { 186,10,11 }, { 171,11,10 }, { 187,11,11 }, { 76,12,4 }, { 92,12,5 },
  { 77,13,4 }, { 108,12,6 }, { 93,13,5 }, { 78,14,4 }, { 124,12,7 }, { 109,13,6 }, { 94,14,5 }, { 79,15,4 }, { 125,13,7 }, { 110,14,6 }, { 95,15,5 }, { 126,14,7 }, { 111,15,6 }, { 127,15,7 }, { 320,0,20 }, { 336,0,21 }, { 321,1,20 }, { 352,0,22 }, { 337,1,21 }, { 322,2,20 },
  { 368,0,23 }, { 353,1,22 }, { 338,2,21 }, { 323,3,20 }, { 369,1,23 }, { 354,2,22 }, { 339,3,21 }, { 370,2,23 }, { 355,3,22 }, { 371,3,23 }, { 260,4,16 }, { 276,4,17 }, { 261,5,16 }, { 292,4,18 }, { 277,5,17 }, { 262,6,16 }, { 308,4,19 }, { 293,5,18 }, { 278,6,17 }, { 263,7,16 },
  { 309,5,19 }, { 294,6,18 }, { 279,7,17 }, { 310,6,19 }, { 295,7,18 }, { 311,7,19 }, { 200,8,12 }, { 216,8,13 }, { 201,9,12 }, { 232,8,14 }, { 217,9,13 }, { 202,10,12 }, { 248,8,15 }, { 233,9,14 }, { 218,10,13 }, { 203,11,12 }, { 249,9,15 }, { 234,10,14 }, { 219,11,13 }, { 250,10,15 },
  { 235,11,14 }, { 251,11,15 }, { 140,12,8 }, { 156,12,9 }, { 141,13,8 }, { 172,12,10 }, { 157,13,9 }, { 142,14,8 }, { 188,12,11 }, { 173,13,10 }, { 158,14,9 }, { 143,15,8 }, { 189,13,11 }, { 174,14,10 }, { 159,15,9 }, { 190,14,11 }, { 175,15,10 }, { 191,15,11 }, { 384,0,24 }, { 400,0,25 },
  { 385,1,24 }, { 416,0,26 }, { 401,1,25 }, { 386,2,24 }, { 432,0,27 }, { 417,1,26 }, { 402,2,25 }, { 387,3,24 }, { 433,1,27 }, { 418,2,26 }, { 403,3,25 }, { 434,2,27 }, { 419,3,26 }, { 435,3,27 }, { 324,4,20 }, { 340,4,21 }, { 325,5,20 }, { 356,4,22 }, { 341,5,21 }, { 326,6,20 },
  { 372,4,23 }, { 357,5,22 }, { 342,6,21 }, { 327,7,20 }, { 373,5,23 }, { 358,6,22 }, { 343,7,21 }, { 374,6,23 }, { 359,7,22 }, { 375,7,23 }, { 264,8,16 }, { 280,8,17 }, { 265,9,16 }, { 296,8,18 }, { 281,9,17 }, { 266,10,16 }, { 312,8,19 }, { 297,9,18 }, { 282,10,17 }, { 267,11,16 },
  { 313,9,19 }, { 298,10,18 }, { 283,11,17 }, { 314,10,19 }, { 299,11,18 }, { 315,11,19 }, { 204,12,12 }, { 220,12,13 }, { 205,13,12 }, { 236,12,14 }, { 221,13,13 }, { 206,14,12 }, { 252,12,15 }, { 237,13,14 }, { 222,14,13 }, { 207,15,12 }, { 253,13,15 }, { 238,14,14 }, { 223,15,13 }, { 254,14,15 },
  { 239,15,14 }, { 255,15,15 }, { 448,0,28 }, { 464,0,29 }, { 449,1,28 }, { 480,0,30 }, { 465,1,29 }, { 450,2,28 }, { 496,0,31 }, { 481,1,30 }, { 466,2,29 }, { 451,3,28 }, { 497,1,31 }, { 482,2,30 }, { 467,3,29 }, { 498,2,31 }, { 483,3,30 }, { 499,3,31 }, { 388,4,24 }, { 404,4,25 },
  { 389,5,24 }, { 420,4,26 }, { 405,5,25 }, { 390,6,24 }, { 436,4,27 }, { 421,5,26 }, { 406,6,25 }, { 391,7,24 }, { 437,5,27 }, { 422,6,26 }, { 407,7,25 }, { 438,6,27 }, { 423,7,26 }, { 439,7,27 }, { 328,8,20 }, { 344,8,21 }, { 329,9,20 }, { 360,8,22 }, { 345,9,21 }, { 330,10,20 },
  { 376,8,23 }, { 361,9,22 }, { 346,10,21 }, { 331,11,20 }, { 377,9,23 }, { 362,10,22 }, { 347,11,21 }, { 378,10,23 }, { 363,11,22 }, { 379,11,23 }, { 268,12,16 }, { 284,12,17 }, { 269,13,16 }, { 300,12,18 }, { 285,13,17 }, { 270,14,16 }, { 316,12,19 }, { 301,13,18 }, { 286,14,17 }, { 271,15,16 },
  { 317,13,19 }, { 302,14,18 }, { 287,15,17 }, { 318,14,19 }, { 303,15,18 }, { 319,15,19 }, { 452,4,28 }, { 468,4,29 }, { 453,5,28 }, { 484,4,30 }, { 469,5,29 }, { 454,6,28 }, { 500,4,31 }, { 485,5,30 }, { 470,6,29 }, { 455,7,28 }, { 501,5,31 }, { 486,6,30 }, { 471,7,29 }, { 502,6,31 },
  { 487,7,30 }, { 503,7,31 }, { 392,8,24 }, { 408,8,25 }, { 393,9,24 }, { 424,8,26 }, { 409,9,25 }, { 394,10,24 }, { 440,8,27 }, { 425,9,26 }, { 410,10,25 }, { 395,11,24 }, { 441,9,27 }, { 426,10,26 }, { 411,11,25 }, { 442,10,27 }, { 427,11,26 }, { 443,11,27 }, { 332,12,20 }, { 348,12,21 },
  { 333,13,20 }, { 364,12,22 }, { 349,13,21 }, { 334,14,20 }, { 380,12,23 }, { 365,13,22 }, { 350,14,21 }, { 335,15,20 }, { 381,13,23 }, { 366,14,22 }, { 351,15,21 }, { 382,14,23 }, { 367,15,22 }, { 383,15,23 }, { 456,8,28 }, { 472,8,29 }, { 457,9,28 }, { 488,8,30 }, { 473,9,29 }, { 458,10,28 },
  { 504,8,31 }, { 489,9,30 }, { 474,10,29 }, { 459,11,28 }, { 505,9,31 }, { 490,10,30 }, { 475,11,29 }, { 506,10,31 }, { 491,11,30 }, { 507,11,31 }, { 396,12,24 }, { 412,12,25 }, { 397,13,24 }, { 428,12,26 }, { 413,13,25 }, { 398,14,24 }, { 444,12,27 }, { 429,13,26 }, { 414,14,25 }, { 399,15,24 },
  { 445,13,27 }, { 430,14,26 }, { 415,15,25 }, { 446,14,27 }, { 431,15,26 }, { 447,15,27 }, { 460,12,28 }, { 476,12,29 }, { 461,13,28 }, { 492,12,30 }, { 477,13,29 }, { 462,14,28 }, { 508,12,31 }, { 493,13,30 }, { 478,14,29 }, { 463,15,28 }, { 509,13,31 }, { 494,14,30 }, { 479,15,29 }, { 510,14,31 },
  { 495,15,30 }, { 511,15,31 }, { 0,0,0 }, { 16,0,1 }, { 1,1,0 }, { 32,0,2 }, { 17,1,1 }, { 2,2,0 }, { 48,0,3 }, { 33,1,2 }, { 18,2,1 }, { 3,3,0 }, { 49,1,3 }, { 34,2,2 }, { 19,3,1 }, { 50,2,3 }, { 35,3,2 }, { 51,3,3 }, { 64,0,4 }, { 80,0,5 },
  { 65,1,4 }, { 96,0,6 }, { 81,1,5 }, { 66,2,4 }, { 112,0,7 }, { 97,1,6 }, { 82,2,5 }, { 67,3,4 }, { 113,1,7 }, { 98,2,6 }, { 83,3,5 }, { 114,2,7 }, { 99,3,6 }, { 115,3,7 }, { 4,4,0 }, { 20,4,1 }, { 5,5,0 }, { 36,4,2 }, { 21,5,1 }, { 6,6,0 },
  { 52,4,3 }, { 37,5,2 }, { 22,6,1 }, { 7,7,0 }, { 53,5,3 }, { 38,6,2 }, { 23,7,1 }, { 54,6,3 }, { 39,7,2 }, { 55,7,3 }, { 128,0,8 }, { 144,0,9 }, { 129,1,8 }, { 160,0,10 }, { 145,1,9 }, { 130,2,8 }, { 176,0,11 }, { 161,1,10 }, { 146,2,9 }, { 131,3,8 },
  { 177,1,11 }, { 162,2,10 }, { 147,3,9 }, { 178,2,11 }, { 163,3,10 }, { 179,3,11 }, { 68,4,4 }, { 84,4,5 }, { 69,5,4 }, { 100,4,6 }, { 85,5,5 }, { 70,6,4 }, { 116,4,7 }, { 101,5,6 }, { 86,6,5 }, { 71,7,4 }, { 117,5,7 }, { 102,6,6 }, { 87,7,5 }, { 118,6,7 },
  { 103,7,6 }, { 119,7,7 }, { 8,8,0 }, { 24,8,1 }, { 9,9,0 }, { 40,8,2 }, { 25,9,1 }, { 10,10,0 }, { 56,8,3 }, { 41,9,2 }, { 26,10,1 }, { 11,11,0 }, { 57,9,3 }, { 42,10,2 }, { 27,11,1 }, { 58,10,3 }, { 43,11,2 }, { 59,11,3 }, { 192,0,12 }, { 208,0,13 },
  { 193,1,12 }, { 224,0,14 }, { 209,1,13 }, { 194,2,12 }, { 240,0,15 }, { 225,1,14 }, { 210,2,13 }, { 195,3,12 }, { 241,1,15 }, { 226,2,14 }, { 211,3,13 }, { 242,2,15 }, { 227,3,14 }, { 243,3,15 }, { 132,4,8 }, { 148,4,9 }, { 133,5,8 }, { 164,4,10 }, { 149,5,9 }, { 134,6,8 },
  { 180,4,11 }, { 165,5,10 }, { 150,6,9 }, { 135,7,8 }, { 181,5,11 }, { 166,6,10 }, { 151,7,9 }, { 182,6,11 }, { 167,7,10 }, { 183,7,11 }, { 72,8,4 }, { 88,8,5 }, { 73,9,4 }, { 104,8,6 }, { 89,9,5 }, { 74,10,4 }, { 120,8,7 }, { 105,9,6 }, { 90,10,5 }, { 75,11,4 },
  { 121,9,7 }, { 106,10,6 }, { 91,11,5 }, { 122,10,7 }, { 107,11,6 }, { 123,11,7 }, { 12,12,0 }, { 28,12,1 }, { 13,13,0 }, { 44,12,2 }, { 29,13,1 }, { 14,14,0 }, { 60,12,3 }, { 45,13,2 }, { 30,14,1 }, { 15,15,0 }, { 61,13,3 }, { 46,14,2 }, { 31,15,1 }, { 62,14,3 },
  { 47,15,2 }, { 63,15,3 }, { 256,0,16 }, { 272,0,17 }, { 257,1,16 }, { 288,0,18 }, { 273,1,17 }, { 258,2,16 }, { 304,0,19 }, { 289,1,18 }, { 274,2,17 }, { 259,3,16 }, { 305,1,19 }, { 290,2,18 }, { 275,3,17 }, { 306,2,19 }, { 291,3,18 }, { 307,3,19 }, { 196,4,12 }, { 212,4,13 },
  { 197,5,12 }, { 228,4,14 }, { 213,5,13 }, { 198,6,12 }, { 244,4,15 }, { 229,5,14 }, { 214,6,13 }, { 199,7,12 }, { 245,5,15 }, { 230,6,14 }, { 215,7,13 }, { 246,6,15 }, { 231,7,14 }, { 247,7,15 }, { 136,8,8 }, { 152,8,9 }, { 137,9,8 }, { 168,8,10 }, { 153,9,9 }, { 138,10,8 },
  { 184,8,11 }, { 169,9,10 }, { 154,10,9 }, { 139,11,8 }, { 185,9,11 }, { 170,10,10 }, { 155,11,9 }, { 186,10,11 }, { 171,11,10 }, { 187,11,11 }, { 76,12,4 }, { 92,12,5 }, { 77,13,4 }, { 108,12,6 }, { 93,13,5 }, { 78,14,4 }, { 124,12,7 }, { 109,13,6 }, { 94,14,5 }, { 79,15,4 },
  { 125,13,7 }, { 110,14,6 }, { 95,15,5 }, { 126,14,7 }, { 111,15,6 }, { 127,15,7 }, { 320,0,20 }, { 336,0,21 }, { 321,1,20 }, { 352,0,22 }, { 337,1,21 }, { 322,2,20 }, { 368,0,23 }, { 353,1,22 }, { 338,2,21 }, { 323,3,20 }, { 369,1,23 }, { 354,2,22 }, { 339,3,21 }, { 370,2,23 },
  { 355,3,22 }, { 371,3,23 }, { 260,4,16 }, { 276,4,17 }, { 261,5,16 }, { 292,4,18 }, { 277,5,17 }, { 262,6,16 }, { 308,4,19 }, { 293,5,18 }, { 278,6,17 }, { 263,7,16 }, { 309,5,19 }, { 294,6,18 }, { 279,7,17 }, { 310,6,19 }, { 295,7,18 }, { 311,7,19 }, { 200,8,12 }, { 216,8,13 },
  { 201,9,12 }, { 232,8,14 }, { 217,9,13 }, { 202,10,12 }, { 248,8,15 }, { 233,9,14 }, { 218,10,13 }, { 203,11,12 }, { 249,9,15 }, { 234,10,14 }, { 219,11,13 }, { 250,10,15 }, { 235,11,14 }, { 251,11,15 }, { 140,12,8 }, { 156,12,9 }, { 141,13,8 }, { 172,12,10 }, { 157,13,9 }, { 142,14,8 },
  { 188,12,11 }, { 173,13,10 }, { 158,14,9 }, { 143,15,8 }, { 189,13,11 }, { 174,14,10 }, { 159,15,9 }, { 190,14,11 }, { 175,15,10 }, { 191,15,11 }, { 384,0,24 }, { 400,0,25 }, { 385,1,24 }, { 416,0,26 }, { 401,1,25 }, { 386,2,24 }, { 432,0,27 }, { 417,1,26 }, { 402,2,25 }, { 387,3,24 },
  { 433,1,27 }, { 418,2,26 }, { 403,3,25 }, { 434,2,27 }, { 419,3,26 }, { 435,3,27 }, { 324,4,20 }, { 340,4,21 }, { 325,5,20 }, { 356,4,22 }, { 341,5,21 }, { 326,6,20 }, { 372,4,23 }, { 357,5,22 }, { 342,6,21 }, { 327,7,20 }, { 373,5,23 }, { 358,6,22 }, { 343,7,21 }, { 374,6,23 },
  { 359,7,22 }, { 375,7,23 }, { 264,8,16 }, { 280,8,17 }, { 265,9,16 }, { 296,8,18 }, { 281,9,17 }, { 266,10,16 }, { 312,8,19 }, { 297,9,18 }, { 282,10,17 }, { 267,11,16 }, { 313,9,19 }, { 298,10,18 }, { 283,11,17 }, { 314,10,19 }, { 299,11,18 }, { 315,11,19 }, { 204,12,12 }, { 220,12,13 },
  { 205,13,12 }, { 236,12,14 }, { 221,13,13 }, { 206,14,12 }, { 252,12,15 }, { 237,13,14 }, { 222,14,13 }, { 207,15,12 }, { 253,13,15 }, { 238,14,14 }, { 223,15,13 }, { 254,14,15 }, { 239,15,14 }, { 255,15,15 }, { 448,0,28 }, { 464,0,29 }, { 449,1,28 }, { 480,0,30 }, { 465,1,29 }, { 450,2,28 },
  { 496,0,31 }, { 481,1,30 }, { 466,2,29 }, { 451,3,28 }, { 497,1,31 }, { 482,2,30 }, { 467,3,29 }, { 498,2,31 }, { 483,3,30 }, { 499,3,31 }, { 388,4,24 }, { 404,4,25 }, { 389,5,24 }, { 420,4,26 }, { 405,5,25 }, { 390,6,24 }, { 436,4,27 }, { 421,5,26 }, { 406,6,25 }, { 391,7,24 },
  { 437,5,27 }, { 422,6,26 }, { 407,7,25 }, { 438,6,27 }, { 423,7,26 }, { 439,7,27 }, { 328,8,20 }, { 344,8,21 }, { 329,9,20 }, { 360,8,22 }, { 345,9,21 }, { 330,10,20 }, { 376,8,23 }, { 361,9,22 }, { 346,10,21 }, { 331,11,20 }, { 377,9,23 }, { 362,10,22 }, { 347,11,21 }, { 378,10,23 },
  { 363,11,22 }, { 379,11,23 }, { 268,12,16 }, { 284,12,17 }, { 269,13,16 }, { 300,12,18 }, { 285,13,17 }, { 270,14,16 }, { 316,12,19 }, { 301,13,18 }, { 286,14,17 }, { 271,15,16 }, { 317,13,19 }, { 302,14,18 }, { 287,15,17 }, { 318,14,19 }, { 303,15,18 }, { 319,15,19 }, { 452,4,28 }, { 468,4,29 },
  { 453,5,28 }, { 484,4,30 }, { 469,5,29 }, { 454,6,28 }, { 500,4,31 }, { 485,5,30 }, { 470,6,29 }, { 455,7,28 }, { 501,5,31 }, { 486,6,30 }, { 471,7,29 }, { 502,6,31 }, { 487,7,30 }, { 503,7,31 }, { 392,8,24 }, { 408,8,25 }, { 393,9,24 }, { 424,8,26 }, { 409,9,25 }, { 394,10,24 },
  { 440,8,27 }, { 425,9,26 }, { 410,10,25 }, { 395,11,24 }, { 441,9,27 }, { 426,10,26 }, { 411,11,25 }, { 442,10,27 }, { 427,11,26 }, { 443,11,27 }, { 332,12,20 }, { 348,12,21 }, { 333,13,20 }, { 364,12,22 }, { 349,13,21 }, { 334,14,20 }, { 380,12,23 }, { 365,13,22 }, { 350,14,21 }, { 335,15,20 },
  { 381,13,23 }, { 366,14,22 }, { 351,15,21 }, { 382,14,23 }, { 367,15,22 }, { 383,15,23 }, { 456,8,28 }, { 472,8,29 }, { 457,9,28 }, { 488,8,30 }, { 473,9,29 }, { 458,10,28 }, { 504,8,31 }, { 489,9,30 }, { 474,10,29 }, { 459,11,28 }, { 505,9,31 }, { 490,10,30 }, { 475,11,29 }, { 506,10,31 },
  { 491,11,30 }, { 507,11,31 }, { 396,12,24 }, { 412,12,25 }, { 397,13,24 }, { 428,12,26 }, { 413,13,25 }, { 398,14,24 }, { 444,12,27 }, { 429,13,26 }, { 414,14,25 }, { 399,15,24 }, { 445,13,27 }, { 430,14,26 }, { 415,15,25 }, { 446,14,27 }, { 431,15,26 }, { 447,15,27 }, { 460,12,28 }, { 476,12,29 },
  { 461,13,28 }, { 492,12,30 }, { 477,13,29 }, { 462,14,28 }, { 508,12,31 }, { 493,13,30 }, { 478,14,29 }, { 463,15,28 }, { 509,13,31 }, { 494,14,30 }, { 479,15,29 }, { 510,14,31 }, { 495,15,30 }, { 511,15,31 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 },
  { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 1023,15,63 }, { 0,0,0 }, { 1,1,0 }, { 2,2,0 }, { 3,3,0 }, { 4,4,0 }, { 5,5,0 }, { 6,6,0 }, { 7,7,0 }, { 8,8,0 }, { 9,9,0 }, { 10,10,0 }, { 11,11,0 }, { 12,12,0 }, { 13,13,0 },
  { 14,14,0 }, { 15,15,0 }, { 16,16,0 }, { 17,17,0 }, { 18,18,0 }, { 19,19,0 }, { 20,20,0 }, { 21,21,0 }, { 22,22,0 }, { 23,23,0 }, { 24,24,0 }, { 25,25,0 }, { 26,26,0 }, { 27,27,0 }, { 28,28,0 }, { 29,29,0 }, { 30,30,0 }, { 31,31,0 }, { 0,0,0 }, { 32,0,1 },
  { 1,1,0 }, { 33,1,1 }, { 2,2,0 }, { 34,2,1 }, { 3,3,0 }, { 35,3,1 }, { 4,4,0 }, { 36,4,1 }, { 5,5,0 }, { 37,5,1 }, { 6,6,0 }, { 38,6,1 }, { 7,7,0 }, { 39,7,1 }, { 8,8,0 }, { 40,8,1 }, { 9,9,0 }, { 41,9,1 }, { 10,10,0 }, { 42,10,1 },
  { 11,11,0 }, { 43,11,1 }, { 12,12,0 }, { 44,12,1 }, { 13,13,0 }, { 45,13,1 }, { 14,14,0 }, { 46,14,1 }, { 15,15,0 }, { 47,15,1 }, { 16,16,0 }, { 48,16,1 }, { 17,17,0 }, { 49,17,1 }, { 18,18,0 }, { 50,18,1 }, { 19,19,0 }, { 51,19,1 }, { 20,20,0 }, { 52,20,1 },
  { 21,21,0 }, { 53,21,1 }, { 22,22,0 }, { 54,22,1 }, { 23,23,0 }, { 55,23,1 }, { 24,24,0 }, { 56,24,1 }, { 25,25,0 }, { 57,25,1 }, { 26,26,0 }, { 58,26,1 }, { 27,27,0 }, { 59,27,1 }, { 28,28,0 }, { 60,28,1 }, { 29,29,0 }, { 61,29,1 }, { 30,30,0 }, { 62,30,1 },
  { 31,31,0 }, { 63,31,1 }, { 0,0,0 }, { 32,0,1 }, { 1,1,0 }, { 64,0,2 }, { 33,1,1 }, { 2,2,0 }, { 96,0,3 }, { 65,1,2 }, { 34,2,1 }, { 3,3,0 }, { 97,1,3 }, { 66,2,2 }, { 35,3,1 }, { 98,2,3 }, { 67,3,2 }, { 99,3,3 }, { 4,4,0 }, { 36,4,1 },
  { 5,5,0 }, { 68,4,2 }, { 37,5,1 }, { 6,6,0 }, { 100,4,3 }, { 69,5,2 }, { 38,6,1 }, { 7,7,0 }, { 101,5,3 }, { 70,6,2 }, { 39,7,1 }, { 102,6,3 }, { 71,7,2 }, { 103,7,3 }, { 8,8,0 }, { 40,8,1 }, { 9,9,0 }, { 72,8,2 }, { 41,9,1 }, { 10,10,0 },
  { 104,8,3 }, { 73,9,2 }, { 42,10,1 }, { 11,11,0 }, { 105,9,3 }, { 74,10,2 }, { 43,11,1 }, { 106,10,3 }, { 75,11,2 }, { 107,11,3 }, { 12,12,0 }, { 44,12,1 }, { 13,13,0 }, { 76,12,2 }, { 45,13,1 }, { 14,14,0 }, { 108,12,3 }, { 77,13,2 }, { 46,14,1 }, { 15,15,0 },
  { 109,13,3 }, { 78,14,2 }, { 47,15,1 }, { 110,14,3 }, { 79,15,2 }, { 111,15,3 }, { 16,16,0 }, { 48,16,1 }, { 17,17,0 }, { 80,16,2 }, { 49,17,1 }, { 18,18,0 }, { 112,16,3 }, { 81,17,2 }, { 50,18,1 }, { 19,19,0 }, { 113,17,3 }, { 82,18,2 }, { 51,19,1 }, { 114,18,3 },
  { 83,19,2 }, { 115,19,3 }, { 20,20,0 }, { 52,20,1 }, { 21,21,0 }, { 84,20,2 }, { 53,21,1 }, { 22,22,0 }, { 116,20,3 }, { 85,21,2 }, { 54,22,1 }, { 23,23,0 }, { 117,21,3 }, { 86,22,2 }, { 55,23,1 }, { 118,22,3 }, { 87,23,2 }, { 119,23,3 }, { 24,24,0 }, { 56,24,1 },
  { 25,25,0 }, { 88,24,2 }, { 57,25,1 }, { 26,26,0 }, { 120,24,3 }, { 89,25,2 }, { 58,26,1 }, { 27,27,0 }, { 121,25,3 }, { 90,26,2 }, { 59,27,1 }, { 122,26,3 }, { 91,27,2 }, { 123,27,3 }, { 28,28,0 }, { 60,28,1 }, { 29,29,0 }, { 92,28,2 }, { 61,29,1 }, { 30,30,0 },
  { 124,28,3 }, { 93,29,2 }, { 62,30,1 }, { 31,31,0 }, { 125,29,3 }, { 94,30,2 }, { 63,31,1 }, { 126,30,3 }, { 95,31,2 }, { 127,31,3 }, { 0,0,0 }, { 32,0,1 }, { 1,1,0 }, { 64,0,2 }, { 33,1,1 }, { 2,2,0 }, { 96,0,3 }, { 65,1,2 }, { 34,2,1 }, { 3,3,0 },
  { 97,1,3 }, { 66,2,2 }, { 35,3,1 }, { 98,2,3 }, { 67,3,2 }, { 99,3,3 }, { 128,0,4 }, { 160,0,5 }, { 129,1,4 }, { 192,0,6 }, { 161,1,5 }, { 130,2,4 }, { 224,0,7 }, { 193,1,6 }, { 162,2,5 }, { 131,3,4 }, { 225,1,7 }, { 194,2,6 }, { 163,3,5 }, { 226,2,7 },
  { 195,3,6 }, { 227,3,7 }, { 4,4,0 }, { 36,4,1 }, { 5,5,0 }, { 68,4,2 }, { 37,5,1 }, { 6,6,0 }, { 100,4,3 }, { 69,5,2 }, { 38,6,1 }, { 7,7,0 }, { 101,5,3 }, { 70,6,2 }, { 39,7,1 }, { 102,6,3 }, { 71,7,2 }, { 103,7,3 }, { 132,4,4 }, { 164,4,5 },
  { 133,5,4 }, { 196,4,6 }, { 165,5,5 }, { 134,6,4 }, { 228,4,7 }, { 197,5,6 }, { 166,6,5 }, { 135,7,4 }, { 229,5,7 }, { 198,6,6 }, { 167,7,5 }, { 230,6,7 }, { 199,7,6 }, { 231,7,7 }, { 8,8,0 }, { 40,8,1 }, { 9,9,0 }, { 72,8,2 }, { 41,9,1 }, { 10,10,0 },
  { 104,8,3 }, { 73,9,2 }, { 42,10,1 }, { 11,11,0 }, { 105,9,3 }, { 74,10,2 }, { 43,11,1 }, { 106,10,3 }, { 75,11,2 }, { 107,11,3 }, { 136,8,4 }, { 168,8,5 }, { 137,9,4 }, { 200,8,6 }, { 169,9,5 }, { 138,10,4 }, { 232,8,7 }, { 201,9,6 }, { 170,10,5 }, { 139,11,4 },
  { 233,9,7 }, { 202,10,6 }, { 171,11,5 }, { 234,10,7 }, { 203,11,6 }, { 235,11,7 }, { 12,12,0 }, { 44,12,1 }, { 13,13,0 }, { 76,12,2 }, { 45,13,1 }, { 14,14,0 }, { 108,12,3 }, { 77,13,2 }, { 46,14,1 }, { 15,15,0 }, { 109,13,3 }, { 78,14,2 }, { 47,15,1 }, { 110,14,3 },
  { 79,15,2 }, { 111,15,3 }, { 140,12,4 }, { 172,12,5 }, { 141,13,4 }, { 204,12,6 }, { 173,13,5 }, { 142,14,4 }, { 236,12,7 }, { 205,13,6 }, { 174,14,5 }, { 143,15,4 }, { 237,13,7 }, { 206,14,6 }, { 175,15,5 }, { 238,14,7 }, { 207,15,6 }, { 239,15,7 }, { 16,16,0 }, { 48,16,1 },
  { 17,17,0 }, { 80,16,2 }, { 49,17,1 }, { 18,18,0 }, { 112,16,3 }, { 81,17,2 }, { 50,18,1 }, { 19,19,0 }, { 113,17,3 }, { 82,18,2 }, { 51,19,1 }, { 114,18,3 }, { 83,19,2 }, { 115,19,3 }, { 144,16,4 }, { 176,16,5 }, { 145,17,4 }, { 208,16,6 }, { 177,17,5 }, { 146,18,4 },
  { 240,16,7 }, { 209,17,6 }, { 178,18,5 }, { 147,19,4 }, { 241,17,7 }, { 210,18,6 }, { 179,19,5 }, { 242,18,7 }, { 211,19,6 }, { 243,19,7 }, { 20,20,0 }, { 52,20,1 }, { 21,21,0 }, { 84,20,2 }, { 53,21,1 }, { 22,22,0 }, { 116,20,3 }, { 85,21,2 }, { 54,22,1 }, { 23,23,0 },
  { 117,21,3 }, { 86,22,2 }, { 55,23,1 }, { 118,22,3 }, { 87,23,2 }, { 119,23,3 }, { 148,20,4 }, { 180,20,5 }, { 149,21,4 }, { 212,20,6 }, { 181,21,5 }, { 150,22,4 }, { 244,20,7 }, { 213,21,6 }, { 182,22,5 }, { 151,23,4 }, { 245,21,7 }, { 214,22,6 }, { 183,23,5 }, { 246,22,7 },
  { 215,23,6 }, { 247,23,7 }, { 24,24,0 }, { 56,24,1 }, { 25,25,0 }, { 88,24,2 }, { 57,25,1 }, { 26,26,0 }, { 120,24,3 }, { 89,25,2 }, { 58,26,1 }, { 27,27,0 }, { 121,25,3 }, { 90,26,2 }, { 59,27,1 }, { 122,26,3 }, { 91,27,2 }, { 123,27,3 }, { 152,24,4 }, { 184,24,5 },
  { 153,25,4 }, { 216,24,6 }, { 185,25,5 }, { 154,26,4 }, { 248,24,7 }, { 217,25,6 }, { 186,26,5 }, { 155,27,4 }, { 249,25,7 }, { 218,26,6 }, { 187,27,5 }, { 250,26,7 }, { 219,27,6 }, { 251,27,7 }, { 28,28,0 }, { 60,28,1 }, { 29,29,0 }, { 92,28,2 }, { 61,29,1 }, { 30,30,0 },
  { 124,28,3 }, { 93,29,2 }, { 62,30,1 }, { 31,31,0 }, { 125,29,3 }, { 94,30,2 }, { 63,31,1 }, { 126,30,3 }, { 95,31,2 }, { 127,31,3 }, { 156,28,4 }, { 188,28,5 }, { 157,29,4 }, { 220,28,6 }, { 189,29,5 }, { 158,30,4 }, { 252,28,7 }, { 221,29,6 }, { 190,30,5 }, { 159,31,4 },
  { 253,29,7 }, { 222,30,6 }, { 191,31,5 }, { 254,30,7 }, { 223,31,6 }, { 255,31,7 }, { 0,0,0 }, { 32,0,1 }, { 1,1,0 }, { 64,0,2 }, { 33,1,1 }, { 2,2,0 }, { 96,0,3 }, { 65,1,2 }, { 34,2,1 }, { 3,3,0 }, { 97,1,3 }, { 66,2,2 }, { 35,3,1 }, { 98,2,3 },
  { 67,3,2 }, { 99,3,3 }, { 128,0,4 }, { 160,0,5 }, { 129,1,4 }, { 192,0,6 }, { 161,1,5 }, { 130,2,4 }, { 224,0,7 }, { 193,1,6 }, { 162,2,5 }, { 131,3,4 }, { 225,1,7 }, { 194,2,6 }, { 163,3,5 }, { 226,2,7 }, { 195,3,6 }, { 227,3,7 }, { 4,4,0 }, { 36,4,1 },
  { 5,5,0 }, { 68,4,2 }, { 37,5,1 }, { 6,6,0 }, { 100,4,3 }, { 69,5,2 }, { 38,6,1 }, { 7,7,0 }, { 101,5,3 }, { 70,6,2 }, { 39,7,1 }, { 102,6,3 }, { 71,7,2 }, { 103,7,3 }, { 256,0,8 }, { 288,0,9 }, { 257,1,8 }, { 320,0,10 }, { 289,1,9 }, { 258,2,8 },
  { 352,0,11 }, { 321,1,10 }, { 290,2,9 }, { 259,3,8 }, { 353,1,11 }, { 322,2,10 }, { 291,3,9 }, { 354,2,11 }, { 323,3,10 }, { 355,3,11 }, { 132,4,4 }, { 164,4,5 }, { 133,5,4 }, { 196,4,6 }, { 165,5,5 }, { 134,6,4 }, { 228,4,7 }, { 197,5,6 }, { 166,6,5 }, { 135,7,4 },
  { 229,5,7 }, { 198,6,6 }, { 167,7,5 }, { 230,6,7 }, { 199,7,6 }, { 231,7,7 }, { 8,8,0 }, { 40,8,1 }, { 9,9,0 }, { 72,8,2 }, { 41,9,1 }, { 10,10,0 }, { 104,8,3 }, { 73,9,2 }, { 42,10,1 }, { 11,11,0 }, { 105,9,3 }, { 74,10,2 }, { 43,11,1 }, { 106,10,3 },
  { 75,11,2 }, { 107,11,3 }, { 384,0,12 }, { 416,0,13 }, { 385,1,12 }, { 448,0,14 }, { 417,1,13 }, { 386,2,12 }, { 480,0,15 }, { 449,1,14 }, { 418,2,13 }, { 387,3,12 }, { 481,1,15 }, { 450,2,14 }, { 419,3,13 }, { 482,2,15 }, { 451,3,14 }, { 483,3,15 }, { 260,4,8 }, { 292,4,9 },
  { 261,5,8 }, { 324,4,10 }, { 293,5,9 }, { 262,6,8 }, { 356,4,11 }, { 325,5,10 }, { 294,6,9 }, { 263,7,8 }, { 357,5,11 }, { 326,6,10 }, { 295,7,9 }, { 358,6,11 }, { 327,7,10 }, { 359,7,11 }, { 136,8,4 }, { 168,8,5 }, { 137,9,4 }, { 200,8,6 }, { 169,9,5 }, { 138,10,4 },
  { 232,8,7 }, { 201,9,6 }, { 170,10,5 }, { 139,11,4 }, { 233,9,7 }, { 202,10,6 }, { 171,11,5 }, { 234,10,7 }, { 203,11,6 }, { 235,11,7 }, { 12,12,0 }, { 44,12,1 }, { 13,13,0 }, { 76,12,2 }, { 45,13,1 }, { 14,14,0 }, { 108,12,3 }, { 77,13,2 }, { 46,14,1 }, { 15,15,0 },
  { 109,13,3 }, { 78,14,2 }, { 47,15,1 }, { 110,14,3 }, { 79,15,2 }, { 111,15,3 }, { 388,4,12 }, { 420,4,13 }, { 389,5,12 }, { 452,4,14 }, { 421,5,13 }, { 390,6,12 }, { 484,4,15 }, { 453,5,14 }, { 422,6,13 }, { 391,7,12 }, { 485,5,15 }, { 454,6,14 }, { 423,7,13 }, { 486,6,15 },
  { 455,7,14 }, { 487,7,15 }, { 264,8,8 }, { 296,8,9 }, { 265,9,8 }, { 328,8,10 }, { 297,9,9 }, { 266,10,8 }, { 360,8,11 }, { 329,9,10 }, { 298,10,9 }, { 267,11,8 }, { 361,9,11 }, { 330,10,10 }, { 299,11,9 }, { 362,10,11 }, { 331,11,10 }, { 363,11,11 }, { 140,12,4 }, { 172,12,5 },
  { 141,13,4 }, { 204,12,6 }, { 173,13,5 }, { 142,14,4 }, { 236,12,7 }, { 205,13,6 }, { 174,14,5 }, { 143,15,4 }, { 237,13,7 }, { 206,14,6 }, { 175,15,5 }, { 238,14,7 }, { 207,15,6 }, { 239,15,7 }, { 16,16,0 }, { 48,16,1 }, { 17,17,0 }, { 80,16,2 }, { 49,17,1 }, { 18,18,0 },
  { 112,16,3 }, { 81,17,2 }, { 50,18,1 }, { 19,19,0 }, { 113,17,3 }, { 82,18,2 }, { 51,19,1 }, { 114,18,3 }, { 83,19,2 }, { 115,19,3 }, { 392,8,12 }, { 424,8,13 }, { 393,9,12 }, { 456,8,14 }, { 425,9,13 }, { 394,10,12 }, { 488,8,15 }, { 457,9,14 }, { 426,10,13 }, { 395,11,12 },
  { 489,9,15 }, { 458,10,14 }, { 427,11,13 }, { 490,10,15 }, { 459,11,14 }, { 491,11,15 }, { 268,12,8 }, { 300,12,9 }, { 269,13,8 }, { 332,12,10 }, { 301,13,9 }, { 270,14,8 }, { 364,12,11 }, { 333,13,10 }, { 302,14,9 }, { 271,15,8 }, { 365,13,11 }, { 334,14,10 }, { 303,15,9 }, { 366,14,11 },
  { 335,15,10 }, { 367,15,11 }, { 144,16,4 }, { 176,16,5 }, { 145,17,4 }, { 208,16,6 }, { 177,17,5 }, { 146,18,4 }, { 240,16,7 }, { 209,17,6 }, { 178,18,5 }, { 147,19,4 }, { 241,17,7 }, { 210,18,6 }, { 179,19,5 }, { 242,18,7 }, { 211,19,6 }, { 243,19,7 }, { 20,20,0 }, { 52,20,1 },
  { 21,21,0 }, { 84,20,2 }, { 53,21,1 }, { 22,22,0 }, { 116,20,3 }, { 85,21,2 }, { 54,22,1 }, { 23,23,0 }, { 117,21,3 }, { 86,22,2 }, { 55,23,1 }, { 118,22,3 }, { 87,23,2 }, { 119,23,3 }, { 396,12,12 }, { 428,12,13 }, { 397,13,12 }, { 460,12,14 }, { 429,13,13 }, { 398,14,12 },
  { 492,12,15 }, { 461,13,14 }, { 430,14,13 }, { 399,15,12 }, { 493,13,15 }, { 462,14,14 }, { 431,15,13 }, { 494,14,15 }, { 463,15,14 }, { 495,15,15 }, { 272,16,8 }, { 304,16,9 }, { 273,17,8 }, { 336,16,10 }, { 305,17,9 }, { 274,18,8 }, { 368,16,11 }, { 337,17,10 }, { 306,18,9 }, { 275,19,8 },
  { 369,17,11 }, { 338,18,10 }, { 307,19,9 }, { 370,18,11 }, { 339,19,10 }, { 371,19,11 }, { 148,20,4 }, { 180,20,5 }, { 149,21,4 }, { 212,20,6 }, { 181,21,5 }, { 150,22,4 }, { 244,20,7 }, { 213,21,6 }, { 182,22,5 }, { 151,23,4 }, { 245,21,7 }, { 214,22,6 }, { 183,23,5 }, { 246,22,7 },
  { 215,23,6 }, { 247,23,7 }, { 24,24,0 }, { 56,24,1 }, { 25,25,0 }, { 88,24,2 }, { 57,25,1 }, { 26,26,0 }, { 120,24,3 }, { 89,25,2 }, { 58,26,1 }, { 27,27,0 }, { 121,25,3 }, { 90,26,2 }, { 59,27,1 }, { 122,26,3 }, { 91,27,2 }, { 123,27,3 }, { 400,16,12 }, { 432,16,13 },
  { 401,17,12 }, { 464,16,14 }, { 433,17,13 }, { 402,18,12 }, { 496,16,15 }, { 465,17,14 }, { 434,18,13 }, { 403,19,12 }, { 497,17,15 }, { 466,18,14 }, { 435,19,13 }, { 498,18,15 }, { 467,19,14 }, { 499,19,15 }, { 276,20,8 }, { 308,20,9 }, { 277,21,8 }, { 340,20,10 }, { 309,21,9 }, { 278,22,8 },
  { 372,20,11 }, { 341,21,10 }, { 310,22,9 }, { 279,23,8 }, { 373,21,11 }, { 342,22,10 }, { 311,23,9 }, { 374,22,11 }, { 343,23,10 }, { 375,23,11 }, { 152,24,4 }, { 184,24,5 }, { 153,25,4 }, { 216,24,6 }, { 185,25,5 }, { 154,26,4 }, { 248,24,7 }, { 217,25,6 }, { 186,26,5 }, { 155,27,4 },
  { 249,25,7 }, { 218,26,6 }, { 187,27,5 }, { 250,26,7 }, { 219,27,6 }, { 251,27,7 }, { 28,28,0 }, { 60,28,1 }, { 29,29,0 }, { 92,28,2 }, { 61,29,1 }, { 30,30,0 }, { 124,28,3 }, { 93,29,2 }, { 62,30,1 }, { 31,31,0 }, { 125,29,3 }, { 94,30,2 }, { 63,31,1 }, { 126,30,3 },
  { 95,31,2 }, { 127,31,3 }, { 404,20,12 }, { 436,20,13 }, { 405,21,12 }, { 468,20,14 }, { 437,21,13 }, { 406,22,12 }, { 500,20,15 }, { 469,21,14 }, { 438,22,13 }, { 407,23,12 }, { 501,21,15 }, { 470,22,14 }, { 439,23,13 }, { 502,22,15 }, { 471,23,14 }, { 503,23,15 }, { 280,24,8 }, { 312,24,9 },
  { 281,25,8 }, { 344,24,10 }, { 313,25,9 }, { 282,26,8 }, { 376,24,11 }, { 345,25,10 }, { 314,26,9 }, { 283,27,8 }, { 377,25,11 }, { 346,26,10 }, { 315,27,9 }, { 378,26,11 }, { 347,27,10 }, { 379,27,11 }, { 156,28,4 }, { 188,28,5 }, { 157,29,4 }, { 220,28,6 }, { 189,29,5 }, { 158,30,4 },
  { 252,28,7 }, { 221,29,6 }, { 190,30,5 }, { 159,31,4 }, { 253,29,7 }, { 222,30,6 }, { 191,31,5 }, { 254,30,7 }, { 223,31,6 }, { 255,31,7 }, { 408,24,12 }, { 440,24,13 }, { 409,25,12 }, { 472,24,14 }, { 441,25,13 }, { 410,26,12 }, { 504,24,15 }, { 473,25,14 }, { 442,26,13 }, { 411,27,12 },
  { 505,25,15 }, { 474,26,14 }, { 443,27,13 }, { 506,26,15 }, { 475,27,14 }, { 507,27,15 }, { 284,28,8 }, { 316,28,9 }, { 285,29,8 }, { 348,28,10 }, { 317,29,9 }, { 286,30,8 }, { 380,28,11 }, { 349,29,10 }, { 318,30,9 }, { 287,31,8 }, { 381,29,11 }, { 350,30,10 }, { 319,31,9 }, { 382,30,11 },
  { 351,31,10 }, { 383,31,11 }, { 412,28,12 }, { 444,28,13 }, { 413,29,12 }, { 476,28,14 }, { 445,29,13 }, { 414,30,12 }, { 508,28,15 }, { 477,29,14 }, { 446,30,13 }, { 415,31,12 }, { 509,29,15 }, { 478,30,14 }, { 447,31,13 }, { 510,30,15 }, { 479,31,14 }, { 511,31,15 }, { 0,0,0 }, { 32,0,1 },
  { 1,1,0 }, { 64,0,2 }, { 33,1,1 }, { 2,2,0 }, { 96,0,3 }, { 65,1,2 }, { 34,2,1 }, { 3,3,0 }, { 97,1,3 }, { 66,2,2 }, { 35,3,1 }, { 98,2,3 }, { 67,3,2 }, { 99,3,3 }, { 128,0,4 }, { 160,0,5 }, { 129,1,4 }, { 192,0,6 }, { 161,1,5 }, { 130,2,4 },
  { 224,0,7 }, { 193,1,6 }, { 162,2,5 }, { 131,3,4 }, { 225,1,7 }, { 194,2,6 }, { 163,3,5 }, { 226,2,7 }, { 195,3,6 }, { 227,3,7 }, { 4,4,0 }, { 36,4,1 }, { 5,5,0 }, { 68,4,2 }, { 37,5,1 }, { 6,6,0 }, { 100,4,3 }, { 69,5,2 }, { 38,6,1 }, { 7,7,0 },
  { 101,5,3 }, { 70,6,2 }, { 39,7,1 }, { 102,6,3 }, { 71,7,2 }, { 103,7,3 }, { 256,0,8 }, { 288,0,9 }, { 257,1,8 }, { 320,0,10 }, { 289,1,9 }, { 258,2,8 }, { 352,0,11 }, { 321,1,10 }, { 290,2,9 }, { 259,3,8 }, { 353,1,11 }, { 322,2,10 }, { 291,3,9 }, { 354,2,11 },
  { 323,3,10 }, { 355,3,11 }, { 132,4,4 }, { 164,4,5 }, { 133,5,4 }, { 196,4,6 }, { 165,5,5 }, { 134,6,4 }, { 228,4,7 }, { 197,5,6 }, { 166,6,5 }, { 135,7,4 }, { 229,5,7 }, { 198,6,6 }, { 167,7,5 }, { 230,6,7 }, { 199,7,6 }, { 231,7,7 }, { 8,8,0 }, { 40,8,1 },
  { 9,9,0 }, { 72,8,2 }, { 41,9,1 }, { 10,10,0 }, { 104,8,3 }, { 73,9,2 }, { 42,10,1 }, { 11,11,0 }, { 105,9,3 }, { 74,10,2 }, { 43,11,1 }, { 106,10,3 }, { 75,11,2 }, { 107,11,3 }, { 384,0,12 }, { 416,0,13 }, { 385,1,12 }, { 448,0,14 }, { 417,1,13 }, { 386,2,12 },
  { 480,0,15 }, { 449,1,14 }, { 418,2,13 }, { 387,3,12 }, { 481,1,15 }, { 450,2,14 }, { 419,3,13 }, { 482,2,15 }, { 451,3,14 }, { 483,3,15 }, { 260,4,8 }, { 292,4,9 }, { 261,5,8 }, { 324,4,10 }, { 293,5,9 }, { 262,6,8 }, { 356,4,11 }, { 325,5,10 }, { 294,6,9 }, { 263,7,8 },
  { 357,5,11 }, { 326,6,10 }, { 295,7,9 }, { 358,6,11 }, { 327,7,10 }, { 359,7,11 }, { 136,8,4 }, { 168,8,5 }, { 137,9,4 }, { 200,8,6 }, { 169,9,5 }, { 138,10,4 }, { 232,8,7 }, { 201,9,6 }, { 170,10,5 }, { 139,11,4 }, { 233,9,7 }, { 202,10,6 }, { 171,11,5 }, { 234,10,7 },
  { 203,11,6 }, { 235,11,7 }, { 12,12,0 }, { 44,12,1 }, { 13,13,0 }, { 76,12,2 }, { 45,13,1 }, { 14,14,0 }, { 108,12,3 }, { 77,13,2 }, { 46,14,1 }, { 15,15,0 }, { 109,13,3 }, { 78,14,2 }, { 47,15,1 }, { 110,14,3 }, { 79,15,2 }, { 111,15,3 }, { 512,0,16 }, { 544,0,17 },
  { 513,1,16 }, { 576,0,18 }, { 545,1,17 }, { 514,2,16 }, { 608,0,19 }, { 577,1,18 }, { 546,2,17 }, { 515,3,16 }, { 609,1,19 }, { 578,2,18 }, { 547,3,17 }, { 610,2,19 }, { 579,3,18 }, { 611,3,19 }, { 388,4,12 }, { 420,4,13 }, { 389,5,12 }, { 452,4,14 }, { 421,5,13 }, { 390,6,12 },
  { 484,4,15 }, { 453,5,14 }, { 422,6,13 }, { 391,7,12 }, { 485,5,15 }, { 454,6,14 }, { 423,7,13 }, { 486,6,15 }, { 455,7,14 }, { 487,7,15 }, { 264,8,8 }, { 296,8,9 }, { 265,9,8 }, { 328,8,10 }, { 297,9,9 }, { 266,10,8 }, { 360,8,11 }, { 329,9,10 }, { 298,10,9 }, { 267,11,8 },
  { 361,9,11 }, { 330,10,10 }, { 299,11,9 }, { 362,10,11 }, { 331,11,10 }, { 363,11,11 }, { 140,12,4 }, { 172,12,5 }, { 141,13,4 }, { 204,12,6 }, { 173,13,5 }, { 142,14,4 }, { 236,12,7 }, { 205,13,6 }, { 174,14,5 }, { 143,15,4 }, { 237,13,7 }, { 206,14,6 }, { 175,15,5 }, { 238,14,7 },
  { 207,15,6 }, { 239,15,7 }, { 16,16,0 }, { 48,16,1 }, { 17,17,0 }, { 80,16,2 }, { 49,17,1 }, { 18,18,0 }, { 112,16,3 }, { 81,17,2 }, { 50,18,1 }, { 19,19,0 }, { 113,17,3 }, { 82,18,2 }, { 51,19,1 }, { 114,18,3 }, { 83,19,2 }, { 115,19,3 }, { 640,0,20 }, { 672,0,21 },
  { 641,1,20 }, { 704,0,22 }, { 673,1,21 }, { 642,2,20 }, { 736,0,23 }, { 705,1,22 }, { 674,2,21 }, { 643,3,20 }, { 737,1,23 }, { 706,2,22 }, { 675,3,21 }, { 738,2,23 }, { 707,3,22 }, { 739,3,23 }, { 516,4,16 }, { 548,4,17 }, { 517,5,16 }, { 580,4,18 }, { 549,5,17 }, { 518,6,16 },
  { 612,4,19 }, { 581,5,18 }, { 550,6,17 }, { 519,7,16 }, { 613,5,19 }, { 582,6,18 }, { 551,7,17 }, { 614,6,19 }, { 583,7,18 }, { 615,7,19 }, { 392,8,12 }, { 424,8,13 }, { 393,9,12 }, { 456,8,14 }, { 425,9,13 }, { 394,10,12 }, { 488,8,15 }, { 457,9,14 }, { 426,10,13 }, { 395,11,12 },
  { 489,9,15 }, { 458,10,14 }, { 427,11,13 }, { 490,10,15 }, { 459,11,14 }, { 491,11,15 }, { 268,12,8 }, { 300,12,9 }, { 269,13,8 }, { 332,12,10 }, { 301,13,9 }, { 270,14,8 }, { 364,12,11 }, { 333,13,10 }, { 302,14,9 }, { 271,15,8 }, { 365,13,11 }, { 334,14,10 }, { 303,15,9 }, { 366,14,11 },
  { 335,15,10 }, { 367,15,11 }, { 144,16,4 }, { 176,16,5 }, { 145,17,4 }, { 208,16,6 }, { 177,17,5 }, { 146,18,4 }, { 240,16,7 }, { 209,17,6 }, { 178,18,5 }, { 147,19,4 }, { 241,17,7 }, { 210,18,6 }, { 179,19,5 }, { 242,18,7 }, { 211,19,6 }, { 243,19,7 }, { 20,20,0 }, { 52,20,1 },
  { 21,21,0 }, { 84,20,2 }, { 53,21,1 }, { 22,22,0 }, { 116,20,3 }, { 85,21,2 }, { 54,22,1 }, { 23,23,0 }, { 117,21,3 }, { 86,22,2 }, { 55,23,1 }, { 118,22,3 }, { 87,23,2 }, { 119,23,3 }, { 768,0,24 }, { 800,0,25 }, { 769,1,24 }, { 832,0,26 }, { 801,1,25 }, { 770,2,24 },
  { 864,0,27 }, { 833,1,26 }, { 802,2,25 }, { 771,3,24 }, { 865,1,27 }, { 834,2,26 }, { 803,3,25 }, { 866,2,27 }, { 835,3,26 }, { 867,3,27 }, { 644,4,20 }, { 676,4,21 }, { 645,5,20 }, { 708,4,22 }, { 677,5,21 }, { 646,6,20 }, { 740,4,23 }, { 709,5,22 }, { 678,6,21 }, { 647,7,20 },
  { 741,5,23 }, { 710,6,22 }, { 679,7,21 }, { 742,6,23 }, { 711,7,22 }, { 743,7,23 }, { 520,8,16 }, { 552,8,17 }, { 521,9,16 }, { 584,8,18 }, { 553,9,17 }, { 522,10,16 }, { 616,8,19 }, { 585,9,18 }, { 554,10,17 }, { 523,11,16 }, { 617,9,19 }, { 586,10,18 }, { 555,11,17 }, { 618,10,19 },
  { 587,11,18 }, { 619,11,19 }, { 396,12,12 }, { 428,12,13 }, { 397,13,12 }, { 460,12,14 }, { 429,13,13 }, { 398,14,12 }, { 492,12,15 }, { 461,13,14 }, { 430,14,13 }, { 399,15,12 }, { 493,13,15 }, { 462,14,14 }, { 431,15,13 }, { 494,14,15 }, { 463,15,14 }, { 495,15,15 }, { 272,16,8 }, { 304,16,9 },
  { 273,17,8 }, { 336,16,10 }, { 305,17,9 }, { 274,18,8 }, { 368,16,11 }, { 337,17,10 }, { 306,18,9 }, { 275,19,8 }, { 369,17,11 }, { 338,18,10 }, { 307,19,9 }, { 370,18,11 }, { 339,19,10 }, { 371,19,11 }, { 148,20,4 }, { 180,20,5 }, { 149,21,4 }, { 212,20,6 }, { 181,21,5 }, { 150,22,4 },
  { 244,20,7 }, { 213,21,6 }, { 182,22,5 }, { 151,23,4 }, { 245,21,7 }, { 214,22,6 }, { 183,23,5 }, { 246,22,7 }, { 215,23,6 }, { 247,23,7 }, { 24,24,0 }, { 56,24,1 }, { 25,25,0 }, { 88,24,2 }, { 57,25,1 }, { 26,26,0 }, { 120,24,3 }, { 89,25,2 }, { 58,26,1 }, { 27,27,0 },
  { 121,25,3 }, { 90,26,2 }, { 59,27,1 }, { 122,26,3 }, { 91,27,2 }, { 123,27,3 }, { 896,0,28 }, { 928,0,29 }, { 897,1,28 }, { 960,0,30 }, { 929,1,29 }, { 898,2,28 }, { 992,0,31 }, { 961,1,30 }, { 930,2,29 }, { 899,3,28 }, { 993,1,31 }, { 962,2,30 }, { 931,3,29 }, { 994,2,31 },
  { 963,3,30 }, { 995,3,31 }, { 772,4,24 }, { 804,4,25 }, { 773,5,24 }, { 836,4,26 }, { 805,5,25 }, { 774,6,24 }, { 868,4,27 }, { 837,5,26 }, { 806,6,25 }, { 775,7,24 }, { 869,5,27 }, { 838,6,26 }, { 807,7,25 }, { 870,6,27 }, { 839,7,26 }, { 871,7,27 }, { 648,8,20 }, { 680,8,21 },
  { 649,9,20 }, { 712,8,22 }, { 681,9,21 }, { 650,10,20 }, { 744,8,23 }, { 713,9,22 }, { 682,10,21 }, { 651,11,20 }, { 745,9,23 }, { 714,10,22 }, { 683,11,21 }, { 746,10,23 }, { 715,11,22 }, { 747,11,23 }, { 524,12,16 }, { 556,12,17 }, { 525,13,16 }, { 588,12,18 }, { 557,13,17 }, { 526,14,16 },
  { 620,12,19 }, { 589,13,18 }, { 558,14,17 }, { 527,15,16 }, { 621,13,19 }, { 590,14,18 }, { 559,15,17 }, { 622,14,19 }, { 591,15,18 }, { 623,15,19 }, { 400,16,12 }, { 432,16,13 }, { 401,17,12 }, { 464,16,14 }, { 433,17,13 }, { 402,18,12 }, { 496,16,15 }, { 465,17,14 }, { 434,18,13 }, { 403,19,12 },
  { 497,17,15 }, { 466,18,14 }, { 435,19,13 }, { 498,18,15 }, { 467,19,14 }, { 499,19,15 }, { 276,20,8 }, { 308,20,9 }, { 277,21,8 }, { 340,20,10 }, { 309,21,9 }, { 278,22,8 }, { 372,20,11 }, { 341,21,10 }, { 310,22,9 }, { 279,23,8 }, { 373,21,11 }, { 342,22,10 }, { 311,23,9 }, { 374,22,11 },
  { 343,23,10 }, { 375,23,11 }, { 152,24,4 }, { 184,24,5 }, { 153,25,4 }, { 216,24,6 }, { 185,25,5 }, { 154,26,4 }, { 248,24,7 }, { 217,25,6 }, { 186,26,5 }, { 155,27,4 }, { 249,25,7 }, { 218,26,6 }, { 187,27,5 }, { 250,26,7 }, { 219,27,6 }, { 251,27,7 }, { 28,28,0 }, { 60,28,1 },
  { 29,29,0 }, { 92,28,2 }, { 61,29,1 }, { 30,30,0 }, { 124,28,3 }, { 93,29,2 }, { 62,30,1 }, { 31,31,0 }, { 125,29,3 }, { 94,30,2 }, { 63,31,1 }, { 126,30,3 }, { 95,31,2 }, { 127,31,3 }, { 900,4,28 }, { 932,4,29 }, { 901,5,28 }, { 964,4,30 }, { 933,5,29 }, { 902,6,28 },
  { 996,4,31 }, { 965,5,30 }, { 934,6,29 }, { 903,7,28 }, { 997,5,31 }, { 966,6,30 }, { 935,7,29 }, { 998,6,31 }, { 967,7,30 }, { 999,7,31 }, { 776,8,24 }, { 808,8,25 }, { 777,9,24 }, { 840,8,26 }, { 809,9,25 }, { 778,10,24 }, { 872,8,27 }, { 841,9,26 }, { 810,10,25 }, { 779,11,24 },
  { 873,9,27 }, { 842,10,26 }, { 811,11,25 }, { 874,10,27 }, { 843,11,26 }, { 875,11,27 }, { 652,12,20 }, { 684,12,21 }, { 653,13,20 }, { 716,12,22 }, { 685,13,21 }, { 654,14,20 }, { 748,12,23 }, { 717,13,22 }, { 686,14,21 }, { 655,15,20 }, { 749,13,23 }, { 718,14,22 }, { 687,15,21 }, { 750,14,23 },
  { 719,15,22 }, { 751,15,23 }, { 528,16,16 }, { 560,16,17 }, { 529,17,16 }, { 592,16,18 }, { 561,17,17 }, { 530,18,16 }, { 624,16,19 }, { 593,17,18 }, { 562,18,17 }, { 531,19,16 }, { 625,17,19 }, { 594,18,18 }, { 563,19,17 }, { 626,18,19 }, { 595,19,18 }, { 627,19,19 }, { 404,20,12 }, { 436,20,13 },
  { 405,21,12 }, { 468,20,14 }, { 437,21,13 }, { 406,22,12 }, { 500,20,15 }, { 469,21,14 }, { 438,22,13 }, { 407,23,12 }, { 501,21,15 }, { 470,22,14 }, { 439,23,13 }, { 502,22,15 }, { 471,23,14 }, { 503,23,15 }, { 280,24,8 }, { 312,24,9 }, { 281,25,8 }, { 344,24,10 }, { 313,25,9 }, { 282,26,8 },
  { 376,24,11 }, { 345,25,10 }, { 314,26,9 }, { 283,27,8 }, { 377,25,11 }, { 346,26,10 }, { 315,27,9 }, { 378,26,11 }, { 347,27,10 }, { 379,27,11 }, { 156,28,4 }, { 188,28,5 }, { 157,29,4 }, { 220,28,6 }, { 189,29,5 }, { 158,30,4 }, { 252,28,7 }, { 221,29,6 }, { 190,30,5 }, { 159,31,4 },
  { 253,29,7 }, { 222,30,6 }, { 191,31,5 }, { 254,30,7 }, { 223,31,6 }, { 255,31,7 }, { 904,8,28 }, { 936,8,29 }, { 905,9,28 }, { 968,8,30 }, { 937,9,29 }, { 906,10,28 }, { 1000,8,31 }, { 969,9,30 }, { 938,10,29 }, { 907,11,28 }, { 1001,9,31 }, { 970,10,30 }, { 939,11,29 }, { 1002,10,31 },
  { 971,11,30 }, { 1003,11,31 }, { 780,12,24 }, { 812,12,25 }, { 781,13,24 }, { 844,12,26 }, { 813,13,25 }, { 782,14,24 }, { 876,12,27 }, { 845,13,26 }, { 814,14,25 }, { 783,15,24 }, { 877,13,27 }, { 846,14,26 }, { 815,15,25 }, { 878,14,27 }, { 847,15,26 }, { 879,15,27 }, { 656,16,20 }, { 688,16,21 },
  { 657,17,20 }, { 720,16,22 }, { 689,17,21 }, { 658,18,20 }, { 752,16,23 }, { 721,17,22 }, { 690,18,21 }, { 659,19,20 }, { 753,17,23 }, { 722,18,22 }, { 691,19,21 }, { 754,18,23 }, { 723,19,22 }, { 755,19,23 }, { 532,20,16 }, { 564,20,17 }, { 533,21,16 }, { 596,20,18 }, { 565,21,17 }, { 534,22,16 },
  { 628,20,19 }, { 597,21,18 }, { 566,22,17 }, { 535,23,16 }, { 629,21,19 }, { 598,22,18 }, { 567,23,17 }, { 630,22,19 }, { 599,23,18 }, { 631,23,19 }, { 408,24,12 }, { 440,24,13 }, { 409,25,12 }, { 472,24,14 }, { 441,25,13 }, { 410,26,12 }, { 504,24,15 }, { 473,25,14 }, { 442,26,13 }, { 411,27,12 },
  { 505,25,15 }, { 474,26,14 }, { 443,27,13 }, { 506,26,15 }, { 475,27,14 }, { 507,27,15 }, { 284,28,8 }, { 316,28,9 }, { 285,29,8 }, { 348,28,10 }, { 317,29,9 }, { 286,30,8 }, { 380,28,11 }, { 349,29,10 }, { 318,30,9 }, { 287,31,8 }, { 381,29,11 }, { 350,30,10 }, { 319,31,9 }, { 382,30,11 },
  { 351,31,10 }, { 383,31,11 }, { 908,12,28 }, { 940,12,29 }, { 909,13,28 }, { 972,12,30 }, { 941,13,29 }, { 910,14,28 }, { 1004,12,31 }, { 973,13,30 }, { 942,14,29 }, { 911,15,28 }, { 1005,13,31 }, { 974,14,30 }, { 943,15,29 }, { 1006,14,31 }, { 975,15,30 }, { 1007,15,31 }, { 784,16,24 }, { 816,16,25 },
  { 785,17,24 }, { 848,16,26 }, { 817,17,25 }, { 786,18,24 }, { 880,16,27 }, { 849,17,26 }, { 818,18,25 }, { 787,19,24 }, { 881,17,27 }, { 850,18,26 }, { 819,19,25 }, { 882,18,27 }, { 851,19,26 }, { 883,19,27 }, { 660,20,20 }, { 692,20,21 }, { 661,21,20 }, { 724,20,22 }, { 693,21,21 }, { 662,22,20 },
  { 756,20,23 }, { 725,21,22 }, { 694,22,21 }, { 663,23,20 }, { 757,21,23 }, { 726,22,22 }, { 695,23,21 }, { 758,22,23 }, { 727,23,22 }, { 759,23,23 }, { 536,24,16 }, { 568,24,17 }, { 537,25,16 }, { 600,24,18 }, { 569,25,17 }, { 538,26,16 }, { 632,24,19 }, { 601,25,18 }, { 570,26,17 }, { 539,27,16 },
  { 633,25,19 }, { 602,26,18 }, { 571,27,17 }, { 634,26,19 }, { 603,27,18 }, { 635,27,19 }, { 412,28,12 }, { 444,28,13 }, { 413,29,12 }, { 476,28,14 }, { 445,29,13 }, { 414,30,12 }, { 508,28,15 }, { 477,29,14 }, { 446,30,13 }, { 415,31,12 }, { 509,29,15 }, { 478,30,14 }, { 447,31,13 }, { 510,30,15 },
  { 479,31,14 }, { 511,31,15 }, { 912,16,28 }, { 944,16,29 }, { 913,17,28 }, { 976,16,30 }, { 945,17,29 }, { 914,18,28 }, { 1008,16,31 }, { 977,17,30 }, { 946,18,29 }, { 915,19,28 }, { 1009,17,31 }, { 978,18,30 }, { 947,19,29 }, { 1010,18,31 }, { 979,19,30 }, { 1011,19,31 }, { 788,20,24 }, { 820,20,25 },
  { 789,21,24 }, { 852,20,26 }, { 821,21,25 }, { 790,22,24 }, { 884,20,27 }, { 853,21,26 }, { 822,22,25 }, { 791,23,24 }, { 885,21,27 }, { 854,22,26 }, { 823,23,25 }, { 886,22,27 }, { 855,23,26 }, { 887,23,27 }, { 664,24,20 }, { 696,24,21 }, { 665,25,20 }, { 728,24,22 }, { 697,25,21 }, { 666,26,20 },
  { 760,24,23 }, { 729,25,22 }, { 698,26,21 }, { 667,27,20 }, { 761,25,23 }, { 730,26,22 }, { 699,27,21 }, { 762,26,23 }, { 731,27,22 }, { 763,27,23 }, { 540,28,16 }, { 572,28,17 }, { 541,29,16 }, { 604,28,18 }, { 573,29,17 }, { 542,30,16 }, { 636,28,19 }, { 605,29,18 }, { 574,30,17 }, { 543,31,16 },
  { 637,29,19 }, { 606,30,18 }, { 575,31,17 }, { 638,30,19 }, { 607,31,18 }, { 639,31,19 }, { 916,20,28 }, { 948,20,29 }, { 917,21,28 }, { 980,20,30 }, { 949,21,29 }, { 918,22,28 }, { 1012,20,31 }, { 981,21,30 }, { 950,22,29 }, { 919,23,28 }, { 1013,21,31 }, { 982,22,30 }, { 951,23,29 }, { 1014,22,31 },
  { 983,23,30 }, { 1015,23,31 }, { 792,24,24 }, { 824,24,25 }, { 793,25,24 }, { 856,24,26 }, { 825,25,25 }, { 794,26,24 }, { 888,24,27 }, { 857,25,26 }, { 826,26,25 }, { 795,27,24 }, { 889,25,27 }, { 858,26,26 }, { 827,27,25 }, { 890,26,27 }, { 859,27,26 }, { 891,27,27 }, { 668,28,20 }, { 700,28,21 },
  { 669,29,20 }, { 732,28,22 }, { 701,29,21 }, { 670,30,20 }, { 764,28,23 }, { 733,29,22 }, { 702,30,21 }, { 671,31,20 }, { 765,29,23 }, { 734,30,22 }, { 703,31,21 }, { 766,30,23 }, { 735,31,22 }, { 767,31,23 }, { 920,24,28 }, { 952,24,29 }, { 921,25,28 }, { 984,24,30 }, { 953,25,29 }, { 922,26,28 },
  { 1016,24,31 }, { 985,25,30 }, { 954,26,29 }, { 923,27,28 }, { 1017,25,31 }, { 986,26,30 }, { 955,27,29 }, { 1018,26,31 }, { 987,27,30 }, { 1019,27,31 }, { 796,28,24 }, { 828,28,25 }, { 797,29,24 }, { 860,28,26 }, { 829,29,25 }, { 798,30,24 }, { 892,28,27 }, { 861,29,26 }, { 830,30,25 }, { 799,31,24 },
  { 893,29,27 }, { 862,30,26 }, { 831,31,25 }, { 894,30,27 }, { 863,31,26 }, { 895,31,27 }, { 924,28,28 }, { 956,28,29 }, { 925,29,28 }, { 988,28,30 }, { 957,29,29 }, { 926,30,28 }, { 1020,28,31 }, { 989,29,30 }, { 958,30,29 }, { 927,31,28 }, { 1021,29,31 }, { 990,30,30 }, { 959,31,29 }, { 1022,30,31 },
  { 991,31,30 }, { 1023,31,31 }, { 0,0,0 }, { 32,0,1 }, { 1,1,0 }, { 64,0,2 }, { 33,1,1 }, { 2,2,0 }, { 96,0,3 }, { 65,1,2 }, { 34,2,1 }, { 3,3,0 }, { 97,1,3 }, { 66,2,2 }, { 35,3,1 }, { 98,2,3 }, { 67,3,2 }, { 99,3,3 }, { 128,0,4 }, { 160,0,5 },
  { 129,1,4 }, { 192,0,6 }, { 161,1,5 }, { 130,2,4 }, { 224,0,7 }, { 193,1,6 }, { 162,2,5 }, { 131,3,4 }, { 225,1,7 }, { 194,2,6 }, { 163,3,5 }, { 226,2,7 }, { 195,3,6 }, { 227,3,7 }, { 4,4,0 }, { 36,4,1 }, { 5,5,0 }, { 68,4,2 }, { 37,5,1 }, { 6,6,0 },
  { 100,4,3 }, { 69,5,2 }, { 38,6,1 }, { 7,7,0 }, { 101,5,3 }, { 70,6,2 }, { 39,7,1 }, { 102,6,3 }, { 71,7,2 }, { 103,7,3 }, { 256,0,8 }, { 288,0,9 }, { 257,1,8 }, { 320,0,10 }, { 289,1,9 }, { 258,2,8 }, { 352,0,11 }, { 321,1,10 }, { 290,2,9 }, { 259,3,8 },
  { 353,1,11 }, { 322,2,10 }, { 291,3,9 }, { 354,2,11 }, { 323,3,10 }, { 355,3,11 }, { 132,4,4 }, { 164,4,5 }, { 133,5,4 }, { 196,4,6 }, { 165,5,5 }, { 134,6,4 }, { 228,4,7 }, { 197,5,6 }, { 166,6,5 }, { 135,7,4 }, { 229,5,7 }, { 198,6,6 }, { 167,7,5 }, { 230,6,7 },
  { 199,7,6 }, { 231,7,7 }, { 8,8,0 }, { 40,8,1 }, { 9,9,0 }, { 72,8,2 }, { 41,9,1 }, { 10,10,0 }, { 104,8,3 }, { 73,9,2 }, { 42,10,1 }, { 11,11,0 }, { 105,9,3 }, { 74,10,2 }, { 43,11,1 }, { 106,10,3 }, { 75,11,2 }, { 107,11,3 }, { 384,0,12 }, { 416,0,13 },
  { 385,1,12 }, { 448,0,14 }, { 417,1,13 }, { 386,2,12 }, { 480,0,15 }, { 449,1,14 }, { 418,2,13 }, { 387,3,12 }, { 481,1,15 }, { 450,2,14 }, { 419,3,13 }, { 482,2,15 }, { 451,3,14 }, { 483,3,15 }, { 260,4,8 }, { 292,4,9 }, { 261,5,8 }, { 324,4,10 }, { 293,5,9 }, { 262,6,8 },
  { 356,4,11 }, { 325,5,10 }, { 294,6,9 }, { 263,7,8 }, { 357,5,11 }, { 326,6,10 }, { 295,7,9 }, { 358,6,11 }, { 327,7,10 }, { 359,7,11 }, { 136,8,4 }, { 168,8,5 }, { 137,9,4 }, { 200,8,6 }, { 169,9,5 }, { 138,10,4 }, { 232,8,7 }, { 201,9,6 }, { 170,10,5 }, { 139,11,4 },
  { 233,9,7 }, { 202,10,6 }, { 171,11,5 }, { 234,10,7 }, { 203,11,6 }, { 235,11,7 }, { 12,12,0 }, { 44,12,1 }, { 13,13,0 }, { 76,12,2 }, { 45,13,1 }, { 14,14,0 }, { 108,12,3 }, { 77,13,2 }, { 46,14,1 }, { 15,15,0 }, { 109,13,3 }, { 78,14,2 }, { 47,15,1 }, { 110,14,3 },
  { 79,15,2 }, { 111,15,3 }, { 512,0,16 }, { 544,0,17 }, { 513,1,16 }, { 576,0,18 }, { 545,1,17 }, { 514,2,16 }, { 608,0,19 }, { 577,1,18 }, { 546,2,17 }, { 515,3,16 }, { 609,1,19 }, { 578,2,18 }, { 547,3,17 }, { 610,2,19 }, { 579,3,18 }, { 611,3,19 }, { 388,4,12 }, { 420,4,13 },
  { 389,5,12 }, { 452,4,14 }, { 421,5,13 }, { 390,6,12 }, { 484,4,15 }, { 453,5,14 }, { 422,6,13 }, { 391,7,12 }, { 485,5,15 }, { 454,6,14 }, { 423,7,13 }, { 486,6,15 }, { 455,7,14 }, { 487,7,15 }, { 264,8,8 }, { 296,8,9 }, { 265,9,8 }, { 328,8,10 }, { 297,9,9 }, { 266,10,8 },
  { 360,8,11 }, { 329,9,10 }, { 298,10,9 }, { 267,11,8 }, { 361,9,11 }, { 330,10,10 }, { 299,11,9 }, { 362,10,11 }, { 331,11,10 }, { 363,11,11 }, { 140,12,4 }, { 172,12,5 }, { 141,13,4 }, { 204,12,6 }, { 173,13,5 }, { 142,14,4 }, { 236,12,7 }, { 205,13,6 }, { 174,14,5 }, { 143,15,4 },
  { 237,13,7 }, { 206,14,6 }, { 175,15,5 }, { 238,14,7 }, { 207,15,6 }, { 239,15,7 }, { 16,16,0 }, { 48,16,1 }, { 17,17,0 }, { 80,16,2 }, { 49,17,1 }, { 18,18,0 }, { 112,16,3 }, { 81,17,2 }, { 50,18,1 }, { 19,19,0 }, { 113,17,3 }, { 82,18,2 }, { 51,19,1 }, { 114,18,3 },
  { 83,19,2 }, { 115,19,3 }, { 640,0,20 }, { 672,0,21 }, { 641,1,20 }, { 704,0,22 }, { 673,1,21 }, { 642,2,20 }, { 736,0,23 }, { 705,1,22 }, { 674,2,21 }, { 643,3,20 }, { 737,1,23 }, { 706,2,22 }, { 675,3,21 }, { 738,2,23 }, { 707,3,22 }, { 739,3,23 }, { 516,4,16 }, { 548,4,17 },
  { 517,5,16 }, { 580,4,18 }, { 549,5,17 }, { 518,6,16 }, { 612,4,19 }, { 581,5,18 }, { 550,6,17 }, { 519,7,16 }, { 613,5,19 }, { 582,6,18 }, { 551,7,17 }, { 614,6,19 }, { 583,7,18 }, { 615,7,19 }, { 392,8,12 }, { 424,8,13 }, { 393,9,12 }, { 456,8,14 }, { 425,9,13 }, { 394,10,12 },
  { 488,8,15 }, { 457,9,14 }, { 426,10,13 }, { 395,11,12 }, { 489,9,15 }, { 458,10,14 }, { 427,11,13 }, { 490,10,15 }, { 459,11,14 }, { 491,11,15 }, { 268,12,8 }, { 300,12,9 }, { 269,13,8 }, { 332,12,10 }, { 301,13,9 }, { 270,14,8 }, { 364,12,11 }, { 333,13,10 }, { 302,14,9 }, { 271,15,8 },
  { 365,13,11 }, { 334,14,10 }, { 303,15,9 }, { 366,14,11 }, { 335,15,10 }, { 367,15,11 }, { 144,16,4 }, { 176,16,5 }, { 145,17,4 }, { 208,16,6 }, { 177,17,5 }, { 146,18,4 }, { 240,16,7 }, { 209,17,6 }, { 178,18,5 }, { 147,19,4 }, { 241,17,7 }, { 210,18,6 }, { 179,19,5 }, { 242,18,7 },
  { 211,19,6 }, { 243,19,7 }, { 20,20,0 }, { 52,20,1 }, { 21,21,0 }, { 84,20,2 }, { 53,21,1 }, { 22,22,0 }, { 116,20,3 }, { 85,21,2 }, { 54,22,1 }, { 23,23,0 }, { 117,21,3 }, { 86,22,2 }, { 55,23,1 }, { 118,22,3 }, { 87,23,2 }, { 119,23,3 }, { 768,0,24 }, { 800,0,25 },
  { 769,1,24 }, { 832,0,26 }, { 801,1,25 }, { 770,2,24 }, { 864,0,27 }, { 833,1,26 }, { 802,2,25 }, { 771,3,24 }, { 865,1,27 }, { 834,2,26 }, { 803,3,25 }, { 866,2,27 }, { 835,3,26 }, { 867,3,27 }, { 644,4,20 }, { 676,4,21 }, { 645,5,20 }, { 708,4,22 }, { 677,5,21 }, { 646,6,20 },
  { 740,4,23 }, { 709,5,22 }, { 678,6,21 }, { 647,7,20 }, { 741,5,23 }, { 710,6,22 }, { 679,7,21 }, { 742,6,23 }, { 711,7,22 }, { 743,7,23 }, { 520,8,16 }, { 552,8,17 }, { 521,9,16 }, { 584,8,18 }, { 553,9,17 }, { 522,10,16 }, { 616,8,19 }, { 585,9,18 }, { 554,10,17 }, { 523,11,16 },
  { 617,9,19 }, { 586,10,18 }, { 555,11,17 }, { 618,10,19 }, { 587,11,18 }, { 619,11,19 }, { 396,12,12 }, { 428,12,13 }, { 397,13,12 }, { 460,12,14 }, { 429,13,13 }, { 398,14,12 }, { 492,12,15 }, { 461,13,14 }, { 430,14,13 }, { 399,15,12 }, { 493,13,15 }, { 462,14,14 }, { 431,15,13 }, { 494,14,15 },
  { 463,15,14 }, { 495,15,15 }, { 272,16,8 }, { 304,16,9 }, { 273,17,8 }, { 336,16,10 }, { 305,17,9 }, { 274,18,8 }, { 368,16,11 }, { 337,17,10 }, { 306,18,9 }, { 275,19,8 }, { 369,17,11 }, { 338,18,10 }, { 307,19,9 }, { 370,18,11 }, { 339,19,10 }, { 371,19,11 }, { 148,20,4 }, { 180,20,5 },
  { 149,21,4 }, { 212,20,6 }, { 181,21,5 }, { 150,22,4 }, { 244,20,7 }, { 213,21,6 }, { 182,22,5 }, { 151,23,4 }, { 245,21,7 }, { 214,22,6 }, { 183,23,5 }, { 246,22,7 }, { 215,23,6 }, { 247,23,7 }, { 24,24,0 }, { 56,24,1 }, { 25,25,0 }, { 88,24,2 }, { 57,25,1 }, { 26,26,0 },
  { 120,24,3 }, { 89,25,2 }, { 58,26,1 }, { 27,27,0 }, { 121,25,3 }, { 90,26,2 }, { 59,27,1 }, { 122,26,3 }, { 91,27,2 }, { 123,27,3 }, { 896,0,28 }, { 928,0,29 }, { 897,1,28 }, { 960,0,30 }, { 929,1,29 }, { 898,2,28 }, { 992,0,31 }, { 961,1,30 }, { 930,2,29 }, { 899,3,28 },
  { 993,1,31 }, { 962,2,30 }, { 931,3,29 }, { 994,2,31 }, { 963,3,30 }, { 995,3,31 }, { 772,4,24 }, { 804,4,25 }, { 773,5,24 }, { 836,4,26 }, { 805,5,25 }, { 774,6,24 }, { 868,4,27 }, { 837,5,26 }, { 806,6,25 }, { 775,7,24 }, { 869,5,27 }, { 838,6,26 }, { 807,7,25 }, { 870,6,27 },
  { 839,7,26 }, { 871,7,27 }, { 648,8,20 }, { 680,8,21 }, { 649,9,20 }, { 712,8,22 }, { 681,9,21 }, { 650,10,20 }, { 744,8,23 }, { 713,9,22 }, { 682,10,21 }, { 651,11,20 }, { 745,9,23 }, { 714,10,22 }, { 683,11,21 }, { 746,10,23 }, { 715,11,22 }, { 747,11,23 }, { 524,12,16 }, { 556,12,17 },
  { 525,13,16 }, { 588,12,18 }, { 557,13,17 }, { 526,14,16 }, { 620,12,19 }, { 589,13,18 }, { 558,14,17 }, { 527,15,16 }, { 621,13,19 }, { 590,14,18 }, { 559,15,17 }, { 622,14,19 }, { 591,15,18 }, { 623,15,19 }, { 400,16,12 }, { 432,16,13 }, { 401,17,12 }, { 464,16,14 }, { 433,17,13 }, { 402,18,12 },
  { 496,16,15 }, { 465,17,14 }, { 434,18,13 }, { 403,19,12 }, { 497,17,15 }, { 466,18,14 }, { 435,19,13 }, { 498,18,15 }, { 467,19,14 }, { 499,19,15 }, { 276,20,8 }, { 308,20,9 }, { 277,21,8 }, { 340,20,10 }, { 309,21,9 }, { 278,22,8 }, { 372,20,11 }, { 341,21,10 }, { 310,22,9 }, { 279,23,8 },
  { 373,21,11 }, { 342,22,10 }, { 311,23,9 }, { 374,22,11 }, { 343,23,10 }, { 375,23,11 }, { 152,24,4 }, { 184,24,5 }, { 153,25,4 }, { 216,24,6 }, { 185,25,5 }, { 154,26,4 }, { 248,24,7 }, { 217,25,6 }, { 186,26,5 }, { 155,27,4 }, { 249,25,7 }, { 218,26,6 }, { 187,27,5 }, { 250,26,7 },
  { 219,27,6 }, { 251,27,7 }, { 28,28,0 }, { 60,28,1 }, { 29,29,0 }, { 92,28,2 }, { 61,29,1 }, { 30,30,0 }, { 124,28,3 }, { 93,29,2 }, { 62,30,1 }, { 31,31,0 }, { 125,29,3 }, { 94,30,2 }, { 63,31,1 }, { 126,30,3 }, { 95,31,2 }, { 127,31,3 }, { 900,4,28 }, { 932,4,29 },
  { 901,5,28 }, { 964,4,30 }, { 933,5,29 }, { 902,6,28 }, { 996,4,31 }, { 965,5,30 }, { 934,6,29 }, { 903,7,28 }, { 997,5,31 }, { 966,6,30 }, { 935,7,29 }, { 998,6,31 }, { 967,7,30 }, { 999,7,31 }, { 776,8,24 }, { 808,8,25 }, { 777,9,24 }, { 840,8,26 }, { 809,9,25 }, { 778,10,24 },
  { 872,8,27 }, { 841,9,26 }, { 810,10,25 }, { 779,11,24 }, { 873,9,27 }, { 842,10,26 }, { 811,11,25 }, { 874,10,27 }, { 843,11,26 }, { 875,11,27 }, { 652,12,20 }, { 684,12,21 }, { 653,13,20 }, { 716,12,22 }, { 685,13,21 }, { 654,14,20 }, { 748,12,23 }, { 717,13,22 }, { 686,14,21 }, { 655,15,20 },
  { 749,13,23 }, { 718,14,22 }, { 687,15,21 }, { 750,14,23 }, { 719,15,22 }, { 751,15,23 }, { 528,16,16 }, { 560,16,17 }, { 529,17,16 }, { 592,16,18 }, { 561,17,17 }, { 530,18,16 }, { 624,16,19 }, { 593,17,18 }, { 562,18,17 }, { 531,19,16 }, { 625,17,19 }, { 594,18,18 }, { 563,19,17 }, { 626,18,19 },
  { 595,19,18 }, { 627,19,19 }, { 404,20,12 }, { 436,20,13 }, { 405,21,12 }, { 468,20,14 }, { 437,21,13 }, { 406,22,12 }, { 500,20,15 }, { 469,21,14 }, { 438,22,13 }, { 407,23,12 }, { 501,21,15 }, { 470,22,14 }, { 439,23,13 }, { 502,22,15 }, { 471,23,14 }, { 503,23,15 }, { 280,24,8 }, { 312,24,9 },
  { 281,25,8 }, { 344,24,10 }, { 313,25,9 }, { 282,26,8 }, { 376,24,11 }, { 345,25,10 }, { 314,26,9 }, { 283,27,8 }, { 377,25,11 }, { 346,26,10 }, { 315,27,9 }, { 378,26,11 }, { 347,27,10 }, { 379,27,11 }, { 156,28,4 }, { 188,28,5 }, { 157,29,4 }, { 220,28,6 }, { 189,29,5 }, { 158,30,4 },
  { 252,28,7 }, { 221,29,6 }, { 190,30,5 }, { 159,31,4 }, { 253,29,7 }, { 222,30,6 }, { 191,31,5 }, { 254,30,7 }, { 223,31,6 }, { 255,31,7 }, { 904,8,28 }, { 936,8,29 }, { 905,9,28 }, { 968,8,30 }, { 937,9,29 }, { 906,10,28 }, { 1000,8,31 }, { 969,9,30 }, { 938,10,29 }, { 907,11,28 },
  { 1001,9,31 }, { 970,10,30 }, { 939,11,29 }, { 1002,10,31 }, { 971,11,30 }, { 1003,11,31 }, { 780,12,24 }, { 812,12,25 }, { 781,13,24 }, { 844,12,26 }, { 813,13,25 }, { 782,14,24 }, { 876,12,27 }, { 845,13,26 }, { 814,14,25 }, { 783,15,24 }, { 877,13,27 }, { 846,14,26 }, { 815,15,25 }, { 878,14,27 },
  { 847,15,26 }, { 879,15,27 }, { 656,16,20 }, { 688,16,21 }, { 657,17,20 }, { 720,16,22 }, { 689,17,21 }, { 658,18,20 }, { 752,16,23 }, { 721,17,22 }, { 690,18,21 }, { 659,19,20 }, { 753,17,23 }, { 722,18,22 }, { 691,19,21 }, { 754,18,23 }, { 723,19,22 }, { 755,19,23 }, { 532,20,16 }, { 564,20,17 },
  { 533,21,16 }, { 596,20,18 }, { 565,21,17 }, { 534,22,16 }, { 628,20,19 }, { 597,21,18 }, { 566,22,17 }, { 535,23,16 }, { 629,21,19 }, { 598,22,18 }, { 567,23,17 }, { 630,22,19 }, { 599,23,18 }, { 631,23,19 }, { 408,24,12 }, { 440,24,13 }, { 409,25,12 }, { 472,24,14 }, { 441,25,13 }, { 410,26,12 },
  { 504,24,15 }, { 473,25,14 }, { 442,26,13 }, { 411,27,12 }, { 505,25,15 }, { 474,26,14 }, { 443,27,13 }, { 506,26,15 }, { 475,27,14 }, { 507,27,15 }, { 284,28,8 }, { 316,28,9 }, { 285,29,8 }, { 348,28,10 }, { 317,29,9 }, { 286,30,8 }, { 380,28,11 }, { 349,29,10 }, { 318,30,9 }, { 287,31,8 },
  { 381,29,11 }, { 350,30,10 }, { 319,31,9 }, { 382,30,11 }, { 351,31,10 }, { 383,31,11 }, { 908,12,28 }, { 940,12,29 }, { 909,13,28 }, { 972,12,30 }, { 941,13,29 }, { 910,14,28 }, { 1004,12,31 }, { 973,13,30 }, { 942,14,29 }, { 911,15,28 }, { 1005,13,31 }, { 974,14,30 }, { 943,15,29 }, { 1006,14,31 },
  { 975,15,30 }, { 1007,15,31 }, { 784,16,24 }, { 816,16,25 }, { 785,17,24 }, { 848,16,26 }, { 817,17,25 }, { 786,18,24 }, { 880,16,27 }, { 849,17,26 }, { 818,18,25 }, { 787,19,24 }, { 881,17,27 }, { 850,18,26 }, { 819,19,25 }, { 882,18,27 }, { 851,19,26 }, { 883,19,27 }, { 660,20,20 }, { 692,20,21 },
  { 661,21,20 }, { 724,20,22 }, { 693,21,21 }, { 662,22,20 }, { 756,20,23 }, { 725,21,22 }, { 694,22,21 }, { 663,23,20 }, { 757,21,23 }, { 726,22,22 }, { 695,23,21 }, { 758,22,23 }, { 727,23,22 }, { 759,23,23 }, { 536,24,16 }, { 568,24,17 }, { 537,25,16 }, { 600,24,18 }, { 569,25,17 }, { 538,26,16 },
  { 632,24,19 }, { 601,25,18 }, { 570,26,17 }, { 539,27,16 }, { 633,25,19 }, { 602,26,18 }, { 571,27,17 }, { 634,26,19 }, { 603,27,18 }, { 635,27,19 }, { 412,28,12 }, { 444,28,13 }, { 413,29,12 }, { 476,28,14 }, { 445,29,13 }, { 414,30,12 }, { 508,28,15 }, { 477,29,14 }, { 446,30,13 }, { 415,31,12 },
  { 509,29,15 }, { 478,30,14 }, { 447,31,13 }, { 510,30,15 }, { 479,31,14 }, { 511,31,15 }, { 912,16,28 }, { 944,16,29 }, { 913,17,28 }, { 976,16,30 }, { 945,17,29 }, { 914,18,28 }, { 1008,16,31 }, { 977,17,30 }, { 946,18,29 }, { 915,19,28 }, { 1009,17,31 }, { 978,18,30 }, { 947,19,29 }, { 1010,18,31 },
  { 979,19,30 }, { 1011,19,31 }, { 788,20,24 }, { 820,20,25 }, { 789,21,24 }, { 852,20,26 }, { 821,21,25 }, { 790,22,24 }, { 884,20,27 }, { 853,21,26 }, { 822,22,25 }, { 791,23,24 }, { 885,21,27 }, { 854,22,26 }, { 823,23,25 }, { 886,22,27 }, { 855,23,26 }, { 887,23,27 }, { 664,24,20 }, { 696,24,21 },
  { 665,25,20 }, { 728,24,22 }, { 697,25,21 }, { 666,26,20 }, { 760,24,23 }, { 729,25,22 }, { 698,26,21 }, { 667,27,20 }, { 761,25,23 }, { 730,26,22 }, { 699,27,21 }, { 762,26,23 }, { 731,27,22 }, { 763,27,23 }, { 540,28,16 }, { 572,28,17 }, { 541,29,16 }, { 604,28,18 }, { 573,29,17 }, { 542,30,16 },
  { 636,28,19 }, { 605,29,18 }, { 574,30,17 }, { 543,31,16 }, { 637,29,19 }, { 606,30,18 }, { 575,31,17 }, { 638,30,19 }, { 607,31,18 }, { 639,31,19 }, { 916,20,28 }, { 948,20,29 }, { 917,21,28 }, { 980,20,30 }, { 949,21,29 }, { 918,22,28 }, { 1012,20,31 }, { 981,21,30 }, { 950,22,29 }, { 919,23,28 },
  { 1013,21,31 }, { 982,22,30 }, { 951,23,29 }, { 1014,22,31 }, { 983,23,30 }, { 1015,23,31 }, { 792,24,24 }, { 824,24,25 }, { 793,25,24 }, { 856,24,26 }, { 825,25,25 }, { 794,26,24 }, { 888,24,27 }, { 857,25,26 }, { 826,26,25 }, { 795,27,24 }, { 889,25,27 }, { 858,26,26 }, { 827,27,25 }, { 890,26,27 },
  { 859,27,26 }, { 891,27,27 }, { 668,28,20 }, { 700,28,21 }, { 669,29,20 }, { 732,28,22 }, { 701,29,21 }, { 670,30,20 }, { 764,28,23 }, { 733,29,22 }, { 702,30,21 }, { 671,31,20 }, { 765,29,23 }, { 734,30,22 }, { 703,31,21 }, { 766,30,23 }, { 735,31,22 }, { 767,31,23 }, { 920,24,28 }, { 952,24,29 },
  { 921,25,28 }, { 984,24,30 }, { 953,25,29 }, { 922,26,28 }, { 1016,24,31 }, { 985,25,30 }, { 954,26,29 }, { 923,27,28 }, { 1017,25,31 }, { 986,26,30 }, { 955,27,29 }, { 1018,26,31 }, { 987,27,30 }, { 1019,27,31 }, { 796,28,24 }, { 828,28,25 }, { 797,29,24 }, { 860,28,26 }, { 829,29,25 }, { 798,30,24 },
  { 892,28,27 }, { 861,29,26 }, { 830,30,25 }, { 799,31,24 }, { 893,29,27 }, { 862,30,26 }, { 831,31,25 }, { 894,30,27 }, { 863,31,26 }, { 895,31,27 }, { 924,28,28 }, { 956,28,29 }, { 925,29,28 }, { 988,28,30 }, { 957,29,29 }, { 926,30,28 }, { 1020,28,31 }, { 989,29,30 }, { 958,30,29 }, { 927,31,28 },
  { 1021,29,31 }, { 990,30,30 }, { 959,31,29 }, { 1022,30,31 }, { 991,31,30 }, { 1023,31,31 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 },
  { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 2047,31,63 }, { 0,0,0 }, { 1,1,0 }, { 2,2,0 }, { 3,3,0 }, { 4,4,0 }, { 5,5,0 }, { 6,6,0 }, { 7,7,0 }, { 8,8,0 }, { 9,9,0 },
  { 10,10,0 }, { 11,11,0 }, { 12,12,0 }, { 13,13,0 }, { 14,14,0 }, { 15,15,0 }, { 16,16,0 }, { 17,17,0 }, { 18,18,0 }, { 19,19,0 }, { 20,20,0 }, { 21,21,0 }, { 22,22,0 }, { 23,23,0 }, { 24,24,0 }, { 25,25,0 }, { 26,26,0 }, { 27,27,0 }, { 28,28,0 }, { 29,29,0 },
  { 30,30,0 }, { 31,31,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 },
  { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 63,63,0 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 65,1,1 }, { 2,2,0 }, { 66,2,1 },
  { 3,3,0 }, { 67,3,1 }, { 4,4,0 }, { 68,4,1 }, { 5,5,0 }, { 69,5,1 }, { 6,6,0 }, { 70,6,1 }, { 7,7,0 }, { 71,7,1 }, { 8,8,0 }, { 72,8,1 }, { 9,9,0 }, { 73,9,1 }, { 10,10,0 }, { 74,10,1 }, { 11,11,0 }, { 75,11,1 }, { 12,12,0 }, { 76,12,1 },
  { 13,13,0 }, { 77,13,1 }, { 14,14,0 }, { 78,14,1 }, { 15,15,0 }, { 79,15,1 }, { 16,16,0 }, { 80,16,1 }, { 17,17,0 }, { 81,17,1 }, { 18,18,0 }, { 82,18,1 }, { 19,19,0 }, { 83,19,1 }, { 20,20,0 }, { 84,20,1 }, { 21,21,0 }, { 85,21,1 }, { 22,22,0 }, { 86,22,1 },
  { 23,23,0 }, { 87,23,1 }, { 24,24,0 }, { 88,24,1 }, { 25,25,0 }, { 89,25,1 }, { 26,26,0 }, { 90,26,1 }, { 27,27,0 }, { 91,27,1 }, { 28,28,0 }, { 92,28,1 }, { 29,29,0 }, { 93,29,1 }, { 30,30,0 }, { 94,30,1 }, { 31,31,0 }, { 95,31,1 }, { 127,63,1 }, { 127,63,1 },
  { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 },
  { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 },
  { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 }, { 127,63,1 },
  { 127,63,1 }, { 127,63,1 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 128,0,2 }, { 65,1,1 }, { 2,2,0 }, { 192,0,3 }, { 129,1,2 }, { 66,2,1 }, { 3,3,0 }, { 193,1,3 }, { 130,2,2 }, { 67,3,1 }, { 194,2,3 }, { 131,3,2 }, { 195,3,3 }, { 4,4,0 }, { 68,4,1 },
  { 5,5,0 }, { 132,4,2 }, { 69,5,1 }, { 6,6,0 }, { 196,4,3 }, { 133,5,2 }, { 70,6,1 }, { 7,7,0 }, { 197,5,3 }, { 134,6,2 }, { 71,7,1 }, { 198,6,3 }, { 135,7,2 }, { 199,7,3 }, { 8,8,0 }, { 72,8,1 }, { 9,9,0 }, { 136,8,2 }, { 73,9,1 }, { 10,10,0 },
  { 200,8,3 }, { 137,9,2 }, { 74,10,1 }, { 11,11,0 }, { 201,9,3 }, { 138,10,2 }, { 75,11,1 }, { 202,10,3 }, { 139,11,2 }, { 203,11,3 }, { 12,12,0 }, { 76,12,1 }, { 13,13,0 }, { 140,12,2 }, { 77,13,1 }, { 14,14,0 }, { 204,12,3 }, { 141,13,2 }, { 78,14,1 }, { 15,15,0 },
  { 205,13,3 }, { 142,14,2 }, { 79,15,1 }, { 206,14,3 }, { 143,15,2 }, { 207,15,3 }, { 16,16,0 }, { 80,16,1 }, { 17,17,0 }, { 144,16,2 }, { 81,17,1 }, { 18,18,0 }, { 208,16,3 }, { 145,17,2 }, { 82,18,1 }, { 19,19,0 }, { 209,17,3 }, { 146,18,2 }, { 83,19,1 }, { 210,18,3 },
  { 147,19,2 }, { 211,19,3 }, { 20,20,0 }, { 84,20,1 }, { 21,21,0 }, { 148,20,2 }, { 85,21,1 }, { 22,22,0 }, { 212,20,3 }, { 149,21,2 }, { 86,22,1 }, { 23,23,0 }, { 213,21,3 }, { 150,22,2 }, { 87,23,1 }, { 214,22,3 }, { 151,23,2 }, { 215,23,3 }, { 24,24,0 }, { 88,24,1 },
  { 25,25,0 }, { 152,24,2 }, { 89,25,1 }, { 26,26,0 }, { 216,24,3 }, { 153,25,2 }, { 90,26,1 }, { 27,27,0 }, { 217,25,3 }, { 154,26,2 }, { 91,27,1 }, { 218,26,3 }, { 155,27,2 }, { 219,27,3 }, { 28,28,0 }, { 92,28,1 }, { 29,29,0 }, { 156,28,2 }, { 93,29,1 }, { 30,30,0 },
  { 220,28,3 }, { 157,29,2 }, { 94,30,1 }, { 31,31,0 }, { 221,29,3 }, { 158,30,2 }, { 95,31,1 }, { 222,30,3 }, { 159,31,2 }, { 223,31,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 },
  { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 },
  { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 },
  { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 },
  { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 },
  { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 },
  { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 255,63,3 }, { 0,0,0 }, { 64,0,1 },
  { 1,1,0 }, { 128,0,2 }, { 65,1,1 }, { 2,2,0 }, { 192,0,3 }, { 129,1,2 }, { 66,2,1 }, { 3,3,0 }, { 193,1,3 }, { 130,2,2 }, { 67,3,1 }, { 194,2,3 }, { 131,3,2 }, { 195,3,3 }, { 256,0,4 }, { 320,0,5 }, { 257,1,4 }, { 384,0,6 }, { 321,1,5 }, { 258,2,4 },
  { 448,0,7 }, { 385,1,6 }, { 322,2,5 }, { 259,3,4 }, { 449,1,7 }, { 386,2,6 }, { 323,3,5 }, { 450,2,7 }, { 387,3,6 }, { 451,3,7 }, { 4,4,0 }, { 68,4,1 }, { 5,5,0 }, { 132,4,2 }, { 69,5,1 }, { 6,6,0 }, { 196,4,3 }, { 133,5,2 }, { 70,6,1 }, { 7,7,0 },
  { 197,5,3 }, { 134,6,2 }, { 71,7,1 }, { 198,6,3 }, { 135,7,2 }, { 199,7,3 }, { 260,4,4 }, { 324,4,5 }, { 261,5,4 }, { 388,4,6 }, { 325,5,5 }, { 262,6,4 }, { 452,4,7 }, { 389,5,6 }, { 326,6,5 }, { 263,7,4 }, { 453,5,7 }, { 390,6,6 }, { 327,7,5 }, { 454,6,7 },
  { 391,7,6 }, { 455,7,7 }, { 8,8,0 }, { 72,8,1 }, { 9,9,0 }, { 136,8,2 }, { 73,9,1 }, { 10,10,0 }, { 200,8,3 }, { 137,9,2 }, { 74,10,1 }, { 11,11,0 }, { 201,9,3 }, { 138,10,2 }, { 75,11,1 }, { 202,10,3 }, { 139,11,2 }, { 203,11,3 }, { 264,8,4 }, { 328,8,5 },
  { 265,9,4 }, { 392,8,6 }, { 329,9,5 }, { 266,10,4 }, { 456,8,7 }, { 393,9,6 }, { 330,10,5 }, { 267,11,4 }, { 457,9,7 }, { 394,10,6 }, { 331,11,5 }, { 458,10,7 }, { 395,11,6 }, { 459,11,7 }, { 12,12,0 }, { 76,12,1 }, { 13,13,0 }, { 140,12,2 }, { 77,13,1 }, { 14,14,0 },
  { 204,12,3 }, { 141,13,2 }, { 78,14,1 }, { 15,15,0 }, { 205,13,3 }, { 142,14,2 }, { 79,15,1 }, { 206,14,3 }, { 143,15,2 }, { 207,15,3 }, { 268,12,4 }, { 332,12,5 }, { 269,13,4 }, { 396,12,6 }, { 333,13,5 }, { 270,14,4 }, { 460,12,7 }, { 397,13,6 }, { 334,14,5 }, { 271,15,4 },
  { 461,13,7 }, { 398,14,6 }, { 335,15,5 }, { 462,14,7 }, { 399,15,6 }, { 463,15,7 }, { 16,16,0 }, { 80,16,1 }, { 17,17,0 }, { 144,16,2 }, { 81,17,1 }, { 18,18,0 }, { 208,16,3 }, { 145,17,2 }, { 82,18,1 }, { 19,19,0 }, { 209,17,3 }, { 146,18,2 }, { 83,19,1 }, { 210,18,3 },
  { 147,19,2 }, { 211,19,3 }, { 272,16,4 }, { 336,16,5 }, { 273,17,4 }, { 400,16,6 }, { 337,17,5 }, { 274,18,4 }, { 464,16,7 }, { 401,17,6 }, { 338,18,5 }, { 275,19,4 }, { 465,17,7 }, { 402,18,6 }, { 339,19,5 }, { 466,18,7 }, { 403,19,6 }, { 467,19,7 }, { 20,20,0 }, { 84,20,1 },
  { 21,21,0 }, { 148,20,2 }, { 85,21,1 }, { 22,22,0 }, { 212,20,3 }, { 149,21,2 }, { 86,22,1 }, { 23,23,0 }, { 213,21,3 }, { 150,22,2 }, { 87,23,1 }, { 214,22,3 }, { 151,23,2 }, { 215,23,3 }, { 276,20,4 }, { 340,20,5 }, { 277,21,4 }, { 404,20,6 }, { 341,21,5 }, { 278,22,4 },
  { 468,20,7 }, { 405,21,6 }, { 342,22,5 }, { 279,23,4 }, { 469,21,7 }, { 406,22,6 }, { 343,23,5 }, { 470,22,7 }, { 407,23,6 }, { 471,23,7 }, { 24,24,0 }, { 88,24,1 }, { 25,25,0 }, { 152,24,2 }, { 89,25,1 }, { 26,26,0 }, { 216,24,3 }, { 153,25,2 }, { 90,26,1 }, { 27,27,0 },
  { 217,25,3 }, { 154,26,2 }, { 91,27,1 }, { 218,26,3 }, { 155,27,2 }, { 219,27,3 }, { 280,24,4 }, { 344,24,5 }, { 281,25,4 }, { 408,24,6 }, { 345,25,5 }, { 282,26,4 }, { 472,24,7 }, { 409,25,6 }, { 346,26,5 }, { 283,27,4 }, { 473,25,7 }, { 410,26,6 }, { 347,27,5 }, { 474,26,7 },
  { 411,27,6 }, { 475,27,7 }, { 28,28,0 }, { 92,28,1 }, { 29,29,0 }, { 156,28,2 }, { 93,29,1 }, { 30,30,0 }, { 220,28,3 }, { 157,29,2 }, { 94,30,1 }, { 31,31,0 }, { 221,29,3 }, { 158,30,2 }, { 95,31,1 }, { 222,30,3 }, { 159,31,2 }, { 223,31,3 }, { 284,28,4 }, { 348,28,5 },
  { 285,29,4 }, { 412,28,6 }, { 349,29,5 }, { 286,30,4 }, { 476,28,7 }, { 413,29,6 }, { 350,30,5 }, { 287,31,4 }, { 477,29,7 }, { 414,30,6 }, { 351,31,5 }, { 478,30,7 }, { 415,31,6 }, { 479,31,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 },
  { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 511,63,7 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 128,0,2 }, { 65,1,1 }, { 2,2,0 }, { 192,0,3 }, { 129,1,2 }, { 66,2,1 }, { 3,3,0 },
  { 193,1,3 }, { 130,2,2 }, { 67,3,1 }, { 194,2,3 }, { 131,3,2 }, { 195,3,3 }, { 256,0,4 }, { 320,0,5 }, { 257,1,4 }, { 384,0,6 }, { 321,1,5 }, { 258,2,4 }, { 448,0,7 }, { 385,1,6 }, { 322,2,5 }, { 259,3,4 }, { 449,1,7 }, { 386,2,6 }, { 323,3,5 }, { 450,2,7 },
  { 387,3,6 }, { 451,3,7 }, { 4,4,0 }, { 68,4,1 }, { 5,5,0 }, { 132,4,2 }, { 69,5,1 }, { 6,6,0 }, { 196,4,3 }, { 133,5,2 }, { 70,6,1 }, { 7,7,0 }, { 197,5,3 }, { 134,6,2 }, { 71,7,1 }, { 198,6,3 }, { 135,7,2 }, { 199,7,3 }, { 512,0,8 }, { 576,0,9 },
  { 513,1,8 }, { 640,0,10 }, { 577,1,9 }, { 514,2,8 }, { 704,0,11 }, { 641,1,10 }, { 578,2,9 }, { 515,3,8 }, { 705,1,11 }, { 642,2,10 }, { 579,3,9 }, { 706,2,11 }, { 643,3,10 }, { 707,3,11 }, { 260,4,4 }, { 324,4,5 }, { 261,5,4 }, { 388,4,6 }, { 325,5,5 }, { 262,6,4 },
  { 452,4,7 }, { 389,5,6 }, { 326,6,5 }, { 263,7,4 }, { 453,5,7 }, { 390,6,6 }, { 327,7,5 }, { 454,6,7 }, { 391,7,6 }, { 455,7,7 }, { 8,8,0 }, { 72,8,1 }, { 9,9,0 }, { 136,8,2 }, { 73,9,1 }, { 10,10,0 }, { 200,8,3 }, { 137,9,2 }, { 74,10,1 }, { 11,11,0 },
  { 201,9,3 }, { 138,10,2 }, { 75,11,1 }, { 202,10,3 }, { 139,11,2 }, { 203,11,3 }, { 768,0,12 }, { 832,0,13 }, { 769,1,12 }, { 896,0,14 }, { 833,1,13 }, { 770,2,12 }, { 960,0,15 }, { 897,1,14 }, { 834,2,13 }, { 771,3,12 }, { 961,1,15 }, { 898,2,14 }, { 835,3,13 }, { 962,2,15 },
  { 899,3,14 }, { 963,3,15 }, { 516,4,8 }, { 580,4,9 }, { 517,5,8 }, { 644,4,10 }, { 581,5,9 }, { 518,6,8 }, { 708,4,11 }, { 645,5,10 }, { 582,6,9 }, { 519,7,8 }, { 709,5,11 }, { 646,6,10 }, { 583,7,9 }, { 710,6,11 }, { 647,7,10 }, { 711,7,11 }, { 264,8,4 }, { 328,8,5 },
  { 265,9,4 }, { 392,8,6 }, { 329,9,5 }, { 266,10,4 }, { 456,8,7 }, { 393,9,6 }, { 330,10,5 }, { 267,11,4 }, { 457,9,7 }, { 394,10,6 }, { 331,11,5 }, { 458,10,7 }, { 395,11,6 }, { 459,11,7 }, { 12,12,0 }, { 76,12,1 }, { 13,13,0 }, { 140,12,2 }, { 77,13,1 }, { 14,14,0 },
  { 204,12,3 }, { 141,13,2 }, { 78,14,1 }, { 15,15,0 }, { 205,13,3 }, { 142,14,2 }, { 79,15,1 }, { 206,14,3 }, { 143,15,2 }, { 207,15,3 }, { 772,4,12 }, { 836,4,13 }, { 773,5,12 }, { 900,4,14 }, { 837,5,13 }, { 774,6,12 }, { 964,4,15 }, { 901,5,14 }, { 838,6,13 }, { 775,7,12 },
  { 965,5,15 }, { 902,6,14 }, { 839,7,13 }, { 966,6,15 }, { 903,7,14 }, { 967,7,15 }, { 520,8,8 }, { 584,8,9 }, { 521,9,8 }, { 648,8,10 }, { 585,9,9 }, { 522,10,8 }, { 712,8,11 }, { 649,9,10 }, { 586,10,9 }, { 523,11,8 }, { 713,9,11 }, { 650,10,10 }, { 587,11,9 }, { 714,10,11 },
  { 651,11,10 }, { 715,11,11 }, { 268,12,4 }, { 332,12,5 }, { 269,13,4 }, { 396,12,6 }, { 333,13,5 }, { 270,14,4 }, { 460,12,7 }, { 397,13,6 }, { 334,14,5 }, { 271,15,4 }, { 461,13,7 }, { 398,14,6 }, { 335,15,5 }, { 462,14,7 }, { 399,15,6 }, { 463,15,7 }, { 16,16,0 }, { 80,16,1 },
  { 17,17,0 }, { 144,16,2 }, { 81,17,1 }, { 18,18,0 }, { 208,16,3 }, { 145,17,2 }, { 82,18,1 }, { 19,19,0 }, { 209,17,3 }, { 146,18,2 }, { 83,19,1 }, { 210,18,3 }, { 147,19,2 }, { 211,19,3 }, { 776,8,12 }, { 840,8,13 }, { 777,9,12 }, { 904,8,14 }, { 841,9,13 }, { 778,10,12 },
  { 968,8,15 }, { 905,9,14 }, { 842,10,13 }, { 779,11,12 }, { 969,9,15 }, { 906,10,14 }, { 843,11,13 }, { 970,10,15 }, { 907,11,14 }, { 971,11,15 }, { 524,12,8 }, { 588,12,9 }, { 525,13,8 }, { 652,12,10 }, { 589,13,9 }, { 526,14,8 }, { 716,12,11 }, { 653,13,10 }, { 590,14,9 }, { 527,15,8 },
  { 717,13,11 }, { 654,14,10 }, { 591,15,9 }, { 718,14,11 }, { 655,15,10 }, { 719,15,11 }, { 272,16,4 }, { 336,16,5 }, { 273,17,4 }, { 400,16,6 }, { 337,17,5 }, { 274,18,4 }, { 464,16,7 }, { 401,17,6 }, { 338,18,5 }, { 275,19,4 }, { 465,17,7 }, { 402,18,6 }, { 339,19,5 }, { 466,18,7 },
  { 403,19,6 }, { 467,19,7 }, { 20,20,0 }, { 84,20,1 }, { 21,21,0 }, { 148,20,2 }, { 85,21,1 }, { 22,22,0 }, { 212,20,3 }, { 149,21,2 }, { 86,22,1 }, { 23,23,0 }, { 213,21,3 }, { 150,22,2 }, { 87,23,1 }, { 214,22,3 }, { 151,23,2 }, { 215,23,3 }, { 780,12,12 }, { 844,12,13 },
  { 781,13,12 }, { 908,12,14 }, { 845,13,13 }, { 782,14,12 }, { 972,12,15 }, { 909,13,14 }, { 846,14,13 }, { 783,15,12 }, { 973,13,15 }, { 910,14,14 }, { 847,15,13 }, { 974,14,15 }, { 911,15,14 }, { 975,15,15 }, { 528,16,8 }, { 592,16,9 }, { 529,17,8 }, { 656,16,10 }, { 593,17,9 }, { 530,18,8 },
  { 720,16,11 }, { 657,17,10 }, { 594,18,9 }, { 531,19,8 }, { 721,17,11 }, { 658,18,10 }, { 595,19,9 }, { 722,18,11 }, { 659,19,10 }, { 723,19,11 }, { 276,20,4 }, { 340,20,5 }, { 277,21,4 }, { 404,20,6 }, { 341,21,5 }, { 278,22,4 }, { 468,20,7 }, { 405,21,6 }, { 342,22,5 }, { 279,23,4 },
  { 469,21,7 }, { 406,22,6 }, { 343,23,5 }, { 470,22,7 }, { 407,23,6 }, { 471,23,7 }, { 24,24,0 }, { 88,24,1 }, { 25,25,0 }, { 152,24,2 }, { 89,25,1 }, { 26,26,0 }, { 216,24,3 }, { 153,25,2 }, { 90,26,1 }, { 27,27,0 }, { 217,25,3 }, { 154,26,2 }, { 91,27,1 }, { 218,26,3 },
  { 155,27,2 }, { 219,27,3 }, { 784,16,12 }, { 848,16,13 }, { 785,17,12 }, { 912,16,14 }, { 849,17,13 }, { 786,18,12 }, { 976,16,15 }, { 913,17,14 }, { 850,18,13 }, { 787,19,12 }, { 977,17,15 }, { 914,18,14 }, { 851,19,13 }, { 978,18,15 }, { 915,19,14 }, { 979,19,15 }, { 532,20,8 }, { 596,20,9 },
  { 533,21,8 }, { 660,20,10 }, { 597,21,9 }, { 534,22,8 }, { 724,20,11 }, { 661,21,10 }, { 598,22,9 }, { 535,23,8 }, { 725,21,11 }, { 662,22,10 }, { 599,23,9 }, { 726,22,11 }, { 663,23,10 }, { 727,23,11 }, { 280,24,4 }, { 344,24,5 }, { 281,25,4 }, { 408,24,6 }, { 345,25,5 }, { 282,26,4 },
  { 472,24,7 }, { 409,25,6 }, { 346,26,5 }, { 283,27,4 }, { 473,25,7 }, { 410,26,6 }, { 347,27,5 }, { 474,26,7 }, { 411,27,6 }, { 475,27,7 }, { 28,28,0 }, { 92,28,1 }, { 29,29,0 }, { 156,28,2 }, { 93,29,1 }, { 30,30,0 }, { 220,28,3 }, { 157,29,2 }, { 94,30,1 }, { 31,31,0 },
  { 221,29,3 }, { 158,30,2 }, { 95,31,1 }, { 222,30,3 }, { 159,31,2 }, { 223,31,3 }, { 788,20,12 }, { 852,20,13 }, { 789,21,12 }, { 916,20,14 }, { 853,21,13 }, { 790,22,12 }, { 980,20,15 }, { 917,21,14 }, { 854,22,13 }, { 791,23,12 }, { 981,21,15 }, { 918,22,14 }, { 855,23,13 }, { 982,22,15 },
  { 919,23,14 }, { 983,23,15 }, { 536,24,8 }, { 600,24,9 }, { 537,25,8 }, { 664,24,10 }, { 601,25,9 }, { 538,26,8 }, { 728,24,11 }, { 665,25,10 }, { 602,26,9 }, { 539,27,8 }, { 729,25,11 }, { 666,26,10 }, { 603,27,9 }, { 730,26,11 }, { 667,27,10 }, { 731,27,11 }, { 284,28,4 }, { 348,28,5 },
  { 285,29,4 }, { 412,28,6 }, { 349,29,5 }, { 286,30,4 }, { 476,28,7 }, { 413,29,6 }, { 350,30,5 }, { 287,31,4 }, { 477,29,7 }, { 414,30,6 }, { 351,31,5 }, { 478,30,7 }, { 415,31,6 }, { 479,31,7 }, { 792,24,12 }, { 856,24,13 }, { 793,25,12 }, { 920,24,14 }, { 857,25,13 }, { 794,26,12 },
  { 984,24,15 }, { 921,25,14 }, { 858,26,13 }, { 795,27,12 }, { 985,25,15 }, { 922,26,14 }, { 859,27,13 }, { 986,26,15 }, { 923,27,14 }, { 987,27,15 }, { 540,28,8 }, { 604,28,9 }, { 541,29,8 }, { 668,28,10 }, { 605,29,9 }, { 542,30,8 }, { 732,28,11 }, { 669,29,10 }, { 606,30,9 }, { 543,31,8 },
  { 733,29,11 }, { 670,30,10 }, { 607,31,9 }, { 734,30,11 }, { 671,31,10 }, { 735,31,11 }, { 796,28,12 }, { 860,28,13 }, { 797,29,12 }, { 924,28,14 }, { 861,29,13 }, { 798,30,12 }, { 988,28,15 }, { 925,29,14 }, { 862,30,13 }, { 799,31,12 }, { 989,29,15 }, { 926,30,14 }, { 863,31,13 }, { 990,30,15 },
  { 927,31,14 }, { 991,31,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 },
  { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 1023,63,15 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 128,0,2 }, { 65,1,1 }, { 2,2,0 },
  { 192,0,3 }, { 129,1,2 }, { 66,2,1 }, { 3,3,0 }, { 193,1,3 }, { 130,2,2 }, { 67,3,1 }, { 194,2,3 }, { 131,3,2 }, { 195,3,3 }, { 256,0,4 }, { 320,0,5 }, { 257,1,4 }, { 384,0,6 }, { 321,1,5 }, { 258,2,4 }, { 448,0,7 }, { 385,1,6 }, { 322,2,5 }, { 259,3,4 },
  { 449,1,7 }, { 386,2,6 }, { 323,3,5 }, { 450,2,7 }, { 387,3,6 }, { 451,3,7 }, { 4,4,0 }, { 68,4,1 }, { 5,5,0 }, { 132,4,2 }, { 69,5,1 }, { 6,6,0 }, { 196,4,3 }, { 133,5,2 }, { 70,6,1 }, { 7,7,0 }, { 197,5,3 }, { 134,6,2 }, { 71,7,1 }, { 198,6,3 },
  { 135,7,2 }, { 199,7,3 }, { 512,0,8 }, { 576,0,9 }, { 513,1,8 }, { 640,0,10 }, { 577,1,9 }, { 514,2,8 }, { 704,0,11 }, { 641,1,10 }, { 578,2,9 }, { 515,3,8 }, { 705,1,11 }, { 642,2,10 }, { 579,3,9 }, { 706,2,11 }, { 643,3,10 }, { 707,3,11 }, { 260,4,4 }, { 324,4,5 },
  { 261,5,4 }, { 388,4,6 }, { 325,5,5 }, { 262,6,4 }, { 452,4,7 }, { 389,5,6 }, { 326,6,5 }, { 263,7,4 }, { 453,5,7 }, { 390,6,6 }, { 327,7,5 }, { 454,6,7 }, { 391,7,6 }, { 455,7,7 }, { 8,8,0 }, { 72,8,1 }, { 9,9,0 }, { 136,8,2 }, { 73,9,1 }, { 10,10,0 },
  { 200,8,3 }, { 137,9,2 }, { 74,10,1 }, { 11,11,0 }, { 201,9,3 }, { 138,10,2 }, { 75,11,1 }, { 202,10,3 }, { 139,11,2 }, { 203,11,3 }, { 768,0,12 }, { 832,0,13 }, { 769,1,12 }, { 896,0,14 }, { 833,1,13 }, { 770,2,12 }, { 960,0,15 }, { 897,1,14 }, { 834,2,13 }, { 771,3,12 },
  { 961,1,15 }, { 898,2,14 }, { 835,3,13 }, { 962,2,15 }, { 899,3,14 }, { 963,3,15 }, { 516,4,8 }, { 580,4,9 }, { 517,5,8 }, { 644,4,10 }, { 581,5,9 }, { 518,6,8 }, { 708,4,11 }, { 645,5,10 }, { 582,6,9 }, { 519,7,8 }, { 709,5,11 }, { 646,6,10 }, { 583,7,9 }, { 710,6,11 },
  { 647,7,10 }, { 711,7,11 }, { 264,8,4 }, { 328,8,5 }, { 265,9,4 }, { 392,8,6 }, { 329,9,5 }, { 266,10,4 }, { 456,8,7 }, { 393,9,6 }, { 330,10,5 }, { 267,11,4 }, { 457,9,7 }, { 394,10,6 }, { 331,11,5 }, { 458,10,7 }, { 395,11,6 }, { 459,11,7 }, { 12,12,0 }, { 76,12,1 },
  { 13,13,0 }, { 140,12,2 }, { 77,13,1 }, { 14,14,0 }, { 204,12,3 }, { 141,13,2 }, { 78,14,1 }, { 15,15,0 }, { 205,13,3 }, { 142,14,2 }, { 79,15,1 }, { 206,14,3 }, { 143,15,2 }, { 207,15,3 }, { 1024,0,16 }, { 1088,0,17 }, { 1025,1,16 }, { 1152,0,18 }, { 1089,1,17 }, { 1026,2,16 },
  { 1216,0,19 }, { 1153,1,18 }, { 1090,2,17 }, { 1027,3,16 }, { 1217,1,19 }, { 1154,2,18 }, { 1091,3,17 }, { 1218,2,19 }, { 1155,3,18 }, { 1219,3,19 }, { 772,4,12 }, { 836,4,13 }, { 773,5,12 }, { 900,4,14 }, { 837,5,13 }, { 774,6,12 }, { 964,4,15 }, { 901,5,14 }, { 838,6,13 }, { 775,7,12 },
  { 965,5,15 }, { 902,6,14 }, { 839,7,13 }, { 966,6,15 }, { 903,7,14 }, { 967,7,15 }, { 520,8,8 }, { 584,8,9 }, { 521,9,8 }, { 648,8,10 }, { 585,9,9 }, { 522,10,8 }, { 712,8,11 }, { 649,9,10 }, { 586,10,9 }, { 523,11,8 }, { 713,9,11 }, { 650,10,10 }, { 587,11,9 }, { 714,10,11 },
  { 651,11,10 }, { 715,11,11 }, { 268,12,4 }, { 332,12,5 }, { 269,13,4 }, { 396,12,6 }, { 333,13,5 }, { 270,14,4 }, { 460,12,7 }, { 397,13,6 }, { 334,14,5 }, { 271,15,4 }, { 461,13,7 }, { 398,14,6 }, { 335,15,5 }, { 462,14,7 }, { 399,15,6 }, { 463,15,7 }, { 16,16,0 }, { 80,16,1 },
  { 17,17,0 }, { 144,16,2 }, { 81,17,1 }, { 18,18,0 }, { 208,16,3 }, { 145,17,2 }, { 82,18,1 }, { 19,19,0 }, { 209,17,3 }, { 146,18,2 }, { 83,19,1 }, { 210,18,3 }, { 147,19,2 }, { 211,19,3 }, { 1280,0,20 }, { 1344,0,21 }, { 1281,1,20 }, { 1408,0,22 }, { 1345,1,21 }, { 1282,2,20 },
  { 1472,0,23 }, { 1409,1,22 }, { 1346,2,21 }, { 1283,3,20 }, { 1473,1,23 }, { 1410,2,22 }, { 1347,3,21 }, { 1474,2,23 }, { 1411,3,22 }, { 1475,3,23 }, { 1028,4,16 }, { 1092,4,17 }, { 1029,5,16 }, { 1156,4,18 }, { 1093,5,17 }, { 1030,6,16 }, { 1220,4,19 }, { 1157,5,18 }, { 1094,6,17 }, { 1031,7,16 },
  { 1221,5,19 }, { 1158,6,18 }, { 1095,7,17 }, { 1222,6,19 }, { 1159,7,18 }, { 1223,7,19 }, { 776,8,12 }, { 840,8,13 }, { 777,9,12 }, { 904,8,14 }, { 841,9,13 }, { 778,10,12 }, { 968,8,15 }, { 905,9,14 }, { 842,10,13 }, { 779,11,12 }, { 969,9,15 }, { 906,10,14 }, { 843,11,13 }, { 970,10,15 },
  { 907,11,14 }, { 971,11,15 }, { 524,12,8 }, { 588,12,9 }, { 525,13,8 }, { 652,12,10 }, { 589,13,9 }, { 526,14,8 }, { 716,12,11 }, { 653,13,10 }, { 590,14,9 }, { 527,15,8 }, { 717,13,11 }, { 654,14,10 }, { 591,15,9 }, { 718,14,11 }, { 655,15,10 }, { 719,15,11 }, { 272,16,4 }, { 336,16,5 },
  { 273,17,4 }, { 400,16,6 }, { 337,17,5 }, { 274,18,4 }, { 464,16,7 }, { 401,17,6 }, { 338,18,5 }, { 275,19,4 }, { 465,17,7 }, { 402,18,6 }, { 339,19,5 }, { 466,18,7 }, { 403,19,6 }, { 467,19,7 }, { 20,20,0 }, { 84,20,1 }, { 21,21,0 }, { 148,20,2 }, { 85,21,1 }, { 22,22,0 },
  { 212,20,3 }, { 149,21,2 }, { 86,22,1 }, { 23,23,0 }, { 213,21,3 }, { 150,22,2 }, { 87,23,1 }, { 214,22,3 }, { 151,23,2 }, { 215,23,3 }, { 1536,0,24 }, { 1600,0,25 }, { 1537,1,24 }, { 1664,0,26 }, { 1601,1,25 }, { 1538,2,24 }, { 1728,0,27 }, { 1665,1,26 }, { 1602,2,25 }, { 1539,3,24 },
  { 1729,1,27 }, { 1666,2,26 }, { 1603,3,25 }, { 1730,2,27 }, { 1667,3,26 }, { 1731,3,27 }, { 1284,4,20 }, { 1348,4,21 }, { 1285,5,20 }, { 1412,4,22 }, { 1349,5,21 }, { 1286,6,20 }, { 1476,4,23 }, { 1413,5,22 }, { 1350,6,21 }, { 1287,7,20 }, { 1477,5,23 }, { 1414,6,22 }, { 1351,7,21 }, { 1478,6,23 },
  { 1415,7,22 }, { 1479,7,23 }, { 1032,8,16 }, { 1096,8,17 }, { 1033,9,16 }, { 1160,8,18 }, { 1097,9,17 }, { 1034,10,16 }, { 1224,8,19 }, { 1161,9,18 }, { 1098,10,17 }, { 1035,11,16 }, { 1225,9,19 }, { 1162,10,18 }, { 1099,11,17 }, { 1226,10,19 }, { 1163,11,18 }, { 1227,11,19 }, { 780,12,12 }, { 844,12,13 },
  { 781,13,12 }, { 908,12,14 }, { 845,13,13 }, { 782,14,12 }, { 972,12,15 }, { 909,13,14 }, { 846,14,13 }, { 783,15,12 }, { 973,13,15 }, { 910,14,14 }, { 847,15,13 }, { 974,14,15 }, { 911,15,14 }, { 975,15,15 }, { 528,16,8 }, { 592,16,9 }, { 529,17,8 }, { 656,16,10 }, { 593,17,9 }, { 530,18,8 },
  { 720,16,11 }, { 657,17,10 }, { 594,18,9 }, { 531,19,8 }, { 721,17,11 }, { 658,18,10 }, { 595,19,9 }, { 722,18,11 }, { 659,19,10 }, { 723,19,11 }, { 276,20,4 }, { 340,20,5 }, { 277,21,4 }, { 404,20,6 }, { 341,21,5 }, { 278,22,4 }, { 468,20,7 }, { 405,21,6 }, { 342,22,5 }, { 279,23,4 },
  { 469,21,7 }, { 406,22,6 }, { 343,23,5 }, { 470,22,7 }, { 407,23,6 }, { 471,23,7 }, { 24,24,0 }, { 88,24,1 }, { 25,25,0 }, { 152,24,2 }, { 89,25,1 }, { 26,26,0 }, { 216,24,3 }, { 153,25,2 }, { 90,26,1 }, { 27,27,0 }, { 217,25,3 }, { 154,26,2 }, { 91,27,1 }, { 218,26,3 },
  { 155,27,2 }, { 219,27,3 }, { 1792,0,28 }, { 1856,0,29 }, { 1793,1,28 }, { 1920,0,30 }, { 1857,1,29 }, { 1794,2,28 }, { 1984,0,31 }, { 1921,1,30 }, { 1858,2,29 }, { 1795,3,28 }, { 1985,1,31 }, { 1922,2,30 }, { 1859,3,29 }, { 1986,2,31 }, { 1923,3,30 }, { 1987,3,31 }, { 1540,4,24 }, { 1604,4,25 },
  { 1541,5,24 }, { 1668,4,26 }, { 1605,5,25 }, { 1542,6,24 }, { 1732,4,27 }, { 1669,5,26 }, { 1606,6,25 }, { 1543,7,24 }, { 1733,5,27 }, { 1670,6,26 }, { 1607,7,25 }, { 1734,6,27 }, { 1671,7,26 }, { 1735,7,27 }, { 1288,8,20 }, { 1352,8,21 }, { 1289,9,20 }, { 1416,8,22 }, { 1353,9,21 }, { 1290,10,20 },
  { 1480,8,23 }, { 1417,9,22 }, { 1354,10,21 }, { 1291,11,20 }, { 1481,9,23 }, { 1418,10,22 }, { 1355,11,21 }, { 1482,10,23 }, { 1419,11,22 }, { 1483,11,23 }, { 1036,12,16 }, { 1100,12,17 }, { 1037,13,16 }, { 1164,12,18 }, { 1101,13,17 }, { 1038,14,16 }, { 1228,12,19 }, { 1165,13,18 }, { 1102,14,17 }, { 1039,15,16 },
  { 1229,13,19 }, { 1166,14,18 }, { 1103,15,17 }, { 1230,14,19 }, { 1167,15,18 }, { 1231,15,19 }, { 784,16,12 }, { 848,16,13 }, { 785,17,12 }, { 912,16,14 }, { 849,17,13 }, { 786,18,12 }, { 976,16,15 }, { 913,17,14 }, { 850,18,13 }, { 787,19,12 }, { 977,17,15 }, { 914,18,14 }, { 851,19,13 }, { 978,18,15 },
  { 915,19,14 }, { 979,19,15 }, { 532,20,8 }, { 596,20,9 }, { 533,21,8 }, { 660,20,10 }, { 597,21,9 }, { 534,22,8 }, { 724,20,11 }, { 661,21,10 }, { 598,22,9 }, { 535,23,8 }, { 725,21,11 }, { 662,22,10 }, { 599,23,9 }, { 726,22,11 }, { 663,23,10 }, { 727,23,11 }, { 280,24,4 }, { 344,24,5 },
  { 281,25,4 }, { 408,24,6 }, { 345,25,5 }, { 282,26,4 }, { 472,24,7 }, { 409,25,6 }, { 346,26,5 }, { 283,27,4 }, { 473,25,7 }, { 410,26,6 }, { 347,27,5 }, { 474,26,7 }, { 411,27,6 }, { 475,27,7 }, { 28,28,0 }, { 92,28,1 }, { 29,29,0 }, { 156,28,2 }, { 93,29,1 }, { 30,30,0 },
  { 220,28,3 }, { 157,29,2 }, { 94,30,1 }, { 31,31,0 }, { 221,29,3 }, { 158,30,2 }, { 95,31,1 }, { 222,30,3 }, { 159,31,2 }, { 223,31,3 }, { 1796,4,28 }, { 1860,4,29 }, { 1797,5,28 }, { 1924,4,30 }, { 1861,5,29 }, { 1798,6,28 }, { 1988,4,31 }, { 1925,5,30 }, { 1862,6,29 }, { 1799,7,28 },
  { 1989,5,31 }, { 1926,6,30 }, { 1863,7,29 }, { 1990,6,31 }, { 1927,7,30 }, { 1991,7,31 }, { 1544,8,24 }, { 1608,8,25 }, { 1545,9,24 }, { 1672,8,26 }, { 1609,9,25 }, { 1546,10,24 }, { 1736,8,27 }, { 1673,9,26 }, { 1610,10,25 }, { 1547,11,24 }, { 1737,9,27 }, { 1674,10,26 }, { 1611,11,25 }, { 1738,10,27 },
  { 1675,11,26 }, { 1739,11,27 }, { 1292,12,20 }, { 1356,12,21 }, { 1293,13,20 }, { 1420,12,22 }, { 1357,13,21 }, { 1294,14,20 }, { 1484,12,23 }, { 1421,13,22 }, { 1358,14,21 }, { 1295,15,20 }, { 1485,13,23 }, { 1422,14,22 }, { 1359,15,21 }, { 1486,14,23 }, { 1423,15,22 }, { 1487,15,23 }, { 1040,16,16 }, { 1104,16,17 },
  { 1041,17,16 }, { 1168,16,18 }, { 1105,17,17 }, { 1042,18,16 }, { 1232,16,19 }, { 1169,17,18 }, { 1106,18,17 }, { 1043,19,16 }, { 1233,17,19 }, { 1170,18,18 }, { 1107,19,17 }, { 1234,18,19 }, { 1171,19,18 }, { 1235,19,19 }, { 788,20,12 }, { 852,20,13 }, { 789,21,12 }, { 916,20,14 }, { 853,21,13 }, { 790,22,12 },
  { 980,20,15 }, { 917,21,14 }, { 854,22,13 }, { 791,23,12 }, { 981,21,15 }, { 918,22,14 }, { 855,23,13 }, { 982,22,15 }, { 919,23,14 }, { 983,23,15 }, { 536,24,8 }, { 600,24,9 }, { 537,25,8 }, { 664,24,10 }, { 601,25,9 }, { 538,26,8 }, { 728,24,11 }, { 665,25,10 }, { 602,26,9 }, { 539,27,8 },
  { 729,25,11 }, { 666,26,10 }, { 603,27,9 }, { 730,26,11 }, { 667,27,10 }, { 731,27,11 }, { 284,28,4 }, { 348,28,5 }, { 285,29,4 }, { 412,28,6 }, { 349,29,5 }, { 286,30,4 }, { 476,28,7 }, { 413,29,6 }, { 350,30,5 }, { 287,31,4 }, { 477,29,7 }, { 414,30,6 }, { 351,31,5 }, { 478,30,7 },
  { 415,31,6 }, { 479,31,7 }, { 1800,8,28 }, { 1864,8,29 }, { 1801,9,28 }, { 1928,8,30 }, { 1865,9,29 }, { 1802,10,28 }, { 1992,8,31 }, { 1929,9,30 }, { 1866,10,29 }, { 1803,11,28 }, { 1993,9,31 }, { 1930,10,30 }, { 1867,11,29 }, { 1994,10,31 }, { 1931,11,30 }, { 1995,11,31 }, { 1548,12,24 }, { 1612,12,25 },
  { 1549,13,24 }, { 1676,12,26 }, { 1613,13,25 }, { 1550,14,24 }, { 1740,12,27 }, { 1677,13,26 }, { 1614,14,25 }, { 1551,15,24 }, { 1741,13,27 }, { 1678,14,26 }, { 1615,15,25 }, { 1742,14,27 }, { 1679,15,26 }, { 1743,15,27 }, { 1296,16,20 }, { 1360,16,21 }, { 1297,17,20 }, { 1424,16,22 }, { 1361,17,21 }, { 1298,18,20 },
  { 1488,16,23 }, { 1425,17,22 }, { 1362,18,21 }, { 1299,19,20 }, { 1489,17,23 }, { 1426,18,22 }, { 1363,19,21 }, { 1490,18,23 }, { 1427,19,22 }, { 1491,19,23 }, { 1044,20,16 }, { 1108,20,17 }, { 1045,21,16 }, { 1172,20,18 }, { 1109,21,17 }, { 1046,22,16 }, { 1236,20,19 }, { 1173,21,18 }, { 1110,22,17 }, { 1047,23,16 },
  { 1237,21,19 }, { 1174,22,18 }, { 1111,23,17 }, { 1238,22,19 }, { 1175,23,18 }, { 1239,23,19 }, { 792,24,12 }, { 856,24,13 }, { 793,25,12 }, { 920,24,14 }, { 857,25,13 }, { 794,26,12 }, { 984,24,15 }, { 921,25,14 }, { 858,26,13 }, { 795,27,12 }, { 985,25,15 }, { 922,26,14 }, { 859,27,13 }, { 986,26,15 },
  { 923,27,14 }, { 987,27,15 }, { 540,28,8 }, { 604,28,9 }, { 541,29,8 }, { 668,28,10 }, { 605,29,9 }, { 542,30,8 }, { 732,28,11 }, { 669,29,10 }, { 606,30,9 }, { 543,31,8 }, { 733,29,11 }, { 670,30,10 }, { 607,31,9 }, { 734,30,11 }, { 671,31,10 }, { 735,31,11 }, { 1804,12,28 }, { 1868,12,29 },
  { 1805,13,28 }, { 1932,12,30 }, { 1869,13,29 }, { 1806,14,28 }, { 1996,12,31 }, { 1933,13,30 }, { 1870,14,29 }, { 1807,15,28 }, { 1997,13,31 }, { 1934,14,30 }, { 1871,15,29 }, { 1998,14,31 }, { 1935,15,30 }, { 1999,15,31 }, { 1552,16,24 }, { 1616,16,25 }, { 1553,17,24 }, { 1680,16,26 }, { 1617,17,25 }, { 1554,18,24 },
  { 1744,16,27 }, { 1681,17,26 }, { 1618,18,25 }, { 1555,19,24 }, { 1745,17,27 }, { 1682,18,26 }, { 1619,19,25 }, { 1746,18,27 }, { 1683,19,26 }, { 1747,19,27 }, { 1300,20,20 }, { 1364,20,21 }, { 1301,21,20 }, { 1428,20,22 }, { 1365,21,21 }, { 1302,22,20 }, { 1492,20,23 }, { 1429,21,22 }, { 1366,22,21 }, { 1303,23,20 },
  { 1493,21,23 }, { 1430,22,22 }, { 1367,23,21 }, { 1494,22,23 }, { 1431,23,22 }, { 1495,23,23 }, { 1048,24,16 }, { 1112,24,17 }, { 1049,25,16 }, { 1176,24,18 }, { 1113,25,17 }, { 1050,26,16 }, { 1240,24,19 }, { 1177,25,18 }, { 1114,26,17 }, { 1051,27,16 }, { 1241,25,19 }, { 1178,26,18 }, { 1115,27,17 }, { 1242,26,19 },
  { 1179,27,18 }, { 1243,27,19 }, { 796,28,12 }, { 860,28,13 }, { 797,29,12 }, { 924,28,14 }, { 861,29,13 }, { 798,30,12 }, { 988,28,15 }, { 925,29,14 }, { 862,30,13 }, { 799,31,12 }, { 989,29,15 }, { 926,30,14 }, { 863,31,13 }, { 990,30,15 }, { 927,31,14 }, { 991,31,15 }, { 1808,16,28 }, { 1872,16,29 },
  { 1809,17,28 }, { 1936,16,30 }, { 1873,17,29 }, { 1810,18,28 }, { 2000,16,31 }, { 1937,17,30 }, { 1874,18,29 }, { 1811,19,28 }, { 2001,17,31 }, { 1938,18,30 }, { 1875,19,29 }, { 2002,18,31 }, { 1939,19,30 }, { 2003,19,31 }, { 1556,20,24 }, { 1620,20,25 }, { 1557,21,24 }, { 1684,20,26 }, { 1621,21,25 }, { 1558,22,24 },
  { 1748,20,27 }, { 1685,21,26 }, { 1622,22,25 }, { 1559,23,24 }, { 1749,21,27 }, { 1686,22,26 }, { 1623,23,25 }, { 1750,22,27 }, { 1687,23,26 }, { 1751,23,27 }, { 1304,24,20 }, { 1368,24,21 }, { 1305,25,20 }, { 1432,24,22 }, { 1369,25,21 }, { 1306,26,20 }, { 1496,24,23 }, { 1433,25,22 }, { 1370,26,21 }, { 1307,27,20 },
  { 1497,25,23 }, { 1434,26,22 }, { 1371,27,21 }, { 1498,26,23 }, { 1435,27,22 }, { 1499,27,23 }, { 1052,28,16 }, { 1116,28,17 }, { 1053,29,16 }, { 1180,28,18 }, { 1117,29,17 }, { 1054,30,16 }, { 1244,28,19 }, { 1181,29,18 }, { 1118,30,17 }, { 1055,31,16 }, { 1245,29,19 }, { 1182,30,18 }, { 1119,31,17 }, { 1246,30,19 },
  { 1183,31,18 }, { 1247,31,19 }, { 1812,20,28 }, { 1876,20,29 }, { 1813,21,28 }, { 1940,20,30 }, { 1877,21,29 }, { 1814,22,28 }, { 2004,20,31 }, { 1941,21,30 }, { 1878,22,29 }, { 1815,23,28 }, { 2005,21,31 }, { 1942,22,30 }, { 1879,23,29 }, { 2006,22,31 }, { 1943,23,30 }, { 2007,23,31 }, { 1560,24,24 }, { 1624,24,25 },
  { 1561,25,24 }, { 1688,24,26 }, { 1625,25,25 }, { 1562,26,24 }, { 1752,24,27 }, { 1689,25,26 }, { 1626,26,25 }, { 1563,27,24 }, { 1753,25,27 }, { 1690,26,26 }, { 1627,27,25 }, { 1754,26,27 }, { 1691,27,26 }, { 1755,27,27 }, { 1308,28,20 }, { 1372,28,21 }, { 1309,29,20 }, { 1436,28,22 }, { 1373,29,21 }, { 1310,30,20 },
  { 1500,28,23 }, { 1437,29,22 }, { 1374,30,21 }, { 1311,31,20 }, { 1501,29,23 }, { 1438,30,22 }, { 1375,31,21 }, { 1502,30,23 }, { 1439,31,22 }, { 1503,31,23 }, { 1816,24,28 }, { 1880,24,29 }, { 1817,25,28 }, { 1944,24,30 }, { 1881,25,29 }, { 1818,26,28 }, { 2008,24,31 }, { 1945,25,30 }, { 1882,26,29 }, { 1819,27,28 },
  { 2009,25,31 }, { 1946,26,30 }, { 1883,27,29 }, { 2010,26,31 }, { 1947,27,30 }, { 2011,27,31 }, { 1564,28,24 }, { 1628,28,25 }, { 1565,29,24 }, { 1692,28,26 }, { 1629,29,25 }, { 1566,30,24 }, { 1756,28,27 }, { 1693,29,26 }, { 1630,30,25 }, { 1567,31,24 }, { 1757,29,27 }, { 1694,30,26 }, { 1631,31,25 }, { 1758,30,27 },
  { 1695,31,26 }, { 1759,31,27 }, { 1820,28,28 }, { 1884,28,29 }, { 1821,29,28 }, { 1948,28,30 }, { 1885,29,29 }, { 1822,30,28 }, { 2012,28,31 }, { 1949,29,30 }, { 1886,30,29 }, { 1823,31,28 }, { 2013,29,31 }, { 1950,30,30 }, { 1887,31,29 }, { 2014,30,31 }, { 1951,31,30 }, { 2015,31,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 }, { 2047,63,31 },
  { 2047,63,31 }, { 2047,63,31 }, { 0,0,0 }, { 64,0,1 }, { 1,1,0 }, { 128,0,2 }, { 65,1,1 }, { 2,2,0 }, { 192,0,3 }, { 129,1,2 }, { 66,2,1 }, { 3,3,0 }, { 193,1,3 }, { 130,2,2 }, { 67,3,1 }, { 194,2,3 }, { 131,3,2 }, { 195,3,3 }, { 256,0,4 }, { 320,0,5 },
  { 257,1,4 }, { 384,0,6 }, { 321,1,5 }, { 258,2,4 }, { 448,0,7 }, { 385,1,6 }, { 322,2,5 }, { 259,3,4 }, { 449,1,7 }, { 386,2,6 }, { 323,3,5 }, { 450,2,7 }, { 387,3,6 }, { 451,3,7 }, { 4,4,0 }, { 68,4,1 }, { 5,5,0 }, { 132,4,2 }, { 69,5,1 }, { 6,6,0 },
  { 196,4,3 }, { 133,5,2 }, { 70,6,1 }, { 7,7,0 }, { 197,5,3 }, { 134,6,2 }, { 71,7,1 }, { 198,6,3 }, { 135,7,2 }, { 199,7,3 }, { 512,0,8 }, { 576,0,9 }, { 513,1,8 }, { 640,0,10 }, { 577,1,9 }, { 514,2,8 }, { 704,0,11 }, { 641,1,10 }, { 578,2,9 }, { 515,3,8 },
  { 705,1,11 }, { 642,2,10 }, { 579,3,9 }, { 706,2,11 }, { 643,3,10 }, { 707,3,11 }, { 260,4,4 }, { 324,4,5 }, { 261,5,4 }, { 388,4,6 }, { 325,5,5 }, { 262,6,4 }, { 452,4,7 }, { 389,5,6 }, { 326,6,5 }, { 263,7,4 }, { 453,5,7 }, { 390,6,6 }, { 327,7,5 }, { 454,6,7 },
  { 391,7,6 }, { 455,7,7 }, { 8,8,0 }, { 72,8,1 }, { 9,9,0 }, { 136,8,2 }, { 73,9,1 }, { 10,10,0 }, { 200,8,3 }, { 137,9,2 }, { 74,10,1 }, { 11,11,0 }, { 201,9,3 }, { 138,10,2 }, { 75,11,1 }, { 202,10,3 }, { 139,11,2 }, { 203,11,3 }, { 768,0,12 }, { 832,0,13 },
  { 769,1,12 }, { 896,0,14 }, { 833,1,13 }, { 770,2,12 }, { 960,0,15 }, { 897,1,14 }, { 834,2,13 }, { 771,3,12 }, { 961,1,15 }, { 898,2,14 }, { 835,3,13 }, { 962,2,15 }, { 899,3,14 }, { 963,3,15 }, { 516,4,8 }, { 580,4,9 }, { 517,5,8 }, { 644,4,10 }, { 581,5,9 }, { 518,6,8 },
  { 708,4,11 }, { 645,5,10 }, { 582,6,9 }, { 519,7,8 }, { 709,5,11 }, { 646,6,10 }, { 583,7,9 }, { 710,6,11 }, { 647,7,10 }, { 711,7,11 }, { 264,8,4 }, { 328,8,5 }, { 265,9,4 }, { 392,8,6 }, { 329,9,5 }, { 266,10,4 }, { 456,8,7 }, { 393,9,6 }, { 330,10,5 }, { 267,11,4 },
  { 457,9,7 }, { 394,10,6 }, { 331,11,5 }, { 458,10,7 }, { 395,11,6 }, { 459,11,7 }, { 12,12,0 }, { 76,12,1 }, { 13,13,0 }, { 140,12,2 }, { 77,13,1 }, { 14,14,0 }, { 204,12,3 }, { 141,13,2 }, { 78,14,1 }, { 15,15,0 }, { 205,13,3 }, { 142,14,2 }, { 79,15,1 }, { 206,14,3 },
  { 143,15,2 }, { 207,15,3 }, { 1024,0,16 }, { 1088,0,17 }, { 1025,1,16 }, { 1152,0,18 }, { 1089,1,17 }, { 1026,2,16 }, { 1216,0,19 }, { 1153,1,18 }, { 1090,2,17 }, { 1027,3,16 }, { 1217,1,19 }, { 1154,2,18 }, { 1091,3,17 }, { 1218,2,19 }, { 1155,3,18 }, { 1219,3,19 }, { 772,4,12 }, { 836,4,13 },
  { 773,5,12 }, { 900,4,14 }, { 837,5,13 }, { 774,6,12 }, { 964,4,15 }, { 901,5,14 }, { 838,6,13 }, { 775,7,12 }, { 965,5,15 }, { 902,6,14 }, { 839,7,13 }, { 966,6,15 }, { 903,7,14 }, { 967,7,15 }, { 520,8,8 }, { 584,8,9 }, { 521,9,8 }, { 648,8,10 }, { 585,9,9 }, { 522,10,8 },
  { 712,8,11 }, { 649,9,10 }, { 586,10,9 }, { 523,11,8 }, { 713,9,11 }, { 650,10,10 }, { 587,11,9 }, { 714,10,11 }, { 651,11,10 }, { 715,11,11 }, { 268,12,4 }, { 332,12,5 }, { 269,13,4 }, { 396,12,6 }, { 333,13,5 }, { 270,14,4 }, { 460,12,7 }, { 397,13,6 }, { 334,14,5 }, { 271,15,4 },
  { 461,13,7 }, { 398,14,6 }, { 335,15,5 }, { 462,14,7 }, { 399,15,6 }, { 463,15,7 }, { 16,16,0 }, { 80,16,1 }, { 17,17,0 }, { 144,16,2 }, { 81,17,1 }, { 18,18,0 }, { 208,16,3 }, { 145,17,2 }, { 82,18,1 }, { 19,19,0 }, { 209,17,3 }, { 146,18,2 }, { 83,19,1 }, { 210,18,3 },
  { 147,19,2 }, { 211,19,3 }, { 1280,0,20 }, { 1344,0,21 }, { 1281,1,20 }, { 1408,0,22 }, { 1345,1,21 }, { 1282,2,20 }, { 1472,0,23 }, { 1409,1,22 }, { 1346,2,21 }, { 1283,3,20 }, { 1473,1,23 }, { 1410,2,22 }, { 1347,3,21 }, { 1474,2,23 }, { 1411,3,22 }, { 1475,3,23 }, { 1028,4,16 }, { 1092,4,17 },
  { 1029,5,16 }, { 1156,4,18 }, { 1093,5,17 }, { 1030,6,16 }, { 1220,4,19 }, { 1157,5,18 }, { 1094,6,17 }, { 1031,7,16 }, { 1221,5,19 }, { 1158,6,18 }, { 1095,7,17 }, { 1222,6,19 }, { 1159,7,18 }, { 1223,7,19 }, { 776,8,12 }, { 840,8,13 }, { 777,9,12 }, { 904,8,14 }, { 841,9,13 }, { 778,10,12 },
  { 968,8,15 }, { 905,9,14 }, { 842,10,13 }, { 779,11,12 }, { 969,9,15 }, { 906,10,14 }, { 843,11,13 }, { 970,10,15 }, { 907,11,14 }, { 971,11,15 }, { 524,12,8 }, { 588,12,9 }, { 525,13,8 }, { 652,12,10 }, { 589,13,9 }, { 526,14,8 }, { 716,12,11 }, { 653,13,10 }, { 590,14,9 }, { 527,15,8 },
  { 717,13,11 }, { 654,14,10 }, { 591,15,9 }, { 718,14,11 }, { 655,15,10 }, { 719,15,11 }, { 272,16,4 }, { 336,16,5 }, { 273,17,4 }, { 400,16,6 }, { 337,17,5 }, { 274,18,4 }, { 464,16,7 }, { 401,17,6 }, { 338,18,5 }, { 275,19,4 }, { 465,17,7 }, { 402,18,6 }, { 339,19,5 }, { 466,18,7 },
  { 403,19,6 }, { 467,19,7 }, { 20,20,0 }, { 84,20,1 }, { 21,21,0 }, { 148,20,2 }, { 85,21,1 }, { 22,22,0 }, { 212,20,3 }, { 149,21,2 }, { 86,22,1 }, { 23,23,0 }, { 213,21,3 }, { 150,22,2 }, { 87,23,1 }, { 214,22,3 }, { 151,23,2 }, { 215,23,3 }, { 1536,0,24 }, { 1600,0,25 },
  { 1537,1,24 }, { 1664,0,26 }, { 1601,1,25 }, { 1538,2,24 }, { 1728,0,27 }, { 1665,1,26 }, { 1602,2,25 }, { 1539,3,24 }, { 1729,1,27 }, { 1666,2,26 }, { 1603,3,25 }, { 1730,2,27 }, { 1667,3,26 }, { 1731,3,27 }, { 1284,4,20 }, { 1348,4,21 }, { 1285,5,20 }, { 1412,4,22 }, { 1349,5,21 }, { 1286,6,20 },
  { 1476,4,23 }, { 1413,5,22 }, { 1350,6,21 }, { 1287,7,20 }, { 1477,5,23 }, { 1414,6,22 }, { 1351,7,21 }, { 1478,6,23 }, { 1415,7,22 }, { 1479,7,23 }, { 1032,8,16 }, { 1096,8,17 }, { 1033,9,16 }, { 1160,8,18 }, { 1097,9,17 }, { 1034,10,16 }, { 1224,8,19 }, { 1161,9,18 }, { 1098,10,17 }, { 1035,11,16 },
  { 1225,9,19 }, { 1162,10,18 }, { 1099,11,17 }, { 1226,10,19 }, { 1163,11,18 }, { 1227,11,19 }, { 780,12,12 }, { 844,12,13 }, { 781,13,12 }, { 908,12,14 }, { 845,13,13 }, { 782,14,12 }, { 972,12,15 }, { 909,13,14 }, { 846,14,13 }, { 783,15,12 }, { 973,13,15 }, { 910,14,14 }, { 847,15,13 }, { 974,14,15 },
  { 911,15,14 }, { 975,15,15 }, { 528,16,8 }, { 592,16,9 }, { 529,17,8 }, { 656,16,10 }, { 593,17,9 }, { 530,18,8 }, { 720,16,11 }, { 657,17,10 }, { 594,18,9 }, { 531,19,8 }, { 721,17,11 }, { 658,18,10 }, { 595,19,9 }, { 722,18,11 }, { 659,19,10 }, { 723,19,11 }, { 276,20,4 }, { 340,20,5 },
  { 277,21,4 }, { 404,20,6 }, { 341,21,5 }, { 278,22,4 }, { 468,20,7 }, { 405,21,6 }, { 342,22,5 }, { 279,23,4 }, { 469,21,7 }, { 406,22,6 }, { 343,23,5 }, { 470,22,7 }, { 407,23,6 }, { 471,23,7 }, { 24,24,0 }, { 88,24,1 }, { 25,25,0 }, { 152,24,2 }, { 89,25,1 }, { 26,26,0 },
  { 216,24,3 }, { 153,25,2 }, { 90,26,1 }, { 27,27,0 }, { 217,25,3 }, { 154,26,2 }, { 91,27,1 }, { 218,26,3 }, { 155,27,2 }, { 219,27,3 }, { 1792,0,28 }, { 1856,0,29 }, { 1793,1,28 }, { 1920,0,30 }, { 1857,1,29 }, { 1794,2,28 }, { 1984,0,31 }, { 1921,1,30 }, { 1858,2,29 }, { 1795,3,28 },
  { 1985,1,31 }, { 1922,2,30 }, { 1859,3,29 }, { 1986,2,31 }, { 1923,3,30 }, { 1987,3,31 }, { 1540,4,24 }, { 1604,4,25 }, { 1541,5,24 }, { 1668,4,26 }, { 1605,5,25 }, { 1542,6,24 }, { 1732,4,27 }, { 1669,5,26 }, { 1606,6,25 }, { 1543,7,24 }, { 1733,5,27 }, { 1670,6,26 }, { 1607,7,25 }, { 1734,6,27 },
  { 1671,7,26 }, { 1735,7,27 }, { 1288,8,20 }, { 1352,8,21 }, { 1289,9,20 }, { 1416,8,22 }, { 1353,9,21 }, { 1290,10,20 }, { 1480,8,23 }, { 1417,9,22 }, { 1354,10,21 }, { 1291,11,20 }, { 1481,9,23 }, { 1418,10,22 }, { 1355,11,21 }, { 1482,10,23 }, { 1419,11,22 }, { 1483,11,23 }, { 1036,12,16 }, { 1100,12,17 },
  { 1037,13,16 }, { 1164,12,18 }, { 1101,13,17 }, { 1038,14,16 }, { 1228,12,19 }, { 1165,13,18 }, { 1102,14,17 }, { 1039,15,16 }, { 1229,13,19 }, { 1166,14,18 }, { 1103,15,17 }, { 1230,14,19 }, { 1167,15,18 }, { 1231,15,19 }, { 784,16,12 }, { 848,16,13 }, { 785,17,12 }, { 912,16,14 }, { 849,17,13 }, { 786,18,12 },
  { 976,16,15 }, { 913,17,14 }, { 850,18,13 }, { 787,19,12 }, { 977,17,15 }, { 914,18,14 }, { 851,19,13 }, { 978,18,15 }, { 915,19,14 }, { 979,19,15 }, { 532,20,8 }, { 596,20,9 }, { 533,21,8 }, { 660,20,10 }, { 597,21,9 }, { 534,22,8 }, { 724,20,11 }, { 661,21,10 }, { 598,22,9 }, { 535,23,8 },
  { 725,21,11 }, { 662,22,10 }, { 599,23,9 }, { 726,22,11 }, { 663,23,10 }, { 727,23,11 }, { 280,24,4 }, { 344,24,5 }, { 281,25,4 }, { 408,24,6 }, { 345,25,5 }, { 282,26,4 }, { 472,24,7 }, { 409,25,6 }, { 346,26,5 }, { 283,27,4 }, { 473,25,7 }, { 410,26,6 }, { 347,27,5 }, { 474,26,7 },
  { 411,27,6 }, { 475,27,7 }, { 28,28,0 }, { 92,28,1 }, { 29,29,0 }, { 156,28,2 }, { 93,29,1 }, { 30,30,0 }, { 220,28,3 }, { 157,29,2 }, { 94,30,1 }, { 31,31,0 }, { 221,29,3 }, { 158,30,2 }, { 95,31,1 }, { 222,30,3 }, { 159,31,2 }, { 223,31,3 }, { 1796,4,28 }, { 1860,4,29 },
  { 1797,5,28 }, { 1924,4,30 }, { 1861,5,29 }, { 1798,6,28 }, { 1988,4,31 }, { 1925,5,30 }, { 1862,6,29 }, { 1799,7,28 }, { 1989,5,31 }, { 1926,6,30 }, { 1863,7,29 }, { 1990,6,31 }, { 1927,7,30 }, { 1991,7,31 }, { 1544,8,24 }, { 1608,8,25 }, { 1545,9,24 }, { 1672,8,26 }, { 1609,9,25 }, { 1546,10,24 },
  { 1736,8,27 }, { 1673,9,26 }, { 1610,10,25 }, { 1547,11,24 }, { 1737,9,27 }, { 1674,10,26 }, { 1611,11,25 }, { 1738,10,27 }, { 1675,11,26 }, { 1739,11,27 }, { 1292,12,20 }, { 1356,12,21 }, { 1293,13,20 }, { 1420,12,22 }, { 1357,13,21 }, { 1294,14,20 }, { 1484,12,23 }, { 1421,13,22 }, { 1358,14,21 }, { 1295,15,20 },
  { 1485,13,23 }, { 1422,14,22 }, { 1359,15,21 }, { 1486,14,23 }, { 1423,15,22 }, { 1487,15,23 }, { 1040,16,16 }, { 1104,16,17 }, { 1041,17,16 }, { 1168,16,18 }, { 1105,17,17 }, { 1042,18,16 }, { 1232,16,19 }, { 1169,17,18 }, { 1106,18,17 }, { 1043,19,16 }, { 1233,17,19 }, { 1170,18,18 }, { 1107,19,17 }, { 1234,18,19 },
  { 1171,19,18 }, { 1235,19,19 }, { 788,20,12 }, { 852,20,13 }, { 789,21,12 }, { 916,20,14 }, { 853,21,13 }, { 790,22,12 }, { 980,20,15 }, { 917,21,14 }, { 854,22,13 }, { 791,23,12 }, { 981,21,15 }, { 918,22,14 }, { 855,23,13 }, { 982,22,15 }, { 919,23,14 }, { 983,23,15 }, { 536,24,8 }, { 600,24,9 },
  { 537,25,8 }, { 664,24,10 }, { 601,25,9 }, { 538,26,8 }, { 728,24,11 }, { 665,25,10 }, { 602,26,9 }, { 539,27,8 }, { 729,25,11 }, { 666,26,10 }, { 603,27,9 }, { 730,26,11 }, { 667,27,10 }, { 731,27,11 }, { 284,28,4 }, { 348,28,5 }, { 285,29,4 }, { 412,28,6 }, { 349,29,5 }, { 286,30,4 },
  { 476,28,7 }, { 413,29,6 }, { 350,30,5 }, { 287,31,4 }, { 477,29,7 }, { 414,30,6 }, { 351,31,5 }, { 478,30,7 }, { 415,31,6 }, { 479,31,7 }, { 1800,8,28 }, { 1864,8,29 }, { 1801,9,28 }, { 1928,8,30 }, { 1865,9,29 }, { 1802,10,28 }, { 1992,8,31 }, { 1929,9,30 }, { 1866,10,29 }, { 1803,11,28 },
  { 1993,9,31 }, { 1930,10,30 }, { 1867,11,29 }, { 1994,10,31 }, { 1931,11,30 }, { 1995,11,31 }, { 1548,12,24 }, { 1612,12,25 }, { 1549,13,24 }, { 1676,12,26 }, { 1613,13,25 }, { 1550,14,24 }, { 1740,12,27 }, { 1677,13,26 }, { 1614,14,25 }, { 1551,15,24 }, { 1741,13,27 }, { 1678,14,26 }, { 1615,15,25 }, { 1742,14,27 },
  { 1679,15,26 }, { 1743,15,27 }, { 1296,16,20 }, { 1360,16,21 }, { 1297,17,20 }, { 1424,16,22 }, { 1361,17,21 }, { 1298,18,20 }, { 1488,16,23 }, { 1425,17,22 }, { 1362,18,21 }, { 1299,19,20 }, { 1489,17,23 }, { 1426,18,22 }, { 1363,19,21 }, { 1490,18,23 }, { 1427,19,22 }, { 1491,19,23 }, { 1044,20,16 }, { 1108,20,17 },
  { 1045,21,16 }, { 1172,20,18 }, { 1109,21,17 }, { 1046,22,16 }, { 1236,20,19 }, { 1173,21,18 }, { 1110,22,17 }, { 1047,23,16 }, { 1237,21,19 }, { 1174,22,18 }, { 1111,23,17 }, { 1238,22,19 }, { 1175,23,18 }, { 1239,23,19 }, { 792,24,12 }, { 856,24,13 }, { 793,25,12 }, { 920,24,14 }, { 857,25,13 }, { 794,26,12 },
  { 984,24,15 }, { 921,25,14 }, { 858,26,13 }, { 795,27,12 }, { 985,25,15 }, { 922,26,14 }, { 859,27,13 }, { 986,26,15 }, { 923,27,14 }, { 987,27,15 }, { 540,28,8 }, { 604,28,9 }, { 541,29,8 }, { 668,28,10 }, { 605,29,9 }, { 542,30,8 }, { 732,28,11 }, { 669,29,10 }, { 606,30,9 }, { 543,31,8 },
  { 733,29,11 }, { 670,30,10 }, { 607,31,9 }, { 734,30,11 }, { 671,31,10 }, { 735,31,11 }, { 1804,12,28 }, { 1868,12,29 }, { 1805,13,28 }, { 1932,12,30 }, { 1869,13,29 }, { 1806,14,28 }, { 1996,12,31 }, { 1933,13,30 }, { 1870,14,29 }, { 1807,15,28 }, { 1997,13,31 }, { 1934,14,30 }, { 1871,15,29 }, { 1998,14,31 },
  { 1935,15,30 }, { 1999,15,31 }, { 1552,16,24 }, { 1616,16,25 }, { 1553,17,24 }, { 1680,16,26 }, { 1617,17,25 }, { 1554,18,24 }, { 1744,16,27 }, { 1681,17,26 }, { 1618,18,25 }, { 1555,19,24 }, { 1745,17,27 }, { 1682,18,26 }, { 1619,19,25 }, { 1746,18,27 }, { 1683,19,26 }, { 1747,19,27 }, { 1300,20,20 }, { 1364,20,21 },
  { 1301,21,20 }, { 1428,20,22 }, { 1365,21,21 }, { 1302,22,20 }, { 1492,20,23 }, { 1429,21,22 }, { 1366,22,21 }, { 1303,23,20 }, { 1493,21,23 }, { 1430,22,22 }, { 1367,23,21 }, { 1494,22,23 }, { 1431,23,22 }, { 1495,23,23 }, { 1048,24,16 }, { 1112,24,17 }, { 1049,25,16 }, { 1176,24,18 }, { 1113,25,17 }, { 1050,26,16 },
  { 1240,24,19 }, { 1177,25,18 }, { 1114,26,17 }, { 1051,27,16 }, { 1241,25,19 }, { 1178,26,18 }, { 1115,27,17 }, { 1242,26,19 }, { 1179,27,18 }, { 1243,27,19 }, { 796,28,12 }, { 860,28,13 }, { 797,29,12 }, { 924,28,14 }, { 861,29,13 }, { 798,30,12 }, { 988,28,15 }, { 925,29,14 }, { 862,30,13 }, { 799,31,12 },
  { 989,29,15 }, { 926,30,14 }, { 863,31,13 }, { 990,30,15 }, { 927,31,14 }, { 991,31,15 }, { 1808,16,28 }, { 1872,16,29 }, { 1809,17,28 }, { 1936,16,30 }, { 1873,17,29 }, { 1810,18,28 }, { 2000,16,31 }, { 1937,17,30 }, { 1874,18,29 }, { 1811,19,28 }, { 2001,17,31 }, { 1938,18,30 }, { 1875,19,29 }, { 2002,18,31 },
  { 1939,19,30 }, { 2003,19,31 }, { 1556,20,24 }, { 1620,20,25 }, { 1557,21,24 }, { 1684,20,26 }, { 1621,21,25 }, { 1558,22,24 }, { 1748,20,27 }, { 1685,21,26 }, { 1622,22,25 }, { 1559,23,24 }, { 1749,21,27 }, { 1686,22,26 }, { 1623,23,25 }, { 1750,22,27 }, { 1687,23,26 }, { 1751,23,27 }, { 1304,24,20 }, { 1368,24,21 },
  { 1305,25,20 }, { 1432,24,22 }, { 1369,25,21 }, { 1306,26,20 }, { 1496,24,23 }, { 1433,25,22 }, { 1370,26,21 }, { 1307,27,20 }, { 1497,25,23 }, { 1434,26,22 }, { 1371,27,21 }, { 1498,26,23 }, { 1435,27,22 }, { 1499,27,23 }, { 1052,28,16 }, { 1116,28,17 }, { 1053,29,16 }, { 1180,28,18 }, { 1117,29,17 }, { 1054,30,16 },
  { 1244,28,19 }, { 1181,29,18 }, { 1118,30,17 }, { 1055,31,16 }, { 1245,29,19 }, { 1182,30,18 }, { 1119,31,17 }, { 1246,30,19 }, { 1183,31,18 }, { 1247,31,19 }, { 1812,20,28 }, { 1876,20,29 }, { 1813,21,28 }, { 1940,20,30 }, { 1877,21,29 }, { 1814,22,28 }, { 2004,20,31 }, { 1941,21,30 }, { 1878,22,29 }, { 1815,23,28 },
  { 2005,21,31 }, { 1942,22,30 }, { 1879,23,29 }, { 2006,22,31 }, { 1943,23,30 }, { 2007,23,31 }, { 1560,24,24 }, { 1624,24,25 }, { 1561,25,24 }, { 1688,24,26 }, { 1625,25,25 }, { 1562,26,24 }, { 1752,24,27 }, { 1689,25,26 }, { 1626,26,25 }, { 1563,27,24 }, { 1753,25,27 }, { 1690,26,26 }, { 1627,27,25 }, { 1754,26,27 },
  { 1691,27,26 }, { 1755,27,27 }, { 1308,28,20 }, { 1372,28,21 }, { 1309,29,20 }, { 1436,28,22 }, { 1373,29,21 }, { 1310,30,20 }, { 1500,28,23 }, { 1437,29,22 }, { 1374,30,21 }, { 1311,31,20 }, { 1501,29,23 }, { 1438,30,22 }, { 1375,31,21 }, { 1502,30,23 }, { 1439,31,22 }, { 1503,31,23 }, { 1816,24,28 }, { 1880,24,29 },
  { 1817,25,28 }, { 1944,24,30 }, { 1881,25,29 }, { 1818,26,28 }, { 2008,24,31 }, { 1945,25,30 }, { 1882,26,29 }, { 1819,27,28 }, { 2009,25,31 }, { 1946,26,30 }, { 1883,27,29 }, { 2010,26,31 }, { 1947,27,30 }, { 2011,27,31 }, { 1564,28,24 }, { 1628,28,25 }, { 1565,29,24 }, { 1692,28,26 }, { 1629,29,25 }, { 1566,30,24 },
  { 1756,28,27 }, { 1693,29,26 }, { 1630,30,25 }, { 1567,31,24 }, { 1757,29,27 }, { 1694,30,26 }, { 1631,31,25 }, { 1758,30,27 }, { 1695,31,26 }, { 1759,31,27 }, { 1820,28,28 }, { 1884,28,29 }, { 1821,29,28 }, { 1948,28,30 }, { 1885,29,29 }, { 1822,30,28 }, { 2012,28,31 }, { 1949,29,30 }, { 1886,30,29 }, { 1823,31,28 },
  { 2013,29,31 }, { 1950,30,30 }, { 1887,31,29 }, { 2014,30,31 }, { 1951,31,30 }, { 2015,31,31 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
  { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 }, { 4095,63,63 },
};

} // namespace vvenc

//! \}

