/*
  gmorgan - a ryhthm station software

  gmorgan.varios.C  -  Miscelaneous functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modified by Josep Andreu

*/

#include "GMorgan.h"
#include <FL/fl_message.H>
#include <FL/Fl_Help_Dialog.H>

void
GMO::GetCombiM (int i)
{
  int j, k;
//  cout << " GetCombiM: " << Name << endl;
  for (k = 0; k <= (int) strlen (Name); k++)
    Prog[i].Nom[k] = Name[k];
  cout << "Changing Voicing from " << Name << endl;
  for (j = 1; j <= 4; j++)
    {
      Prog[i].OnOff[j] = OnOff[j];
      Prog[i].volume[j] = volume[j];
      Prog[i].progch[j] = progch[j];
      Prog[i].pan[j] = pan[j];
      Prog[i].reverb[j] = reverb[j];
      Prog[i].chorus[j] = chorus[j];
      Prog[i].BankMSB[j] = BankMSB[j];
      Prog[i].BankLSB[j] = BankLSB[j];
      Prog[i].Pon[j] = Pon[j];
      Prog[i].Ptime[j] = Ptime[j];
      Prog[i].octa[j] = octa[j];
      Prog[i].lowvel[j] = lowvel[j];
      Prog[i].hivel[j] = hivel[j];
      Prog[i].lonote[j] = lonote[j];
      Prog[i].hinote[j] = hinote[j];
    }

};

void
GMO::MeteMixerMidi (int i)
{
//fl_message(gettext("Set defaults "));
//cout << "rlv voicing.C MeteMixerMidi: i =" << i << endl;
  cout << "Change Voicing to  " << i << endl;;
  if (MutesOnOff)
    {
      Rt[i].acc1on = 0;
      Rt[i].acc2on = 0;
      Rt[i].acc3on = 0;
      Rt[i].acc4on = 0;
      Rt[i].acc5on = 0;
      Rt[i].basson = 1;
      Rt[i].dron = 1;
    }
  else
    {
      OnOff[5] = Rt[i].acc1on;
      OnOff[6] = Rt[i].acc2on;
      OnOff[7] = Rt[i].basson;
      OnOff[8] = Rt[i].dron;
      OnOff[9] = Rt[i].acc3on;
      OnOff[10] = Rt[i].acc4on;
      OnOff[11] = Rt[i].acc5on;
    }
if (MidiMode > 0)
	{
  cout << "restoring accompaniment settings,  midimode = " << MidiMode << endl;
  volume[5] = Rt[i].acc1vol;
  volume[6] = Rt[i].acc2vol;
  volume[7] = Rt[i].bassvol;
  volume[8] = Rt[i].drvol;
  volume[9] = Rt[i].acc3vol;
  volume[10] = Rt[i].acc4vol;
  volume[11] = Rt[i].acc5vol;

  progch[5] = Rt[i].acc1pc;
  progch[6] = Rt[i].acc2pc;
  progch[7] = Rt[i].basspc;
  progch[8] = Rt[i].drpc;
  progch[9] = Rt[i].acc3pc;
  progch[10] = Rt[i].acc4pc;
  progch[11] = Rt[i].acc5pc;

  pan[5] = Rt[i].acc1pan;
  pan[6] = Rt[i].acc2pan;
  pan[7] = Rt[i].basspan;
  pan[8] = Rt[i].drpan;
  pan[9] = Rt[i].acc3pan;
  pan[10] = Rt[i].acc4pan;
  pan[11] = Rt[i].acc5pan;

  reverb[5] = Rt[i].acc1rev;
  reverb[6] = Rt[i].acc2rev;
  reverb[7] = Rt[i].bassrev;
  reverb[8] = Rt[i].drrev;
  reverb[9] = Rt[i].acc3rev;
  reverb[10] = Rt[i].acc4rev;
  reverb[11] = Rt[i].acc5rev;

  chorus[5] = Rt[i].acc1cho;
  chorus[6] = Rt[i].acc2cho;
  chorus[7] = Rt[i].basscho;
  chorus[8] = Rt[i].drcho;
  chorus[9] = Rt[i].acc3cho;
  chorus[10] = Rt[i].acc4cho;
  chorus[11] = Rt[i].acc5cho;
	}
  octa[5] = Rt[i].acc1octa;
  octa[6] = Rt[i].acc2octa;
  octa[7] = Rt[i].bassocta;
  octa[8] = Rt[i].drocta;
  octa[9] = Rt[i].acc3octa;
  octa[10] = Rt[i].acc4octa;
  octa[11] = Rt[i].acc5octa;
  
  BankMSB[5] = Rt[i].acc1BankM;
  BankMSB[6] = Rt[i].acc2BankM;
  BankMSB[7] = Rt[i].bassBankM;
  BankMSB[8] = Rt[i].drBankM;
  BankMSB[9] = Rt[i].acc3BankM;
  BankMSB[10] = Rt[i].acc4BankM;
  BankMSB[11] = Rt[i].acc5BankM;

  Pon[5] = Rt[i].acc1pon;
  Pon[6] = Rt[i].acc2pon;
  Pon[7] = Rt[i].basspon;
  Pon[8] = Rt[i].drpon;
  Pon[9] = Rt[i].acc3pon;
  Pon[10] = Rt[i].acc4pon;
  Pon[11] = Rt[i].acc5pon;

  Ptime[5] = Rt[i].acc1ptime;
  Ptime[6] = Rt[i].acc2ptime;
  Ptime[7] = Rt[i].bassptime;
  Ptime[8] = Rt[i].drptime;
  Ptime[9] = Rt[i].acc3ptime;
  Ptime[10] = Rt[i].acc4ptime;
  Ptime[11] = Rt[i].acc5ptime;
if (MidiMode > 2)
	{
  cout << " - changing accompanying voices because MidiMode =  " << MidiMode ;
  int j;
  for (j = 5; j <= 11; j++)
    enviocontrol (j, 121, TMch[j]);
  for (j = 5; j <= 11; j++)
    enviomidi (j, TMch[j]);
  for (j = 5; j <= 11; j++)
    enviocontrol (j, 7, TMch[j]);
  for (j = 5; j <= 11; j++)
    {
      enviocontrol (j, 10, TMch[j]);
      enviocontrol (j, 91, TMch[j]);
      enviocontrol (j, 93, TMch[j]);
      enviocontrol (j, 65, TMch[j]);
      enviocontrol (j, 5, TMch[j]);
      enviocontrol (j, 37, TMch[j]);
    }
	}
  cout << endl;
  cambiapat = 1;
};

// ********************************************************************
//
// ********************************************************************
void
GMO::MeteMixerMidiProg (int i)
{
  int j;
  for (int k = 0; k <= (int) strlen (Name); k++)
	Name[k] = Prog[i].Nom[k];
  cout << " Changing primary voicing to " << Name;
  for (j = 1; j <= 4; j++)
    {
      OnOff[j] = Prog[i].OnOff[j];
      volume[j] = Prog[i].volume[j];
      progch[j] = Prog[i].progch[j];
      pan[j] = Prog[i].pan[j];
      reverb[j] = Prog[i].reverb[j];
      chorus[j] = Prog[i].chorus[j];
      BankMSB[j] = Prog[i].BankMSB[j];
      BankLSB[j] = Prog[i].BankLSB[j];
      Pon[j] = Prog[i].Pon[j];
      Ptime[j] = Prog[i].Ptime[j];
      octa[j] = Prog[i].octa[j];
      lowvel[j] = Prog[i].lowvel[j];
      hivel[j] = Prog[i].hivel[j];
      lonote[j] = Prog[i].lonote[j];
      hinote[j] = Prog[i].hinote[j];
    }
//if (MidiMode > 2)
  if ((stst == 0) && (bplay == 0))
	{
  cout << " and environment ";
  for (j = 1; j <= 4; j++)
    enviomidi (j, TMch[j]);

  for (j = 1; j <= 4; j++)
    {
      enviocontrol (j, 7, TMch[j]);
      enviocontrol (j, 10, TMch[j]);
      enviocontrol (j, 91, TMch[j]);
      enviocontrol (j, 93, TMch[j]);
      enviocontrol (j, 65, TMch[j]);
      enviocontrol (j, 5, TMch[j]);
      enviocontrol (j, 37, TMch[j]);
    }
	}
  cout << endl;
};

//***********************
//***********************
//***********************

void
GMO::ChangePattern (int i)
{
//fl_message(gettext("Set defaults "));
// cout << "rlv voicing.C ChangePattern: i =" << i << endl;
  if (MutesOnOff)
    {
      cout << "Changing Pattern: i =" << i << "...no change to mutes: " << endl;
    }
  else
    {
      OnOff[5] = Rt[i].acc1on;
      OnOff[6] = Rt[i].acc2on;
      OnOff[7] = Rt[i].basson;
      OnOff[8] = Rt[i].dron;
      OnOff[9] = Rt[i].acc3on;
      OnOff[10] = Rt[i].acc4on;
      OnOff[11] = Rt[i].acc5on;
	cout << "Changing Pattern to: " << i << " restoring mutes " << endl;
    }
// if midimode is off the keyboard controls take precedunce.
if (MidiMode > 0)
	{
  volume[5] = Rt[i].acc1vol;
  volume[6] = Rt[i].acc2vol;
  volume[7] = Rt[i].bassvol;
  volume[8] = Rt[i].drvol;
  volume[9] = Rt[i].acc3vol;
  volume[10] = Rt[i].acc4vol;
  volume[11] = Rt[i].acc5vol;

  progch[5] = Rt[i].acc1pc;
  progch[6] = Rt[i].acc2pc;
  progch[7] = Rt[i].basspc;
  progch[8] = Rt[i].drpc;
  progch[9] = Rt[i].acc3pc;
  progch[10] = Rt[i].acc4pc;
  progch[11] = Rt[i].acc5pc;

  pan[5] = Rt[i].acc1pan;
  pan[6] = Rt[i].acc2pan;
  pan[7] = Rt[i].basspan;
  pan[8] = Rt[i].drpan;
  pan[9] = Rt[i].acc3pan;
  pan[10] = Rt[i].acc4pan;
  pan[11] = Rt[i].acc5pan;

  reverb[5] = Rt[i].acc1rev;
  reverb[6] = Rt[i].acc2rev;
  reverb[7] = Rt[i].bassrev;
  reverb[8] = Rt[i].drrev;
  reverb[9] = Rt[i].acc3rev;
  reverb[10] = Rt[i].acc4rev;
  reverb[11] = Rt[i].acc5rev;

  chorus[5] = Rt[i].acc1cho;
  chorus[6] = Rt[i].acc2cho;
  chorus[7] = Rt[i].basscho;
  chorus[8] = Rt[i].drcho;
  chorus[9] = Rt[i].acc3cho;
  chorus[10] = Rt[i].acc4cho;
  chorus[11] = Rt[i].acc5cho;

  octa[5] = Rt[i].acc1octa;
  octa[6] = Rt[i].acc2octa;
  octa[7] = Rt[i].bassocta;
  octa[8] = Rt[i].drocta;
  octa[9] = Rt[i].acc3octa;
  octa[10] = Rt[i].acc4octa;
  octa[11] = Rt[i].acc5octa;

  BankMSB[5] = Rt[i].acc1BankM;
  BankMSB[6] = Rt[i].acc2BankM;
  BankMSB[7] = Rt[i].bassBankM;
  BankMSB[8] = Rt[i].drBankM;
  BankMSB[9] = Rt[i].acc3BankM;
  BankMSB[10] = Rt[i].acc4BankM;
  BankMSB[11] = Rt[i].acc5BankM;

  Pon[5] = Rt[i].acc1pon;
  Pon[6] = Rt[i].acc2pon;
  Pon[7] = Rt[i].basspon;
  Pon[8] = Rt[i].drpon;
  Pon[9] = Rt[i].acc3pon;
  Pon[10] = Rt[i].acc4pon;
  Pon[11] = Rt[i].acc5pon;


  Ptime[5] = Rt[i].acc1ptime;
  Ptime[6] = Rt[i].acc2ptime;
  Ptime[7] = Rt[i].bassptime;
  Ptime[8] = Rt[i].drptime;
  Ptime[9] = Rt[i].acc3ptime;
  Ptime[10] = Rt[i].acc4ptime;
  Ptime[11] = Rt[i].acc5ptime;
	}
// this takes too much time
// to do while actually playing. rlv. 
if (notplaying == 3)
{
int j;
for (j=5; j<=11; j++) enviocontrol(j,121,TMch[j]);
for (j=5; j<=11; j++) enviomidi(j,TMch[j]);
  for (j = 5; j <= 11; j++)
    enviocontrol (j, 7, TMch[j]);
  for (j = 5; j <= 11; j++)
    {
      enviocontrol (j, 10, TMch[j]);
      enviocontrol (j, 91, TMch[j]);
      enviocontrol (j, 93, TMch[j]);
      enviocontrol (j, 65, TMch[j]);
      enviocontrol (j, 5, TMch[j]);
      enviocontrol (j, 37, TMch[j]);
    }
}
  cambiapat = 1;
};
