/*
  gmorgan - ryhthm station software

  gmorgan.C  - A Midi processor.  
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu and Robert Vogel

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modified by Josep Andreu

  modified by Robert Vogel, vogelrl@gmx.com 2016
*/

#include "GMorgan.h"
#include "Chord.h"
#include <FL/fl_message.H>
#include "gettext.h"
#define _(string) gettext (string)
#include <iostream>
using namespace std;
#include <vector>
#include <string>
using
  std::string;
extern GMO
  gmo;

extern CHORD
  zing;
extern int
  globalchannel;
song
  S[129];

char
  KbChordSymbol[16];
char
  NombreAcorde[16];
char
  AName[16];
char
  NombreSong[80];

int
  l1,
  i,
  j,
  k,
  l,
  Pexitprogram,
  vum,
  vumvum,
  espera,
  UndoCount,
  programa,
  vavi,
  pr,
  pr1,
  tum,
  cambialo;
int
  la1;
int
  la3;
int
  la5;
int
  la7;

int
  splash,
  splashcounter,
  clicksplash;
int
  count,
  ulcount,
  ponfin;
int
  actunex,
  ttnp,
  cambiapat,
  tocadrum,
  sde,
  sdec;
int
  TempoSong,
  SNomi,
  InvMode;
int
  veloplus[65];
const char *
  FilePreset;
const char *
  FileDrums;
int
  Edr[62][129];
int
  Ectrl[8][38][129];
int
  paraplay,
  canaledit,
  lastcasdr,
  cambiacasdr;
int
  lastcascr,
  cambiacascr;

GMO::GMO ()
{

  //inicio de variables
  MidiMode = 1;
  cambiacascr = 0;
  cambiacasdr = 0;
  cambiaacorde = 0;
  MTempo = 0;
  cttemp = 0;
  valorctrl = 0;
  canaledit = 1;
  ctrledit = 0;
  MTlsb = 64;
  MTmsb = 64;
  DataLSB = 0;
  DataMSB = 0;
  Hay = 0;
  MasterVolume = 1;
  MasterON = 0;
  StyleSelect = 0;
  PatternSelect = 1;
  SoundSelect = 0;
  MutesOnOff = 0;
  ultimotick = 0;
  paraplay = 0;
  grabaconta = 0;
  reproduccion = 0;
  grabacion = 0;
  TresCinco = 3;
  DosCuatro = 2;
  bplay = 0;
  VeloMixer = 0;
  anticipa = 0;
  KeybON = 0;
  dredit = 0;
  InvMode = 1;
  inversion = 1;
  TempoSong = 120;
  SNomi = 4;
  BPW = 0;
  veloW = 0;
  ttnp = 0;
  finito = 0;
  ponfin = 0;
  stst = 0;
  vum = 0;
  vumvum = 0;
  bpm = 240;
  espera = 0;
  sd = 1;
  cdn = 36;
  sbar = 1;
  sp = 1;
  ss = 1;
  st = 1;
  sposi = 0;
  semi = 0;
  selmix = 1;
  nextp = 0;
  tick = 0;
  negra = 0;
  ncompas = 0;
  count = 0;
  queue_id = 0;
  elbar = 1;
  HMode = 0;
  MiNominator = 4;
  MiBars = 1;
  MiBaseKey = 0;
  MiDrumsMCh = 10;
  MiBassMCh = 0;
  MiAcc1MCh = 0;
  MiAcc1MCh = 0;
  MiAcc2MCh = 0;
  MiAcc3MCh = 0;
  MiAcc4MCh = 0;
  MiAcc5MCh = 0;
  Mmodebass = 2;
  Mmodeacc2 = 2;
  Mmodeacc4 = 2;
  MiStart = 1;

  genwindow = 0;
  bzero (ElEstilo, sizeof (ElEstilo));
  strcpy (ElEstilo, "Empty");
  GUIPlay = 0;
  WGUIP = 0;
  ABOW = 0;
  PFEW = 0;
  DNNWE = 0;
  for (i = 1; i < 12; i++)
    {
      reverb[i] = 0;
      chorus[i] = 0;
      progch[i] = 0;
      BankMSB[i] = 0;
      BankLSB[i] = 0;
      pan[i] = 64;
      volume[i] = 100;
      Pon[i] = 0;
      Ptime[i] = 0;
      octa[i] = 0;
      OnOff[i] = 0;
      if (i < 5)
	{	
	lowvel[i] = 0;
	hivel[i] = 199;
	lonote[i] = 0;
	hinote[i] = 128;
	}
    }
  BankMSB[8] = 1;
  BankLSB[8] = 1;

  memset (S, 0, sizeof S);

  newsong ();

  memset (EG, 0, sizeof EG);
  memset (GP, 0, sizeof GP);

// values for harmonization... 
  strcpy (HM[0].Name, "Unison");
  HM[0].notes = 0;
  HM[0].dist = 0;
  HM[0].nnu = 0;

  strcpy (HM[1].Name, "Thirds");
  HM[1].notes = 1;
  HM[1].dist = -4;
  HM[1].nnu = 0;

  strcpy (HM[2].Name, "Sixths");
  HM[2].notes = 1;
  HM[2].dist = -7;
  HM[2].nnu = 0;

  strcpy (HM[3].Name, "Triad 1");
  HM[3].notes = 2;
  HM[3].dist = -1;
  HM[3].nnu = 0;

  strcpy (HM[4].Name, "Triad 2");
  HM[4].notes = 2;
  HM[4].dist = -3;
  HM[4].nnu = 0;

  strcpy (HM[5].Name, "Block Chords");
  HM[5].notes = 4;
  HM[5].dist = -1;
  HM[5].nnu = 0;

  strcpy (HM[6].Name, "Drop 2");
  HM[6].notes = 4;
  HM[6].dist = -3;
  HM[6].nnu = 0;

  strcpy (HM[7].Name, "Open ");
  HM[7].notes = 4;
  HM[7].dist = -3;
  HM[7].nnu = 0;

//rlv initial midi channel assignment for accompaniment.
  TMch[1] = 0;
  TMch[2] = 1;
  TMch[3] = 2;
  TMch[4] = 3;
  TMch[5] = 4;
  TMch[6] = 5;
  TMch[7] = 6;
  TMch[8] = 9;
  TMch[9] = 7;
  TMch[10] = 8;
  TMch[11] = 10;
  TMch[12] = 11;
  TMch[13] = 12;
  TMch[14] = 13;

  v1highMidi = 60;
  v1lowMidi = 0;
  v1highVelocity = 199;
  v1lowVelocity = 0;
  v2highMidi = 60;
  v2lowMidi = 0;
  v2highVelocity = 199;
  v2lowVelocity = 0;
  v3highMidi = 128;
  v3lowMidi = 60;
  v3highVelocity = 199;
  v3lowVelocity = 0;
  v4highMidi = 128;
  v4lowMidi = 60;
  v4highVelocity = 199;
  v4lowVelocity = 0;

  memset (Prog, 0, sizeof Prog);

  for (i = 1; i <= 100; i++)
    {
      strcpy (Prog[i].Nom, "Empty");


      Prog[i].pattern = 7;
      Prog[i].bpm = 120;
      Prog[i].transpose = 0;
      Prog[i].style = 1;

      for (j = 1; j <= 4; j++)
	{
	  Prog[i].detune[j] = 0;
	  Prog[i].reverb[j] = 0;
	  Prog[i].chorus[j] = 0;
	  Prog[i].progch[j] = 0;
	  Prog[i].BankMSB[j] = 0;
	  Prog[i].BankLSB[j] = 0;
	  Prog[i].pan[j] = 64;
	  Prog[i].volume[j] = 100;
	  Prog[i].Pon[j] = 0;
	  Prog[i].Ptime[j] = 0;
	  Prog[i].octa[j] = 0;
	  Prog[i].lowvel[j] = 0;
	  Prog[i].hivel[j] = 199;
	  Prog[i].lonote[j] = 0;
	  Prog[i].hinote[j] = 128;
	}
    }


  memset (Styl, 0, sizeof Styl);

  for (i = 1; i <= 100; i++)

    {

      strcpy (Styl[i].Nom, "Empty");

      Styl[i].Intro = 0;
      Styl[i].Var1 = 0;
      Styl[i].Var2 = 0;
      Styl[i].Fill1 = 0;
      Styl[i].Fill2 = 0;
      Styl[i].Ending = 0;
      Styl[i].bpm = 120;
      Styl[i].startP = 99;
      Styl[i].programa = 1;

    }



  memset (Rt, 0, sizeof Rt);


  for (i = 0; i < 500; i++)
    patternclear (i);


  for (i = 0; i < 65; i++)
    veloplus[i] = 0;


  strcpy (NC[0].Nom, "C");
  strcpy (NC[1].Nom, "Db");
  strcpy (NC[2].Nom, "D");
  strcpy (NC[3].Nom, "Eb");
  strcpy (NC[4].Nom, "E");
  strcpy (NC[5].Nom, "F");
  strcpy (NC[6].Nom, "Gb");
  strcpy (NC[7].Nom, "G");
  strcpy (NC[8].Nom, "Ab");
  strcpy (NC[9].Nom, "A");
  strcpy (NC[10].Nom, "Bb");
  strcpy (NC[11].Nom, "B");


  strcpy (NCE[0].Nom, "C");
  NCE[0].note = 0;
  strcpy (NCE[1].Nom, "Db");
  NCE[1].note = 1;
  strcpy (NCE[2].Nom, "D");
  NCE[2].note = 2;
  strcpy (NCE[3].Nom, "Eb");
  NCE[3].note = 3;
  strcpy (NCE[4].Nom, "E");
  NCE[4].note = 4;
  strcpy (NCE[5].Nom, "F");
  NCE[5].note = 5;
  strcpy (NCE[6].Nom, "Gb");
  NCE[6].note = 6;
  strcpy (NCE[7].Nom, "G");
  NCE[7].note = -5;
  strcpy (NCE[8].Nom, "Ab");
  NCE[8].note = -4;
  strcpy (NCE[9].Nom, "A");
  NCE[9].note = -3;
  strcpy (NCE[10].Nom, "Bb");
  NCE[10].note = -2;
  strcpy (NCE[11].Nom, "B");
  NCE[11].note = -1;
  strcpy (NCE[12].Nom, "C#");
  NCE[12].note = 1;
  strcpy (NCE[13].Nom, "D#");
  NCE[13].note = 3;
  strcpy (NCE[14].Nom, "E#");
  NCE[14].note = 5;
  strcpy (NCE[15].Nom, "F#");
  NCE[15].note = 6;
  strcpy (NCE[16].Nom, "G#");
  NCE[16].note = -4;
  strcpy (NCE[17].Nom, "A#");
  NCE[17].note = -2;
  strcpy (NCE[18].Nom, "B#");
  NCE[18].note = 0;

// Inicia TipoChords

//Maj7

  TCh[1].ter = 0;
  TCh[1].qui = 0;
  TCh[1].sep = 0;

//7

  TCh[2].ter = 0;
  TCh[2].qui = 0;
  TCh[2].sep = -1;

//-7

  TCh[3].ter = -1;
  TCh[3].qui = 0;
  TCh[3].sep = -1;

//-7(b5)

  TCh[4].ter = -1;
  TCh[4].qui = -1;
  TCh[4].sep = -1;

//dis

  TCh[5].ter = -1;
  TCh[5].qui = -1;
  TCh[5].sep = -2;

//aug7

  TCh[6].ter = 0;
  TCh[6].qui = +1;
  TCh[6].sep = -1;


//7Sus4

  TCh[7].ter = +1;
  TCh[7].qui = 0;
  TCh[7].sep = -1;


//Triad Maj

  TCh[8].ter = 0;
  TCh[8].qui = 0;
  TCh[8].sep = +1;


// Triad Min

  TCh[9].ter = -1;
  TCh[9].qui = 0;
  TCh[9].sep = +1;


// 6

  TCh[10].ter = 0;
  TCh[10].qui = 0;
  TCh[10].sep = -2;

// ****************************************************************************
// ****************************************************************************
// ****************************************************************************

  strcpy (INames[1].Name, gettext ("Bass Drum"));
  strcpy (INames[2].Name, gettext ("Snares"));
  strcpy (INames[3].Name, gettext ("Cymballs"));
  strcpy (INames[4].Name, gettext ("Toms"));
  strcpy (INames[5].Name, gettext ("Percussion"));
  strcpy (INames[6].Name, gettext ("Bass Line"));
  strcpy (INames[7].Name, gettext ("Piano Soli"));
  strcpy (INames[8].Name, gettext ("Guitar Soli"));
  strcpy (INames[9].Name, gettext ("String Soli"));
  strcpy (INames[10].Name, gettext ("Brass  Soli"));
  strcpy (INames[11].Name, gettext ("Piano Melodic"));
  strcpy (INames[12].Name, gettext ("Guitar Melodic"));
  strcpy (INames[13].Name, gettext ("String Melodic"));
  strcpy (INames[14].Name, gettext ("Brass Melodic"));
  strcpy (INames[15].Name, gettext ("Piano Harmonic"));
  strcpy (INames[16].Name, gettext ("Guitar Harmonic"));
  strcpy (INames[17].Name, gettext ("String Harmonic"));
  strcpy (INames[18].Name, gettext ("Brass Harmonic"));


  //ALSA init
  snd_seq_open (&MidiOutPuerto[1].midi_out, "hw", SND_SEQ_OPEN_OUTPUT, 0);
  snd_config_update_free_global ();
  snd_seq_open (&MidiInPuerto[1].midi_in, "hw", SND_SEQ_OPEN_INPUT, 0);
  snd_config_update_free_global ();
  char portname[50];
  sprintf (portname, "gmorgan IN");
  pmidi_in = snd_seq_create_simple_port (MidiInPuerto[1].midi_in, portname,
					 SND_SEQ_PORT_CAP_WRITE |
					 SND_SEQ_PORT_CAP_SUBS_WRITE,
					 SND_SEQ_PORT_TYPE_APPLICATION);
  sprintf (portname, "gmorgan OUT");
  pmidi_out =
    snd_seq_create_simple_port (MidiOutPuerto[1].midi_out, portname,
				SND_SEQ_PORT_CAP_READ |
				SND_SEQ_PORT_CAP_SUBS_READ,
				SND_SEQ_PORT_TYPE_APPLICATION);
  FILE *fs;
  char temp[128];
  char nomfile[128];
  sprintf (nomfile, "%s%s", getenv ("HOME"), "/.gmorgan");
  if ((fs = fopen (nomfile, "r")) != NULL)
    {
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	{
	  for (i = 0; i <= (int) strlen (temp) - 2; i++)
	    MidiInPuerto[1].SetMidiIn[i] = temp[i];
	  MidiInPuerto[1].SMidiIn = MidiInPuerto[1].SetMidiIn;
	}
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	{

	  for (i = 0; i <= (int) strlen (temp) - 2; i++)
	    MidiOutPuerto[1].SetMidiOut[i] = temp[i];
	  MidiOutPuerto[1].SMidiOut = MidiOutPuerto[1].SetMidiOut;
	}
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	for (i = 0; i <= (int) strlen (temp) - 2; i++)
	  SoundsFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	for (i = 0; i <= (int) strlen (temp) - 2; i++)
	  PatternsFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	for (i = 0; i <= (int) strlen (temp) - 2; i++)
	  StylesFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	for (i = 0; i <= (int) strlen (temp) - 2; i++)
	  PresetFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	for (i = 0; i <= (int) strlen (temp) - 2; i++)
	  DrumNoteFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	for (i = 0; i <= (int) strlen (temp) - 2; i++)
	  SkinFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	for (i = 0; i <= (int) strlen (temp) - 2; i++)
	  SkinNombre[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      sscanf (temp, "%2d", &MutesOnOff);
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	for (i = 0; i <= (int) strlen (temp) - 2; i++)
	  HelpFilename[i] = temp[i];
	cout << "helpfile: " << HelpFilename << endl;
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen (temp) > 2)
	for (i = 0; i <= (int) strlen (temp) - 2; i++)
	  LibStylesFilename[i] = temp[i];
      fclose (fs);
    }

  if (SoundsFilename[0] != '0')
    {
      prime = 1;
      ulti = 100;
      loadfile (SoundsFilename);
    }

  if (PatternsFilename[0] != '0')
    {
      prime = 1;
      ulti = 500;
      loadpatt (PatternsFilename);
    }


  if (StylesFilename[0] != '0')
    {
      prime = 1;
      ulti = 100;
      loadstyl (StylesFilename);
    }


  if (PresetFilename[0] != '0')
    {
      prime = 1;
      ulti = 100;
      loadpreset (PresetFilename);
    }

  if (DrumNoteFilename[0] != '0')
    {
      prime = 1;
      ulti = 100;
      loaddrumset (DrumNoteFilename);
    }

  if (SkinFilename[0] != '0')
    {
      BuscaSkindir ();
    }
  espera = 1;
  sp = 1;
  MeteMixerMidi (sp);
};

GMO::~GMO ()
{
//  cout << " midi input port is " << MidiInPuerto[1].midi_in << endl;
//  cout << " midi out port is " << MidiOutPuerto[1].midi_out << endl;
  snd_seq_close (MidiOutPuerto[1].midi_out);
  snd_seq_close (MidiInPuerto[1].midi_in);
};

// *************************************************************************
// *************************************************************************
// Display the current chord. 
// *************************************************************************
// *************************************************************************
void
GMO::ChangeChord ()
{
  std::string displaychordout = zing.GetCurrentChordsym ();
  strcpy (Delacorde, displaychordout.c_str ());
  if (Delacorde != "")
    {
      sprintf (AName, "%s", Delacorde);
      if (strcmp (AName, NombreAcorde) != 0)
	{
	  strcpy (NombreAcorde, AName);
	  cambialo = 1;
	}
    }
};

// *************************************************************************
// *************************************************************************
// rlv main loop . 
// *************************************************************************
// *************************************************************************

void
GMO::organo ()
{
  if (stst == 0)
    return;
  tick = get_tick ();
  if ((tick - atick) >= 64)
    {
      atick = tick;
      semi++;
      if (semi == 5)
	{
	  semi = 1;
	  negra++;
	  count++;
	  if (count >= Rt[sp].blackn + 1)
	    {
	      elbar++;
	      if (elbar > Rt[sp].bars)
		elbar = 1;
	      negra = 0;
	      count = 1;
	      ncompas++;
	      sprintf (elbart, "%d", ncompas + 1);
// 
//	      if ((bplay == 0) && (GUIPlay == 1))
//rlv	Note: Guided Play can override batch play settings.
	      if (GUIPlay == 1)
		MiraGuia ();
	      if (bplay)
		{
		  if (S[nb].fin == 1)
		    {
		      finito = 1;
		      bplay = 0;
		      KeybON = 0;
		      ncompas = 0;	
		      return;
		    }
		  sprintf (elnb, "%d", nb);
		  nb = mirasaltos (nb);
		  ncompas = nb - 1;
		  sprintf (elnb, "%d", nb);
		
	      if (GUIPlay == 0)
		{
		  if ((S[nb].pattern != 0) && (S[nb].pattern != sp))
		    {
		      sp = S[nb].pattern;
		      sposi = 0;
		      cambiapat = 1;
			cout << "at bar " << nb << " changing pattern to " << sp << endl;
		      ChangePattern (sp);
		    }
		}
		}
	    }
	  if ((bplay) && (MTempo))
	    UsaTempoTrack ();
	}
      GeneraChord ();
      accompaniment ();
    }
};

// ***************************************************************************
// replay the recording.  
// **************************************************************************
void
GMO::EPlay ()
{
  int i;
  snd_seq_tick_time_t ptick;
  ptick = get_tick ();
  if (ptick > ultimotick)
    paraplay = 1;
  for (i = 0; i < 256; i++)
    {
      if (EG[cs].tipo == 0)
	cs++;
      if ((EG[cs].tick - ptick) < 1024)
	{
	  if (EG[cs].tipo != 0)
	    {
	      PonPlay (EG[cs].tipo, EG[cs].tick, EG[cs].nota, EG[cs].canal,
		       EG[cs].velocity, EG[cs].length);
	      cs++;
	      if ((EG[cs].tick + EG[cs].length) > ultimotick)
		ultimotick = EG[cs].tick + EG[cs].length;
	    }
	}

    }
};

// ***********************************************************************************************
// play it.
// ***********************************************************************************************
void
GMO::PonPlay (int tipo, snd_seq_tick_time_t gtick, int gnota, int gcanal,
	      int gvelocity, int glength)
{
  snd_seq_event_t ev;
  snd_seq_ev_clear (&ev);
  switch (tipo)
    {
    case 1:
      snd_seq_ev_set_note (&ev, gcanal, gnota, gvelocity, glength);
      break;
    case 2:
      snd_seq_ev_set_note (&ev, gcanal, gnota, gvelocity, glength);
      break;
    case 3:
      snd_seq_ev_set_controller (&ev, gcanal, gnota, gvelocity);
      break;
    case 4:
      snd_seq_ev_set_pgmchange (&ev, gcanal, gnota);
      break;
    }
  if ((tipo > 0) && (tipo < 5))
    {
      snd_seq_ev_schedule_tick (&ev, queue_id, 0, gtick);
      snd_seq_ev_set_source (&ev, pmidi_in);
      snd_seq_ev_set_subs (&ev);
      snd_seq_event_output_direct (MidiOutPuerto[1].midi_out, &ev);
    }

};

// ********************************************************************************
// 
// ********************************************************************************
void
GMO::PonGraba (int tipo, snd_seq_tick_time_t gtick, int gnota, int gcanal,
	       int gvelocity, int glength, int gcontrol, int gvalue,
	       int gprograma)
{
  int i;
  grabaconta++;
  if (grabaconta >= 64000)
    printf (gettext ("Record Memory Full\n"));
  if (grabaconta < 64000)

    {
      switch (tipo)
	{
	case 1:
	  EG[grabaconta].tipo = tipo;
	  EG[grabaconta].tick = gtick;
	  EG[grabaconta].nota = gnota;
	  EG[grabaconta].canal = gcanal;
	  EG[grabaconta].velocity = gvelocity;
	  EG[grabaconta].length = glength;
	  break;
	case 2:
	  if (gvelocity != 0)
	    {
	      EG[grabaconta].tipo = tipo;
	      EG[grabaconta].tick = gtick;
	      EG[grabaconta].nota = gnota;
	      EG[grabaconta].canal = gcanal;
	      EG[grabaconta].velocity = gvelocity;
	      EG[grabaconta].length = glength;
	    }
	  if (gvelocity == 0)
	    {
	      for (i = grabaconta; i >= 1; i--)
		{
		  if ((EG[i].tipo == tipo) && (EG[i].canal == gcanal)
		      && (EG[i].nota == gnota))
		    {
		      EG[i].length = gtick - EG[i].tick;
		      grabaconta--;
		      break;

		    }
		}
	    }
	  break;

	case 3:
	  EG[grabaconta].tipo = tipo;
	  EG[grabaconta].tick = gtick;
	  EG[grabaconta].canal = gcanal;
	  EG[grabaconta].nota = gcontrol;
	  EG[grabaconta].velocity = gvalue;
	  break;

	case 4:
	  EG[grabaconta].tipo = tipo;
	  EG[grabaconta].tick = gtick;
	  EG[grabaconta].canal = gcanal;
	  EG[grabaconta].nota = gprograma;
	  break;
	}
    }
};


void
GMO::miranotam2 (int i)
{
  int k;
  int afundi;
  int sino = 0;
  k = 0;			// temporary rlv.
  if (ya == 0)
    {
      afundi = fundi;
      ya = 1;
    }
//      cout << i << "** miranotam2 fundi: " << fundi;
  switch (i)
    {
    case 2:
      lanota = Rt[sp].acc2n[0][sposi];
      break;
    case 3:
      lanota = Rt[sp].acc3n[0][sposi];
      break;
    case 4:
      lanota = Rt[sp].acc4n[0][sposi];
      break;
    case 5:
      lanota = Rt[sp].acc5n[0][sposi];
      break;
    }

  (lanota > 0) ? k = -1 : k = 1;
//      cout << " lanota: " << lanota;
/*       if (lanota > 0)
        {
        if ((lanota % 12 == 5) ||  (lanota == 5) ) adjustment = la3;
        if ((lanota % 12 == 8) ||  (lanota == 8) ) adjustment = la5; 
        if ((lanota % 12 == 0) ||  (lanota == 12)) adjustment = la1; 
        }
        else
        {
        if ((lanota == -9) || lanota % 12 == -9 ) adjustment = (4 -di1); 
        if ((lanota == -6) || lanota % 12 == -6 ) adjustment = (8 - (di1 + di2)); 
        if ((lanota == -2) || lanota % 12 == -2) adjustment = (10 - (di1 + di2 + di3)); 
        }
	cout << " adjustment " << adjustment << endl; 
        notabajo = lanota + afundi + k + 24;*/
//  notabajo = lanota + fundi + k + 24;
//      cout << " notabajo: " << notabajo << "-->";
//      Midi2Note(notabajo);
//      cout << endl;
     if (fundi != afundi)
     { 
     if (notabajo ==  1 + k + fundi + 24) sino = 1;
     if (notabajo ==  13 + k + fundi + 24) sino = 1;
     if (notabajo ==  26 + k + fundi + 24) sino = 1;
     if (notabajo ==  -13 + k + fundi + 24) sino = 1;
     if (notabajo ==  -25 + k + fundi + 24) sino = 1; 
     if (notabajo ==  5 + k + fundi + la3 + 24) sino = 1;
     if (notabajo ==  17 + k + fundi + la3 + 24) sino = 1;
     if (notabajo ==  29 + k + fundi + la3 + 24) sino = 1;
     if (notabajo == -9 + k + fundi + la3 + 24) sino = 1;
     if (notabajo == -21 + k + fundi + la3 + 24) sino = 1;
     if (notabajo == -33 + k + fundi + la3 + 24) sino = 1;
     if (notabajo ==  8 + k + fundi + la5  + 24) sino = 1;
     if (notabajo ==  20 + k + fundi + la5  + 24) sino = 1;
     if (notabajo ==  32 + k + fundi + la5  + 24) sino = 1;
     if (notabajo == -6 + k + fundi + la5 + 24) sino = 1;
     if (notabajo == -18 + k + fundi + la5 + 24) sino = 1;
     if (notabajo == -30 + k + fundi + la5 + 24) sino = 1;
     if (notabajo == 12 + k + fundi + la7 + 24) sino = 1;
     if (notabajo == 24 + k + fundi + la7 + 24) sino = 1;
     if (notabajo == 36 + k + fundi + la7 + 24) sino = 1; 
     if (notabajo == -2 + k + fundi + la7 + 24) sino = 1;        
     if (notabajo == -14 + k + fundi + la7 + 24) sino = 1;
     if (notabajo == -26 + k + fundi + la7 + 24) sino = 1; 
     if (sino ==0) notabajo = fundi + 24;
     }
};

void
GMO::miranotam3 (int i)
{

  int k;
//  cout << i << "***miranotam3 ** i= ";
  switch (i)
    {
    case 2:
      lanota = Rt[sp].acc2n[0][sposi];
      break;
    case 3:
      lanota = Rt[sp].acc3n[0][sposi];
      break;
    case 4:
      lanota = Rt[sp].acc4n[0][sposi];
      break;
    case 5:
      lanota = Rt[sp].acc5n[0][sposi];
      break;

    }

  (lanota > 0) ? k = -1 : k = 1;
  if (lanota > 12)
    lanota = lanota % 12;
  if (lanota < -12)
    lanota = (lanota % 12) - 12;
        switch(lanota)
        { 
        case -9:
	        lanota +=la3;
	        break;
        case -6:
	        lanota +=la5;
	        break;
        case -2:
	        lanota +=la7;
	        break;
        case 5:
	        lanota += la3;
	        break;
        case 8:
	        lanota += la5;
	        break;
        case 12:
	        lanota += la7;
	        break;
        
        } 
  notabajo = lanota + fundi + k + 24;
//  cout << "-->" << notabajo << ">>";
//  Midi2Note (notabajo);
//  cout << endl;
};

void
GMO::accompaniment ()
{
  int i, j;
  int note;
  int maxposi;
  int fillposi;
  int lavelo = 0;
  sposi++;
  if (mezcla != 0)
    {
      maxposi = Rt[sp].bars * Rt[sp].blackn * 4;
      fillposi = Rt[mezcla].bars * Rt[sp].blackn * 4;

      if (sposi > (maxposi - fillposi))
	{
	  sposi = sposi % (Rt[sp].blackn * 4);
	  sp = mezcla;
	  mezcla = 0;
	}
    }
  maxposi = Rt[sp].bars * Rt[sp].blackn * 4;
// stop it. we're done.
  if (finito == 1)
    {
      finito = 0;
      stst = 0;
      ponfin = 1;
      return;
    }
  if (sposi > maxposi)
    {
//      cout << " sposi = " << sposi << " maxposi " << maxposi << endl;
      sposi = 1;
      if (nextp != 0)
	{
	  sp = nextp;
	  elbar = 1;
	  nextpm = nextp;
	  nextp = 0;
	  actunex = 1;
	  ChangePattern (sp);
//      cout << " **** gmorgan.C **** MeteMixerMidi sp= " << sp <<  endl;
// rlv: No time for the next routine. It causes hiccups..
//      MeteMixerMidi(sp);
	}
    }
  if (OnOff[8])
    {
      for (i = 1; i <= 61; i++)
	{
	  if (Edr[i][sposi] != 0)
	    {
	      lavelo = Edr[i][sposi] + veloplus[i];
	      if (lavelo > 127)
		lavelo = 127;
	      if (lavelo < 0)
		lavelo = 0;
	      sacaev (TMch[8], i + 26, lavelo, 8);
	    }
	}
    }
// Accompaniment 1 plays the chord according to pattern rythm.
  if ((OnOff[5]) && (Rt[sp].acc1n[1][sposi] != 0))
    {
      if (Rt[sp].acc1n[0][sposi] != 0)
	duracion = (int) (TICKS4 + Rt[sp].acc1stlt) / Rt[sp].acc1n[0][sposi];
	note = fundi + 60 + transpose;
	note += (12 * Rt[sp].acc1octa);
//	cout << "Acc1 note = " << note << " duration: " << duracion << endl;
	harmonize(5,1,TMch[5],note,Rt[sp].acc1n[1][sposi],duracion);
	}
// Accompaniment 2 
  if ((OnOff[6]) && (Rt[sp].acc2n[0][sposi] != 0))
    {
      if (Rt[sp].acc2n[2][sposi] != 0)
	duracion = (int) (TICKS4 + Rt[sp].acc2stlt) / Rt[sp].acc2n[2][sposi];
      notabajo = zing.FindNote(Rt[sp].acc2n[0][sposi],0); 	
//	miranota (2);
      if (Rt[sp].octavate)
	notabajo += (12 * Rt[sp].acc2octa);
	note =  notabajo + 36 + transpose;
//	cout << "Acc2 mode is " << Rt[sp].acc2mode << " -->";
//	Midi2Note(note);
//	cout << "duration: " << duracion;
	if (Rt[sp].acc2mode > 0)
		{
		harmonize(Rt[sp].acc2mode,1,TMch[6],note,Rt[sp].acc2n[1][sposi],duracion);
		}
	else
		{
//	cout << "Acc2 octavate " << notabajo << endl;
		sacaev (TMch[6], notabajo + 36 + transpose, Rt[sp].acc2n[1][sposi],
		duracion);
		}

    }
// *****************************************************************************************************
// bass is 7.   
// *****************************************************************************************************
  if ((OnOff[7]) && (Rt[sp].basn[0][sposi] != 0))
    {
//      miranota (1);
      notabajo = zing.FindNote(Rt[sp].basn[0][sposi],0);
      notabajo += (12 * Rt[sp].bassocta);
      if (Rt[sp].basn[2][sposi] != 0)
	duracion = (int) (TICKS4 + Rt[sp].bassstlt) / Rt[sp].basn[2][sposi];
/*	If (musescore == 1)
		write to musescore
*/
//      cout << "****bass " << Rt[sp].basn[0][sposi] << " -->";
//      Midi2Note(notabajo);
//	cout << " duration: " << duration << endl;
      sacaev (TMch[7], notabajo + transpose, Rt[sp].basn[1][sposi], duracion);
    }
// *****************************************************************************************************
//  Acc 3.
// *****************************************************************************************************
  if ((OnOff[9]) && (Rt[sp].acc3n[0][sposi] != 0))
    {
//      cout << " OnOff[9] " << Rt[sp].
//	acc3n[0][sposi] << " acc3mode is " << Rt[sp].acc3mode << endl;
//	miranota (3);
      notabajo = zing.FindNote(Rt[sp].acc3n[0][sposi],0); 	
      if (Rt[sp].acc3n[2][sposi] != 0)
	duracion = (int) (TICKS4 + Rt[sp].acc3stlt) / Rt[sp].acc3n[2][sposi];
	notabajo += (12 * Rt[sp].acc3octa);
	note =  notabajo + 24 + transpose;
//	cout << "Acc3 mode is " << Rt[sp].acc3mode << " -->";
//	Midi2Note(note);
//	cout << endl;
	harmonize(Rt[sp].acc3mode,1,TMch[9],note,Rt[sp].acc3n[1][sposi],duracion);
    }

  if ((OnOff[10]) && (Rt[sp].acc4n[0][sposi] != 0))
    {
//	miranota (4);
      notabajo = zing.FindNote(Rt[sp].acc4n[0][sposi],0); 	
      notabajo += (12 * Rt[sp].acc4octa);
	note =  notabajo + 24 + transpose;
      if (Rt[sp].acc4n[2][sposi] != 0)
	duracion = (int) (TICKS4 + Rt[sp].acc4stlt) / Rt[sp].acc4n[2][sposi];
	harmonize(Rt[sp].acc4mode,1,TMch[10],note,Rt[sp].acc4n[1][sposi],duracion);
/*
      sacaev (TMch[10], notabajo + 48 + transpose, Rt[sp].acc4n[1][sposi],
	      duracion);
      if (Rt[sp].octavate4)
	sacaev (TMch[10], notabajo + 36 + transpose, Rt[sp].acc4n[1][sposi],
		duracion);

      if ((Rt[sp].terceras4) || (Rt[sp].sextas4))
	{

	  for (i = notabajo + laresta + 48 + transpose;
	       i >= notabajo + 36 + transpose; i--)
	    {
	      if ((i % 12 == la1) || (i % 12 == la3) || (i % 12 == la5)
		  || (i % 12 == la7))
		{
		  sacaev (TMch[10], i, Rt[sp].acc4n[1][sposi], duracion);
		  break;
		}
	    }
	}
*/
    }

  if ((OnOff[11]) && (Rt[sp].acc5n[0][sposi] != 0))
    {
//	  miranota (5);
      notabajo = zing.FindNote(Rt[sp].acc5n[0][sposi],0); 	
	note =  notabajo + 36 + transpose;
      if (Rt[sp].acc5n[2][sposi] != 0)
	duracion = (int) (TICKS4 + Rt[sp].acc5stlt) / Rt[sp].acc5n[2][sposi];
//      notabajo += (12 * Rt[sp].acc5octa);
	harmonize(Rt[sp].acc5mode,1,TMch[11],note,Rt[sp].acc5n[1][sposi],duracion);
/*
      sacaev (TMch[11], notabajo + 36 + transpose, Rt[sp].acc5n[1][sposi],
	      duracion);
      for (i = notabajo - 2 + 36; i >= notabajo - 14 + 36; i--)
	{
	  if ((i % 12 == la3) || (i % 12 == la7) || (i % 12 == la5)
	      || (i % 12 == la1))
	    {
	      conh++;
	      if (i >= 40)
		altinoti = i;
	      else
		altinoti = i + 12;
	      sacaev (TMch[11], altinoti + transpose, Rt[sp].acc5n[1][sposi],
		      duracion);
	      if (conh == 3)
		break;
	    }
	  if (conh == 3)
	    break;
	}
*/
    }
};

void
GMO::GeneraChord ()
{
  int i, labase;
  int aocta = 4;
  std::string chordstring;
  char elacorde[32];
  bzero (elacorde, sizeof (elacorde));

//determine where the chord is coming from. Could be from the sequencer, the soft keyboard, or an external keyboard.
//if KeybON then the soft keyboard is on, take it from there.

  if (bplay)
    {
      switch (count)
	{
	case 1:
	  strcpy (elacorde, S[nb].ch1);
	  break;
	case 2:
	  strcpy (elacorde, S[nb].ch2);
	  break;
	case 3:
	  strcpy (elacorde, S[nb].ch3);
	  break;
	case 4:
	  strcpy (elacorde, S[nb].ch4);
	  break;
	}
    }
  else
    {
      if (KeybON)
	{
	  zing.SetCurrentChordsym (KbChordSymbol);
	}
      std::string chordout = zing.GetCurrentChordsym ();
      strcpy (Delacorde, chordout.c_str ());
      strcpy (elacorde, Delacorde);
    }
  if ((bplay) && (anticipa))
    {
      anticipa = 0;
      strcpy (elacorde, S[nb + 1].ch1);
    }

  if (strlen (elacorde) == 0)
    {
      return;
    }
  if (elacorde == " ")
    return;

  if (strlen (elacorde) != 0)
    {
      strcpy (Delacorde, elacorde);
      cambiaacorde = 1;
      sprintf (AName, "%s", Delacorde);
      if (strcmp (AName, NombreAcorde) != 0)
	{
	  strcpy (NombreAcorde, AName);
	  cambialo = 1;
	}
//      cout << " gmorgan.C about to look up chord: " << Delacorde << endl;	
      chordstring.assign (Delacorde);
      int index;
      vector < int >midinotes = zing.Chordsym2Midi (chordstring, 4);
/*
      cout << chordstring << " midinotes vector "; 
      for (index = 0; index < midinotes.size (); ++index)
		{
		cout << midinotes.at (index) << "+";
		}
	cout << endl;
*/
      for (index = 0; index < midinotes.size (); ++index)
	{
	  if (index == 0)
	    {
	      if (midinotes.at (0) == 12)
		{
		  cout << "Bar #" << nb <<
		    " ==>Unrecognized Chord: " << chordstring <<
		    " rejected " << endl;
		  break;
		}
	      fundi = midinotes.at (0);
	    }
/*
	  if ((index == 1) && (midinotes.at (1) == 0))
	    {
	      cout << "*****>Chord not found: " << chordstring << " in bar " << nb << " index: " << index 
		<< endl;
	      break;
	    }
*/
	  for (i = 0; i < POLY; i++)
	    {
	      note_active[i] = 0;
	      rnote[i] = 0;
	    }
	    labase = (aocta * 12) + fundi;
	    vector < int > ChordNotes = zing.GetCurrentChordNotes ();
	     for (int cn = 0; cn < ChordNotes.size (); ++cn)
	        {
	        rnote[cn] = ChordNotes.at (cn) + labase;
	  	note_active[cn] = 1;
/*
	        cout << "  #" << cn << " " << rnote[cn] << ": " << "--> ";
	        Midi2Note (rnote[cn]);
	        cout << endl;
*/
            }
	}
    }	
};

// *****************************************************************************
// *****************************************************************************
// rlv Initialize for repeats. 
// *****************************************************************************
// *****************************************************************************
void
GMO::BuscaRepes ()
{
  int i;
  for (i = 1; i <= 128; i++)
    {
      if (S[i].times != 0)
	{
	  Repe[i].times = S[i].times;

	}
      else
	Repe[i].times = 0;

      if (S[i].atimes != 0)
	Salta[i].times = S[i].atimes;
      else
	Salta[i].times = 0;
      Salta[i].pasa = 0;
    }
};

// *****************************************************************************
// *****************************************************************************
// rlv determine repeats by looking at goto's in the current measure 
// *****************************************************************************
// *****************************************************************************
int
GMO::mirasaltos (int nextb)
{
  int LetterNo;
  if (strlen (S[nextb].go_to) != 0)
    {
      elchardm = S[nextb].go_to[0];
      if (elchardm > 90)
	elchardm -= 32;
      switch (elchardm)
	{
	case 'A':
	  LetterNo = 1;
	  break;
	case 'B':
	  LetterNo = 2;
	  break;
	case 'C':
	  LetterNo = 3;
	  break;
	case 'D':
	  LetterNo = 4;
	  break;
	case 'E':
	  LetterNo = 5;
	  break;
	case 'F':
	  LetterNo = 6;
	  break;
	case 'G':
	  LetterNo = 7;
	  break;
	case 'H':
	  LetterNo = 8;
	  break;
	}
      Repe[nextb].times--;
      if (Repe[nextb].times > 0)
	{
	  nextb = BuscaM (LetterNo);
	  cout << "going to letter " << elchardm << " bar: " << nextb << endl; 
	  return nextb;
	}
      else
	{
	  Repe[nextb].times = S[nextb].times;
//                              cout << "restoring bar " << nextb << " to " << S[nextb].times << endl;
	  nextb++;
	  return nextb;
	}
      sprintf (elnb, "%d", nextb);
      if (Repe[nextb].times == 0)
	{
	  Repe[nextb].times = S[nextb].times;
	}
    }

  if (strlen (S[nextb].go_af) != 0)
    {
      elchardm = S[nextb].go_af[0];
//                   cout << "counting to jump ahead to " << elchardm << " at bar " << nextb << endl;   
      if (elchardm > 90)
	elchardm -= 32;
      switch (elchardm)
	{
	case 'A':
	  LetterNo = 1;
	  break;
	case 'B':
	  LetterNo = 2;
	  break;
	case 'C':
	  LetterNo = 3;
	  break;
	case 'D':
	  LetterNo = 4;
	  break;
	case 'E':
	  LetterNo = 5;
	  break;
	case 'F':
	  LetterNo = 6;
	  break;
	case 'G':
	  LetterNo = 7;
	  break;
	case 'H':
	  LetterNo = 8;
	  break;
	}
      if (Salta[nextb].times > 0)
	{
	  Salta[nextb].pasa++;
	  if (Salta[nextb].pasa == Salta[nextb].times)
	    {
	      nextb = BuscaM (LetterNo);
	      Salta[nextb].pasa = 0;
              cout << " jumping ahead to letter " << elchardm << " bar " << nextb << endl;
	      return nextb;
	    }
	}
    }
  if (strlen (S[nextb].go_to) == 0)
    {
      nextb++;
      if (nextb > 127)
	nextb = 1;
//                               cout << " incremented " << nextb << endl;
    }
  else
    {
      Repe[nextb].times = S[nextb].times;
//                              cout << "restore count a at bar " << nextb << endl;
    }
//  cout << "returning nextb = " << nextb << endl;
  sprintf (elnb, "%d", nextb);
  return (nextb);
};
