/*
 *   gmorgan - a ryhthm station software
 *
     gmorgan.Chord.C  -  Chord Class header.
     Author: Robert Vogel

     This program is free software; you can redistribute it and/or modify
     it under the terms of version 2 of the GNU General Public License
     as published by the Free Software Foundation.

     This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License (version 2) for more details.

     You should have received a copy of the GNU General Public License
     (version2)
     along with this program; if not, write to the Free Software Foundation,
     Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/
#ifndef _CHORD_H
#define _CHORD_H	1
/*
 *       Chord functions by Robert Vogel 
 *
 *       */
using namespace std;
#include <vector>
#include <string>
#include <map>
void Midi2Note (int Midinote);
typedef multimap <string, vector<int> > MMAP_CHORD;
class CHORD
{
private:
  string CurrentChordsym;
/// MidiVector contains the intervals found in ChordTable, not actual midi notes. 
  std::vector < int >MidiVector;
/// Actual chord notes are in the ChordNotes vector.
  std::vector < int >ChordNotes;
// Private to CHORD.
// indexed by scale and note.
int Thirds [6][12];
int Sixths [6][12];
// Table to contain values for block chords. 
// scale, note, offset are the indices.
int BlockChords [6][12][3];
public:
  CHORD ();
  ~CHORD ();
  MMAP_CHORD midi2chordtable;
  int CurrentRoot;
// C2M
  std::string root;
  std::string chordtype;
// next item is the inversion no.
  int rootno;
// integer root of the current chord.
  int iroot;
  int scale;
    std::vector < int >loadedvector;
    std::vector < int >MajorScale;
    std::vector < int >MinorScale;
    std::vector < int >DominantScale;
    std::vector < int >DiminishedScale;
    std::vector < int >AugmentedScale;
    std::vector < int >HalfDiminishedScale;
    std::vector < int >CurrentScale;
    std::vector < int >CurrentThirds;
    std::vector < int >MajorThirds;
    std::vector < int >MinorThirds;
    std::vector < int >DominantThirds;
    std::vector < int >CurrentFifths;
    std::vector < int >MajorFifths;
    std::vector < int >MinorFifths;
    std::vector < int >DominantFifths;
    std::vector < int >CurrentSixths;
    std::vector < int >MajorSixths;
    std::vector < int >MinorSixths;
    std::vector < int >DominantSixths;
    std::vector < int >CurrentSevenths;
    std::vector < int >MajorSevenths;
    std::vector < int >MinorSevenths;
    std::vector < int >DominantSevenths;
    int GetThird (int topnote);
    int GetSixth (int topnote);	
    std::vector < int > GetCurrentBlock (int topnote);

/// This switch would initialize the Chord Table...if the code were not commented out.
/// You could uncomment it, but you shouldn't have to. 
  int RinitChordtable;
  int loadChordtable (char *filename);
  int FindScale (std::string Chordtype);
  int FindNote (int RelNote, int Acctype);
  void LoadScales ();
  string GetCurrentChordsym ();
  void SetCurrentChordsym (string Chordsym);
  void GenerateChordTable ();
  void DumpChordTable ();
  void SetChordTable (string chordtyp, std::vector < int >midiintervals);
  string Midi2Chordsym (std::vector < int >Intervals);
/// Given a chord symbol and an integer representing the desired type of chord, return a vector of midi notes. Voicing not included.
    std::vector < int >Chordsym2Midi (string Chordsym, int ChordMode);
    std::vector < int >Harmonize (int TopNote, int hmode);
// 
    std::vector < int >GetCurrentChordNotes ();
};
#endif /* chord.h */
