#pragma once

typedef enum _PIXEL_MODE
{
    DEFAULT_PIXEL_MODE = -1,
    LOW_BIT_DEPTH = 0,
    HIGH_BIT_DEPTH_STACKED,
    HIGH_BIT_DEPTH_INTERLEAVED,
    PIXEL_MODE_COUNT
} PIXEL_MODE;

typedef enum _DITHER_ALGORITHM
{
    // _DEPRECATED_DA_LOW = 0,
    DA_HIGH_NO_DITHERING = 1,
    DA_HIGH_ORDERED_DITHERING,
    DA_HIGH_FLOYD_STEINBERG_DITHERING,
    DA_16BIT_STACKED,
    DA_16BIT_INTERLEAVED,

    DA_COUNT,
    DA_USER_PARAM_MAX = DA_HIGH_FLOYD_STEINBERG_DITHERING
} DITHER_ALGORITHM;

typedef enum _RANDOM_ALGORITHM {
    RANDOM_ALGORITHM_OLD = 0,
    RANDOM_ALGORITHM_UNIFORM,
    RANDOM_ALGORITHM_GAUSSIAN,
    RANDOM_ALGORITHM_COUNT
} RANDOM_ALGORITHM;

typedef enum _OPTIMIZATION_MODE {
    IMPL_AUTO_DETECT = -1,
    IMPL_C = 0,
    IMPL_SSE2,
    IMPL_SSSE3,
    IMPL_SSE4,

    IMPL_COUNT
} OPTIMIZATION_MODE;