/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.asymmetric.ec;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Hashtable;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JDKKeyPairGenerator;
import org.bouncycastle.jce.provider.ProviderUtil;
import org.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public abstract class KeyPairGenerator
extends JDKKeyPairGenerator {
    public KeyPairGenerator(String string) {
        super(string);
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECGOST3410
    extends EC {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class EC
    extends KeyPairGenerator {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        Object ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        private static Hashtable ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
        }

        public EC(String string) {
            super(string);
            this.algorithm = string;
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
            this.ecParams = ecParameters.get(new Integer(n));
            if (this.ecParams != null) {
                try {
                    this.initialize((ECGenParameterSpec)this.ecParams, secureRandom);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            } else {
                throw new InvalidParameterException("unknown key size.");
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec instanceof org.bouncycastle.jce.spec.ECParameterSpec) {
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (org.bouncycastle.jce.spec.ECParameterSpec)algorithmParameterSpec;
                this.ecParams = algorithmParameterSpec;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()), secureRandom);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (algorithmParameterSpec instanceof ECParameterSpec) {
                ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
                this.ecParams = algorithmParameterSpec;
                ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
                ECPoint eCPoint = EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCCurve, eCPoint, eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor())), secureRandom);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                Object object;
                if (this.algorithm.equals("ECGOST3410")) {
                    object = ECGOST3410NamedCurves.getByName(((ECGenParameterSpec)algorithmParameterSpec).getName());
                    if (object == null) {
                        throw new InvalidAlgorithmParameterException("unknown curve name: " + ((ECGenParameterSpec)algorithmParameterSpec).getName());
                    }
                    this.ecParams = new ECNamedCurveSpec(((ECGenParameterSpec)algorithmParameterSpec).getName(), ((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getG(), ((ECDomainParameters)object).getN(), ((ECDomainParameters)object).getH(), ((ECDomainParameters)object).getSeed());
                } else {
                    object = X962NamedCurves.getByName(((ECGenParameterSpec)algorithmParameterSpec).getName());
                    if (object == null) {
                        object = SECNamedCurves.getByName(((ECGenParameterSpec)algorithmParameterSpec).getName());
                        if (object == null) {
                            object = NISTNamedCurves.getByName(((ECGenParameterSpec)algorithmParameterSpec).getName());
                        }
                        if (object == null) {
                            object = TeleTrusTNamedCurves.getByName(((ECGenParameterSpec)algorithmParameterSpec).getName());
                        }
                        if (object == null) {
                            throw new InvalidAlgorithmParameterException("unknown curve name: " + ((ECGenParameterSpec)algorithmParameterSpec).getName());
                        }
                    }
                    this.ecParams = new ECNamedCurveSpec(((ECGenParameterSpec)algorithmParameterSpec).getName(), ((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getG(), ((X9ECParameters)object).getN(), ((X9ECParameters)object).getH(), ((X9ECParameters)object).getSeed());
                }
                object = (ECParameterSpec)this.ecParams;
                ECCurve eCCurve = EC5Util.convertCurve(((ECParameterSpec)object).getCurve());
                ECPoint eCPoint = EC5Util.convertPoint(eCCurve, ((ECParameterSpec)object).getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCCurve, eCPoint, ((ECParameterSpec)object).getOrder(), BigInteger.valueOf(((ECParameterSpec)object).getCofactor())), secureRandom);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (algorithmParameterSpec == null && ProviderUtil.getEcImplicitlyCa() != null) {
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = ProviderUtil.getEcImplicitlyCa();
                this.ecParams = algorithmParameterSpec;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()), secureRandom);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (algorithmParameterSpec == null && ProviderUtil.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("EC Key Pair Generator not initialised");
            }
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            if (this.ecParams instanceof org.bouncycastle.jce.spec.ECParameterSpec) {
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (org.bouncycastle.jce.spec.ECParameterSpec)this.ecParams;
                return new KeyPair(new JCEECPublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec), new JCEECPrivateKey(this.algorithm, eCPrivateKeyParameters, eCParameterSpec));
            }
            if (this.ecParams == null) {
                return new KeyPair(new JCEECPublicKey(this.algorithm, eCPublicKeyParameters), new JCEECPrivateKey(this.algorithm, eCPrivateKeyParameters));
            }
            ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecParams;
            return new KeyPair(new JCEECPublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec), new JCEECPrivateKey(this.algorithm, eCPrivateKeyParameters, eCParameterSpec));
        }

        static {
            ecParameters.put(new Integer(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(new Integer(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(new Integer(256), new ECGenParameterSpec("prime256v1"));
        }
    }
}

