/*
 * Decompiled with CFR 0.152.
 */
package bdvm.vm;

import bdvm.vm.BDVMException;
import bdvm.vm.BDVMInterface;
import bdvm.vm.bdsvm_player_interface;
import bdvm.vm.common;
import bdvm.vm.constants;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class BDVM
implements BDVMInterface {
    public static final String versionString = "BDVM 0.1.5";
    public static final int MEMSIZE = 0x400000;
    private static final int MASK_DW = 0x3FFFFC;
    private static final int MASK_W = 0x3FFFFE;
    private static final int MASK_B = 0x3FFFFF;
    private static final int MASK_UNS = Integer.MAX_VALUE;
    private static final int[] watchDogDecrementTable = new int[]{1, 1, 1, 4, 16, 16, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 2, 1, 4, 4, 4, 4, 2, 4, 4, 2, 0, 6, 1, 1, 1, 1, 1};
    private final bdsvm_player_interface vpi;
    private File mountpoint = null;
    public int statusExecutedTrap;
    public int statusExecutionInterruption;
    public final int[] R = new int[32];
    public final byte[] memory = new byte[0x400000];
    public final ByteBuffer mem8 = ByteBuffer.wrap(this.memory);
    public final ShortBuffer mem16;
    public final IntBuffer mem32;
    public long watchDogCounter;
    public int pc;
    public long instructionCounter;
    public long trapCounter;
    public long breakCounter;
    private int IF;
    private boolean suspend = false;

    public BDVM() {
        this.vpi = new bdsvm_player_interface(this);
        this.mem8.order(ByteOrder.BIG_ENDIAN);
        this.mem16 = this.mem8.asShortBuffer();
        this.mem32 = this.mem8.asIntBuffer();
    }

    @Override
    public String getVersionString() {
        return versionString;
    }

    @Override
    public void initVM(File mountpoint, byte[] vid) throws BDVMException {
        try {
            this.initVM(mountpoint, 4096);
            this.loadFile("BDSVM/00000.svm");
            this.vpi.reset();
            if (vid == null) {
                vid = new byte[16];
                Arrays.fill(vid, (byte)0);
            }
            this.vpi.setVolumeId(vid, 0);
        }
        catch (Exception ex) {
            throw new BDVMException("Error initializing the BDVM", ex);
        }
    }

    @Override
    public void run() {
        this.suspend = false;
        do {
            this.step();
        } while (!this.suspend);
    }

    @Override
    public byte[] getRAWConversionTable() {
        return this.vpi.getConvTab().toByteArray();
    }

    public void loadFile(String filename) throws Exception {
        int i;
        DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(this.mountpoint, filename))));
        byte[] magicNumBuf = new byte[8];
        input.read(magicNumBuf);
        if (!new String(magicNumBuf).equals("BDSVM_CC")) {
            throw new Exception("Magic number check failed");
        }
        input.skip(12L);
        int length = input.readInt();
        this.mem8.rewind();
        for (i = 0; i < length; ++i) {
            this.mem8.put(input.readByte());
        }
        for (i = 0; i < 4095; ++i) {
            this.mem8.put(i, (byte)0);
        }
        this.mem8.position(length);
        while (this.mem8.hasRemaining()) {
            this.mem8.put((byte)0);
        }
        input.close();
    }

    public void initVM(File mountpoint, int pcStartOffset) throws Exception {
        this.mountpoint = mountpoint;
        this.pc = pcStartOffset;
        this.watchDogCounter = Integer.MAX_VALUE;
        this.breakCounter = 0L;
        for (int i = 0; i < 32; ++i) {
            this.R[i] = 0;
        }
        this.instructionCounter = 0L;
        this.trapCounter = 0L;
        this.statusExecutedTrap = 0;
        this.statusExecutionInterruption = 0;
    }

    public bdsvm_player_interface getVPI() {
        return this.vpi;
    }

    public File getMountpoint() {
        return this.mountpoint;
    }

    public void SetTimer(int cycles) {
        this.watchDogCounter = cycles;
    }

    public int GetProgramCounter() {
        return this.pc;
    }

    public void SetProgramCounter(int address) {
        this.pc = address & 0x3FFFFC;
    }

    public int GetInstructionFilter() {
        return this.IF;
    }

    public int ReadRegister(int register) {
        return this.R[register];
    }

    public byte[] ReadMemory8(int address, int length) {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = this.mem8.get(address + i & 0x3FFFFF);
        }
        return buffer;
    }

    public long ReadMemory32(int address) {
        long value = (long)this.mem32.get((address & 0x3FFFFC) >> 2) << 32 >>> 32;
        return value;
    }

    public long[] ReadMemory32(int address, int length) {
        long[] buffer = new long[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = (long)this.mem32.get((address + (i << 2) & 0x3FFFFC) >> 2) << 32 >>> 32;
        }
        return buffer;
    }

    public void WriteMemory8(byte[] buffer, int address, int length) {
        for (int i = 0; i < length; ++i) {
            this.mem8.put(address + i & 0x3FFFFF, buffer[i]);
        }
    }

    public void WriteMemory32(int value, int address) {
        this.mem32.put((address & 0x3FFFFC) >> 2, value);
    }

    public void WriteMemory32(int[] buffer, int address, int length) {
        for (int i = 0; i < length; ++i) {
            this.mem32.put((address + (i << 2) & 0x3FFFFC) >> 2, buffer[i]);
        }
    }

    public void setTrapReturnValue(int returnValue) {
        this.R[1] = returnValue;
    }

    public void step() {
        this.statusExecutedTrap = 0;
        this.statusExecutionInterruption = 0;
        ++this.instructionCounter;
        this.pc &= 0x3FFFFC;
        int i = this.IF ^ this.mem32.get(this.pc >> 2);
        int cmd = i >>> 26;
        int d = i >>> 21 & 0x1F;
        int s1 = i >>> 16 & 0x1F;
        int s2 = i >>> 11 & 0x1F;
        int Iimm = i & 0xFFFF;
        int IimmS = i << 16 >> 16;
        int JimmS = i << 6 >> 6;
        this.pc += 4;
        this.pc &= 0x3FFFFC;
        switch (cmd) {
            case 1: {
                this.R[d] = this.R[s1] + this.R[s2];
                break;
            }
            case 2: {
                this.R[d] = this.R[s1] - this.R[s2];
                break;
            }
            case 3: {
                this.R[d] = this.R[s1] * this.R[s2];
                break;
            }
            case 4: {
                if (this.R[s2] != 0) {
                    this.R[d] = this.R[s1] / this.R[s2];
                    break;
                }
                if (this.R[s2] == 0) {
                    this.R[d] = 0;
                    break;
                }
            }
            case 5: {
                if (common.unsigned(this.R[s2]) != 0L) {
                    this.R[d] = (int)(common.unsigned(this.R[s1]) / common.unsigned(this.R[s2]));
                    break;
                }
                if (common.unsigned(this.R[s2]) == 0L) {
                    this.R[d] = 0;
                    break;
                }
            }
            case 6: {
                this.R[d] = this.R[s1] << (this.R[s2] & 0x1F);
                break;
            }
            case 7: {
                this.R[d] = this.R[s1] >>> (this.R[s2] & 0x1F);
                break;
            }
            case 8: {
                this.R[d] = this.R[s1] >> (this.R[s2] & 0x1F);
                break;
            }
            case 9: {
                this.R[d] = this.R[s1] & this.R[s2];
                break;
            }
            case 10: {
                this.R[d] = this.R[s1] | this.R[s2];
                break;
            }
            case 11: {
                this.R[d] = this.R[s1] ^ this.R[s2];
                break;
            }
            case 12: {
                this.R[d] = this.R[s1] == this.R[s2] ? 1 : 0;
                break;
            }
            case 13: {
                this.R[d] = this.R[s1] != this.R[s2] ? 1 : 0;
                break;
            }
            case 14: {
                this.R[d] = this.R[s1] < this.R[s2] ? 1 : 0;
                break;
            }
            case 15: {
                this.R[d] = this.R[s1] < this.R[s2] ^ this.R[s1] < 0 ^ this.R[s2] < 0 ? 1 : 0;
                break;
            }
            case 16: {
                this.R[d] = this.R[s1] > this.R[s2] ? 1 : 0;
                break;
            }
            case 17: {
                this.R[d] = this.R[s1] > this.R[s2] ^ this.R[s1] < 0 ^ this.R[s2] < 0 ? 1 : 0;
                break;
            }
            case 18: {
                this.R[d] = this.R[s1] <= this.R[s2] ? 1 : 0;
                break;
            }
            case 19: {
                this.R[d] = this.R[s1] <= this.R[s2] ^ this.R[s1] < 0 ^ this.R[s2] < 0 ? 1 : 0;
                break;
            }
            case 20: {
                this.R[d] = this.R[s1] >= this.R[s2] ? 1 : 0;
                break;
            }
            case 21: {
                this.R[d] = this.R[s1] >= this.R[s2] ^ this.R[s1] < 0 ^ this.R[s2] < 0 ? 1 : 0;
                break;
            }
            case 22: {
                this.pc = this.R[s1];
                break;
            }
            case 23: {
                this.R[31] = this.pc;
                this.pc = this.R[s1];
                break;
            }
            case 24: {
                this.R[d] = this.R[s1] + IimmS;
                break;
            }
            case 25: {
                this.R[d] = this.R[s1] + Iimm;
                break;
            }
            case 26: {
                this.R[d] = this.R[s1] - IimmS;
                break;
            }
            case 27: {
                this.R[d] = this.R[s1] - Iimm;
                break;
            }
            case 28: {
                this.R[d] = this.R[s1] << (Iimm & 0x1F);
                break;
            }
            case 29: {
                this.R[d] = this.R[s1] >>> (Iimm & 0x1F);
                break;
            }
            case 30: {
                this.R[d] = this.R[s1] >> (Iimm & 0x1F);
                break;
            }
            case 31: {
                this.R[d] = this.R[s1] & Iimm;
                break;
            }
            case 32: {
                this.R[d] = this.R[s1] | Iimm;
                break;
            }
            case 33: {
                this.R[d] = this.R[s1] ^ Iimm;
                break;
            }
            case 34: {
                this.R[d] = this.R[s1] == IimmS ? 1 : 0;
                break;
            }
            case 35: {
                this.R[d] = this.R[s1] != IimmS ? 1 : 0;
                break;
            }
            case 36: {
                this.R[d] = IimmS > this.R[s1] ? 1 : 0;
                break;
            }
            case 37: {
                this.R[d] = Iimm > this.R[s1] ^ this.R[s1] < 0 ? 1 : 0;
                break;
            }
            case 38: {
                this.R[d] = IimmS < this.R[s1] ? 1 : 0;
                break;
            }
            case 39: {
                this.R[d] = Iimm < this.R[s1] ^ this.R[s1] < 0 ? 1 : 0;
                break;
            }
            case 40: {
                this.R[d] = IimmS >= this.R[s1] ? 1 : 0;
                break;
            }
            case 41: {
                this.R[d] = Iimm >= this.R[s1] ^ this.R[s1] < 0 ? 1 : 0;
                break;
            }
            case 42: {
                this.R[d] = IimmS <= this.R[s1] ? 1 : 0;
                break;
            }
            case 43: {
                this.R[d] = Iimm <= this.R[s1] ^ this.R[s1] < 0 ? 1 : 0;
                break;
            }
            case 44: {
                this.pc = 0x3FFFFC & this.pc + JimmS;
                break;
            }
            case 45: {
                this.R[31] = this.pc;
                this.pc = 0x3FFFFC & this.pc + JimmS;
                break;
            }
            case 46: {
                if (this.R[s1] != 0) break;
                this.pc += IimmS;
                break;
            }
            case 47: {
                if (this.R[s1] == 0) break;
                this.pc += IimmS;
                break;
            }
            case 48: {
                this.R[d] = Iimm << 16;
                break;
            }
            case 49: 
            case 50: {
                int b = this.mem8.get(this.R[s1] + IimmS & 0x3FFFFF);
                if (cmd == 50 && b < 0) {
                    b += 256;
                }
                this.R[d] = b;
                break;
            }
            case 51: 
            case 52: {
                int b = this.mem16.get((this.R[s1] + IimmS & 0x3FFFFE) / 2);
                if (cmd == 52 && b < 0) {
                    b += 65536;
                }
                this.R[d] = b;
                break;
            }
            case 53: {
                this.R[d] = this.mem32.get((this.R[s1] + IimmS & 0x3FFFFC) / 4);
                break;
            }
            case 54: {
                this.mem8.put(this.R[s1] + IimmS & 0x3FFFFF, (byte)(this.R[d] & 0xFF));
                break;
            }
            case 55: {
                this.mem16.put((this.R[s1] + IimmS & 0x3FFFFE) / 2, (short)(this.R[d] & 0xFFFF));
                break;
            }
            case 56: {
                this.mem32.put((this.R[s1] + IimmS & 0x3FFFFC) / 4, this.R[d]);
                break;
            }
            case 57: {
                this.watchDogCounter = Integer.MAX_VALUE;
                this.vpi.TRAP_handler(JimmS);
                this.statusExecutedTrap = 1;
                ++this.trapCounter;
                break;
            }
            case 58: {
                this.IF = this.R[s1];
                break;
            }
        }
        this.watchDogCounter -= (long)watchDogDecrementTable[cmd];
        if (this.watchDogCounter < 1L) {
            this.vpi.GetEvent();
            this.statusExecutionInterruption = 1;
            ++this.breakCounter;
        }
    }

    public void setSuspend(boolean suspend) {
        this.suspend = suspend;
    }

    public boolean isSuspended() {
        return this.suspend;
    }

    public long NextCmd() {
        long i = (long)this.IF ^ common.unsigned(this.mem32.get((0x3FFFFC & this.pc) / 4));
        return i >> 26;
    }

    public long getStackArg(int i) {
        return common.unsigned(this.mem32.get(this.R[29] / 4 + i));
    }

    public int getNextTrap() {
        long i = (long)this.IF ^ common.unsigned(this.mem32.get((0x3FFFFC & this.pc) / 4));
        long cmd = i >> 26;
        int JimmS = (int)(i << 6) >> 6;
        return cmd == 57L ? 0x3FFFFC & JimmS : 0;
    }

    public String disassemble(int address) {
        long I = (long)this.IF ^ common.unsigned(this.mem32.get((0x3FFFFC & address) / 4));
        int opCode = (int)(I >> 26) & 0x3F;
        int Rd = (int)(I >> 21 & 0x1FL);
        int Rs1 = (int)(I >> 16 & 0x1FL);
        int Rs2 = (int)(I >> 11 & 0x1FL);
        int imm16 = (int)I & 0xFFFF;
        int simm16 = imm16 << 16 >> 16;
        int imm26 = (int)I & 0x3FFFFFF;
        int simm26 = imm26 << 6 >> 6;
        switch (constants.OP_TYPE[opCode]) {
            case 0: {
                return String.format("%-6s", constants.OP_NAME[opCode]);
            }
            case 1: {
                return String.format("%-6sR%02d, R%02d, R%02d", constants.OP_NAME[opCode], Rd, Rs1, Rs2);
            }
            case 2: {
                return String.format("%-6sR%02d, R%02d, #$%04X", constants.OP_NAME[opCode], Rd, Rs1, imm16);
            }
            case 3: {
                return String.format("%-6sR%02d, %d(R%02d)", constants.OP_NAME[opCode], Rd, simm16, Rs1);
            }
            case 4: {
                return String.format("%-6s#$%04X", constants.OP_NAME[opCode], imm26);
            }
            case 5: {
                return String.format("%-6sR%02d, #$%04X", constants.OP_NAME[opCode], Rs1, address + 4 + simm16);
            }
            case 6: {
                return String.format("%-6s$%06X", constants.OP_NAME[opCode], address + 4 + simm26);
            }
            case 7: {
                return String.format("%-6sR%02d", constants.OP_NAME[opCode], Rs1);
            }
        }
        return "";
    }

    public int getNextReadAddress() {
        long i = (long)this.IF ^ common.unsigned(this.mem32.get((0x3FFFFC & this.pc) / 4));
        long cmd = i >> 26;
        int s1 = (int)(i >> 16 & 0x1FL);
        int IimmS = (int)(i << 16) >> 16;
        switch ((int)cmd) {
            case 49: 
            case 50: {
                return this.R[s1] + IimmS & 0x3FFFFF;
            }
            case 51: 
            case 52: {
                return this.R[s1] + IimmS & 0x3FFFFE;
            }
            case 53: {
                return this.R[s1] + IimmS & 0x3FFFFC;
            }
        }
        return -1;
    }

    public int getNextWriteAddress() {
        long i = (long)this.IF ^ common.unsigned(this.mem32.get((0x3FFFFC & this.pc) / 4));
        long cmd = i >> 26;
        int s1 = (int)(i >> 16 & 0x1FL);
        int IimmS = (int)(i << 16) >> 16;
        switch ((int)cmd) {
            case 54: {
                return this.R[s1] + IimmS & 0x3FFFFF;
            }
            case 55: {
                return this.R[s1] + IimmS & 0x3FFFFE;
            }
            case 56: {
                return this.R[s1] + IimmS & 0x3FFFFC;
            }
        }
        return -1;
    }

    public int find(int regionAddress, int regionLen, byte[] searchData) {
        for (int i = regionAddress; i < regionAddress + regionLen; ++i) {
            boolean found = true;
            for (int j = 0; j < searchData.length && (found &= this.mem8.get(i + j) == searchData[j]); ++j) {
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }
}

