/*
 * Decompiled with CFR 0.152.
 */
package bdvm.debugger;

import bdvm.vm.common;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class snapshots {
    private BufferedInputStream archive = null;
    private RandomAccessFile recording = null;
    private int snapshotSize = 0;
    private int snapshotCount = 0;
    public byte[] memory = null;

    public void open(String filename) throws IOException {
        File snapshotArchive = new File(filename);
        this.archive = new BufferedInputStream(new FileInputStream(snapshotArchive));
        byte[] tmp = new byte[4];
        this.archive.read(tmp);
        this.snapshotSize = common.byteArrayToInt(tmp, 0);
        this.archive.read(tmp);
        this.snapshotCount = common.byteArrayToInt(tmp, 0);
        System.out.format("%s : found %d snapshots of size %d bytes\n", filename, this.snapshotCount, this.snapshotSize);
        this.memory = new byte[this.snapshotSize];
        this.next();
    }

    public void create(String filename, int size) throws IOException {
        byte[] dword = new byte[4];
        this.snapshotSize = size;
        boolean success = new File("snapshots").mkdir();
        if (success) {
            System.out.println("snapshot directory created");
        }
        File snapshotArchive = new File(filename);
        snapshotArchive.delete();
        snapshotArchive.createNewFile();
        this.recording = new RandomAccessFile(snapshotArchive, "rw");
        this.recording.seek(0L);
        common.int32ToByteArray(this.snapshotSize, dword, 0);
        this.recording.write(dword);
        common.int32ToByteArray(0, dword, 0);
        this.recording.write(dword);
        this.memory = new byte[this.snapshotSize];
    }

    private int nextDiff(byte[] memory, byte[] snapshot, int offset) {
        for (int i = offset; i < memory.length; ++i) {
            if (memory[i] == snapshot[i]) continue;
            return i;
        }
        return memory.length;
    }

    private int diffLength(byte[] memory, byte[] snapshot, int offset, int skip) {
        for (int i = offset; i < memory.length; ++i) {
            if (memory[i] != snapshot[i]) continue;
            int addr_nextdiff = this.nextDiff(memory, snapshot, i);
            if (addr_nextdiff - i >= skip) {
                return i - offset;
            }
            if (addr_nextdiff != memory.length) continue;
            return i - offset;
        }
        return memory.length - offset;
    }

    public void store(byte[] snapshot) {
        byte[] buffer = new byte[4];
        int pos = 0;
        int diffcount = 0;
        int difflength = 0;
        try {
            long fileOffset = this.recording.length();
            this.recording.seek(fileOffset);
            this.recording.write(buffer);
            do {
                if ((pos = this.nextDiff(this.memory, snapshot, pos)) >= this.memory.length) continue;
                ++diffcount;
                difflength = this.diffLength(this.memory, snapshot, pos, 9);
                common.int32ToByteArray(pos, buffer, 0);
                this.recording.write(buffer);
                common.int32ToByteArray(difflength, buffer, 0);
                this.recording.write(buffer);
                this.recording.write(snapshot, pos, difflength);
                pos += difflength;
            } while (pos < this.memory.length);
            this.recording.seek(fileOffset);
            common.int32ToByteArray(diffcount, buffer, 0);
            this.recording.write(buffer);
            ++this.snapshotCount;
            System.arraycopy(snapshot, 0, this.memory, 0, this.memory.length);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void finalizeRecording() {
        byte[] buffer = new byte[4];
        try {
            this.recording.seek(4L);
            common.int32ToByteArray(this.snapshotCount, buffer, 0);
            this.recording.write(buffer);
            this.recording.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void applyBinaryPatch() {
        byte[] tmp = new byte[4];
        int offset = 0;
        int length = 0;
        try {
            this.archive.read(tmp);
            offset = common.byteArrayToInt(tmp, 0);
            this.archive.read(tmp);
            length = common.byteArrayToInt(tmp, 0);
            for (int i = 0; i < length; ++i) {
                this.memory[offset + i] = (byte)this.archive.read();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void next() {
        byte[] tmp = new byte[4];
        int diffCount = 0;
        try {
            this.archive.read(tmp);
            diffCount = common.byteArrayToInt(tmp, 0);
            for (int i = 0; i < diffCount; ++i) {
                this.applyBinaryPatch();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

