/*
 * Decompiled with CFR 0.152.
 */
package bdvm.debugger;

import bdvm.debugger.CommandLineException;
import bdvm.debugger.Debugger;
import bdvm.debugger.debugger_commands;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CommandLine
implements Runnable {
    private InputStream in;
    private OutputStream out;

    public CommandLine(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        new Thread(this).start();
    }

    protected String[] parse(String line) {
        StringTokenizer st = new StringTokenizer(line);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            tokens.add(token);
        }
        return tokens.toArray(new String[0]);
    }

    protected Object narrow(String argstring) {
        try {
            return Integer.valueOf(argstring);
        }
        catch (NumberFormatException nfe) {
            try {
                return Double.valueOf(argstring);
            }
            catch (NumberFormatException numberFormatException) {
                if (argstring.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (argstring.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                return argstring;
            }
        }
    }

    protected Object[] narrow(String[] argstrings, int startIndex) {
        Object[] narrowed = new Object[argstrings.length - startIndex];
        for (int i = 0; i < narrowed.length; ++i) {
            narrowed[i] = this.narrow(argstrings[startIndex + i]);
        }
        return narrowed;
    }

    protected Class[] getTypes(Object[] objs) {
        Class[] types = new Class[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            types[i] = objs[i].getClass();
            if (types[i] == Double.class) {
                types[i] = Double.TYPE;
            }
            if (types[i] != Integer.class) continue;
            types[i] = Integer.TYPE;
        }
        return types;
    }

    protected void execute(String line) throws CommandLineException {
        this.execute(this.parse(line));
    }

    protected void execute(String[] line) throws CommandLineException {
        String methodName = line[0];
        Object[] args = this.narrow(line, 1);
        Class[] types = this.getTypes(args);
        try {
            Method method = debugger_commands.class.getDeclaredMethod(methodName, types);
            method.invoke(null, args);
        }
        catch (NoSuchMethodException nsme) {
            throw new CommandLineException("Can't find method " + methodName);
        }
        catch (IllegalAccessException iae) {
            throw new CommandLineException("Not allowed to call method " + methodName);
        }
        catch (InvocationTargetException ite) {
            throw (CommandLineException)new CommandLineException("Exception while executing command").initCause(ite);
        }
    }

    @Override
    public void run() {
        block7: {
            try {
                BufferedReader inr = new BufferedReader(new InputStreamReader(this.in));
                BufferedWriter outw = new BufferedWriter(new OutputStreamWriter(this.out));
                while (true) {
                    try {
                        while (true) {
                            outw.write("$ ");
                            outw.flush();
                            String line = inr.readLine();
                            if (line != null) {
                                this.execute(line);
                                Debugger.updateRegisters();
                                Debugger.showCodePos(Debugger.vm.pc / 4);
                                continue;
                            }
                            break block7;
                            break;
                        }
                    }
                    catch (CommandLineException cle) {
                        System.out.println("Error: " + cle);
                        if (!(cle.getCause() instanceof InvocationTargetException)) continue;
                        ((InvocationTargetException)cle.getCause()).getTargetException().printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ie) {
                ie.printStackTrace(System.err);
            }
        }
        System.out.println("Command line exiting.");
    }
}

