/*
 * BDSup2Sub++ (C) 2012 Adam T.
 * Based on code from BDSup2Sub by Copyright 2009 Volker Oth (0xdeadbeef)
 * and Copyright 2012 Miklos Juhasz (mjuhasz)
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef SUBPICTUREHD_H
#define SUBPICTUREHD_H

#include "subpicture.h"

class SubPictureHD : public SubPicture
{
public:
    SubPictureHD();
    SubPictureHD(const SubPictureHD& other);
    SubPictureHD(const SubPictureHD* other);
    ~SubPictureHD() { }

    int paletteOffset() { return paletteOfs; }
    void setPaletteOffset(int paletteOffset) { paletteOfs = paletteOffset; }
    int alphaOffset() { return alphaOfs; }
    void setAlphaOffset(int alphaOffset) { alphaOfs = alphaOffset; }
    int imageBufferSize() { return imageBufSize; }
    void setImageBufferSize(int imageBufferSize) { imageBufSize = imageBufferSize; }
    int imageBufferOffsetEven() { return imageBufferOfsEven; }
    void setImageBufferOffsetEven(int imageBufferOffsetEven) { imageBufferOfsEven = imageBufferOffsetEven; }
    int imageBufferOffsetOdd() { return imageBufferOfsOdd; }
    void setImageBufferOffsetOdd(int imageBufferOffsetOdd) { imageBufferOfsOdd = imageBufferOffsetOdd; }

private:
    int paletteOfs = 0;
    int alphaOfs = 0;
    int imageBufSize = 0;
    int imageBufferOfsEven = 0;
    int imageBufferOfsOdd = 0;
};

#endif // SUBPICTUREHD_H
