/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import deadbeef.GUI.MyComboBoxEditor;
import deadbeef.SupTools.Core;
import deadbeef.Tools.ToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConversionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanelResolution = null;
    private JComboBox jComboBoxResolution = null;
    private JCheckBox jCheckBoxFrameRate = null;
    private JCheckBox jCheckBoxResolution = null;
    private JPanel jPanelFPS = null;
    private JComboBox jComboBoxFPSSrc = null;
    private JComboBox jComboBoxFPSTrg = null;
    private JPanel jPanelMove = null;
    private JCheckBox jCheckBoxMove = null;
    private JPanel jPanelTimes = null;
    private JTextField jTextFieldDelay = null;
    private JCheckBox jCheckBoxFixMinTime = null;
    private JTextField jTextFieldMinTime = null;
    private JTextField fpsTrgEditor = null;
    private JTextField fpsSrcEditor = null;
    private JPanel jPanelDefaults = null;
    private JButton jButtonStore = null;
    private JButton jButtonRestore = null;
    private JButton jButtonReset = null;
    private JPanel jPanelButtons = null;
    private JButton jButtonOk = null;
    private JButton jButtonCancel = null;
    private JPanel jPanelScale = null;
    private JCheckBox jCheckBoxScale = null;
    private JTextField jTextFieldScaleX = null;
    private JTextField jTextFieldScaleY = null;
    private JPanel jPanelForced = null;
    private JComboBox jComboBoxForced = null;
    private final Color errBgnd = new Color(-1987412);
    private final Color warnBgnd = new Color(-64);
    private final Color okBgnd = UIManager.getColor("TextField.background");
    private Core.Resolution resolution;
    private int delayPTS;
    private int minTimePTS;
    private boolean changeFPS;
    private boolean changeResolution;
    private boolean fixShortFrames;
    private double fpsSrc;
    private double fpsTrg;
    private boolean cancel;
    private volatile boolean isReady = false;
    private boolean changeScale;
    private double scaleX;
    private double scaleY;
    private boolean fpsSrcCertain;
    private Core.SetState forcedState;
    private boolean moveCaptions;
    static Dimension lDim = new Dimension(70, 20);

    public ConversionDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.fpsTrgEditor = new JTextField();
        this.fpsSrcEditor = new JTextField();
        this.initialize();
        Point p = owner.getLocation();
        this.setLocation(p.x + owner.getWidth() / 2 - this.getWidth() / 2, p.y + owner.getHeight() / 2 - this.getHeight() / 2);
        this.setResizable(false);
        this.changeResolution = Core.getConvertResolution();
        this.resolution = !this.changeResolution && Core.getNumFrames() > 0 ? Core.getResolution(Core.getSubPictureSrc((int)0).width, Core.getSubPictureSrc((int)0).height) : Core.getOutputResolution();
        this.moveCaptions = Core.getMoveCaptions();
        this.jCheckBoxMove.setEnabled(false);
        this.jCheckBoxMove.setSelected(this.moveCaptions);
        this.delayPTS = Core.getDelayPTS();
        this.minTimePTS = (int)Core.syncTimePTS(Core.getMinTimePTS(), Core.getFPSTrg());
        this.changeFPS = Core.getConvertFPS();
        this.changeScale = Core.getApplyFreeScale();
        this.fixShortFrames = Core.getFixShortFrames();
        this.fpsSrc = Core.getFPSSrc();
        this.fpsTrg = Core.getFPSTrg();
        this.scaleX = Core.getFreeScaleX();
        this.scaleY = Core.getFreeScaleY();
        this.fpsSrcCertain = Core.getFpsSrcCertain();
        this.cancel = false;
        Core.Resolution[] resolutionArray = Core.Resolution.values();
        int n = resolutionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Core.Resolution r = resolutionArray[n2];
            this.jComboBoxResolution.addItem(Core.getResolutionName(r));
            ++n2;
        }
        this.jComboBoxFPSSrc.addItem("23.975");
        this.jComboBoxFPSSrc.addItem("23.976");
        this.jComboBoxFPSSrc.addItem("24");
        this.jComboBoxFPSSrc.addItem("25");
        this.jComboBoxFPSSrc.addItem("29.97");
        this.jComboBoxFPSSrc.addItem("50");
        this.jComboBoxFPSSrc.addItem("59.94");
        this.jComboBoxFPSTrg.addItem("23.975");
        this.jComboBoxFPSTrg.addItem("23.976");
        this.jComboBoxFPSTrg.addItem("24");
        this.jComboBoxFPSTrg.addItem("25");
        this.jComboBoxFPSTrg.addItem("29.97");
        this.jComboBoxFPSTrg.addItem("50");
        this.jComboBoxFPSTrg.addItem("59.94");
        this.jComboBoxFPSSrc.setEditor(new MyComboBoxEditor(this.fpsSrcEditor));
        this.jComboBoxFPSTrg.setEditor(new MyComboBoxEditor(this.fpsTrgEditor));
        this.forcedState = Core.getForceAll();
        this.jComboBoxForced.addItem("keep      ");
        this.jComboBoxForced.addItem("set all   ");
        this.jComboBoxForced.addItem("clear all ");
        this.fillDialog();
        this.isReady = true;
    }

    private void fillDialog() {
        this.jComboBoxResolution.setSelectedIndex(this.resolution.ordinal());
        this.jComboBoxResolution.setEnabled(this.changeResolution);
        this.jCheckBoxResolution.setSelected(this.changeResolution);
        this.jTextFieldDelay.setText(ToolBox.formatDouble((double)this.delayPTS / 90.0));
        this.jCheckBoxFrameRate.setSelected(this.changeFPS);
        this.jComboBoxFPSSrc.setSelectedItem(ToolBox.formatDouble(this.fpsSrc));
        this.jComboBoxFPSSrc.setEnabled(this.changeFPS);
        this.jComboBoxFPSTrg.setSelectedItem(ToolBox.formatDouble(this.fpsTrg));
        this.jComboBoxFPSTrg.setEnabled(true);
        this.jTextFieldMinTime.setText(ToolBox.formatDouble((double)this.minTimePTS / 90.0));
        this.jCheckBoxFixMinTime.setEnabled(true);
        this.jCheckBoxFixMinTime.setSelected(this.fixShortFrames);
        this.jCheckBoxFixMinTime.setSelected(this.fixShortFrames);
        this.jTextFieldMinTime.setEnabled(this.fixShortFrames);
        this.jCheckBoxScale.setSelected(this.changeScale);
        this.jTextFieldScaleX.setText(ToolBox.formatDouble(this.scaleX));
        this.jTextFieldScaleX.setEnabled(this.changeScale);
        this.jTextFieldScaleY.setText(ToolBox.formatDouble(this.scaleY));
        this.jTextFieldScaleY.setEnabled(this.changeScale);
        this.jComboBoxForced.setSelectedIndex(this.forcedState.ordinal());
    }

    private void initialize() {
        this.setSize(500, 350);
        this.setTitle("Conversion Options");
        this.setPreferredSize(new Dimension(500, 350));
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConversionDialog.this.cancel = true;
                ConversionDialog.this.dispose();
            }
        });
    }

    private JPanel getJPanelResolution() {
        if (this.jPanelResolution == null) {
            GridBagConstraints gridBagCheckBoxResolution = new GridBagConstraints();
            gridBagCheckBoxResolution.gridx = 0;
            gridBagCheckBoxResolution.gridy = 0;
            gridBagCheckBoxResolution.anchor = 17;
            gridBagCheckBoxResolution.gridwidth = 2;
            GridBagConstraints gridBagLabelResolution = new GridBagConstraints();
            gridBagLabelResolution.gridx = 0;
            gridBagLabelResolution.gridy = 1;
            gridBagLabelResolution.anchor = 17;
            gridBagLabelResolution.insets = new Insets(2, 6, 2, 0);
            GridBagConstraints gridBagComboResolution = new GridBagConstraints();
            gridBagComboResolution.gridx = 1;
            gridBagComboResolution.gridy = 1;
            gridBagComboResolution.weightx = 1.0;
            gridBagComboResolution.anchor = 17;
            gridBagComboResolution.insets = new Insets(2, 4, 2, 4);
            this.jPanelResolution = new JPanel();
            this.jPanelResolution.setLayout(new GridBagLayout());
            this.jPanelResolution.setBorder(BorderFactory.createTitledBorder(null, "Resolution", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelResolution.setMinimumSize(new Dimension(200, 70));
            this.jPanelResolution.setPreferredSize(new Dimension(200, 70));
            JLabel label = new JLabel("Resolution");
            label.setMinimumSize(lDim);
            this.jPanelResolution.add((Component)this.getJCheckBoxResolution(), gridBagCheckBoxResolution);
            this.jPanelResolution.add((Component)label, gridBagLabelResolution);
            this.jPanelResolution.add((Component)this.getJComboBoxResolution(), gridBagComboResolution);
        }
        return this.jPanelResolution;
    }

    private JPanel getJPanelMove() {
        if (this.jPanelMove == null) {
            GridBagConstraints gridBagCheckBoxMove = new GridBagConstraints();
            gridBagCheckBoxMove.gridx = 0;
            gridBagCheckBoxMove.gridy = 0;
            gridBagCheckBoxMove.anchor = 17;
            gridBagCheckBoxMove.weightx = 1.0;
            this.jPanelMove = new JPanel();
            this.jPanelMove.setLayout(new GridBagLayout());
            this.jPanelMove.setBorder(BorderFactory.createTitledBorder(null, "Move", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelMove.setMinimumSize(new Dimension(200, 50));
            this.jPanelMove.setPreferredSize(new Dimension(200, 50));
            this.jPanelMove.add((Component)this.getJCheckBoxMove(), gridBagCheckBoxMove);
        }
        return this.jPanelMove;
    }

    private JPanel getJPanelFPS() {
        if (this.jPanelFPS == null) {
            GridBagConstraints gridBagCheckBoxFrameRate = new GridBagConstraints();
            gridBagCheckBoxFrameRate.gridx = 0;
            gridBagCheckBoxFrameRate.gridy = 0;
            gridBagCheckBoxFrameRate.anchor = 17;
            gridBagCheckBoxFrameRate.gridwidth = 2;
            GridBagConstraints gridBagLabelFPSSrc = new GridBagConstraints();
            gridBagLabelFPSSrc.gridx = 0;
            gridBagLabelFPSSrc.gridy = 1;
            gridBagLabelFPSSrc.anchor = 17;
            gridBagLabelFPSSrc.insets = new Insets(2, 6, 2, 0);
            GridBagConstraints gridBagComboFPSSrc = new GridBagConstraints();
            gridBagComboFPSSrc.gridx = 1;
            gridBagComboFPSSrc.gridy = 1;
            gridBagComboFPSSrc.weightx = 1.0;
            gridBagComboFPSSrc.anchor = 17;
            gridBagComboFPSSrc.insets = new Insets(2, 4, 2, 4);
            GridBagConstraints gridBagLabelFPSTrg = new GridBagConstraints();
            gridBagLabelFPSTrg.gridx = 0;
            gridBagLabelFPSTrg.gridy = 2;
            gridBagLabelFPSTrg.anchor = 17;
            gridBagLabelFPSTrg.insets = new Insets(2, 6, 2, 0);
            GridBagConstraints gridBagComboFPSTrg = new GridBagConstraints();
            gridBagComboFPSTrg.gridx = 1;
            gridBagComboFPSTrg.gridy = 2;
            gridBagComboFPSTrg.weightx = 1.0;
            gridBagComboFPSTrg.anchor = 17;
            gridBagComboFPSTrg.insets = new Insets(2, 4, 2, 4);
            this.jPanelFPS = new JPanel();
            this.jPanelFPS.setLayout(new GridBagLayout());
            this.jPanelFPS.setBorder(BorderFactory.createTitledBorder(null, "Framerate", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelFPS.setMinimumSize(new Dimension(200, 100));
            this.jPanelFPS.setPreferredSize(new Dimension(200, 100));
            this.jPanelFPS.add((Component)this.getJCheckBoxFrameRate(), gridBagCheckBoxFrameRate);
            JLabel label = new JLabel("FPS Source");
            label.setMinimumSize(lDim);
            this.jPanelFPS.add((Component)label, gridBagLabelFPSSrc);
            label = new JLabel("FPS Target");
            label.setMinimumSize(lDim);
            this.jPanelFPS.add((Component)label, gridBagLabelFPSTrg);
            this.jPanelFPS.add((Component)this.getJComboBoxFPSSrc(), gridBagComboFPSSrc);
            this.jPanelFPS.add((Component)this.getJComboBoxFPSTrg(), gridBagComboFPSTrg);
        }
        return this.jPanelFPS;
    }

    private JPanel getJPanelTimes() {
        if (this.jPanelTimes == null) {
            GridBagConstraints gridBagLabelDelay = new GridBagConstraints();
            gridBagLabelDelay.gridx = 0;
            gridBagLabelDelay.gridy = 0;
            gridBagLabelDelay.anchor = 17;
            gridBagLabelDelay.insets = new Insets(2, 6, 2, 0);
            GridBagConstraints gridBagTextDelay = new GridBagConstraints();
            gridBagTextDelay.gridx = 1;
            gridBagTextDelay.gridy = 0;
            gridBagTextDelay.weightx = 1.0;
            gridBagTextDelay.anchor = 17;
            gridBagTextDelay.insets = new Insets(2, 4, 2, 4);
            gridBagTextDelay.ipadx = 100;
            GridBagConstraints gridBagCheckBoxFixMinTime = new GridBagConstraints();
            gridBagCheckBoxFixMinTime.gridx = 0;
            gridBagCheckBoxFixMinTime.gridy = 1;
            gridBagCheckBoxFixMinTime.anchor = 17;
            gridBagCheckBoxFixMinTime.gridwidth = 2;
            gridBagCheckBoxFixMinTime.insets = new Insets(0, 0, 0, 0);
            GridBagConstraints gridBagLabelMinTime = new GridBagConstraints();
            gridBagLabelMinTime.gridx = 0;
            gridBagLabelMinTime.gridy = 2;
            gridBagLabelMinTime.anchor = 17;
            gridBagLabelMinTime.insets = new Insets(2, 6, 2, 2);
            GridBagConstraints gridBagTextMinTime = new GridBagConstraints();
            gridBagTextMinTime.gridx = 1;
            gridBagTextMinTime.gridy = 2;
            gridBagTextMinTime.anchor = 17;
            gridBagTextMinTime.weightx = 1.0;
            gridBagTextMinTime.ipadx = 100;
            gridBagTextMinTime.insets = new Insets(2, 4, 2, 4);
            this.jPanelTimes = new JPanel();
            this.jPanelTimes.setLayout(new GridBagLayout());
            this.jPanelTimes.setBorder(BorderFactory.createTitledBorder(null, "Times", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelTimes.setMinimumSize(new Dimension(200, 100));
            this.jPanelTimes.setPreferredSize(new Dimension(200, 100));
            JLabel label = new JLabel("Delay (ms)");
            label.setMinimumSize(lDim);
            this.jPanelTimes.add((Component)label, gridBagLabelDelay);
            this.jPanelTimes.add((Component)this.getJTextFieldDelay(), gridBagTextDelay);
            this.jPanelTimes.add((Component)this.getJCheckBoxFixMineTime(), gridBagCheckBoxFixMinTime);
            this.jPanelTimes.add((Component)this.getJTextFieldMinTime(), gridBagTextMinTime);
            label = new JLabel("Min Time (ms)");
            label.setMinimumSize(lDim);
            this.jPanelTimes.add((Component)label, gridBagLabelMinTime);
        }
        return this.jPanelTimes;
    }

    private JPanel getJPanelScale() {
        if (this.jPanelScale == null) {
            GridBagConstraints gridBagCheckBoxScale = new GridBagConstraints();
            gridBagCheckBoxScale.gridx = 0;
            gridBagCheckBoxScale.gridy = 0;
            gridBagCheckBoxScale.anchor = 17;
            gridBagCheckBoxScale.gridwidth = 2;
            GridBagConstraints gridBagLabelScaleX = new GridBagConstraints();
            gridBagLabelScaleX.gridx = 0;
            gridBagLabelScaleX.gridy = 1;
            gridBagLabelScaleX.anchor = 17;
            gridBagLabelScaleX.insets = new Insets(2, 6, 2, 2);
            GridBagConstraints gridBagTextScaleX = new GridBagConstraints();
            gridBagTextScaleX.gridx = 1;
            gridBagTextScaleX.gridy = 1;
            gridBagTextScaleX.anchor = 17;
            gridBagTextScaleX.insets = new Insets(2, 4, 2, 4);
            gridBagTextScaleX.weightx = 1.0;
            gridBagTextScaleX.ipadx = 100;
            GridBagConstraints gridBagLabelScaleY = new GridBagConstraints();
            gridBagLabelScaleY.gridx = 0;
            gridBagLabelScaleY.gridy = 2;
            gridBagLabelScaleY.anchor = 17;
            gridBagLabelScaleY.insets = new Insets(2, 6, 2, 2);
            GridBagConstraints gridBagTextScaleY = new GridBagConstraints();
            gridBagTextScaleY.gridx = 1;
            gridBagTextScaleY.gridy = 2;
            gridBagTextScaleY.anchor = 17;
            gridBagTextScaleY.insets = new Insets(2, 4, 2, 4);
            gridBagTextScaleY.weightx = 1.0;
            gridBagTextScaleY.ipadx = 100;
            this.jPanelScale = new JPanel();
            this.jPanelScale.setLayout(new GridBagLayout());
            this.jPanelScale.setBorder(BorderFactory.createTitledBorder(null, "Scale", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelScale.setMinimumSize(new Dimension(200, 100));
            this.jPanelScale.setPreferredSize(new Dimension(200, 100));
            this.jPanelScale.add((Component)this.getJCheckBoxScale(), gridBagCheckBoxScale);
            JLabel label = new JLabel("Scale X");
            label.setMinimumSize(lDim);
            this.jPanelScale.add((Component)label, gridBagLabelScaleX);
            this.jPanelScale.add((Component)this.getJTextFieldScaleX(), gridBagTextScaleX);
            label = new JLabel("Scale Y");
            label.setMinimumSize(lDim);
            this.jPanelScale.add((Component)label, gridBagLabelScaleY);
            this.jPanelScale.add((Component)this.getJTextFieldScaleY(), gridBagTextScaleY);
        }
        return this.jPanelScale;
    }

    private JPanel getJPanelDefaults() {
        if (this.jPanelDefaults == null) {
            GridBagConstraints gridBagButtonStore = new GridBagConstraints();
            gridBagButtonStore.gridx = 0;
            gridBagButtonStore.gridy = 0;
            gridBagButtonStore.anchor = 17;
            gridBagButtonStore.weightx = 1.0;
            gridBagButtonStore.insets = new Insets(2, 0, 2, 0);
            GridBagConstraints gridBagButtonRestore = new GridBagConstraints();
            gridBagButtonRestore.gridx = 1;
            gridBagButtonRestore.gridy = 0;
            gridBagButtonRestore.anchor = 10;
            gridBagButtonRestore.weightx = 1.0;
            gridBagButtonRestore.insets = new Insets(2, 0, 2, 0);
            GridBagConstraints gridBagButtonReset = new GridBagConstraints();
            gridBagButtonReset.gridx = 2;
            gridBagButtonReset.gridy = 0;
            gridBagButtonReset.anchor = 13;
            gridBagButtonReset.weightx = 1.0;
            gridBagButtonReset.insets = new Insets(2, 4, 2, 0);
            this.jPanelDefaults = new JPanel();
            this.jPanelDefaults.setLayout(new GridBagLayout());
            this.jPanelDefaults.setBorder(BorderFactory.createTitledBorder(null, "Defaults", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelDefaults.setMinimumSize(new Dimension(200, 60));
            this.jPanelDefaults.setPreferredSize(new Dimension(200, 60));
            this.jPanelDefaults.add((Component)this.getJButtonStore(), gridBagButtonStore);
            this.jPanelDefaults.add((Component)this.getJButtonRestore(), gridBagButtonRestore);
            this.jPanelDefaults.add((Component)this.getJButtonReset(), gridBagButtonReset);
        }
        return this.jPanelDefaults;
    }

    private JPanel getJPanelForced() {
        if (this.jPanelForced == null) {
            GridBagConstraints gridBagLabelForced = new GridBagConstraints();
            gridBagLabelForced.gridx = 0;
            gridBagLabelForced.gridy = 0;
            gridBagLabelForced.anchor = 17;
            gridBagLabelForced.insets = new Insets(2, 6, 2, 0);
            GridBagConstraints gridBagComboForced = new GridBagConstraints();
            gridBagComboForced.gridx = 1;
            gridBagComboForced.gridy = 0;
            gridBagComboForced.weightx = 1.0;
            gridBagComboForced.anchor = 17;
            gridBagComboForced.insets = new Insets(2, 4, 2, 4);
            this.jPanelForced = new JPanel();
            this.jPanelForced.setLayout(new GridBagLayout());
            this.jPanelForced.setBorder(BorderFactory.createTitledBorder(null, "Global forced flags", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelForced.setMinimumSize(new Dimension(200, 70));
            this.jPanelForced.setPreferredSize(new Dimension(200, 70));
            JLabel label = new JLabel("Force all");
            label.setMinimumSize(lDim);
            this.jPanelForced.add((Component)label, gridBagLabelForced);
            this.jPanelForced.add((Component)this.getJComboBoxForced(), gridBagComboForced);
        }
        return this.jPanelForced;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            GridBagConstraints gridBagButtonCancel = new GridBagConstraints();
            gridBagButtonCancel.gridx = 0;
            gridBagButtonCancel.gridy = 0;
            gridBagButtonCancel.anchor = 17;
            gridBagButtonCancel.weightx = 1.0;
            gridBagButtonCancel.insets = new Insets(2, 8, 4, 0);
            GridBagConstraints gridBagButtonOk = new GridBagConstraints();
            gridBagButtonOk.gridx = 3;
            gridBagButtonOk.gridy = 0;
            gridBagButtonOk.anchor = 13;
            gridBagButtonOk.weightx = 1.0;
            gridBagButtonOk.insets = new Insets(2, 4, 4, 8);
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(new GridBagLayout());
            this.jPanelButtons.setMinimumSize(new Dimension(200, 30));
            this.jPanelButtons.setPreferredSize(new Dimension(200, 30));
            this.jPanelButtons.add((Component)this.getJButtonOk(), gridBagButtonOk);
            this.jPanelButtons.add((Component)this.getJButtonCancel(), gridBagButtonCancel);
        }
        return this.jPanelButtons;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagPanelResolution = new GridBagConstraints();
            gridBagPanelResolution.gridx = 0;
            gridBagPanelResolution.gridy = 0;
            gridBagPanelResolution.anchor = 18;
            gridBagPanelResolution.weightx = 1.0;
            gridBagPanelResolution.weighty = 1.0;
            gridBagPanelResolution.fill = 1;
            GridBagConstraints gridBagPanelMove = new GridBagConstraints();
            gridBagPanelMove.gridx = 0;
            gridBagPanelMove.gridy = 1;
            gridBagPanelMove.anchor = 18;
            gridBagPanelMove.weightx = 1.0;
            gridBagPanelMove.weighty = 1.0;
            gridBagPanelMove.fill = 1;
            GridBagConstraints gridBagPanelScale = new GridBagConstraints();
            gridBagPanelScale.gridx = 1;
            gridBagPanelScale.gridy = 0;
            gridBagPanelScale.anchor = 18;
            gridBagPanelScale.weightx = 1.0;
            gridBagPanelScale.weighty = 1.0;
            gridBagPanelScale.gridheight = 2;
            gridBagPanelScale.fill = 1;
            GridBagConstraints gridBagPanelFPS = new GridBagConstraints();
            gridBagPanelFPS.gridx = 0;
            gridBagPanelFPS.gridy = 2;
            gridBagPanelFPS.anchor = 18;
            gridBagPanelFPS.weightx = 1.0;
            gridBagPanelFPS.weighty = 1.0;
            gridBagPanelFPS.fill = 1;
            GridBagConstraints gridBagPanelTimes = new GridBagConstraints();
            gridBagPanelTimes.gridx = 1;
            gridBagPanelTimes.gridy = 2;
            gridBagPanelTimes.anchor = 18;
            gridBagPanelTimes.weightx = 1.0;
            gridBagPanelTimes.weighty = 1.0;
            gridBagPanelTimes.fill = 1;
            GridBagConstraints gridBagPanelForced = new GridBagConstraints();
            gridBagPanelForced.gridx = 0;
            gridBagPanelForced.gridy = 3;
            gridBagPanelForced.anchor = 18;
            gridBagPanelForced.weightx = 1.0;
            gridBagPanelForced.weighty = 1.0;
            gridBagPanelForced.fill = 1;
            GridBagConstraints gridBagPanelDefaults = new GridBagConstraints();
            gridBagPanelDefaults.gridx = 1;
            gridBagPanelDefaults.gridy = 3;
            gridBagPanelDefaults.anchor = 18;
            gridBagPanelDefaults.weightx = 1.0;
            gridBagPanelDefaults.weighty = 1.0;
            gridBagPanelDefaults.fill = 1;
            GridBagConstraints gridBagPanelButtons = new GridBagConstraints();
            gridBagPanelButtons.gridx = 0;
            gridBagPanelButtons.gridy = 4;
            gridBagPanelButtons.anchor = 18;
            gridBagPanelButtons.weightx = 1.0;
            gridBagPanelButtons.weighty = 1.0;
            gridBagPanelButtons.gridwidth = 2;
            gridBagPanelButtons.fill = 2;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJPanelResolution(), gridBagPanelResolution);
            this.jContentPane.add((Component)this.getJPanelMove(), gridBagPanelMove);
            this.jContentPane.add((Component)this.getJPanelFPS(), gridBagPanelFPS);
            this.jContentPane.add((Component)this.getJPanelTimes(), gridBagPanelTimes);
            this.jContentPane.add((Component)this.getJPanelScale(), gridBagPanelScale);
            this.jContentPane.add((Component)this.getJPanelForced(), gridBagPanelForced);
            this.jContentPane.add((Component)this.getJPanelDefaults(), gridBagPanelDefaults);
            this.jContentPane.add((Component)this.getJPanelButtons(), gridBagPanelButtons);
        }
        return this.jContentPane;
    }

    private JComboBox getJComboBoxResolution() {
        if (this.jComboBoxResolution == null) {
            this.jComboBoxResolution = new JComboBox();
            this.jComboBoxResolution.setPreferredSize(new Dimension(200, 20));
            this.jComboBoxResolution.setMinimumSize(new Dimension(150, 20));
            this.jComboBoxResolution.setEditable(false);
            this.jComboBoxResolution.setToolTipText("Select the target resolution");
            this.jComboBoxResolution.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ConversionDialog.this.isReady) {
                        int idx = ConversionDialog.this.jComboBoxResolution.getSelectedIndex();
                        Core.Resolution[] resolutionArray = Core.Resolution.values();
                        int n = resolutionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Core.Resolution r = resolutionArray[n2];
                            if (idx == r.ordinal()) {
                                ConversionDialog.this.resolution = r;
                                if (!Core.getKeepFps()) {
                                    ConversionDialog.this.fpsTrg = Core.getDefaultFPS(r);
                                }
                                ConversionDialog.this.jComboBoxFPSTrg.setSelectedItem(ToolBox.formatDouble(ConversionDialog.this.fpsTrg));
                                break;
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
        return this.jComboBoxResolution;
    }

    private JCheckBox getJCheckBoxFrameRate() {
        if (this.jCheckBoxFrameRate == null) {
            this.jCheckBoxFrameRate = new JCheckBox();
            this.jCheckBoxFrameRate.setToolTipText("Convert frame rate from FPS Source to FPS target");
            this.jCheckBoxFrameRate.setText("Change frame rate");
            this.jCheckBoxFrameRate.setMnemonic('f');
            this.jCheckBoxFrameRate.setFocusable(false);
            this.jCheckBoxFrameRate.setIconTextGap(10);
            this.jCheckBoxFrameRate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        ConversionDialog.this.changeFPS = ConversionDialog.this.jCheckBoxFrameRate.isSelected();
                        ConversionDialog.this.jComboBoxFPSSrc.setEnabled(ConversionDialog.this.changeFPS);
                    }
                }
            });
        }
        return this.jCheckBoxFrameRate;
    }

    private JCheckBox getJCheckBoxResolution() {
        if (this.jCheckBoxResolution == null) {
            this.jCheckBoxResolution = new JCheckBox();
            this.jCheckBoxResolution.setToolTipText("Convert resolution");
            this.jCheckBoxResolution.setText("Convert resolution");
            this.jCheckBoxResolution.setMnemonic('r');
            this.jCheckBoxResolution.setDisplayedMnemonicIndex(8);
            this.jCheckBoxResolution.setFocusable(false);
            this.jCheckBoxResolution.setIconTextGap(10);
            this.jCheckBoxResolution.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        ConversionDialog.this.changeResolution = ConversionDialog.this.jCheckBoxResolution.isSelected();
                        ConversionDialog.this.jComboBoxResolution.setEnabled(ConversionDialog.this.changeResolution);
                    }
                }
            });
        }
        return this.jCheckBoxResolution;
    }

    private JCheckBox getJCheckBoxMove() {
        if (this.jCheckBoxMove == null) {
            this.jCheckBoxMove = new JCheckBox();
            this.jCheckBoxMove.setToolTipText("Apply settings for moving captions");
            this.jCheckBoxMove.setText("Apply 'move all' settings");
            this.jCheckBoxMove.setMnemonic('k');
            this.jCheckBoxMove.setDisplayedMnemonicIndex(8);
            this.jCheckBoxMove.setFocusable(false);
            this.jCheckBoxMove.setIconTextGap(10);
            this.jCheckBoxMove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        ConversionDialog.this.moveCaptions = ConversionDialog.this.jCheckBoxMove.isSelected();
                    }
                }
            });
        }
        return this.jCheckBoxMove;
    }

    private JComboBox getJComboBoxFPSSrc() {
        if (this.jComboBoxFPSSrc == null) {
            this.jComboBoxFPSSrc = new JComboBox();
            this.jComboBoxFPSSrc.setPreferredSize(new Dimension(200, 20));
            this.jComboBoxFPSSrc.setMinimumSize(new Dimension(150, 20));
            this.jComboBoxFPSSrc.setEditable(true);
            this.jComboBoxFPSSrc.setEnabled(false);
            this.jComboBoxFPSSrc.setToolTipText("Set the source frame rate (only needed for frame rate conversion)");
            this.jComboBoxFPSSrc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s = (String)ConversionDialog.this.jComboBoxFPSSrc.getSelectedItem();
                        double d = Core.getFPS(s);
                        if (d > 0.0) {
                            ConversionDialog.this.fpsSrc = d;
                        }
                        ConversionDialog.this.jComboBoxFPSSrc.setSelectedItem(ToolBox.formatDouble(ConversionDialog.this.fpsSrc));
                        ConversionDialog.this.jComboBoxFPSSrc.getEditor().getEditorComponent().setBackground(ConversionDialog.this.okBgnd);
                        ConversionDialog.this.fpsSrcCertain = false;
                    }
                }
            });
            this.fpsSrcEditor.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (ConversionDialog.this.isReady) {
                        Color c;
                        String s = ConversionDialog.this.fpsSrcEditor.getText();
                        double d = Core.getFPS(s);
                        if (d > 0.0) {
                            c = ConversionDialog.this.okBgnd;
                            ConversionDialog.this.fpsSrc = d;
                        } else {
                            c = ConversionDialog.this.errBgnd;
                        }
                        ConversionDialog.this.fpsSrcEditor.setBackground(c);
                        ConversionDialog.this.fpsSrcCertain = false;
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jComboBoxFPSSrc;
    }

    private JComboBox getJComboBoxFPSTrg() {
        if (this.jComboBoxFPSTrg == null) {
            this.jComboBoxFPSTrg = new JComboBox();
            this.jComboBoxFPSTrg.setPreferredSize(new Dimension(200, 20));
            this.jComboBoxFPSTrg.setMinimumSize(new Dimension(150, 20));
            this.jComboBoxFPSTrg.setEditable(true);
            this.jComboBoxFPSTrg.setEnabled(false);
            this.jComboBoxFPSTrg.setToolTipText("Set the target frame rate");
            this.jComboBoxFPSTrg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s = (String)ConversionDialog.this.jComboBoxFPSTrg.getSelectedItem();
                        double d = Core.getFPS(s);
                        if (d > 0.0) {
                            ConversionDialog.this.fpsTrg = d;
                        }
                        ConversionDialog.this.jComboBoxFPSTrg.setSelectedItem(ToolBox.formatDouble(ConversionDialog.this.fpsTrg));
                        ConversionDialog.this.jComboBoxFPSTrg.getEditor().getEditorComponent().setBackground(ConversionDialog.this.okBgnd);
                        ConversionDialog.this.delayPTS = (int)Core.syncTimePTS(ConversionDialog.this.delayPTS, ConversionDialog.this.fpsTrg);
                        ConversionDialog.this.jTextFieldDelay.setText(ToolBox.formatDouble((double)ConversionDialog.this.delayPTS / 90.0));
                        ConversionDialog.this.minTimePTS = (int)Core.syncTimePTS(ConversionDialog.this.minTimePTS, ConversionDialog.this.fpsTrg);
                        d = ConversionDialog.this.minTimePTS;
                        ConversionDialog.this.jTextFieldMinTime.setText(ToolBox.formatDouble((double)ConversionDialog.this.minTimePTS / 90.0));
                    }
                }
            });
            this.fpsTrgEditor.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (ConversionDialog.this.isReady) {
                        Color c;
                        String s = ConversionDialog.this.fpsTrgEditor.getText();
                        double d = Core.getFPS(s);
                        if (d > 0.0) {
                            c = (int)Core.syncTimePTS(ConversionDialog.this.delayPTS, ConversionDialog.this.fpsTrg) != ConversionDialog.this.delayPTS || ConversionDialog.this.minTimePTS != (int)Core.syncTimePTS(ConversionDialog.this.minTimePTS, ConversionDialog.this.fpsTrg) ? ConversionDialog.this.warnBgnd : ConversionDialog.this.okBgnd;
                            ConversionDialog.this.fpsTrg = d;
                        } else {
                            c = ConversionDialog.this.errBgnd;
                        }
                        ConversionDialog.this.fpsTrgEditor.setBackground(c);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jComboBoxFPSTrg;
    }

    private JTextField getJTextFieldDelay() {
        if (this.jTextFieldDelay == null) {
            this.jTextFieldDelay = new JTextField();
            this.jTextFieldDelay.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldDelay.setToolTipText("Set global delay (in milliseconds) added to all timestamps");
            this.jTextFieldDelay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s = ConversionDialog.this.jTextFieldDelay.getText();
                        try {
                            ConversionDialog.this.delayPTS = (int)Core.syncTimePTS((long)(Double.parseDouble(s) * 90.0), ConversionDialog.this.fpsTrg);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        ConversionDialog.this.jTextFieldDelay.setBackground(ConversionDialog.this.okBgnd);
                        ConversionDialog.this.jTextFieldDelay.setText(ToolBox.formatDouble((double)ConversionDialog.this.delayPTS / 90.0));
                    }
                }
            });
            this.jTextFieldDelay.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s = ConversionDialog.this.jTextFieldDelay.getText();
                        try {
                            ConversionDialog.this.delayPTS = (int)Core.syncTimePTS((long)(Double.parseDouble(s) * 90.0), ConversionDialog.this.fpsTrg);
                            if (!s.equalsIgnoreCase(ToolBox.formatDouble((double)ConversionDialog.this.delayPTS / 90.0))) {
                                ConversionDialog.this.jTextFieldDelay.setBackground(ConversionDialog.this.warnBgnd);
                            } else {
                                ConversionDialog.this.jTextFieldDelay.setBackground(ConversionDialog.this.okBgnd);
                            }
                        }
                        catch (NumberFormatException ex) {
                            ConversionDialog.this.jTextFieldDelay.setBackground(ConversionDialog.this.errBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldDelay;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setToolTipText("Lose all changes and use the default values");
            this.jButtonCancel.setMnemonic('c');
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConversionDialog.this.cancel = true;
                    ConversionDialog.this.dispose();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JButton getJButtonStore() {
        if (this.jButtonStore == null) {
            this.jButtonStore = new JButton();
            this.jButtonStore.setText("Store");
            this.jButtonStore.setToolTipText("Store current settings as default");
            this.jButtonStore.setMnemonic('o');
            this.jButtonStore.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s;
                        double d;
                        Core.storeConvertFPS(ConversionDialog.this.changeFPS);
                        if (ConversionDialog.this.changeFPS && (d = Core.getFPS(s = (String)ConversionDialog.this.jComboBoxFPSSrc.getSelectedItem())) > 0.0) {
                            ConversionDialog.this.fpsSrc = d;
                            Core.storeFPSSrc(ConversionDialog.this.fpsSrc);
                        }
                        if ((d = Core.getFPS(s = (String)ConversionDialog.this.jComboBoxFPSTrg.getSelectedItem())) > 0.0) {
                            ConversionDialog.this.fpsTrg = d;
                            Core.storeFPSTrg(ConversionDialog.this.fpsTrg);
                        }
                        s = ConversionDialog.this.jTextFieldDelay.getText();
                        try {
                            ConversionDialog.this.delayPTS = (int)Core.syncTimePTS((long)(Double.parseDouble(s) * 90.0), ConversionDialog.this.fpsTrg);
                            Core.storeDelayPTS(ConversionDialog.this.delayPTS);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        Core.storeFixShortFrames(ConversionDialog.this.fixShortFrames);
                        s = ConversionDialog.this.jTextFieldMinTime.getText();
                        try {
                            ConversionDialog.this.minTimePTS = (int)Core.syncTimePTS((long)(Double.parseDouble(s) * 90.0), ConversionDialog.this.fpsTrg);
                            Core.storeMinTimePTS(ConversionDialog.this.minTimePTS);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        Core.storeConvertResolution(ConversionDialog.this.changeResolution);
                        if (ConversionDialog.this.changeResolution) {
                            Core.storeOutputResolution(ConversionDialog.this.resolution);
                        }
                        if ((d = ToolBox.getDouble(s = ConversionDialog.this.jTextFieldScaleX.getText())) > 0.0) {
                            if (d > 2.0) {
                                d = 2.0;
                            } else if (d < 0.5) {
                                d = 0.5;
                            }
                            ConversionDialog.this.scaleX = d;
                        }
                        if ((d = ToolBox.getDouble(s = ConversionDialog.this.jTextFieldScaleY.getText())) > 0.0) {
                            if (d > 2.0) {
                                d = 2.0;
                            } else if (d < 0.5) {
                                d = 0.5;
                            }
                            ConversionDialog.this.scaleY = d;
                        }
                        Core.storeApplyFreeScale(ConversionDialog.this.changeScale);
                        if (ConversionDialog.this.changeScale) {
                            Core.storeFreeScale(ConversionDialog.this.scaleX, ConversionDialog.this.scaleY);
                        }
                        Core.storeProps();
                    }
                }
            });
        }
        return this.jButtonStore;
    }

    private JButton getJButtonRestore() {
        if (this.jButtonRestore == null) {
            this.jButtonRestore = new JButton();
            this.jButtonRestore.setText("Restore");
            this.jButtonRestore.setToolTipText("Restore last default settings");
            this.jButtonRestore.setMnemonic('e');
            this.jButtonRestore.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConversionDialog.this.changeResolution = Core.restoreConvertResolution();
                    if (ConversionDialog.this.changeResolution) {
                        ConversionDialog.this.resolution = Core.restoreResolution();
                    }
                    ConversionDialog.this.changeFPS = Core.restoreConvertFPS();
                    if (ConversionDialog.this.changeFPS && !ConversionDialog.this.fpsSrcCertain) {
                        ConversionDialog.this.fpsSrc = Core.restoreFpsSrc();
                    }
                    ConversionDialog.this.fpsTrg = Core.restoreFpsTrg();
                    ConversionDialog.this.delayPTS = Core.restoreDelayPTS();
                    ConversionDialog.this.fixShortFrames = Core.restoreFixShortFrames();
                    ConversionDialog.this.minTimePTS = Core.restoreMinTimePTS();
                    ConversionDialog.this.changeScale = Core.restoreApplyFreeScale();
                    if (ConversionDialog.this.changeScale) {
                        ConversionDialog.this.scaleX = Core.restoreFreeScaleX();
                        ConversionDialog.this.scaleY = Core.restoreFreeScaleY();
                    }
                    ConversionDialog.this.forcedState = Core.getForceAll();
                    ConversionDialog.this.fillDialog();
                }
            });
        }
        return this.jButtonRestore;
    }

    private JButton getJButtonReset() {
        if (this.jButtonReset == null) {
            this.jButtonReset = new JButton();
            this.jButtonReset.setText("Reset");
            this.jButtonReset.setToolTipText("Reset defaults");
            this.jButtonReset.setMnemonic('t');
            this.jButtonReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConversionDialog.this.changeResolution = Core.getConvertResolutionDefault();
                    if (ConversionDialog.this.changeResolution) {
                        ConversionDialog.this.resolution = Core.getResolutionDefault();
                    }
                    ConversionDialog.this.changeFPS = Core.getConvertFPSdefault();
                    if (ConversionDialog.this.changeFPS) {
                        if (!ConversionDialog.this.fpsSrcCertain) {
                            ConversionDialog.this.fpsSrc = Core.getFpsSrcDefault();
                        }
                        ConversionDialog.this.fpsTrg = Core.getFpsTrgDefault();
                    } else {
                        ConversionDialog.this.fpsTrg = ConversionDialog.this.fpsSrc;
                    }
                    ConversionDialog.this.delayPTS = Core.getDelayPTSdefault();
                    ConversionDialog.this.fixShortFrames = Core.getFixShortFramesDefault();
                    ConversionDialog.this.minTimePTS = Core.getMinTimePTSdefault();
                    ConversionDialog.this.changeScale = Core.getApplyFreeScaleDefault();
                    if (ConversionDialog.this.changeScale) {
                        ConversionDialog.this.scaleX = Core.getFreeScaleXdefault();
                        ConversionDialog.this.scaleY = Core.getFreeScaleYdefault();
                    }
                    ConversionDialog.this.forcedState = Core.SetState.KEEP;
                    ConversionDialog.this.fillDialog();
                }
            });
        }
        return this.jButtonReset;
    }

    public boolean wasCanceled() {
        return this.cancel;
    }

    private JCheckBox getJCheckBoxScale() {
        if (this.jCheckBoxScale == null) {
            this.jCheckBoxScale = new JCheckBox();
            this.jCheckBoxScale.setToolTipText("Allow free scaling of subtitles in X and Y direction");
            this.jCheckBoxScale.setText("Apply free scaling");
            this.jCheckBoxScale.setMnemonic('a');
            this.jCheckBoxScale.setFocusable(false);
            this.jCheckBoxScale.setIconTextGap(10);
            this.jCheckBoxScale.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ConversionDialog.this.isReady) {
                        ConversionDialog.this.changeScale = ConversionDialog.this.jCheckBoxScale.isSelected();
                        ConversionDialog.this.jTextFieldScaleX.setEnabled(ConversionDialog.this.changeScale);
                        ConversionDialog.this.jTextFieldScaleY.setEnabled(ConversionDialog.this.changeScale);
                    }
                }
            });
        }
        return this.jCheckBoxScale;
    }

    private JCheckBox getJCheckBoxFixMineTime() {
        if (this.jCheckBoxFixMinTime == null) {
            this.jCheckBoxFixMinTime = new JCheckBox();
            this.jCheckBoxFixMinTime.setToolTipText("Force a minimum display duration of 'Min Time'");
            this.jCheckBoxFixMinTime.setText("Fix too short frames");
            this.jCheckBoxFixMinTime.setMnemonic('s');
            this.jCheckBoxFixMinTime.setFocusable(false);
            this.jCheckBoxFixMinTime.setIconTextGap(10);
            this.jCheckBoxFixMinTime.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ConversionDialog.this.isReady) {
                        ConversionDialog.this.fixShortFrames = ConversionDialog.this.jCheckBoxFixMinTime.isSelected();
                        ConversionDialog.this.jTextFieldMinTime.setEnabled(ConversionDialog.this.fixShortFrames);
                    }
                }
            });
        }
        return this.jCheckBoxFixMinTime;
    }

    private JTextField getJTextFieldMinTime() {
        if (this.jTextFieldMinTime == null) {
            this.jTextFieldMinTime = new JTextField();
            this.jTextFieldMinTime.setEditable(true);
            this.jTextFieldMinTime.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldMinTime.setEnabled(false);
            this.jTextFieldMinTime.setToolTipText("Set minimum display time for a subtitle");
            this.jTextFieldMinTime.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s = ConversionDialog.this.jTextFieldMinTime.getText();
                        try {
                            ConversionDialog.this.minTimePTS = (int)Core.syncTimePTS((long)(Double.parseDouble(s) * 90.0), ConversionDialog.this.fpsTrg);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        ConversionDialog.this.jTextFieldMinTime.setBackground(ConversionDialog.this.okBgnd);
                        ConversionDialog.this.jTextFieldMinTime.setText(ToolBox.formatDouble((double)ConversionDialog.this.minTimePTS / 90.0));
                    }
                }
            });
            this.jTextFieldMinTime.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s = ConversionDialog.this.jTextFieldMinTime.getText();
                        try {
                            ConversionDialog.this.minTimePTS = (int)Core.syncTimePTS((long)(Double.parseDouble(s) * 90.0), ConversionDialog.this.fpsTrg);
                            if (!s.equalsIgnoreCase(ToolBox.formatDouble((double)ConversionDialog.this.minTimePTS / 90.0))) {
                                ConversionDialog.this.jTextFieldMinTime.setBackground(ConversionDialog.this.warnBgnd);
                            } else {
                                ConversionDialog.this.jTextFieldMinTime.setBackground(ConversionDialog.this.okBgnd);
                            }
                        }
                        catch (NumberFormatException ex) {
                            ConversionDialog.this.jTextFieldMinTime.setBackground(ConversionDialog.this.errBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldMinTime;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText("  Ok  ");
            this.jButtonOk.setMnemonic('o');
            this.jButtonOk.setToolTipText("Use current values and continue");
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s;
                        double d;
                        Core.setConvertFPS(ConversionDialog.this.changeFPS);
                        if (ConversionDialog.this.changeFPS && (d = Core.getFPS(s = (String)ConversionDialog.this.jComboBoxFPSSrc.getSelectedItem())) > 0.0) {
                            ConversionDialog.this.fpsSrc = d;
                            Core.setFPSSrc(ConversionDialog.this.fpsSrc);
                        }
                        if ((d = Core.getFPS(s = (String)ConversionDialog.this.jComboBoxFPSTrg.getSelectedItem())) > 0.0) {
                            ConversionDialog.this.fpsTrg = d;
                            Core.setFPSTrg(ConversionDialog.this.fpsTrg);
                        }
                        s = ConversionDialog.this.jTextFieldDelay.getText();
                        try {
                            ConversionDialog.this.delayPTS = (int)Core.syncTimePTS((long)(Double.parseDouble(s) * 90.0), ConversionDialog.this.fpsTrg);
                            Core.setDelayPTS(ConversionDialog.this.delayPTS);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        Core.setFixShortFrames(ConversionDialog.this.fixShortFrames);
                        s = ConversionDialog.this.jTextFieldMinTime.getText();
                        try {
                            ConversionDialog.this.minTimePTS = (int)Core.syncTimePTS((long)(Double.parseDouble(s) * 90.0), ConversionDialog.this.fpsTrg);
                            Core.setMinTimePTS(ConversionDialog.this.minTimePTS);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        Core.setConvertResolution(ConversionDialog.this.changeResolution);
                        if (ConversionDialog.this.changeResolution) {
                            Core.setOutputResolution(ConversionDialog.this.resolution);
                        }
                        if ((d = ToolBox.getDouble(s = ConversionDialog.this.jTextFieldScaleX.getText())) > 0.0) {
                            if (d > 2.0) {
                                d = 2.0;
                            } else if (d < 0.5) {
                                d = 0.5;
                            }
                            ConversionDialog.this.scaleX = d;
                        }
                        if ((d = ToolBox.getDouble(s = ConversionDialog.this.jTextFieldScaleY.getText())) > 0.0) {
                            if (d > 2.0) {
                                d = 2.0;
                            } else if (d < 0.5) {
                                d = 0.5;
                            }
                            ConversionDialog.this.scaleY = d;
                        }
                        Core.setApplyFreeScale(ConversionDialog.this.changeScale);
                        if (ConversionDialog.this.changeScale) {
                            Core.setFreeScale(ConversionDialog.this.scaleX, ConversionDialog.this.scaleY);
                        }
                        ConversionDialog.this.cancel = false;
                        Core.setForceAll(ConversionDialog.this.forcedState);
                        if (ConversionDialog.this.jCheckBoxMove.isEnabled()) {
                            Core.setMoveCaptions(ConversionDialog.this.moveCaptions);
                        }
                        ConversionDialog.this.dispose();
                    }
                }
            });
        }
        return this.jButtonOk;
    }

    private JTextField getJTextFieldScaleX() {
        if (this.jTextFieldScaleX == null) {
            this.jTextFieldScaleX = new JTextField();
            this.jTextFieldScaleX.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldScaleX.setToolTipText("Set free scaling factor in X direction");
            this.jTextFieldScaleX.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s = ConversionDialog.this.jTextFieldScaleX.getText();
                        double d = ToolBox.getDouble(s);
                        if (d > 0.0) {
                            if (d > 2.0) {
                                d = 2.0;
                            } else if (d < 0.5) {
                                d = 0.5;
                            }
                            ConversionDialog.this.scaleX = d;
                        }
                        ConversionDialog.this.jTextFieldScaleX.setText(ToolBox.formatDouble(ConversionDialog.this.scaleX));
                        ConversionDialog.this.jTextFieldScaleX.setBackground(ConversionDialog.this.okBgnd);
                    }
                }
            });
            this.jTextFieldScaleX.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s = ConversionDialog.this.jTextFieldScaleX.getText();
                        double d = ToolBox.getDouble(s);
                        if (d >= 0.5 && d <= 2.0) {
                            ConversionDialog.this.scaleX = d;
                            ConversionDialog.this.jTextFieldScaleX.setBackground(ConversionDialog.this.okBgnd);
                        } else {
                            ConversionDialog.this.jTextFieldScaleX.setBackground(ConversionDialog.this.errBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldScaleX;
    }

    private JTextField getJTextFieldScaleY() {
        if (this.jTextFieldScaleY == null) {
            this.jTextFieldScaleY = new JTextField();
            this.jTextFieldScaleY.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldScaleY.setToolTipText("Set free scaling factor in Y direction");
            this.jTextFieldScaleY.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s = ConversionDialog.this.jTextFieldScaleY.getText();
                        double d = ToolBox.getDouble(s);
                        if (d > 0.0) {
                            if (d > 2.0) {
                                d = 2.0;
                            } else if (d < 0.5) {
                                d = 0.5;
                            }
                            ConversionDialog.this.scaleY = d;
                        }
                        ConversionDialog.this.jTextFieldScaleY.setText(ToolBox.formatDouble(ConversionDialog.this.scaleY));
                    }
                }
            });
            this.jTextFieldScaleY.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (ConversionDialog.this.isReady) {
                        String s = ConversionDialog.this.jTextFieldScaleY.getText();
                        double d = ToolBox.getDouble(s);
                        if (d >= 0.5 && d <= 2.0) {
                            ConversionDialog.this.scaleY = d;
                            ConversionDialog.this.jTextFieldScaleY.setBackground(ConversionDialog.this.okBgnd);
                        } else {
                            ConversionDialog.this.jTextFieldScaleY.setBackground(ConversionDialog.this.errBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldScaleY;
    }

    private JComboBox getJComboBoxForced() {
        if (this.jComboBoxForced == null) {
            this.jComboBoxForced = new JComboBox();
            this.jComboBoxForced.setPreferredSize(new Dimension(200, 20));
            this.jComboBoxForced.setMinimumSize(new Dimension(150, 20));
            this.jComboBoxForced.setEditable(false);
            this.jComboBoxForced.setToolTipText("Select the target resolution");
            this.jComboBoxForced.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ConversionDialog.this.isReady) {
                        int idx = ConversionDialog.this.jComboBoxForced.getSelectedIndex();
                        Core.SetState[] setStateArray = Core.SetState.values();
                        int n = setStateArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Core.SetState s = setStateArray[n2];
                            if (idx == s.ordinal()) {
                                ConversionDialog.this.forcedState = s;
                                break;
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
        return this.jComboBoxForced;
    }

    public void enableOptionMove(boolean e) {
        this.jCheckBoxMove.setEnabled(e);
    }
}

