/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import deadbeef.SupTools.Core;
import deadbeef.SupTools.CoreException;
import deadbeef.Tools.Props;
import deadbeef.Tools.ToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ColorDialog
extends JDialog {
    static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel lblColor = null;
    private JScrollPane jScrollPane = null;
    private JList jList = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private JButton btnDefault = null;
    private JButton btnColor = null;
    private JButton jButtonSave = null;
    private JButton jButtonLoad = null;
    private ImageIcon[] cIcon;
    private Color[] cColor;
    private Color[] cColorDefault;
    private String[] cName;
    private String colorPath;
    private boolean canceled = true;
    private Component thisFrame = this;

    private void paintIcon(ImageIcon i, Color c) {
        Graphics g = i.getImage().getGraphics();
        g.setColor(c);
        g.setPaintMode();
        g.fillRect(0, 0, i.getIconWidth(), i.getIconHeight());
    }

    private void changeColor(int idx) {
        Color c = JColorChooser.showDialog(null, "Chose Input Color " + this.cName[idx], this.cColor[idx]);
        if (c != null) {
            this.cColor[idx] = c;
        }
        this.paintIcon(this.cIcon[idx], this.cColor[idx]);
        this.jList.repaint();
    }

    public void setParameters(String[] name, Color[] cCurrent, Color[] cDefault) {
        this.cName = name;
        this.cColorDefault = cDefault;
        this.cColor = new Color[this.cName.length];
        this.cIcon = new ImageIcon[this.cName.length];
        this.jList = new JList<String>(this.cName);
        this.jList.setSelectedIndex(0);
        this.jList.setSelectionMode(0);
        this.jList.setCellRenderer(new myListCellRenderer());
        int i = 0;
        while (i < this.cName.length) {
            this.cIcon[i] = new ImageIcon(new BufferedImage(12, 12, 1));
            this.cColor[i] = new Color(cCurrent[i].getRGB());
            this.paintIcon(this.cIcon[i], this.cColor[i]);
            ++i;
        }
        this.jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ColorDialog.this.changeColor(((JList)e.getSource()).locationToIndex(e.getPoint()));
                }
            }
        });
        this.jScrollPane.setViewportView(this.jList);
    }

    public Color[] getColors() {
        return this.cColor;
    }

    public ColorDialog(JFrame frame, boolean modal) {
        super((Frame)frame, modal);
        this.initialize();
        Point p = frame.getLocation();
        this.setLocation(p.x + frame.getWidth() / 2 - this.getWidth() / 2, p.y + frame.getHeight() / 2 - this.getHeight() / 2);
        this.setResizable(false);
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setSize(372, 231);
        this.setTitle("Choose Colors");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ColorDialog.this.cColor = ColorDialog.this.cColorDefault;
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblColor = new JLabel();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.lblColor.setText("Choose Color");
            this.lblColor.setBounds(15, 9, 73, 16);
            this.jContentPane.add((Component)this.lblColor, null);
            this.jContentPane.add((Component)this.getBtnOk(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.getBtnDefault(), null);
            this.jContentPane.add((Component)this.getJScrollPane(), null);
            this.jContentPane.add((Component)this.getBtnColor(), null);
            this.jContentPane.add((Component)this.getJButtonSave(), null);
            this.jContentPane.add((Component)this.getJButtonLoad(), null);
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(15, 30, 150, 152);
        }
        return this.jScrollPane;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setBounds(280, 162, 66, 20);
            this.btnOk.setText("OK");
            this.btnOk.setToolTipText("Apply changes and return");
            this.btnOk.setMnemonic('o');
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorDialog.this.canceled = false;
                    ColorDialog.this.dispose();
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setBounds(175, 161, 70, 20);
            this.btnCancel.setText("Cancel");
            this.btnCancel.setToolTipText("Lose changes and return");
            this.btnCancel.setMnemonic('c');
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorDialog.this.cColor = ColorDialog.this.cColorDefault;
                    ColorDialog.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnDefault() {
        if (this.btnDefault == null) {
            this.btnDefault = new JButton();
            this.btnDefault.setBounds(175, 60, 170, 20);
            this.btnDefault.setText("Restore default Colors");
            this.btnDefault.setToolTipText("Revert to default colors");
            this.btnDefault.setMnemonic('r');
            this.btnDefault.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < ColorDialog.this.cName.length) {
                        ((ColorDialog)ColorDialog.this).cColor[i] = new Color(ColorDialog.this.cColorDefault[i].getRGB());
                        ColorDialog.this.paintIcon(ColorDialog.this.cIcon[i], ColorDialog.this.cColor[i]);
                        ++i;
                    }
                    ColorDialog.this.jList.repaint();
                }
            });
        }
        return this.btnDefault;
    }

    private JButton getBtnColor() {
        if (this.btnColor == null) {
            this.btnColor = new JButton();
            this.btnColor.setBounds(175, 30, 170, 20);
            this.btnColor.setText("Change Color");
            this.btnColor.setToolTipText("Edit the selected color");
            this.btnColor.setMnemonic('h');
            this.btnColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int idx = ColorDialog.this.jList.getSelectedIndex();
                    ColorDialog.this.changeColor(idx);
                }
            });
        }
        return this.btnColor;
    }

    public String getPath() {
        return this.colorPath;
    }

    public void setPath(String p) {
        this.colorPath = p;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    private JButton getJButtonSave() {
        if (this.jButtonSave == null) {
            this.jButtonSave = new JButton();
            this.jButtonSave.setBounds(new Rectangle(175, 92, 170, 20));
            this.jButtonSave.setText("Save Palette");
            this.jButtonSave.setToolTipText("Save the current palette settings in an INI file");
            this.jButtonSave.setMnemonic('s');
            this.jButtonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block7: {
                        String fn;
                        String[] ext = new String[]{"ini"};
                        String p = ToolBox.getPathName(ColorDialog.this.colorPath);
                        String fname = ToolBox.getFileName(p, fn = ToolBox.getFileName(ColorDialog.this.colorPath), ext, false, ColorDialog.this.thisFrame);
                        if (fname != null) {
                            fname = String.valueOf(ToolBox.stripExtension(fname)) + ".ini";
                            File f = new File(fname);
                            try {
                                if (f.exists()) {
                                    if (f.exists() && !f.canWrite() || f.exists() && !f.canWrite()) {
                                        throw new CoreException("Target is write protected.");
                                    }
                                    if (JOptionPane.showConfirmDialog(ColorDialog.this.thisFrame, "Target exists! Overwrite?", "", 0) == 1) {
                                        throw new CoreException();
                                    }
                                }
                                ColorDialog.this.colorPath = fname;
                                Props colProps = new Props();
                                colProps.setHeader("COL - created by " + Core.getProgVerName());
                                int i = 0;
                                while (i < ColorDialog.this.cColor.length) {
                                    String s = ColorDialog.this.cColor[i].getRed() + "," + ColorDialog.this.cColor[i].getGreen() + "," + ColorDialog.this.cColor[i].getBlue();
                                    colProps.set("Color_" + i, s);
                                    ++i;
                                }
                                colProps.save(ColorDialog.this.colorPath);
                            }
                            catch (CoreException ex) {
                                if (ex.getMessage() == null) break block7;
                                JOptionPane.showMessageDialog(ColorDialog.this.thisFrame, ex.getMessage(), "Error!", 2);
                            }
                        }
                    }
                }
            });
        }
        return this.jButtonSave;
    }

    private JButton getJButtonLoad() {
        if (this.jButtonLoad == null) {
            this.jButtonLoad = new JButton();
            this.jButtonLoad.setBounds(new Rectangle(178, 126, 168, 18));
            this.jButtonLoad.setText("Load Palette");
            this.jButtonLoad.setToolTipText("Load palette settings from an INI file");
            this.jButtonLoad.setMnemonic('l');
            this.jButtonLoad.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block8: {
                        String fn;
                        String[] ext = new String[]{"ini"};
                        String p = ToolBox.getPathName(ColorDialog.this.colorPath);
                        String fname = ToolBox.getFileName(p, fn = ToolBox.getFileName(ColorDialog.this.colorPath), ext, true, ColorDialog.this.thisFrame);
                        if (fname != null) {
                            File f = new File(fname);
                            try {
                                if (f.exists()) {
                                    byte[] id = ToolBox.getFileID(fname, 4);
                                    if (id == null || id[0] != 35 || id[1] != 67 || id[2] != 79 || id[3] != 76) {
                                        JOptionPane.showMessageDialog(ColorDialog.this.thisFrame, "This is not a valid palette file", "Wrong format!", 2);
                                        throw new CoreException();
                                    }
                                } else {
                                    throw new CoreException("File not found.");
                                }
                                Props colProps = new Props();
                                colProps.load(fname);
                                ColorDialog.this.colorPath = fname;
                                int i = 0;
                                while (i < ColorDialog.this.cColor.length) {
                                    String s = colProps.get("Color_" + i, "0,0,0");
                                    String[] sp = s.split(",");
                                    if (sp.length >= 3) {
                                        int r = Integer.valueOf(ToolBox.trim(sp[0])) & 0xFF;
                                        int g = Integer.valueOf(ToolBox.trim(sp[1])) & 0xFF;
                                        int b = Integer.valueOf(ToolBox.trim(sp[2])) & 0xFF;
                                        ((ColorDialog)ColorDialog.this).cColor[i] = new Color(r, g, b);
                                        ColorDialog.this.paintIcon(ColorDialog.this.cIcon[i], ColorDialog.this.cColor[i]);
                                    }
                                    ++i;
                                }
                                ColorDialog.this.jList.repaint();
                            }
                            catch (CoreException ex) {
                                if (ex.getMessage() == null) break block8;
                                JOptionPane.showMessageDialog(ColorDialog.this.thisFrame, ex.getMessage(), "Error!", 2);
                            }
                        }
                    }
                }
            });
        }
        return this.jButtonLoad;
    }

    private class myListCellRenderer
    extends DefaultListCellRenderer {
        static final long serialVersionUID = 1L;

        private myListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(ColorDialog.this.cName[index]);
            this.setIcon(ColorDialog.this.cIcon[index]);
            return retValue;
        }
    }
}

